/************************************************
File : non_ascii_names.sql
Release : UB2.0.3
SIR     : 1683
Author : Ganesh Thadkamalla
Date :  04/27/2005
Description : Identifies and generates a report of display names with non-ASCII characters.

Comments :


*************************************************/

spool logs\non_ascii_names.log

Prompt Adding non-ASCII names to STORET.TSRCHDUP for review.
Prompt   
Prompt Pre statistics
select count(*) from storet.tsrchdup;
--
set serveroutput on size 100000
declare
  cursor ascii_name_cur is
  select tsn,itis_name,itis_name_ascii
  from itis.itistaxa
  where itis_name != itis_name_ascii;
begin
  for c_var in ascii_name_cur loop
     begin
       insert into storet.tsrchdup(tsn,itis_name,pref_display_name)
       values(c_var.tsn,c_var.itis_name,substr(c_var.itis_name_ascii,1,60));
     exception when others then
        dbms_output.put_line('Unable to insert into tsrchdup.  Data = '||c_var.tsn||'~'||c_var.itis_name);
     end;
  end loop;
  commit;
end;
/
show errors;

Prompt Post statistics
select count(*) from storet.tsrchdup;

spool off;

--Generating a text report file.
--set heading off
set echo off
set linesize 120
set trimspool on
set pagesize 1000
set feedback off

spool logs\rep_non_ascii_names.log
Prompt ITIS names with non-ASCII characters.  This list will be added to the STORET.TSRCHDUP for review.
select lpad(tsn,12,' ')||'    '||itis_name  "  TSN                ITIS_NAME"
from itis.itistaxa
where itis_name != itis_name_ascii;

spool off;
exit;