/************************************************
File : rep_chdup_data.sql
Release : UB2.0.3
SIR     : 1683
Author : Ganesh Thadkamalla
Date :  04/27/2005
Description : Reports data from STORET.TSRCHDUP table. 

Comments :


*************************************************/

set echo off
set pagesize 0
set linesize 500
set trimspool on
set heading on;
spool logs\rep_chdup_data.log

Prompt
Prompt Duplicate Names in ITIS Taxonomy extraction.
Prompt
Prompt TSN~ITIS_Name~Pref_Display_Name
select tsn||'~'||itis_name||'~'||pref_display_name
from storet.tsrchdup da
where exists (select 1 from storet.tsrchdup db
     where db.itis_name=da.itis_name
       and db.tsn != da.tsn)
order by itis_name,tsn;

Prompt   
Prompt ITIS_Names matching STORET's non-Taxon names.
Prompt
Prompt TSN~ITIS_Name~Pref_Display_Name
select tsn||'~'||itis_name||'~'||pref_display_name
from storet.tsrchdup da
where not exists (select 1 from storet.tsrchdup db
     where db.itis_name=da.itis_name
       and db.tsn != da.tsn)
and itis_name = pref_display_name
order by itis_name,tsn;

Prompt   
Prompt ITIS_Names with non-ASCII characters.
Prompt
Prompt TSN~ITIS_Name~Pref_Display_Name
select tsn||'~'||itis_name||'~'||pref_display_name
from storet.tsrchdup da
where not exists (select 1 from storet.tsrchdup db
     where db.itis_name=da.itis_name
       and db.tsn != da.tsn)
and itis_name != pref_display_name
order by itis_name,tsn;

spool off;

exit;