/************************************************
File : sir1625a.sql
Release : UB2.0.3
SIR     : 1625, 1683
Author : Ganesh Thadkamalla
Date :  04/27/2005
Description :  Updates STORET.TSRCHAR data with taxon information extracted from ITIS tables.

Comments :
	This scirpt is dependent on ITISparams.sql

*************************************************/

spool logs\sir1625a.log
set echo off
set time on
set timing on

show user;
set echo on
-- run ITISparams.sql for defining userid and buffer variables.
@scripts\ITISparams.sql

--pre update

prompt number of rows in storet.tsrchar table that match itis.itistaxa table.
select count(*) from storet.tsrchar c,
   itis.itistaxa ct
where ct.tsn= c.extrnl_serial_num;

prompt number of rows in storet.tsrchar table
select count(*) from storet.tsrchar;


--plsql block to update storet.tsrchar table.
ALTER ROLLBACK SEGMENT "RBSBIG" ONLINE;
set serveroutput on size 1000000
declare

lv_userid_code varchar2(8);
icounter number:=0;
lv_max_count number:=0;


--cursor for display_name variations.
cursor c_name is 
select ct.tsn, ct.display_name
from itis.itistaxa ct
where exists (select 'x' from storet.tsrchar c
           where c.extrnl_serial_num=ct.tsn
             and c.display_name !=ct.display_name);


BEGIN
  --read userid from variable.
  --lv_user:= upper('&gv_userid');
  select upper('&gv_userid') into lv_userid_code from dual;

  select ceil(max(serial_number)/10000)+2 into lv_max_count from itis.itistaxa;

  dbms_output.put_line('Number of updates = '||lv_max_count||'. Each update statement updates 10000 records.');

  for i in 1 .. lv_max_count loop
  commit;
  dbms_transaction.use_rollback_segment('RBSBIG');


--  dbms_output.put_line ('between '||(i-1)*10000||' and '||(i)*10000);
  execute immediate 'update storet.tsrchar c
    set (c.true_name_tsn,c.parent_tsn,c.taxon_sort_code,c.AUTHOR_DATE,
    c.status,c.TAXON_RANK_NAME,c.TAXON_RANK_code,c.d_last_update_Ts,c.D_USERID_CODE) = 
      (select a.true_name_tsn,a.parent_tsn,a.taxon_sort_code,
       substr(a.AUTHOR_DATE,1,45),a.status,substr(a.TAXON_RANK_NAME,1,12),
       a.TAXON_RANK_code,sysdate,'''||lv_userid_code||''' from itis.itistaxa a
        where a.tsn= c.extrnl_serial_num)
    where exists
       (select 1 from itis.itistaxa z
        where z.tsn=c.extrnl_serial_num
        and z.serial_number between '||(i-1)*10000||' and '||(i)*10000||')';

  commit;
  end loop;
commit;



-- processing extrnl_serial_num with modified display_name.
  -- reset icounter
  icounter:=0;
for cv_name in c_name loop
  update storet.tsrchar c
  set c.display_name = cv_name.display_name,
    c.search_name = upper(cv_name.display_name),
    d_last_update_Ts = sysdate
  where c.extrnl_serial_num=cv_name.tsn;

  icounter:=icounter+1;
  if icounter > 3000 then
    commit;
    dbms_transaction.use_rollback_segment('RBSBIG');
    icounter:=0;
  end if;
end loop;  -- end of c_name cursor loop.
  commit;
end;
/

--post DML
prompt number of rows in storet.tsrchar table that match itis.itistaxa table.
select count(*) from storet.tsrchar c,
   itis.itistaxa ct
where ct.tsn= c.extrnl_serial_num;

prompt number of rows in storet.tsrchar table
select count(*) from storet.tsrchar;


--disconnect
disconnect;
set echo off;
spool off;
exit
