/***********************************************************************
File :  	SIR1625d.sql	
Release :	
SIR : 		1625,1683
Author : 	Ganesh B. Thadkamalla
Date :   	8/17/2004
Description :  	Add new storet.tsrchals rows for ITIS Serial number for all the new ITIS rows in storet.tsrchar table.
 05/06/2005 - Edited for TIR #11.  Removed taxon_sort_code as a filter to identify the taxa. -GT



Comments : 	Run this after sir1625c.sql
 		This scirpt is dependent on ITISparams.sql
  
***********************************************************************/
--connect storet/storet
spool logs\sir1625d.log
set echo on
set time on
set timing on

show user

-- run ITISparams.sql for defining userid and buffer variables.
@scripts\ITISparams.sql

alter trigger storet.CHALS_AFT_ROW_ALL disable;
alter trigger storet.CHALS_AFT_STM_ALL disable;
alter trigger storet.CHALS_BEF_STM_ALL disable;

ALTER ROLLBACK SEGMENT "RBSBIG" ONLINE;

--pre DML
select count(*) from storet.tsrchals;

select tsrcalt_is_number||' - '||tsrcalt_org_id,count(*) from storet.tsrchals
group by tsrcalt_is_number||' - '||tsrcalt_org_id;

select d_scr_type_cd,count(*) from storet.tsrchar
where d_scr_type_cd in ('TAXA','VAR')
AND  uom_type = 'TAX'
group by d_scr_type_cd;

select max(tsrchals_is_number) from storet.tsrchals;
select max(d_last_update_ts) from storet.tsrchals;

select 'Number of records that will be inserted as ITIS serial number aliases.' from dual;

select count(*)
from storet.tsrchar c
where not exists (select 'x' from storet.tsrchals a
  where a.tsrcalt_is_number=&gv_calt_isn_ser_num
  AND A.tsrchar_is_number = c.tsrchar_is_number)
and c.d_scr_type_cd in ('TAXA','VAR')
AND C.UOM_TYPE = 'TAX';

SET serveroutput on
DECLARE

  lv_tsrchals_is_number storet.tsrchals.tsrchals_is_number%type;
  lv_commit_counter number:=0;
-- Cursor for reading all ITIS characteristics that do not have an ITIS serial num alias.
cursor c1 is
select c.tsrchar_is_number,c.extrnl_serial_num
from storet.tsrchar c
where not exists (select 'x' from storet.tsrchals a
  where a.tsrcalt_is_number=&gv_calt_isn_ser_num
  AND A.tsrchar_is_number = c.tsrchar_is_number)
and c.d_scr_type_cd in ('TAXA','VAR')
AND C.UOM_TYPE = 'TAX';

lv_userid storet.tsrchals.D_USERID_CODE%type;

BEGIN

  -- read defined variables in ITISparams.sql file.
  lv_userid := upper('&gv_userid');

  commit;
  dbms_transaction.use_rollback_segment('RBSBIG');
  select max(tsrchals_is_number) into lv_tsrchals_is_number from storet.tsrchals;

 -- process the cursor
for c1_var in c1 loop
 lv_tsrchals_is_number:=lv_tsrchals_is_number+1;
  insert into storet.tsrchals 
  (TSRCHAR_IS_NUMBER      ,
  TSRCHAR_ORG_ID         ,
  TSRCHALS_IS_NUMBER     ,
  TYPE_NAME              , -- NOT NULL
  NAME                   ,
  D_USERID_CODE          ,
  D_LAST_UPDATE_TS       ,
  TSRCALT_IS_NUMBER      ,
  TSRCALT_ORG_ID         ,
  SEARCH_NAME             )
 values
  (c1_var.TSRCHAR_IS_NUMBER      ,
  'ZZZZZZZZ',   				--c1_var.TSRCHAR_ORG_ID         ,
  lv_TSRCHALS_IS_NUMBER     ,
  'ITIS TAXON SERIAL NUMBER',  -- TYPE CODE NOT NULL COLUMN
  c1_var.extrnl_serial_num, 			--NAME                   ,
  lv_userid, 					--D_USERID_CODE          ,
  SYSDATE, 					--D_LAST_UPDATE_TS       ,
  &gv_calt_isn_ser_num, 	--TSRCALT_IS_NUMBER      ,
  'ZZZZZZZZ', 				--TSRCALT_ORG_ID         ,
  upper(c1_var.extrnl_serial_num)); 		--SEARCH_NAME             )
  
  lv_commit_counter:=lv_commit_counter+1;
  if lv_commit_counter > 2000 then
    commit;
    dbms_transaction.use_rollback_segment('RBSBIG');
    lv_commit_counter:=0;
  end if;
 end loop; 
  commit;
end;
/

-- enable triggers.
alter trigger storet.CHALS_AFT_ROW_ALL enable;
alter trigger storet.CHALS_AFT_STM_ALL enable;
alter trigger storet.CHALS_BEF_STM_ALL enable;

--post DML
select count(*) from storet.tsrchals;
select tsrcalt_is_number||' - '||tsrcalt_org_id,count(*) from storet.tsrchals
group by tsrcalt_is_number||' - '||tsrcalt_org_id;

select d_scr_type_cd,count(*) from storet.tsrchar
where d_scr_type_cd in ('TAXA','VAR')
AND  uom_type = 'TAX'
group by d_scr_type_cd;

select max(tsrchals_is_number) from storet.tsrchals;
select max(d_last_update_ts) from storet.tsrchals;

Prompt Number of Taxonomy characteristics without an ITIS serial number alias.
Prompt The following select should return 0 count.
select count(*)
from storet.tsrchar c
where not exists (select 'x' from storet.tsrchals a
  where a.tsrcalt_is_number=&gv_calt_isn_ser_num
  AND A.tsrchar_is_number = c.tsrchar_is_number)
and c.d_scr_type_cd in ('TAXA','VAR')
AND C.UOM_TYPE = 'TAX';

analyze table storet.tsrchals compute statistics;

Prompt TSMEISN table is udpated in sir1625e.sql script.

disconnect
spool off;
exit


