
/************************************************
File : taxon_sort_code
Release : UB2.0.3
SIR     : 1683
Author : Ganesh Thadkamalla
Date :  04/27/2005
Description : Generates taxon sort code for records in ITISTAXA table.

Comments :


*************************************************/
set heading off;
set echo off;

spool logs\taxon_sort_code.log
set serveroutput on
select 'Generating Taxon Sort Code for the entires in ITIS.ITISTAXA table.' from dual;

--pre stats
select 'Number of records in ITISTAXA table whose Taxon_sort_code is not null.' from dual;
select count(*) from itis.itistaxa
where taxon_sort_code is not null;

--DML


create index i_itistaxa_sn on itistaxa(serial_number)
tablespace itis_inds;

declare
cursor tsc_cursor is 
select serial_number,TAXON_RANK_CODE,status,parent_tsn
from itistaxa
order by serial_number;

lv_commit_ctr number:=0;
lv_parent_tsn itistaxa.parent_tsn%type :=null;
lv_child_cnt number:= null;

cursor errorinfo_cursor is
select tsn,parent_tsn,serial_number,taxon_rank_code,taxon_rank_name,itis_name 
  from itistaxa where tsn=lv_parent_tsn;

begin
  --sort_code_pkg.f_sort_code;
  for tsc_var in tsc_cursor loop
  IF tsc_var.status = 'A' THEN
    lv_parent_tsn:=tsc_var.parent_tsn;
    sort_code_pkg.reset_ranks(tsc_var.taxon_rank_code);
    sort_code_pkg.inc_rank(tsc_var.taxon_rank_code);
  ELSIF tsc_var.status='S' THEN
    NULL;
  END IF;

  update itistaxa m
  set taxon_sort_code = sort_code_pkg.f_sort_code(m.TAXON_RANK_CODE)
  where m.serial_number = tsc_var.serial_number;

  lv_commit_ctr:=lv_commit_ctr+1;
  if lv_commit_ctr > 1000  then 
    commit;
  end if;
  end loop;
commit;

exception when VALUE_ERROR then
  dbms_output.put_line ('Errors encountered in processing taxon_sort_code');
  dbms_output.put_line(sqlERRM);
  dbms_output.put_line ('May be too many children for the following taxonomy:');
  --  dbms_output.put_line ('TSN='||lv_parent_tsn);

  for ei_var in errorinfo_cursor loop
  dbms_output.put_line('TSN='||ei_var.tsn);
  dbms_output.put_line('Parent TSN='||ei_var.Parent_tsn);
  dbms_output.put_line('Serial Number='||ei_var.serial_number);
  dbms_output.put_line('Taxon_rank_code='||ei_var.Taxon_rank_code);
  dbms_output.put_line('Taxon_rank_name='||ei_var.Taxon_rank_name);
  dbms_output.put_line('ITIS_name='||ei_var.ITIS_name);
  dbms_output.put_line('----------------------------------------------');

  end loop;

WHEN OTHERS THEN
  dbms_output.put_line ('Errors encountered in processing taxon_sort_code');
  dbms_output.put_line(sqlERRM);

end;
/
show errors

--post stats

select 'Total count of ITISTAXA records.' from dual;
select count(*) from itis.itistaxa;

select 'Number of records in ITISTAXA table whose Taxon_sort_code is not null.' from dual;
select count(*) from itis.itistaxa
where taxon_sort_code is not null;

spool off;