/************************************************
File : updt_chdup.sql
Release : UB2.0.3
SIR     : 1683
Author : Ganesh Thadkamalla
Date :  04/27/2005
Description : Maintain STORET.TSRCHDUP table with extracted ITIS data. 

Comments :


*************************************************/

set echo off
set linesize 100
set trimspool on
set heading off;

spool logs\updt_chdup.log

-- delete non-duplicates in ITIS extract from tsrchdup.  These deletes could be made unique or they could be missing TSNs in ITIS extraction.

select 'Non-duplicate display names are removed from the STORET.TSRCHDUP table.' from dual;

delete from storet.tsrchdup sd
where not exists (select 1 from itis.dupl_names id
          where id.tsn = sd.tsn);

commit;

Prompt ITIS_name and Pref_display_names of STORET.TSRCHDUP are updated with modified ITIS names.
-- update tsrchdup records if ITIS_name is changed.
Update storet.tsrchdup sd
set (itis_name, pref_display_name) = (select itis_name, substr(rtrim(itis_name),1,60) 
                              from itis.dupl_names id
                              where id.tsn=sd.tsn)
where not exists (select 1 from itis.dupl_names id2
          where id2.tsn=sd.tsn
             and id2.itis_name = sd.itis_name);



-- insert any new duplicate itis_names into tsrchdup table.
select 'New records with duplicate names are added to STORET.TSRCHDUP table for review.' from dual;
insert into storet.tsrchdup (tsn,itis_name,pref_display_name)
select tsn,itis_name,substr(rtrim(itis_name),1,60)
from itis.dupl_names id
where not exists (select 1 from storet.tsrchdup sd
          where sd.tsn=id.tsn);
commit;
spool off;
exit;
