set define off verify off feedback off
whenever sqlerror exit sql.sqlcode rollback
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_050000 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2013.01.01'
,p_release=>'5.0.4.00.12'
,p_default_workspace_id=>3625332328987376
,p_default_application_id=>105
,p_default_owner=>'STORETDASH_APEX'
);
end;
/
prompt --application/set_environment
 
prompt APPLICATION 105 - STORETDASH_2016-02-20
--
-- Application Export:
--   Application:     105
--   Name:            STORETDASH_2016-02-20
--   Date and Time:   14:52 Friday June 29, 2018
--   Exported By:     ADMIN
--   Flashback:       0
--   Export Type:     Application Export
--   Version:         5.0.4.00.12
--   Instance ID:     69314666475274
--

-- Application Statistics:
--   Pages:                     14
--     Items:                  131
--     Computations:            42
--     Processes:                7
--     Regions:                114
--     Buttons:                 16
--     Dynamic Actions:          3
--   Shared Components:
--     Logic:
--       Items:                  1
--     Navigation:
--       Breadcrumbs:            3
--         Entries:             25
--       NavBar Entries:         1
--     Security:
--       Authentication:         4
--     User Interface:
--       Themes:                 2
--       Templates:
--         Page:                21
--         Region:              24
--         Label:               11
--         List:                29
--         Popup LOV:            2
--         Calendar:             3
--         Breadcrumb:           6
--         Button:               6
--         Report:              10
--     Globalization:
--     Reports:
--   Supporting Objects:  Included

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/ui_types
begin
null;
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_display_id=>nvl(wwv_flow_application_install.get_application_id,105)
,p_owner=>nvl(wwv_flow_application_install.get_schema,'STORETDASH_APEX')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'STORETDASH_2016-02-20')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'STORETDASH')
,p_page_view_logging=>'YES'
,p_page_protection_enabled_y_n=>'Y'
,p_checksum_salt_last_reset=>'20160220100405'
,p_bookmark_checksum_function=>'MD5'
,p_max_session_length_sec=>28800
,p_flow_language=>'en'
,p_flow_language_derived_from=>'FLOW_PRIMARY_LANGUAGE'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(37711154621483118)
,p_application_tab_set=>0
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=> nvl(wwv_flow_application_install.get_proxy,'')
,p_flow_version=>'release 1.0'
,p_flow_status=>'AVAILABLE_W_EDIT_LINK'
,p_flow_unavailable_text=>'This application is currently unavailable at this time.'
,p_exact_substitutions_only=>'Y'
,p_deep_linking=>'Y'
,p_runtime_api_usage=>'T:O:W'
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'P'
,p_csv_encoding=>'Y'
,p_auto_time_zone=>'N'
,p_last_updated_by=>'XJTURAKA'
,p_last_upd_yyyymmddhh24miss=>'20160220100405'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists
begin
null;
end;
/
prompt --application/shared_components/files
begin
null;
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(27667541927614328)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(27667578464614328)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(34159019718391934)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
);
end;
/
prompt --application/shared_components/security/authorizations
begin
null;
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(37711464586483118)
,p_icon_sequence=>10
,p_icon_subtext=>'Logout'
,p_icon_target=>'&LOGOUT_URL.'
,p_icon_image_alt=>'Logout'
,p_icon_height=>32
,p_icon_width=>32
,p_icon_height2=>24
,p_icon_width2=>24
,p_nav_entry_is_feedback_yn=>'N'
,p_icon_bar_disp_cond_type=>'CURRENT_LOOK_IS_1'
,p_cell_colspan=>1
);
end;
/
prompt --application/shared_components/logic/application_processes
begin
null;
end;
/
prompt --application/shared_components/logic/application_items
begin
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(35646321328778717)
,p_name=>'F102_X_BREADCRUMB'
,p_protection_level=>'N'
);
end;
/
prompt --application/shared_components/logic/application_computations
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/shared_components/user_interface/lovs
begin
null;
end;
/
prompt --application/shared_components/navigation/trees
begin
null;
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/comments
begin
null;
end;
/
prompt --application/shared_components/navigation/breadcrumbs/breadcrumb3
begin
wwv_flow_api.create_menu(
 p_id=>wwv_flow_api.id(35650446974005666)
,p_name=>'Breadcrumb3'
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(35652036631031064)
,p_parent_id=>0
,p_short_name=>'Dashboard'
,p_long_name=>'Dashboard'
,p_link=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::'
,p_page_id=>1
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(35652242519032794)
,p_parent_id=>wwv_flow_api.id(35652036631031064)
,p_short_name=>'Annual Data Submission by State'
,p_long_name=>'Annual Data Submission by State'
,p_link=>'f?p=&APP_ID.:3:&SESSION.::&DEBUG.:::'
,p_page_id=>3
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(35652449098034698)
,p_parent_id=>wwv_flow_api.id(35652242519032794)
,p_short_name=>'State Profile'
,p_long_name=>'State Profile'
,p_link=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.:::'
,p_page_id=>7
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(35652623256036643)
,p_parent_id=>wwv_flow_api.id(35652449098034698)
,p_short_name=>'Data Owners Contribution'
,p_long_name=>'Data Owners Contribution'
,p_link=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::'
,p_page_id=>9
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(37068134889435435)
,p_parent_id=>wwv_flow_api.id(37077044224215652)
,p_short_name=>'Tribal Profile'
,p_link=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.:::'
,p_page_id=>6
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(37068526263439440)
,p_parent_id=>wwv_flow_api.id(37068134889435435)
,p_short_name=>'Top 10 Substances for Past 5 Years By Tribe'
,p_link=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.:::'
,p_page_id=>14
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(37077044224215652)
,p_parent_id=>wwv_flow_api.id(35652036631031064)
,p_short_name=>'By Tribes'
,p_link=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::'
,p_page_id=>2
);
end;
/
prompt --application/shared_components/navigation/breadcrumbs/breadcrumb4
begin
wwv_flow_api.create_menu(
 p_id=>wwv_flow_api.id(35650549744006425)
,p_name=>'Breadcrumb4'
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(35653046113043297)
,p_parent_id=>0
,p_short_name=>'Dashboard'
,p_long_name=>'Dashboard'
,p_link=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::'
,p_page_id=>1
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(35653252346045091)
,p_parent_id=>wwv_flow_api.id(35653046113043297)
,p_short_name=>'State Profile'
,p_long_name=>'State Profile'
,p_link=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.:::'
,p_page_id=>7
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(35653425812046898)
,p_parent_id=>wwv_flow_api.id(35653252346045091)
,p_short_name=>'Data Owners Contribution'
,p_long_name=>'Data Owners Contribution'
,p_link=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::'
,p_page_id=>9
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(37069642153781590)
,p_parent_id=>wwv_flow_api.id(37077322658225726)
,p_short_name=>'Tribal Profile'
,p_link=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.:::'
,p_page_id=>6
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(37070024469789749)
,p_parent_id=>wwv_flow_api.id(37069642153781590)
,p_short_name=>'Top 10 Substances for Past 5 Years By Tribe'
,p_link=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.:::'
,p_page_id=>14
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(37077322658225726)
,p_parent_id=>wwv_flow_api.id(35653046113043297)
,p_short_name=>'By Tribes'
,p_link=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::'
,p_page_id=>2
);
end;
/
prompt --application/shared_components/navigation/breadcrumbs/breadcrumb
begin
wwv_flow_api.create_menu(
 p_id=>wwv_flow_api.id(37712576903483127)
,p_name=>' Breadcrumb'
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(27695392530030526)
,p_parent_id=>wwv_flow_api.id(37072145264932134)
,p_short_name=>'All Tribes'
,p_link=>'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:::'
,p_page_id=>11
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(27699604618557990)
,p_parent_id=>wwv_flow_api.id(35552927694122874)
,p_short_name=>'Top 10 within States'
,p_link=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.:::'
,p_page_id=>10
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(35510246936335256)
,p_parent_id=>wwv_flow_api.id(35552927694122874)
,p_short_name=>'Annual Data Submission by EPA Region'
,p_long_name=>'Annual Data Submission by EPA Region'
,p_link=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:::'
,p_page_id=>5
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(35538334432134728)
,p_parent_id=>wwv_flow_api.id(35552927694122874)
,p_short_name=>'Data Owners Contribution'
,p_long_name=>'Data Owners Contribution'
,p_link=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::'
,p_page_id=>9
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(35552927694122874)
,p_short_name=>'Dashboard'
,p_link=>'f?p=&FLOW_ID.:1:&SESSION.'
,p_page_id=>1
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(35556450946279259)
,p_parent_id=>wwv_flow_api.id(35552927694122874)
,p_short_name=>'Annual Data Submission by State'
,p_link=>'f?p=&APP_ID.:3:&SESSION.::&DEBUG.:::'
,p_page_id=>3
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(35621325073360620)
,p_parent_id=>wwv_flow_api.id(35552927694122874)
,p_short_name=>'State Profile'
,p_long_name=>'State Profile'
,p_link=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.:::'
,p_page_id=>7
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(36284333358795590)
,p_parent_id=>wwv_flow_api.id(35552927694122874)
,p_short_name=>'Data Owners Contribution by Tribes'
,p_long_name=>'Data Owners Contribution by Tribes'
,p_link=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:::'
,p_page_id=>12
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(37072145264932134)
,p_parent_id=>wwv_flow_api.id(35552927694122874)
,p_short_name=>'By Tribes'
,p_link=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::'
,p_page_id=>2
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(37074827076031687)
,p_parent_id=>wwv_flow_api.id(37072145264932134)
,p_short_name=>'Annual Data Submission by EPA Region'
,p_link=>'f?p=&APP_ID.:4:&SESSION.::&DEBUG.:::'
,p_page_id=>4
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(37075833287144797)
,p_parent_id=>wwv_flow_api.id(37072145264932134)
,p_short_name=>'Tribal Profile'
,p_link=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.:::'
,p_page_id=>6
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(37076222504149776)
,p_parent_id=>wwv_flow_api.id(37072145264932134)
,p_short_name=>'Top 10 Substances for Past 5 Years By Tribe'
,p_link=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.:::'
,p_page_id=>14
);
end;
/
prompt --application/shared_components/user_interface/templates/page
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(25944018426584686)
,p_theme_id=>101
,p_name=>'OneEPA wide-new template_old127'
,p_is_popup=>false
,p_inline_css=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'input[type="radio"]~label {',
'    display: inline-block;',
'    margin: 0 0 10px 5px;',
'}'))
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
' <!DOCTYPE html>',
'<!--[if IEMobile 7]><html class="iem7 no-js" lang="en" dir="ltr"><![endif]-->',
'<!--[if lt IE 7]><html class="lt-ie9 lt-ie8 lt-ie7 no-js" lang="en" dir="ltr"><![endif]-->',
'<!--[if (IE 7)&(!IEMobile)]><html class="lt-ie9 lt-ie8 no-js" lang="en" dir="ltr"><![endif]-->',
'<!--[if IE 8]><html class="lt-ie9 no-js" lang="en" dir="ltr"><![endif]-->',
'<!--[if (gt IE 8)|(gt IEMobile 7)]><!--> <html class="no-js not-oldie" lang="en" dir="ltr"> <!--<![endif]-->',
'<head>',
'',
' ',
'  <meta charset="utf-8" />',
'  <meta http-equiv="X-UA-Compatible" content="IE=edge" />',
'  <meta name="HandheldFriendly" content="true" />',
'  <link rel="shortcut icon" href="http://www2.epa.gov/sites/all/themes/epa/favicon.ico" type="image/vnd.microsoft.icon" />',
'  <meta name="MobileOptimized" content="width" />',
'  <meta http-equiv="cleartype" content="on" />',
'  <meta http-equiv="ImageToolbar" content="false" />',
'  <meta name="viewport" content="width=device-width" />',
'<!--googleon: all-->',
'  <meta name="DC.description" content="" />',
'  <meta name="DC.title" content="" />',
'  <title>#TITLE#</title>',
'<!--googleoff: snippet-->',
'  <meta name="keywords" content="" />',
'  <link rel="shortlink" href="" />',
'  <link rel="canonical" href="" />',
'  <meta name="DC.creator" content="" />',
'  <meta name="DC.language" content="en" />',
'  <meta name="DC.Subject.epachannel" content="" />',
'  <meta name="DC.type" content="" />',
'  <meta name="DC.date.created" content="" />',
'  <meta name="DC.date.modified" content="" />',
'<!--googleoff: all-->',
'  <link type="text/css" rel="stylesheet" href="http://www2.epa.gov/sites/all/libraries/template/s.css" media="all" />',
'  <!--[if lt IE 9]><link type="text/css" rel="stylesheet" href="http://www2.epa.gov/sites/all/themes/epa/css/ie.css" media="all" /><![endif]-->',
'  <link rel="alternate" type="application/atom+xml" title="EPA.gov News" href="http://yosemite.epa.gov/opa/admpress.nsf/RSSRecentNews" />',
'  <link rel="alternate" type="application/atom+xml" title="EPA.gov Headquarters Press Releases" href="http://yosemite.epa.gov/opa/admpress.nsf/RSSByLocation?open&amp;location=Headquarters" />',
'  <link rel="alternate" type="application/atom+xml" title="Greenversations, EPA''s Blog" href="http://blog.epa.gov/blog/feed/" />',
'  <!--[if lt IE 9]><script src="http://www2.epa.gov/sites/all/themes/epa/js/html5.js"></script><![endif]-->',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
' ',
'  <meta name="viewport" content="width=device-width,initial-scale=1.0,maximum-scale=1.0,user-scalable=0" />',
'',
'<style type="text/css">',
'table, th, td {',
'    border: 0 none;',
'}',
'',
'thead, tr:nth-of-type(2n), table.datatable tbody tr:nth-of-type(2n) {',
'    background: #fff;',
'}',
'',
'.button_field {',
'    height: 35px !important;',
'    width: 120px;',
'}',
'p{font-size:.8em;!important}',
'</style>',
'',
'</head>',
'<body class="html not-front not-logged-in no-sidebars node-type-page wide-template resource-directory" #ONLOAD#>',
'  <!-- Google Tag Manager -->',
'  <noscript><iframe src="//www.googletagmanager.com/ns.html?id=GTM-L8ZB" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>',
'  <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({''gtm.start'':new Date().getTime(),event:''gtm.js''});var f=d.getElementsByTagName(s)[0],j=d.createElement(s),dl=l!=''dataLayer''?''&l=''+l:'''';j.async=true;j.src=''//www.googletagmanager.com/gtm.js?id=''+'
||'i+dl;f.parentNode.insertBefore(j,f);})(window,document,''script'',''dataLayer'',''GTM-L8ZB'');</script>',
'  <!-- End Google Tag Manager -->',
'  <div class="skip-links"><a href="#main-content" class="skip-link element-invisible element-focusable">Jump to main content</a></div>',
'  <header class="masthead clearfix" role="banner">',
'    <img class="site-logo" src="http://www2.epa.gov/sites/all/themes/epa/logo.png" alt="" />',
'    <hgroup class="site-name-and-slogan">',
'      <h1 class="site-name"><a href="http://www2.epa.gov/" title="Go to the home page" rel="home"><span>US EPA</span></a></h1>',
'      <div class="site-slogan">United States Environmental Protection Agency</div>',
'    </hgroup>',
'    <form class="epa-search" method="get" action="http://search.epa.gov/epasearch/epasearch">',
'      <label class="element-hidden" for="search-box">Search</label>',
'      <input class="form-text" placeholder="Search EPA.gov" name="querytext" id="search-box" value=""/>',
'      <button class="epa-search-button" id="search-button" type="submit" title="Search">Search</button>',
'      <input type="hidden" name="fld" value="" />',
'      <input type="hidden" name="areaname" value="" />',
'      <input type="hidden" name="areacontacts" value="" />',
'      <input type="hidden" name="areasearchurl" value="" />',
'      <input type="hidden" name="typeofsearch" value="epa" />',
'      <input type="hidden" name="result_template" value="2col.ftl" />',
'      <input type="hidden" name="filter" value="sample4filt.hts" />',
'    </form>',
'  </header>',
'  <section id="main-content" class="main-content clearfix" lang="en" role="main" tabindex="-1">',
'',
'<div class="region-preface clearfix">',
'	<div id="block-pane-epa-web-area-connect" class="block block-pane contextual-links-region">',
'		<ul class="menu utility-menu">',
'		<li class="menu-item">',
'		<a class="menu-link contact-us" href="http://water.epa.gov/contactus.cfm">Contact Us</a>',
'		</li>',
'		<li id="share" class="menu-item">',
'		</ul>',
'	</div>',
'	<div id="block-views-hublinks-block" class="block block-views">',
'		<div class="view view-hublinks view-id-hublinks view-display-id-block view-dom-id-35e70be26ce213e7b8af7da8bb2d6205">',
'			<ul class="menu pipeline">',
'			<li class="menu-item">',
'			<span style="font-weight: bold;">STORET - Dashboard</span>',
'			</li>',
'			</ul>',
'		</div>',
'	</div>',
'</div>',
'<!--googleon: all-->',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!--googleoff: index-->',
'',
'<div class="main-column clearfix">',
'',
'<h2 class="breadcrumb-title">You are here:</h2>',
'',
'<p class="breadcrumb">',
'',
'<a href="http://www3.epa.gov/">EPA Home</a> ',
'»',
'<a href="http://water.epa.gov/">Water</a>',
'»',
'<a href="http://water.epa.gov/aboutow/owow/">Wetlands, Oceans, & Watersheds</a>',
'»',
'<a href="http://water.epa.gov/type/watersheds/monitoring/index.cfm">Monitoring and Assessing Water Quality</a>',
'»',
'<a href="http://www3.epa.gov/storet/index.html">STORET</a>',
'»',
'<a>Data Warehouse</a>',
'',
'#REGION_POSITION_08#',
'</p>',
'',
'#REGION_POSITION_07#',
'',
'<!--googleon: index-->',
'',
'#FORM_OPEN#',
'',
'#REGION_POSITION_01#',
'#GLOBAL_NOTIFICATION#',
'#NOTIFICATION_MESSAGE#',
'#SUCCESS_MESSAGE#     ',
'#BODY#',
'#REGION_POSITION_02#',
'#REGION_POSITION_04#',
'#REGION_POSITION_03#',
'',
'',
'',
'<p class="pagetop"><a href="#">Top of Page</a></p>',
'',
'<!--googleoff: index-->',
'',
'',
'</div>',
'',
'<!-- /content -->'))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</div>',
'<!--googleoff: all-->',
'    </div>',
'  </section>',
'  <nav class="nav simple-nav simple-main-nav" role="navigation">',
'    <h2 class="element-invisible">Main menu</h2>',
'    <ul class="menu" role="menu">',
'      <li class="menu-item" id="menu-learn" role="presentation"><a href="http://www2.epa.gov/learn-issues" title="Learn what you can do to protect the environment in your home, workplace, and community." class="menu-link" role="menuitem">Learn the Is'
||'sues</a></li>',
'      <li class="menu-item" id="menu-scitech" role="presentation"><a href="http://www2.epa.gov/science-and-technology" title="EPA&#039;s research mission is to conduct leading-edge research and foster the sound use of science and technology to fulfil'
||'l EPA&#039;s mission to protect human health and safeguard the natural environment." class="menu-link" role="menuitem">Science &amp; Technology</a></li>',
'      <li class="menu-item" id="menu-lawsregs" role="presentation"><a href="http://www2.epa.gov/laws-regulations" title="Laws written by Congress provide the authority for EPA to write regulations. Regulations explain the technical, operational, and '
||'legal details necessary to implement laws." class="menu-link" role="menuitem">Laws &amp; Regulations</a></li>',
'      <li class="menu-item" id="menu-about" role="presentation"><a href="http://www2.epa.gov/aboutepa" title="Learn more about: our mission and what we do, how we are organized, and our history." class="menu-link" role="menuitem">About EPA</a></li>',
'    </ul>',
'  </nav>',
'  <nav class="nav simple-nav simple-secondary-nav" role="navigation">',
'    <h2 class="element-invisible">Secondary menu</h2>',
'    <ul class="menu secondary-menu">',
'      <li class="menu-1569 menu-item"><a href="http://www.epa.gov/espanol/" title="Spanish" class="menu-link">Espa&ntilde;ol</a></li>',
'      <li class="menu-1571 menu-item"><a href="http://www2.epa.gov/languages/traditional-chinese" title="Traditional Chinese" class="menu-link">&#20013;&#25991;: &#32321;&#39636;&#29256;</a></li>',
'      <li class="menu-1573 menu-item"><a href="http://www2.epa.gov/languages/simplified-chinese" title="Simplified Chinese" class="menu-link">&#20013;&#25991;: &#31616;&#20307;&#29256;</a></li>',
'      <li class="menu-1575 menu-item"><a href="http://www2.epa.gov/languages/vietnamese" title="Vietnamese" class="menu-link">Ti&#7871;ng Vi&#7879;t</a></li>',
'      <li class="menu-1577 menu-item"><a href="http://www2.epa.gov/languages/korean" title="Korean" class="menu-link">&#54620;&#44397;&#50612;</a></li>',
'    </ul>',
'  </nav>',
'  <footer class="main-footer clearfix" role="contentinfo">',
'    <div class="region-footer">',
'      <div id="block-epa-core-footer" class="block block-epa-core">',
'        <div class="row cols-2">',
'          <div class="col size-2of5">',
'            <ul class="pipeline">',
'              <li><a href="http://www.epa.gov/">EPA Home</a></li>',
'              <li><a href="http://www2.epa.gov/home/privacy-and-security-notice">Privacy and Security Notice</a></li>',
'              <li><a href="http://www2.epa.gov/accessibility"',
'                  >Accessibility</a></li>',
'            </ul>',
'            <p class="last-updated">&PAGE_LAST_UPDATED_DATE.</p>',
'          </div>',
'          <div class="col size-3of5">',
'            <ul class="menu epa-menu">',
'              <li class="menu-item"><a class="menu-link epa-hotline" href="http://www2.epa.gov/home/epa-hotlines">Hotlines</a></li>',
'              <li class="menu-item"><a class="menu-link epa-news" href="http://www2.epa.gov/newsroom">News</a></li>',
'              <li class="menu-item"><a class="menu-link epa-blog" href="http://www2.epa.gov/aboutepa/greenversations">Blogs</a></li>',
'              <li class="menu-item"><a class="menu-link epa-apps" href="http://developer.epa.gov/category/apps/">Apps</a></li>',
'              <li class="menu-item"><a class="menu-link epa-widgets" href="http://developer.epa.gov/category/widgets/">Widgets</a></li>',
'            </ul>',
'            <div class="social-menu-wrapper">',
'              <div class="social-menu-title">Social sites:</div>',
'              <ul class="menu social-menu">',
'                <li class="menu-item"><a class="menu-link social-twitter" href="https://twitter.com/epa">Twitter</a></li>',
'                <li class="menu-item"><a class="menu-link social-facebook" href="https://www.facebook.com/EPA">Facebook</a></li>',
'                <li class="menu-item"><a class="menu-link social-youtube" href="http://www.youtube.com/user/USEPAgov">YouTube</a></li>',
'                <li class="menu-item"><a class="menu-link social-flickr" href="http://www.flickr.com/photos/usepagov">Flickr</a></li>',
'                <li class="menu-item"><a class="menu-link social-instagram" href="http://instagram.com/epagov">Instagram</a></li>',
'              </ul>',
'              <p class="social-menu-more"><a href="http://www2.epa.gov/home/social-media">More social media at&#160;EPA&#160;�</a></p>',
'            </div>',
'          </div>',
'        </div>',
'      </div>',
'    </div>',
'  </footer>',
' <script src="http://www2.epa.gov/sites/all/libraries/template/jquery.js"></script>',
'  <script src="http://www2.epa.gov/sites/all/libraries/template/js.js"></script>',
'  <script src="http://www2.epa.gov/sites/all/modules/custom/epa_core/js/alert.js"></script>',
'  <!--[if lt IE 9]><script src="http://www2.epa.gov/sites/all/themes/epa/js/ie.js"></script><![endif]-->',
'',
'',
'<script type="text/javascript" language="javascript">',
'  function jumpToBottom() {',
'        var scnHei;',
'',
'	if (self.innerHeight) // all except Explorer',
'	{',
'		scnHei = self.innerHeight;',
'	}',
'	else if (document.documentElement && document.documentElement.clientHeight)',
'		// Explorer 6 Strict Mode',
'	{',
'		scnHei = document.documentElement.clientHeight;',
'	}',
'	else if (document.body) // other Explorers',
'	{',
'		scnHei = document.body.clientHeight;',
'	}',
'     window.scrollTo(0,scnHei*10);',
' }',
' ',
'</script>',
'',
'<script type="text/javascript">',
'<!--',
'function resetSelectList(thisControl) {',
'  document.getElementById(thisControl).selectedIndex = 0;',
'}',
'-->',
'</script>',
'',
'',
'<script type="text/javascript" language="javascript">',
'apex.jQuery(function(){',
' apex.jQuery(''#htmldbIR_x1'').change(function(){',
'  gReport.navigate.paginate(''pgR_min_row=''+this.value+''max_rows=''+$v(''apexir_NUM_ROWS'')+''rows_fetched=''+$v(''apexir_NUM_ROWS''));',
' });',
'});',
' ',
'(function($){',
' ',
' $.htmldbIrPagination=function(options){',
'  var p=$.trim($(''#apexir_DATA_PANEL'').find(''td.pagination'').find(''span.fielddata'').text());',
'  var a=new Array();',
'  var n=new Array();',
'  a=p.split('' '');',
'  $.each(a,function(i,v){',
'   if(!isNaN(v)){',
'    n.push(v);',
'   }',
'  });',
'  switch(options){',
'   case ''first'':return n[0];',
'   case ''last'':return n[1];',
'   case ''max'':return n[2];',
'   default:return n;',
'  }',
' };',
' ',
' $.htmldbIrLastPageRow=function(){',
'  var lS=parseFloat($v(''apexir_NUM_ROWS''));',
'  var lQ=parseFloat($.htmldbIrPagination(''max''));',
'  var lN=Math.floor(lQ/lS);',
'  if(lS>1){lN=(lN*lS)+1;if(lN>lQ){lN=lN-lS}}else{return lQ;}',
'  return lN;',
' };',
' ',
' $.fn.htmldbIrPageSelect=function(){',
'  var lS=parseFloat($v(''apexir_NUM_ROWS''));',
'  var lQ=parseFloat($.htmldbIrPagination(''max''));',
'  var lN=Math.floor(lQ/lS);',
'  var lM=$.htmldbIrLastPageRow();',
'  var j=1;',
'  var l;',
'  if(lS==1){lN=lQ-1;}',
'  return this.each(function(i){',
'   $(this).empty();',
'   for(var i=0;i<=lN;i++){',
'    if(j+lS-1<=lQ){',
'     l=''Rows ''+j+'' - ''+(j+lS-1);',
'    }else{',
'     l=''Rows ''+j+'' - ''+lQ;',
'    }',
'    if(j<=lM){',
'     appendOpt(this,l,j);',
'    }',
'    j=j+lS;',
'   }',
'   $(this).val($.htmldbIrPagination(''first''));',
'  });',
' ',
'  function appendOpt(pThis,d,r){',
'   var o=createOpt(d,r);',
'   $(pThis).append(o);',
'   function createOpt(d,r){return $(''<option/>'',{html:d,value:r});}',
'  }',
' };',
' ',
'})(apex.jQuery);',
'</script>',
'',
'',
'</body>',
'</html>'))
,p_region_table_cattributes=>'width="100%" summary=""'
,p_theme_class_id=>8
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(31007705311538595)
,p_theme_id=>101
,p_name=>'OneEPA wide-new template'
,p_is_popup=>false
,p_inline_css=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'input[type="radio"]~label {',
'    display: inline-block;',
'    margin: 0 0 10px 5px;',
'}'))
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
' <!DOCTYPE html>',
'<!--[if IEMobile 7]><html class="iem7 no-js" lang="en" dir="ltr"><![endif]-->',
'<!--[if lt IE 7]><html class="lt-ie9 lt-ie8 lt-ie7 no-js" lang="en" dir="ltr"><![endif]-->',
'<!--[if (IE 7)&(!IEMobile)]><html class="lt-ie9 lt-ie8 no-js" lang="en" dir="ltr"><![endif]-->',
'<!--[if IE 8]><html class="lt-ie9 no-js" lang="en" dir="ltr"><![endif]-->',
'<!--[if (gt IE 8)|(gt IEMobile 7)]><!--> <html class="no-js not-oldie" lang="en" dir="ltr"> <!--<![endif]-->',
'<head>',
'',
' ',
'  <meta charset="utf-8" />',
'  <meta http-equiv="X-UA-Compatible" content="IE=edge" />',
'  <meta name="HandheldFriendly" content="true" />',
'  <link rel="shortcut icon" href="https://www.epa.gov/sites/all/themes/epa/favicon.ico" type="image/vnd.microsoft.icon" />',
'  <meta name="MobileOptimized" content="width" />',
'  <meta http-equiv="cleartype" content="on" />',
'  <meta http-equiv="ImageToolbar" content="false" />',
'  <meta name="viewport" content="width=device-width" />',
'<!--googleon: all-->',
'  <meta name="DC.description" content="" />',
'  <meta name="DC.title" content="" />',
'  <title>#TITLE#</title>',
'<!--googleoff: snippet-->',
'  <meta name="keywords" content="" />',
'  <link rel="shortlink" href="" />',
'  <link rel="canonical" href="" />',
'  <meta name="DC.creator" content="" />',
'  <meta name="DC.language" content="en" />',
'  <meta name="DC.Subject.epachannel" content="" />',
'  <meta name="DC.type" content="" />',
'  <meta name="DC.date.created" content="" />',
'  <meta name="DC.date.modified" content="" />',
'<!--googleoff: all-->',
'  <link type="text/css" rel="stylesheet" href="https://www.epa.gov/sites/all/libraries/template/s.css" media="all" />',
'  <!--[if lt IE 9]><link type="text/css" rel="stylesheet" href="https://www2.epa.gov/sites/all/themes/epa/css/ie.css" media="all" /><![endif]-->',
'  <link rel="alternate" type="application/atom+xml" title="EPA.gov News" href="http://yosemite.epa.gov/opa/admpress.nsf/RSSRecentNews" />',
'  <link rel="alternate" type="application/atom+xml" title="EPA.gov Headquarters Press Releases" href="http://yosemite.epa.gov/opa/admpress.nsf/RSSByLocation?open&amp;location=Headquarters" />',
'  <link rel="alternate" type="application/atom+xml" title="Greenversations, EPA''s Blog" href="http://blog.epa.gov/blog/feed/" />',
'  <!--[if lt IE 9]><script src="https://www.epa.gov/sites/all/themes/epa/js/html5.js"></script><![endif]-->',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
' ',
'  <meta name="viewport" content="width=device-width,initial-scale=1.0,maximum-scale=1.0,user-scalable=0" />',
'',
'<style type="text/css">',
'table, th, td {',
'    border: 0 none;',
'}',
'',
'thead, tr:nth-of-type(2n), table.datatable tbody tr:nth-of-type(2n) {',
'    background: #fff;',
'}',
'',
'.button_field {',
'    height: 35px !important;',
'    width: 120px;',
'}',
'p{font-size:.8em;!important}',
'</style>',
'',
'</head>',
'<body class="html not-front not-logged-in no-sidebars node-type-page wide-template resource-directory" #ONLOAD#>',
'  <!-- Google Tag Manager -->',
'  <noscript><iframe src="//www.googletagmanager.com/ns.html?id=GTM-L8ZB" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>',
'  <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({''gtm.start'':new Date().getTime(),event:''gtm.js''});var f=d.getElementsByTagName(s)[0],j=d.createElement(s),dl=l!=''dataLayer''?''&l=''+l:'''';j.async=true;j.src=''//www.googletagmanager.com/gtm.js?id=''+'
||'i+dl;f.parentNode.insertBefore(j,f);})(window,document,''script'',''dataLayer'',''GTM-L8ZB'');</script>',
'  <!-- End Google Tag Manager -->',
'  <div class="skip-links"><a href="#main-content" class="skip-link element-invisible element-focusable">Jump to main content</a></div>',
'  <header class="masthead clearfix" role="banner">',
'    <img class="site-logo" src="https://www.epa.gov/sites/all/themes/epa/logo.png" alt="" />',
'    <hgroup class="site-name-and-slogan">',
'      <h1 class="site-name"><a href="https://www.epa.gov/" title="Go to the home page" rel="home"><span>US EPA</span></a></h1>',
'      <div class="site-slogan">United States Environmental Protection Agency</div>',
'    </hgroup>',
'    <form class="epa-search" method="get" action="https://search.epa.gov/epasearch/epasearch">',
'      <label class="element-hidden" for="search-box">Search</label>',
'      <input class="form-text" placeholder="Search EPA.gov" name="querytext" id="search-box" value=""/>',
'      <button class="epa-search-button" id="search-button" type="submit" title="Search">Search</button>',
'      <input type="hidden" name="fld" value="" />',
'      <input type="hidden" name="areaname" value="" />',
'      <input type="hidden" name="areacontacts" value="" />',
'      <input type="hidden" name="areasearchurl" value="" />',
'      <input type="hidden" name="typeofsearch" value="epa" />',
'      <input type="hidden" name="result_template" value="2col.ftl" />',
'      <input type="hidden" name="filter" value="sample4filt.hts" />',
'    </form>',
'  </header>',
'  <section id="main-content" class="main-content clearfix" lang="en" role="main" tabindex="-1">',
'',
'<div class="region-preface clearfix">',
'	<div id="block-pane-epa-web-area-connect" class="block block-pane contextual-links-region">',
'		<ul class="menu utility-menu">',
'		<li class="menu-item">',
'		<a class="menu-link contact-us" href="https://water.epa.gov/contactus.cfm">Contact Us</a>',
'		</li>',
'		<li id="share" class="menu-item">',
'		</ul>',
'	</div>',
'	<div id="block-views-hublinks-block" class="block block-views">',
'		<div class="view view-hublinks view-id-hublinks view-display-id-block view-dom-id-35e70be26ce213e7b8af7da8bb2d6205">',
'			<ul class="menu pipeline">',
'			<li class="menu-item">',
'			<span style="font-weight: bold;">STORET - Dashboard</span>',
'			</li>',
'			</ul>',
'		</div>',
'	</div>',
'</div>',
'<!--googleon: all-->',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!--googleoff: index-->',
'',
'<div class="main-column clearfix">',
'',
'<h2 class="breadcrumb-title">You are here:</h2>',
'',
'<p class="breadcrumb">',
'',
'<a href="https://www.epa.gov/">EPA Home</a> ',
'»',
'<a href="https://water.epa.gov/">Water</a>',
'»',
'<a href="https://water.epa.gov/aboutow/owow/">Wetlands, Oceans, & Watersheds</a>',
'»',
'<a href="https://water.epa.gov/type/watersheds/monitoring/index.cfm">Monitoring and Assessing Water Quality</a>',
'»',
'<a href="http://www.epa.gov/waterdata/storage-and-retrieval-and-water-quality-exchange">STORET</a>',
'»',
'<a>Data Warehouse</a>',
'',
'#REGION_POSITION_08#',
'</p>',
'',
'#REGION_POSITION_07#',
'',
'<!--googleon: index-->',
'',
'#FORM_OPEN#',
'',
'#REGION_POSITION_01#',
'#GLOBAL_NOTIFICATION#',
'#NOTIFICATION_MESSAGE#',
'#SUCCESS_MESSAGE#     ',
'#BODY#',
'#REGION_POSITION_02#',
'#REGION_POSITION_04#',
'#REGION_POSITION_03#',
'',
'',
'',
'<p class="pagetop"><a href="#">Top of Page</a></p>',
'',
'<!--googleoff: index-->',
'',
'',
'</div>',
'',
'<!-- /content -->'))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</div>',
'<!--googleoff: all-->',
'    </div>',
'  </section>',
'  <nav class="nav simple-nav simple-main-nav" role="navigation">',
'    <h2 class="element-invisible">Main menu</h2>',
'    <ul class="menu" role="menu">',
'      <li class="menu-item" id="menu-learn" role="presentation"><a href="https://www.epa.gov/learn-issues" title="Learn what you can do to protect the environment in your home, workplace, and community." class="menu-link" role="menuitem">Learn the Is'
||'sues</a></li>',
'      <li class="menu-item" id="menu-scitech" role="presentation"><a href="https://www.epa.gov/science-and-technology" title="EPA&#039;s research mission is to conduct leading-edge research and foster the sound use of science and technology to fulfil'
||'l EPA&#039;s mission to protect human health and safeguard the natural environment." class="menu-link" role="menuitem">Science &amp; Technology</a></li>',
'      <li class="menu-item" id="menu-lawsregs" role="presentation"><a href="https://www.epa.gov/laws-regulations" title="Laws written by Congress provide the authority for EPA to write regulations. Regulations explain the technical, operational, and '
||'legal details necessary to implement laws." class="menu-link" role="menuitem">Laws &amp; Regulations</a></li>',
'      <li class="menu-item" id="menu-about" role="presentation"><a href="https://www.epa.gov/aboutepa" title="Learn more about: our mission and what we do, how we are organized, and our history." class="menu-link" role="menuitem">About EPA</a></li>',
'    </ul>',
'  </nav>',
'  <nav class="nav simple-nav simple-secondary-nav" role="navigation">',
'    <h2 class="element-invisible">Secondary menu</h2>',
'    <ul class="menu secondary-menu">',
'      <li class="menu-1569 menu-item"><a href="https://www.epa.gov/espanol/" title="Spanish" class="menu-link">Espa&ntilde;ol</a></li>',
'      <li class="menu-1571 menu-item"><a href="https://www.epa.gov/languages/traditional-chinese" title="Traditional Chinese" class="menu-link">&#20013;&#25991;: &#32321;&#39636;&#29256;</a></li>',
'      <li class="menu-1573 menu-item"><a href="https://www.epa.gov/languages/simplified-chinese" title="Simplified Chinese" class="menu-link">&#20013;&#25991;: &#31616;&#20307;&#29256;</a></li>',
'      <li class="menu-1575 menu-item"><a href="https://www.epa.gov/languages/vietnamese" title="Vietnamese" class="menu-link">Ti&#7871;ng Vi&#7879;t</a></li>',
'      <li class="menu-1577 menu-item"><a href="https://www.epa.gov/languages/korean" title="Korean" class="menu-link">&#54620;&#44397;&#50612;</a></li>',
'    </ul>',
'  </nav>',
'  <footer class="main-footer clearfix" role="contentinfo">',
'    <div class="region-footer">',
'      <div id="block-epa-core-footer" class="block block-epa-core">',
'        <div class="row cols-2">',
'          <div class="col size-2of5">',
'            <ul class="pipeline">',
'              <li><a href="https://www.epa.gov/">EPA Home</a></li>',
'              <li><a href="https://www.epa.gov/home/privacy-and-security-notice">Privacy and Security Notice</a></li>',
'              <li><a href="https://www.epa.gov/accessibility"',
'                  >Accessibility</a></li>',
'            </ul>',
'            <p class="last-updated">&PAGE_LAST_UPDATED_DATE.</p>',
'          </div>',
'          <div class="col size-3of5">',
'            <ul class="menu epa-menu">',
'              <li class="menu-item"><a class="menu-link epa-hotline" href="https://www.epa.gov/home/epa-hotlines">Hotlines</a></li>',
'              <li class="menu-item"><a class="menu-link epa-news" href="https://www.epa.gov/newsroom">News</a></li>',
'              <li class="menu-item"><a class="menu-link epa-blog" href="https://www.epa.gov/aboutepa/greenversations">Blogs</a></li>',
'              <li class="menu-item"><a class="menu-link epa-apps" href="http://developer.epa.gov/category/apps/">Apps</a></li>',
'              <li class="menu-item"><a class="menu-link epa-widgets" href="http://developer.epa.gov/category/widgets/">Widgets</a></li>',
'            </ul>',
'            <div class="social-menu-wrapper">',
'              <div class="social-menu-title">Social sites:</div>',
'              <ul class="menu social-menu">',
'                <li class="menu-item"><a class="menu-link social-twitter" href="https://twitter.com/epa">Twitter</a></li>',
'                <li class="menu-item"><a class="menu-link social-facebook" href="https://www.facebook.com/EPA">Facebook</a></li>',
'                <li class="menu-item"><a class="menu-link social-youtube" href="http://www.youtube.com/user/USEPAgov">YouTube</a></li>',
'                <li class="menu-item"><a class="menu-link social-flickr" href="http://www.flickr.com/photos/usepagov">Flickr</a></li>',
'                <li class="menu-item"><a class="menu-link social-instagram" href="http://instagram.com/epagov">Instagram</a></li>',
'              </ul>',
'              <p class="social-menu-more"><a href="https://www.epa.gov/home/social-media">More social media at&#160;EPA&#160;�</a></p>',
'            </div>',
'          </div>',
'        </div>',
'      </div>',
'    </div>',
'  </footer>',
' <script src="https://www.epa.gov/sites/all/libraries/template/jquery.js"></script>',
'  <script src="https://www.epa.gov/sites/all/libraries/template/js.js"></script>',
'  <script src="https://www.epa.gov/sites/all/modules/custom/epa_core/js/alert.js"></script>',
'  <!--[if lt IE 9]><script src="https://www.epa.gov/sites/all/themes/epa/js/ie.js"></script><![endif]-->',
'',
'',
'<script type="text/javascript" language="javascript">',
'  function jumpToBottom() {',
'        var scnHei;',
'',
'	if (self.innerHeight) // all except Explorer',
'	{',
'		scnHei = self.innerHeight;',
'	}',
'	else if (document.documentElement && document.documentElement.clientHeight)',
'		// Explorer 6 Strict Mode',
'	{',
'		scnHei = document.documentElement.clientHeight;',
'	}',
'	else if (document.body) // other Explorers',
'	{',
'		scnHei = document.body.clientHeight;',
'	}',
'     window.scrollTo(0,scnHei*10);',
' }',
' ',
'</script>',
'',
'<script type="text/javascript">',
'<!--',
'function resetSelectList(thisControl) {',
'  document.getElementById(thisControl).selectedIndex = 0;',
'}',
'-->',
'</script>',
'',
'',
'<script type="text/javascript" language="javascript">',
'apex.jQuery(function(){',
' apex.jQuery(''#htmldbIR_x1'').change(function(){',
'  gReport.navigate.paginate(''pgR_min_row=''+this.value+''max_rows=''+$v(''apexir_NUM_ROWS'')+''rows_fetched=''+$v(''apexir_NUM_ROWS''));',
' });',
'});',
' ',
'(function($){',
' ',
' $.htmldbIrPagination=function(options){',
'  var p=$.trim($(''#apexir_DATA_PANEL'').find(''td.pagination'').find(''span.fielddata'').text());',
'  var a=new Array();',
'  var n=new Array();',
'  a=p.split('' '');',
'  $.each(a,function(i,v){',
'   if(!isNaN(v)){',
'    n.push(v);',
'   }',
'  });',
'  switch(options){',
'   case ''first'':return n[0];',
'   case ''last'':return n[1];',
'   case ''max'':return n[2];',
'   default:return n;',
'  }',
' };',
' ',
' $.htmldbIrLastPageRow=function(){',
'  var lS=parseFloat($v(''apexir_NUM_ROWS''));',
'  var lQ=parseFloat($.htmldbIrPagination(''max''));',
'  var lN=Math.floor(lQ/lS);',
'  if(lS>1){lN=(lN*lS)+1;if(lN>lQ){lN=lN-lS}}else{return lQ;}',
'  return lN;',
' };',
' ',
' $.fn.htmldbIrPageSelect=function(){',
'  var lS=parseFloat($v(''apexir_NUM_ROWS''));',
'  var lQ=parseFloat($.htmldbIrPagination(''max''));',
'  var lN=Math.floor(lQ/lS);',
'  var lM=$.htmldbIrLastPageRow();',
'  var j=1;',
'  var l;',
'  if(lS==1){lN=lQ-1;}',
'  return this.each(function(i){',
'   $(this).empty();',
'   for(var i=0;i<=lN;i++){',
'    if(j+lS-1<=lQ){',
'     l=''Rows ''+j+'' - ''+(j+lS-1);',
'    }else{',
'     l=''Rows ''+j+'' - ''+lQ;',
'    }',
'    if(j<=lM){',
'     appendOpt(this,l,j);',
'    }',
'    j=j+lS;',
'   }',
'   $(this).val($.htmldbIrPagination(''first''));',
'  });',
' ',
'  function appendOpt(pThis,d,r){',
'   var o=createOpt(d,r);',
'   $(pThis).append(o);',
'   function createOpt(d,r){return $(''<option/>'',{html:d,value:r});}',
'  }',
' };',
' ',
'})(apex.jQuery);',
'</script>',
'',
'',
'</body>',
'</html>'))
,p_region_table_cattributes=>'width="100%" summary=""'
,p_theme_class_id=>8
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
);
end;
/
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(35508444644856193)
,p_theme_id=>101
,p_name=>'Blank'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<head>',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'<title>#TITLE#</title>',
'</head>',
'<body #ONLOAD#>#FORM_OPEN#<a name="PAGETOP"></a>'))
,p_box=>'#BODY#'
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#<a name="END"></a>#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_theme_class_id=>8
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(36989448962556229)
,p_theme_id=>101
,p_name=>'basic wide-tribal'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="en">',
'<!-- EPA Template, OneEPA Web, 17 November 2010 -->',
'<head>',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'<meta charset="utf-8" />',
'<meta http-equiv="X-UA-Compatible" content="IE=8" />',
'<title>#TITLE#</title>',
'<meta name="DC.description" content="" />',
'<meta name="keywords" content="" />',
'<meta name="DC.title" content="" />',
'<meta name="DC.type" content="" />',
'<meta name="DC.Subject.epachannel" content="" />',
'<meta name="DC.Subject.epabrm" content="" />',
'<meta name="DC.Subject.epacat" content="" />',
'<meta name="DC.Subject.epaect" content="" />',
'<meta name="DC.Subject.epaemt" content="" />',
'',
'<meta name="DC.Subject.epahealth" content="" />',
'<meta name="DC.Subject.epaindustry" content="" />',
'<meta name="DC.Subject.epaopt" content="" />',
'<meta name="DC.Subject.epappt" content="" />',
'<meta name="DC.Subject.eparat" content="" />',
'<meta name="DC.Subject.eparegulation" content="" />',
'<meta name="DC.Subject.eparit" content="" />',
'<meta name="DC.Subject.epasubstance" content="" />',
'<meta name="DC.audience" content="" />',
'<meta name="DC.coverage" content="" />',
'<meta name="DC.date.created" content="" />',
'<meta name="DC.date.modified" content="" />',
'<meta name="DC.date.archivedate" content="" />',
'<meta name="DC.creator" content="US EPA" />',
'<meta name="DC.language" content="en" />',
'<meta name="viewport" content="width=device-width; initial-scale=1.0"/>',
'',
'<link rel="schema.DC" href="http://purl.org/dc/elements/1.1/" />',
'<!--RSS Feeds -->',
'<link rel="meta" href="http://www.epa.gov/labels.rdf" type="application/rdf+xml" title="ICRA labels" />',
'<link rel="alternate" type="application/atom+xml" title="EPA.gov News" href="http://yosemite.epa.gov/opa/admpress.nsf/RSSRecentNews" />',
'<link rel="alternate" type="application/atom+xml" title="EPA.gov Headquarters Press Releases" href="http://yosemite.epa.gov/opa/admpress.nsf/RSSByLocation?open&location=Headquarters" />',
'<link rel="alternate" type="application/atom+xml" title="Greenversations, EPA''s Blog" href="http://blog.epa.gov/blog/feed/" />',
'',
'<!-- ALL PAGE STYLES BELOW THIS LINE -->',
'<link rel="stylesheet" href="#WORKSPACE_IMAGES#template4_fix.css" type="text/css" />',
'<!--link rel="stylesheet" href="css/local.css" /-->',
'<link rel="stylesheet" href="#WORKSPACE_IMAGES#epa.css" />',
'<!--[if IE 7]><link rel="stylesheet" href="#WORKSPACE_IMAGES#ie7.css"/><![endif]-->',
'<!--[if lt IE 7]><link rel="stylesheet" href="#WORKSPACE_IMAGES#ie6.css"/><![endif]-->',
'',
'<style type="text/css"> ',
'div.left_box{float:left;width:65%;position:relative;padding-right:1%;}',
'div.right_box{float:right;width:30%;position:relative;}',
'div.box_wrapper{width:100%;position:relative;}',
'ul.dhtmlSubMenu{z-index:9999;}',
'.multi_selectlist{display:block;border:1px solid #ddd;padding:5px;}',
'.multi_selectlist:focus{border:1px solid #666;}',
'.text_field{display:block;border:1px solid #ddd;padding:5px;}',
'.text_field:focus{border:1px solid #666;}',
'.button_field{display:block;background:#369;border:#ddd;color:#fff;cursor:pointer;font-weight:bold;margin:10px 0;padding:5px;width:120px;}',
'.button_field_auto{display:block;background:#369;border:#ddd;color:#fff;cursor:pointer;font-weight:bold;margin:10px 0;padding:5px;width:auto;}',
'</style>',
'',
'</head>',
'<body class="basic wide" #ONLOAD#>'))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!--googleoff: index-->',
'<p id="sitewidec"></p>',
'<p class="skip">Jump to <a href="#main" title="Jump to main content">main content</a> or <a href="#areanav" title="Jump to area navigation.">area navigation</a>.</p>',
'',
'<div id="header">',
'  <p><a href="http://www.epa.gov/" title="US EPA Home Page"><img src="https://ofmpub.epa.gov/WATERSHTML/oneepa/print-epa-logo.gif" alt="US Environmental Protection Agency logo" /></a></p>',
'  <form id="EPAsearch" method="get" action="http://nlquery.epa.gov/epasearch/epasearch">',
'    <fieldset>',
'      <ol>',
'        <li id="azindex"><a href="http://www.epa.gov/epahome/quickfinder.htm" title="Alphabetical list of top EPA topics">A-Z Index</a></li>',
'        <li><a href="http://www.epa.gov/search.html" title="Advanced search with additional filters">Advanced Search</a></li>',
'        <li>',
'',
'          <fieldset id="search">',
'            <legend>What are you looking for?</legend>',
'            <input name="querytext" id="searchbox" value=""/>',
'            <button id="searchbutton" type="submit" title="Search">Search</button>',
'          </fieldset>',
'        </li>',
'      </ol>',
'      <input type="hidden" name="fld" value="" />',
'',
'      <input type="hidden" name="areaname" value="" />',
'      <input type="hidden" name="areacontacts" value="" />',
'      <input type="hidden" name="areasearchurl" value="" />',
'      <input type="hidden" name="typeofsearch" value="epa" />',
'      <input type="hidden" name="result_template" value="epafiles_default.xsl" />',
'      <input type="hidden" name="filter" value="sample4filt.hts" />',
'    </fieldset>',
'  </form><!-- /search -->',
'  <ul>',
'',
'    <li id="learn"><a href="http://www.epa.gov/gateway/learn/" title="Learn the Issues">Learn the Issues</a></li>',
'    <li id="scitech"><a href="http://www.epa.gov/gateway/science/" title="Science and Technology">Science &amp; Technology</a></li>',
'    <li id="laws"><a href="http://www.epa.gov/lawsregs/" title="Laws and Regulations">Laws &amp; Regulations</a></li>',
'    <li id="about"><a href="http://www.epa.gov/aboutepa/" title="About EPA">About EPA</a></li>',
'  </ul><!-- /IA Buckets -->',
'',
'</div><!-- /header -->',
'<div id="content">',
'  <div id="area">',
'    <p><a href="http://www.epa.gov/storet/contact.html">Contact Us</a></p>',
'<p>STORET - #TITLE#</p>',
'   <!-- <p>STORET</p>-->',
'',
'  </div>',
'',
'',
'',
'<!-- /area -->',
'',
'',
'  <div id="page">',
'    <div id="main">',
'      <ul id="breadcrumbs">',
'',
'        <li class="first"><b>You are here:</b> <a href="http://www.epa.gov/">EPA Home</a></li>',
'       <li><a href="http://www.epa.gov/water/">Water</a></li>',
'       <li><a href="http://www.epa.gov/owow/">Wetlands, Oceans, & Watersheds</a></li>',
'       <li><a href="http://www.epa.gov/owow/monitoring/">Monitoring and Assessing Water Quality</a></li>',
'       <li><a href="http://www.epa.gov/storet/index.html">STORET</a></li>',
'        <li>Data Warehouse</li>',
'      </ul>',
'<!--googleon: index-->',
'',
'',
'#REGION_POSITION_06# ',
'',
'',
'#FORM_OPEN#',
'',
'<div style="font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 10px; width: 120px; text-align: center;float:right;"><a href="http://www.epa.gov/indian" target="_blank"><img src="http://www.epa.gov/indian/images/turtlelink.jpg" alt="Link t'
||'o AIEO Tribal Portal "><br/>AIEO Tribal Portal</a> </div> ',
'#REGION_POSITION_01# <br><br>',
'',
'',
'',
'<table width="100%" summary="" height="70%" cellspacing="0" cellpadding="0" border="0">',
'  <tr>',
'',
'    <td>',
'    <div align="center">',
'      #GLOBAL_NOTIFICATION##NOTIFICATION_MESSAGE##SUCCESS_MESSAGE#     ',
'    </div>',
'    #BODY##REGION_POSITION_02##REGION_POSITION_04#',
'    </td>',
'    <td align="right" valign="top">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" width="15" height="3" alt="" />',
'    </td>',
'    <td class="t15RightBar" align="right" valign="top">',
'      #REGION_POSITION_03#',
'    </td>',
'  </tr>',
'</table>',
'',
'',
'			<p class="pagetop"><a href="#content">Top of Page</a></p>',
'<!--googleoff: index-->',
'    </div><!-- /main -->',
'',
'    <div id="areanav">',
'      <h4 class="skip">Area Navigation</h4>',
'      <ul>',
'        <li class="separator"><a href="#">Area Home</a><hr /></li>',
'        <li><a href="#">Subarea Home</a></li>',
'        <li><a href="#">Basic Information</a></li>',
'        <li><a href="#">Where You Live</a></li>',
'',
'        <li><a href="#">Recent Additions</a></li>',
'        <li><a href="#">Area sidebar links go here</a></li>',
'        <li><a href="#">Link #7</a></li>',
'        <li><a href="#">Link #8</a></li>',
'      </ul>',
'    </div><!-- /area-nav -->',
'  </div><!-- /page -->',
'',
'</div><!-- /content -->'))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'<div id="footer">',
'  <ul id="goodies">',
'    <li id="rss-news"><a href="http://www.epa.gov/newsroom/rssfeeds.htm">News Feeds</a></li>',
'    <li id="podcasts"><a href="http://www.epa.gov/epahome/podcasts.htm">Podcasts</a></li>',
'    <li id="mobile"><a href="http://m.epa.gov/">EPA Mobile</a></li>',
'    <li id="email-news"><a href="http://www.epa.gov/newsroom/email_signups.htm">News by Email</a></li>',
'    <li id="widgets"><a href="http://www.epa.gov/widgets/">Widgets</a></li>',
'',
'  </ul>',
'  <ul id="globalfooter">',
'    <li><a href="http://www.epa.gov/">EPA Home</a></li>',
'    <li><a href="http://www.epa.gov/epahome/usenotice.htm">Privacy and Security Notice</a></li>',
'    <li class="last"><a href="http://www.epa.gov/epahome/comments.htm">Contact Us</a></li>',
'  </ul>',
'  <p id="seal">The Seal of the United States Environmental Protection Agency</p>',
'',
'</div><!-- /footer -->',
'<p class="skip"><a href="#content" title="Jump to main content.">Jump to main content.</a></p>',
'<script src="#WORKSPACE_IMAGES#jquery.js"></script>',
'<script src="#WORKSPACE_IMAGES#epa-core-v4.js"></script>',
'<!-- ALL SCRIPTS BELOW THIS LINE -->',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_region_table_cattributes=>'width="100%" summary=""'
,p_theme_class_id=>8
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(37710474362483110)
,p_theme_id=>101
,p_name=>'basic wide'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="en">',
'<!-- EPA Template, OneEPA Web, 17 November 2010 -->',
'<head>',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'<meta charset="utf-8" />',
'<meta http-equiv="X-UA-Compatible" content="IE=8" />',
'<title>#TITLE#</title>',
'<meta name="DC.description" content="" />',
'<meta name="keywords" content="" />',
'<meta name="DC.title" content="" />',
'<meta name="DC.type" content="" />',
'<meta name="DC.Subject.epachannel" content="" />',
'<meta name="DC.Subject.epabrm" content="" />',
'<meta name="DC.Subject.epacat" content="" />',
'<meta name="DC.Subject.epaect" content="" />',
'<meta name="DC.Subject.epaemt" content="" />',
'',
'<meta name="DC.Subject.epahealth" content="" />',
'<meta name="DC.Subject.epaindustry" content="" />',
'<meta name="DC.Subject.epaopt" content="" />',
'<meta name="DC.Subject.epappt" content="" />',
'<meta name="DC.Subject.eparat" content="" />',
'<meta name="DC.Subject.eparegulation" content="" />',
'<meta name="DC.Subject.eparit" content="" />',
'<meta name="DC.Subject.epasubstance" content="" />',
'<meta name="DC.audience" content="" />',
'<meta name="DC.coverage" content="" />',
'<meta name="DC.date.created" content="" />',
'<meta name="DC.date.modified" content="" />',
'<meta name="DC.date.archivedate" content="" />',
'<meta name="DC.creator" content="US EPA" />',
'<meta name="DC.language" content="en" />',
'<meta name="viewport" content="width=device-width; initial-scale=1.0"/>',
'',
'<link rel="schema.DC" href="http://purl.org/dc/elements/1.1/" />',
'<!--RSS Feeds -->',
'<link rel="meta" href="http://www.epa.gov/labels.rdf" type="application/rdf+xml" title="ICRA labels" />',
'<link rel="alternate" type="application/atom+xml" title="EPA.gov News" href="http://yosemite.epa.gov/opa/admpress.nsf/RSSRecentNews" />',
'<link rel="alternate" type="application/atom+xml" title="EPA.gov Headquarters Press Releases" href="http://yosemite.epa.gov/opa/admpress.nsf/RSSByLocation?open&location=Headquarters" />',
'<link rel="alternate" type="application/atom+xml" title="Greenversations, EPA''s Blog" href="http://blog.epa.gov/blog/feed/" />',
'',
'<!-- ALL PAGE STYLES BELOW THIS LINE -->',
'<link rel="stylesheet" href="#WORKSPACE_IMAGES#template4_fix.css" type="text/css" />',
'<!--link rel="stylesheet" href="css/local.css" /-->',
'<link rel="stylesheet" href="#WORKSPACE_IMAGES#epa.css" />',
'<!--[if IE 7]><link rel="stylesheet" href="#WORKSPACE_IMAGES#ie7.css"/><![endif]-->',
'<!--[if lt IE 7]><link rel="stylesheet" href="#WORKSPACE_IMAGES#ie6.css"/><![endif]-->',
'',
'<style type="text/css"> ',
'div.left_box{float:left;width:65%;position:relative;padding-right:1%;}',
'div.right_box{float:right;width:30%;position:relative;}',
'div.box_wrapper{width:100%;position:relative;}',
'ul.dhtmlSubMenu{z-index:9999;}',
'.multi_selectlist{display:block;border:1px solid #ddd;padding:5px;}',
'.multi_selectlist:focus{border:1px solid #666;}',
'.text_field{display:block;border:1px solid #ddd;padding:5px;}',
'.text_field:focus{border:1px solid #666;}',
'.button_field{display:block;background:#369;border:#ddd;color:#fff;cursor:pointer;font-weight:bold;margin:10px 0;padding:5px;width:120px;}',
'.button_field_auto{display:block;background:#369;border:#ddd;color:#fff;cursor:pointer;font-weight:bold;margin:10px 0;padding:5px;width:auto;}',
'</style>',
'',
'</head>',
'<body class="basic wide" #ONLOAD#>'))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!--googleoff: index-->',
'<p id="sitewidec"></p>',
'<p class="skip">Jump to <a href="#main" title="Jump to main content">main content</a> or <a href="#areanav" title="Jump to area navigation.">area navigation</a>.</p>',
'',
'<div id="header">',
'  <p><a href="http://www.epa.gov/" title="US EPA Home Page"><img src="https://ofmpub.epa.gov/WATERSHTML/oneepa/print-epa-logo.gif" alt="US Environmental Protection Agency logo" /></a></p>',
'  <form id="EPAsearch" method="get" action="http://nlquery.epa.gov/epasearch/epasearch">',
'    <fieldset>',
'      <ol>',
'        <li id="azindex"><a href="http://www.epa.gov/epahome/quickfinder.htm" title="Alphabetical list of top EPA topics">A-Z Index</a></li>',
'        <li><a href="http://www.epa.gov/search.html" title="Advanced search with additional filters">Advanced Search</a></li>',
'        <li>',
'',
'          <fieldset id="search">',
'            <legend>What are you looking for?</legend>',
'            <input name="querytext" id="searchbox" value=""/>',
'            <button id="searchbutton" type="submit" title="Search">Search</button>',
'          </fieldset>',
'        </li>',
'      </ol>',
'      <input type="hidden" name="fld" value="" />',
'',
'      <input type="hidden" name="areaname" value="" />',
'      <input type="hidden" name="areacontacts" value="" />',
'      <input type="hidden" name="areasearchurl" value="" />',
'      <input type="hidden" name="typeofsearch" value="epa" />',
'      <input type="hidden" name="result_template" value="epafiles_default.xsl" />',
'      <input type="hidden" name="filter" value="sample4filt.hts" />',
'    </fieldset>',
'  </form><!-- /search -->',
'  <ul>',
'',
'    <li id="learn"><a href="http://www.epa.gov/gateway/learn/" title="Learn the Issues">Learn the Issues</a></li>',
'    <li id="scitech"><a href="http://www.epa.gov/gateway/science/" title="Science and Technology">Science &amp; Technology</a></li>',
'    <li id="laws"><a href="http://www.epa.gov/lawsregs/" title="Laws and Regulations">Laws &amp; Regulations</a></li>',
'    <li id="about"><a href="http://www.epa.gov/aboutepa/" title="About EPA">About EPA</a></li>',
'  </ul><!-- /IA Buckets -->',
'',
'</div><!-- /header -->',
'<div id="content">',
'  <div id="area">',
'    <p><a href="http://www.epa.gov/storet/contact.html">Contact Us</a></p>',
'<p>STORET - #TITLE#</p>',
'   <!-- <p>STORET</p>-->',
'  </div><!-- /area -->',
'  <div id="page">',
'    <div id="main">',
'      <ul id="breadcrumbs">',
'',
'        <li class="first"><b>You are here:</b> <a href="http://www.epa.gov/">EPA Home</a></li>',
'       <li><a href="http://www.epa.gov/water/">Water</a></li>',
'       <li><a href="http://www.epa.gov/owow/">Wetlands, Oceans, & Watersheds</a></li>',
'       <li><a href="http://www.epa.gov/owow/monitoring/">Monitoring and Assessing Water Quality</a></li>',
'       <li><a href="http://www.epa.gov/storet/index.html">STORET</a></li>',
'        <li>Data Warehouse</li>',
'      </ul>',
'<!--googleon: index-->',
' ',
'#REGION_POSITION_06# ',
'',
'#FORM_OPEN#',
'',
'',
'#REGION_POSITION_01# <br><br>',
'',
'<table width="100%" summary="" height="70%" cellspacing="0" cellpadding="0" border="0">',
'  <tr>',
'',
'    <td>',
'    <div align="center">',
'      #GLOBAL_NOTIFICATION##NOTIFICATION_MESSAGE##SUCCESS_MESSAGE#     ',
'    </div>',
'    #BODY##REGION_POSITION_02##REGION_POSITION_04#',
'    </td>',
'    <td align="right" valign="top">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" width="15" height="3" alt="" />',
'    </td>',
'    <td class="t15RightBar" align="right" valign="top">',
'      #REGION_POSITION_03#',
'    </td>',
'  </tr>',
'</table>',
'',
'',
'			<p class="pagetop"><a href="#content">Top of Page</a></p>',
'<!--googleoff: index-->',
'    </div><!-- /main -->',
'',
'    <div id="areanav">',
'      <h4 class="skip">Area Navigation</h4>',
'      <ul>',
'        <li class="separator"><a href="#">Area Home</a><hr /></li>',
'        <li><a href="#">Subarea Home</a></li>',
'        <li><a href="#">Basic Information</a></li>',
'        <li><a href="#">Where You Live</a></li>',
'',
'        <li><a href="#">Recent Additions</a></li>',
'        <li><a href="#">Area sidebar links go here</a></li>',
'        <li><a href="#">Link #7</a></li>',
'        <li><a href="#">Link #8</a></li>',
'      </ul>',
'    </div><!-- /area-nav -->',
'  </div><!-- /page -->',
'',
'</div><!-- /content -->'))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'<div id="footer">',
'  <ul id="goodies">',
'    <li id="rss-news"><a href="http://www.epa.gov/newsroom/rssfeeds.htm">News Feeds</a></li>',
'    <li id="podcasts"><a href="http://www.epa.gov/epahome/podcasts.htm">Podcasts</a></li>',
'    <li id="mobile"><a href="http://m.epa.gov/">EPA Mobile</a></li>',
'    <li id="email-news"><a href="http://www.epa.gov/newsroom/email_signups.htm">News by Email</a></li>',
'    <li id="widgets"><a href="http://www.epa.gov/widgets/">Widgets</a></li>',
'',
'  </ul>',
'  <ul id="globalfooter">',
'    <li><a href="http://www.epa.gov/">EPA Home</a></li>',
'    <li><a href="http://www.epa.gov/epahome/usenotice.htm">Privacy and Security Notice</a></li>',
'    <li class="last"><a href="http://www.epa.gov/epahome/comments.htm">Contact Us</a></li>',
'  </ul>',
'  <p id="seal">The Seal of the United States Environmental Protection Agency</p>',
'',
'</div><!-- /footer -->',
'<p class="skip"><a href="#content" title="Jump to main content.">Jump to main content.</a></p>',
'<script src="#WORKSPACE_IMAGES#jquery.js"></script>',
'<script src="#WORKSPACE_IMAGES#epa-core-v4.js"></script>',
'<!-- ALL SCRIPTS BELOW THIS LINE -->',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_region_table_cattributes=>'width="100%" summary=""'
,p_theme_class_id=>8
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(37723274196942150)
,p_theme_id=>2
,p_name=>'Login'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="login">',
'  <div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'  <div id="login-main">#REGION_POSITION_02##BODY##REGION_POSITION_03#</div>',
'</div>',
''))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0"'
,p_theme_class_id=>6
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
,p_template_comment=>'18'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(37723479522942152)
,p_theme_id=>2
,p_name=>'No Tabs - Left Sidebar (fixed-width / DIV based)'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    #NAVIGATION_BAR#',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'</div>',
'<div id="tabs">',
'  <div class="frame">',
'    <div class="bg">',
'      <div class="tab-holder">',
'        &nbsp;',
'      </div>',
'    </div>',
'  </div>',
'</div>',
'<div id="topbar">#REGION_POSITION_01##REGION_POSITION_04#</div>',
'<div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div id="body">',
'  <div id="two-col-sb-left">',
'    <div id="left-sidebar">#REGION_POSITION_02#</div>',
'    <div id="main-sb-left">',
'      #BODY##REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="footer"><div class="content">',
'  #REGION_POSITION_05#',
'  <div id="customize">#CUSTOMIZE#</div>&nbsp;',
'</div></div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>'summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>17
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(37723755183942154)
,p_theme_id=>2
,p_name=>'No Tabs - Left and Right Sidebar (fixed-width / DIV left and optional table-based right)'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    #NAVIGATION_BAR#',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'</div>',
'<div id="tabs">',
'  <div class="frame">',
'    <div class="bg">',
'      <div class="tab-holder">',
'        &nbsp;',
'      </div>',
'    </div>',
'  </div>',
'</div>',
'<div id="topbar">#REGION_POSITION_01##REGION_POSITION_04#</div>',
'<div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div id="body">',
'  <div id="three-col">',
'    <div id="left-sidebar">#REGION_POSITION_02#</div>',
'    <div id="two-col-tbl">',
'      <table class="tbl-body" cellspacing="0" cellpadding="0" border="0" summary="">',
'        <tbody>',
'          <tr>',
'            <td class="tbl-main" width="100%">#BODY#</td>',
'            <td class="tbl-sidebar">#REGION_POSITION_03#</td>     ',
'          </tr>',
'        </tbody>',
'      </table>',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="footer"><div class="content">',
'  #REGION_POSITION_05#',
'  <div id="customize">#CUSTOMIZE#</div>&nbsp;',
'</div></div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>'summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>17
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(37724053138942154)
,p_theme_id=>2
,p_name=>'No Tabs - Right Sidebar (fixed-width / DIV based)'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    #NAVIGATION_BAR#',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'</div>',
'<div id="tabs">',
'  <div class="frame">',
'    <div class="bg">',
'      <div class="tab-holder">',
'        &nbsp;',
'      </div>',
'    </div>',
'  </div>',
'</div>',
'<div id="topbar">#REGION_POSITION_01##REGION_POSITION_04#</div>',
'<div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div id="body">',
'  <div id="two-col">',
'    <div id="sidebar">#REGION_POSITION_03#</div>     ',
'    <div id="main">#REGION_POSITION_02##BODY#</div>',
'  </div>',
'</div>',
''))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="footer"><div class="content">',
'  #REGION_POSITION_05#',
'  <div id="customize">#CUSTOMIZE#</div>&nbsp;',
'</div></div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>3
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
end;
/
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(37724366021942154)
,p_theme_id=>2
,p_name=>'No Tabs - Right Sidebar (optional / table-based)'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    #NAVIGATION_BAR#',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'</div>',
'<div id="tabs">',
'  <div class="frame">',
'    <div class="bg">',
'      <div class="tab-holder">',
'        &nbsp;',
'      </div>',
'    </div>',
'  </div>',
'</div>',
'<div id="topbar">#REGION_POSITION_01##REGION_POSITION_04#</div>',
'<div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div id="body">',
'  <table class="tbl-body" cellspacing="0" cellpadding="0" border="0" summary="">',
'    <tbody>',
'      <tr>',
'        <td class="tbl-main" width="100%">#REGION_POSITION_02##BODY#</td>',
'        <td class="tbl-sidebar">#REGION_POSITION_03#</td>     ',
'      </tr>',
'    </tbody>',
'  </table>',
'</div>'))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="footer"><div class="content">',
'  #REGION_POSITION_05#',
'  <div id="customize">#CUSTOMIZE#</div>&nbsp;',
'</div></div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>3
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(37724657078942154)
,p_theme_id=>2
,p_name=>'One Level Tabs - Left Sidebar (fixed-width / DIV based)'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    #NAVIGATION_BAR#',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'</div>',
'<div id="tabs">',
'  <div class="frame">',
'    <div class="bg">',
'      <div class="tab-holder">',
'        #TAB_CELLS#',
'      </div>',
'    </div>',
'  </div>',
'</div>',
'<div id="topbar">#REGION_POSITION_01##REGION_POSITION_04#</div>',
'<div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div id="body">',
'  <div id="two-col-sb-left">',
'    <div id="left-sidebar">#REGION_POSITION_02#</div>',
'    <div id="main-sb-left">',
'      #BODY##REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="footer"><div class="content">',
'  #REGION_POSITION_05#',
'  <div id="customize">#CUSTOMIZE#</div>&nbsp;',
'</div></div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<span>#TAB_LABEL#</span>#TAB_INLINE_EDIT#',
'</div></div>'))
,p_non_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
'</div></div>',
''))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>16
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(37724953005942154)
,p_theme_id=>2
,p_name=>'One Level Tabs - Left and Right Sidebar (fixed-width / DIV left and optional table-based right)'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    #NAVIGATION_BAR#',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'</div>',
'<div id="tabs">',
'  <div class="frame">',
'    <div class="bg">',
'      <div class="tab-holder">',
'        #TAB_CELLS#',
'      </div>',
'    </div>',
'  </div>',
'</div>',
'<div id="topbar">#REGION_POSITION_01##REGION_POSITION_04#</div>',
'<div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div id="body">',
'  <div id="three-col">',
'    <div id="left-sidebar">#REGION_POSITION_02#</div>',
'    <div id="two-col-tbl">',
'      <table class="tbl-body" cellspacing="0" cellpadding="0" border="0" summary="">',
'        <tbody>',
'          <tr>',
'            <td class="tbl-main" width="100%">#BODY#</td>',
'            <td class="tbl-sidebar">#REGION_POSITION_03#</td>     ',
'          </tr>',
'        </tbody>',
'      </table>',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="footer"><div class="content">',
'  #REGION_POSITION_05#',
'  <div id="customize">#CUSTOMIZE#</div>&nbsp;',
'</div></div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<span>#TAB_LABEL#</span>#TAB_INLINE_EDIT#',
'</div></div>'))
,p_non_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
'</div></div>',
'',
'',
'',
'',
'',
''))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>16
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(37725263821942154)
,p_theme_id=>2
,p_name=>'One Level Tabs - Right Sidebar (fixed-width / DIV based)'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    #NAVIGATION_BAR#',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'</div>',
'<div id="tabs">',
'  <div class="frame">',
'    <div class="bg">',
'      <div class="tab-holder">',
'        #TAB_CELLS#',
'      </div>',
'    </div>',
'  </div>',
'</div>',
'<div id="topbar">#REGION_POSITION_01##REGION_POSITION_04#</div>',
'<div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div id="body">',
'  <div id="two-col">',
'    <div id="sidebar">#REGION_POSITION_03#</div>     ',
'    <div id="main">#REGION_POSITION_02##BODY#</div>',
'  </div>',
'</div>',
''))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="footer"><div class="content">',
'  #REGION_POSITION_05#',
'  <div id="customize">#CUSTOMIZE#</div>&nbsp;',
'</div></div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<span>#TAB_LABEL#</span>#TAB_INLINE_EDIT#',
'</div></div>'))
,p_non_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
'</div></div>',
''))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>8
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(37725567436942154)
,p_theme_id=>2
,p_name=>'One Level Tabs - Right Sidebar (optional / table-based)'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    #NAVIGATION_BAR#',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'</div>',
'<div id="tabs">',
'  <div class="frame">',
'    <div class="bg">',
'      <div class="tab-holder">',
'        #TAB_CELLS#',
'      </div>',
'    </div>',
'  </div>',
'</div>',
'<div id="topbar">#REGION_POSITION_01##REGION_POSITION_04#</div>',
'<div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div id="body">',
'  <table class="tbl-body" cellspacing="0" cellpadding="0" border="0" summary="">',
'    <tbody>',
'      <tr>',
'        <td class="tbl-main" width="100%">#REGION_POSITION_02##BODY#</td>',
'        <td class="tbl-sidebar">#REGION_POSITION_03#</td>     ',
'      </tr>',
'    </tbody>',
'  </table>',
'</div>'))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="footer"><div class="content">',
'  #REGION_POSITION_05#',
'  <div id="customize">#CUSTOMIZE#</div>&nbsp;',
'</div></div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<span>#TAB_LABEL#</span>#TAB_INLINE_EDIT#',
'</div></div>'))
,p_non_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
'</div></div>',
'',
'',
'',
'',
'',
''))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="navbar-link">#TEXT#</a></div>'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>1
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(37725878474942155)
,p_theme_id=>2
,p_name=>'Popup'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/theme_4_0.css" type="text/css" />',
'</head>',
'<body #ONLOAD#>#FORM_OPEN#'))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">',
'<tr>',
'<td width="100%" valign="top"><div class="t1messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BODY##REGION_POSITION_01##REGION_POSITION_02##REGION_POSITION_04##REGION_POSITION_05##REGION_POSITION_06##REGION_POSITION_07##REGION_POSITION_08#</td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table>'))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'#FORM_CLOSE##DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>'<div class="t1success" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#SUCCESS_MESSAGE#</div>'
,p_notification_message=>'<div class="t1notification" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#MESSAGE#</div>'
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_theme_class_id=>4
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(37726159973942155)
,p_theme_id=>2
,p_name=>'Printer Friendly'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
'  <link rel="icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'</div>',
'<div id="body">',
'  <table class="tbl-body" cellspacing="0" cellpadding="0" border="0" summary="">',
'    <tbody>',
'      <tr>',
'        <td class="tbl-sidebar">#REGION_POSITION_02#</td>     ',
'        <td class="tbl-main" width="100%">#BODY#</td>',
'        <td class="tbl-sidebar">#REGION_POSITION_03#</td>     ',
'      </tr>',
'    </tbody>',
'  </table>',
'</div>'))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_theme_class_id=>5
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
,p_template_comment=>'3'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(37726453986942156)
,p_theme_id=>2
,p_name=>'Two Level Tabs - Left Sidebar (fixed-width / DIV based)'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
' #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header2">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    #NAVIGATION_BAR#',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'  <div id="parent-tabs">',
'    <div class="tab-holder">#PARENT_TAB_CELLS#</div>',
'  </div>',
'</div>',
'<div id="tabs">',
'  <div class="frame">',
'    <div class="bg">',
'      <div class="tab-holder">',
'        #TAB_CELLS#',
'      </div>',
'    </div>',
'  </div>',
'</div>',
'<div id="topbar">#REGION_POSITION_01##REGION_POSITION_04#</div>',
'<div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div id="body">',
'  <div id="two-col-sb-left">',
'    <div id="left-sidebar">#REGION_POSITION_02#</div>',
'    <div id="main-sb-left">',
'      #BODY##REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>',
''))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="footer"><div class="content">',
'  #REGION_POSITION_05#',
'  <div id="customize">#CUSTOMIZE#</div>&nbsp;',
'</div></div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<span>#TAB_LABEL#</span>#TAB_INLINE_EDIT#',
'</div></div>'))
,p_non_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
'</div></div>',
''))
,p_top_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="current"><div>',
'#TAB_LABEL##TAB_INLINE_EDIT#',
'</div></div>',
'',
''))
,p_top_non_curr_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="noncurrent"><div>',
'<a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
'</div></div>',
'',
'',
'',
'',
''))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>18
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(37726751301942156)
,p_theme_id=>2
,p_name=>'Two Level Tabs - Left and Right Sidebar (fixed-width / DIV left and optional table-based right)'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
' #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header2">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    #NAVIGATION_BAR#',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'  <div id="parent-tabs">',
'    <div class="tab-holder">#PARENT_TAB_CELLS#</div>',
'  </div>',
'</div>',
'<div id="tabs">',
'  <div class="frame">',
'    <div class="bg">',
'      <div class="tab-holder">',
'        #TAB_CELLS#',
'      </div>',
'    </div>',
'  </div>',
'</div>',
'<div id="topbar">#REGION_POSITION_01##REGION_POSITION_04#</div>',
'<div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div id="body">',
'  <div id="three-col">',
'    <div id="left-sidebar">#REGION_POSITION_02#</div>',
'    <div id="two-col-tbl">',
'      <table class="tbl-body" cellspacing="0" cellpadding="0" border="0" summary="">',
'        <tbody>',
'          <tr>',
'            <td class="tbl-main" width="100%">#BODY#</td>',
'            <td class="tbl-sidebar">#REGION_POSITION_03#</td>     ',
'          </tr>',
'        </tbody>',
'      </table>',
'    </div>',
'  </div>',
'</div>',
''))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="footer"><div class="content">',
'  #REGION_POSITION_05#',
'  <div id="customize">#CUSTOMIZE#</div>&nbsp;',
'</div></div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<span>#TAB_LABEL#</span>#TAB_INLINE_EDIT#',
'</div></div>'))
,p_non_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
'</div></div>'))
,p_top_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="current"><div>',
'#TAB_LABEL##TAB_INLINE_EDIT#',
'</div></div>',
'',
''))
,p_top_non_curr_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="noncurrent"><div>',
'<a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
'</div></div>',
'',
'',
'',
'',
''))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>18
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
end;
/
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(37727066900942156)
,p_theme_id=>2
,p_name=>'Two Level Tabs - Right Sidebar (fixed-width / DIV based)'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
' #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header2">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    #NAVIGATION_BAR#',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'  <div id="parent-tabs">',
'    <div class="tab-holder">#PARENT_TAB_CELLS#</div>',
'  </div>',
'</div>',
'<div id="tabs">',
'  <div class="frame">',
'    <div class="bg">',
'      <div class="tab-holder">',
'        #TAB_CELLS#',
'      </div>',
'    </div>',
'  </div>',
'</div>',
'<div id="topbar">#REGION_POSITION_01##REGION_POSITION_04#</div>',
'<div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div id="body">',
'  <div id="two-col">',
'    <div id="sidebar">#REGION_POSITION_03#</div>     ',
'    <div id="main">#REGION_POSITION_02##BODY#</div>',
'  </div>',
'</div>',
''))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="footer"><div class="content">',
'  #REGION_POSITION_05#',
'  <div id="customize">#CUSTOMIZE#</div>&nbsp;',
'</div></div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<span>#TAB_LABEL#</span>#TAB_INLINE_EDIT#',
'</div></div>'))
,p_non_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
'</div></div>'))
,p_top_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="current"><div>',
'#TAB_LABEL##TAB_INLINE_EDIT#',
'</div></div>',
'',
''))
,p_top_non_curr_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="noncurrent"><div>',
'<a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
'</div></div>',
'',
'',
'',
'',
''))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>2
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(37727377854942156)
,p_theme_id=>2
,p_name=>'Two Level Tabs - Right Sidebar (optional / table-based)'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
' #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header2">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    #NAVIGATION_BAR#',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'  <div id="parent-tabs">',
'    <div class="tab-holder">#PARENT_TAB_CELLS#</div>',
'  </div>',
'</div>',
'<div id="tabs">',
'  <div class="frame">',
'    <div class="bg">',
'      <div class="tab-holder">',
'        #TAB_CELLS#',
'      </div>',
'    </div>',
'  </div>',
'</div>',
'<div id="topbar">#REGION_POSITION_01##REGION_POSITION_04#</div>',
'<div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div id="body">',
'  <table class="tbl-body" cellspacing="0" cellpadding="0" border="0" summary="">',
'    <tbody>',
'      <tr>',
'        <td class="tbl-main" width="100%">#REGION_POSITION_02##BODY#</td>',
'        <td class="tbl-sidebar">#REGION_POSITION_03#</td>     ',
'      </tr>',
'    </tbody>',
'  </table>',
'</div>'))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="footer"><div class="content">',
'  #REGION_POSITION_05#',
'  <div id="customize">#CUSTOMIZE#</div>&nbsp;',
'</div></div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<span>#TAB_LABEL#</span>#TAB_INLINE_EDIT#',
'</div></div>'))
,p_non_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
'</div></div>'))
,p_top_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="current"><div>',
'#TAB_LABEL##TAB_INLINE_EDIT#',
'</div></div>',
'',
''))
,p_top_non_curr_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="noncurrent"><div>',
'<a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
'</div></div>',
'',
'',
'',
'',
''))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>2
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(38135575755180443)
,p_theme_id=>101
,p_name=>'Basic'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="en">',
'<!-- EPA Template, OneEPA Web, 17 November 2010 -->',
'<head>',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'<meta charset="utf-8" />',
'<meta http-equiv="X-UA-Compatible" content="IE=8" />',
'<title>#TITLE#</title>',
'<meta name="DC.description" content="" />',
'<meta name="keywords" content="" />',
'<meta name="DC.title" content="" />',
'<meta name="DC.type" content="" />',
'<meta name="DC.Subject.epachannel" content="" />',
'<meta name="DC.Subject.epabrm" content="" />',
'<meta name="DC.Subject.epacat" content="" />',
'<meta name="DC.Subject.epaect" content="" />',
'<meta name="DC.Subject.epaemt" content="" />',
'',
'<meta name="DC.Subject.epahealth" content="" />',
'<meta name="DC.Subject.epaindustry" content="" />',
'<meta name="DC.Subject.epaopt" content="" />',
'<meta name="DC.Subject.epappt" content="" />',
'<meta name="DC.Subject.eparat" content="" />',
'<meta name="DC.Subject.eparegulation" content="" />',
'<meta name="DC.Subject.eparit" content="" />',
'<meta name="DC.Subject.epasubstance" content="" />',
'<meta name="DC.audience" content="" />',
'<meta name="DC.coverage" content="" />',
'<meta name="DC.date.created" content="" />',
'<meta name="DC.date.modified" content="" />',
'<meta name="DC.date.archivedate" content="" />',
'<meta name="DC.creator" content="US EPA" />',
'<meta name="DC.language" content="en" />',
'<meta name="viewport" content="width=device-width; initial-scale=1.0"/>',
'',
'<link rel="schema.DC" href="http://purl.org/dc/elements/1.1/" />',
'<link rel="meta" href="http://www.epa.gov/labels.rdf" type="application/rdf+xml" title="ICRA labels" />',
'<!--RSS Feeds -->',
'<link rel="alternate" type="application/atom+xml" title="EPA.gov News" href="http://yosemite.epa.gov/opa/admpress.nsf/RSSRecentNews" />',
'<link rel="alternate" type="application/atom+xml" title="EPA.gov Headquarters Press Releases" href="http://yosemite.epa.gov/opa/admpress.nsf/RSSByLocation?open&location=Headquarters" />',
'<link rel="alternate" type="application/atom+xml" title="Greenversations, EPA''s Blog" href="http://blog.epa.gov/blog/feed/" />',
'',
'<!-- ALL PAGE STYLES BELOW THIS LINE -->',
'<!--link rel="stylesheet" href="css/local.css" /-->',
'<link rel="stylesheet" href="http://www.epa.gov/epafiles/templates/webcms/css/epa.css" />',
'<!--[if IE 7]><link rel="stylesheet" href="http://www.epa.gov/epafiles/templates/webcms/css/ie7.css"/><![endif]-->',
'<!--[if lt IE 7]><link rel="stylesheet" href="http://www.epa.gov/epafiles/templates/webcms/css/ie6.css"/><![endif]-->',
'</head>',
'<body class="basic" #ONLOAD#>'))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!--googleoff: index-->',
'<p id="sitewidec"></p>',
'<p class="skip">Jump to <a href="#main" title="Jump to main content">main content</a> or <a href="#areanav" title="Jump to area navigation.">area navigation</a>.</p>',
'',
'<div id="header">',
'  <p><a href="http://www.epa.gov/" title="US EPA Home Page"><img src="http://www.epa.gov/epafiles/templates/webcms/css/i/print-epa-logo.gif" alt="US Environmental Protection Agency logo" /></a></p>',
'  <form id="EPAsearch" method="get" action="http://nlquery.epa.gov/epasearch/epasearch">',
'    <fieldset>',
'      <ol>',
'        <li id="azindex"><a href="http://www.epa.gov/epahome/quickfinder.htm" title="Alphabetical list of top EPA topics">A-Z Index</a></li>',
'        <li><a href="http://www.epa.gov/search.html" title="Advanced search with additional filters">Advanced Search</a></li>',
'        <li>',
'',
'          <fieldset id="search">',
'            <legend>What are you looking for?</legend>',
'            <input name="querytext" id="searchbox" value=""/>',
'            <button id="searchbutton" type="submit" title="Search">Search</button>',
'          </fieldset>',
'        </li>',
'      </ol>',
'      <input type="hidden" name="fld" value="" />',
'',
'      <input type="hidden" name="areaname" value="" />',
'      <input type="hidden" name="areacontacts" value="" />',
'      <input type="hidden" name="areasearchurl" value="" />',
'      <input type="hidden" name="typeofsearch" value="epa" />',
'      <input type="hidden" name="result_template" value="epafiles_default.xsl" />',
'      <input type="hidden" name="filter" value="sample4filt.hts" />',
'    </fieldset>',
'  </form><!-- /search -->',
'  <ul>',
'',
'    <li id="learn"><a href="http://www.epa.gov/gateway/learn/" title="Learn the Issues">Learn the Issues</a></li>',
'    <li id="scitech"><a href="http://www.epa.gov/gateway/science/" title="Science and Technology">Science &amp; Technology</a></li>',
'    <li id="laws"><a href="http://www.epa.gov/lawsregs/" title="Laws and Regulations">Laws &amp; Regulations</a></li>',
'    <li id="about"><a href="http://www.epa.gov/aboutepa/" title="About EPA">About EPA</a></li>',
'  </ul><!-- /IA Buckets -->',
'',
'</div><!-- /header -->',
'#FORM_OPEN#',
'<div id="content">',
'  <div id="area">',
'    <p><a href="#">Contact Us</a></p>',
'    <p>{Area Name}</p>',
'  </div><!-- /area -->',
'  <div id="page">',
'    <div id="main">',
'      <ul id="breadcrumbs">',
'',
'        <li class="first"><b>You are here:</b> <a href="http://www.epa.gov/">EPA Home</a></li>',
'        <li>{Page Title}</li>',
'      </ul>',
'<!--googleon: index-->',
'      <h1>{Page title goes here}</h1>',
'   ',
'#BODY#',
'			<p class="pagetop"><a href="#content">Top of Page</a></p>',
'',
'<!--googleoff: index-->',
''))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
' #FORM_CLOSE#',
' <p id="areafooter">{Area footer content goes here}</p>',
'    </div><!-- /main -->',
'    <div id="areanav">',
'',
'      <h4 class="skip">Area Navigation</h4>',
'      <ul>',
'        <li class="separator"><a href="#">Area Home</a><hr /></li>',
'        <li><a href="#">Subarea Home</a></li>',
'        <li><a href="#">Basic Information</a></li>',
'        <li><a href="#">Where You Live</a></li>',
'',
'        <li><a href="#">Recent Additions</a></li>',
'        <li><a href="#">Area sidebar links go here</a></li>',
'        <li><a href="#">Link #7</a></li>',
'        <li><a href="#">Link #8</a></li>',
'      </ul>',
'    </div><!-- /area-nav -->',
'  </div><!-- /page -->',
'',
'</div><!-- /content -->',
'<div id="footer">',
'  <ul id="goodies">',
'    <li id="rss-news"><a href="http://www.epa.gov/newsroom/rssfeeds.htm">News Feeds</a></li>',
'    <li id="podcasts"><a href="http://www.epa.gov/epahome/podcasts.htm">Podcasts</a></li>',
'    <li id="mobile"><a href="http://m.epa.gov/">EPA Mobile</a></li>',
'    <li id="email-news"><a href="http://www.epa.gov/newsroom/email_signups.htm">News by Email</a></li>',
'    <li id="widgets"><a href="http://www.epa.gov/widgets/">Widgets</a></li>',
'',
'  </ul>',
'  <ul id="globalfooter">',
'    <li><a href="http://www.epa.gov/">EPA Home</a></li>',
'    <li><a href="http://www.epa.gov/epahome/usenotice.htm">Privacy and Security Notice</a></li>',
'    <li class="last"><a href="#">Contact Us</a></li>',
'  </ul>',
'  <p id="seal">The Seal of the United States Environmental Protection Agency</p>',
'',
'</div><!-- /footer -->',
'<p class="skip"><a href="#content" title="Jump to main content.">Jump to main content.</a></p>',
'<script src="http://www.epa.gov/epafiles/js/third-party/jquery.js"></script>',
'<script src="http://www.epa.gov/epafiles/js/epa-core-v4.js"></script>',
'<!-- ALL SCRIPTS BELOW THIS LINE -->',
'',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_theme_class_id=>9
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(27668368034614464)
,p_template_name=>'HTML button (legacy - APEX 5 migration)'
,p_template=>' <input type="button" value="#LABEL#" onclick="#JAVASCRIPT#" id="#BUTTON_ID#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES#/>'
,p_hot_template=>' <input type="button" value="#LABEL#" onclick="#JAVASCRIPT#" id="#BUTTON_ID#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES#/>'
,p_translate_this_template=>'N'
,p_theme_class_id=>13
,p_theme_id=>101
);
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(37710977565483114)
,p_template_name=>'Button'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table class="t15Button" cellspacing="0" cellpadding="0" border="0"  summary=""><tr>',
'<td class="t15L"><img src="#IMAGE_PREFIX#themes/theme_15/button-l.gif" alt="" /></td>',
'<td class="t15C" style="vertical-align:top"><a href="#LINK#">#LABEL#</a></td>',
'<td class="t15R"><img src="#IMAGE_PREFIX#themes/theme_15/button-r.gif" alt="" /></td>',
'</tr></table>'))
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>101
);
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(37727669919942156)
,p_template_name=>'Button'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<button value="#LABEL#" onclick="#LINK#" class="button-gray" type="button">',
'  <span>#LABEL#</span>',
'</button>'))
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>2
);
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(37727851996942157)
,p_template_name=>'Button, Alternative 1'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<button value="#LABEL#" onclick="#LINK#" class="button-alt1" type="button">',
'  <span>#LABEL#</span>',
'</button>'))
,p_translate_this_template=>'N'
,p_theme_class_id=>4
,p_theme_id=>2
);
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(37728077216942157)
,p_template_name=>'Button, Alternative 2'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<button value="#LABEL#" onclick="#LINK#" class="button-alt2" type="button">',
'  <span>#LABEL#</span>',
'</button>'))
,p_translate_this_template=>'N'
,p_theme_class_id=>5
,p_template_comment=>'XP Square FFFFFF'
,p_theme_id=>2
);
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(37728278343942157)
,p_template_name=>'Button, Alternative 3'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<button value="#LABEL#" onclick="#LINK#" class="button-alt3" type="button">',
'  <span>#LABEL#</span>',
'</button>'))
,p_translate_this_template=>'N'
,p_theme_class_id=>2
,p_template_comment=>'Standard Button'
,p_theme_id=>2
);
end;
/
prompt --application/shared_components/user_interface/templates/region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37710582515483112)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="rc-gray-top"><div class="rc-gray-top-r">',
'    <div class="rc-title">#TITLE#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r">',
'<div class="rc-content-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'<div class="rc-content-main">#BODY#<div class="clear"></div></div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div> '))
,p_page_plug_template_name=>'Reports Region'
,p_theme_id=>101
,p_theme_class_id=>9
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37710655050483113)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region float-left-100pct" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="rc-gray-top"><div class="rc-gray-top-r">',
'    <div class="rc-title"><strong>#TITLE#</strong></div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r">',
'<div class="rc-content-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'<div class="rc-content-main">#BODY#<div class="clear"></div></div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'Reports Region 100% Width'
,p_theme_id=>101
,p_theme_class_id=>13
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37728452308942157)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="borderless-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="bl-top">',
'    <div class="bl-title">#TITLE#</div>',
'    <div class="bl-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div>',
'  <div class="bl-body">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'Borderless Region'
,p_theme_id=>2
,p_theme_class_id=>7
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'Use this region template when you want to contain content without a border.',
'',
'TITLE=YES',
'BUTTONS=YES',
'100% WIDTH=NO'))
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37728782665942158)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="bracketed-region brackets" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="bk-top">',
'    <div class="bk-top-r">',
'      <div class="bk-title">#TITLE#</div>',
'      <div class="bk-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'    </div>',
'  </div>',
'  <div class="bk-body">#BODY#</div>',
'  <div class="bk-bottom">',
'    <div class="bk-bottom-r">&nbsp;</div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'Bracketed Region'
,p_theme_id=>2
,p_theme_class_id=>18
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'Use this region template when you want to contain content with a bracket UI.',
'',
'TITLE=YES',
'BUTTONS=YES',
'100% WIDTH=NO'))
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37729057076942158)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="breadcrumb-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div>#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'Breadcrumb Region'
,p_theme_id=>2
,p_theme_class_id=>6
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Use this region template to contain breadcrumb menus.  Breadcrumb menus are implemented using breadcrumbs.  Breadcrumb menus are designed to displayed in #REGION_POSITION_01#'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37729350898942158)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="borderless-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="bl-top">',
'    <div class="bl-title">#TITLE#</div>',
'    <div class="bl-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div>',
'  <div class="bl-body">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'Button Region with Title'
,p_theme_id=>2
,p_theme_class_id=>4
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37729679837942158)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="borderless-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="bl-top">',
'    <div class="bl-title">&nbsp;</div>',
'    <div class="bl-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div>',
'  <div class="bl-body">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'Button Region without Title'
,p_theme_id=>2
,p_theme_class_id=>17
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37729979920942159)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="rc-blue-top"><div class="rc-blue-top-r">',
'    <div class="rc-title">#TITLE#</div>',
'    <div class="rc-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r"><div class="rc-content-main">#BODY#</div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'Chart Region'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>2
,p_theme_class_id=>30
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37730280196942159)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="rc-blue-top"><div class="rc-blue-top-r">',
'    <div class="rc-title">#TITLE#</div>',
'    <div class="rc-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r"><div class="rc-content-main">#BODY#</div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'Form Region'
,p_plug_table_bgcolor=>'#f7f7e7'
,p_theme_id=>2
,p_theme_class_id=>8
,p_plug_heading_bgcolor=>'#f7f7e7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37730571378942159)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="hide-show-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="hide-show-top">',
'    <div class="hide-show-title">#TITLE#<a style="margin-left:5px;" href="javascript:hideShow(''region#REGION_SEQUENCE_ID#'',''shIMG#REGION_SEQUENCE_ID#'',''#IMAGE_PREFIX#themes/theme_2/rollup_plus_dgray.gif'',''#IMAGE_PREFIX#themes/theme_2/rollup_minus_dgr'
||'ay.gif'');" class="t1HideandShowRegionLink"><img src="#IMAGE_PREFIX#themes/theme_2/rollup_plus_dgray.gif" ',
'  id="shIMG#REGION_SEQUENCE_ID#" alt="" /></a></div>',
'    <div class="hide-show-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div>',
'  <div class="hide" id="region#REGION_SEQUENCE_ID#">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'Hide and Show Region'
,p_theme_id=>2
,p_theme_class_id=>1
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Gray Head, white body'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37730876781942159)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="rc-blue-top"><div class="rc-blue-top-r">',
'    <div class="rc-title">#TITLE#</div>',
'    <div class="rc-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r">',
'    <div class="rc-content-main">',
'      <div class="rc-image"><img src="#IMAGE_PREFIX#themes/theme_2/images/report_icon.png" alt="" /></div>',
'      <div class="rc-content">#BODY#</div>',
'    </div>',
'  </div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'List Region with Icon'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>2
,p_theme_class_id=>29
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37731179769942159)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="navigation-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div>',
'    <h3>#TITLE#</h3>',
'    #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'Navigation Region'
,p_theme_id=>2
,p_theme_class_id=>5
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37731455383942159)
,p_layout=>'TABLE'
,p_template=>'<div class="navigation-region-alt" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'Navigation Region, Alternative 1'
,p_theme_id=>2
,p_theme_class_id=>16
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37731779156942159)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="borderless-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="bl-body">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'Region without Buttons and Titles'
,p_theme_id=>2
,p_theme_class_id=>19
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37732060828942159)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="borderless-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="bl-top">',
'    <div class="bl-title">&nbsp;</div>',
'    <div class="bl-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div>',
'  <div class="bl-body">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'Region without Title'
,p_theme_id=>2
,p_theme_class_id=>11
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37732358507942160)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table class="apex_finderbar" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'<tbody>',
'<tr>',
'<td class="apex_finderbar_left_top" valign="top"><img src="#IMAGE_PREFIX#1px_trans.gif" width="10" height="8" alt=""  class="spacer" alt="" /></td>',
'<td class="apex_finderbar_middle" rowspan="3" valign="middle"><img src="#IMAGE_PREFIX#htmldb/builder/builder_find.png" /></td>',
'<td class="apex_finderbar_middle" rowspan="3" valign="middle" style="">#BODY#</td>',
'<td class="apex_finderbar_left" rowspan="3" width="10"><br /></td>',
'<td class="apex_finderbar_buttons" rowspan="3" valign="middle" nowrap="nowrap"><span class="apex_close">#CLOSE#</span><span>#EDIT##CHANGE##DELETE##CREATE##CREATE2##COPY##PREVIOUS##NEXT##EXPAND##HELP#</span></td>',
'</tr>',
'<tr><td class="apex_finderbar_left_middle"><br /></td></tr>',
'<tr>',
'<td class="apex_finderbar_left_bottom" valign="bottom"><img src="#IMAGE_PREFIX#1px_trans.gif" width="10" height="8"  class="spacer" alt="" /></td>',
'</tr>',
'</tbody>',
'</table>'))
,p_page_plug_template_name=>'Report Filter - Single Row'
,p_theme_id=>2
,p_theme_class_id=>31
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37732661305942160)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="rc-blue-top"><div class="rc-blue-top-r">',
'    <div class="rc-title">#TITLE#</div>',
'    <div class="rc-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r"><div class="rc-content-main">#BODY#</div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'Reports Region'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>2
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37732982587942160)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region float-left-100pct" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="rc-blue-top"><div class="rc-blue-top-r">',
'    <div class="rc-title">#TITLE#</div>',
'    <div class="rc-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r"><div class="rc-content-main">#BODY#</div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'Reports Region 100% Width'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>2
,p_theme_class_id=>13
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37733257652942160)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="rc-gray-top"><div class="rc-gray-top-r">',
'    <div class="rc-title">#TITLE#</div>',
'    <div class="rc-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r"><div class="rc-content-main">#BODY#</div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'Reports Region, Alternative 1'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>2
,p_theme_class_id=>10
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37733568335942160)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="sidebar-region" id="#REGION_STATIC_ID#">',
'  <h3>#TITLE#</h3>',
'  <div class="box">',
'    <div class="frame"><div class="content">#BODY#</div></div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'Sidebar Region'
,p_plug_table_bgcolor=>'#f7f7e7'
,p_theme_id=>2
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#f7f7e7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table border="0" cellpadding="0" cellspacing="0">',
'        <tr>',
'          <td rowspan="2" valign="top" width="4" bgcolor="#FF0000"><img src="#IMAGE_PREFIX#tl_img.gif" border="0" width="4" height="18" alt="" /></td>',
'          <td bgcolor="#000000" height="1"><img src="#IMAGE_PREFIX#stretch.gif" width="142" height="1" border="0" alt="" /></td>',
'          <td rowspan="2" valign="top" width="4" bgcolor="#FF0000"><img src="#IMAGE_PREFIX#tr_img.gif" border="0" width="4" height="18" alt="" /></td>',
'        </tr>',
'        <tr>',
'          <td bgcolor="#FF0000" height="16">',
'            <table border="0" cellpadding="0" cellspacing="0" width="100%">',
'              <tr>',
'                <td align=middle valign="top">',
'                  <div align="center">',
'                     <font color="#ffffff" face="Arial, Helvetica, sans-serif" size="1">',
'                      <b>#TITLE# </b></font></div>',
'                </td>',
'              </tr>',
'            </table>',
'          </td>',
'        </tr>',
'</table>',
'<table border="0" cellpadding="0" cellspacing="0">',
'   <tr>',
'   <td bgcolor="#000000" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>',
'   <td valign="top" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="146" height="1" border="0" alt="" /><br />',
'            <table border="0" cellpadding="1" cellspacing="0" width="146" summary="">',
'              <tr>',
'                <td colspan="2">',
'                  <table border="0" cellpadding="2" cellspacing="0" width="124" summary="">',
'                    <tr>',
'                      <td>&nbsp;</td>',
'                      <td valign="top" width="106">',
'                        <P><FONT face="arial, helvetica" size="1">',
'                            #BODY#',
'                           </font>',
'                        </P>',
'                      </td>',
'                    </tr>',
'                  </table>',
'            </table>',
'          </td>',
'          <td bgcolor="#000000" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>',
'          <td bgcolor="#9a9c9a" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>',
'          <td bgcolor="#b3b4b3" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>',
'        </tr>',
'      </table>',
'      <table border="0" cellpadding="0" cellspacing="0">',
'        <tr>',
'          <td rowspan="4" valign="top" width="4"><img src="#IMAGE_PREFIX#bl_img.gif" border="0" width="4" height="6" alt="" /></td>',
'          <td bgcolor="#ffffff" height="2"><img src="#IMAGE_PREFIX#stretch.gif" width="142" height="1" border="0" alt="" /></td>',
'          <td rowspan="4" valign="top" width="4"><img src="#IMAGE_PREFIX#br_img.gif" border="0" width="4" height="6" alt="" /></td>',
'        </tr>',
'        <tr>',
'          <td bgcolor="#000000" width="1"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>',
'        </tr>',
'        <tr>',
'          <td bgcolor="#9a9c9a" width="1"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>',
'        </tr>',
'        <tr>',
'          <td bgcolor="#b3b4b3" width="1" height="2"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>',
'        </tr>',
'</table>',
''))
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37733881250942160)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="sidebar-region-alt" id="#REGION_STATIC_ID#">',
'  <h3>#TITLE#</h3>',
'  <div class="box">',
'    <div class="frame"><div class="content">#BODY#</div></div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'Sidebar Region, Alternative 1'
,p_plug_table_bgcolor=>'#f7f7e7'
,p_theme_id=>2
,p_theme_class_id=>3
,p_plug_heading_bgcolor=>'#f7f7e7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37734154528942160)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="topbar" style="width:100%;clear:both;" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="topbar-top"><div class="topbar-top-r"></div></div>',
'  <div class="topbar-body"><div class="topbar-body-r"><div class="topbar-content">',
'      <div style="float:left">#BODY#</div>',
'      <div style="float:right"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</div>',
'   </div></div></div>',
'  <div class="topbar-bottom"><div class="topbar-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'Top Bar'
,p_theme_id=>2
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37734470328942160)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="rc-blue-top"><div class="rc-blue-top-r">',
'    <div class="rc-title">#TITLE#</div>',
'    <div class="rc-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r"><div class="rc-content-main">#BODY#</div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'Wizard Region'
,p_theme_id=>2
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(37734768643942160)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="rc-blue-top"><div class="rc-blue-top-r">',
'    <div class="rc-title">#TITLE#</div>',
'    <div class="rc-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r"><div class="rc-content-main">#BODY#</div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'Wizard Region with Icon'
,p_theme_id=>2
,p_theme_class_id=>20
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37718880644934603)
,p_list_template_current=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<button value="#TEXT#" onclick="#LINK#" class="button-alt1" type="button">',
'  <span>#TEXT#</span>',
'</button>'))
,p_list_template_noncurrent=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<button value="#TEXT#" onclick="#LINK#" class="button-alt3" type="button">',
'  <span>#TEXT#</span>',
'</button>'))
,p_list_template_name=>'Copy of Button List'
,p_theme_id=>101
,p_theme_class_id=>6
,p_list_template_before_rows=>'<div class="button-list">'
,p_list_template_after_rows=>'</div>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37719063144934606)
,p_list_template_current=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Copy of DHTML Tree'
,p_theme_id=>101
,p_theme_class_id=>23
,p_list_template_before_rows=>'<ul class="dhtmlTree">'
,p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>'
,p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#">'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_item_templ_noncurr_w_child=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_sub_templ_curr_w_child=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_sub_templ_noncurr_w_child=>'<li><a href="#LINK#">#TEXT#</a></li>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37719382409934606)
,p_list_template_current=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle" alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle"  alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Copy of Hierarchical Expanding'
,p_theme_id=>101
,p_theme_class_id=>22
,p_list_template_before_rows=>'<ul class="dhtmlTree">'
,p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>'
,p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" style="display:none;" class="dhtmlTree">'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle"  alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_sub_list_item_noncurrent=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif"  align="middle" alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" align="middle"  onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_item_templ_noncurr_w_child=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" align="middle"  onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_sub_templ_curr_w_child=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" align="middle" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_sub_templ_noncurr_w_child=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" align="middle" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37719651247934608)
,p_list_template_current=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="list-item-current">',
'  <div class="list-item-image"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ></div>',
'  <div class="list-item-label"><a href="#LINK#" class="current">#TEXT#</a></div>',
'</div>'))
,p_list_template_noncurrent=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="list-item">',
'  <div class="list-item-image"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ></div>',
'  <div class="list-item-label"><a href="#LINK#" class="current">#TEXT#</a></div>',
'</div>'))
,p_list_template_name=>'Copy of Horizontal Images with Label List'
,p_theme_id=>101
,p_theme_class_id=>4
,p_list_template_before_rows=>'<div class="horizontal-images-list">'
,p_list_template_after_rows=>'</div>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37719982220934609)
,p_list_template_current=>'<a href="#LINK#" class="current">#TEXT#</a>'
,p_list_template_noncurrent=>'<a href="#LINK#">#TEXT#</a>'
,p_list_template_name=>'Copy of Horizontal Links List'
,p_theme_id=>101
,p_theme_class_id=>3
,p_list_template_before_rows=>'<div class="horizontal-links-list">'
,p_list_template_after_rows=>'</div>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37720274366934609)
,p_list_template_current=>'<li class="dhtmlMenuItem"><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li class="dhtmlMenuItem"><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Copy of Pull Down Menu'
,p_theme_id=>101
,p_theme_class_id=>20
,p_list_template_before_rows=>'<ul class="dhtmlMenuLG2">'
,p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>'
,p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu2" style="display:none;">'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep2"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt="" class="dhtmlMenuSep2" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<li class="dhtmlMenuItem1"><a href="#LINK#">#TEXT#</a><img src="#IMAGE_PREFIX#themes/theme_1/images/menu-small.gif" alt="Expand" onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" />',
'</li>'))
,p_item_templ_noncurr_w_child=>'<li class="dhtmlMenuItem1"><a href="#LINK#">#TEXT#</a><img src="#IMAGE_PREFIX#themes/theme_1/images/menu-small.gif" alt="Expand" onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" /></li>'
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" /></a></li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" / ></a></li>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37720575882934609)
,p_list_template_current=>'<div class="dhtmlMenuItem"><a href="#LINK#" id="#LIST_ITEM_ID#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR#  /></a><img src="#IMAGE_PREFIX#menu/drop_down_nochild.png" width="20" height="128" alt="" /><a href="#LINK#" class="dhtmlBottom">#TEXT#</a><'
||'/div>'
,p_list_template_noncurrent=>'<div class="dhtmlMenuItem"><a href="#LINK#" id="#LIST_ITEM_ID#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR#  "/></a><img src="#IMAGE_PREFIX#menu/drop_down_nochild.png" width="20" height="128" alt="" /><a href="#LINK#" class="dhtmlBottom">#TEXT#</a>'
||'</div>'
,p_list_template_name=>'Copy of Pull Down Menu with Image'
,p_theme_id=>101
,p_theme_class_id=>21
,p_list_template_before_rows=>'<div class="dhtmlMenuLG">'
,p_list_template_after_rows=>'</div><br style="clear:both;"/><br style="clear:both;"/>'
,p_before_sub_list=>'<ul id="S#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu2" style="display:none;"><li class="dhtmlSubMenuP" onmouseover="dhtml_CloseAllSubMenusL(this)">#PARENT_TEXT#</li>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt=""  class="dhtmlMenuSep" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="dhtmlMenuItem"><a href="#LINK#" id="#LIST_ITEM_ID#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR#  /></a><img src="#IMAGE_PREFIX#menu/drop_down.png" width="20" height="128" alt="" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom3(thi'
||'s,''S#LIST_ITEM_ID#'',''#LIST_ITEM_ID#'',false)" />',
'<a href="#LINK#" class="dhtmlBottom">#TEXT#</a>',
'</div>'))
,p_item_templ_noncurr_w_child=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="dhtmlMenuItem"><a href="#LINK#" id="#LIST_ITEM_ID#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR#  /></a><img src="#IMAGE_PREFIX#menu/drop_down.png" width="20" height="128" alt=""  class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom3(th'
||'is,''S#LIST_ITEM_ID#'',''#LIST_ITEM_ID#'',false)" />',
'<a href="#LINK#" class="dhtmlBottom">#TEXT#</a>',
'</div>'))
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></li>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37720861551934609)
,p_list_template_current=>'<td><a href="#LINK#" onclick="qF(this,''#LINK#'');return false;" id="#A01#" class="htmldbButtonListCurrent" title="#TEXT_ESC_SC#">#TEXT#</a></td>'
,p_list_template_noncurrent=>'<td><a href="#LINK#" onclick="qF(this,''#LINK#'');return false;" id="#A01#"  class="htmldbButtonList" title="#TEXT_ESC_SC#">#TEXT#</a></td>'
,p_list_template_name=>'Copy of Region Display Selector'
,p_theme_id=>101
,p_theme_class_id=>16
,p_list_template_before_rows=>'<table class="htmldbButtonList" summary="" border="0" cellpadding="0" cellspacing="3" id="ql"><tr>'
,p_list_template_after_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</tr></table><script type="text/javascript">',
'apex.jQuery(document).ready(function(){propTest();});',
'</script>'))
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37721156081934609)
,p_list_template_current=>'<li class="active"><a href="#LINK#"><span>#TEXT#</span></a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#"><span>#TEXT#</span></a></li>'
,p_list_template_name=>'Copy of Tabbed Navigation List'
,p_theme_id=>101
,p_theme_class_id=>7
,p_list_template_before_rows=>'<ul class="tabbed-navigation-list">'
,p_list_template_after_rows=>'</ul>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37721479571934610)
,p_list_template_current=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="list-item-current">',
'  <div class="list-item-image"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ></div>',
'  <div class="list-item-label"><a href="#LINK#" class="current">#TEXT#</a></div>',
'</div>'))
,p_list_template_noncurrent=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="list-item">',
'  <div class="list-item-image"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ></div>',
'  <div class="list-item-label"><a href="#LINK#" class="current">#TEXT#</a></div>',
'</div>'))
,p_list_template_name=>'Copy of Vertical Images List'
,p_theme_id=>101
,p_theme_class_id=>5
,p_list_template_before_rows=>'<div class="vertical-images-list">'
,p_list_template_after_rows=>'</div>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37721770061934610)
,p_list_template_current=>'<li class="current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Copy of Vertical Ordered List'
,p_theme_id=>101
,p_theme_class_id=>2
,p_list_template_before_rows=>'<ol class="vertical-ordered-List">'
,p_list_template_after_rows=>'</ol>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37722057845934610)
,p_list_template_current=>'<li class="active"><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Copy of Vertical Sidebar List'
,p_theme_id=>101
,p_theme_class_id=>19
,p_list_template_before_rows=>'<ul class="vertical-sidebar-list">'
,p_list_template_after_rows=>'</ul>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37722367145934610)
,p_list_template_current=>'<li class="current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Copy of Vertical Unordered List with Bullets'
,p_theme_id=>101
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="vertical-unordered-list-with-bullets">'
,p_list_template_after_rows=>'</ul>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37722674024934610)
,p_list_template_current=>'<li class="current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Copy of Vertical Unordered List without Bullets'
,p_theme_id=>101
,p_theme_class_id=>18
,p_list_template_before_rows=>'<ul class="vertical-unordered-list-without-bullets">'
,p_list_template_after_rows=>'</ul>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37722950846934610)
,p_list_template_current=>'<li class="current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li class="non-current"><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Copy of Wizard Progress List'
,p_theme_id=>101
,p_theme_class_id=>17
,p_list_template_before_rows=>'<div class="wizard-progress-list"><ul>'
,p_list_template_after_rows=>'</ul></div>'
,p_between_items=>'<li class="progress-indicator">&nbsp;</li>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37735058470942160)
,p_list_template_current=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<button value="#TEXT#" onclick="#LINK#" class="button-alt1" type="button">',
'  <span>#TEXT#</span>',
'</button>'))
,p_list_template_noncurrent=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<button value="#TEXT#" onclick="#LINK#" class="button-gray" type="button">',
'  <span>#TEXT#</span>',
'</button>'))
,p_list_template_name=>'Button List'
,p_theme_id=>2
,p_theme_class_id=>6
,p_list_template_before_rows=>'<div class="button-list">'
,p_list_template_after_rows=>'</div>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37735373928942161)
,p_list_template_current=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'DHTML Tree'
,p_theme_id=>2
,p_theme_class_id=>23
,p_list_template_before_rows=>'<ul class="dhtmlTree">'
,p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>'
,p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#">'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_item_templ_noncurr_w_child=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_sub_templ_curr_w_child=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_sub_templ_noncurr_w_child=>'<li><a href="#LINK#">#TEXT#</a></li>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37735682102942161)
,p_list_template_current=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle" alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle"  alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Hierarchical Expanding'
,p_theme_id=>2
,p_theme_class_id=>22
,p_list_template_before_rows=>'<ul class="dhtmlTree">'
,p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>'
,p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" style="display:none;" class="dhtmlTree">'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle"  alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_sub_list_item_noncurrent=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif"  align="middle" alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" align="middle"  onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_item_templ_noncurr_w_child=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" align="middle"  onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_sub_templ_curr_w_child=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" align="middle" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_sub_templ_noncurr_w_child=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" align="middle" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37735982748942161)
,p_list_template_current=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="list-item-current">',
'  <div class="list-item-image"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ></div>',
'  <div class="list-item-label"><a href="#LINK#" class="current">#TEXT#</a></div>',
'</div>'))
,p_list_template_noncurrent=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="list-item">',
'  <div class="list-item-image"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ></div>',
'  <div class="list-item-label"><a href="#LINK#" class="current">#TEXT#</a></div>',
'</div>'))
,p_list_template_name=>'Horizontal Images with Label List'
,p_theme_id=>2
,p_theme_class_id=>4
,p_list_template_before_rows=>'<div class="horizontal-images-list">'
,p_list_template_after_rows=>'</div>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37736262175942161)
,p_list_template_current=>'<a href="#LINK#" class="current">#TEXT#</a>'
,p_list_template_noncurrent=>'<a href="#LINK#">#TEXT#</a>'
,p_list_template_name=>'Horizontal Links List'
,p_theme_id=>2
,p_theme_class_id=>3
,p_list_template_before_rows=>'<div class="horizontal-links-list">'
,p_list_template_after_rows=>'</div>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37736573511942162)
,p_list_template_current=>'<li class="dhtmlMenuItem"><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li class="dhtmlMenuItem"><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Pull Down Menu'
,p_theme_id=>2
,p_theme_class_id=>20
,p_list_template_before_rows=>'<ul class="dhtmlMenuLG2">'
,p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>'
,p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu2" style="display:none;">'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep2"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt="" class="dhtmlMenuSep2" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<li class="dhtmlMenuItem1"><a href="#LINK#">#TEXT#</a><img src="#IMAGE_PREFIX#themes/theme_13/menu_small.gif" alt="Expand" onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" />',
'</li>'))
,p_item_templ_noncurr_w_child=>'<li class="dhtmlMenuItem1"><a href="#LINK#">#TEXT#</a><img src="#IMAGE_PREFIX#themes/theme_13/menu_small.gif" alt="Expand" onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" /></li>'
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" /></a></li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" / ></a></li>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37736854607942162)
,p_list_template_current=>'<div class="dhtmlMenuItem"><a href="#LINK#" id="#LIST_ITEM_ID#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR#  /></a><img src="#IMAGE_PREFIX#menu/drop_down_nochild.png" width="20" height="128" alt="" /><a href="#LINK#" class="dhtmlBottom">#TEXT#</a><'
||'/div>'
,p_list_template_noncurrent=>'<div class="dhtmlMenuItem"><a href="#LINK#" id="#LIST_ITEM_ID#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR#  "/></a><img src="#IMAGE_PREFIX#menu/drop_down_nochild.png" width="20" height="128" alt="" /><a href="#LINK#" class="dhtmlBottom">#TEXT#</a>'
||'</div>'
,p_list_template_name=>'Pull Down Menu with Image'
,p_theme_id=>2
,p_theme_class_id=>21
,p_list_template_before_rows=>'<div class="dhtmlMenuLG">'
,p_list_template_after_rows=>'</div><br style="clear:both;"/><br style="clear:both;"/>'
,p_before_sub_list=>'<ul id="S#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu2" style="display:none;"><li class="dhtmlSubMenuP" onmouseover="dhtml_CloseAllSubMenusL(this)">#PARENT_TEXT#</li>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt=""  class="dhtmlMenuSep" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="dhtmlMenuItem"><a href="#LINK#" id="#LIST_ITEM_ID#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR#  /></a><img src="#IMAGE_PREFIX#menu/drop_down.png" width="20" height="128" alt="" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom3(thi'
||'s,''S#LIST_ITEM_ID#'',''#LIST_ITEM_ID#'',false)" />',
'<a href="#LINK#" class="dhtmlBottom">#TEXT#</a>',
'</div>'))
,p_item_templ_noncurr_w_child=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="dhtmlMenuItem"><a href="#LINK#" id="#LIST_ITEM_ID#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR#  /></a><img src="#IMAGE_PREFIX#menu/drop_down.png" width="20" height="128" alt=""  class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom3(th'
||'is,''S#LIST_ITEM_ID#'',''#LIST_ITEM_ID#'',false)" />',
'<a href="#LINK#" class="dhtmlBottom">#TEXT#</a>',
'</div>'))
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></li>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37737181024942162)
,p_list_template_current=>'<li class="active"><a href="#LINK#"><span>#TEXT#</span></a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#"><span>#TEXT#</span></a></li>'
,p_list_template_name=>'Tabbed Navigation List'
,p_theme_id=>2
,p_theme_class_id=>7
,p_list_template_before_rows=>'<ul class="tabbed-navigation-list">'
,p_list_template_after_rows=>'</ul>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37737475736942162)
,p_list_template_current=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="list-item-current">',
'  <div class="list-item-image"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ></div>',
'  <div class="list-item-label"><a href="#LINK#" class="current">#TEXT#</a></div>',
'</div>'))
,p_list_template_noncurrent=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="list-item">',
'  <div class="list-item-image"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ></div>',
'  <div class="list-item-label"><a href="#LINK#" class="current">#TEXT#</a></div>',
'</div>'))
,p_list_template_name=>'Vertical Images List'
,p_theme_id=>2
,p_theme_class_id=>5
,p_list_template_before_rows=>'<div class="vertical-images-list">'
,p_list_template_after_rows=>'</div>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37737777236942162)
,p_list_template_current=>'<li class="current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Vertical Ordered List'
,p_theme_id=>2
,p_theme_class_id=>2
,p_list_template_before_rows=>'<ol class="vertical-ordered-List">'
,p_list_template_after_rows=>'</ol>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37738063876942162)
,p_list_template_current=>'<li class="active"><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Vertical Sidebar List'
,p_theme_id=>2
,p_theme_class_id=>19
,p_list_template_before_rows=>'<ul class="vertical-sidebar-list">'
,p_list_template_after_rows=>'</ul>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37738356355942162)
,p_list_template_current=>'<li class="current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Vertical Unordered List with Bullets'
,p_theme_id=>2
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="vertical-unordered-list-with-bullets">'
,p_list_template_after_rows=>'</ul>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37738681915942162)
,p_list_template_current=>'<li class="current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Vertical Unordered List without Bullets'
,p_theme_id=>2
,p_theme_class_id=>18
,p_list_template_before_rows=>'<ul class="vertical-unordered-list-without-bullets">'
,p_list_template_after_rows=>'</ul>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(37738958189942162)
,p_list_template_current=>'<li class="current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li class="non-current"><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Wizard Progress List'
,p_theme_id=>2
,p_theme_class_id=>17
,p_list_template_before_rows=>'<div class="wizard-progress-list"><ul>'
,p_list_template_after_rows=>'</ul></div>'
,p_between_items=>'<li class="progress-indicator">&nbsp;</li>'
);
end;
/
prompt --application/shared_components/user_interface/templates/report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(37710755401483113)
,p_row_template_name=>'Standard'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="data">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
' <table cellpadding="0" border="0" cellspacing="0" summary="" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#">#TOP_PAGINATION#',
'<tr>',
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="report-standard">'))
,p_row_template_after_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
' </table><div class="CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="header">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_next_page_template=>'<a href="#LINK#" class="pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_4/paginate_next.gif" alt="Next"></a>'
,p_previous_page_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_4/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_4/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_4/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_row_style_checked=>'#ccc'
,p_theme_id=>101
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(37710755401483113)
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(37710852220483114)
,p_row_template_name=>'Standard, Alternating Row Colors'
,p_row_template1=>'<td class="data"#ALIGNMENT#>#COLUMN_VALUE#</td>'
,p_row_template2=>'<td class="dataalt"#ALIGNMENT#>#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table border="0" cellpadding="0" cellspacing="0" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#" class="report-holder">#TOP_PAGINATION#<tr><td>',
'<table border="0" cellpadding="0" cellspacing="0" class="report-standard-alternatingrowcolors" summary="" >'))
,p_row_template_after_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</table><div class="CSV">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th class="header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'ODD_ROW_NUMBERS'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'ODD_ROW_NUMBERS'
,p_next_page_template=>'<a href="#LINK#" class="pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_4/images/paginate_next.gif" alt="Next"></a>'
,p_previous_page_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_4/images/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_4/images/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_4/images/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_theme_id=>101
,p_theme_class_id=>5
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(37710852220483114)
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(37739277506942162)
,p_row_template_name=>'Borderless Report'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="data">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellpadding="0" border="0" cellspacing="0" summary="" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#">#TOP_PAGINATION#<tr>',
'<td><table class="report-borderless" cellpadding="0" border="0" cellspacing="0" summary="">'))
,p_row_template_after_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</table><div class="CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th class="header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_next_page_template=>'<a href="#LINK#" class="pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_2/paginate_next.gif" alt="Next"></a>'
,p_previous_page_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_2/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_2/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_2/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_row_style_checked=>'#ccc'
,p_theme_id=>2
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(37739277506942162)
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(37739753314942164)
,p_row_template_name=>'Fixed Column Headers'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="data" #COLUMN_WIDTH#><p #COLUMN_WIDTH#>#COLUMN_VALUE#</p></td>'
,p_row_template2=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="data-alt" #COLUMN_WIDTH#><p #COLUMN_WIDTH#>#COLUMN_VALUE#</p></td>'
,p_row_template_before_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table border="0" cellpadding="0" cellspacing="0" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#" class="report-holder">#TOP_PAGINATION#',
'<tr>',
'<td><div class="fixed-header-report"><table cellpadding="0" border="0" cellspacing="0" summary="">'))
,p_row_template_after_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</tbody></table></div><div class="CSV">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<thead>',
''))
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="header" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</thead>',
'<tbody>',
''))
,p_row_template_display_cond1=>'ODD_ROW_NUMBERS'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'ODD_ROW_NUMBERS'
,p_next_page_template=>'<a href="#LINK#" class="pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_2/paginate_next.gif" alt="Next"></a>'
,p_previous_page_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_2/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_2/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_2/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_row_style_checked=>'#ccc'
,p_theme_id=>2
,p_theme_class_id=>7
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(37739753314942164)
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(37740254973942164)
,p_row_template_name=>'Horizontal Border'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="data">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellpadding="0" border="0" cellspacing="0" summary="" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#">#TOP_PAGINATION#',
'<tr>',
'<td><table cellpadding="0" cellspacing="0" border="0" class="report-standard" summary="">'))
,p_row_template_after_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</table><div class="CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="header">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_next_page_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_2/paginate_next.gif" alt="Next"></a>',
''))
,p_previous_page_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_2/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_2/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_2/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_row_style_checked=>'#ccc'
,p_theme_id=>2
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(37740254973942164)
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(37740771214942164)
,p_row_template_name=>'One Column Unordered List'
,p_row_template1=>'<li>#COLUMN_VALUE#</li>'
,p_row_template_before_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellpadding="0" cellspacing="0" summary="" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#">',
'#TOP_PAGINATION#',
'<tr><td><ul class="t1OneColumnUnorderedList">'))
,p_row_template_after_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</ul><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td></tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_2/paginate_next.gif" alt="Next"></a>'
,p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_2/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_2/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_2/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_theme_id=>2
,p_theme_class_id=>3
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(37740771214942164)
,p_row_template_before_first=>'OMIT'
,p_row_template_after_last=>'OMIT'
);
exception when others then null;
end;
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(37741272369942164)
,p_row_template_name=>'Standard'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="data">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellpadding="0" border="0" cellspacing="0" summary="" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#">#TOP_PAGINATION#',
'<tr>',
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="report-standard">'))
,p_row_template_after_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</table><div class="CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="header">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_next_page_template=>'<a href="#LINK#" class="pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_2/paginate_next.gif" alt="Next"></a>'
,p_previous_page_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_2/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_2/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_2/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_row_style_checked=>'#ccc'
,p_theme_id=>2
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(37741272369942164)
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(37741759934942164)
,p_row_template_name=>'Standard, Alternating Row Colors'
,p_row_template1=>'<td class="data"#ALIGNMENT#>#COLUMN_VALUE#</td>'
,p_row_template2=>'<td class="dataalt"#ALIGNMENT#>#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table border="0" cellpadding="0" cellspacing="0" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#" class="report-holder">#TOP_PAGINATION#<tr><td>',
'<table border="0" cellpadding="0" cellspacing="0" class="report-standard-alternatingrowcolors" summary="" >'))
,p_row_template_after_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</table><div class="CSV">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th class="header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'ODD_ROW_NUMBERS'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'ODD_ROW_NUMBERS'
,p_next_page_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_2/images/paginate_next.gif" alt="Next"></a>',
''))
,p_previous_page_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_2/images/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_2/images/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_2/images/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_row_style_checked=>'#ccc'
,p_theme_id=>2
,p_theme_class_id=>5
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(37741759934942164)
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</tr>',
''))
);
exception when others then null;
end;
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(37742275720942164)
,p_row_template_name=>'Two Column Portlet'
,p_row_template1=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="report-row">',
'  <div class="report-col-hdr">#1#</div>',
'  <div class="report-col-val">#2#</div>',
'</div>'))
,p_row_template_before_rows=>'<div class="two-col-report-portlet" #REPORT_ATTRIBUTES# id="#REGION_ID#">'
,p_row_template_after_rows=>'</div>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>2
,p_theme_class_id=>7
,p_translate_this_template=>'N'
);
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(37742553069942164)
,p_row_template_name=>'Value Attribute Pairs'
,p_row_template1=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="report-row">',
'  <div class="report-col-hdr">#COLUMN_HEADER#</div>',
'  <div class="report-col-val">#COLUMN_VALUE#</div>',
'</div>'))
,p_row_template_before_rows=>'<div class="two-col-report-portlet">'
,p_row_template_after_rows=>'</div>'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>2
,p_theme_class_id=>6
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(35687125029751204)
,p_template_name=>'Optional with Spacing'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><span class="optional">'
,p_template_body2=>'&nbsp;&nbsp;&nbsp;</span></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>101
,p_theme_class_id=>3
,p_translate_this_template=>'N'
);
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(37718361251928950)
,p_template_name=>'Copy of No Label'
,p_template_body1=>'<span class="no-label">'
,p_template_body2=>'</span>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>101
,p_theme_class_id=>13
,p_translate_this_template=>'N'
);
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(37718475221928950)
,p_template_name=>'Copy of Optional'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><span class="optional">'
,p_template_body2=>'</span></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>101
,p_theme_class_id=>3
,p_translate_this_template=>'N'
);
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(37718564528928950)
,p_template_name=>'Copy of Optional with help'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><a class="optional-w-help" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>101
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(37718680898928950)
,p_template_name=>'Copy of Required'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><img src="#IMAGE_PREFIX#themes/theme_1/images/required.gif" alt="#VALUE_REQUIRED#" tabindex="999" /><span class="required">'
,p_template_body2=>'</span></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>101
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(37718780358928950)
,p_template_name=>'Copy of Required with help'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><img src="#IMAGE_PREFIX#themes/theme_1/images/required.gif" alt="#VALUE_REQUIRED#" tabindex="999" /><a class="required-w-help" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSI'
||'ON.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>101
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(37742861754942164)
,p_template_name=>'No Label'
,p_template_body1=>'<span class="no-label">'
,p_template_body2=>'</span>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>2
,p_theme_class_id=>13
,p_translate_this_template=>'N'
);
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(37742980538942165)
,p_template_name=>'Optional'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><span class="optional">'
,p_template_body2=>'</span></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>2
,p_theme_class_id=>3
,p_translate_this_template=>'N'
);
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(37743081064942165)
,p_template_name=>'Optional with help'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><a class="optional-w-help" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>2
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(37743175512942165)
,p_template_name=>'Required'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><img src="#IMAGE_PREFIX#themes/theme_2/images/required.gif" alt="#VALUE_REQUIRED#" tabindex="999" /><span class="required">'
,p_template_body2=>'</span></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>2
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(37743275991942165)
,p_template_name=>'Required with help'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><img src="#IMAGE_PREFIX#themes/theme_2/images/required.gif" alt="#VALUE_REQUIRED#" tabindex="999" /><a class="required-w-help" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSI'
||'ON.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>2
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(25944577388589282)
,p_name=>'OneEPA-breadcrumb1_old0127'
,p_before_first=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<br>',
'<p class="breadcrumb">'))
,p_current_page_option=>'» #NAME#'
,p_non_current_page_option=>'» <a href="#LINK#">#NAME#</a>'
,p_between_levels=>'&nbsp;'
,p_after_last=>'</p>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>101
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(31009000087660106)
,p_name=>'OneEPA-breadcrumb1'
,p_before_first=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<br>',
'<p class="breadcrumb">'))
,p_current_page_option=>'» #NAME#'
,p_non_current_page_option=>'» <a href="#LINK#">#NAME#</a>'
,p_between_levels=>'&nbsp;'
,p_after_last=>'</p>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>101
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(37718178435924515)
,p_name=>'Copy of Breadcrumb Menu'
,p_before_first=>'<div id="breadcrumbs"><ul id="breadcrumbs">'
,p_current_page_option=>'<li class="current">#NAME#</li>'
,p_non_current_page_option=>'<li class="noncurrent"><a href="#LINK#">#NAME#</a></li>'
,p_between_levels=>'&nbsp;'
,p_after_last=>'</ul></div>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>101
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(37718252158924516)
,p_name=>'Copy of Hierarchical Menu'
,p_before_first=>'<ul class="t1HierarchicalMenu">'
,p_current_page_option=>'<li class="t1current">#NAME#</li>'
,p_non_current_page_option=>'<li><a href="#LINK#">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>11
,p_start_with_node=>'CHILD_MENU'
,p_theme_id=>101
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(37743369110942165)
,p_name=>'Breadcrumb Menu'
,p_before_first=>'<div id="breadcrumbs"><ul class="breadcrumb-list">'
,p_current_page_option=>'<li class="current">#NAME#</li>'
,p_non_current_page_option=>'<li class="noncurrent"><a href="#LINK#">#NAME#</a></li>'
,p_between_levels=>'<li class="separator">&nbsp;</li>'
,p_after_last=>'</ul></div>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>2
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(37743453946942165)
,p_name=>'Hierarchical Menu'
,p_before_first=>'<ul class="t1HierarchicalMenu">'
,p_current_page_option=>'<li class="t1current">#NAME#</li>'
,p_non_current_page_option=>'<li><a href="#LINK#">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>11
,p_start_with_node=>'CHILD_MENU'
,p_theme_id=>2
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(37717965707901855)
,p_popup_icon=>'#IMAGE_PREFIX#list.gif'
,p_popup_icon_attr=>'width=13 height=13'
,p_page_name=>'winlov'
,p_page_title=>'Search Dialog'
,p_page_html_head=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#THEME_STYLE_CSS#',
'#APEX_JAVASCRIPT#',
'<link rel=stylesheet href=#IMAGE_PREFIX#platform2.css type=text/css>',
'',
'</head>'))
,p_page_body_attr=>'bgcolor=white OnLoad=first_field()'
,p_before_field_text=>' '
,p_page_heading_text=>'<link rel=stylesheet href=#IMAGE_PREFIX#platform2.css type=text/css><style>a:link { color:#336699; text-decoration:none; padding:2px;} a:visited { color:#336699; text-decoration:none;} a:hover { color:red; text-decoration:underline;} body { font-fami'
||'ly:arial; background-color:#ffffff;} </style>'
,p_page_footer_text=>'</center></td></tr></table>'
,p_filter_width=>'20'
,p_filter_max_width=>'100'
,p_find_button_text=>'Search'
,p_close_button_text=>'Close'
,p_next_button_text=>'Next'
,p_prev_button_text=>'Previous'
,p_after_field_text=>'</div><br />'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'400'
,p_height=>'450'
,p_result_row_x_of_y=>'Row(s) #FIRST_ROW# - #LAST_ROW#'
,p_result_rows_per_pg=>10
,p_translate_this_template=>'N'
);
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(37744179950942167)
,p_popup_icon=>'#IMAGE_PREFIX#htmldb/icons/view_small.gif'
,p_popup_icon_attr=>'width="18" height="18" alt="Popup Lov"'
,p_page_name=>'winlov'
,p_page_title=>'Search Dialog'
,p_page_html_head=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#THEME_STYLE_CSS#',
'#APEX_JAVASCRIPT#',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon"><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css">',
'',
'',
'</head>'))
,p_page_body_attr=>'onload="first_field()" style="margin:0;"'
,p_before_field_text=>'<div class="popup-head">'
,p_filter_width=>'20'
,p_filter_max_width=>'100'
,p_find_button_text=>'Search'
,p_close_button_text=>'Close'
,p_next_button_text=>'Next >'
,p_prev_button_text=>'< Previous'
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'400'
,p_height=>'450'
,p_result_row_x_of_y=>'<br /><div style="padding:2px; font-size:8pt;">Row(s) #FIRST_ROW# - #LAST_ROW#</div>'
,p_result_rows_per_pg=>500
,p_before_result_set=>'<div class="popup-body">'
,p_theme_id=>2
,p_theme_class_id=>1
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(37743550866942165)
,p_cal_template_name=>'Calendar'
,p_day_of_week_format=>'<th class="DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" class="CalendarHolder"> ',
' <tr>',
'   <td class="MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="0" class="Calendar">'
,p_month_close_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" class="WeekCalendarHolder">',
'<tr>',
'<td class="MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th class="DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="0" class="WeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th class="Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th class="DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" class="DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="0" summary="0" class="DayCalendar">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="Today">'
,p_daily_time_open_format=>'<th class="Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_cust_month_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" class="CalendarHolder"> ',
' <tr>',
'   <td class="MonthTitle">#WTITLE#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_cust_day_of_week_format=>'<th class="DayOfWeek">#IDAY#</th>'
,p_cust_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="0" class="Calendar">'
,p_cust_month_close_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_cust_week_open_format=>'<tr>'
,p_cust_week_close_format=>'</tr> '
,p_cust_day_title_format=>'<div class="DayTitle">#DD#</div>'
,p_cust_day_open_format=>'<td style="#COL_HEIGHT_PIX# #COL_HEIGHT_PER#" class="Day" valign="top">'
,p_cust_day_close_format=>'</td>'
,p_cust_today_open_format=>'<td style="#COL_HEIGHT_PIX# #COL_HEIGHT_PER#" valign="top" class="Today">'
,p_cust_nonday_title_format=>'<div class="NonDayTitle">#DD#</div>'
,p_cust_nonday_open_format=>'<td style="#COL_HEIGHT_PIX# #COL_HEIGHT_PER#" class="NonDay" valign="top">'
,p_cust_nonday_close_format=>'</td>'
,p_cust_weekend_title_format=>'<div class="WeekendDayTitle">#DD#</div>'
,p_cust_weekend_open_format=>'<td style="#COL_HEIGHT_PIX# #COL_HEIGHT_PER#" valign="top" class="WeekendDay">'
,p_cust_weekend_close_format=>'</td>'
,p_cust_hour_open_format=>'<tr>'
,p_cust_hour_close_format=>'</tr>'
,p_cust_time_title_format=>'#TIME#'
,p_cust_time_open_format=>'<th class="Hour">'
,p_cust_time_close_format=>'<br /></th>'
,p_cust_wk_month_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" class="WeekCalendarHolder">',
'<tr>',
'<td class="MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_cust_wk_day_of_week_format=>'<th class="DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_cust_wk_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="0" class="WeekCalendar">'
,p_cust_wk_month_close_format=>'</table></td></tr></table>'
,p_cust_wk_day_open_format=>'<td style="#COL_WIDTH_PIX# #COL_WIDTH_PER#" class="Day" valign="top">'
,p_cust_wk_day_close_format=>'<br /></td>'
,p_cust_wk_today_open_format=>'<td style="#COL_WIDTH_PIX# #COL_WIDTH_PER#" class="Today" valign="top">'
,p_cust_wk_weekend_open_format=>'<td style="#COL_WIDTH_PIX# #COL_WIDTH_PER#" valign="top" class="NonDay">'
,p_cust_wk_weekend_close_format=>'<br /></td>'
,p_cust_month_day_height_pix=>'75'
,p_cust_week_day_width_per=>'14'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>2
,p_theme_class_id=>1
);
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(37743774445942166)
,p_cal_template_name=>'Calendar, Alternative 1'
,p_day_of_week_format=>'<th valign="bottom" class="DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" class="CalendarAlternative1Holder"> ',
' <tr>',
'   <td class="MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="4" summary="0" class="CalendarAlternative1">'
,p_month_close_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="Day" valign="top" height="100" height="100">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="4" cellpadding="0" border="0" summary="" class="WeekCalendarAlternative1Holder">',
'<tr>',
'<td class="MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th class="DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="4" summary="0" class="WeekCalendarAlternative1">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th class="Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th class="DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="4" cellpadding="0" border="0" summary="" class="DayCalendarAlternative1Holder"> <tr><td class="MonthTitle">#IMONTH# #DD#, #YYYY#</td></tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="4" summary="0" class="DayCalendarAlternative1">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="Today">'
,p_daily_time_open_format=>'<th class="Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_cust_month_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" class="CalendarAlternative1Holder"> ',
' <tr>',
'   <td class="MonthTitle">#WTITLE#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_cust_day_of_week_format=>'<th valign="bottom" class="DayOfWeek">#IDAY#</th>'
,p_cust_month_open_format=>'<table border="0" cellpadding="0" cellspacing="4" summary="0" class="CalendarAlternative1">'
,p_cust_month_close_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_cust_week_open_format=>'<tr>'
,p_cust_week_close_format=>'</tr> '
,p_cust_day_title_format=>'<div class="DayTitle">#DD#</div>'
,p_cust_day_open_format=>'<td style="#COL_HEIGHT_PIX# #COL_HEIGHT_PER#" class="Day" valign="top" height="100" height="100">'
,p_cust_day_close_format=>'</td>'
,p_cust_today_open_format=>'<td style="#COL_HEIGHT_PIX# #COL_HEIGHT_PER#" valign="top" class="Today">'
,p_cust_nonday_title_format=>'<div class="NonDayTitle">#DD#</div>'
,p_cust_nonday_open_format=>'<td style="#COL_HEIGHT_PIX# #COL_HEIGHT_PER#" class="NonDay" valign="top">'
,p_cust_nonday_close_format=>'</td>'
,p_cust_weekend_title_format=>'<div class="WeekendDayTitle">#DD#</div>'
,p_cust_weekend_open_format=>'<td style="#COL_HEIGHT_PIX# #COL_HEIGHT_PER#" valign="top" class="WeekendDay">'
,p_cust_weekend_close_format=>'</td>'
,p_cust_hour_open_format=>'<tr>'
,p_cust_hour_close_format=>'</tr>'
,p_cust_time_title_format=>'#TIME#'
,p_cust_time_open_format=>'<th class="Hour">'
,p_cust_time_close_format=>'<br /></th>'
,p_cust_wk_month_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="4" cellpadding="0" border="0" summary="" class="WeekCalendarAlternative1Holder">',
'<tr>',
'<td class="MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_cust_wk_day_of_week_format=>'<th class="DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_cust_wk_month_open_format=>'<table border="0" cellpadding="0" cellspacing="4" summary="0" class="WeekCalendarAlternative1">'
,p_cust_wk_month_close_format=>'</table></td></tr></table>'
,p_cust_wk_day_open_format=>'<td style="#COL_WIDTH_PIX# #COL_WIDTH_PER#" class="Day" valign="top">'
,p_cust_wk_day_close_format=>'<br /></td>'
,p_cust_wk_today_open_format=>'<td style="#COL_WIDTH_PIX# #COL_WIDTH_PER#" class="Today" valign="top">'
,p_cust_wk_weekend_open_format=>'<td style="#COL_WIDTH_PIX# #COL_WIDTH_PER#" valign="top" class="NonDay">'
,p_cust_wk_weekend_close_format=>'<br /></td>'
,p_cust_month_day_height_pix=>'100'
,p_cust_week_day_width_pix=>'100'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>2
,p_theme_class_id=>2
);
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(37743968682942167)
,p_cal_template_name=>'Small Calendar'
,p_day_of_week_format=>'<th class="day-of-week">#DY#</th>'
,p_month_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="2" cellpadding="0" border="0" summary="" class="small-calendar-holder"> ',
' <tr>',
'   <td class="month-title">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="" class="small-calendar">'
,p_month_close_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>'))
,p_day_title_format=>'<div class="day-title">#DD#</div>'
,p_day_open_format=>'<td class="day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="weekend-day-title">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="weekend-day">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="non-day-title">#DD#</div>'
,p_nonday_open_format=>'<td class="non-day" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="2" cellpadding="0" border="0" summary="" class="SmallWeekCalendarHolder">',
'<tr>',
'<td class="MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th class="DayOfWeek">#DY#<br />#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="0" class="SmallWeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th class="Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th class="DayOfWeek">#DY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="2" cellpadding="0" border="0" summary="" class="SmallDayCalendarHolder"> <tr> <td class="MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="1" summary="0" class="SmallDayCalendar">'
,p_daily_month_close_format=>'</table></td></tr></table>'
,p_daily_day_open_format=>'<td valign="top" class="Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="Today">'
,p_daily_time_open_format=>'<th class="Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_cust_month_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="2" cellpadding="0" border="0" summary="" class="small-calendar-holder"> ',
' <tr>',
'   <td class="month-title">#WTITLE#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_cust_day_of_week_format=>'<th class="day-of-week">#DY#</th>'
,p_cust_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="" class="small-calendar">'
,p_cust_month_close_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>'))
,p_cust_week_open_format=>'<tr>'
,p_cust_week_close_format=>'</tr> '
,p_cust_day_title_format=>'<div class="day-title">#DD#</div>'
,p_cust_day_open_format=>'<td style="#COL_HEIGHT_PIX# #COL_HEIGHT_PER#" class="day" valign="top">'
,p_cust_day_close_format=>'</td>'
,p_cust_today_open_format=>'<td style="#COL_HEIGHT_PIX# #COL_HEIGHT_PER#" valign="top" class="today">'
,p_cust_nonday_title_format=>'<div class="non-day-title">#DD#</div>'
,p_cust_nonday_open_format=>'<td style="#COL_HEIGHT_PIX# #COL_HEIGHT_PER#" class="non-day" valign="top">'
,p_cust_nonday_close_format=>'</td>'
,p_cust_weekend_title_format=>'<div class="weekend-day-title">#DD#</div>'
,p_cust_weekend_open_format=>'<td style="#COL_HEIGHT_PIX# #COL_HEIGHT_PER#" valign="top" class="weekend-day">'
,p_cust_weekend_close_format=>'</td>'
,p_cust_hour_open_format=>'<tr>'
,p_cust_hour_close_format=>'</tr>'
,p_cust_time_title_format=>'#TIME#'
,p_cust_time_open_format=>'<th class="Hour">'
,p_cust_time_close_format=>'<br /></th>'
,p_cust_wk_month_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="2" cellpadding="0" border="0" summary="" class="SmallWeekCalendarHolder">',
'<tr>',
'<td class="MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_cust_wk_day_of_week_format=>'<th class="DayOfWeek">#DY#<br />#MM#/#DD#</th>'
,p_cust_wk_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="0" class="SmallWeekCalendar">'
,p_cust_wk_month_close_format=>'</table></td></tr></table>'
,p_cust_wk_day_open_format=>'<td style="#COL_WIDTH_PIX# #COL_WIDTH_PER#" class="Day" valign="top">'
,p_cust_wk_day_close_format=>'<br /></td>'
,p_cust_wk_today_open_format=>'<td style="#COL_WIDTH_PIX# #COL_WIDTH_PER#" class="t1Today" valign="top">'
,p_cust_wk_weekend_open_format=>'<td style="#COL_WIDTH_PIX# #COL_WIDTH_PER#" valign="top" class="NonDay">'
,p_cust_wk_weekend_close_format=>'<br /></td>'
,p_cust_month_day_height_pix=>'14'
,p_cust_month_day_height_per=>'14'
,p_cust_week_day_width_pix=>'40'
,p_cust_week_day_width_per=>'14'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>2
,p_theme_class_id=>3
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
wwv_flow_api.create_theme(
 p_id=>wwv_flow_api.id(37711053202483116)
,p_theme_id=>101
,p_theme_name=>'oneEPA'
,p_ui_type_name=>'DESKTOP'
,p_navigation_type=>'T'
,p_nav_bar_type=>'NAVBAR'
,p_is_locked=>false
,p_error_template=>wwv_flow_api.id(37710474362483110)
,p_printer_friendly_template=>wwv_flow_api.id(37710474362483110)
,p_default_page_transition=>'NONE'
,p_default_popup_transition=>'NONE'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_theme_file_prefix(101),'')
,p_css_file_urls=>'#IMAGE_PREFIX#legacy_ui/css/5.0#MIN#.css?v=#APEX_VERSION#'
);
wwv_flow_api.create_theme(
 p_id=>wwv_flow_api.id(37744367628942168)
,p_theme_id=>2
,p_theme_name=>'Builder Blue'
,p_ui_type_name=>'DESKTOP'
,p_navigation_type=>'T'
,p_nav_bar_type=>'NAVBAR'
,p_is_locked=>false
,p_default_page_template=>wwv_flow_api.id(37725567436942154)
,p_error_template=>wwv_flow_api.id(37725567436942154)
,p_printer_friendly_template=>wwv_flow_api.id(37726159973942155)
,p_breadcrumb_display_point=>'REGION_POSITION_01'
,p_sidebar_display_point=>'REGION_POSITION_02'
,p_login_template=>wwv_flow_api.id(37723274196942150)
,p_default_button_template=>wwv_flow_api.id(37727669919942156)
,p_default_region_template=>wwv_flow_api.id(37732661305942160)
,p_default_chart_template=>wwv_flow_api.id(37729979920942159)
,p_default_form_template=>wwv_flow_api.id(37730280196942159)
,p_default_reportr_template=>wwv_flow_api.id(37732661305942160)
,p_default_tabform_template=>wwv_flow_api.id(37732661305942160)
,p_default_wizard_template=>wwv_flow_api.id(37734470328942160)
,p_default_menur_template=>wwv_flow_api.id(37729057076942158)
,p_default_listr_template=>wwv_flow_api.id(37730876781942159)
,p_default_report_template=>wwv_flow_api.id(37741272369942164)
,p_default_label_template=>wwv_flow_api.id(37743081064942165)
,p_default_menu_template=>wwv_flow_api.id(37743369110942165)
,p_default_calendar_template=>wwv_flow_api.id(37743550866942165)
,p_default_list_template=>wwv_flow_api.id(37738356355942162)
,p_default_option_label=>wwv_flow_api.id(37743081064942165)
,p_default_required_label=>wwv_flow_api.id(37743275991942165)
,p_default_page_transition=>'NONE'
,p_default_popup_transition=>'NONE'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_theme_file_prefix(2),'')
,p_css_file_urls=>'#IMAGE_PREFIX#legacy_ui/css/5.0#MIN#.css?v=#APEX_VERSION#'
);
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_options
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
null;
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/globalization/translations
begin
null;
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
prompt --application/shared_components/globalization/dyntranslations
begin
null;
end;
/
prompt --application/shared_components/user_interface/shortcuts
begin
null;
end;
/
prompt --application/shared_components/security/authentications
begin
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(37099135068873772)
,p_name=>'No Authentication (using DAD)'
,p_scheme_type=>'NATIVE_DAD'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
);
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(37711154621483118)
,p_name=>'Application Express'
,p_scheme_type=>'NATIVE_APEX_ACCOUNTS'
,p_attribute_15=>'3552433650091224'
,p_invalid_session_type=>'URL'
,p_invalid_session_url=>'f?p=&APP_ID.:101:&SESSION.'
,p_logout_url=>'f?p=&APP_ID.:1'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_comments=>'Use internal Application Express account credentials and login page in this application.'
);
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(37711273086483118)
,p_name=>'DATABASE'
,p_scheme_type=>'NATIVE_DAD'
,p_attribute_15=>'3552552115091224'
,p_invalid_session_type=>'LOGIN'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_comments=>'Use database authentication (user identified by DAD).'
);
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(37711380597483118)
,p_name=>'DATABASE ACCOUNT'
,p_scheme_type=>'NATIVE_DB_ACCOUNTS'
,p_attribute_15=>'3552659626091224'
,p_invalid_session_type=>'URL'
,p_invalid_session_url=>'f?p=&APP_ID.:101:&SESSION.'
,p_logout_url=>'f?p=&APP_ID.:1'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_comments=>'Use database account credentials.'
);
end;
/
prompt --application/ui_types
begin
null;
end;
/
prompt --application/user_interfaces
begin
wwv_flow_api.create_user_interface(
 p_id=>wwv_flow_api.id(34223238802660366)
,p_ui_type_name=>'DESKTOP'
,p_display_name=>'Desktop'
,p_display_seq=>10
,p_use_auto_detect=>true
,p_is_default=>true
,p_theme_id=>101
,p_home_url=>'f?p=&APP_ID.:1:&SESSION.'
,p_nav_list_template_options=>'#DEFAULT#'
,p_include_legacy_javascript=>true
,p_include_jquery_migrate=>true
,p_nav_bar_type=>'NAVBAR'
,p_nav_bar_template_options=>'#DEFAULT#'
);
end;
/
prompt --application/user_interfaces/combined_files
begin
null;
end;
/
prompt --application/pages/page_00001
begin
wwv_flow_api.create_page(
 p_id=>1
,p_user_interface_id=>wwv_flow_api.id(34223238802660366)
,p_name=>'Dashboard'
,p_page_mode=>'NORMAL'
,p_step_title=>'Dashboard'
,p_step_sub_title_type=>'TEXT_WITH_SUBSTITUTIONS'
,p_first_item=>'NO_FIRST_ITEM'
,p_step_template=>wwv_flow_api.id(31007705311538595)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_chained=>'Y'
,p_overwrite_navigation_list=>'N'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_cache_mode=>'NOCACHE'
,p_cache_timeout_seconds=>21600
,p_last_updated_by=>'XJTURAKA'
,p_last_upd_yyyymmddhh24miss=>'20160208153947'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35552621125122873)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(37712576903483127)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(31009000087660106)
,p_plug_query_row_template=>1
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35747129960891184)
,p_plug_name=>'Chart Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>21
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35747639572912846)
,p_plug_name=>'Total Warehouse Results'
,p_parent_plug_id=>wwv_flow_api.id(35747129960891184)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>31
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_grid_column_span=>1
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:1:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:1:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_column_width=>'width="50%"'
,p_plug_header=>'<center>'
,p_plug_footer=>'</center>'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(35747841667912852)
,p_default_chart_type=>'3DColumn'
,p_chart_title=>'Total Warehouse Records'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1589120696520958'
,p_chart_width=>500
,p_chart_height=>350
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:N:N:N::V:Y:Circle:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'#B9E2F4,#63A9D5,#4E77A7'
,p_x_axis_label_font=>'Tahoma:10:#000000'
,p_y_axis_label_font=>'Tahoma:10:#000000'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:#000000'
,p_y_axis_title_font=>'Tahoma:14:#000000'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>#NO_DATA_MESSAGE#</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedVertical" name="chart_1589120696520958"> ',
'      <chart_settings>',
'        <title text_align="Center" position="Top" >',
'          <text>Total Warehouse Records Added in the Past 5 Years</text>',
'          <font family="Tahoma" size="12" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="left" enabled="false">',
'            <scale mode="Normal" />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'            <minor_grid enabled="False"/>            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'            <minor_grid enabled="False"/>            ',
'          </x_axis>          ',
'        </axes>',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Center">',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'        <line_series>',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Center">',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <line_style>',
'					   <line enabled="true" thickness="1" opacity="1" />',
'          </line_style>',
'          <marker_settings enabled="True" >',
'            <marker type="Circle" />',
'          </marker_settings>',
'        </line_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(36251942144243377)
,p_chart_id=>wwv_flow_api.id(35747841667912852)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null as link,',
'       act_start_year_date as label, ',
'       sum(result_count) as value  from state_year a, table(pkg_dynamic_list.get_years()) dt',
' where dt.column_value = a.act_start_year_date',
' group by act_start_year_date',
' order by 2'))
,p_series_type=>'Bar'
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35748130662967042)
,p_plug_name=>'Total Records By Type'
,p_parent_plug_id=>wwv_flow_api.id(35747129960891184)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>41
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_grid_column_span=>1
,p_plug_display_column=>2
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:1:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:1:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_column_width=>'width="50%"'
,p_plug_header=>'<center>'
,p_plug_footer=>'</center>'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(35748323083967045)
,p_default_chart_type=>'3DColumn'
,p_chart_title=>'Total Records By Type'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1589602112575151'
,p_chart_width=>500
,p_chart_height=>350
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:N:N:N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'#B9E2F4,#63A9D5,#4E77A7'
,p_x_axis_label_font=>'Tahoma:10:#000000'
,p_y_axis_label_font=>'Tahoma:10:#000000'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:#000000'
,p_y_axis_title_font=>'Tahoma:14:#000000'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for found.</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>Total Warehouse Records by Type</text>',
'           <font family="Tahoma" size="12" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(35748443349967047)
,p_chart_id=>wwv_flow_api.id(35748323083967045)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null as link,',
'       ''Biological'' as label,',
'       sum(biological_count) as value ',
'  from state_year',
' union',
'select null as link,',
'       ''Habitat'' as label,',
'       sum(habitat_count) as value ',
'  from state_year',
' union',
'select null as link,',
'       ''Physical/Chemical'' as label,',
'       sum(regular_count) as value ',
'  from state_year',
''))
,p_series_type=>'Bar'
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36296325220510642)
,p_plug_name=>'Report and Link Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>18
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<p>Welcome to the STORET Dashboard.  This site enables quick views into the STORET water quality data holdings as submitted by federal, state, and tribal agencies, watershed groups, universities, and industry.</p>',
'',
'<p>Select a view of interest using the buttons below.</p>',
''))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35553036494136787)
,p_plug_name=>'STORET Dashboard'
,p_parent_plug_id=>wwv_flow_api.id(36296325220510642)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>23
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_grid_column_span=>1
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<center>',
'<font family="Calibri"><b>Dashboard  Reports</b></font>',
'<br><br>',
'<table>',
'',
'<tr><td align="center" width="150"><input type="button" value="By Region" onclick="javascript:window.location.href=''f?p=&APP_ID.:5:&SESSION.:::5::''" class="button_field"><br><br>',
'</td>',
'<td align="center" width="150">',
'<input type="button" value="By State" onclick="javascript:window.location.href=''f?p=&APP_ID.:3:&SESSION.:::3::''" class="button_field"><br><br>',
'</td></tr>',
'',
'<tr><td align="center"><input type="button" value="By Tribes" onclick="javascript:window.location.href=''f?p=&APP_ID.:2:&SESSION.:::2::''" class="button_field"><br><br></td>',
'<td align="center"><input type="button" value="State Profile" onclick="javascript:window.location.href=''f?p=&APP_ID.:7:&SESSION.:::7::''" class="button_field"><br><br></td>',
'</tr>',
'',
'<tr>',
'<td align="center"><input type="button" value="All Orgs" onclick="javascript:window.location.href=''f?p=&APP_ID.:9:&SESSION.:::9::''" class="button_field"><br><br></td>',
'<td align="center"><input type="button" value="Top 10" onclick="javascript:window.location.href=''f?p=&APP_ID.:10:&SESSION.:::10::''" class="button_field"><br><br></td>',
'</tr>',
'',
'</table>',
'</center>',
'',
'',
'',
'',
'<!--',
'<center>',
'<font family="Tahoma"><b>Dashboard  Reports</b></font>',
'<br><br>',
'<table><tr><td align="left">',
'<a href="f?p=&APP_ID.:5:&SESSION.:::5::">Annual Data Submission by EPA Region</a><br>',
'</td></tr>',
'<tr><td align="left">',
'<a href="f?p=&APP_ID.:3:&SESSION.:::3::">Annual Data Submission by State',
'</a><br>',
'</td></tr>',
'<tr><td align="left">',
'<a href="f?p=&APP_ID.:7:&SESSION.:::7::">State Profile</a><br>',
'</td></tr>',
'<tr><td align="left">',
'<a href="f?p=&APP_ID.:9:&SESSION.:::9::">Data Owners Contribution</a><br>',
'</td></tr>',
'<tr><td align="left">',
'<a href="f?p=&APP_ID.:12:&SESSION.:::12::">Data Owners Contribution by Tribes</a><br>',
'</td></tr>',
'<tr><td align="left">',
'<a href="f?p=&APP_ID.:10:&SESSION.:::10::">Top 10 Substances for Recent 5 Years by State</a><br>',
'</td></tr></table>',
'</center>',
'-->'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_column_width=>'valign="middle" width="50%"'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36254051198501861)
,p_plug_name=>'Top 10 Warehouse Characteristics'
,p_parent_plug_id=>wwv_flow_api.id(36296325220510642)
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>25
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_grid_column_span=>1
,p_plug_display_column=>2
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select display_name,',
'       result_count',
'  from ( select display_name,',
'                sum(regular_count) as result_count,',
'                dense_rank() over (order by sum(regular_count) desc) rnk',
'           from state_char_year',
'          group by display_name )',
' where rnk <= 10',
' order by rnk'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_row_template=>1
,p_plug_column_width=>'valign="middle" width="50%"'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>'<span style="font-weight:bold;">Top 10 Warehouse Characteristics</span><br><br>'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(36254130827501861)
,p_name=>'Top Characteristics'
,p_max_row_count=>'1000000'
,p_max_row_count_message=>'The maximum row count for this report is #MAX_ROW_COUNT# rows.  Please apply a filter to reduce the number of records in your query.'
,p_no_data_found_message=>'No data found.'
,p_allow_report_saving=>'N'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_show_search_bar=>'N'
,p_show_search_textbox=>'N'
,p_show_actions_menu=>'N'
,p_report_list_mode=>'NONE'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_select_columns=>'N'
,p_show_rows_per_page=>'N'
,p_show_filter=>'N'
,p_show_sort=>'N'
,p_show_control_break=>'N'
,p_show_highlight=>'N'
,p_show_computation=>'N'
,p_show_aggregate=>'N'
,p_show_chart=>'N'
,p_show_group_by=>'N'
,p_show_pivot=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_show_reset=>'N'
,p_show_download=>'N'
,p_show_help=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'DSPOREA'
,p_internal_uid=>2095409856109967
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(36254333063501867)
,p_db_column_name=>'DISPLAY_NAME'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'Characteristic'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'DISPLAY_NAME'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(36254450371501870)
,p_db_column_name=>'RESULT_COUNT'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Result Count'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G990'
,p_tz_dependent=>'N'
,p_static_id=>'RESULT_COUNT'
);
wwv_flow_api.create_worksheet_rpt(
 p_id=>wwv_flow_api.id(36254551890502063)
,p_application_user=>'APXWS_DEFAULT'
,p_report_seq=>10
,p_report_alias=>'20959'
,p_status=>'PUBLIC'
,p_is_default=>'Y'
,p_display_rows=>15
,p_report_columns=>'DISPLAY_NAME:RESULT_COUNT'
,p_flashback_enabled=>'N'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(35646543492785111)
,p_computation_sequence=>10
,p_computation_item=>'F102_X_BREADCRUMB'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'1'
);
end;
/
prompt --application/pages/page_00002
begin
wwv_flow_api.create_page(
 p_id=>2
,p_user_interface_id=>wwv_flow_api.id(34223238802660366)
,p_name=>'Tribal Dashboard'
,p_page_mode=>'NORMAL'
,p_step_title=>'Tribal Dashboard'
,p_step_sub_title=>'Tribal Dashboard'
,p_step_sub_title_type=>'TEXT_WITH_SUBSTITUTIONS'
,p_first_item=>'NO_FIRST_ITEM'
,p_step_template=>wwv_flow_api.id(31007705311538595)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_chained=>'Y'
,p_overwrite_navigation_list=>'N'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_cache_mode=>'NOCACHE'
,p_cache_timeout_seconds=>21600
,p_last_updated_by=>'JTURAKA'
,p_last_upd_yyyymmddhh24miss=>'20151209120740'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36986625522541151)
,p_plug_name=>'Chart Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>21
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36986831830541151)
,p_plug_name=>'Total Warehouse Results'
,p_parent_plug_id=>wwv_flow_api.id(36986625522541151)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>31
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_grid_column_span=>1
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:1:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:1:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_column_width=>'width="50%"'
,p_plug_header=>'<center>'
,p_plug_footer=>'</center>'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(36987038609541153)
,p_default_chart_type=>'3DColumn'
,p_chart_title=>'Total Warehouse Records'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1589120696520958'
,p_chart_width=>500
,p_chart_height=>350
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:N:N:N::V:Y:Circle:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'#B9E2F4,#63A9D5,#4E77A7'
,p_x_axis_label_font=>'Tahoma:10:#000000'
,p_y_axis_label_font=>'Tahoma:10:#000000'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:#000000'
,p_y_axis_title_font=>'Tahoma:14:#000000'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>#NO_DATA_MESSAGE#</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedVertical" name="chart_1589120696520958"> ',
'      <chart_settings>',
'        <title text_align="Center" position="Top" >',
'          <text>Total Warehouse Records Added by Tribes in the Past 5 Years</text>',
'          <font family="Tahoma" size="12" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="left" enabled="false">',
'            <scale mode="Normal" />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'            <minor_grid enabled="False"/>            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'            <minor_grid enabled="False"/>            ',
'          </x_axis>          ',
'        </axes>',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Center">',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'        <line_series>',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Center">',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <line_style>',
'					   <line enabled="true" thickness="1" opacity="1" />',
'          </line_style>',
'          <marker_settings enabled="True" >',
'            <marker type="Circle" />',
'          </marker_settings>',
'        </line_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(36987149793541158)
,p_chart_id=>wwv_flow_api.id(36987038609541153)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null as link,',
'       act_start_year_date as label, ',
'       sum(result_count) as value  from tribal_state_year a, table(pkg_dynamic_list.get_years()) dt',
' where dt.column_value = a.act_start_year_date',
' group by act_start_year_date',
' order by 2'))
,p_series_type=>'Bar'
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36987249829541160)
,p_plug_name=>'Total Records By Type'
,p_parent_plug_id=>wwv_flow_api.id(36986625522541151)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>41
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_grid_column_span=>1
,p_plug_display_column=>2
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:1:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:1:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_column_width=>'width="50%"'
,p_plug_header=>'<center>'
,p_plug_footer=>'</center>'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(36987435802541160)
,p_default_chart_type=>'3DColumn'
,p_chart_title=>'Total Records By Type'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1589602112575151'
,p_chart_width=>500
,p_chart_height=>350
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:N:N:N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'#B9E2F4,#63A9D5,#4E77A7'
,p_x_axis_label_font=>'Tahoma:10:#000000'
,p_y_axis_label_font=>'Tahoma:10:#000000'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:#000000'
,p_y_axis_title_font=>'Tahoma:14:#000000'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for found.</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>Total Warehouse Records Added by Tribes by Type</text>',
'           <font family="Tahoma" size="12" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(36987547483541161)
,p_chart_id=>wwv_flow_api.id(36987435802541160)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null as link,',
'       ''Biological'' as label,',
'       sum(biological_count) as value ',
'  from tribal_state_year',
' union',
'select null as link,',
'       ''Habitat'' as label,',
'       sum(habitat_count) as value ',
'  from tribal_state_year',
' union',
'select null as link,',
'       ''Physical/Chemical'' as label,',
'       sum(regular_count) as value ',
'  from tribal_state_year',
''))
,p_series_type=>'Bar'
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36987644902541161)
,p_plug_name=>'Report and Link Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>18
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<p>Welcome to the STORET Dashboard. This site enables quick views into the STORET water quality data holdings as submitted by tribal agencies.</p>',
'',
'<p>Select a view of interest using the buttons below.</p>',
''))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36987831722541161)
,p_plug_name=>'STORET Dashboard'
,p_parent_plug_id=>wwv_flow_api.id(36987644902541161)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>23
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_grid_column_span=>1
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<center>',
'<font family="Tahoma"><b>Dashboard Reports</b></font>',
'<br><br>',
'<table>',
'',
'<tr>',
'<td align="center" width="150"><input type="button" value="By Region" onclick="javascript:window.location.href=''f?p=&APP_ID.:4:&SESSION.:::4::''" class="button_field"><br><br></td>',
'<td align="center"><input type="button" value="Tribal Profile" onclick="javascript:window.location.href=''f?p=&APP_ID.:6:&SESSION.:::6::''" class="button_field"><br><br></td>',
'</tr>',
'',
'<tr>',
'<td align="center"><input type="button" value="All Tribes" onclick="javascript:window.location.href=''f?p=&APP_ID.:11:&SESSION.:::11:P11_FROMPG:2''" class="button_field"><br><br></td>',
'<td align="center"><input type="button" value="Top 10" onclick="javascript:window.location.href=''f?p=&APP_ID.:14:&SESSION.:::14:P14_FROMPG:2''" class="button_field"><br><br></td>',
'</tr>',
'',
'</table>',
'</center>',
'',
'',
'',
'',
'<!--',
'<center>',
'<font family="Tahoma"><b>Dashboard Reports</b></font>',
'<br><br>',
'<table><tr><td align="left">',
'<a href="f?p=&APP_ID.:5:&SESSION.:::5::">Annual Data Submission by EPA Region</a><br>',
'</td></tr>',
'<tr><td align="left">',
'<a href="f?p=&APP_ID.:3:&SESSION.:::3::">Annual Data Submission by State',
'</a><br>',
'</td></tr>',
'<tr><td align="left">',
'<a href="f?p=&APP_ID.:7:&SESSION.:::7::">State Profile</a><br>',
'</td></tr>',
'<tr><td align="left">',
'<a href="f?p=&APP_ID.:9:&SESSION.:::9::">Data Owners Contribution</a><br>',
'</td></tr>',
'<tr><td align="left">',
'<a href="f?p=&APP_ID.:12:&SESSION.:::12::">Data Owners Contribution by Tribes</a><br>',
'</td></tr>',
'<tr><td align="left">',
'<a href="f?p=&APP_ID.:10:&SESSION.:::10::">Top 10 Substances for Recent 5 Years by State</a><br>',
'</td></tr></table>',
'</center>',
'-->'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_column_width=>'valign="middle" width="50%"'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36988024351541162)
,p_plug_name=>'Top Characteristics'
,p_parent_plug_id=>wwv_flow_api.id(36987644902541161)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>25
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_grid_column_span=>1
,p_plug_display_column=>2
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select display_name,',
'       result_count',
'  from ( select display_name,',
'                sum(regular_count) as result_count,',
'                dense_rank() over (order by sum(regular_count) desc) rnk',
'           from tribal_state_char_year',
'          group by display_name )',
' where rnk <= 10',
' order by rnk'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_row_template=>1
,p_plug_column_width=>'valign="middle" width="50%"'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<span style="font-weight:bold;">Top 10 Warehouse Characteristics</span><br><br>',
''))
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(36988234181541164)
,p_name=>'Top Characteristics'
,p_max_row_count=>'1000000'
,p_max_row_count_message=>'The maximum row count for this report is #MAX_ROW_COUNT# rows.  Please apply a filter to reduce the number of records in your query.'
,p_no_data_found_message=>'No data found.'
,p_allow_report_saving=>'N'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_show_search_bar=>'N'
,p_show_search_textbox=>'N'
,p_show_actions_menu=>'N'
,p_report_list_mode=>'NONE'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_select_columns=>'N'
,p_show_rows_per_page=>'N'
,p_show_filter=>'N'
,p_show_sort=>'N'
,p_show_control_break=>'N'
,p_show_highlight=>'N'
,p_show_computation=>'N'
,p_show_aggregate=>'N'
,p_show_chart=>'N'
,p_show_group_by=>'N'
,p_show_pivot=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_show_reset=>'N'
,p_show_download=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'DSPOREA'
,p_internal_uid=>2829513210149270
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(36988337107541167)
,p_db_column_name=>'DISPLAY_NAME'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'Characteristic'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'DISPLAY_NAME'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(36988427954541167)
,p_db_column_name=>'RESULT_COUNT'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Result Count'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G990'
,p_tz_dependent=>'N'
,p_static_id=>'RESULT_COUNT'
);
wwv_flow_api.create_worksheet_rpt(
 p_id=>wwv_flow_api.id(36988526217541167)
,p_application_user=>'APXWS_DEFAULT'
,p_report_seq=>10
,p_report_alias=>'28299'
,p_status=>'PUBLIC'
,p_is_default=>'Y'
,p_display_rows=>15
,p_report_columns=>'DISPLAY_NAME:RESULT_COUNT'
,p_flashback_enabled=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(37075327210138438)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>51
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(37712576903483127)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(31009000087660106)
,p_plug_query_row_template=>1
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(36988844320541170)
,p_computation_sequence=>10
,p_computation_item=>'F102_X_BREADCRUMB'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'1'
,p_compute_when_type=>'NEVER'
);
end;
/
prompt --application/pages/page_00003
begin
wwv_flow_api.create_page(
 p_id=>3
,p_user_interface_id=>wwv_flow_api.id(34223238802660366)
,p_name=>'Annual Data Submission by State'
,p_page_mode=>'NORMAL'
,p_step_title=>'Dashboard: Annual Data Submission by State'
,p_step_sub_title=>'Yearly Submission Completion by State'
,p_step_sub_title_type=>'TEXT_WITH_SUBSTITUTIONS'
,p_first_item=>'NO_FIRST_ITEM'
,p_html_page_header=>'<script src="#IMAGE_PREFIX#flashchart/anychart_6/js/AnyChart.js" type="text/javascript"></script>'
,p_javascript_code_onload=>'updateChartData();'
,p_step_template=>wwv_flow_api.id(31007705311538595)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_chained=>'Y'
,p_overwrite_navigation_list=>'N'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_cache_mode=>'NOCACHE'
,p_cache_timeout_seconds=>21600
,p_last_updated_by=>'JTURAKA'
,p_last_upd_yyyymmddhh24miss=>'20151209105916'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35555028805279251)
,p_plug_name=>'Yearly Submission Completion By State'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>31
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'DECLARE',
'   l_chart_scale    NUMBER;',
'   l_chart_value    NUMBER;',
'   l_chart_max      NUMBER;',
'   l_chart_pa       NUMBER;',
'   l_chart_ag       NUMBER;',
'   l_chart_title    VARCHAR2(1000);',
'   l_chart_label    VARCHAR2(1000);',
'   l_chart_plabel   VARCHAR2(1000);',
'   l_image_prefix   VARCHAR2(300);',
'   l_host           VARCHAR2(4000);',
'   l_XML            VARCHAR2(32767);',
'   l_idx            NUMBER;',
'   l_max            NUMBER;',
'BEGIN',
'',
'   l_image_prefix := V(''IMAGE_PREFIX'');',
'   l_host := OWA_UTIL.get_cgi_env (''REQUEST_PROTOCOL'') || ''://''  ',
'          || OWA_UTIL.get_cgi_env (''HTTP_HOST'')        || '':''  ',
'          || OWA_UTIL.get_cgi_env (''SERVER_PORT'')      || ''/''  ',
'          || REPLACE(OWA_UTIL.get_cgi_env (''SCRIPT_NAME''),''/'','''') || ''/'';',
'             ',
'   -- Create HTML table with div holders for the dynamic charts ',
'                      ',
'   htp.p(''<table cellspacing="20" cellpadding="0" border="0">'');',
'   ',
'   FOR c IN (',
'      select state_postal_code,',
'             rownum as idx',
'        from ( select st.state_postal_code',
'                 from di_geo_state st',
'                where country_code = ''US''',
'                  and ( epa_region_code = :P3_X_EPA_REGION or :P3_X_EPA_REGION = ''0'' )',
'                order by st.state_name )',
'   )',
'   LOOP',
'   ',
'      IF c.idx MOD 3 = 1',
'      THEN      ',
'         htp.p(''<tr>'');      ',
'      END IF;',
'   ',
'      htp.p(''<td><div id="my_rchart_'' || c.state_postal_code || ''"></div></td>'');',
'   ',
'      IF c.idx MOD 3 = 0',
'      THEN      ',
'         htp.p(''</tr>'');',
'      END IF;',
'      ',
'      l_idx := c.idx;',
'   ',
'   END LOOP;   ',
'   ',
'   IF l_idx MOD 3 > 0 THEN',
'',
'      FOR i IN l_idx + 1 .. l_idx + 3',
'      LOOP',
'',
'          IF i MOD 3 = 0',
'          THEN          ',
'             htp.p(''<td></td>'');',
'             htp.p(''</tr>'');',
'             exit;          ',
'          ELSE          ',
'             htp.p(''<td></td>'');',
'          END IF;',
'',
'      END LOOP; ',
'',
'   END IF;   ',
'',
'   htp.p(''</table>'');',
'   ',
'   -- Create chart objects with JavaScript ',
'',
'   htp.p(''<script type="text/javascript" language="javascript">'');',
'   FOR c IN (',
'      select state_postal_code,',
'             rownum as idx',
'        from ( select st.state_postal_code',
'                 from di_geo_state st',
'                where country_code = ''US''',
'                  and ( epa_region_code = :P3_X_EPA_REGION or :P3_X_EPA_REGION = ''0'' )',
'                order by st.state_name )',
'   )',
'   LOOP',
'      htp.p(''',
'        var c_'' || c.state_postal_code || '' = new AnyChart("'' || l_image_prefix || ''flashchart/anychart_6/swf/OracleAnyChart.swf"); ',
'        with(c_'' || c.state_postal_code || '') {     ',
'            width = "300";     ',
'            height = "250";   ',
'        } ',
'        with(c_'' || c.state_postal_code || ''.messages) {     ',
'            init = "Initializing..."; ',
'            loadingXML = "Loading data...";     ',
'            loadingResources = "Loading resources..."; ',
'            loadingTemplates = "Loading templates...";     ',
'            noData = "No data found."; ',
'            waitingForData = "Loading data. Please wait.";   ',
'        } ',
'        c_'' || c.state_postal_code || ''.write("my_rchart_'' || c.state_postal_code || ''"); '');',
'   END LOOP;',
'   htp.p(''</script>'');',
'   ',
'   -- Create JavaScript function to generate the chart data XML and load it',
'',
'   htp.p(''<script type="text/javascript" language="javascript">',
'      function updateChartData() { '');       ',
'',
'   FOR c IN (',
'',
'      select st.pk_isn,',
'             st.state_postal_code,',
'             st.state_name,',
'             nvl(x.total_count,0) as val,',
'             nvl(z.avg_5_yr,1) as max1,',
'             nvl(z.avg_5_yr,0) as max0',
'        from di_geo_state st,',
'             ( select /*+ DYNAMIC_SAMPLING(dt 5) */',
'                      fk_gen_geo_state, ',
'                      avg(result_count) as avg_5_yr,',
'                      avg(regular_count) as avg_5_yr_reg,',
'                      avg(habitat_count) as avg_5_yr_hab,',
'                      avg(biological_count) as avg_5_yr_bio                ',
'                 from state_year a, table(pkg_dynamic_list.get_years(:P3_X_YEAR - 1,5)) dt                ',
'                where dt.column_value = a.act_start_year_date',
'                group by fk_gen_geo_state ) z,',
'             ( select /*+ DYNAMIC_SAMPLING(dt 5) */',
'                      fk_gen_geo_state,',
'                      biological_count,',
'                      habitat_count,',
'                      regular_count,',
'                      result_count as total_count,',
'                      dt.column_value as activity_year',
'                 from state_year a,',
'                      table(pkg_dynamic_list.get_years(:P3_X_YEAR,1)) dt',
'                where dt.column_value = a.act_start_year_date ) x',
'       where st.pk_isn = z.fk_gen_geo_state (+)',
'         and st.pk_isn = x.fk_gen_geo_state (+)',
'         and st.country_code = ''US''',
'                  and ( st.epa_region_code = :P3_X_EPA_REGION or :P3_X_EPA_REGION = ''0'' )',
'       order by st.state_name',
'',
'   )',
'   LOOP',
'',
'      IF c.max1 > c.val THEN',
'         l_max := c.max1;',
'      ELSE',
'         l_max := c.val;',
'      END IF;   ',
'',
'      l_chart_scale := l_max / 4000;',
'      l_chart_value := c.val / 1000;',
'      l_chart_max := l_max / 1000;',
'      l_chart_pa := l_max / 3000;',
'      l_chart_ag := 2 * l_max / 3000;',
'      l_chart_title := c.state_name; ',
'      l_chart_plabel := ''In '' || :P3_X_YEAR || '': '' || trim(to_char(c.val,''999,999,999,999'')) || '' records'';',
'      l_chart_label := ''5 yr avg: '' || trim(to_char(round(c.max0),''999,999,999,999'')) || ''/yr'';',
'',
'      l_XML := ''<?xml version = "1.0" encoding="utf-8" standalone = "yes"?><anychart><settings><animation enabled="true"/><no_data show_waiting_animation="False"><label><text>No data submitted.</text><font family="Verdana" bold="yes" size="10"/></lab'
||'el></no_data></settings><gauges><gauge><chart_settings><title enabled="True" position="Top" padding="0"><font family="Verdana" bold="True" size="10"/><text>''',
'|| l_chart_title ||',
'''</text><actions><action type="NavigateToURL" url="f?p=&APP_ID.:7:&SESSION.:::7:P7_X_GEN_GEO_STATE,P7_X_YEAR:''',
'|| c.pk_isn || '','' || :P3_X_YEAR ||',
'''" target="_self"/></actions></title><chart_background><fill type="Solid" color="0xffffff" opacity="0" /><border enabled="false" /><corners type="Square" /></chart_background><data_plot_background /></chart_settings><circular><axis radius="37" start_'
||'angle="85" sweep_angle="190" size="3"><labels align="Outside" padding="6"><format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.}k]]></format></labels><scale minimum="0" maximum="'' ',
'        || l_chart_max || ',
'        ''" major_interval="'' ',
'        || l_chart_scale || ',
'        ''"/><scale_bar><fill color="#292929"/></scale_bar><major_tickmark align="Center" length="10" padding="0"/><minor_tickmark enabled="false"/><color_ranges><color_range start="0" end="'' ',
'        || l_chart_pa || ',
'        ''" align="Inside" start_size="60" end_size="60" padding="6" color="#B9E2F4"><border enabled="true" color="Black" opacity="0.4"/><label enabled="true" align="Inside" padding="34"><format><![CDATA[]]></format><position valign="Center" halign="C'
||'enter"/><font family="Verdana" bold="True" size="10"/></label><fill opacity="0.6"/></color_range><color_range start="'' ',
'        || l_chart_pa || ',
'        ''" end="'' ',
'        || l_chart_ag || ',
'        ''" align="Inside" start_size="60" end_size="60" padding="6" color="#63A9D5"><border enabled="true" color="Black" opacity="0.4"/><label enabled="true" align="Inside" padding="34"><format><![CDATA[]]></format><position valign="Center" halign="C'
||'enter"/><font family="Verdana" bold="True" size="10"/></label><fill opacity="0.6"/></color_range><color_range start="'' ',
'        || l_chart_ag || ',
'        ''" end="'' ',
'        || l_chart_max || ',
'        ''" align="Inside" start_size="60" end_size="60" padding="6" color="#4E77A7"><border enabled="true" color="Black" opacity="0.4"/><label enabled="true" align="Inside" padding="34"><format><![CDATA[]]></format><position valign="Center" halign="C'
||'enter"/><font family="Verdana" bold="True" size="10"/></label><fill opacity="0.6"/></color_range></color_ranges></axis><frame><inner_stroke enabled="false"/><outer_stroke enabled="false"/><background><fill type="Gradient"><gradient angle="45"><key co'
||'lor="#FDFDFD"/><key color="#F7F3F4"/></gradient></fill><border enabled="false"/></background><effects enabled="false"/></frame><pointers><pointer value="'' ',
'        || l_chart_value || ',
'        ''"><label enabled="true"><position placement_mode="ByPoint" x="50" y="120"/><format><![CDATA['' ',
'        || l_chart_plabel || ',
'        '']]></format><background enabled="false"/></label><actions><action type="NavigateToURL" url="f?p=&APP_ID.:7:&SESSION.:::7:P7_X_GEN_GEO_STATE,P7_X_YEAR:''',
'|| c.pk_isn || '','' || :P3_X_YEAR ||',
'''" target="_self"/></actions><needle_pointer_style thickness="7" point_thickness="5" point_radius="3"><fill color="Rgb(230,230,230)"/><border color="Black" opacity="0.7"/><effects enabled="true"><bevel enabled="true" distance="2" shadow_opacity="0.6"'
||' highlight_opacity="0.6"/><drop_shadow enabled="true" distance="1" blur_x="1" blur_y="1" opacity="0.4"/></effects><cap><background><fill type="Gradient"><gradient type="Linear" angle="45"><key color="#D3D3D3"/><key color="#6F6F6F"/></gradient></fill>'
||'<border color="Black" opacity="0.9"/></background><effects enabled="true"><bevel enabled="true" distance="2" shadow_opacity="0.6" highlight_opacity="0.6"/><drop_shadow enabled="true" distance="1.5" blur_x="2" blur_y="2" opacity="0.4"/></effects></cap'
||'></needle_pointer_style><animation enabled="true" start_time="0" duration="0.5" interpolation_type="Bounce"/></pointer></pointers><labels><label enabled="true"><position placement_mode="ByPoint" x="50" y="130"/><format><![CDATA['' ',
'|| l_chart_label || ',
''']]></format><background enabled="false"/></label></labels></circular></gauge></gauges></anychart>''; ',
'',
'      htp.p(''',
'        c_'' || c.state_postal_code || ''.setData('''''' || l_XML || ''''''); '');',
'',
'   END LOOP;',
'',
'   htp.p(''',
'        }',
'    </script>'');',
'',
'END;',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P3_X_EPA_REGION'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35555248184279256)
,p_plug_name=>'Search Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>11
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<p>These figures display the amount of data available within an EPA Region in the selected year by State. The number of records submitted in the selected year is compared to the number of records submitted to STORET over a five year average. The reco'
||'rds represent the data available in STORET on measurements of water quality as reported by ALL current organizations, including state, local, and tribal agencies and watershed groups.</p>',
'<p>Select a year and a Region using the dropdown menu. To view the organizations which submit data within the state, click on the figure.</p>'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35556024260279257)
,p_plug_name=>'Yearly Submission Completion by State'
,p_region_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_08'
,p_menu_id=>wwv_flow_api.id(37712576903483127)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(25853960577757693)
,p_plug_query_row_template=>1
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35557650673339593)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(37712576903483127)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(31009000087660106)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'bitand(:F102_X_BREADCRUMB,2) = 0'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(35555849621279257)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(35555248184279256)
,p_button_name=>'P3_GO'
,p_button_static_id=>'P3_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(27668368034614464)
,p_button_image_alt=>'Submit'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT'
,p_grid_new_grid=>false
,p_grid_new_row=>'Y'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35555638326279257)
,p_name=>'P3_1_0'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(35555248184279256)
,p_prompt=>'&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35558541678412626)
,p_name=>'P3_X_EPA_REGION'
,p_is_required=>true
,p_item_sequence=>5
,p_item_plug_id=>wwv_flow_api.id(35555248184279256)
,p_prompt=>'<strong>Select EPA Region:</strong>&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select epa_region_name,',
'       epa_region_code',
'  from di_epa_region',
' order by pk_isn'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'-SELECT-'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35603423993301612)
,p_name=>'P3_X_YEAR'
,p_is_required=>true
,p_item_sequence=>2
,p_item_plug_id=>wwv_flow_api.id(35555248184279256)
,p_prompt=>'<strong>Select Year:</strong>&nbsp;&nbsp;'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_char(sysdate,''YYYY'')',
'  from dual;'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_number(column_value) as n,',
'       to_number(column_value) as v',
'  from table(pkg_dynamic_list.get_years(null,to_number(to_char(sysdate,''YYYY'')) - 1899))',
' order by 1 desc;'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(35647943248917510)
,p_computation_sequence=>10
,p_computation_item=>'F102_X_BREADCRUMB'
,p_computation_point=>'BEFORE_HEADER'
,p_computation=>'bitand(nvl(:F102_X_BREADCRUMB,1) + 4 - bitand(nvl(:F102_X_BREADCRUMB,1),4),7)'
);
end;
/
prompt --application/pages/page_00004
begin
wwv_flow_api.create_page(
 p_id=>4
,p_user_interface_id=>wwv_flow_api.id(34223238802660366)
,p_name=>'Annual Data Submission by EPA Region'
,p_page_mode=>'NORMAL'
,p_step_title=>'Annual Data Submission by EPA Region'
,p_step_sub_title=>'Annual Data Submission by EPA Region-Tribal'
,p_step_sub_title_type=>'TEXT_WITH_SUBSTITUTIONS'
,p_first_item=>'NO_FIRST_ITEM'
,p_html_page_header=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!--<script src="#IMAGE_PREFIX#flashchart/anychart_5/js/AnyChart.js" type="text/javascript"></script>-->',
'<script type="text/javascript" src="#IMAGE_PREFIX#flashchart/anychart_6/js/AnyChart.js"></script>'))
,p_javascript_code_onload=>'updateChartData();'
,p_step_template=>wwv_flow_api.id(31007705311538595)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_chained=>'Y'
,p_overwrite_navigation_list=>'N'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_cache_mode=>'NOCACHE'
,p_cache_timeout_seconds=>21600
,p_last_updated_by=>'JHUMA'
,p_last_upd_yyyymmddhh24miss=>'20151209081535'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36993031743057216)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(37712576903483127)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(31009000087660106)
,p_plug_query_row_template=>1
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36993233154057219)
,p_plug_name=>'Select Year'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>11
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<p>These figures display the amount of data available within an EPA Region in the selected year (default to the current year). The number of records submitted in the selected year is compared to the number of records submitted to STORET over a five y'
||'ear average. The records represent the data available in STORET on measurements of water quality as reported by ALL current tribal agencies.</p>',
'<p>Select a year using the dropdown menu.</p>'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36994052299057226)
,p_plug_name=>'Yearly Submission Completion by Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>21
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'DECLARE',
'   l_chart_scale    NUMBER;',
'   l_chart_value    NUMBER;',
'   l_chart_max      NUMBER;',
'   l_chart_pa       NUMBER;',
'   l_chart_ag       NUMBER;',
'   l_chart_title    VARCHAR2(1000);',
'   l_chart_plabel   VARCHAR2(1000);',
'   l_chart_label    VARCHAR2(1000);',
'   l_image_prefix   VARCHAR2(300);',
'   l_host           VARCHAR2(4000);',
'   l_XML            VARCHAR2(32767);',
'   l_idx            NUMBER;',
'   l_max            NUMBER;',
'BEGIN',
'    ',
'   l_image_prefix := V(''IMAGE_PREFIX'');',
'   l_host := OWA_UTIL.get_cgi_env (''REQUEST_PROTOCOL'') || ''://''  ',
'          || OWA_UTIL.get_cgi_env (''HTTP_HOST'')        || '':''  ',
'          || OWA_UTIL.get_cgi_env (''SERVER_PORT'')      || ''/''  ',
'          || REPLACE(OWA_UTIL.get_cgi_env (''SCRIPT_NAME''),''/'','''') || ''/'';',
'',
'   -- Create HTML table with div holders for the dynamic charts ',
'                   ',
'   htp.p(''<table cellspacing="20" cellpadding="0" border="0">'');   ',
'   FOR c IN (',
'',
'      select epa_region_code,',
'             rownum idx',
'        from ( select st.epa_region_code',
'                 from di_epa_region st',
'                order by st.pk_isn )',
'',
'   )',
'   LOOP',
'   ',
'      IF c.idx MOD 3 = 1',
'      THEN      ',
'         htp.p(''<tr>'');      ',
'      END IF;',
'   ',
'      htp.p(''<td><div id="my_rchart_'' || c.epa_region_code || ''"></div></td>'');',
'   ',
'      IF c.idx MOD 3 = 0',
'      THEN      ',
'         htp.p(''</tr>'');      ',
'      END IF;',
'      ',
'      l_idx := c.idx;',
'   ',
'   END LOOP;',
'   ',
'   IF l_idx MOD 3 > 0 THEN',
'',
'      FOR i IN l_idx + 1 .. l_idx + 3',
'      LOOP',
'',
'          IF i MOD 3 = 0',
'          THEN          ',
'             htp.p(''<td></td>'');',
'             htp.p(''</tr>'');',
'             exit;          ',
'          ELSE          ',
'             htp.p(''<td></td>'');',
'          END IF;',
'',
'      END LOOP; ',
'',
'   END IF;   ',
'   ',
'   htp.p(''</table>'');',
'   ',
'   -- Create chart objects with JavaScript ',
'',
'   htp.p(''<script type="text/javascript" language="javascript">'');',
'   FOR c IN (',
'',
'      select epa_region_code,',
'             rownum idx',
'        from ( select st.epa_region_code',
'                 from di_epa_region st',
'                order by st.pk_isn )',
'',
'   )',
'   LOOP',
'      htp.p(''',
'        var c_'' || c.epa_region_code || '' = new AnyChart("'' || l_image_prefix || ''flashchart/anychart_6/swf/OracleAnyChart.swf"); ',
'        with(c_'' || c.epa_region_code || '') {     ',
'            width = "300";     ',
'            height = "250";   ',
'        } ',
'        with(c_'' || c.epa_region_code || ''.messages) {     ',
'            init = "Initializing..."; ',
'            loadingXML = "Loading data...";     ',
'            loadingResources = "Loading resources..."; ',
'            loadingTemplates = "Loading templates...";     ',
'            noData = "No data found."; ',
'            waitingForData = "Loading data. Please wait.";   ',
'        } ',
'        c_'' || c.epa_region_code || ''.write("my_rchart_'' || c.epa_region_code || ''"); '');',
'   END LOOP;',
'   htp.p(''</script>'');',
'   ',
'   -- Create JavaScript function to generate the chart data XML and load it',
'   ',
'   htp.p(''<script type="text/javascript" language="javascript">',
'      function updateChartData() { '');       ',
'',
'   FOR c IN (',
'',
'      select st.epa_region_code,',
'             ''Region '' || st.EPA_REGION_CODE epa_region_name,',
'             nvl(x.total_count,0) as val,',
'             nvl(z.avg_5_yr,1) as max1,',
'             nvl(z.avg_5_yr,0) as max0',
'        from di_epa_region st,',
'             ( SELECT epa_region_code,',
'                   AVG (sum_5_yr) AS avg_5_yr,',
'                   AVG (sum_5_yr_reg) AS avg_5_yr_reg,',
'                   AVG (sum_5_yr_hab) AS avg_5_yr_hab,',
'                   AVG (sum_5_yr_bio) AS avg_5_yr_bio',
'              FROM ( SELECT /*+ DYNAMIC_SAMPLING(dt 5) */',
'                            b.epa_region_code,',
'                            dt.column_value AS yr,',
'                            SUM (result_count) AS sum_5_yr,',
'                            SUM (regular_count) AS sum_5_yr_reg,',
'                            SUM (habitat_count) AS sum_5_yr_hab,',
'                            SUM (biological_count) AS sum_5_yr_bio',
'                       FROM tribal_state_year a,',
'                            di_geo_state b,',
'                            TABLE (pkg_dynamic_list.get_years(:P4_X_YEAR - 1,5)) dt',
'                      WHERE     dt.column_value = a.act_start_year_date',
'                            AND a.fk_gen_geo_state = b.pk_isn',
'                   GROUP BY b.epa_region_code, dt.column_value )',
'             GROUP BY epa_region_code ) z,',
'             ( select /*+ DYNAMIC_SAMPLING(dt 5) */',
'                      b.epa_region_code,',
'                      sum(biological_count) as biological_count,',
'                      sum(habitat_count) as habitat_count,',
'                      sum(regular_count) as regular_count,',
'                      sum(result_count) as total_count,',
'                      dt.column_value as activity_year',
'                 from tribal_state_year a,',
'                      di_geo_state b,',
'                      table(pkg_dynamic_list.get_years(:P4_X_YEAR,1)) dt',
'                where dt.column_value = a.act_start_year_date',
'                  and a.fk_gen_geo_state = b.pk_isn',
'                group by b.epa_region_code, dt.column_value ) x',
'       where st.epa_region_code = z.epa_region_code (+)',
'         and st.epa_region_code = x.epa_region_code (+)',
'       order by st.pk_isn',
'',
'   )',
'   LOOP',
'   ',
'      IF c.max1 > c.val THEN',
'         l_max := c.max1;',
'      ELSE',
'         l_max := c.val;',
'      END IF;   ',
'',
'      l_chart_scale := l_max / 4000;',
'      l_chart_value := c.val / 1000;',
'      l_chart_max := l_max / 1000;',
'      l_chart_pa := l_max / 3000;',
'      l_chart_ag := 2 * l_max / 3000;',
'      l_chart_title := c.epa_region_name; ',
'      l_chart_plabel := ''In '' || :P4_X_YEAR || '': '' || trim(to_char(c.val,''999,999,999,999'')) || '' records'';',
'      l_chart_label := ''5 yr avg: '' || trim(to_char(round(c.max0),''999,999,999,999'')) || ''/yr'';',
'',
'      l_XML := ''<?xml version = "1.0" encoding="utf-8" standalone = "yes"?><anychart><settings><animation enabled="true"/><no_data show_waiting_animation="False"><label><text>No data submitted.</text><font family="Verdana" bold="True" size="10"/></la'
||'bel></no_data></settings><gauges><gauge><chart_settings><title enabled="True" position="Top" padding="0"><font family="Verdana" bold="True" size="10"/><text>''',
'|| l_chart_title ||',
'''</text></title><chart_background><fill type="Solid" color="0xffffff" opacity="0" /><border enabled="false" /><corners type="Square" /></chart_background><data_plot_background /></chart_settings><circular><axis radius="37" start_angle="85" sweep_angl'
||'e="190" size="3"><labels align="Outside" padding="6"><format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.}k]]></format></labels><scale minimum="0" maximum="'' ',
'|| l_chart_max || ',
'''" major_interval="'' ',
'|| l_chart_scale || ',
'''"/><scale_bar><fill color="#292929"/></scale_bar><major_tickmark align="Center" length="10" padding="0"/><minor_tickmark enabled="false"/><color_ranges><color_range start="0" end="'' ',
'|| l_chart_pa || ',
'''" align="Inside" start_size="60" end_size="60" padding="6" color="#B9E2F4"><border enabled="true" color="Black" opacity="0.4"/><label enabled="true" align="Inside" padding="34"><format><![CDATA[]]></format><position valign="Center" halign="Center"/>'
||'<font family="Verdana" bold="True" size="10"/></label><fill opacity="0.6"/></color_range><color_range start="'' ',
'|| l_chart_pa || ',
'''" end="'' ',
'|| l_chart_ag || ',
'''" align="Inside" start_size="60" end_size="60" padding="6" color="#63A9D5"><border enabled="true" color="Black" opacity="0.4"/><label enabled="true" align="Inside" padding="34"><format><![CDATA[]]></format><position valign="Center" halign="Center"/>'
||'<font family="Verdana" bold="True" size="10"/></label><fill opacity="0.6"/></color_range><color_range start="'' ',
'|| l_chart_ag || ',
'''" end="'' ',
'|| l_chart_max || ',
'''" align="Inside" start_size="60" end_size="60" padding="6" color="#4E77A7"><border enabled="true" color="Black" opacity="0.4"/><label enabled="true" align="Inside" padding="34"><format><![CDATA[]]></format><position valign="Center" halign="Center"/>'
||'<font family="Verdana" bold="True" size="10"/></label><fill opacity="0.6"/></color_range></color_ranges></axis><frame><inner_stroke enabled="false"/><outer_stroke enabled="false"/><background><fill type="Gradient"><gradient angle="45"><key color="#FD'
||'FDFD"/><key color="#F7F3F4"/></gradient></fill><border enabled="false"/></background><effects enabled="false"/></frame><pointers><pointer value="'' ',
'|| l_chart_value || ',
'''"><label enabled="true"><position placement_mode="ByPoint" x="50" y="120"/><format><![CDATA['' ',
'|| l_chart_plabel || ',
''']]></format><background enabled="false"/></label><needle_pointer_style thickness="7" point_thickness="5" point_radius="3"><fill color="Rgb(230,230,230)"/><border color="Black" opacity="0.7"/><effects enabled="true"><bevel enabled="true" distance="2"'
||' shadow_opacity="0.6" highlight_opacity="0.6"/><drop_shadow enabled="true" distance="1" blur_x="1" blur_y="1" opacity="0.4"/></effects><cap><background><fill type="Gradient"><gradient type="Linear" angle="45"><key color="#D3D3D3"/><key color="#6F6F6F'
||'"/></gradient></fill><border color="Black" opacity="0.9"/></background><effects enabled="true"><bevel enabled="true" distance="2" shadow_opacity="0.6" highlight_opacity="0.6"/><drop_shadow enabled="true" distance="1.5" blur_x="2" blur_y="2" opacity="'
||'0.4"/></effects></cap></needle_pointer_style><animation enabled="true" start_time="0" duration="0.5" interpolation_type="Bounce"/></pointer></pointers><labels><label enabled="true"><position placement_mode="ByPoint" x="50" y="130"/><format><![CDATA['''
||' ',
'|| l_chart_label || ',
''']]></format><background enabled="false"/></label></labels></circular></gauge></gauges></anychart>''; ',
'',
'      htp.p(''',
'        c_'' || c.epa_region_code || ''.setData('''''' || l_XML || ''''''); '');',
'',
'   END LOOP;',
'',
'   htp.p(''',
'        }',
'    </script>'');',
'',
'END;',
' '))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(36993629675057225)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(36993233154057219)
,p_button_name=>'P4_GO'
,p_button_static_id=>'P4_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(27668368034614464)
,p_button_image_alt=>'Submit'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT'
,p_grid_new_grid=>false
,p_grid_new_row=>'Y'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36993446297057221)
,p_name=>'P4_X_YEAR'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(36993233154057219)
,p_prompt=>'<strong>Select Year:</strong>&nbsp;&nbsp;'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_char(sysdate,''YYYY'')',
'  from dual;'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_number(column_value) as n,',
'       to_number(column_value) as v',
'  from table(pkg_dynamic_list.get_years(null,to_number(to_char(sysdate,''YYYY'')) - 1899))',
' order by 1 desc;'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36993837872057225)
,p_name=>'P4_1_0'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(36993233154057219)
,p_prompt=>'&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(36994327286057230)
,p_computation_sequence=>10
,p_computation_item=>'F102_X_BREADCRUMB'
,p_computation_point=>'BEFORE_HEADER'
,p_computation=>'bitand(nvl(:F102_X_BREADCRUMB,1) + 2 - bitand(nvl(:F102_X_BREADCRUMB,1),2),3)'
,p_compute_when_type=>'NEVER'
);
end;
/
prompt --application/pages/page_00005
begin
wwv_flow_api.create_page(
 p_id=>5
,p_user_interface_id=>wwv_flow_api.id(34223238802660366)
,p_name=>'Annual Data Submission by EPA Region'
,p_page_mode=>'NORMAL'
,p_step_title=>'Dashboard: Annual Data Submission by EPA Region'
,p_step_sub_title_type=>'TEXT_WITH_SUBSTITUTIONS'
,p_first_item=>'NO_FIRST_ITEM'
,p_html_page_header=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!--<script src="#IMAGE_PREFIX#flashchart/anychart_5/js/AnyChart.js" type="text/javascript"></script>-->',
'<script type="text/javascript" src="#IMAGE_PREFIX#flashchart/anychart_6/js/AnyChart.js"></script>'))
,p_javascript_code_onload=>'updateChartData();'
,p_step_template=>wwv_flow_api.id(31007705311538595)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_chained=>'Y'
,p_overwrite_navigation_list=>'N'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_cache_mode=>'NOCACHE'
,p_cache_timeout_seconds=>21600
,p_last_updated_by=>'JHUMA'
,p_last_upd_yyyymmddhh24miss=>'20151209082348'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35509932280335255)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(37712576903483127)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(31009000087660106)
,p_plug_query_row_template=>1
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35512421384445665)
,p_plug_name=>'Yearly Submission Completion by Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>21
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'DECLARE',
'   l_chart_scale    NUMBER;',
'   l_chart_value    NUMBER;',
'   l_chart_max      NUMBER;',
'   l_chart_pa       NUMBER;',
'   l_chart_ag       NUMBER;',
'   l_chart_title    VARCHAR2(1000);',
'   l_chart_plabel   VARCHAR2(1000);',
'   l_chart_label    VARCHAR2(1000);',
'   l_image_prefix   VARCHAR2(300);',
'   l_host           VARCHAR2(4000);',
'   l_XML            VARCHAR2(32767);',
'   l_idx            NUMBER;',
'   l_max            NUMBER;',
'BEGIN',
'    ',
'   l_image_prefix := V(''IMAGE_PREFIX'');',
'   l_host := OWA_UTIL.get_cgi_env (''REQUEST_PROTOCOL'') || ''://''  ',
'          || OWA_UTIL.get_cgi_env (''HTTP_HOST'')        || '':''  ',
'          || OWA_UTIL.get_cgi_env (''SERVER_PORT'')      || ''/''  ',
'          || REPLACE(OWA_UTIL.get_cgi_env (''SCRIPT_NAME''),''/'','''') || ''/'';',
'',
'   -- Create HTML table with div holders for the dynamic charts ',
'                   ',
'   htp.p(''<table cellspacing="20" cellpadding="0" border="0">'');   ',
'   FOR c IN (',
'',
'      select epa_region_code,',
'             rownum idx',
'        from ( select st.epa_region_code',
'                 from di_epa_region st',
'                order by st.pk_isn )',
'',
'   )',
'   LOOP',
'   ',
'      IF c.idx MOD 3 = 1',
'      THEN      ',
'         htp.p(''<tr>'');      ',
'      END IF;',
'   ',
'      htp.p(''<td><div id="my_rchart_'' || c.epa_region_code || ''"></div></td>'');',
'   ',
'      IF c.idx MOD 3 = 0',
'      THEN      ',
'         htp.p(''</tr>'');      ',
'      END IF;',
'      ',
'      l_idx := c.idx;',
'   ',
'   END LOOP;',
'   ',
'   IF l_idx MOD 3 > 0 THEN',
'',
'      FOR i IN l_idx + 1 .. l_idx + 3',
'      LOOP',
'',
'          IF i MOD 3 = 0',
'          THEN          ',
'             htp.p(''<td></td>'');',
'             htp.p(''</tr>'');',
'             exit;          ',
'          ELSE          ',
'             htp.p(''<td></td>'');',
'          END IF;',
'',
'      END LOOP; ',
'',
'   END IF;   ',
'   ',
'   htp.p(''</table>'');',
'   ',
'   -- Create chart objects with JavaScript ',
'',
'   htp.p(''<script type="text/javascript" language="javascript">'');',
'   FOR c IN (',
'',
'      select epa_region_code,',
'             rownum idx',
'        from ( select st.epa_region_code',
'                 from di_epa_region st',
'                order by st.pk_isn )',
'',
'   )',
'   LOOP',
'      htp.p(''',
'        var c_'' || c.epa_region_code || '' = new AnyChart("'' || l_image_prefix || ''flashchart/anychart_6/swf/OracleAnyChart.swf"); ',
'        with(c_'' || c.epa_region_code || '') {     ',
'            width = "300";     ',
'            height = "250";   ',
'        } ',
'        with(c_'' || c.epa_region_code || ''.messages) {     ',
'            init = "Initializing..."; ',
'            loadingXML = "Loading data...";     ',
'            loadingResources = "Loading resources..."; ',
'            loadingTemplates = "Loading templates...";     ',
'            noData = "No data found."; ',
'            waitingForData = "Loading data. Please wait.";   ',
'        } ',
'        c_'' || c.epa_region_code || ''.write("my_rchart_'' || c.epa_region_code || ''"); '');',
'   END LOOP;',
'   htp.p(''</script>'');',
'   ',
'   -- Create JavaScript function to generate the chart data XML and load it',
'   ',
'   htp.p(''<script type="text/javascript" language="javascript">',
'      function updateChartData() { '');       ',
'',
'   FOR c IN (',
'',
'      select st.epa_region_code,',
'             st.epa_region_name,',
'             nvl(x.total_count,0) as val,',
'             nvl(z.avg_5_yr,1) as max1,',
'             nvl(z.avg_5_yr,0) as max0',
'        from di_epa_region st,',
'             ( SELECT epa_region_code,',
'                   AVG (sum_5_yr) AS avg_5_yr,',
'                   AVG (sum_5_yr_reg) AS avg_5_yr_reg,',
'                   AVG (sum_5_yr_hab) AS avg_5_yr_hab,',
'                   AVG (sum_5_yr_bio) AS avg_5_yr_bio',
'              FROM ( SELECT /*+ DYNAMIC_SAMPLING(dt 5) */',
'                            b.epa_region_code,',
'                            dt.column_value AS yr,',
'                            SUM (result_count) AS sum_5_yr,',
'                            SUM (regular_count) AS sum_5_yr_reg,',
'                            SUM (habitat_count) AS sum_5_yr_hab,',
'                            SUM (biological_count) AS sum_5_yr_bio',
'                       FROM state_year a,',
'                            di_geo_state b,',
'                            TABLE (pkg_dynamic_list.get_years(:P5_X_YEAR - 1,5)) dt',
'                      WHERE     dt.column_value = a.act_start_year_date',
'                            AND a.fk_gen_geo_state = b.pk_isn',
'                   GROUP BY b.epa_region_code, dt.column_value )',
'             GROUP BY epa_region_code ) z,',
'             ( select /*+ DYNAMIC_SAMPLING(dt 5) */',
'                      b.epa_region_code,',
'                      sum(biological_count) as biological_count,',
'                      sum(habitat_count) as habitat_count,',
'                      sum(regular_count) as regular_count,',
'                      sum(result_count) as total_count,',
'                      dt.column_value as activity_year',
'                 from state_year a,',
'                      di_geo_state b,',
'                      table(pkg_dynamic_list.get_years(:P5_X_YEAR,1)) dt',
'                where dt.column_value = a.act_start_year_date',
'                  and a.fk_gen_geo_state = b.pk_isn',
'                group by b.epa_region_code, dt.column_value ) x',
'       where st.epa_region_code = z.epa_region_code (+)',
'         and st.epa_region_code = x.epa_region_code (+)',
'       order by st.pk_isn',
'',
'   )',
'   LOOP',
'   ',
'      IF c.max1 > c.val THEN',
'         l_max := c.max1;',
'      ELSE',
'         l_max := c.val;',
'      END IF;   ',
'',
'      l_chart_scale := l_max / 4000;',
'      l_chart_value := c.val / 1000;',
'      l_chart_max := l_max / 1000;',
'      l_chart_pa := l_max / 3000;',
'      l_chart_ag := 2 * l_max / 3000;',
'      l_chart_title := c.epa_region_name; ',
'      l_chart_plabel := ''In '' || :P5_X_YEAR || '': '' || trim(to_char(c.val,''999,999,999,999'')) || '' records'';',
'      l_chart_label := ''5 yr avg: '' || trim(to_char(round(c.max0),''999,999,999,999'')) || ''/yr'';',
'',
'      l_XML := ''<?xml version = "1.0" encoding="utf-8" standalone = "yes"?><anychart><settings><animation enabled="true"/><no_data show_waiting_animation="False"><label><text>No data submitted.</text><font family="Verdana" bold="True" size="10"/></la'
||'bel></no_data></settings><gauges><gauge><chart_settings><title enabled="True" position="Top" padding="0"><font family="Verdana" bold="True" size="10"/><text>''',
'|| l_chart_title ||',
'''</text><actions><action type="NavigateToURL" url="f?p=&APP_ID.:3:&SESSION.:::3:P3_X_EPA_REGION,P3_X_YEAR:''',
'|| c.epa_region_code || '','' || :P5_X_YEAR ||',
'''" target="_self"/></actions></title><chart_background><fill type="Solid" color="0xffffff" opacity="0" /><border enabled="false" /><corners type="Square" /></chart_background><data_plot_background /></chart_settings><circular><axis radius="37" start_'
||'angle="85" sweep_angle="190" size="3"><labels align="Outside" padding="6"><format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.}k]]></format></labels><scale minimum="0" maximum="'' ',
'|| l_chart_max || ',
'''" major_interval="'' ',
'|| l_chart_scale || ',
'''"/><scale_bar><fill color="#292929"/></scale_bar><major_tickmark align="Center" length="10" padding="0"/><minor_tickmark enabled="false"/><color_ranges><color_range start="0" end="'' ',
'|| l_chart_pa || ',
'''" align="Inside" start_size="60" end_size="60" padding="6" color="#B9E2F4"><border enabled="true" color="Black" opacity="0.4"/><label enabled="true" align="Inside" padding="34"><format><![CDATA[]]></format><position valign="Center" halign="Center"/>'
||'<font family="Verdana" bold="True" size="10"/></label><fill opacity="0.6"/></color_range><color_range start="'' ',
'|| l_chart_pa || ',
'''" end="'' ',
'|| l_chart_ag || ',
'''" align="Inside" start_size="60" end_size="60" padding="6" color="#63A9D5"><border enabled="true" color="Black" opacity="0.4"/><label enabled="true" align="Inside" padding="34"><format><![CDATA[]]></format><position valign="Center" halign="Center"/>'
||'<font family="Verdana" bold="True" size="10"/></label><fill opacity="0.6"/></color_range><color_range start="'' ',
'|| l_chart_ag || ',
'''" end="'' ',
'|| l_chart_max || ',
'''" align="Inside" start_size="60" end_size="60" padding="6" color="#4E77A7"><border enabled="true" color="Black" opacity="0.4"/><label enabled="true" align="Inside" padding="34"><format><![CDATA[]]></format><position valign="Center" halign="Center"/>'
||'<font family="Verdana" bold="True" size="10"/></label><fill opacity="0.6"/></color_range></color_ranges></axis><frame><inner_stroke enabled="false"/><outer_stroke enabled="false"/><background><fill type="Gradient"><gradient angle="45"><key color="#FD'
||'FDFD"/><key color="#F7F3F4"/></gradient></fill><border enabled="false"/></background><effects enabled="false"/></frame><pointers><pointer value="'' ',
'|| l_chart_value || ',
'''"><label enabled="true"><position placement_mode="ByPoint" x="50" y="120"/><format><![CDATA['' ',
'|| l_chart_plabel || ',
''']]></format><background enabled="false"/></label><actions><action type="NavigateToURL" url="f?p=&APP_ID.:3:&SESSION.:::3:P3_X_EPA_REGION,P3_X_YEAR:''',
'|| c.epa_region_code || '','' || :P5_X_YEAR ||',
'''" target="_self"/></actions><needle_pointer_style thickness="7" point_thickness="5" point_radius="3"><fill color="Rgb(230,230,230)"/><border color="Black" opacity="0.7"/><effects enabled="true"><bevel enabled="true" distance="2" shadow_opacity="0.6"'
||' highlight_opacity="0.6"/><drop_shadow enabled="true" distance="1" blur_x="1" blur_y="1" opacity="0.4"/></effects><cap><background><fill type="Gradient"><gradient type="Linear" angle="45"><key color="#D3D3D3"/><key color="#6F6F6F"/></gradient></fill>'
||'<border color="Black" opacity="0.9"/></background><effects enabled="true"><bevel enabled="true" distance="2" shadow_opacity="0.6" highlight_opacity="0.6"/><drop_shadow enabled="true" distance="1.5" blur_x="2" blur_y="2" opacity="0.4"/></effects></cap'
||'></needle_pointer_style><animation enabled="true" start_time="0" duration="0.5" interpolation_type="Bounce"/></pointer></pointers><labels><label enabled="true"><position placement_mode="ByPoint" x="50" y="130"/><format><![CDATA['' ',
'|| l_chart_label || ',
''']]></format><background enabled="false"/></label></labels></circular></gauge></gauges></anychart>''; ',
'',
'      htp.p(''',
'        c_'' || c.epa_region_code || ''.setData('''''' || l_XML || ''''''); '');',
'',
'   END LOOP;',
'',
'   htp.p(''',
'        }',
'    </script>'');',
'',
'END;',
' '))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35601350632613512)
,p_plug_name=>'Select Year'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>11
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<p>These figures display the amount of data available within an EPA Region in the selected year (default to the current year). The number of records submitted in the selected year is compared to the number of records submitted to STORET over a five y'
||'ear average. The records represent the data available in STORET on measurements of water quality as reported by ALL current organizations, including state, local, and tribal agencies and watershed groups.</p>',
'<p>Select a year using the dropdown menu. To view the states within the Region,',
'click on the figure.</p>'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(35602149771651153)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(35601350632613512)
,p_button_name=>'P5_GO'
,p_button_static_id=>'P5_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(27668368034614464)
,p_button_image_alt=>'Submit'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT'
,p_grid_new_grid=>false
,p_grid_new_row=>'Y'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35601731632636417)
,p_name=>'P5_X_YEAR'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(35601350632613512)
,p_prompt=>'<strong>Select Year:</strong>&nbsp;&nbsp;'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_char(sysdate,''YYYY'')',
'  from dual;'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_number(column_value) as n,',
'       to_number(column_value) as v',
'  from table(pkg_dynamic_list.get_years(null,to_number(to_char(sysdate,''YYYY'')) - 1899))',
' order by 1 desc;'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35602041806648820)
,p_name=>'P5_1_0'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(35601350632613512)
,p_prompt=>'&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(35647524538836345)
,p_computation_sequence=>10
,p_computation_item=>'F102_X_BREADCRUMB'
,p_computation_point=>'BEFORE_HEADER'
,p_computation=>'bitand(nvl(:F102_X_BREADCRUMB,1) + 2 - bitand(nvl(:F102_X_BREADCRUMB,1),2),3)'
);
end;
/
prompt --application/pages/page_00006
begin
wwv_flow_api.create_page(
 p_id=>6
,p_user_interface_id=>wwv_flow_api.id(34223238802660366)
,p_name=>'Tribal Profile'
,p_page_mode=>'NORMAL'
,p_step_title=>'Tribal Profile'
,p_step_sub_title=>'Tribal Profile'
,p_step_sub_title_type=>'TEXT_WITH_SUBSTITUTIONS'
,p_first_item=>'NO_FIRST_ITEM'
,p_html_page_header=>'<script type="text/javascript" src="#IMAGE_PREFIX#flashchart/anychart_6/js/AnyChart.js"></script>'
,p_javascript_code_onload=>'updateChartData();'
,p_step_template=>wwv_flow_api.id(31007705311538595)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_chained=>'Y'
,p_overwrite_navigation_list=>'N'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_cache_mode=>'NOCACHE'
,p_cache_timeout_seconds=>21600
,p_last_updated_by=>'XJTURAKA'
,p_last_upd_yyyymmddhh24miss=>'20160211134143'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36996823767614570)
,p_plug_name=>'Profile Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>15
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<br>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P6_X_GEN_GEO_TRIBE'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(37000053607614581)
,p_plug_name=>'Chart Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>25
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
' ',
'DECLARE',
'   l_chart_scale    NUMBER;',
'   l_chart_value    NUMBER;',
'   l_chart_max      NUMBER;',
'   l_chart_pa       NUMBER;',
'   l_chart_ag       NUMBER;',
'   l_chart_title    VARCHAR2(1000);',
'   l_chart_label    VARCHAR2(1000);',
'   l_chart_plabel   VARCHAR2(1000);',
'   l_image_prefix   VARCHAR2(300);',
'   l_host           VARCHAR2(4000);',
'   l_XML            VARCHAR2(32767);',
'   l_idx            NUMBER;',
'   l_max            NUMBER;',
'   l_year           NUMBER;',
'BEGIN',
'',
'   l_image_prefix := V(''IMAGE_PREFIX'');',
'   l_host := OWA_UTIL.get_cgi_env (''REQUEST_PROTOCOL'') || ''://''  ',
'          || OWA_UTIL.get_cgi_env (''HTTP_HOST'')        || '':''  ',
'          || OWA_UTIL.get_cgi_env (''SERVER_PORT'')      || ''/''  ',
'          || REPLACE(OWA_UTIL.get_cgi_env (''SCRIPT_NAME''),''/'','''') || ''/'';',
'',
'   l_year := :P6_X_YEAR;',
'             ',
'   -- Create HTML table with div holders for the dynamic charts ',
'',
'   htp.p(''<table cellspacing="0" cellpadding="0" border="0"><tr><td><center>'');',
'   htp.p(''<table cellspacing="0" cellpadding="0" border="0"><tr>'');',
'   htp.p(''<td><div id="my_rchart_'' || to_char(l_year) || ''"></div></td>'');',
'   htp.p(''<td><div id="my_rchart_'' || to_char(l_year - 1) || ''"></div></td>'');',
'   htp.p(''<td><div id="my_rchart_'' || to_char(l_year - 2) || ''"></div></td></tr><tr>'');',
'   htp.p(''<td><div id="my_rchart_d'' || to_char(l_year) || ''"></div></td>'');',
'   htp.p(''<td><div id="my_rchart_d'' || to_char(l_year - 1) || ''"></div></td>'');',
'   htp.p(''<td><div id="my_rchart_d'' || to_char(l_year - 2) || ''"></div></td></tr></table><br>'');   ',
'   ',
'   htp.p(''<table cellspacing="0" cellpadding="0" border="0"><tr>'');',
'   htp.p(''<td><div id="my_rchart_'' || to_char(l_year - 3) || ''"></div></td>'');   ',
'   htp.p(''<td><div id="my_rchart_'' || to_char(l_year - 4) || ''"></div></td></tr><tr>'');',
'   htp.p(''<td><div id="my_rchart_d'' || to_char(l_year - 3) || ''"></div></td>'');',
'   htp.p(''<td><div id="my_rchart_d'' || to_char(l_year - 4) || ''"></div></td></tr></table>'');',
'   htp.p(''</center></td></tr></table>'');',
'                      ',
'   -- Create chart objects with JavaScript ',
'',
'   htp.p(''<script type="text/javascript" language="javascript">'');',
'   FOR c IN (',
'',
'      select yr,',
'             rownum as idx',
'        from ( select a.column_value as yr',
'                 from table(pkg_dynamic_list.get_years(:P6_X_YEAR,5)) a',
'                order by yr desc )',
'',
'   )',
'   LOOP',
'      htp.p(''',
'        var c_'' || c.yr || '' = new AnyChart("'' || l_image_prefix || ''flashchart/anychart_6/swf/OracleAnyChart.swf"); ',
'        with(c_'' || c.yr || '') {     ',
'            width = "300";     ',
'            height = "250";   ',
'        } ',
'        with(c_'' || c.yr || ''.messages) {     ',
'            init = "Initializing..."; ',
'            loadingXML = "Loading data...";     ',
'            loadingResources = "Loading resources..."; ',
'            loadingTemplates = "Loading templates...";     ',
'            noData = "No data found."; ',
'            waitingForData = "Loading data. Please wait.";   ',
'        } ',
'        c_'' || c.yr || ''.write("my_rchart_'' || c.yr || ''"); '');',
'',
'      htp.p(''',
'        var c_d'' || c.yr || '' = new AnyChart("'' || l_image_prefix || ''flashchart/anychart_6/swf/OracleAnyChart.swf"); ',
'        with(c_d'' || c.yr || '') {     ',
'            width = "300";     ',
'            height = "200";   ',
'        } ',
'        with(c_d'' || c.yr || ''.messages) {     ',
'            init = "Initializing..."; ',
'            loadingXML = "Loading data...";     ',
'            loadingResources = "Loading resources..."; ',
'            loadingTemplates = "Loading templates...";     ',
'            noData = "No data found."; ',
'            waitingForData = "Loading data. Please wait.";   ',
'        } ',
'        c_d'' || c.yr || ''.write("my_rchart_d'' || c.yr || ''"); '');',
'   END LOOP;',
'   htp.p(''</script>'');',
'   ',
'   -- Create JavaScript function to generate the chart data XML and load it',
'',
'   htp.p(''<script type="text/javascript" language="javascript">',
'      function updateChartData() { '');       ',
'',
'   FOR yr IN (',
'',
'      select yr,',
'             rownum as idx',
'        from ( select a.column_value as yr',
'                 from table(pkg_dynamic_list.get_years(:P6_X_YEAR,5)) a',
'                order by yr desc )',
'',
'   )',
'   LOOP',
'',
'       FOR c IN (',
'select org.organization_name,',
'                 nvl(x.total_count,0) as val,',
'                 nvl(z.avg_5_yr,1) as max1,',
'                 nvl(z.avg_5_yr,0) as max0,                 ',
'                 nvl(x.biological_count,0) as bcnt,',
'                 nvl(x.habitat_count,0) as hcnt,',
'                 nvl(x.regular_count,0) as rcnt',
'            from di_org org,',
'                 ( select /*+ DYNAMIC_SAMPLING(dt 5) */',
'                          fk_org, ',
'                          avg(result_count) as avg_5_yr,',
'                          avg(regular_count) as avg_5_yr_reg,',
'                          avg(habitat_count) as avg_5_yr_hab,',
'                          avg(biological_count) as avg_5_yr_bio                ',
'                     from tribal_state_org_year a, table(pkg_dynamic_list.get_years(yr.yr - 1,5)) dt                 ',
'                    where dt.column_value = a.act_start_year_date',
'                      and fk_org = :P6_X_GEN_GEO_TRIBE',
'                    group by fk_org ) z,',
'                 ( select /*+ DYNAMIC_SAMPLING(dt 5) */',
'                          fk_org,',
'                          biological_count,',
'                          habitat_count,',
'                          regular_count,',
'                          result_count as total_count,',
'                          dt.column_value as activity_year',
'                     from tribal_state_org_year a,',
'                          table(pkg_dynamic_list.get_years(yr.yr,1)) dt',
'                    where dt.column_value = a.act_start_year_date',
'                      and fk_org = :P6_X_GEN_GEO_TRIBE ) x',
'           where org.pk_isn = z.fk_org (+)',
'             and org.pk_isn = x.fk_org (+)',
'             --and st.country_code = ''US''',
'             and org.pk_isn = :P6_X_GEN_GEO_TRIBE',
'',
'       )',
'       LOOP',
'',
'          IF c.max1 > c.val THEN',
'             l_max := c.max1;',
'          ELSE',
'             l_max := c.val;',
'          END IF;   ',
'',
'          l_chart_scale := l_max / 4000;',
'          l_chart_value := c.val / 1000;',
'          l_chart_max := l_max / 1000;',
'          l_chart_pa := l_max / 3000;',
'          l_chart_ag := 2 * l_max / 3000;',
'          l_chart_title := c.organization_name; ',
'          l_chart_plabel := ''In '' || yr.yr || '': '' || trim(to_char(c.val,''999,999,999,999'')) || '' records'';',
'          l_chart_label := ''5 yr avg: '' || trim(to_char(round(c.max0),''999,999,999,999'')) || ''/yr'';',
'',
'          if length(l_chart_title) >= 39 then',
'',
'             l_chart_title := substr(l_chart_title, 1, instr(l_chart_title, '' '', 38 - length(l_chart_title)) - 1) || ''\n'' || substr(l_chart_title, instr(l_chart_title, '' '', 38 - length(l_chart_title)) + 1);',
'',
'          end if;',
'',
'          l_XML := ''<?xml version = "1.0" encoding="utf-8" standalone = "yes"?><anychart><settings><animation enabled="true"/><no_data show_waiting_animation="False"><label><text>No data submitted.</text><font family="Verdana" bold="yes" size="10"/><'
||'/label></no_data></settings><gauges><gauge><chart_settings><title enabled="True" position="Top" padding="0" text_align="Center"><font family="Verdana" bold="True" size="10"/><text>''',
'            || l_chart_title ||',
'            ''</text></title><chart_background><fill type="Solid" color="0xffffff" opacity="0" /><border enabled="false" /><corners type="Square" /></chart_background><data_plot_background /></chart_settings><circular><axis radius="37" start_angle="85'
||'" sweep_angle="190" size="3"><labels align="Outside" padding="6"><format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.}k]]></format></labels><scale minimum="0" maximum="'' ',
'            || l_chart_max || ',
'            ''" major_interval="'' ',
'            || l_chart_scale || ',
'            ''"/><scale_bar><fill color="#292929"/></scale_bar><major_tickmark align="Center" length="10" padding="0"/><minor_tickmark enabled="false"/><color_ranges><color_range start="0" end="'' ',
'            || l_chart_pa || ',
'            ''" align="Inside" start_size="60" end_size="60" padding="6" color="#B9E2F4"><border enabled="true" color="Black" opacity="0.4"/><label enabled="true" align="Inside" padding="34"><format><![CDATA[]]></format><position valign="Center" halig'
||'n="Center"/><font family="Verdana" bold="True" size="10"/></label><fill opacity="0.6"/></color_range><color_range start="'' ',
'            || l_chart_pa || ',
'            ''" end="'' ',
'            || l_chart_ag || ',
'            ''" align="Inside" start_size="60" end_size="60" padding="6" color="#63A9D5"><border enabled="true" color="Black" opacity="0.4"/><label enabled="true" align="Inside" padding="34"><format><![CDATA[]]></format><position valign="Center" halig'
||'n="Center"/><font family="Verdana" bold="True" size="10"/></label><fill opacity="0.6"/></color_range><color_range start="'' ',
'            || l_chart_ag || ',
'            ''" end="'' ',
'            || l_chart_max || ',
'            ''" align="Inside" start_size="60" end_size="60" padding="6" color="#4E77A7"><border enabled="true" color="Black" opacity="0.4"/><label enabled="true" align="Inside" padding="34"><format><![CDATA[]]></format><position valign="Center" halig'
||'n="Center"/><font family="Verdana" bold="True" size="10"/></label><fill opacity="0.6"/></color_range></color_ranges></axis><frame><inner_stroke enabled="false"/><outer_stroke enabled="false"/><background><fill type="Gradient"><gradient angle="45"><ke'
||'y color="#FDFDFD"/><key color="#F7F3F4"/></gradient></fill><border enabled="false"/></background><effects enabled="false"/></frame><pointers><pointer value="'' ',
'            || l_chart_value || ',
'            ''"><label enabled="true"><position placement_mode="ByPoint" x="50" y="120"/><format><![CDATA['' ',
'            || l_chart_plabel || ',
'            '']]></format><background enabled="false"/></label><needle_pointer_style thickness="7" point_thickness="5" point_radius="3"><fill color="Rgb(230,230,230)"/><border color="Black" opacity="0.7"/><effects enabled="true"><bevel enabled="true" '
||'distance="2" shadow_opacity="0.6" highlight_opacity="0.6"/><drop_shadow enabled="true" distance="1" blur_x="1" blur_y="1" opacity="0.4"/></effects><cap><background><fill type="Gradient"><gradient type="Linear" angle="45"><key color="#D3D3D3"/><key co'
||'lor="#6F6F6F"/></gradient></fill><border color="Black" opacity="0.9"/></background><effects enabled="true"><bevel enabled="true" distance="2" shadow_opacity="0.6" highlight_opacity="0.6"/><drop_shadow enabled="true" distance="1.5" blur_x="2" blur_y="'
||'2" opacity="0.4"/></effects></cap></needle_pointer_style><animation enabled="true" start_time="0" duration="0.5" interpolation_type="Bounce"/></pointer></pointers><labels><label enabled="true"><position placement_mode="ByPoint" x="50" y="130"/><forma'
||'t><![CDATA['' ',
'            || l_chart_label || ',
'            '']]></format><background enabled="false"/></label></labels></circular></gauge></gauges></anychart>''; ',
'',
'          htp.p(''',
'            c_'' || yr.yr || ''.setData('''''' || l_XML || ''''''); '');',
'            ',
'          l_XML := ''<?xml version = "1.0" encoding="utf-8" standalone = "yes"?><anychart><settings><animation enabled="false"/><no_data show_waiting_animation="False"><label><text>No data for ''',
'            || yr.yr || ''.</text><font family="Verdana" bold="yes" size="10"/></label></no_data></settings><margin left="0" top="0" right="0" bottom="0" /><charts><chart plot_type="CategorizedHorizontal"><chart_settings><title enabled="True"><text>''',
'            || yr.yr || ''</text></title><chart_background><fill type="Solid" color="0xffffff" opacity="0" /><border enabled="false"/><corners type="Square"/></chart_background><data_plot_background></data_plot_background><axes><y_axis position="Oppos'
||'ite"><scale mode="Normal" /><title enabled="false" /><labels enabled="true" position="Outside"><font family="Tahoma" size="10" color="0x000000" /><format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format></labels><m'
||'ajor_grid enabled="False"/><minor_grid enabled="False"/></y_axis><x_axis><scale  mode="Normal"    /><title enabled="false"/><labels enabled="true" position="Outside"><font family="Tahoma" size="10" color="0x000000" /><format><![CDATA[{%Value}{numDeci'
||'mals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format></labels><major_grid enabled="False"/><minor_grid enabled="False"/></x_axis></axes></chart_settings><data_plot_settings enable_3d_mode="false" ><bar_series style="Default"><tooltip_settings '
||'enabled="true"><format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format><font family="Tahoma" size="10" color="0x000000" /><position anchor="Float" valign="Top" padding="10" /></tooltip_set'
||'tings><label_settings enabled="true" mode="Outside" multi_line_align="Left"><position anchor="CenterBottom" padding="5" /><format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format><background enabled="false"/><font '
||'family="Tahoma" size="10" color="0x000000" /></label_settings><bar_style></bar_style><marker_settings enabled="True"><marker type="None" /></marker_settings></bar_series></data_plot_settings>'';',
'',
'          if c.hcnt > 0 or c.rcnt >0 or c.bcnt > 0 then',
'          ',
'             l_XML := l_XML ',
'                || ''<data><series><point name="Biological" y="''',
'                || c.bcnt || ''" color="0xB9E2F4" /><point name="Habitat" y="''',
'                || c.hcnt || ''" color="0xB9E2F4" /><point name="Physical/Chemical" y="''',
'                || c.rcnt || ''" color="0xB9E2F4" /></series></data>'';',
'          ',
'          end if;',
'                             ',
'          l_XML := l_XML || ''</chart></charts></anychart>'';',
'  ',
'          htp.p(''',
'            c_d'' || yr.yr || ''.setData('''''' || l_XML || ''''''); '');',
'',
'       END LOOP;',
'   ',
'   END LOOP;',
'   ',
'   htp.p(''',
'        }',
'    </script>'');',
'',
'END;',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P6_X_GEN_GEO_TRIBE'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(37000222778614584)
,p_plug_name=>'State Profile'
,p_region_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_08'
,p_menu_id=>wwv_flow_api.id(37712576903483127)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(25853960577757693)
,p_plug_query_row_template=>1
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(37000426805614584)
,p_plug_name=>'Search Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>5
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<p>These figures display the amount of data available within a state by the selected year. The number of records submitted in the selected year is compared to the number of records submitted to STORET over a five year average. The figures also displa'
||'y the number of records submitted by results categories.  The records represent the data available in STORET on measurements of water quality as reported by ALL current tribal agencies.</p>',
'<p>Select a year, a state and a tribe by using the dropdown menu.</p>'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(37002039903614587)
,p_plug_name=>'Before Profile Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0">',
'<tr>',
'<td>'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P6_X_GEN_GEO_TRIBE'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(37002223566614587)
,p_plug_name=>'After Profile Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</td>',
'<td width="450" align="right">',
'<br>',
'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;To query and download the submitted data, please visit the',
'<br>',
'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="http://www.epa.gov/storet/dw_home.html" target="_blank">STORET/WQX Warehouse Reports</a>',
'</td>',
'</tr>',
'</table>'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P6_X_GEN_GEO_TRIBE'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(37079439134302815)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>35
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(37712576903483127)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(31009000087660106)
,p_plug_query_row_template=>1
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(37001036869614585)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(37000426805614584)
,p_button_name=>'P6_GO'
,p_button_static_id=>'P6_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(27668368034614464)
,p_button_image_alt=>'Submit'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT'
,p_grid_new_grid=>false
,p_grid_new_row=>'Y'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36997043363614575)
,p_name=>'P6_0_LABEL'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(36996823767614570)
,p_prompt=>'Number of Tribes in &P6_X_STATE_NAME. Submitting Data in &P6_X_YEAR.:&nbsp;&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_display_when_type=>'NEVER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36997236783614578)
,p_name=>'P6_0_VAL'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(36996823767614570)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select ''<strong><a href="f?p=&APP_ID.:11:&SESSION.:::11:P11_X_GEN_GEO_STATE,P11_X_YEAR,P11_FROMPG:&P6_X_GEN_GEO_STATE.,&P6_X_YEAR.,6">'' || trim(to_char(count(distinct fk_org),''999,999,999,999'')) || ''</a></strong>''',
'  from tribal_state_org_year',
' where fk_gen_geo_state = :P6_X_GEN_GEO_STATE',
'   and act_start_year_date = :P6_X_YEAR'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'onmouseover="toolTip_enable(event,this,''Click here for Data Owners Contribution for &P6_X_STATE_NAME.'')"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'RIGHT-CENTER'
,p_display_when_type=>'NEVER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36997450338614578)
,p_name=>'P6_1_LABEL'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(36996823767614570)
,p_prompt=>'Total Number of Tribes in &P6_X_STATE_NAME. Submitting Data:&nbsp;&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_display_when_type=>'NEVER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36997623005614579)
,p_name=>'P6_1_VAL'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(36996823767614570)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select ''<strong>'' || trim(to_char(count(distinct fk_org),''999,999,999,999'')) || ''</strong>''',
'  from tribal_state_org_year',
' where fk_gen_geo_state = :P6_X_GEN_GEO_STATE'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'RIGHT-CENTER'
,p_display_when_type=>'NEVER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36997836390614579)
,p_name=>'P6_2_LABEL'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(36996823767614570)
,p_prompt=>'Number of Stations for &P6_X_TRIBE_NAME. with Data for &P6_X_YEAR.:&nbsp;&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36998048178614579)
,p_name=>'P6_2_VAL'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(36996823767614570)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select ''<strong>'' || trim(to_char(count(distinct fk_fa_statn),''999,999,999,999'')) || ''</strong>''',
'  from tribal_station_year',
' where FK_ORG = :P6_X_GEN_GEO_TRIBE',
'   and act_start_year_date = :P6_X_YEAR'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'RIGHT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36998251122614579)
,p_name=>'P6_3_LABEL'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(36996823767614570)
,p_prompt=>'Total Number of Stations for &P6_X_TRIBE_NAME. with Data:&nbsp;&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36998453678614579)
,p_name=>'P6_3_VAL'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(36996823767614570)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select ''<strong>'' || trim(to_char(count(distinct fk_fa_statn),''999,999,999,999'')) || ''</strong>''',
'  from tribal_station_year',
' where FK_ORG = :P6_X_GEN_GEO_TRIBE'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'RIGHT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36998623697614579)
,p_name=>'P6_4_LABEL'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(36996823767614570)
,p_prompt=>'Total Number of Stations for &P6_X_TRIBE_NAME.:&nbsp;&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36998844410614579)
,p_name=>'P6_4_VAL'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(36996823767614570)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select ''<strong>'' || trim(to_char(count(distinct pk_isn),''999,999,999,999'')) || ''</strong>''',
'  from fa_station',
' where FK_ORG = :P6_X_GEN_GEO_TRIBE'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'RIGHT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36999029609614579)
,p_name=>'P6_5_LABEL'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(36996823767614570)
,p_prompt=>'Number of Distinct Characteristics Submitted for &P6_X_TRIBE_NAME. in &P6_X_YEAR.:&nbsp;&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36999224611614579)
,p_name=>'P6_5_VAL'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(36996823767614570)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select ''<strong><a href="f?p=&APP_ID.:14:&SESSION.:::14:P14_FK_GEN_GEO_STATE,P14_FK_GEN_GEO_TRIBE,P14_X_YEAR,P14_FROMPG:&P6_X_GEN_GEO_STATE.,&P6_X_GEN_GEO_TRIBE.,&P6_X_YEAR.,6">'' || trim(to_char(count(distinct fk_char),''999,999,999,999'')) || ''</a></s'
||'trong>''',
'  from TRIBAL_STATE_ORG_CHAR_YEAR',
' where FK_ORG = :P6_X_GEN_GEO_TRIBE',
'   and act_start_year_date = :P6_X_YEAR'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'onmouseover="toolTip_enable(event,this,''Click here for the Top 10 Substances for &P6_X_TRIBE_NAME.'')"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'RIGHT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36999444766614580)
,p_name=>'P6_6_LABEL'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(36996823767614570)
,p_prompt=>'Total Number of Distinct Characteristics Submitted for &P6_X_TRIBE_NAME.:&nbsp;&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
end;
/
begin
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36999632793614580)
,p_name=>'P6_6_VAL'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(36996823767614570)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select ''<strong>'' || trim(to_char(count(distinct fk_char),''999,999,999,999'')) || ''</strong>''',
'  from TRIBAL_STATE_ORG_CHAR_YEAR',
' where FK_ORG = :P6_X_GEN_GEO_TRIBE'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'RIGHT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(37000638475614585)
,p_name=>'P6_X_STATE_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(37000426805614584)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(37000825979614585)
,p_name=>'P6_1_0'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(37000426805614584)
,p_prompt=>'&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(37001240839614585)
,p_name=>'P6_X_YEAR'
,p_is_required=>true
,p_item_sequence=>2
,p_item_plug_id=>wwv_flow_api.id(37000426805614584)
,p_prompt=>'<strong>Select Year:</strong>&nbsp;&nbsp;'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_char(sysdate,''YYYY'')',
'  from dual;'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_number(column_value) as n,',
'       to_number(column_value) as v',
'  from table(pkg_dynamic_list.get_years(null,to_number(to_char(sysdate,''YYYY'')) - 1899))',
' order by 1 desc;'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(37001440216614586)
,p_name=>'P6_X_GEN_GEO_STATE'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(37000426805614584)
,p_prompt=>'<strong>Select State:</strong>&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select st.state_name,st.pk_isn',
' from di_geo_state st',
'where country_code = ''US''',
'  and epa_region_code is not null',
'  and PK_ISN in (select FK_GEO_STATE from lu_orgstate)',
'order by state_name'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- SELECT -'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(37006925420876725)
,p_name=>'P6_X_GEN_GEO_TRIBE'
,p_is_required=>true
,p_item_sequence=>25
,p_item_plug_id=>wwv_flow_api.id(37000426805614584)
,p_prompt=>'<strong>Select Tribe:</strong>&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'Select  distinct b.organization_id || '' - '' || b.organization_name as ORGANIZATION_NAME, b.PK_ISN',
'from lu_orgstate a, DI_ORG b',
'where a.fk_org = b.pk_isn',
'and a.fk_geo_state = :P6_X_GEN_GEO_STATE',
'order by 1;'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- SELECT -'
,p_lov_cascade_parent_items=>'P6_X_GEN_GEO_STATE'
,p_ajax_items_to_submit=>'P6_X_GEN_GEO_STATE'
,p_ajax_optimize_refresh=>'Y'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(37007824934211268)
,p_name=>'P6_X_TRIBE_NAME'
,p_item_sequence=>26
,p_item_plug_id=>wwv_flow_api.id(37000426805614584)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(37002538035614588)
,p_computation_sequence=>10
,p_computation_item=>'F102_X_BREADCRUMB'
,p_computation_point=>'BEFORE_HEADER'
,p_computation=>'bitand(nvl(:F102_X_BREADCRUMB,1) + 8 - bitand(nvl(:F102_X_BREADCRUMB,1),8),15)'
,p_compute_when_type=>'NEVER'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(37002737845614589)
,p_computation_sequence=>10
,p_computation_item=>'P6_X_STATE_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select state_name',
'  from di_geo_state',
' where pk_isn = :P6_X_GEN_GEO_STATE'))
,p_compute_when=>'P6_X_GEN_GEO_STATE'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(37008143747222131)
,p_computation_sequence=>20
,p_computation_item=>'P6_X_TRIBE_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'Select ORGANIZATION_NAME',
'from DI_ORG',
'where pk_isn = :P6_X_GEN_GEO_TRIBE;'))
,p_compute_when=>'P6_X_GEN_GEO_TRIBE'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
end;
/
prompt --application/pages/page_00007
begin
wwv_flow_api.create_page(
 p_id=>7
,p_user_interface_id=>wwv_flow_api.id(34223238802660366)
,p_name=>'State Profile'
,p_page_mode=>'NORMAL'
,p_step_title=>'Dashboard: State Profile'
,p_step_sub_title=>'State Profile'
,p_step_sub_title_type=>'TEXT_WITH_SUBSTITUTIONS'
,p_first_item=>'NO_FIRST_ITEM'
,p_html_page_header=>'<script type="text/javascript" src="#IMAGE_PREFIX#flashchart/anychart_6/js/AnyChart.js"></script>'
,p_javascript_code_onload=>'updateChartData();'
,p_step_template=>wwv_flow_api.id(31007705311538595)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_chained=>'Y'
,p_overwrite_navigation_list=>'N'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_cache_mode=>'NOCACHE'
,p_cache_timeout_seconds=>21600
,p_last_updated_by=>'JTURAKA'
,p_last_upd_yyyymmddhh24miss=>'20151209113952'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(27698712765440319)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>35
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(37712576903483127)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(31009000087660106)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'bitand(:F102_X_BREADCRUMB,2) = 0'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35617326557360602)
,p_plug_name=>'Search Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>5
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<p>These figures display the amount of data available within a state by the selected year. The number of records submitted in the selected year is compared to the number of records submitted to STORET over a five year average. The figures also displa'
||'y the number of records submitted by results categories.  The records represent the data available in STORET on measurements of water quality as reported by ALL current organizations, including state, local, and tribal agencies and watershed groups.<'
||'/p>',
'<p>Select a year and a state using the dropdown menu. To view the ',
'organizations which submit data within the state, click on the figure.</p>'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35620922943360607)
,p_plug_name=>'State Profile'
,p_region_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'BODY_3'
,p_menu_id=>wwv_flow_api.id(37712576903483127)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(25853960577757693)
,p_plug_query_row_template=>1
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35629748800594334)
,p_plug_name=>'Profile Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>15
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<br>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P7_X_GEN_GEO_STATE'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35647129555799978)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(37712576903483127)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(25853960577757693)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'bitand(:F102_X_BREADCRUMB,2) = 0 AND bitand(:F102_X_BREADCRUMB,4) = 0'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35659251446480117)
,p_plug_name=>'Chart Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>25
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
' ',
'DECLARE',
'   l_chart_scale    NUMBER;',
'   l_chart_value    NUMBER;',
'   l_chart_max      NUMBER;',
'   l_chart_pa       NUMBER;',
'   l_chart_ag       NUMBER;',
'   l_chart_title    VARCHAR2(1000);',
'   l_chart_label    VARCHAR2(1000);',
'   l_chart_plabel   VARCHAR2(1000);',
'   l_image_prefix   VARCHAR2(300);',
'   l_host           VARCHAR2(4000);',
'   l_XML            VARCHAR2(32767);',
'   l_idx            NUMBER;',
'   l_max            NUMBER;',
'   l_year           NUMBER;',
'BEGIN',
'',
'   l_image_prefix := V(''IMAGE_PREFIX'');',
'   l_host := OWA_UTIL.get_cgi_env (''REQUEST_PROTOCOL'') || ''://''  ',
'          || OWA_UTIL.get_cgi_env (''HTTP_HOST'')        || '':''  ',
'          || OWA_UTIL.get_cgi_env (''SERVER_PORT'')      || ''/''  ',
'          || REPLACE(OWA_UTIL.get_cgi_env (''SCRIPT_NAME''),''/'','''') || ''/'';',
'',
'   l_year := :P7_X_YEAR;',
'             ',
'   -- Create HTML table with div holders for the dynamic charts ',
'',
'   htp.p(''<table cellspacing="0" cellpadding="0" border="0"><tr><td><center>'');',
'   htp.p(''<table cellspacing="0" cellpadding="0" border="0"><tr>'');',
'   htp.p(''<td><div id="my_rchart_'' || to_char(l_year) || ''"></div></td>'');',
'   htp.p(''<td><div id="my_rchart_'' || to_char(l_year - 1) || ''"></div></td>'');',
'   htp.p(''<td><div id="my_rchart_'' || to_char(l_year - 2) || ''"></div></td></tr><tr>'');',
'   htp.p(''<td><div id="my_rchart_d'' || to_char(l_year) || ''"></div></td>'');',
'   htp.p(''<td><div id="my_rchart_d'' || to_char(l_year - 1) || ''"></div></td>'');',
'   htp.p(''<td><div id="my_rchart_d'' || to_char(l_year - 2) || ''"></div></td></tr></table><br>'');   ',
'   ',
'   htp.p(''<table cellspacing="0" cellpadding="0" border="0"><tr>'');',
'   htp.p(''<td><div id="my_rchart_'' || to_char(l_year - 3) || ''"></div></td>'');   ',
'   htp.p(''<td><div id="my_rchart_'' || to_char(l_year - 4) || ''"></div></td></tr><tr>'');',
'   htp.p(''<td><div id="my_rchart_d'' || to_char(l_year - 3) || ''"></div></td>'');',
'   htp.p(''<td><div id="my_rchart_d'' || to_char(l_year - 4) || ''"></div></td></tr></table>'');',
'   htp.p(''</center></td></tr></table>'');',
'                      ',
'   -- Create chart objects with JavaScript ',
'',
'   htp.p(''<script type="text/javascript" language="javascript">'');',
'   FOR c IN (',
'',
'      select yr,',
'             rownum as idx',
'        from ( select a.column_value as yr',
'                 from table(pkg_dynamic_list.get_years(:P7_X_YEAR,5)) a',
'                order by yr desc )',
'',
'   )',
'   LOOP',
'      htp.p(''',
'        var c_'' || c.yr || '' = new AnyChart("'' || l_image_prefix || ''flashchart/anychart_6/swf/OracleAnyChart.swf"); ',
'        with(c_'' || c.yr || '') {     ',
'            width = "300";     ',
'            height = "250";   ',
'        } ',
'        with(c_'' || c.yr || ''.messages) {     ',
'            init = "Initializing..."; ',
'            loadingXML = "Loading data...";     ',
'            loadingResources = "Loading resources..."; ',
'            loadingTemplates = "Loading templates...";     ',
'            noData = "No data found."; ',
'            waitingForData = "Loading data. Please wait.";   ',
'        } ',
'        c_'' || c.yr || ''.write("my_rchart_'' || c.yr || ''"); '');',
'',
'      htp.p(''',
'        var c_d'' || c.yr || '' = new AnyChart("'' || l_image_prefix || ''flashchart/anychart_6/swf/OracleAnyChart.swf"); ',
'        with(c_d'' || c.yr || '') {     ',
'            width = "300";     ',
'            height = "200";   ',
'        } ',
'        with(c_d'' || c.yr || ''.messages) {     ',
'            init = "Initializing..."; ',
'            loadingXML = "Loading data...";     ',
'            loadingResources = "Loading resources..."; ',
'            loadingTemplates = "Loading templates...";     ',
'            noData = "No data found."; ',
'            waitingForData = "Loading data. Please wait.";   ',
'        } ',
'        c_d'' || c.yr || ''.write("my_rchart_d'' || c.yr || ''"); '');',
'   END LOOP;',
'   htp.p(''</script>'');',
'   ',
'   -- Create JavaScript function to generate the chart data XML and load it',
'',
'   htp.p(''<script type="text/javascript" language="javascript">',
'      function updateChartData() { '');       ',
'',
'   FOR yr IN (',
'',
'      select yr,',
'             rownum as idx',
'        from ( select a.column_value as yr',
'                 from table(pkg_dynamic_list.get_years(:P7_X_YEAR,5)) a',
'                order by yr desc )',
'',
'   )',
'   LOOP',
'',
'       FOR c IN (',
'',
'          select st.state_name,',
'                 nvl(x.total_count,0) as val,',
'                 nvl(z.avg_5_yr,1) as max1,',
'                 nvl(z.avg_5_yr,0) as max0,                 ',
'                 nvl(x.biological_count,0) as bcnt,',
'                 nvl(x.habitat_count,0) as hcnt,',
'                 nvl(x.regular_count,0) as rcnt',
'            from di_geo_state st,',
'                 ( select /*+ DYNAMIC_SAMPLING(dt 5) */',
'                          fk_gen_geo_state, ',
'                          avg(result_count) as avg_5_yr,',
'                          avg(regular_count) as avg_5_yr_reg,',
'                          avg(habitat_count) as avg_5_yr_hab,',
'                          avg(biological_count) as avg_5_yr_bio                ',
'                     from state_year a, table(pkg_dynamic_list.get_years(yr.yr - 1,5)) dt                ',
'                    where dt.column_value = a.act_start_year_date',
'                      and fk_gen_geo_state = :P7_X_GEN_GEO_STATE',
'                    group by fk_gen_geo_state ) z,',
'                 ( select /*+ DYNAMIC_SAMPLING(dt 5) */',
'                          fk_gen_geo_state,',
'                          biological_count,',
'                          habitat_count,',
'                          regular_count,',
'                          result_count as total_count,',
'                          dt.column_value as activity_year',
'                     from state_year a,',
'                          table(pkg_dynamic_list.get_years(yr.yr,1)) dt',
'                    where dt.column_value = a.act_start_year_date',
'                      and fk_gen_geo_state = :P7_X_GEN_GEO_STATE ) x',
'           where st.pk_isn = z.fk_gen_geo_state (+)',
'             and st.pk_isn = x.fk_gen_geo_state (+)',
'             and st.country_code = ''US''',
'             and st.pk_isn = :P7_X_GEN_GEO_STATE',
'',
'       )',
'       LOOP',
'',
'          IF c.max1 > c.val THEN',
'             l_max := c.max1;',
'          ELSE',
'             l_max := c.val;',
'          END IF;   ',
'',
'          l_chart_scale := l_max / 4000;',
'          l_chart_value := c.val / 1000;',
'          l_chart_max := l_max / 1000;',
'          l_chart_pa := l_max / 3000;',
'          l_chart_ag := 2 * l_max / 3000;',
'          l_chart_title := c.state_name; ',
'          l_chart_plabel := ''In '' || yr.yr || '': '' || trim(to_char(c.val,''999,999,999,999'')) || '' records'';',
'          l_chart_label := ''5 yr avg: '' || trim(to_char(round(c.max0),''999,999,999,999'')) || ''/yr'';',
'',
'          l_XML := ''<?xml version = "1.0" encoding="utf-8" standalone = "yes"?><anychart><settings><animation enabled="true"/><no_data show_waiting_animation="False"><label><text>No data submitted.</text><font family="Verdana" bold="yes" size="10"/><'
||'/label></no_data></settings><gauges><gauge><chart_settings><title enabled="True" position="Top" padding="0"><font family="Verdana" bold="True" size="10"/><text>''',
'            || l_chart_title ||',
'            ''</text><actions><action type="NavigateToURL" url="f?p=&APP_ID.:9:&SESSION.:::9:P9_X_GEN_GEO_STATE,P9_X_YEAR,P9_X_ORG_TYPE,P9_X_REPORT_TYPE,P9_X_PROGRAM_AREA:'' || :P7_X_GEN_GEO_STATE || '','' || yr.yr ||',
''',-1,CHARTS,-1" target="_self"/></actions></title><chart_background><fill type="Solid" color="0xffffff" opacity="0" /><border enabled="false" /><corners type="Square" /></chart_background><data_plot_background /></chart_settings><circular><axis radiu'
||'s="37" start_angle="85" sweep_angle="190" size="3"><labels align="Outside" padding="6"><format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.}k]]></format></labels><scale minimum="0" maximum="'' ',
'            || l_chart_max || ',
'            ''" major_interval="'' ',
'            || l_chart_scale || ',
'            ''"/><scale_bar><fill color="#292929"/></scale_bar><major_tickmark align="Center" length="10" padding="0"/><minor_tickmark enabled="false"/><color_ranges><color_range start="0" end="'' ',
'            || l_chart_pa || ',
'            ''" align="Inside" start_size="60" end_size="60" padding="6" color="#B9E2F4"><border enabled="true" color="Black" opacity="0.4"/><label enabled="true" align="Inside" padding="34"><format><![CDATA[]]></format><position valign="Center" halig'
||'n="Center"/><font family="Verdana" bold="True" size="10"/></label><fill opacity="0.6"/></color_range><color_range start="'' ',
'            || l_chart_pa || ',
'            ''" end="'' ',
'            || l_chart_ag || ',
'            ''" align="Inside" start_size="60" end_size="60" padding="6" color="#63A9D5"><border enabled="true" color="Black" opacity="0.4"/><label enabled="true" align="Inside" padding="34"><format><![CDATA[]]></format><position valign="Center" halig'
||'n="Center"/><font family="Verdana" bold="True" size="10"/></label><fill opacity="0.6"/></color_range><color_range start="'' ',
'            || l_chart_ag || ',
'            ''" end="'' ',
'            || l_chart_max || ',
'            ''" align="Inside" start_size="60" end_size="60" padding="6" color="#4E77A7"><border enabled="true" color="Black" opacity="0.4"/><label enabled="true" align="Inside" padding="34"><format><![CDATA[]]></format><position valign="Center" halig'
||'n="Center"/><font family="Verdana" bold="True" size="10"/></label><fill opacity="0.6"/></color_range></color_ranges></axis><frame><inner_stroke enabled="false"/><outer_stroke enabled="false"/><background><fill type="Gradient"><gradient angle="45"><ke'
||'y color="#FDFDFD"/><key color="#F7F3F4"/></gradient></fill><border enabled="false"/></background><effects enabled="false"/></frame><pointers><pointer value="'' ',
'            || l_chart_value || ',
'            ''"><label enabled="true"><position placement_mode="ByPoint" x="50" y="120"/><format><![CDATA['' ',
'            || l_chart_plabel || ',
'            '']]></format><background enabled="false"/></label><actions><action type="NavigateToURL" url="f?p=&APP_ID.:9:&SESSION.:::9:P9_X_GEN_GEO_STATE,P9_X_YEAR,P9_X_ORG_TYPE,P9_X_REPORT_TYPE,P9_X_PROGRAM_AREA:'' || :P7_X_GEN_GEO_STATE || '','' || yr.'
||'yr ||',
''',-1,CHARTS,-1" target="_self"/></actions><needle_pointer_style thickness="7" point_thickness="5" point_radius="3"><fill color="Rgb(230,230,230)"/><border color="Black" opacity="0.7"/><effects enabled="true"><bevel enabled="true" distance="2" shadow_'
||'opacity="0.6" highlight_opacity="0.6"/><drop_shadow enabled="true" distance="1" blur_x="1" blur_y="1" opacity="0.4"/></effects><cap><background><fill type="Gradient"><gradient type="Linear" angle="45"><key color="#D3D3D3"/><key color="#6F6F6F"/></gra'
||'dient></fill><border color="Black" opacity="0.9"/></background><effects enabled="true"><bevel enabled="true" distance="2" shadow_opacity="0.6" highlight_opacity="0.6"/><drop_shadow enabled="true" distance="1.5" blur_x="2" blur_y="2" opacity="0.4"/></'
||'effects></cap></needle_pointer_style><animation enabled="true" start_time="0" duration="0.5" interpolation_type="Bounce"/></pointer></pointers><labels><label enabled="true"><position placement_mode="ByPoint" x="50" y="130"/><format><![CDATA['' ',
'            || l_chart_label || ',
'            '']]></format><background enabled="false"/></label></labels></circular></gauge></gauges></anychart>''; ',
'',
'          htp.p(''',
'            c_'' || yr.yr || ''.setData('''''' || l_XML || ''''''); '');',
'            ',
'          l_XML := ''<?xml version = "1.0" encoding="utf-8" standalone = "yes"?><anychart><settings><animation enabled="false"/><no_data show_waiting_animation="False"><label><text>No data for ''',
'            || yr.yr || ''.</text><font family="Verdana" bold="yes" size="10"/></label></no_data></settings><margin left="0" top="0" right="0" bottom="0" /><charts><chart plot_type="CategorizedHorizontal"><chart_settings><title enabled="True"><text>''',
'            || yr.yr || ''</text></title><chart_background><fill type="Solid" color="0xffffff" opacity="0" /><border enabled="false"/><corners type="Square"/></chart_background><data_plot_background></data_plot_background><axes><y_axis position="Oppos'
||'ite"><scale mode="Normal" /><title enabled="false" /><labels enabled="true" position="Outside"><font family="Tahoma" size="10" color="0x000000" /><format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format></labels><m'
||'ajor_grid enabled="False"/><minor_grid enabled="False"/></y_axis><x_axis><scale  mode="Normal"    /><title enabled="false"/><labels enabled="true" position="Outside"><font family="Tahoma" size="10" color="0x000000" /><format><![CDATA[{%Value}{numDeci'
||'mals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format></labels><major_grid enabled="False"/><minor_grid enabled="False"/></x_axis></axes></chart_settings><data_plot_settings enable_3d_mode="false" ><bar_series style="Default"><tooltip_settings '
||'enabled="true"><format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format><font family="Tahoma" size="10" color="0x000000" /><position anchor="Float" valign="Top" padding="10" /></tooltip_set'
||'tings><label_settings enabled="true" mode="Outside" multi_line_align="Left"><position anchor="CenterBottom" padding="5" /><format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format><background enabled="false"/><font '
||'family="Tahoma" size="10" color="0x000000" /></label_settings><bar_style></bar_style><marker_settings enabled="True"><marker type="None" /></marker_settings></bar_series></data_plot_settings>'';',
'',
'          if c.hcnt > 0 or c.rcnt >0 or c.bcnt > 0 then',
'          ',
'             l_XML := l_XML ',
'                || ''<data><series><point name="Biological" y="''',
'                || c.bcnt || ''" color="0xB9E2F4" /><point name="Habitat" y="''',
'                || c.hcnt || ''" color="0xB9E2F4" /><point name="Physical/Chemical" y="''',
'                || c.rcnt || ''" color="0xB9E2F4" /></series></data>'';',
'          ',
'          end if;',
'                             ',
'          l_XML := l_XML || ''</chart></charts></anychart>'';',
'  ',
'          htp.p(''',
'            c_d'' || yr.yr || ''.setData('''''' || l_XML || ''''''); '');',
'',
'       END LOOP;',
'   ',
'   END LOOP;',
'   ',
'   htp.p(''',
'        }',
'    </script>'');',
'',
'END;',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P7_X_GEN_GEO_STATE'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35722324987561347)
,p_plug_name=>'Before Profile Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0">',
'<tr>',
'<td>'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P7_X_GEN_GEO_STATE'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35722534337563990)
,p_plug_name=>'After Profile Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</td>',
'<td width="450" align="right">',
'<br>',
'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;To query and download the submitted data, please visit the',
'<br>',
'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="http://www.epa.gov/storet/dw_home.html" target="_blank">STORET/WQX Warehouse Reports</a>',
'</td>',
'</tr>',
'</table>'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P7_X_GEN_GEO_STATE'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(35617949703360603)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(35617326557360602)
,p_button_name=>'P7_GO'
,p_button_static_id=>'P7_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(27668368034614464)
,p_button_image_alt=>'Submit'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT'
,p_grid_new_grid=>false
,p_grid_new_row=>'Y'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35617524967360603)
,p_name=>'P7_X_STATE_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(35617326557360602)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35617731945360603)
,p_name=>'P7_1_0'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(35617326557360602)
,p_prompt=>'&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35618133453360603)
,p_name=>'P7_X_YEAR'
,p_is_required=>true
,p_item_sequence=>2
,p_item_plug_id=>wwv_flow_api.id(35617326557360602)
,p_prompt=>'<strong>Select Year:</strong>&nbsp;&nbsp;'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_char(sysdate,''YYYY'')',
'  from dual;'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_number(column_value) as n,',
'       to_number(column_value) as v',
'  from table(pkg_dynamic_list.get_years(null,to_number(to_char(sysdate,''YYYY'')) - 1899))',
' order by 1 desc;'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35618343644360603)
,p_name=>'P7_X_GEN_GEO_STATE'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(35617326557360602)
,p_prompt=>'<strong>Select State:</strong>&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
' select st.state_name,',
'        st.pk_isn',
'   from di_geo_state st',
'  where country_code = ''US''',
'    and epa_region_code is not null',
'  order by state_name'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- SELECT -'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35631335472628289)
,p_name=>'P7_0_LABEL'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(35629748800594334)
,p_prompt=>'Number of Organizations Submitting Data for &P7_X_STATE_NAME. in &P7_X_YEAR.:&nbsp;&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35631521187628290)
,p_name=>'P7_0_VAL'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(35629748800594334)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select ''<strong><a href="f?p=&APP_ID.:9:&SESSION.:::9:P9_X_GEN_GEO_STATE,P9_X_ORG_TYPE,P9_X_YEAR:&P7_X_GEN_GEO_STATE.,-1,&P7_X_YEAR.">'' || trim(to_char(count(distinct fk_org),''999,999,999,999'')) || ''</a></strong>''',
'  from state_org_year',
' where fk_gen_geo_state = :P7_X_GEN_GEO_STATE',
'   and act_start_year_date = :P7_X_YEAR'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'onmouseover="toolTip_enable(event,this,''Click here for Data Owners Contribution for &P7_X_STATE_NAME.'')"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'RIGHT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35631731371628290)
,p_name=>'P7_1_LABEL'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(35629748800594334)
,p_prompt=>'Total Number of Organizations Submitting Data for &P7_X_STATE_NAME.:&nbsp;&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35631953563628290)
,p_name=>'P7_1_VAL'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(35629748800594334)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select ''<strong>'' || trim(to_char(count(distinct fk_org),''999,999,999,999'')) || ''</strong>''',
'  from state_org_year',
' where fk_gen_geo_state = :P7_X_GEN_GEO_STATE'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'RIGHT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35632134029628290)
,p_name=>'P7_2_LABEL'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(35629748800594334)
,p_prompt=>'Number of Stations in &P7_X_STATE_NAME. with Data for &P7_X_YEAR.:&nbsp;&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35632333848628290)
,p_name=>'P7_2_VAL'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(35629748800594334)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select ''<strong>'' || trim(to_char(count(distinct fk_fa_statn),''999,999,999,999'')) || ''</strong>''',
'  from station_year',
' where fk_gen_geo_state = :P7_X_GEN_GEO_STATE',
'   and act_start_year_date = :P7_X_YEAR'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'RIGHT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35632524902628290)
,p_name=>'P7_3_LABEL'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(35629748800594334)
,p_prompt=>'Total Number of Stations in &P7_X_STATE_NAME. with Data:&nbsp;&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35632732749628290)
,p_name=>'P7_3_VAL'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(35629748800594334)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select ''<strong>'' || trim(to_char(count(distinct fk_fa_statn),''999,999,999,999'')) || ''</strong>''',
'  from station_year',
' where fk_gen_geo_state = :P7_X_GEN_GEO_STATE'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'RIGHT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
end;
/
begin
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35632953246628290)
,p_name=>'P7_4_LABEL'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(35629748800594334)
,p_prompt=>'Total Number of Stations in &P7_X_STATE_NAME.:&nbsp;&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35633135121628290)
,p_name=>'P7_4_VAL'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(35629748800594334)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select ''<strong>'' || trim(to_char(count(distinct pk_isn),''999,999,999,999'')) || ''</strong>''',
'  from fa_station',
' where fk_gen_geo_state = :P7_X_GEN_GEO_STATE'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'RIGHT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35635422453709733)
,p_name=>'P7_5_LABEL'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(35629748800594334)
,p_prompt=>'Number of Distinct Characteristics Submitted for &P7_X_STATE_NAME. in &P7_X_YEAR.:&nbsp;&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35635642247709735)
,p_name=>'P7_5_VAL'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(35629748800594334)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select ''<strong><a href="f?p=&APP_ID.:10:&SESSION.:::10:P10_FK_GEN_GEO_STATE,P10_X_YEAR:&P7_X_GEN_GEO_STATE.,&P7_X_YEAR.">'' || trim(to_char(count(distinct fk_char),''999,999,999,999'')) || ''</a></strong>''',
'  from state_char_year',
' where fk_gen_geo_state = :P7_X_GEN_GEO_STATE',
'   and act_start_year_date = :P7_X_YEAR'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'onmouseover="toolTip_enable(event,this,''Click here for the Top 10 Substances for &P7_X_STATE_NAME.'')"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'RIGHT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35635850204709735)
,p_name=>'P7_6_LABEL'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(35629748800594334)
,p_prompt=>'Total Number of Distinct Characteristics Submitted for &P7_X_STATE_NAME.:&nbsp;&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35636029833709735)
,p_name=>'P7_6_VAL'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(35629748800594334)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select ''<strong>'' || trim(to_char(count(distinct fk_char),''999,999,999,999'')) || ''</strong>''',
'  from state_char_year',
' where fk_gen_geo_state = :P7_X_GEN_GEO_STATE'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'RIGHT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(35622737888360624)
,p_computation_sequence=>10
,p_computation_item=>'P7_X_STATE_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select state_name',
'  from di_geo_state',
' where pk_isn = :P7_X_GEN_GEO_STATE'))
,p_compute_when=>'P7_X_GEN_GEO_STATE'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(35648237146925167)
,p_computation_sequence=>10
,p_computation_item=>'F102_X_BREADCRUMB'
,p_computation_point=>'BEFORE_HEADER'
,p_computation=>'bitand(nvl(:F102_X_BREADCRUMB,1) + 8 - bitand(nvl(:F102_X_BREADCRUMB,1),8),15)'
);
end;
/
prompt --application/pages/page_00009
begin
wwv_flow_api.create_page(
 p_id=>9
,p_user_interface_id=>wwv_flow_api.id(34223238802660366)
,p_name=>'Data Owners Contribution'
,p_page_mode=>'NORMAL'
,p_step_title=>'Dashboard: Data Owners Contribution'
,p_step_sub_title_type=>'TEXT_WITH_SUBSTITUTIONS'
,p_first_item=>'NO_FIRST_ITEM'
,p_step_template=>wwv_flow_api.id(31007705311538595)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_chained=>'Y'
,p_overwrite_navigation_list=>'N'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_cache_mode=>'NOCACHE'
,p_cache_timeout_seconds=>21600
,p_last_updated_by=>'JTURAKA'
,p_last_upd_yyyymmddhh24miss=>'20151209105916'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35538024657134705)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(37712576903483127)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(31009000087660106)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'bitand(:F102_X_BREADCRUMB,2) = 0 AND bitand(:F102_X_BREADCRUMB,4) = 0 AND bitand(:F102_X_BREADCRUMB,8) = 0'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35538451715170914)
,p_plug_name=>'2012'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>11
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(35538621899170926)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1379900927779032'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V::None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>'200:::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
,p_legend_title=>'2012 Top 5'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P9_X_YEAR1..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P9_X_TOTAL1. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P9_X_YEAR1. Top 5 Orgs</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'      #DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(35538738544170982)
,p_chart_id=>wwv_flow_api.id(35538621899170926)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from state_org_year a, table(pkg_dynamic_list.get_years(:P9_X_YEAR1,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P9_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P9_X_GEN_GEO_STATE )',
'            and ( :P9_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P9_X_PROGRAM_AREA ) ) ',
'            and ( :P9_X_ORG_TYPE = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P9_X_ORG_TYPE ) ) ',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35539548653624273)
,p_plug_name=>'2011'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>21
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>2
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(35539727350624275)
,p_default_chart_type=>'2DPie'
,p_chart_title=>'2011'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1381006379232381'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P9_X_YEAR2..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P9_X_TOTAL2. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P9_X_YEAR2. Top 5 Orgs</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(35539845317624277)
,p_chart_id=>wwv_flow_api.id(35539727350624275)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from state_org_year a, table(pkg_dynamic_list.get_years(:P9_X_YEAR2,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P9_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P9_X_GEN_GEO_STATE )',
'            and ( :P9_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P9_X_PROGRAM_AREA ) ) ',
'            and ( :P9_X_ORG_TYPE = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P9_X_ORG_TYPE ) ) ',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35540122512654570)
,p_plug_name=>'2010'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>31
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>3
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(35540327541654572)
,p_default_chart_type=>'2DPie'
,p_chart_title=>'2010'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1381606570262678'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P9_X_YEAR3..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P9_X_TOTAL3. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P9_X_YEAR3. Top 5 Orgs</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(35540423866654573)
,p_chart_id=>wwv_flow_api.id(35540327541654572)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from state_org_year a, table(pkg_dynamic_list.get_years(:P9_X_YEAR3,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P9_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P9_X_GEN_GEO_STATE )',
'            and ( :P9_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P9_X_PROGRAM_AREA ) ) ',
'            and ( :P9_X_ORG_TYPE = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P9_X_ORG_TYPE ) ) ',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35540640997669347)
,p_plug_name=>'2009'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>41
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>4
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(35540828392669350)
,p_default_chart_type=>'2DPie'
,p_chart_title=>'2009'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1382107421277456'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P9_X_YEAR4..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P9_X_TOTAL4. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P9_X_YEAR4. Top 5 Orgs</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
end;
/
begin
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(35540924311669350)
,p_chart_id=>wwv_flow_api.id(35540828392669350)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from state_org_year a, table(pkg_dynamic_list.get_years(:P9_X_YEAR4,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P9_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P9_X_GEN_GEO_STATE )',
'            and ( :P9_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P9_X_PROGRAM_AREA ) ) ',
'            and ( :P9_X_ORG_TYPE = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P9_X_ORG_TYPE ) ) ',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35541023813673890)
,p_plug_name=>'2008'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>51
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>5
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(35541251455673895)
,p_default_chart_type=>'2DPie'
,p_chart_title=>'2009'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1382530484282001'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P9_X_YEAR5..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P9_X_TOTAL5. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P9_X_YEAR5. Top 5 Orgs</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(35541321126673898)
,p_chart_id=>wwv_flow_api.id(35541251455673895)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from state_org_year a, table(pkg_dynamic_list.get_years(:P9_X_YEAR5,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P9_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P9_X_GEN_GEO_STATE )',
'            and ( :P9_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P9_X_PROGRAM_AREA ) ) ',
'            and ( :P9_X_ORG_TYPE = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P9_X_ORG_TYPE ) ) ',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35544424375014705)
,p_plug_name=>'Search Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>5
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<p>These figures display the top five organizations within a state and/or organization type which submitted data to STORET, listed by the selected year, over the last five years. The records represent the data available in STORET on measurements of w'
||'ater quality as reported by ALL current organizations, including state, local, and tribal agencies and watershed groups. Data can represent biological, chemical, physical, habitat and continuous monitoring data.</p>',
'<p>Select a year, a State, an Organization Type, Program Area, and a Display Type using the dropdown menus.</p>'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35562348080076916)
,p_plug_name=>'Organization Selection'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>61
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<br>',
'<p>To view more details, use the pull down menu and select a single organization by name  to display Biological (fish, algae), Habitat (bank stability), and Physical/Chemical (pH, Temperature, metals).</p>'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35571435092680410)
,p_plug_name=>'Organization Details Charts Line 1'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>71
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<center>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35567424529770358)
,p_plug_name=>'Organization Details Year 1'
,p_region_name=>'OrgDetailsChartYear1'
,p_parent_plug_id=>wwv_flow_api.id(35571435092680410)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>81
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid=>true
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear1(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>',
''))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(35567646617770360)
,p_default_chart_type=>'Horizontal2DColumn'
,p_chart_title=>'&P9_X_YEAR1.'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1408925646378466'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:N:N:N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'Tahoma:10:#000000'
,p_y_axis_label_font=>'Tahoma:10:#000000'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:#000000'
,p_y_axis_title_font=>'Tahoma:14:#000000'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P9_X_YEAR1..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P9_X_YEAR1.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P9_X_YEAR1_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(35567724604770364)
,p_chart_id=>wwv_flow_api.id(35567646617770360)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P9_X_FK_ORG',
'   and act_start_year_date = :P9_X_YEAR1',
'   and (:P9_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P9_X_GEN_GEO_STATE)',
' group by result_type',
' order by label'))
,p_series_type=>'Bar'
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35570323290449905)
,p_plug_name=>'Organization Details Year 2'
,p_region_name=>'OrgDetailsChartYear2'
,p_parent_plug_id=>wwv_flow_api.id(35571435092680410)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>151
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>2
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear2(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(35570523364449910)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1411802393058016'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:::N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P9_X_YEAR2..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P9_X_YEAR2.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P9_X_YEAR2_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(35570639232449910)
,p_chart_id=>wwv_flow_api.id(35570523364449910)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P9_X_FK_ORG',
'   and act_start_year_date = :P9_X_YEAR2',
'   and (:P9_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P9_X_GEN_GEO_STATE)',
' group by result_type',
' order by label;'))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35570943488663918)
,p_plug_name=>'Organization Details Year 3'
,p_region_name=>'OrgDetailsChartYear3'
,p_parent_plug_id=>wwv_flow_api.id(35571435092680410)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>161
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>3
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear3(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
);
end;
/
begin
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(35571153371663918)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1412432400272024'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:::N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P9_X_YEAR3..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P9_X_YEAR3.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P9_X_YEAR3_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(35571229728663918)
,p_chart_id=>wwv_flow_api.id(35571153371663918)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P9_X_FK_ORG',
'   and act_start_year_date = :P9_X_YEAR3',
'   and (:P9_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P9_X_GEN_GEO_STATE)',
' group by result_type',
' order by label;'))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35574436140174745)
,p_plug_name=>'Organization Detail Charts Line 2'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>181
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35574734194183624)
,p_plug_name=>'Organization Details Year 4'
,p_region_name=>'OrgDetailsChartYear4'
,p_parent_plug_id=>wwv_flow_api.id(35574436140174745)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>191
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid=>true
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear4(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(35574934677183631)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1416213705791737'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:::N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P9_X_YEAR4..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P9_X_YEAR4.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P9_X_YEAR4_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>'))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(35575033186183632)
,p_chart_id=>wwv_flow_api.id(35574934677183631)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P9_X_FK_ORG',
'   and act_start_year_date = :P9_X_YEAR4',
'   and (:P9_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P9_X_GEN_GEO_STATE)',
' group by result_type',
' order by label;'))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35575234109202532)
,p_plug_name=>'Organization Details Year 5'
,p_region_name=>'OrgDetailsChartYear5'
,p_parent_plug_id=>wwv_flow_api.id(35574436140174745)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>201
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>2
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear5(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(35575426685202536)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1416705713810642'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:::N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P9_X_YEAR5..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P9_X_YEAR5.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P9_X_YEAR5_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>'))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(35575552574202536)
,p_chart_id=>wwv_flow_api.id(35575426685202536)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P9_X_FK_ORG',
'   and act_start_year_date = :P9_X_YEAR5',
'   and (:P9_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P9_X_GEN_GEO_STATE)',
' group by result_type',
' order by label;'))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35576731704353176)
,p_plug_name=>'State Top Organization Charts'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<center>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35578447334386077)
,p_plug_name=>'State Charts End Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>211
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'</center>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35579535044420465)
,p_plug_name=>'Organization Details End Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>221
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'</center>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'(:P9_X_GEN_GEO_STATE <> -1 OR :P9_X_ORG_TYPE <> -1) AND :P9_X_REPORT_TYPE = ''CHARTS'''
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35656823443150245)
,p_plug_name=>'Breadcrumb3'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(35650446974005666)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(31009000087660106)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'bitand(:F102_X_BREADCRUMB,2) = 0 AND bitand(:F102_X_BREADCRUMB,4) > 0 AND bitand(:F102_X_BREADCRUMB,8) > 0'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35657028638151723)
,p_plug_name=>'Breadcrumb4'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(35650549744006425)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(31009000087660106)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'bitand(:F102_X_BREADCRUMB,2) = 0 AND bitand(:F102_X_BREADCRUMB,4) = 0 AND bitand(:F102_X_BREADCRUMB,8) > 0'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35688545292794888)
,p_plug_name=>'Data Owners Contribution'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>231
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select a.organization_id,',
'       b.organization_name,',
'       sum(a.biological_count) as biological_count,',
'       sum(a.habitat_count) as habitat_count,',
'       sum(a.regular_count) as regular_count,',
'       dt.column_value,',
'       sum(a.result_count) as result_count,',
'       round(ratio_to_report(sum(result_count)) over (partition by dt.column_value) * 100,2) as perc,',
'       count(distinct fk_fa_statn) as station_count,',
'       max(a.max_last_change_date) as max_last_change_date',
'  from station_year a, di_org b, table(pkg_dynamic_list.get_years(:P9_X_YEAR,5)) dt                ',
' where dt.column_value = a.act_start_year_date',
'   and a.fk_org = b.pk_isn',
'   and ( :P9_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P9_X_GEN_GEO_STATE )',
'   and ( :P9_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                    from lu_orgtype',
'                                                   where fk_org_type = :P9_X_PROGRAM_AREA ) ) ',
'   and ( :P9_X_ORG_TYPE = -1 or a.fk_org in ( select fk_org',
'                                                from lu_orgtype',
'                                               where fk_org_type = :P9_X_ORG_TYPE ) )',
' group by a.organization_id, b.organization_name, dt.column_value'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_row_template=>1
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''TABLE'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(35688646920794888)
,p_name=>'Data Owners Contribution'
,p_max_row_count=>'100000'
,p_max_row_count_message=>'This query returns more than #MAX_ROW_COUNT# rows, please filter your data to ensure complete results.'
,p_no_data_found_message=>'No data found.'
,p_sort_asc_image=>'arrow_up_gray_light.gif'
,p_sort_asc_image_attr=>' width="13" height="12" '
,p_sort_desc_image=>'arrow_down_gray_light.gif'
,p_sort_desc_image_attr=>' width="13" height="12" '
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'TOP_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_pivot=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'DSPOREA'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(35690043841964823)
,p_db_column_name=>'ORGANIZATION_ID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'Organization Id'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'ORGANIZATION_ID'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(35690140961964825)
,p_db_column_name=>'BIOLOGICAL_COUNT'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Biological'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'BIOLOGICAL_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(35690253390964826)
,p_db_column_name=>'HABITAT_COUNT'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'Habitat'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'HABITAT_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(35690349080964826)
,p_db_column_name=>'REGULAR_COUNT'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>'Physical/Chemical'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'REGULAR_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(35690439106964826)
,p_db_column_name=>'COLUMN_VALUE'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>'Year'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'COLUMN_VALUE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(35690538900964826)
,p_db_column_name=>'RESULT_COUNT'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>'Total'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'RESULT_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(35690752518964827)
,p_db_column_name=>'PERC'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>'Percentage'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'PERC'
);
end;
/
begin
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(36339225535546288)
,p_db_column_name=>'STATION_COUNT'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>'Stations'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'STATION_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(36367844176045095)
,p_db_column_name=>'ORGANIZATION_NAME'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>'Organization Name'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'ORGANIZATION_NAME'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(30965696463107342)
,p_db_column_name=>'MAX_LAST_CHANGE_DATE'
,p_display_order=>11
,p_column_identifier=>'K'
,p_column_label=>'Last Change Date'
,p_allow_pivot=>'N'
,p_column_type=>'DATE'
,p_tz_dependent=>'N'
,p_static_id=>'MAX_LAST_CHANGE_DATE'
);
wwv_flow_api.create_worksheet_rpt(
 p_id=>wwv_flow_api.id(35689345985795173)
,p_application_user=>'APXWS_DEFAULT'
,p_report_seq=>10
,p_report_alias=>'15307'
,p_status=>'PUBLIC'
,p_is_default=>'Y'
,p_display_rows=>15
,p_report_columns=>'ORGANIZATION_ID:ORGANIZATION_NAME:STATION_COUNT:BIOLOGICAL_COUNT:HABITAT_COUNT:REGULAR_COUNT:COLUMN_VALUE:RESULT_COUNT:PERC:MAX_LAST_CHANGE_DATE'
,p_sort_column_1=>'COLUMN_VALUE'
,p_sort_direction_1=>'DESC'
,p_sort_column_2=>'PERC'
,p_sort_direction_2=>'DESC'
,p_sort_column_3=>'RESULT_COUNT'
,p_sort_direction_3=>'DESC'
,p_sort_column_4=>'0'
,p_sort_direction_4=>'ASC'
,p_sort_column_5=>'0'
,p_sort_direction_5=>'ASC'
,p_sort_column_6=>'0'
,p_sort_direction_6=>'ASC'
,p_break_on=>'COLUMN_VALUE:0:0:0:0:0'
,p_break_enabled_on=>'COLUMN_VALUE:0:0:0:0:0'
,p_flashback_enabled=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(35565141818575061)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(35562348080076916)
,p_button_name=>'P9_REFRESH'
,p_button_static_id=>'P9_REFRESH'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(27668368034614464)
,p_button_image_alt=>'Submit'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT-CENTER'
,p_grid_column_attributes=>'valign="top"'
,p_grid_new_grid=>false
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(35561552244803670)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(35544424375014705)
,p_button_name=>'P9_GO'
,p_button_static_id=>'P9_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(27668368034614464)
,p_button_image_alt=>'Submit'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT'
,p_grid_new_grid=>false
,p_grid_new_row=>'Y'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35541728258921183)
,p_name=>'P9_X_YEAR1'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(35538451715170914)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35542052153928068)
,p_name=>'P9_X_YEAR2'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(35539548653624273)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')) - 1'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35542226311930062)
,p_name=>'P9_X_YEAR3'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(35540122512654570)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')) - 2'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35542432545931867)
,p_name=>'P9_X_YEAR4'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(35540640997669347)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')) - 3'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35542640856934345)
,p_name=>'P9_X_YEAR5'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(35541023813673890)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')) - 4'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35544841690019651)
,p_name=>'P9_X_GEN_GEO_STATE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(35544424375014705)
,p_prompt=>'<strong>Select State:</strong>&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'          select st.state_name,',
'                 st.pk_isn',
'            from di_geo_state st',
'           where country_code = ''US''',
'             and epa_region_code is not null',
'           order by 2'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- ALL STATES -'
,p_lov_null_value=>'-1'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35545653249032501)
,p_name=>'P9_X_STATE_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(35544424375014705)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35561440123800214)
,p_name=>'P9_1_0'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(35544424375014705)
,p_prompt=>'&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35562734190120189)
,p_name=>'P9_X_FK_ORG'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(35562348080076916)
,p_prompt=>'<strong>Select Organization:</strong>&nbsp;&nbsp;'
,p_post_element_text=>'&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select distinct c.organization_id || '' - '' || c.organization_name as org_name,',
'       c.pk_isn as org_id',
'  from state_org_year a, di_org c',
' where ( :P9_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P9_X_GEN_GEO_STATE )',
'   and ( :P9_X_ORG_TYPE = -1 or a.fk_org in ( select fk_org',
'                                                from lu_orgtype',
'                                               where fk_org_type = :P9_X_ORG_TYPE ) )',
'            and ( :P9_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P9_X_PROGRAM_AREA ) ) ',
'   and a.act_start_year_date between to_number(:P9_X_YEAR5) and to_number(:P9_X_YEAR1)',
'   and a.fk_org = c.pk_isn ',
' order by 1 '))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- SELECT -'
,p_lov_null_value=>'0'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35604443469338655)
,p_name=>'P9_X_YEAR'
,p_is_required=>true
,p_item_sequence=>2
,p_item_plug_id=>wwv_flow_api.id(35544424375014705)
,p_prompt=>'<strong>Select Year:</strong>&nbsp;&nbsp;'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_char(sysdate,''YYYY'')',
'  from dual;'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_number(column_value) as n,',
'       to_number(column_value) as v',
'  from table(pkg_dynamic_list.get_years(null,to_number(to_char(sysdate,''YYYY'')) - 1899))',
' order by 1 desc;'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35605453726032398)
,p_name=>'P9_X_TOTAL1'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(35538451715170914)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35605625807033781)
,p_name=>'P9_X_TOTAL2'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(35539548653624273)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35605831348035408)
,p_name=>'P9_X_TOTAL3'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(35540122512654570)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35606036542036908)
,p_name=>'P9_X_TOTAL4'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(35540640997669347)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35606241044038188)
,p_name=>'P9_X_TOTAL5'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(35541023813673890)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35685743280624016)
,p_name=>'P9_X_REPORT_TYPE'
,p_is_required=>true
,p_item_sequence=>15
,p_item_plug_id=>wwv_flow_api.id(35544424375014705)
,p_prompt=>'<strong>Select Display Type:</strong>&nbsp;&nbsp;'
,p_source=>'CHARTS'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_RADIOGROUP'
,p_lov=>'STATIC2:Top 5 Organizations Charts;CHARTS,All Organizations Table;TABLE'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'1'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35712827340555165)
,p_name=>'P9_X_ORG_TYPE'
,p_item_sequence=>12
,p_item_plug_id=>wwv_flow_api.id(35544424375014705)
,p_prompt=>'<strong>Select Organization Type:</strong>&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select organization_type,',
'       pk_isn',
'  from di_org_types',
' where pk_isn < 100',
' order by sort_order'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- ALL TYPES -'
,p_lov_null_value=>'-1'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(37718475221928950)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36264329204417398)
,p_name=>'P9_X_PROGRAM_AREA'
,p_item_sequence=>14
,p_item_plug_id=>wwv_flow_api.id(35544424375014705)
,p_prompt=>'<strong>Select Program Area:</strong>&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select organization_type,',
'       pk_isn',
'  from di_org_types',
' where pk_isn >= 100',
' order by sort_order'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- ALL AREAS -'
,p_lov_null_value=>'-1'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(37718475221928950)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36340138184163355)
,p_name=>'P9_X_YEAR1_ST'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(35567424529770358)
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36340334302165179)
,p_name=>'P9_X_YEAR2_ST'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(35570323290449905)
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36340530421167014)
,p_name=>'P9_X_YEAR3_ST'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(35570943488663918)
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36340726323168910)
,p_name=>'P9_X_YEAR4_ST'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(35574734194183624)
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36340923519170223)
,p_name=>'P9_X_YEAR5_ST'
,p_item_sequence=>150
,p_item_plug_id=>wwv_flow_api.id(35575234109202532)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(35543439433981212)
,p_computation_sequence=>10
,p_computation_item=>'P9_X_YEAR1'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P9_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')))'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(35543649130983994)
,p_computation_sequence=>10
,p_computation_item=>'P9_X_YEAR2'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P9_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))) - 1'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(35543852939985109)
,p_computation_sequence=>10
,p_computation_item=>'P9_X_YEAR3'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P9_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))) - 2'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(35544024673986365)
,p_computation_sequence=>10
,p_computation_item=>'P9_X_YEAR4'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P9_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))) - 3'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(35544229175987693)
,p_computation_sequence=>10
,p_computation_item=>'P9_X_YEAR5'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P9_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))) - 4'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(35546029616044580)
,p_computation_sequence=>10
,p_computation_item=>'P9_X_STATE_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select state_name',
'  from di_geo_state',
' where pk_isn = :P9_X_GEN_GEO_STATE'))
,p_compute_when=>':P9_X_GEN_GEO_STATE <> -1'
,p_compute_when_type=>'SQL_EXPRESSION'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(35569128826206856)
,p_computation_sequence=>10
,p_computation_item=>'P9_X_FK_ORG'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'0'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(35648426195931463)
,p_computation_sequence=>10
,p_computation_item=>'F102_X_BREADCRUMB'
,p_computation_point=>'BEFORE_HEADER'
,p_computation=>'bitand(nvl(:F102_X_BREADCRUMB,1) + 16 - bitand(nvl(:F102_X_BREADCRUMB,1),16),31)'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(35566138793604171)
,p_name=>'Refresh Organization Details'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(35565141818575061)
,p_bind_type=>'live'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(35566847675672991)
,p_event_id=>wwv_flow_api.id(35566138793604171)
,p_event_result=>'TRUE'
,p_action_sequence=>5
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'begin',
'  for c in (',
'     select dt.column_value as year_no,',
'            count(distinct a.fk_fa_statn) as station_count',
'       from station_year a, table(pkg_dynamic_list.get_years(:P9_X_YEAR1)) dt                ',
'      where dt.column_value = a.act_start_year_date',
'        and a.fk_org = :P9_X_FK_ORG',
'        and ( :P9_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P9_X_GEN_GEO_STATE )',
'      group by dt.column_value  ',
'  )',
'  loop',
'     if c.year_no = :P9_X_YEAR1 then',
'        :P9_X_YEAR1_ST := c.station_count;',
'     elsif c.year_no = :P9_X_YEAR2 then',
'        :P9_X_YEAR2_ST := c.station_count;',
'     elsif c.year_no = :P9_X_YEAR3 then',
'        :P9_X_YEAR3_ST := c.station_count;',
'     elsif c.year_no = :P9_X_YEAR4 then',
'        :P9_X_YEAR4_ST := c.station_count;',
'     elsif c.year_no = :P9_X_YEAR5 then',
'        :P9_X_YEAR5_ST := c.station_count;',
'     end if;',
'  end loop;',
'end;'))
,p_attribute_02=>'P9_X_FK_ORG,P9_X_YEAR1_ST,P9_X_YEAR2_ST,P9_X_YEAR3_ST,P9_X_YEAR4_ST,P9_X_YEAR5_ST'
,p_stop_execution_on_error=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(36262230679398650)
,p_event_id=>wwv_flow_api.id(35566138793604171)
,p_event_result=>'TRUE'
,p_action_sequence=>15
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'apex.jQuery( "#OrgDetailsChartYear1_chart" ).trigger( "apexrefresh" );',
'apex.jQuery( "#OrgDetailsChartYear2_chart" ).trigger( "apexrefresh" );',
'apex.jQuery( "#OrgDetailsChartYear3_chart" ).trigger( "apexrefresh" );',
'apex.jQuery( "#OrgDetailsChartYear4_chart" ).trigger( "apexrefresh" );',
'apex.jQuery( "#OrgDetailsChartYear5_chart" ).trigger( "apexrefresh" );'))
,p_stop_execution_on_error=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(35606331825045059)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Compute Totals'
,p_process_sql_clob=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'begin',
'   for c in (',
'      select trim(to_char(sum(a.result_count),''999,999,999,999'')) as total_count,',
'             a.act_start_year_date as year_no',
'        from state_org_year a                ',
'       where a.act_start_year_date in (:P9_X_YEAR1, :P9_X_YEAR2, :P9_X_YEAR3, :P9_X_YEAR4, :P9_X_YEAR5)',
'         and ( :P9_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P9_X_GEN_GEO_STATE )',
'         and ( :P9_X_ORG_TYPE = -1 or a.fk_org in ( select fk_org',
'                                                      from lu_orgtype',
'                                                     where fk_org_type = :P9_X_ORG_TYPE ) )',
'         and ( :P9_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                          from lu_orgtype',
'                                                         where fk_org_type = :P9_X_PROGRAM_AREA ) )',
'       group by a.act_start_year_date',
'  )',
'  loop',
'     if c.year_no = :P9_X_YEAR1 then',
'        :P9_X_TOTAL1 := c.total_count;',
'     elsif c.year_no = :P9_X_YEAR2 then',
'        :P9_X_TOTAL2 := c.total_count;',
'     elsif c.year_no = :P9_X_YEAR3 then',
'        :P9_X_TOTAL3 := c.total_count;',
'     elsif c.year_no = :P9_X_YEAR4 then',
'        :P9_X_TOTAL4 := c.total_count;',
'     elsif c.year_no = :P9_X_YEAR5 then',
'        :P9_X_TOTAL5 := c.total_count;',
'     end if;',
'  end loop;',
'',
'  for c in (',
'     select fk_org',
'       from ( select a.fk_org,',
'                     dense_rank() over (order by act_start_year_date desc, result_count desc) as rnk',
'                from state_org_year a, table(pkg_dynamic_list.get_years(:P9_X_YEAR1)) dt                ',
'               where dt.column_value = a.act_start_year_date',
'                 and ( :P9_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P9_X_GEN_GEO_STATE )  ',
'                 and ( :P9_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                              from lu_orgtype',
'                                                             where fk_org_type = :P9_X_PROGRAM_AREA ) ) ',
'                 and ( :P9_X_ORG_TYPE = -1 or a.fk_org in ( select fk_org',
'                                                              from lu_orgtype',
'                                                             where fk_org_type = :P9_X_ORG_TYPE ) ) )',
'      where rnk = 1',
'  )',
'  loop',
'',
'     :P9_X_FK_ORG := c.fk_org;',
'',
'  end loop;',
'',
'  for c in (',
'     select dt.column_value as year_no,',
'            count(distinct a.fk_fa_statn) as station_count',
'       from station_year a, table(pkg_dynamic_list.get_years(:P9_X_YEAR1)) dt                ',
'      where dt.column_value = a.act_start_year_date',
'        and a.fk_org = :P9_X_FK_ORG',
'        and ( :P9_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P9_X_GEN_GEO_STATE )',
'      group by dt.column_value  ',
'  )',
'  loop',
'     if c.year_no = :P9_X_YEAR1 then',
'        :P9_X_YEAR1_ST := c.station_count;',
'     elsif c.year_no = :P9_X_YEAR2 then',
'        :P9_X_YEAR2_ST := c.station_count;',
'     elsif c.year_no = :P9_X_YEAR3 then',
'        :P9_X_YEAR3_ST := c.station_count;',
'     elsif c.year_no = :P9_X_YEAR4 then',
'        :P9_X_YEAR4_ST := c.station_count;',
'     elsif c.year_no = :P9_X_YEAR5 then',
'        :P9_X_YEAR5_ST := c.station_count;',
'     end if;',
'  end loop;',
'',
'end;'))
,p_process_when=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL AND :P9_X_PROGRAM_AREA IS NOT NULL'
,p_process_when_type=>'SQL_EXPRESSION'
);
end;
/
prompt --application/pages/page_00010
begin
wwv_flow_api.create_page(
 p_id=>10
,p_user_interface_id=>wwv_flow_api.id(34223238802660366)
,p_name=>'Top 10 Substances for Past 5 Years By State'
,p_page_mode=>'NORMAL'
,p_step_title=>'Top 10 Substances for Past 5 Years By State'
,p_step_sub_title=>'Top 10 Substances for Past 5 Years By State'
,p_step_sub_title_type=>'TEXT_WITH_SUBSTITUTIONS'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_step_template=>wwv_flow_api.id(31007705311538595)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_chained=>'Y'
,p_overwrite_navigation_list=>'N'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_cache_mode=>'NOCACHE'
,p_cache_timeout_seconds=>21600
,p_help_text=>'No help is available for this page.'
,p_last_updated_by=>'JTURAKA'
,p_last_upd_yyyymmddhh24miss=>'20151209191108'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30945221965090542)
,p_plug_name=>'Top 10 Substances for Past 5 Years for &P10_X_SELECTED_STATE.'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(37710582515483112)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'  select activity_year,',
'       substance,     ',
'       result_count,',
'       ''Get Results'' results,',
'       state_code ,',
'     min(char_isn) as char_isn',
'  from ( select DISTINCT /*+ DYNAMIC_SAMPLING(dt 5) */',
'                a.display_name as substance,',
'                sum(regular_count) over (partition by dt.column_value, c.pk_isn order by c.pk_isn) as result_count,',
'                dt.column_value as activity_year,',
'                a.fk_gen_geo_state as state_code,',
'                dense_rank() over (partition by dt.column_value order by regular_count desc) as rnk,',
'                c.pk_isn as char_isn',
'           from state_char_year a,',
'                table(pkg_dynamic_list.get_years(:P10_X_YEAR,5)) dt,',
'                di_characteristic c',
'          where dt.column_value = A.ACT_START_YEAR_DATE (+)',
'            and a.fk_gen_geo_state (+) = :P10_FK_GEN_GEO_STATE ',
'            and a.display_name = c.display_name )  ',
' where rnk <= 10 ',
' group by activity_year,substance,result_count,''Get Results'',state_code',
' order by activity_year desc, result_count desc;'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_row_template=>1
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P10_FK_GEN_GEO_STATE'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(30945397905090542)
,p_name=>'Top 10 Substances for Past 5 Years By State'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'This query returns more than 10,000 rows, please filter your data to ensure complete results.'
,p_no_data_found_message=>'No data found.'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_pivot=>'N'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_detail_link_text=>'<img src="#IMAGE_PREFIX#menu/pencil16x16.gif" alt="" />'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'DSPOREA'
,p_internal_uid=>3278202804476228
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(30945508755090542)
,p_db_column_name=>'ACTIVITY_YEAR'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'Activity Year'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'ACTIVITY_YEAR'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(30945609917090542)
,p_db_column_name=>'SUBSTANCE'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Substance'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'SUBSTANCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(30945705725090543)
,p_db_column_name=>'RESULT_COUNT'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'Result Count'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'RESULT_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(30945803817090543)
,p_db_column_name=>'RESULTS'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>'Results'
,p_column_link=>'http://ofmpub.epa.gov/storpubl/dw_pages.resultquery_count?geographic=multipleStates&as_multiple_state=#STATE_CODE#&as_county=ALL&v_county_code=ALL&FROM_MON1=JAN&FROM_DD1=1&FROM_YYYY1=#ACTIVITY_YEAR#&END_MON1=DEC&END_DD1=31&END_YYYY1=#ACTIVITY_YEAR#&D'
||'_MEDIUM_LIST=ALL&D_INTENT_LIST=ALL&D_COMMUNITY_LIST=ALL&v_char_names=#SUBSTANCE#&char_list=dummy&char_list=#CHAR_ISN#&char_filter=selected&D_CHARGRPTYP_LIST=ALL&D_CHARTYP_LIST=ALL&RESULT_TYPE=ALLRESULTS&SOURCE_APP=FILTERPAGE'
,p_column_linktext=>'#RESULTS#'
,p_column_link_attr=>'target="_blank"'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_tz_dependent=>'N'
,p_static_id=>'RESULTS'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(30945898573090543)
,p_db_column_name=>'STATE_CODE'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>'State Code'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_display_text_as=>'HIDDEN'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'STATE_CODE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(30946004348090543)
,p_db_column_name=>'CHAR_ISN'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>'Char Isn'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_display_text_as=>'HIDDEN'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'CHAR_ISN'
);
wwv_flow_api.create_worksheet_rpt(
 p_id=>wwv_flow_api.id(30946095705090543)
,p_application_user=>'APXWS_DEFAULT'
,p_report_seq=>10
,p_report_alias=>'32790'
,p_status=>'PUBLIC'
,p_is_default=>'Y'
,p_display_rows=>10000
,p_report_columns=>'ACTIVITY_YEAR:SUBSTANCE:RESULT_COUNT:RESULTS:CHAR_ISN'
,p_sort_column_1=>'ACTIVITY_YEAR'
,p_sort_direction_1=>'DESC'
,p_sort_column_2=>'RESULT_COUNT'
,p_sort_direction_2=>'DESC'
,p_sort_column_3=>'SUBSTANCE'
,p_sort_direction_3=>'ASC'
,p_sort_column_4=>'0'
,p_sort_direction_4=>'ASC'
,p_sort_column_5=>'0'
,p_sort_direction_5=>'ASC'
,p_sort_column_6=>'0'
,p_sort_direction_6=>'ASC'
,p_break_on=>'ACTIVITY_YEAR:0:0:0:0:0'
,p_break_enabled_on=>'ACTIVITY_YEAR:0:0:0:0:0'
,p_flashback_enabled=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30946518500090545)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(37712576903483127)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(31009000087660106)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'bitand(:F102_X_BREADCRUMB,2) = 0 AND bitand(:F102_X_BREADCRUMB,4) = 0 AND bitand(:F102_X_BREADCRUMB,8) = 0'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30946710951090546)
,p_plug_name=>'Top 10 Substances for Past 5 Years By State'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_08'
,p_menu_id=>wwv_flow_api.id(37712576903483127)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(25853960577757693)
,p_plug_query_row_template=>1
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30947310037090547)
,p_plug_name=>'Search Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<p>These tables provide a count of the  top ten substances within a state''s waters, listed by year, over the last five years. The records represent the data available in STORET on measurements of water quality as reported by ALL current organizations'
||', including state, local, and tribal agencies and watershed groups.</p>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(30947700659090547)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(30947310037090547)
,p_button_name=>'P10_GO'
,p_button_static_id=>'P10_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(27668368034614464)
,p_button_image_alt=>'Query'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT'
,p_request_source=>'Go'
,p_request_source_type=>'STATIC'
,p_grid_new_grid=>false
,p_grid_new_row=>'Y'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(30946314066090543)
,p_button_sequence=>70
,p_button_plug_id=>wwv_flow_api.id(30945221965090542)
,p_button_name=>'P10_GET_RESULTS'
,p_button_static_id=>'P10_GET_RESULTS'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(27668368034614464)
,p_button_image_alt=>'Get All  Results'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT'
,p_button_execute_validations=>'N'
,p_button_condition_type=>'NEVER'
,p_button_cattributes=>'target="_blank"'
,p_request_source=>'GetResults'
,p_request_source_type=>'STATIC'
,p_grid_new_grid=>false
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(30947498336090547)
,p_name=>'P10_X_YEAR'
,p_is_required=>true
,p_item_sequence=>5
,p_item_plug_id=>wwv_flow_api.id(30947310037090547)
,p_prompt=>'<strong>Select Year:</strong>&nbsp;&nbsp;'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_char(sysdate,''YYYY'')',
'  from dual;'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_number(column_value) as n,',
'       to_number(column_value) as v',
'  from table(pkg_dynamic_list.get_years(null,to_number(to_char(sysdate,''YYYY'')) - 1899))',
' order by 1 desc;'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(30947924851090547)
,p_name=>'P10_FK_GEN_GEO_STATE'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(30947310037090547)
,p_prompt=>'<Strong>Select State:</Strong>&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select state_name,',
'       pk_isn ',
'  from di_geo_state',
' where country_code = ''US''',
'   and epa_region_code is not null',
' order by state_name'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'-SELECT-'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(30948106718090547)
,p_name=>'P10_1_0'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(30947310037090547)
,p_prompt=>'&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(30948324301090547)
,p_name=>'P10_X_SELECTED_STATE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(30947310037090547)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(30948600253090548)
,p_computation_sequence=>10
,p_computation_item=>'P10_X_SELECTED_STATE'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select state_name',
'  from di_geo_state',
' where pk_isn = :P10_FK_GEN_GEO_STATE'))
,p_compute_when=>'P10_FK_GEN_GEO_STATE'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(30948806822090548)
,p_computation_sequence=>20
,p_computation_item=>'F102_X_BREADCRUMB'
,p_computation_point=>'BEFORE_HEADER'
,p_computation=>'bitand(nvl(:F102_X_BREADCRUMB,1) + 32 - bitand(nvl(:F102_X_BREADCRUMB,1),32),63)'
);
end;
/
prompt --application/pages/page_00011
begin
wwv_flow_api.create_page(
 p_id=>11
,p_user_interface_id=>wwv_flow_api.id(34223238802660366)
,p_name=>'All Tribes'
,p_page_mode=>'NORMAL'
,p_step_title=>'All Tribes'
,p_step_sub_title=>'All Tribes'
,p_step_sub_title_type=>'TEXT_WITH_SUBSTITUTIONS'
,p_first_item=>'NO_FIRST_ITEM'
,p_step_template=>wwv_flow_api.id(31007705311538595)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_chained=>'Y'
,p_overwrite_navigation_list=>'N'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_cache_mode=>'NOCACHE'
,p_cache_timeout_seconds=>21600
,p_last_updated_by=>'JTURAKA'
,p_last_upd_yyyymmddhh24miss=>'20151209191613'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(27694493284886174)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>240
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(37712576903483127)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(31009000087660106)
,p_plug_query_row_template=>1
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30990709040366058)
,p_plug_name=>'2010'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>100
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>3
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P11_X_GEN_GEO_STATE IS NOT NULL AND :P11_X_REPORT_TYPE = ''CHARTS'''
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(30990911160366058)
,p_default_chart_type=>'2DPie'
,p_chart_title=>'2010'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1381606570262678'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P11_X_YEAR3..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P11_X_TOTAL3. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P11_X_YEAR3. Top 5 Tribes</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(30990999630366062)
,p_chart_id=>wwv_flow_api.id(30990911160366058)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from tribal_state_org_year a, table(pkg_dynamic_list.get_years(:P11_X_YEAR3,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P11_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P11_X_GEN_GEO_STATE )',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30991503419366062)
,p_plug_name=>'State Top Organization Charts'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>70
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<center>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P11_X_GEN_GEO_STATE IS NOT NULL AND :P11_X_REPORT_TYPE = ''CHARTS'''
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30991697304366063)
,p_plug_name=>'2011'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>90
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>2
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P11_X_GEN_GEO_STATE IS NOT NULL AND :P11_X_REPORT_TYPE = ''CHARTS'''
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(30991909376366064)
,p_default_chart_type=>'2DPie'
,p_chart_title=>'2011'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1381006379232381'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P11_X_YEAR2..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P11_X_TOTAL2. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P11_X_YEAR2. Top 5 Tribes</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(30992021024366064)
,p_chart_id=>wwv_flow_api.id(30991909376366064)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from tribal_state_org_year a, table(pkg_dynamic_list.get_years(:P11_X_YEAR2,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P11_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P11_X_GEN_GEO_STATE )',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30992522049366065)
,p_plug_name=>'Data Owners Contribution'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>140
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select a.organization_id,',
'       b.organization_name,',
'       sum(a.biological_count) as biological_count,',
'       sum(a.habitat_count) as habitat_count,',
'       sum(a.regular_count) as regular_count,',
'       dt.column_value,',
'       sum(a.result_count) as result_count,',
'       round(ratio_to_report(sum(result_count)) over (partition by dt.column_value) * 100,2) as perc,',
'       count(distinct fk_fa_statn) as station_count,',
'       max(a.max_last_change_date) as max_last_change_date',
'  from tribal_station_year a, di_org b, table(pkg_dynamic_list.get_years(:P11_X_YEAR,5)) dt                ',
' where dt.column_value = a.act_start_year_date',
'   and a.fk_org = b.pk_isn',
'   and ( :P11_X_EPA_REGION = -1 or  b.fk_eparegion = :P11_X_EPA_REGION ) ',
'   and ( :P11_X_GEN_GEO_STATE = -1 or  a.fk_gen_geo_state = :P11_X_GEN_GEO_STATE ) ',
' group by a.organization_id, b.organization_name, dt.column_value',
' '))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_row_template=>1
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P11_X_GEN_GEO_STATE IS NOT NULL AND :P11_X_REPORT_TYPE = ''TABLE'''
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(30992700610366065)
,p_name=>'Data Owners Contribution'
,p_max_row_count=>'100000'
,p_max_row_count_message=>'This query returns more than #MAX_ROW_COUNT# rows, please filter your data to ensure complete results.'
,p_no_data_found_message=>'No data found.'
,p_sort_asc_image=>'arrow_up_gray_light.gif'
,p_sort_asc_image_attr=>' width="13" height="12" '
,p_sort_desc_image=>'arrow_down_gray_light.gif'
,p_sort_desc_image_attr=>' width="13" height="12" '
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'TOP_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_pivot=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_detail_link_text=>'<img src="#IMAGE_PREFIX#menu/pencil16x16.gif" alt="" />'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'DSPOREA'
,p_internal_uid=>3325505509751751
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(30992801992366066)
,p_db_column_name=>'ORGANIZATION_ID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'Organization Id'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'ORGANIZATION_ID'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(30992922317366066)
,p_db_column_name=>'BIOLOGICAL_COUNT'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Biological'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'BIOLOGICAL_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(30993000142366066)
,p_db_column_name=>'HABITAT_COUNT'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'Habitat'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'HABITAT_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(30993111727366066)
,p_db_column_name=>'REGULAR_COUNT'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>'Physical/Chemical'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'REGULAR_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(30993202371366066)
,p_db_column_name=>'COLUMN_VALUE'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>'Year'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'COLUMN_VALUE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(30993322969366066)
,p_db_column_name=>'RESULT_COUNT'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>'Total'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'RESULT_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(30993397219366066)
,p_db_column_name=>'PERC'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>'Percentage'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'PERC'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(30993505782366066)
,p_db_column_name=>'STATION_COUNT'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>'Stations'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'STATION_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(30993609275366066)
,p_db_column_name=>'ORGANIZATION_NAME'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>'Organization Name'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'ORGANIZATION_NAME'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(30993695874366066)
,p_db_column_name=>'MAX_LAST_CHANGE_DATE'
,p_display_order=>11
,p_column_identifier=>'K'
,p_column_label=>'Last Change Date'
,p_allow_pivot=>'N'
,p_column_type=>'DATE'
,p_tz_dependent=>'N'
,p_static_id=>'MAX_LAST_CHANGE_DATE'
);
wwv_flow_api.create_worksheet_rpt(
 p_id=>wwv_flow_api.id(30993813548366066)
,p_application_user=>'APXWS_DEFAULT'
,p_report_seq=>10
,p_report_alias=>'33267'
,p_status=>'PUBLIC'
,p_is_default=>'Y'
,p_display_rows=>15
,p_report_columns=>'ORGANIZATION_ID:STATION_COUNT:BIOLOGICAL_COUNT:HABITAT_COUNT:REGULAR_COUNT:COLUMN_VALUE:RESULT_COUNT:PERC:ORGANIZATION_NAME:MAX_LAST_CHANGE_DATE:'
,p_sort_column_1=>'COLUMN_VALUE'
,p_sort_direction_1=>'DESC'
,p_sort_column_2=>'PERC'
,p_sort_direction_2=>'DESC'
,p_sort_column_3=>'RESULT_COUNT'
,p_sort_direction_3=>'DESC'
,p_sort_column_4=>'0'
,p_sort_direction_4=>'ASC'
,p_sort_column_5=>'0'
,p_sort_direction_5=>'ASC'
,p_sort_column_6=>'0'
,p_sort_direction_6=>'ASC'
,p_break_on=>'COLUMN_VALUE:0:0:0:0:0'
,p_break_enabled_on=>'COLUMN_VALUE:0:0:0:0:0'
,p_flashback_enabled=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30994025804366067)
,p_plug_name=>'Search Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>60
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<p>These figures display the top five organizations within a state and/or organization type which submitted data to STORET, listed by the selected year, over the last five years. The records represent the data available in STORET on measurements of w'
||'ater quality as reported by ALL current tribal agencies. Data can represent biological, chemical, physical, habitat and continuous monitoring data.</p>',
'<p>Select a year, a State, a Tribe, and a Display Type using the dropdown menus.</p>'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30996017251366070)
,p_plug_name=>'State Charts End Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>130
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'</center>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P11_X_GEN_GEO_STATE IS NOT NULL AND :P11_X_REPORT_TYPE = ''CHARTS'''
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30996202143366071)
,p_plug_name=>'Organization Selection'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>150
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<br>',
'<p>To view more details, use the pull down menu and select a single organization by name  to display Biological (fish, algae), Habitat (bank stability), and Physical/Chemical (pH, Temperature, metals).</p>'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P11_X_GEN_GEO_STATE IS NOT NULL AND :P11_X_REPORT_TYPE = ''CHARTS'''
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30996804409366071)
,p_plug_name=>'2012'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>80
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P11_X_GEN_GEO_STATE IS NOT NULL AND :P11_X_REPORT_TYPE = ''CHARTS'''
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(30996996136366072)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1379900927779032'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V::None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>'200:::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
,p_legend_title=>'2012 Top 5'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P11_X_YEAR1..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P11_X_TOTAL1. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P11_X_YEAR1. Top 5 Tribes</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'      #DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
end;
/
begin
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(30997101373366073)
,p_chart_id=>wwv_flow_api.id(30996996136366072)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from tribal_state_org_year a, table(pkg_dynamic_list.get_years(:P11_X_YEAR1,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P11_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P11_X_GEN_GEO_STATE )',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30997608960366073)
,p_plug_name=>'Organization Details Charts Line 1'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>160
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<center>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P11_X_GEN_GEO_STATE IS NOT NULL AND :P11_X_REPORT_TYPE = ''CHARTS'''
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30997814128366074)
,p_plug_name=>'Organization Details Year 1'
,p_parent_plug_id=>wwv_flow_api.id(30997608960366073)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid=>true
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear1(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>',
''))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P11_X_GEN_GEO_STATE IS NOT NULL AND :P11_X_REPORT_TYPE = ''CHARTS'''
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(30998003943366074)
,p_default_chart_type=>'Horizontal2DColumn'
,p_chart_title=>'&P11_X_YEAR1.'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1408925646378466'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:N:N:N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'Tahoma:10:#000000'
,p_y_axis_label_font=>'Tahoma:10:#000000'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:#000000'
,p_y_axis_title_font=>'Tahoma:14:#000000'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P11_X_YEAR1..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P11_X_YEAR1.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P11_X_YEAR1_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(30998115868366074)
,p_chart_id=>wwv_flow_api.id(30998003943366074)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from tribal_state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P11_X_FK_TRIBE',
'   and act_start_year_date = :P11_X_YEAR1',
'   and (:P11_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P11_X_GEN_GEO_STATE)',
' group by result_type',
' order by label'))
,p_series_type=>'Bar'
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30998421612366074)
,p_plug_name=>'Organization Details Year 2'
,p_parent_plug_id=>wwv_flow_api.id(30997608960366073)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>2
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear2(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P11_X_GEN_GEO_STATE IS NOT NULL AND :P11_X_REPORT_TYPE = ''CHARTS'''
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(30998597944366075)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1411802393058016'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:::N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P11_X_YEAR2..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P11_X_YEAR2.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P11_X_YEAR2_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(30998726210366075)
,p_chart_id=>wwv_flow_api.id(30998597944366075)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from tribal_state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P11_X_FK_TRIBE',
'   and act_start_year_date = :P11_X_YEAR2',
'   and (:P11_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P11_X_GEN_GEO_STATE)',
' group by result_type',
' order by label;'))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30999022077366076)
,p_plug_name=>'Organization Details Year 3'
,p_parent_plug_id=>wwv_flow_api.id(30997608960366073)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>3
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear3(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P11_X_GEN_GEO_STATE IS NOT NULL AND :P11_X_REPORT_TYPE = ''CHARTS'''
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(30999218419366076)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1412432400272024'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:::N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P11_X_YEAR3..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P11_X_YEAR3.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P11_X_YEAR3_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(30999297078366077)
,p_chart_id=>wwv_flow_api.id(30999218419366076)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from tribal_state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P11_X_FK_TRIBE',
'   and act_start_year_date = :P11_X_YEAR3',
'   and (:P11_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P11_X_GEN_GEO_STATE)',
' group by result_type',
' order by label;'))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30999617261366078)
,p_plug_name=>'Organization Detail Charts Line 2'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>170
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P11_X_GEN_GEO_STATE IS NOT NULL AND :P11_X_REPORT_TYPE = ''CHARTS'''
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30999807274366078)
,p_plug_name=>'Organization Details Year 5'
,p_parent_plug_id=>wwv_flow_api.id(30999617261366078)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>2
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear5(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P11_X_GEN_GEO_STATE IS NOT NULL AND :P11_X_REPORT_TYPE = ''CHARTS'''
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(31000017487366078)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1416705713810642'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:::N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P11_X_YEAR5..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P11_X_YEAR5.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P11_X_YEAR5_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>'))
);
end;
/
begin
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(31000114160366079)
,p_chart_id=>wwv_flow_api.id(31000017487366078)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from tribal_state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P11_X_FK_TRIBE',
'   and act_start_year_date = :P11_X_YEAR5',
'   and (:P11_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P11_X_GEN_GEO_STATE)',
' group by result_type',
' order by label;'))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(31000402960366079)
,p_plug_name=>'Organization Details Year 4'
,p_parent_plug_id=>wwv_flow_api.id(30999617261366078)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid=>true
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear4(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P11_X_GEN_GEO_STATE IS NOT NULL AND :P11_X_REPORT_TYPE = ''CHARTS'''
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(31000624297366079)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1416213705791737'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:::N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P11_X_YEAR4..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P11_X_YEAR4.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P11_X_YEAR4_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>'))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(31000711114366080)
,p_chart_id=>wwv_flow_api.id(31000624297366079)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from tribal_state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P11_X_FK_TRIBE',
'   and act_start_year_date = :P11_X_YEAR4',
'   and (:P11_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P11_X_GEN_GEO_STATE)',
' group by result_type',
' order by label;'))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(31001214216366080)
,p_plug_name=>'Organization Details End Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>180
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'</center>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P11_X_GEN_GEO_STATE <> -1'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(31001399560366081)
,p_plug_name=>'2009'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>110
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>4
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P11_X_GEN_GEO_STATE IS NOT NULL AND :P11_X_REPORT_TYPE = ''CHARTS'''
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(31001618629366081)
,p_default_chart_type=>'2DPie'
,p_chart_title=>'2009'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1382107421277456'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P11_X_YEAR4..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P11_X_TOTAL4. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P11_X_YEAR4. Top 5 Tribes</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(31001718779366081)
,p_chart_id=>wwv_flow_api.id(31001618629366081)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from tribal_state_org_year a, table(pkg_dynamic_list.get_years(:P11_X_YEAR4,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P11_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P11_X_GEN_GEO_STATE )',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(31002198713366082)
,p_plug_name=>'2008'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>120
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>5
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P11_X_GEN_GEO_STATE IS NOT NULL AND :P11_X_REPORT_TYPE = ''CHARTS'''
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(31002415655366082)
,p_default_chart_type=>'2DPie'
,p_chart_title=>'2009'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1382530484282001'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P11_X_YEAR5..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P11_X_TOTAL5. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P11_X_YEAR5. Top 5 Tribes</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(31002511836366082)
,p_chart_id=>wwv_flow_api.id(31002415655366082)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from tribal_state_org_year a, table(pkg_dynamic_list.get_years(:P11_X_YEAR5,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P11_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P11_X_GEN_GEO_STATE )',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(30994809867366068)
,p_button_sequence=>130
,p_button_plug_id=>wwv_flow_api.id(30994025804366067)
,p_button_name=>'P11_GO'
,p_button_static_id=>'P11_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(27668368034614464)
,p_button_image_alt=>'Submit'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT'
,p_grid_new_grid=>false
,p_grid_new_row=>'Y'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(30996607935366071)
,p_button_sequence=>250
,p_button_plug_id=>wwv_flow_api.id(30996202143366071)
,p_button_name=>'P11_REFRESH'
,p_button_static_id=>'P11_REFRESH'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(27668368034614464)
,p_button_image_alt=>'Submit'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT-CENTER'
,p_grid_column_attributes=>'valign="top"'
,p_grid_new_grid=>false
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(30991107862366062)
,p_name=>'P11_X_YEAR3'
,p_item_sequence=>180
,p_item_plug_id=>wwv_flow_api.id(30990709040366058)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')) - 2'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(30991306839366062)
,p_name=>'P11_X_TOTAL3'
,p_item_sequence=>190
,p_item_plug_id=>wwv_flow_api.id(30990709040366058)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(30992101430366064)
,p_name=>'P11_X_TOTAL2'
,p_item_sequence=>170
,p_item_plug_id=>wwv_flow_api.id(30991697304366063)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(30992304162366065)
,p_name=>'P11_X_YEAR2'
,p_item_sequence=>160
,p_item_plug_id=>wwv_flow_api.id(30991697304366063)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')) - 1'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(30994199305366067)
,p_name=>'P11_FROMPG'
,p_item_sequence=>260
,p_item_plug_id=>wwv_flow_api.id(30994025804366067)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(30994409626366068)
,p_name=>'P11_X_STATE_NAME'
,p_item_sequence=>75
,p_item_plug_id=>wwv_flow_api.id(30994025804366067)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(30994600961366068)
,p_name=>'P11_1_0'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(30994025804366067)
,p_prompt=>'&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(30994998013366068)
,p_name=>'P11_X_YEAR'
,p_is_required=>true
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(30994025804366067)
,p_prompt=>'<strong>Select Year:</strong>&nbsp;&nbsp;'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_char(sysdate,''YYYY'')',
'  from dual;'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_number(column_value) as n,',
'       to_number(column_value) as v',
'  from table(pkg_dynamic_list.get_years(null,to_number(to_char(sysdate,''YYYY'')) - 1899))',
' order by 1 desc;'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(30995222290366068)
,p_name=>'P11_X_GEN_GEO_STATE'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(30994025804366067)
,p_prompt=>'<strong>Select State:</strong>&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'           select st.state_name,',
'                 st.pk_isn',
'            from di_geo_state st',
'           where country_code = ''US''',
'             and epa_region_code is not null',
'  and PK_ISN in (select FK_GEO_STATE from lu_orgstate)',
'  and ( :P11_X_EPA_REGION = -1 or  st.epa_region_code  = :P11_X_EPA_REGION ) ',
'           order by 2'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- ALL STATES -'
,p_lov_null_value=>'-1'
,p_lov_cascade_parent_items=>'P11_X_EPA_REGION'
,p_ajax_items_to_submit=>'P11_X_EPA_REGION'
,p_ajax_optimize_refresh=>'Y'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(30995411257366068)
,p_name=>'P11_X_REPORT_TYPE'
,p_is_required=>true
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(30994025804366067)
,p_prompt=>'<strong>Select Display Type:</strong>&nbsp;&nbsp;'
,p_source=>'CHARTS'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_RADIOGROUP'
,p_lov=>'STATIC2:Top 5 Tribes Charts;CHARTS,All Tribes Table;TABLE'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'1'
,p_attribute_02=>'NONE'
,p_attribute_04=>'VERTICAL'
);
end;
/
begin
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(30995623647366068)
,p_name=>'P11_X_REGION'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(30994025804366067)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(30995805608366070)
,p_name=>'P11_X_EPA_REGION'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(30994025804366067)
,p_prompt=>'<strong>Select Region:</strong>&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select rg.epa_region_name,',
'                 rg.pk_isn',
'            from di_epa_region rg',
'            where pk_isn != 0',
'            order by 2',
''))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- ALL REGIONS -'
,p_lov_null_value=>'-1'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(30996399266366071)
,p_name=>'P11_X_FK_TRIBE'
,p_item_sequence=>240
,p_item_plug_id=>wwv_flow_api.id(30996202143366071)
,p_prompt=>'<strong>Select Tribe:</strong>&nbsp;&nbsp;'
,p_post_element_text=>'&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select distinct c.organization_id || '' - '' || c.organization_name as org_name,',
'       c.pk_isn as org_id',
'  from tribal_state_org_year a, di_org c',
' where ( :P11_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P11_X_GEN_GEO_STATE )',
'   and a.act_start_year_date between to_number(:P11_X_YEAR5) and to_number(:P11_X_YEAR1)',
'   and a.fk_org = c.pk_isn ',
' order by 1 '))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- SELECT -'
,p_lov_null_value=>'0'
,p_lov_cascade_parent_items=>'P11_X_GEN_GEO_STATE'
,p_ajax_items_to_submit=>'P11_X_GEN_GEO_STATE'
,p_ajax_optimize_refresh=>'Y'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(30997212975366073)
,p_name=>'P11_X_TOTAL1'
,p_item_sequence=>150
,p_item_plug_id=>wwv_flow_api.id(30996804409366071)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(30997421276366073)
,p_name=>'P11_X_YEAR1'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(30996804409366071)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(30998196475366074)
,p_name=>'P11_X_YEAR1_ST'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(30997814128366074)
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(30998821422366075)
,p_name=>'P11_X_YEAR2_ST'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(30998421612366074)
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(30999399138366078)
,p_name=>'P11_X_YEAR3_ST'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(30999022077366076)
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(31000211445366079)
,p_name=>'P11_X_YEAR5_ST'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(30999807274366078)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(31000808703366080)
,p_name=>'P11_X_YEAR4_ST'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(31000402960366079)
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(31001823786366081)
,p_name=>'P11_X_TOTAL4'
,p_item_sequence=>210
,p_item_plug_id=>wwv_flow_api.id(31001399560366081)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(31002014024366082)
,p_name=>'P11_X_YEAR4'
,p_item_sequence=>200
,p_item_plug_id=>wwv_flow_api.id(31001399560366081)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')) - 3'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(31002608270366082)
,p_name=>'P11_X_TOTAL5'
,p_item_sequence=>230
,p_item_plug_id=>wwv_flow_api.id(31002198713366082)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(31002796489366083)
,p_name=>'P11_X_YEAR5'
,p_item_sequence=>220
,p_item_plug_id=>wwv_flow_api.id(31002198713366082)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')) - 4'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(31003100880366083)
,p_computation_sequence=>10
,p_computation_item=>'P11_X_YEAR3'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P11_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))) - 2'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(31003317542366083)
,p_computation_sequence=>20
,p_computation_item=>'P11_X_YEAR1'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P11_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')))'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(31003510169366083)
,p_computation_sequence=>30
,p_computation_item=>'P11_X_YEAR2'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P11_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))) - 1'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(31004725533366084)
,p_computation_sequence=>30
,p_computation_item=>'P11_X_REGION'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'Select ORGANIZATION_NAME',
'from DI_ORG',
'where pk_isn = :P11_X_GEN_GEO_TRIBE;'))
,p_compute_when=>':P11_X_GEN_GEO_TRIBE <> -1'
,p_compute_when_type=>'SQL_EXPRESSION'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(31004519051366084)
,p_computation_sequence=>40
,p_computation_item=>'F102_X_BREADCRUMB'
,p_computation_point=>'BEFORE_HEADER'
,p_computation=>'bitand(nvl(:F102_X_BREADCRUMB,1) + 16 - bitand(nvl(:F102_X_BREADCRUMB,1),16),31)'
,p_compute_when_type=>'NEVER'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(31003910959366084)
,p_computation_sequence=>50
,p_computation_item=>'P11_X_YEAR5'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P11_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))) - 4'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(31004110482366084)
,p_computation_sequence=>60
,p_computation_item=>'P11_X_FK_TRIBE'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'0'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(31004320527366084)
,p_computation_sequence=>70
,p_computation_item=>'P11_X_STATE_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select state_name',
'  from di_geo_state',
' where pk_isn = :P11_X_GEN_GEO_STATE'))
,p_compute_when=>':P11_X_GEN_GEO_STATE <> -1'
,p_compute_when_type=>'SQL_EXPRESSION'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(31003715860366083)
,p_computation_sequence=>80
,p_computation_item=>'P11_X_YEAR4'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P11_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))) - 3'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(31004996454366086)
,p_name=>'Refresh Organization Details'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(30996607935366071)
,p_bind_type=>'live'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(31005525797366086)
,p_event_id=>wwv_flow_api.id(31004996454366086)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'begin',
'  for c in (',
'     select dt.column_value as year_no,',
'            count(distinct a.fk_fa_statn) as station_count',
'       from station_year a, table(pkg_dynamic_list.get_years(:P11_X_YEAR1)) dt                ',
'      where dt.column_value = a.act_start_year_date',
'        and a.fk_org = :P11_X_FK_TRIBE',
'        and ( :P11_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P11_X_GEN_GEO_STATE )',
'      group by dt.column_value  ',
'  )',
'  loop',
'     if c.year_no = :P11_X_YEAR1 then',
'        :P11_X_YEAR1_ST := c.station_count;',
'     elsif c.year_no = :P11_X_YEAR2 then',
'        :P11_X_YEAR2_ST := c.station_count;',
'     elsif c.year_no = :P11_X_YEAR3 then',
'        :P11_X_YEAR3_ST := c.station_count;',
'     elsif c.year_no = :P11_X_YEAR4 then',
'        :P11_X_YEAR4_ST := c.station_count;',
'     elsif c.year_no = :P11_X_YEAR5 then',
'        :P11_X_YEAR5_ST := c.station_count;',
'     end if;',
'  end loop;',
'end;'))
,p_attribute_02=>'P11_X_FK_TRIBE,P11_X_YEAR1_ST,P11_X_YEAR2_ST,P11_X_YEAR3_ST,P11_X_YEAR4_ST,P11_X_YEAR5_ST'
,p_stop_execution_on_error=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(31005300985366086)
,p_event_id=>wwv_flow_api.id(31004996454366086)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'apex.jQuery( "#OrgDetailsChartYear1_chart" ).trigger( "apexrefresh" );',
'apex.jQuery( "#OrgDetailsChartYear2_chart" ).trigger( "apexrefresh" );',
'apex.jQuery( "#OrgDetailsChartYear3_chart" ).trigger( "apexrefresh" );',
'apex.jQuery( "#OrgDetailsChartYear4_chart" ).trigger( "apexrefresh" );',
'apex.jQuery( "#OrgDetailsChartYear5_chart" ).trigger( "apexrefresh" );'))
,p_stop_execution_on_error=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(31004809270366084)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Compute Totals'
,p_process_sql_clob=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'begin',
'   for c in (',
'      select trim(to_char(sum(a.result_count),''999,999,999,999'')) as total_count,',
'             a.act_start_year_date as year_no',
'        from tribal_state_org_year a                ',
'       where a.act_start_year_date in (:P11_X_YEAR1, :P11_X_YEAR2, :P11_X_YEAR3, :P11_X_YEAR4, :P11_X_YEAR5)',
'         and ( :P11_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P11_X_GEN_GEO_STATE )',
'       group by a.act_start_year_date',
'  )',
'  loop',
'     if c.year_no = :P11_X_YEAR1 then',
'        :P11_X_TOTAL1 := c.total_count;',
'     elsif c.year_no = :P11_X_YEAR2 then',
'        :P11_X_TOTAL2 := c.total_count;',
'     elsif c.year_no = :P11_X_YEAR3 then',
'        :P11_X_TOTAL3 := c.total_count;',
'     elsif c.year_no = :P11_X_YEAR4 then',
'        :P11_X_TOTAL4 := c.total_count;',
'     elsif c.year_no = :P11_X_YEAR5 then',
'        :P11_X_TOTAL5 := c.total_count;',
'     end if;',
'  end loop;',
'',
'  for c in (',
'     select fk_org',
'       from ( select a.fk_org,',
'                     dense_rank() over (order by act_start_year_date desc, result_count desc) as rnk',
'                from tribal_state_org_year a, table(pkg_dynamic_list.get_years(:P11_X_YEAR1)) dt                ',
'               where dt.column_value = a.act_start_year_date',
'                 and ( :P11_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P11_X_GEN_GEO_STATE )   )',
'      where rnk = 1',
'  )',
'  loop',
'',
'     :P11_X_FK_TRIBE := c.fk_org;',
'',
'  end loop;',
'',
'  for c in (',
'     select dt.column_value as year_no,',
'            count(distinct a.fk_fa_statn) as station_count',
'       from tribal_station_year a, table(pkg_dynamic_list.get_years(:P11_X_YEAR1)) dt                ',
'      where dt.column_value = a.act_start_year_date',
'        and a.fk_org = :P11_X_FK_TRIBE',
'        and ( :P11_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P11_X_GEN_GEO_STATE )',
'      group by dt.column_value  ',
'  )',
'  loop',
'     if c.year_no = :P11_X_YEAR1 then',
'        :P11_X_YEAR1_ST := c.station_count;',
'     elsif c.year_no = :P11_X_YEAR2 then',
'        :P11_X_YEAR2_ST := c.station_count;',
'     elsif c.year_no = :P11_X_YEAR3 then',
'        :P11_X_YEAR3_ST := c.station_count;',
'     elsif c.year_no = :P11_X_YEAR4 then',
'        :P11_X_YEAR4_ST := c.station_count;',
'     elsif c.year_no = :P11_X_YEAR5 then',
'        :P11_X_YEAR5_ST := c.station_count;',
'     end if;',
'  end loop;',
'',
'end;'))
,p_process_when=>':P11_X_GEN_GEO_STATE IS NOT NULL'
,p_process_when_type=>'SQL_EXPRESSION'
);
end;
/
prompt --application/pages/page_00012
begin
wwv_flow_api.create_page(
 p_id=>12
,p_user_interface_id=>wwv_flow_api.id(34223238802660366)
,p_name=>'Data Owners Contribution by Tribes'
,p_page_mode=>'NORMAL'
,p_step_title=>'Data Owners Contribution by Tribes'
,p_step_sub_title=>'Data Owners Contribution by Tribes'
,p_step_sub_title_type=>'TEXT_WITH_SUBSTITUTIONS'
,p_first_item=>'NO_FIRST_ITEM'
,p_step_template=>wwv_flow_api.id(37710474362483110)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_chained=>'Y'
,p_overwrite_navigation_list=>'N'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_cache_mode=>'NOCACHE'
,p_cache_timeout_seconds=>21600
,p_last_updated_by=>'JENNIFER'
,p_last_upd_yyyymmddhh24miss=>'20151112113546'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36269932703782717)
,p_plug_name=>'2011'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>21
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>2
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(36270151437782762)
,p_default_chart_type=>'2DPie'
,p_chart_title=>'2011'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1381006379232381'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P12_X_YEAR2..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P12_X_TOTAL2. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P12_X_YEAR2. Top 5 Orgs</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(36270223628782841)
,p_chart_id=>wwv_flow_api.id(36270151437782762)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from state_org_year a, table(pkg_dynamic_list.get_years(:P12_X_YEAR2,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P12_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P12_X_GEN_GEO_STATE )',
'            and ( :P12_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P12_X_PROGRAM_AREA ) ) ',
'            and a.fk_org in ( select fk_org',
'                                from lu_orgtype',
'                               where fk_org_type = 9 ) ',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36270726535782917)
,p_plug_name=>'2010'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>31
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>3
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(36270949474782918)
,p_default_chart_type=>'2DPie'
,p_chart_title=>'2010'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1381606570262678'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P12_X_YEAR3..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P12_X_TOTAL3. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P12_X_YEAR3. Top 5 Orgs</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(36271041338782925)
,p_chart_id=>wwv_flow_api.id(36270949474782918)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from state_org_year a, table(pkg_dynamic_list.get_years(:P12_X_YEAR3,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P12_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P12_X_GEN_GEO_STATE )',
'            and ( :P12_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P12_X_PROGRAM_AREA ) ) ',
'            and a.fk_org in ( select fk_org',
'                                from lu_orgtype',
'                               where fk_org_type = 9 ) ',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36271551846782931)
,p_plug_name=>'State Top Organization Charts'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<center>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36271722475782937)
,p_plug_name=>'Organization Detail Charts Line 2'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>181
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36271953094782941)
,p_plug_name=>'Organization Details Year 5'
,p_region_name=>'OrgDetailsChartYear5'
,p_parent_plug_id=>wwv_flow_api.id(36271722475782937)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>201
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>2
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear5(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(36272135918782941)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1416705713810642'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:::N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P12_X_YEAR5..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P12_X_YEAR5.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P12_X_YEAR5_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>'))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(36272229041782943)
,p_chart_id=>wwv_flow_api.id(36272135918782941)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P12_X_FK_ORG',
'   and act_start_year_date = :P12_X_YEAR5',
'   and (:P12_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P12_X_GEN_GEO_STATE)',
' group by result_type',
' order by label;'))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36272328911782943)
,p_plug_name=>'Organization Details Year 4'
,p_region_name=>'OrgDetailsChartYear4'
,p_parent_plug_id=>wwv_flow_api.id(36271722475782937)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>191
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid=>true
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear4(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(36272532655782945)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1416213705791737'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:::N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P12_X_YEAR4..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P12_X_YEAR4.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P12_X_YEAR4_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>'))
);
end;
/
begin
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(36272650871782945)
,p_chart_id=>wwv_flow_api.id(36272532655782945)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P12_X_FK_ORG',
'   and act_start_year_date = :P12_X_YEAR4',
'   and (:P12_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P12_X_GEN_GEO_STATE)',
' group by result_type',
' order by label;'))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36273347241782959)
,p_plug_name=>'Organization Details End Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>221
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'</center>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE <> -1 AND :P12_X_REPORT_TYPE = ''CHARTS'''
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36273538726782960)
,p_plug_name=>'2009'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>41
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>4
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(36273726784782960)
,p_default_chart_type=>'2DPie'
,p_chart_title=>'2009'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1382107421277456'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P12_X_YEAR4..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P12_X_TOTAL4. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P12_X_YEAR4. Top 5 Orgs</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(36273842176782969)
,p_chart_id=>wwv_flow_api.id(36273726784782960)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from state_org_year a, table(pkg_dynamic_list.get_years(:P12_X_YEAR4,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P12_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P12_X_GEN_GEO_STATE )',
'            and ( :P12_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P12_X_PROGRAM_AREA ) ) ',
'            and a.fk_org in ( select fk_org',
'                                from lu_orgtype',
'                               where fk_org_type = 9 ) ',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36274341684782980)
,p_plug_name=>'2008'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>51
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>5
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(36274526988782981)
,p_default_chart_type=>'2DPie'
,p_chart_title=>'2009'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1382530484282001'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P12_X_YEAR5..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P12_X_TOTAL5. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P12_X_YEAR5. Top 5 Orgs</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(36274641158782987)
,p_chart_id=>wwv_flow_api.id(36274526988782981)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from state_org_year a, table(pkg_dynamic_list.get_years(:P12_X_YEAR5,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P12_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P12_X_GEN_GEO_STATE )',
'            and ( :P12_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P12_X_PROGRAM_AREA ) ) ',
'            and a.fk_org in ( select fk_org',
'                                from lu_orgtype',
'                               where fk_org_type = 9 ) ',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36275125920782988)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(37712576903483127)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(37718178435924515)
,p_plug_query_row_template=>1
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36275647013783014)
,p_plug_name=>'Data Owners Contribution'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>231
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select a.organization_id,',
'       b.organization_name,',
'       sum(a.biological_count) as biological_count,',
'       sum(a.habitat_count) as habitat_count,',
'       sum(a.regular_count) as regular_count,',
'       dt.column_value,',
'       sum(a.result_count) as result_count,',
'       round(ratio_to_report(sum(result_count)) over (partition by dt.column_value) * 100,2) as perc,',
'       count(distinct fk_fa_statn) as station_count',
'  from station_year a, di_org b, table(pkg_dynamic_list.get_years(:P12_X_YEAR,5)) dt                ',
' where dt.column_value = a.act_start_year_date',
'   and a.fk_org = b.pk_isn',
'   and ( :P12_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P12_X_GEN_GEO_STATE )',
'   and ( :P12_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                    from lu_orgtype',
'                                                   where fk_org_type = :P12_X_PROGRAM_AREA ) ) ',
'   and a.fk_org in ( select fk_org',
'                       from lu_orgtype',
'                      where fk_org_type = 9 )',
'group by a.organization_id, b.organization_name, dt.column_value'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_row_template=>1
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''TABLE'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(36275826234783024)
,p_name=>'Data Owners Contribution'
,p_max_row_count=>'100000'
,p_max_row_count_message=>'This query returns more than #MAX_ROW_COUNT# rows, please filter your data to ensure complete results.'
,p_no_data_found_message=>'No data found.'
,p_sort_asc_image=>'arrow_up_gray_light.gif'
,p_sort_asc_image_attr=>' width="13" height="12" '
,p_sort_desc_image=>'arrow_down_gray_light.gif'
,p_sort_desc_image_attr=>' width="13" height="12" '
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'TOP_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_pivot=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'DSPOREA'
,p_internal_uid=>2117105263391130
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(36275933367783076)
,p_db_column_name=>'ORGANIZATION_ID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'Organization Id'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'ORGANIZATION_ID'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(36276021075783106)
,p_db_column_name=>'BIOLOGICAL_COUNT'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Biological'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'BIOLOGICAL_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(36276146877783106)
,p_db_column_name=>'HABITAT_COUNT'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'Habitat'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'HABITAT_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(36276227081783106)
,p_db_column_name=>'REGULAR_COUNT'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>'Physical/Chemical'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'REGULAR_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(36276352634783106)
,p_db_column_name=>'COLUMN_VALUE'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>'Year'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'COLUMN_VALUE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(36276447531783106)
,p_db_column_name=>'RESULT_COUNT'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>'Total'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'RESULT_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(36276535779783106)
,p_db_column_name=>'PERC'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>'Percentage'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'PERC'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(36339453534578891)
,p_db_column_name=>'STATION_COUNT'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>'Stations'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'STATION_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(36368246320059251)
,p_db_column_name=>'ORGANIZATION_NAME'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>'Organization Name'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'ORGANIZATION_NAME'
);
wwv_flow_api.create_worksheet_rpt(
 p_id=>wwv_flow_api.id(36276652513783119)
,p_application_user=>'APXWS_DEFAULT'
,p_report_seq=>10
,p_report_alias=>'21180'
,p_status=>'PUBLIC'
,p_is_default=>'Y'
,p_display_rows=>15
,p_report_columns=>'ORGANIZATION_ID:ORGANIZATION_NAME:STATION_COUNT:BIOLOGICAL_COUNT:HABITAT_COUNT:REGULAR_COUNT:COLUMN_VALUE:RESULT_COUNT:PERC:'
,p_sort_column_1=>'COLUMN_VALUE'
,p_sort_direction_1=>'DESC'
,p_sort_column_2=>'PERC'
,p_sort_direction_2=>'DESC'
,p_sort_column_3=>'RESULT_COUNT'
,p_sort_direction_3=>'DESC'
,p_sort_column_4=>'0'
,p_sort_direction_4=>'ASC'
,p_sort_column_5=>'0'
,p_sort_direction_5=>'ASC'
,p_sort_column_6=>'0'
,p_sort_direction_6=>'ASC'
,p_break_on=>'COLUMN_VALUE:0:0:0:0:0'
,p_break_enabled_on=>'COLUMN_VALUE:0:0:0:0:0'
,p_flashback_enabled=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36276846336783138)
,p_plug_name=>'Search Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>5
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<p>These figures display the top five tribal organizations within a state which submitted data to STORET, listed by the selected year, over the last five years. The records represent the data available in STORET on measurements of water quality as re'
||'ported by tribal organizations only. Data can represent biological, chemical, physical, habitat and continuous monitoring data.</p>',
'<p>Select a year, a State, Program Area, and a Display Type using the dropdown menus.</p>'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36278646150783181)
,p_plug_name=>'State Charts End Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>211
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'</center>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36278840726783181)
,p_plug_name=>'Organization Selection'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>61
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<br>',
'<p>To view more details, use the pull down menu and select a single organization by name  to display Biological (fish, algae), Habitat (bank stability), and Physical/Chemical (pH, Temperature, metals).</p>'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36279427985783185)
,p_plug_name=>'2012'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>11
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(36279630275783185)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1379900927779032'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V::None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>'200:::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
,p_legend_title=>'2012 Top 5'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P12_X_YEAR1..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P12_X_TOTAL1. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P12_X_YEAR1. Top 5 Orgs</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'      #DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
end;
/
begin
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(36279740311783189)
,p_chart_id=>wwv_flow_api.id(36279630275783185)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from state_org_year a, table(pkg_dynamic_list.get_years(:P12_X_YEAR1,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P12_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P12_X_GEN_GEO_STATE )',
'            and ( :P12_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P12_X_PROGRAM_AREA ) ) ',
'            and a.fk_org in ( select fk_org',
'                                from lu_orgtype',
'                               where fk_org_type = 9 ) ',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36280248222783193)
,p_plug_name=>'Organization Details Charts Line 1'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>71
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<center>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36280438422783194)
,p_plug_name=>'Organization Details Year 1'
,p_region_name=>'OrgDetailsChartYear1'
,p_parent_plug_id=>wwv_flow_api.id(36280248222783193)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>81
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid=>true
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear1(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>',
''))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(36280639748783194)
,p_default_chart_type=>'Horizontal2DColumn'
,p_chart_title=>'&P12_X_YEAR1.'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1408925646378466'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:N:N:N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'Tahoma:10:#000000'
,p_y_axis_label_font=>'Tahoma:10:#000000'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:#000000'
,p_y_axis_title_font=>'Tahoma:14:#000000'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P12_X_YEAR1..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P12_X_YEAR1.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P12_X_YEAR1_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(36280749581783194)
,p_chart_id=>wwv_flow_api.id(36280639748783194)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P12_X_FK_ORG',
'   and act_start_year_date = :P12_X_YEAR1',
'   and (:P12_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P12_X_GEN_GEO_STATE)',
' group by result_type',
' order by label'))
,p_series_type=>'Bar'
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36280852793783195)
,p_plug_name=>'Organization Details Year 2'
,p_region_name=>'OrgDetailsChartYear2'
,p_parent_plug_id=>wwv_flow_api.id(36280248222783193)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>151
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>2
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear2(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(36281033472783195)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1411802393058016'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:::N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P12_X_YEAR2..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P12_X_YEAR2.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P12_X_YEAR2_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(36281152153783195)
,p_chart_id=>wwv_flow_api.id(36281033472783195)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P12_X_FK_ORG',
'   and act_start_year_date = :P12_X_YEAR2',
'   and (:P12_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P12_X_GEN_GEO_STATE)',
' group by result_type',
' order by label;'))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36281233247783195)
,p_plug_name=>'Organization Details Year 3'
,p_region_name=>'OrgDetailsChartYear3'
,p_parent_plug_id=>wwv_flow_api.id(36280248222783193)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>161
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>3
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear3(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(36281438596783196)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1412432400272024'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:::N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P12_X_YEAR3..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P12_X_YEAR3.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P12_X_YEAR3_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(36281536752783196)
,p_chart_id=>wwv_flow_api.id(36281438596783196)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P12_X_FK_ORG',
'   and act_start_year_date = :P12_X_YEAR3',
'   and (:P12_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P12_X_GEN_GEO_STATE)',
' group by result_type',
' order by label;'))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(36279239526783184)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(36278840726783181)
,p_button_name=>'P12_REFRESH'
,p_button_static_id=>'P12_REFRESH'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(27668368034614464)
,p_button_image_alt=>'Submit'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT-CENTER'
,p_grid_new_grid=>false
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(36277446234783140)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(36276846336783138)
,p_button_name=>'P12_GO'
,p_button_static_id=>'P12_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(27668368034614464)
,p_button_image_alt=>'Submit'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT'
,p_grid_new_grid=>false
,p_grid_new_row=>'Y'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36270337170782867)
,p_name=>'P12_X_TOTAL2'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(36269932703782717)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36270553432782916)
,p_name=>'P12_X_YEAR2'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(36269932703782717)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')) - 1'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36271122969782931)
,p_name=>'P12_X_YEAR3'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(36270726535782917)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')) - 2'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36271337899782931)
,p_name=>'P12_X_TOTAL3'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(36270726535782917)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36273935360782980)
,p_name=>'P12_X_TOTAL4'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(36273538726782960)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36274144840782980)
,p_name=>'P12_X_YEAR4'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(36273538726782960)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')) - 3'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36274745048782988)
,p_name=>'P12_X_TOTAL5'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(36274341684782980)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36274943983782988)
,p_name=>'P12_X_YEAR5'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(36274341684782980)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')) - 4'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
end;
/
begin
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36277053622783139)
,p_name=>'P12_X_STATE_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(36276846336783138)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36277251033783140)
,p_name=>'P12_1_0'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(36276846336783138)
,p_prompt=>'&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36277636190783140)
,p_name=>'P12_X_YEAR'
,p_is_required=>true
,p_item_sequence=>2
,p_item_plug_id=>wwv_flow_api.id(36276846336783138)
,p_prompt=>'<strong>Select Year:</strong>&nbsp;&nbsp;'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_char(sysdate,''YYYY'')',
'  from dual;'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_number(column_value) as n,',
'       to_number(column_value) as v',
'  from table(pkg_dynamic_list.get_years(null,to_number(to_char(sysdate,''YYYY'')) - 1899))',
' order by 1 desc;'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36277842988783155)
,p_name=>'P12_X_GEN_GEO_STATE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(36276846336783138)
,p_prompt=>'<strong>Select State:</strong>&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'          select st.state_name,',
'                 st.pk_isn',
'            from di_geo_state st',
'           where country_code = ''US''',
'             and epa_region_code is not null',
'           order by 2'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- ALL STATES -'
,p_lov_null_value=>'-1'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36278041248783180)
,p_name=>'P12_X_REPORT_TYPE'
,p_is_required=>true
,p_item_sequence=>15
,p_item_plug_id=>wwv_flow_api.id(36276846336783138)
,p_prompt=>'<strong>Select Display Type:</strong>&nbsp;&nbsp;'
,p_source=>'CHARTS'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_RADIOGROUP'
,p_lov=>'STATIC2:Top 5 Organizations Charts;CHARTS,All Organizations Table;TABLE'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'1'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36278453683783180)
,p_name=>'P12_X_PROGRAM_AREA'
,p_item_sequence=>14
,p_item_plug_id=>wwv_flow_api.id(36276846336783138)
,p_prompt=>'<strong>Select Program Area:</strong>&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select organization_type,',
'       pk_isn',
'  from di_org_types',
' where pk_isn >= 100',
' order by sort_order'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- ALL AREAS -'
,p_lov_null_value=>'-1'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(37718475221928950)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36279041516783181)
,p_name=>'P12_X_FK_ORG'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(36278840726783181)
,p_prompt=>'<strong>Select Organization:</strong>&nbsp;&nbsp;'
,p_post_element_text=>'&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select distinct c.organization_id || '' - '' || c.organization_name as org_name,',
'       c.pk_isn as org_id',
'  from state_org_year a, di_org c',
' where ( :P12_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P12_X_GEN_GEO_STATE )',
'   and a.fk_org in ( select fk_org',
'                       from lu_orgtype',
'                      where fk_org_type = 9 )',
'            and ( :P12_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P12_X_PROGRAM_AREA ) ) ',
'   and a.act_start_year_date between to_number(:P12_X_YEAR5) and to_number(:P12_X_YEAR1)',
'   and a.fk_org = c.pk_isn ',
' order by 1 '))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- SELECT -'
,p_lov_null_value=>'0'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36279831199783193)
,p_name=>'P12_X_TOTAL1'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(36279427985783185)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36280021379783193)
,p_name=>'P12_X_YEAR1'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(36279427985783185)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36341938737542986)
,p_name=>'P12_X_YEAR1_ST'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(36280438422783194)
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36342134208545079)
,p_name=>'P12_X_YEAR2_ST'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(36280852793783195)
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36342330542546829)
,p_name=>'P12_X_YEAR3_ST'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(36281233247783195)
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36342526444548725)
,p_name=>'P12_X_YEAR4_ST'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(36272328911782943)
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(36342723209550189)
,p_name=>'P12_X_YEAR5_ST'
,p_item_sequence=>150
,p_item_plug_id=>wwv_flow_api.id(36271953094782941)
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(36281738134783197)
,p_computation_sequence=>10
,p_computation_item=>'P12_X_YEAR3'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P12_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))) - 2'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(36281931388783202)
,p_computation_sequence=>10
,p_computation_item=>'P12_X_YEAR1'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P12_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')))'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(36282149087783207)
,p_computation_sequence=>10
,p_computation_item=>'P12_X_YEAR2'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P12_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))) - 1'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(36282321533783207)
,p_computation_sequence=>10
,p_computation_item=>'P12_X_YEAR4'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P12_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))) - 3'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(36282552743783207)
,p_computation_sequence=>10
,p_computation_item=>'P12_X_YEAR5'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P12_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))) - 4'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(36282745931783207)
,p_computation_sequence=>10
,p_computation_item=>'P12_X_FK_ORG'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'0'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(36282933073783207)
,p_computation_sequence=>10
,p_computation_item=>'P12_X_STATE_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select state_name',
'  from di_geo_state',
' where pk_isn = :P12_X_GEN_GEO_STATE'))
,p_compute_when=>':P12_X_GEN_GEO_STATE <> -1'
,p_compute_when_type=>'SQL_EXPRESSION'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(36283143374783208)
,p_computation_sequence=>10
,p_computation_item=>'F102_X_BREADCRUMB'
,p_computation_point=>'BEFORE_HEADER'
,p_computation=>'bitand(nvl(:F102_X_BREADCRUMB,1) + 16 - bitand(nvl(:F102_X_BREADCRUMB,1),16),31)'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(36283443762783237)
,p_name=>'Refresh Organization Details'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(36279239526783184)
,p_bind_type=>'live'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(36283741851783287)
,p_event_id=>wwv_flow_api.id(36283443762783237)
,p_event_result=>'TRUE'
,p_action_sequence=>5
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'begin',
'  for c in (',
'     select dt.column_value as year_no,',
'            count(distinct a.fk_fa_statn) as station_count',
'       from station_year a, table(pkg_dynamic_list.get_years(:P12_X_YEAR1)) dt                ',
'      where dt.column_value = a.act_start_year_date',
'        and a.fk_org = :P12_X_FK_ORG',
'        and ( :P12_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P12_X_GEN_GEO_STATE )',
'      group by dt.column_value  ',
'  )',
'  loop',
'     if c.year_no = :P12_X_YEAR1 then',
'        :P12_X_YEAR1_ST := c.station_count;',
'     elsif c.year_no = :P12_X_YEAR2 then',
'        :P12_X_YEAR2_ST := c.station_count;',
'     elsif c.year_no = :P12_X_YEAR3 then',
'        :P12_X_YEAR3_ST := c.station_count;',
'     elsif c.year_no = :P12_X_YEAR4 then',
'        :P12_X_YEAR4_ST := c.station_count;',
'     elsif c.year_no = :P12_X_YEAR5 then',
'        :P12_X_YEAR5_ST := c.station_count;',
'     end if;',
'  end loop;',
'end;'))
,p_attribute_02=>'P12_X_FK_ORG,P12_X_YEAR1_ST,P12_X_YEAR2_ST,P12_X_YEAR3_ST,P12_X_YEAR4_ST,P12_X_YEAR5_ST'
,p_stop_execution_on_error=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(36283931921783315)
,p_event_id=>wwv_flow_api.id(36283443762783237)
,p_event_result=>'TRUE'
,p_action_sequence=>15
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'apex.jQuery( "#OrgDetailsChartYear1_chart" ).trigger( "apexrefresh" );',
'apex.jQuery( "#OrgDetailsChartYear2_chart" ).trigger( "apexrefresh" );',
'apex.jQuery( "#OrgDetailsChartYear3_chart" ).trigger( "apexrefresh" );',
'apex.jQuery( "#OrgDetailsChartYear4_chart" ).trigger( "apexrefresh" );',
'apex.jQuery( "#OrgDetailsChartYear5_chart" ).trigger( "apexrefresh" );'))
,p_stop_execution_on_error=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(36283236970783208)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Compute Totals'
,p_process_sql_clob=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'begin',
'   for c in (',
'      select trim(to_char(sum(a.result_count),''999,999,999,999'')) as total_count,',
'             a.act_start_year_date as year_no',
'        from state_org_year a                ',
'       where a.act_start_year_date in (:P12_X_YEAR1, :P12_X_YEAR2, :P12_X_YEAR3, :P12_X_YEAR4, :P12_X_YEAR5)',
'         and ( :P12_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P12_X_GEN_GEO_STATE )',
'         and a.fk_org in ( select fk_org',
'                             from lu_orgtype',
'                            where fk_org_type = 9 )',
'         and ( :P12_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                          from lu_orgtype',
'                                                         where fk_org_type = :P12_X_PROGRAM_AREA ) )',
'       group by a.act_start_year_date',
'  )',
'  loop',
'     if c.year_no = :P12_X_YEAR1 then',
'        :P12_X_TOTAL1 := c.total_count;',
'     elsif c.year_no = :P12_X_YEAR2 then',
'        :P12_X_TOTAL2 := c.total_count;',
'     elsif c.year_no = :P12_X_YEAR3 then',
'        :P12_X_TOTAL3 := c.total_count;',
'     elsif c.year_no = :P12_X_YEAR4 then',
'        :P12_X_TOTAL4 := c.total_count;',
'     elsif c.year_no = :P12_X_YEAR5 then',
'        :P12_X_TOTAL5 := c.total_count;',
'     end if;',
'  end loop;',
'',
'  for c in (',
'     select fk_org',
'       from ( select a.fk_org,',
'                     dense_rank() over (order by act_start_year_date desc, result_count desc) as rnk',
'                from state_org_year a, table(pkg_dynamic_list.get_years(:P12_X_YEAR1)) dt                ',
'               where dt.column_value = a.act_start_year_date',
'                 and ( :P12_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P12_X_GEN_GEO_STATE )  ',
'                 and ( :P12_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                                   from lu_orgtype',
'                                                                  where fk_org_type = :P12_X_PROGRAM_AREA ) ) ',
'                 and a.fk_org in ( select fk_org',
'                                     from lu_orgtype',
'                                    where fk_org_type = 9 ) )',
'      where rnk = 1',
'  )',
'  loop',
'',
'     :P12_X_FK_ORG := c.fk_org;',
'',
'  end loop;',
'',
'  for c in (',
'     select dt.column_value as year_no,',
'            count(distinct a.fk_fa_statn) as station_count',
'       from station_year a, table(pkg_dynamic_list.get_years(:P12_X_YEAR1)) dt                ',
'      where dt.column_value = a.act_start_year_date',
'        and a.fk_org = :P12_X_FK_ORG',
'        and ( :P12_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P12_X_GEN_GEO_STATE )',
'      group by dt.column_value  ',
'  )',
'  loop',
'     if c.year_no = :P12_X_YEAR1 then',
'        :P12_X_YEAR1_ST := c.station_count;',
'     elsif c.year_no = :P12_X_YEAR2 then',
'        :P12_X_YEAR2_ST := c.station_count;',
'     elsif c.year_no = :P12_X_YEAR3 then',
'        :P12_X_YEAR3_ST := c.station_count;',
'     elsif c.year_no = :P12_X_YEAR4 then',
'        :P12_X_YEAR4_ST := c.station_count;',
'     elsif c.year_no = :P12_X_YEAR5 then',
'        :P12_X_YEAR5_ST := c.station_count;',
'     end if;',
'  end loop;',
'',
'end;'))
,p_process_when=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_PROGRAM_AREA IS NOT NULL'
,p_process_when_type=>'SQL_EXPRESSION'
);
end;
/
prompt --application/pages/page_00014
begin
wwv_flow_api.create_page(
 p_id=>14
,p_user_interface_id=>wwv_flow_api.id(34223238802660366)
,p_name=>'Top 10 Substances for Past 5 Years By Tribe'
,p_page_mode=>'NORMAL'
,p_step_title=>'Top 10 Substances for Past 5 Years By Tribe'
,p_step_sub_title=>'Top 10 Substances for Past 5 Years By Tribe'
,p_step_sub_title_type=>'TEXT_WITH_SUBSTITUTIONS'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_step_template=>wwv_flow_api.id(31007705311538595)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_chained=>'Y'
,p_overwrite_navigation_list=>'N'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_cache_mode=>'NOCACHE'
,p_cache_timeout_seconds=>21600
,p_help_text=>'No help is available for this page.'
,p_last_updated_by=>'JHUMA'
,p_last_upd_yyyymmddhh24miss=>'20151209083702'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(37037334094767744)
,p_plug_name=>'Top 10 Substances for Past 5 Years for &P14_X_SELECTED_TRIBE.'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(37710582515483112)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select activity_year,',
'       substance,',
'       result_count',
'  from ( select /*+ DYNAMIC_SAMPLING(dt 5) */',
'                display_name as substance,',
'                regular_count as result_count,',
'                dt.column_value as activity_year,',
'                dense_rank() over (partition by dt.column_value order by regular_count desc) as rnk',
'           from tribal_state_org_char_year a,',
'                table(pkg_dynamic_list.get_years(:P14_X_YEAR,5)) dt',
'          where dt.column_value = A.ACT_START_YEAR_DATE (+)',
'            and a.fk_org (+) = :P14_FK_GEN_GEO_TRIBE )',
' where rnk <= 10           ',
' order by activity_year desc, result_count desc;'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_row_template=>1
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P14_FK_GEN_GEO_TRIBE'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(37037526875767744)
,p_name=>'Top 10 Substances for Past 5 Years By State'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'This query returns more than 10,000 rows, please filter your data to ensure complete results.'
,p_no_data_found_message=>'No data found.'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_pivot=>'N'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_detail_link_text=>'<img src="#IMAGE_PREFIX#menu/pencil16x16.gif" alt="" />'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'DSPOREA'
,p_internal_uid=>2878805904375850
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(37037626329767748)
,p_db_column_name=>'ACTIVITY_YEAR'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'Activity Year'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'ACTIVITY_YEAR'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(37037739568767749)
,p_db_column_name=>'SUBSTANCE'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Substance'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'SUBSTANCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(37037846644767749)
,p_db_column_name=>'RESULT_COUNT'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'Result Count'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'RESULT_COUNT'
);
wwv_flow_api.create_worksheet_rpt(
 p_id=>wwv_flow_api.id(37037940640767750)
,p_application_user=>'APXWS_DEFAULT'
,p_report_seq=>10
,p_report_alias=>'28793'
,p_status=>'PUBLIC'
,p_is_default=>'Y'
,p_display_rows=>10000
,p_report_columns=>'ACTIVITY_YEAR:SUBSTANCE:RESULT_COUNT'
,p_sort_column_1=>'ACTIVITY_YEAR'
,p_sort_direction_1=>'DESC'
,p_sort_column_2=>'RESULT_COUNT'
,p_sort_direction_2=>'DESC'
,p_sort_column_3=>'SUBSTANCE'
,p_sort_direction_3=>'ASC'
,p_sort_column_4=>'0'
,p_sort_direction_4=>'ASC'
,p_sort_column_5=>'0'
,p_sort_direction_5=>'ASC'
,p_sort_column_6=>'0'
,p_sort_direction_6=>'ASC'
,p_break_on=>'ACTIVITY_YEAR:0:0:0:0:0'
,p_break_enabled_on=>'ACTIVITY_YEAR:0:0:0:0:0'
,p_flashback_enabled=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(37038121834767751)
,p_plug_name=>'Search Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<p>These tables provide a count of the  top ten substances within a state''s waters, listed by year, over the last five years. The records represent the data available in STORET on measurements of water quality as reported by ALL current organizations'
||', including state, local, and tribal agencies and watershed groups.</p>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(37039538768767753)
,p_plug_name=>'Top 10 Substances for Past 5 Years By Tribe'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY_3'
,p_menu_id=>wwv_flow_api.id(37712576903483127)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(34158720971391894)
,p_plug_query_row_template=>1
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(37070232414797412)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(37712576903483127)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(31009000087660106)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P14_FROMPG'
,p_plug_display_when_cond2=>'2'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(37070633369816561)
,p_plug_name=>'Breadcrumb3'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_08'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(35650446974005666)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(31009000087660106)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_plug_display_when_condition=>'P14_FROMPG'
,p_plug_display_when_cond2=>'6'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(37038530510767752)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(37038121834767751)
,p_button_name=>'P14_GO'
,p_button_static_id=>'P14_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(27668368034614464)
,p_button_image_alt=>'Submit'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT'
,p_request_source=>'Go'
,p_request_source_type=>'STATIC'
,p_grid_new_grid=>false
,p_grid_new_row=>'Y'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(37038346557767751)
,p_name=>'P14_X_YEAR'
,p_is_required=>true
,p_item_sequence=>5
,p_item_plug_id=>wwv_flow_api.id(37038121834767751)
,p_prompt=>'<strong>Select Year:</strong>&nbsp;&nbsp;'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_char(sysdate,''YYYY'')',
'  from dual;'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_number(column_value) as n,',
'       to_number(column_value) as v',
'  from table(pkg_dynamic_list.get_years(null,to_number(to_char(sysdate,''YYYY'')) - 1899))',
' order by 1 desc;'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(37038735596767752)
,p_name=>'P14_FK_GEN_GEO_STATE'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(37038121834767751)
,p_prompt=>'<Strong>Select State:</Strong>&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select state_name,',
'       pk_isn ',
'  from di_geo_state',
' where country_code = ''US''',
'   and epa_region_code is not null',
'  and PK_ISN in (select FK_GEO_STATE from lu_orgstate)',
' order by state_name'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'-SELECT-'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(37038948661767752)
,p_name=>'P14_1_0'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(37038121834767751)
,p_prompt=>'&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(37039135976767752)
,p_name=>'P14_X_SELECTED_STATE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(37038121834767751)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(37044130501317926)
,p_name=>'P14_FK_GEN_GEO_TRIBE'
,p_is_required=>true
,p_item_sequence=>11
,p_item_plug_id=>wwv_flow_api.id(37038121834767751)
,p_prompt=>'<strong>Select Tribe:</strong>&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'Select b.ORGANIZATION_NAME, b.PK_ISN',
'from lu_orgstate a, DI_ORG b',
'where a.fk_org = b.pk_isn',
'and a.fk_geo_state = :P14_FK_GEN_GEO_STATE',
'order by ORGANIZATION_NAME;'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- SELECT -'
,p_lov_cascade_parent_items=>'P14_FK_GEN_GEO_STATE'
,p_ajax_items_to_submit=>'P14_FK_GEN_GEO_STATE'
,p_ajax_optimize_refresh=>'Y'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(37044327051319532)
,p_name=>'P14_X_SELECTED_TRIBE'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(37038121834767751)
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(37080753158363513)
,p_name=>'P14_FROMPG'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(37038121834767751)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(37040233599767755)
,p_computation_sequence=>10
,p_computation_item=>'P14_X_SELECTED_STATE'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select state_name',
'  from di_geo_state',
' where pk_isn = :P14_FK_GEN_GEO_STATE'))
,p_compute_when=>'P14_FK_GEN_GEO_STATE'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(37040448632767755)
,p_computation_sequence=>20
,p_computation_item=>'F102_X_BREADCRUMB'
,p_computation_point=>'BEFORE_HEADER'
,p_computation=>'bitand(nvl(:F102_X_BREADCRUMB,1) + 32 - bitand(nvl(:F102_X_BREADCRUMB,1),32),63)'
,p_compute_when_type=>'NEVER'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(37044447864320990)
,p_computation_sequence=>30
,p_computation_item=>'P14_X_SELECTED_TRIBE'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'Select ORGANIZATION_NAME',
'from DI_ORG',
'where pk_isn = :P14_FK_GEN_GEO_TRIBE;'))
,p_compute_when=>'P14_FK_GEN_GEO_TRIBE'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
end;
/
prompt --application/pages/page_00016
begin
wwv_flow_api.create_page(
 p_id=>16
,p_user_interface_id=>wwv_flow_api.id(34223238802660366)
,p_name=>'backup for page 10'
,p_page_mode=>'NORMAL'
,p_step_title=>'backup for page 10'
,p_step_sub_title=>'backup for page 10'
,p_step_sub_title_type=>'TEXT_WITH_SUBSTITUTIONS'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_step_template=>wwv_flow_api.id(37710474362483110)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_chained=>'Y'
,p_overwrite_navigation_list=>'N'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_cache_mode=>'NOCACHE'
,p_cache_timeout_seconds=>21600
,p_help_text=>'No help is available for this page.'
,p_last_updated_by=>'JTURAKA'
,p_last_upd_yyyymmddhh24miss=>'20151209105916'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(37353241703599598)
,p_plug_name=>'Breadcrumb3'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(35650446974005666)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(37718178435924515)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'bitand(:F102_X_BREADCRUMB,2) = 0 AND bitand(:F102_X_BREADCRUMB,4) > 0 AND bitand(:F102_X_BREADCRUMB,8) > 0'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(37353450023599616)
,p_plug_name=>'Top 10 Substances for Past 5 Years for &P16_X_SELECTED_STATE.'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(37710582515483112)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select activity_year,',
'       substance,',
'       result_count',
'  from ( select /*+ DYNAMIC_SAMPLING(dt 5) */',
'                display_name as substance,',
'                regular_count as result_count,',
'                dt.column_value as activity_year,',
'                dense_rank() over (partition by dt.column_value order by regular_count desc) as rnk',
'           from state_char_year a,',
'                table(pkg_dynamic_list.get_years(:P16_X_YEAR,5)) dt',
'          where dt.column_value = A.ACT_START_YEAR_DATE (+)',
'            and a.fk_gen_geo_state (+) = :P16_FK_GEN_GEO_STATE )',
' where rnk <= 10           ',
' order by activity_year desc, result_count desc;'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_row_template=>1
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P16_FK_GEN_GEO_STATE'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(37353638382599620)
,p_name=>'Top 10 Substances for Past 5 Years By State'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'This query returns more than 10,000 rows, please filter your data to ensure complete results.'
,p_no_data_found_message=>'No data found.'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_pivot=>'N'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'DSPOREA'
,p_internal_uid=>3194917411207726
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(37353726504599638)
,p_db_column_name=>'ACTIVITY_YEAR'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'Activity Year'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'ACTIVITY_YEAR'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(37353825400599639)
,p_db_column_name=>'SUBSTANCE'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Substance'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'SUBSTANCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(37353942342599639)
,p_db_column_name=>'RESULT_COUNT'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'Result Count'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'RESULT_COUNT'
);
wwv_flow_api.create_worksheet_rpt(
 p_id=>wwv_flow_api.id(37354053121599640)
,p_application_user=>'APXWS_DEFAULT'
,p_report_seq=>10
,p_report_alias=>'31954'
,p_status=>'PUBLIC'
,p_is_default=>'Y'
,p_display_rows=>10000
,p_report_columns=>'ACTIVITY_YEAR:SUBSTANCE:RESULT_COUNT'
,p_sort_column_1=>'ACTIVITY_YEAR'
,p_sort_direction_1=>'DESC'
,p_sort_column_2=>'RESULT_COUNT'
,p_sort_direction_2=>'DESC'
,p_sort_column_3=>'SUBSTANCE'
,p_sort_direction_3=>'ASC'
,p_sort_column_4=>'0'
,p_sort_direction_4=>'ASC'
,p_sort_column_5=>'0'
,p_sort_direction_5=>'ASC'
,p_sort_column_6=>'0'
,p_sort_direction_6=>'ASC'
,p_break_on=>'ACTIVITY_YEAR:0:0:0:0:0'
,p_break_enabled_on=>'ACTIVITY_YEAR:0:0:0:0:0'
,p_flashback_enabled=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(37354245447599641)
,p_plug_name=>'Search Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<p>These tables provide a count of the  top ten substances within a state''s waters, listed by year, over the last five years. The records represent the data available in STORET on measurements of water quality as reported by ALL current organizations'
||', including state, local, and tribal agencies and watershed groups.</p>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(37355437229599677)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(37712576903483127)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(37718178435924515)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'bitand(:F102_X_BREADCRUMB,2) = 0 AND bitand(:F102_X_BREADCRUMB,4) = 0 AND bitand(:F102_X_BREADCRUMB,8) = 0'
,p_plug_display_when_cond2=>'1'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(37355634263599677)
,p_plug_name=>'Top 10 Substances for Past 5 Years By State'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_menu_id=>wwv_flow_api.id(37712576903483127)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_plug_query_row_template=>1
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(37356037097599678)
,p_plug_name=>'Breadcrumb4'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(35650549744006425)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(37718178435924515)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'bitand(:F102_X_BREADCRUMB,2) = 0 AND bitand(:F102_X_BREADCRUMB,4) = 0 AND bitand(:F102_X_BREADCRUMB,8) > 0'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(37354633016599674)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(37354245447599641)
,p_button_name=>'P16_GO'
,p_button_static_id=>'P16_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(27668368034614464)
,p_button_image_alt=>'Submit'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT'
,p_request_source=>'Go'
,p_request_source_type=>'STATIC'
,p_grid_new_grid=>false
,p_grid_new_row=>'Y'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(37354442354599645)
,p_name=>'P16_X_YEAR'
,p_is_required=>true
,p_item_sequence=>5
,p_item_plug_id=>wwv_flow_api.id(37354245447599641)
,p_prompt=>'<strong>Select Year:</strong>&nbsp;&nbsp;'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_char(sysdate,''YYYY'')',
'  from dual;'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_number(column_value) as n,',
'       to_number(column_value) as v',
'  from table(pkg_dynamic_list.get_years(null,to_number(to_char(sysdate,''YYYY'')) - 1899))',
' order by 1 desc;'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(37354839219599674)
,p_name=>'P16_FK_GEN_GEO_STATE'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(37354245447599641)
,p_prompt=>'<Strong>Select State:</Strong>&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select state_name,',
'       pk_isn ',
'  from di_geo_state',
' where country_code = ''US''',
'   and epa_region_code is not null',
' order by state_name'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'-SELECT-'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(37355022826599676)
,p_name=>'P16_1_0'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(37354245447599641)
,p_prompt=>'&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(37355223028599676)
,p_name=>'P16_X_SELECTED_STATE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(37354245447599641)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(37356337287599679)
,p_computation_sequence=>10
,p_computation_item=>'P16_X_SELECTED_STATE'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select state_name',
'  from di_geo_state',
' where pk_isn = :P16_FK_GEN_GEO_STATE'))
,p_compute_when=>'P16_FK_GEN_GEO_STATE'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(37356551373599688)
,p_computation_sequence=>20
,p_computation_item=>'F102_X_BREADCRUMB'
,p_computation_point=>'BEFORE_HEADER'
,p_computation=>'bitand(nvl(:F102_X_BREADCRUMB,1) + 32 - bitand(nvl(:F102_X_BREADCRUMB,1),32),63)'
);
end;
/
prompt --application/pages/page_00101
begin
wwv_flow_api.create_page(
 p_id=>101
,p_user_interface_id=>wwv_flow_api.id(34223238802660366)
,p_name=>'Login'
,p_page_mode=>'NORMAL'
,p_step_title=>'Login'
,p_step_sub_title=>'Login'
,p_step_sub_title_type=>'TEXT_WITH_SUBSTITUTIONS'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'OFF'
,p_step_template=>wwv_flow_api.id(37710474362483110)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_chained=>'Y'
,p_overwrite_navigation_list=>'N'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_cache_mode=>'NOCACHE'
,p_cache_timeout_seconds=>21600
,p_last_updated_by=>'DSPOREA'
,p_last_upd_yyyymmddhh24miss=>'20120827091756'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35596250823614045)
,p_plug_name=>'Login'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(35586821793592018)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY_3'
,p_plug_query_row_template=>1
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(35596822290614049)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(35596250823614045)
,p_button_name=>'P101_LOGIN'
,p_button_static_id=>'P101_LOGIN'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(37710977565483114)
,p_button_image_alt=>'Login'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT'
,p_request_source=>'LOGIN'
,p_request_source_type=>'STATIC'
,p_grid_new_grid=>false
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35596437864614047)
,p_name=>'P101_USERNAME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(35596250823614045)
,p_prompt=>'Username'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>40
,p_cMaxlength=>100
,p_colspan=>2
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(37718564528928950)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(35596621396614048)
,p_name=>'P101_PASSWORD'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(35596250823614045)
,p_prompt=>'Password'
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>40
,p_cMaxlength=>100
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(37718564528928950)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
,p_attribute_02=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(35597232486614051)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set Username Cookie'
,p_process_sql_clob=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'apex_authentication.send_login_username_cookie (',
'    p_username => lower(:P101_USERNAME) );'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(35597043748614050)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Login'
,p_process_sql_clob=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'apex_authentication.login(',
'    p_username => :P101_USERNAME,',
'    p_password => :P101_PASSWORD );'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(35597653675614051)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'Clear Page(s) Cache'
,p_attribute_01=>'CLEAR_CACHE_CURRENT_PAGE'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(35597423579614051)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Get Username Cookie'
,p_process_sql_clob=>':P101_USERNAME := apex_authentication.get_login_username_cookie;'
);
end;
/
prompt --application/deployment/definition
begin
null;
end;
/
prompt --application/deployment/install
begin
null;
end;
/
prompt --application/deployment/checks
begin
null;
end;
/
prompt --application/deployment/buildoptions
begin
null;
end;
/
prompt --application/end_environment
begin
wwv_flow_api.import_end(p_auto_install_sup_obj => nvl(wwv_flow_application_install.get_auto_install_sup_obj, false));
commit;
end;
/
set verify on feedback on define on
prompt  ...done
