set define off verify off feedback off
whenever sqlerror exit sql.sqlcode rollback
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_050000 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2013.01.01'
,p_default_workspace_id=>3625332328987376
);
end;
/
prompt  WORKSPACE 3625332328987376
--
-- Workspace, User Group, User, and Team Development Export:
--   Date and Time:   14:36 Friday June 29, 2018
--   Exported By:     ADMIN
--   Export Type:     Workspace Export
--   Version:         5.0.4.00.12
--   Instance ID:     69314666475274
--
-- Import:
--   Using Instance Administration / Manage Workspaces
--   or
--   Using SQL*Plus as the Oracle user APEX_050000
 
begin
    wwv_flow_api.set_security_group_id(p_security_group_id=>3625332328987376);
end;
/
----------------
-- W O R K S P A C E
-- Creating a workspace will not create database schemas or objects.
-- This API creates only the meta data for this APEX workspace
prompt  Creating workspace STORETDASH...
begin
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
end;
/
begin
wwv_flow_fnd_user_api.create_company (
  p_id => 3625502605987606
 ,p_provisioning_company_id => 3625332328987376
 ,p_short_name => 'STORETDASH'
 ,p_display_name => 'STORETDASH'
 ,p_first_schema_provisioned => 'STORETDASH_APEX'
 ,p_company_schemas => 'STORETDASH_APEX'
 ,p_account_status => 'ASSIGNED'
 ,p_allow_plsql_editing => 'N'
 ,p_allow_app_building_yn => 'Y'
 ,p_allow_packaged_app_ins_yn => 'Y'
 ,p_allow_sql_workshop_yn => 'N'
 ,p_allow_websheet_dev_yn => 'Y'
 ,p_allow_team_development_yn => 'N'
 ,p_allow_to_be_purged_yn => 'Y'
 ,p_allow_restful_services_yn => 'Y'
 ,p_source_identifier => 'STORETDA'
 ,p_path_prefix => 'STORETDASH'
 ,p_files_version => 1
 ,p_workspace_image => wwv_flow_api.g_varchar2_table
);
end;
/
----------------
-- G R O U P S
--
prompt  Creating Groups...
begin
wwv_flow_api.create_user_groups (
  p_id => 1835038152211407,
  p_GROUP_NAME => 'OAuth2 Client Developer',
  p_SECURITY_GROUP_ID => 10,
  p_GROUP_DESC => 'Users authorized to register OAuth2 Client Applications');
end;
/
begin
wwv_flow_api.create_user_groups (
  p_id => 1834946318211407,
  p_GROUP_NAME => 'RESTful Services',
  p_SECURITY_GROUP_ID => 10,
  p_GROUP_DESC => 'Users authorized to use RESTful Services with this workspace');
end;
/
begin
wwv_flow_api.create_user_groups (
  p_id => 1834863230211405,
  p_GROUP_NAME => 'SQL Developer',
  p_SECURITY_GROUP_ID => 10,
  p_GROUP_DESC => 'Users authorized to use SQL Developer with this workspace');
end;
/
prompt  Creating group grants...
----------------
-- U S E R S
-- User repository for use with APEX cookie-based authentication.
--
prompt  Creating Users...
begin
wwv_flow_fnd_user_api.create_fnd_user (
  p_user_id                      => '3625221815987376',
  p_user_name                    => 'ADMIN',
  p_first_name                   => 'DBSS',
  p_last_name                    => 'OAS',
  p_description                  => '',
  p_email_address                => 'DBSS_OAS@epa.gov',
  p_web_password                 => 'F07CA7FA155CE784AE579117C8CC543F185DA405',
  p_web_password_format          => '5;2;10000',
  p_group_ids                    => '1834863230211405:1834946318211407:1835038152211407:',
  p_developer_privs              => 'ADMIN:CREATE:DATA_LOADER:EDIT:HELP:MONITOR:SQL',
  p_default_schema               => 'STORETDASH_APEX',
  p_account_locked               => 'N',
  p_account_expiry               => to_date('201806131102','YYYYMMDDHH24MI'),
  p_failed_access_attempts       => 0,
  p_change_password_on_first_use => 'Y',
  p_first_password_use_occurred  => 'Y',
  p_allow_app_building_yn        => 'Y',
  p_allow_sql_workshop_yn        => 'Y',
  p_allow_websheet_dev_yn        => 'Y',
  p_allow_team_development_yn    => 'Y',
  p_allow_access_to_schemas      => '');
end;
/
begin
wwv_flow_fnd_user_api.create_fnd_user (
  p_user_id                      => '3626502538011777',
  p_user_name                    => 'DSPOREA',
  p_first_name                   => 'Daniel',
  p_last_name                    => 'Sporea',
  p_description                  => 'Indus Developer',
  p_email_address                => 'DSporea@induscorp.com',
  p_web_password                 => 'C5B3FA1C5D4D4451318382EA35327FC1',
  p_web_password_format          => '3;1;',
  p_group_ids                    => '1834863230211405:1834946318211407:1835038152211407:',
  p_developer_privs              => 'CREATE:EDIT:HELP:MONITOR',
  p_default_schema               => 'STORETDASH_APEX',
  p_account_locked               => 'N',
  p_account_expiry               => to_date('201302220730','YYYYMMDDHH24MI'),
  p_failed_access_attempts       => 0,
  p_change_password_on_first_use => 'N',
  p_first_password_use_occurred  => 'Y',
  p_allow_app_building_yn        => 'Y',
  p_allow_sql_workshop_yn        => 'Y',
  p_allow_websheet_dev_yn        => 'Y',
  p_allow_team_development_yn    => 'Y',
  p_allow_access_to_schemas      => '');
end;
/
begin
wwv_flow_fnd_user_api.create_fnd_user (
  p_user_id                      => '294565109728792701',
  p_user_name                    => 'TEMPSTORET',
  p_first_name                   => 'Kevin',
  p_last_name                    => 'Christian',
  p_description                  => 'Temporary ApEx User for internal STORET testing and checkout until Kevin is ready for general Public Access/ 2013/03/18 wreed.',
  p_email_address                => 'christian.kevin@epa.gov',
  p_web_password                 => '369ACF15B05C12E75612895EB52485D5',
  p_web_password_format          => '3;1;',
  p_group_ids                    => '',
  p_developer_privs              => '',
  p_default_schema               => 'STORETDASH_APEX',
  p_account_locked               => 'Y',
  p_account_expiry               => to_date('201303180000','YYYYMMDDHH24MI'),
  p_failed_access_attempts       => 0,
  p_change_password_on_first_use => 'N',
  p_first_password_use_occurred  => 'N',
  p_allow_app_building_yn        => 'N',
  p_allow_sql_workshop_yn        => 'N',
  p_allow_websheet_dev_yn        => 'N',
  p_allow_team_development_yn    => 'N',
  p_allow_access_to_schemas      => '');
end;
/
begin
wwv_flow_fnd_user_api.create_fnd_user (
  p_user_id                      => '14222998067469556',
  p_user_name                    => 'XJTURAKA',
  p_first_name                   => 'Jennifer',
  p_last_name                    => 'Turaka',
  p_description                  => 'Developer/Induscorp/(703) 852 9423',
  p_email_address                => 'jturaka@induscorp.com',
  p_web_password                 => '2A826774ADC5E5066C90486DF0DF8A6C8CA3C6D7',
  p_web_password_format          => '5;2;10000',
  p_group_ids                    => '',
  p_developer_privs              => 'CREATE:EDIT:HELP:MONITOR:SQL:MONITOR:DATA_LOADER:',
  p_default_schema               => 'STORETDASH_APEX',
  p_account_locked               => 'N',
  p_account_expiry               => to_date('201601121317','YYYYMMDDHH24MI'),
  p_failed_access_attempts       => 0,
  p_change_password_on_first_use => 'Y',
  p_first_password_use_occurred  => 'Y',
  p_allow_app_building_yn        => 'Y',
  p_allow_sql_workshop_yn        => 'Y',
  p_allow_websheet_dev_yn        => 'N',
  p_allow_team_development_yn    => 'Y',
  p_allow_access_to_schemas      => '');
end;
/
prompt Check Compatibility...
begin
-- This date identifies the minimum version required to import this file.
wwv_flow_team_api.check_version(p_version_yyyy_mm_dd=>'2010.05.13');
end;
/
 
begin wwv_flow.g_import_in_progress := true; wwv_flow.g_user := USER; end; 
/
 
--
prompt ...news
--
begin
null;
end;
/
--
prompt ...links
--
begin
null;
end;
/
--
prompt ...bugs
--
begin
null;
end;
/
--
prompt ...events
--
begin
null;
end;
/
--
prompt ...features
--
begin
null;
end;
/
--
prompt ...tasks
--
begin
null;
end;
/
--
prompt ...feedback
--
begin
null;
end;
/
--
prompt ...task defaults
--
begin
null;
end;
/
begin
wwv_flow_api.import_end(p_auto_install_sup_obj => nvl(wwv_flow_application_install.get_auto_install_sup_obj, false));
commit;
end;
/
set verify on feedback on define on
prompt  ...done
