
  CREATE OR REPLACE PACKAGE "STORETW"."DW_GLOB_VAR"
IS
   TYPE ident_arr100 IS TABLE OF VARCHAR2 (100)
      INDEX BY BINARY_INTEGER;

   empty                       OWA_UTIL.ident_arr;
   empty100                    ident_arr100;
   /****************************************************************************
    The following serve as examples for the variables that need to be set for specific environment.
     lv_program_path varchar2(1000):= URL for web procedures.  Example: 'http://'||owa_util.get_cgi_env('SERVER_NAME')||owa_util.get_owa_service_path;
     lv_script_path varchar2(1000):= URL for storet.js, a javascript file. Example: 'http://everest.sdc-moses.com/storet/modern/scripts/storet.js';
     lv_image_path varchar2(1000):= URL for storet image files. Example: 'http://everest.sdc-moses.com/storet/modern/images/';
     lv_doc_path varchar2(1000):= URL for static html documents.  Example: 'http://everest.sdc-moses.com/storet/modern/doc/';
   --file io directory for downloads
     lv_iodir varchar2(100):= physical directory path used for utl_file parameter.  Example: '/project/storet/modern/downloads';
     lv_download_path varchar2(200):= URL for above directory.  Example: 'http://everest.sdc-moses.com/storet/modern/downloads/';
   --Report server path with key
     lv_report_key varchar2(200):= Report server URL and key. Example: 'http://everest.sdc-moses.com/storet/cgi-bin/rwcgi60s?storetmod';
   -- where rwcgi60s is a shell script that sets cgi environment variables and calls Oracle's rwcgi60 executable.  storetmod is an entry in key mapping file. this key should have server=reportserver_name userid=storet_reports_username/password@connectstring %
   *****************************************************************************/

   lv_program_path             VARCHAR2 (1000);
   lv_script_path              VARCHAR2 (1000);
   lv_image_path               VARCHAR2 (1000);
   lv_doc_path                 VARCHAR2 (1000);
   lv_iodir                    VARCHAR2 (100);
   lv_utl_file_dir             VARCHAR2 (30);
   lv_download_path            VARCHAR2 (200);
   smtp_host                   VARCHAR2 (200);
   smtp_port                   NUMBER;
   GV_STN_Immediate_LMT        NUMBER;
   gv_stn_Overnight_lmt        NUMBER;
   gv_rslt_Immediate_lmt       NUMBER;
   gv_rslt_Overnight_lmt       NUMBER;
   gv_cmprs_fl_ext             VARCHAR2 (3);
   gv_overnight_hour           NUMBER;
   gv_pending_report_hr        NUMBER;
   gv_STORET_email             VARCHAR2 (50);
   national_project_criteria   NUMBER;
   gv_rslt_online_lmt          NUMBER;
   gv_stn_online_lmt           NUMBER;

   GV_METADATA_FLAG            VARCHAR2 (256);
   GV_PROJECT_BLOB_FLAG        VARCHAR2 (256);
   GV_ENCRYPTION_KEY           VARCHAR2 (256);
END;
/
CREATE OR REPLACE PACKAGE BODY "STORETW"."DW_GLOB_VAR"
IS
BEGIN
   SELECT PARAMETER_VALUE
     INTO LV_PROGRAM_PATH
     FROM MT_WH_CONFIG
    WHERE PARAMETER_NAME = 'LV_PROGRAM_PATH';

   SELECT PARAMETER_VALUE
     INTO LV_SCRIPT_PATH
     FROM MT_WH_CONFIG
    WHERE PARAMETER_NAME = 'LV_SCRIPT_PATH';

   SELECT PARAMETER_VALUE
     INTO LV_IMAGE_PATH
     FROM MT_WH_CONFIG
    WHERE PARAMETER_NAME = 'LV_IMAGE_PATH';

   SELECT PARAMETER_VALUE
     INTO LV_DOC_PATH
     FROM MT_WH_CONFIG
    WHERE PARAMETER_NAME = 'LV_DOC_PATH';

   SELECT PARAMETER_VALUE
     INTO LV_IODIR
     FROM MT_WH_CONFIG
    WHERE PARAMETER_NAME = 'LV_IODIR';

   SELECT PARAMETER_VALUE
     INTO LV_UTL_FILE_DIR
     FROM MT_WH_CONFIG
    WHERE PARAMETER_NAME = 'LV_UTL_FILE_DIR';

   SELECT PARAMETER_VALUE
     INTO LV_DOWNLOAD_PATH
     FROM MT_WH_CONFIG
    WHERE PARAMETER_NAME = 'LV_DOWNLOAD_PATH';

   SELECT PARAMETER_VALUE
     INTO SMTP_HOST
     FROM MT_WH_CONFIG
    WHERE PARAMETER_NAME = 'SMTP_HOST';

   SELECT TO_NUMBER (PARAMETER_VALUE)
     INTO SMTP_PORT
     FROM MT_WH_CONFIG
    WHERE PARAMETER_NAME = 'SMTP_PORT';

   SELECT TO_NUMBER (PARAMETER_VALUE)
     INTO GV_STN_IMMEDIATE_LMT
     FROM MT_WH_CONFIG
    WHERE PARAMETER_NAME = 'GV_STN_IMMEDIATE_LMT';

   SELECT TO_NUMBER (PARAMETER_VALUE)
     INTO GV_STN_OVERNIGHT_LMT
     FROM MT_WH_CONFIG
    WHERE PARAMETER_NAME = 'GV_STN_OVERNIGHT_LMT';

   SELECT TO_NUMBER (PARAMETER_VALUE)
     INTO GV_RSLT_IMMEDIATE_LMT
     FROM MT_WH_CONFIG
    WHERE PARAMETER_NAME = 'GV_RSLT_IMMEDIATE_LMT';

   SELECT TO_NUMBER (PARAMETER_VALUE)
     INTO GV_RSLT_OVERNIGHT_LMT
     FROM MT_WH_CONFIG
    WHERE PARAMETER_NAME = 'GV_RSLT_OVERNIGHT_LMT';

   SELECT PARAMETER_VALUE
     INTO GV_CMPRS_FL_EXT
     FROM MT_WH_CONFIG
    WHERE PARAMETER_NAME = 'GV_CMPRS_FL_EXT';

   SELECT TO_NUMBER (PARAMETER_VALUE)
     INTO GV_OVERNIGHT_HOUR
     FROM MT_WH_CONFIG
    WHERE PARAMETER_NAME = 'GV_OVERNIGHT_HOUR';

   -- MAY BE CANDIDATE FOR TO_NUMBER -- VERIFY
   SELECT PARAMETER_VALUE
     INTO GV_PENDING_REPORT_HR
     FROM MT_WH_CONFIG
    WHERE PARAMETER_NAME = 'GV_PENDING_REPORT_HR';

   SELECT PARAMETER_VALUE
     INTO GV_STORET_EMAIL
     FROM MT_WH_CONFIG
    WHERE PARAMETER_NAME = 'GV_STORET_EMAIL';

   SELECT TO_NUMBER (PARAMETER_VALUE)
     INTO NATIONAL_PROJECT_CRITERIA
     FROM MT_WH_CONFIG
    WHERE PARAMETER_NAME = 'NATIONAL_PROJECT_CRITERIA';

   SELECT TO_NUMBER (PARAMETER_VALUE)
     INTO GV_RSLT_ONLINE_LMT
     FROM MT_WH_CONFIG
    WHERE PARAMETER_NAME = 'GV_RSLT_ONLINE_LMT';

   SELECT TO_NUMBER (PARAMETER_VALUE)
     INTO GV_STN_ONLINE_LMT
     FROM MT_WH_CONFIG
    WHERE PARAMETER_NAME = 'GV_STN_ONLINE_LMT';

   SELECT PARAMETER_VALUE
     INTO GV_METADATA_FLAG
     FROM MT_WH_CONFIG
    WHERE PARAMETER_NAME = 'GV_METADATA_FLAG';

   SELECT PARAMETER_VALUE
     INTO GV_PROJECT_BLOB_FLAG
     FROM MT_WH_CONFIG
    WHERE PARAMETER_NAME = 'GV_PROJECT_BLOB_FLAG';

   SELECT PARAMETER_VALUE
     INTO GV_ENCRYPTION_KEY
     FROM MT_WH_CONFIG
    WHERE PARAMETER_NAME = 'GV_ENCRYPTION_KEY';
END dw_glob_var;
/

