
  CREATE OR REPLACE PROCEDURE "STORETW"."DW_COUNTY_POPUP" (v_StateCode number) AS
v_StateName varchar2(40);
script_path varchar2(1000);

CURSOR c_CountyList IS
	SELECT county_name, pk_isn
		FROM DI_GEO_COUNTY
		WHERE fk_geo_state = v_StateCode;
BEGIN
script_path := DW_glob_var.lv_script_path;
select state_name into v_StateName
  From di_geo_state
  where pk_isn = v_StateCode;

htp.htmlOpen;
htp.headOpen;
htp.print('<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">');
htp.title( 'STORET: Select Counties');
htp.print('<SCRIPT LANGUAGE="JavaScript1.2" SRC='||script_path||'>');
htp.print( '</SCRIPT>' );
htp.print('<basefont face="Arial, Helvetica, sans-serif" size="2">');
htp.headClose;
htp.bodyOpen( 'onload="document.forms[0].as_county.selectedIndex = -1"');
htp.print( '<b>Select One or More Counties in '||v_StateName||'</b>' );
htp.PRINT('<form name="select_county">');
htp.print('<FONT face="Courier">');
htp.formSelectOpen( cname => 'as_county', nsize => '10', cattributes => 'multiple style="font:  10pt/12pt COURIER"');
htp.FormSelectOption('Select All', cattributes => 'value = ALL');
FOR cv_state IN c_CountyList LOOP
	HTP.FormSelectOption(cv_state.county_name, cattributes => 'value ='||cv_state.pk_isn);
END LOOP;
HTP.FormSelectClose;
htp.print('</font><font face="Arial"><br><INPUT TYPE="button" VALUE="Select" onclick="passback(''COUNTY'')"> <INPUT TYPE="button" VALUE="Cancel" onclick="Close_Onclick()"></font>' );
htp.formclose;
htp.bodyClose;
htp.htmlClose;
END;

/

