
  CREATE OR REPLACE PROCEDURE "STORETW"."DW_EXTREF_POPUP" (v_org number) AS
--v_OrgName varchar2(60);
v_OrgName varchar2(256);
script_path varchar2(1000);

CURSOR cextref IS
	SELECT pk_isn, ref_scheme_acronym, ref_scheme_name
	FROM LU_EXTERNAL_REF_SCHEME
	WHERE organization_id IN
 	  (SELECT organization_id FROM DI_ORG
  	   WHERE pk_isn = v_org)
	ORDER BY ref_scheme_acronym;

BEGIN
script_path := DW_glob_var.lv_script_path;

select organization_name into v_OrgName
  From di_org
  where pk_isn = v_org;

htp.htmlOpen;
htp.headOpen;
htp.print('<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">');
htp.title( 'STORET: Select a Station Alias type');
htp.print('<SCRIPT LANGUAGE="JavaScript1.2" SRC='||script_path||'>');
htp.print( '</SCRIPT>' );
htp.print('<basefont face="Arial, Helvetica, sans-serif" size="2">');
htp.headClose;
htp.print('<BODY onload=adjust_width_n(document.forms[0].D_EXTREF_LIST,"~","20~60","None","N");>');
htp.print( '<b>Select a Station Alias Type for the Organization: '||v_OrgName||'</b><br>' );
htp.PRINT('<form name="select_extref">');
htp.print('<font face="Courier">');
htp.formSelectOpen('D_EXTREF_LIST', nsize => '10', cattributes => 'tabindex=25 style="font:  10pt/12pt COURIER"');
htp.formSelectOption('Station Alias Type~Description', cattributes => 'VALUE=0');
htp.formSelectOption('____________________________________________________________________________________',cattributes => 'VALUE=0');
htp.formSelectOption('STANDARD', cattributes => 'VALUE=0');
	FOR extref IN cextref LOOP
        	htp.formSelectOption(extref.ref_scheme_acronym||'~'||extref.ref_scheme_name, cattributes => 'VALUE='||extref.pk_isn);
	END LOOP;
htp.FormSelectClose;
htp.print('</font><font face="Arial"><br><INPUT TYPE="button" VALUE="Select" onclick="passback(''EXTREF'')"> <INPUT TYPE="button" VALUE="Cancel" onclick="Close_Onclick()"></font>' );
htp.formclose;
htp.bodyClose;
htp.htmlClose;
END;

/

