
  CREATE OR REPLACE PROCEDURE "STORETW"."DW_REPORT_PENDING_REQUESTS" as

lv_Overnight_hr number := dw_glob_var.gv_Overnight_hour;
lv_Overnight_pend_ct  number:=0;
lv_Immediate_pend_ct number:=0;
lv_request_ids_Overnight varchar2(2000):='(';
lv_request_ids_Immediate varchar2(2000):='(';
lv_exec_overnight varchar2(2020);
lv_exec_immediate varchar2(2020);

lv_message varchar2(4000);

--Immediate jobs that were submitted 8 hours prior to current time.

cursor req_pend_cur is
select request_id, request_mode, request_status, datetime from dw_data_requests
where
(request_mode = 'Overnight'
 and datetime < ((trunc(sysdate)-1)+lv_Overnight_hr/24)
 and request_status != 'Completed')
or
(request_mode = 'Immediate'
 and datetime < (sysdate - (8/24))
 and request_status != 'Completed');


begin

for cv_pend in req_pend_cur loop
  if cv_pend.request_mode = 'Overnight' then
    if lv_Overnight_pend_ct = 0 then
      lv_request_ids_Overnight:= lv_request_ids_Overnight||''||cv_pend.request_id;
      lv_Overnight_pend_ct:=lv_Overnight_pend_ct+1;
    elsif lv_Overnight_pend_ct > 0 then
      lv_request_ids_Overnight:= lv_request_ids_Overnight||', '||cv_pend.request_id;
      lv_Overnight_pend_ct:=lv_Overnight_pend_ct+1;
    end if;
  elsif cv_pend.request_mode = 'Immediate' then
    if lv_Immediate_pend_ct = 0 then
      lv_request_ids_Immediate:= lv_request_ids_Immediate||''||cv_pend.request_id;
      lv_Immediate_pend_ct:=lv_Immediate_pend_ct+1;
    elsif lv_Immediate_pend_ct > 0 then
      lv_request_ids_Immediate:= lv_request_ids_Immediate||', '||cv_pend.request_id;
      lv_Immediate_pend_ct:=lv_Immediate_pend_ct+1;
    end if;
  end if;
end loop;
  lv_request_ids_Overnight:= lv_request_ids_Overnight||')';
  lv_request_ids_Immediate:= lv_request_ids_Immediate||')';

  if lv_Overnight_pend_ct > 0 then
    lv_exec_overnight := 'exec DW_PROCESS_DATA_REQUEST_LIST('''||
        SUBSTR(lv_request_ids_Overnight,2,(LENGTH  (lv_request_ids_Overnight)-2))||''');';
  end if;
  if lv_Immediate_pend_ct > 0 then
    lv_exec_immediate := 'exec DW_PROCESS_DATA_REQUEST_LIST('''||
      SUBSTR(lv_request_ids_Immediate,2,(LENGTH(lv_request_ids_Immediate)-2))||''');';
  end if;
lv_message := '           STORET Central Warehouse Pending Batch Requests

';
--Message
if (lv_Overnight_pend_ct > 0 and lv_Immediate_pend_ct > 0 )then
lv_message:=  lv_message||
'There are '||lv_Overnight_pend_ct||' pending Overnight jobs and '||lv_Immediate_pend_ct||' pending Immediate jobs found in DW_DATA_REQUESTS table.

The Request_ID of these jobs are as follows:
Immediate --> '||lv_request_ids_Immediate||'
Overnight --> '||lv_request_ids_Overnight||'.'||'

You may run the following in a SQL*Plus session to process above identified requests

'||lv_exec_Immediate||'
'||lv_exec_Overnight;

elsif (lv_Overnight_pend_ct > 0 and lv_Immediate_pend_ct = 0 ) then
lv_message:=  lv_message||
'There are '||lv_Overnight_pend_ct||' pending Overnight jobs and '||lv_Immediate_pend_ct||' pending Immediate jobs found in DW_DATA_REQUESTS table.

The Request_ID of these jobs are as follows:
Overnight --> '||lv_request_ids_Overnight||'.'||'

You may run the following in a SQL*Plus session to process above identified requests

'||lv_exec_Overnight;


elsif (lv_Immediate_pend_ct > 0 and lv_Overnight_pend_ct = 0 ) then
lv_message:=   lv_message||
'There are '||lv_Overnight_pend_ct||' pending Overnight jobs and '||lv_Immediate_pend_ct||' pending Immediate jobs found in DW_DATA_REQUESTS table.

The Request_ID of these jobs are as follows:
Immediate --> '||lv_request_ids_Immediate||'.'||'

You may run the following in a SQL*Plus session to process above identified requests

'||lv_exec_Immediate;

elsif (lv_Immediate_pend_ct = 0 and lv_Overnight_pend_ct = 0 ) then
  lv_message:=   lv_message||'No pending jobs found.';
end if;

--dbms_output.put_line(to_char(lv_immediate_pend_ct));
--dbms_output.put_line(to_char(lv_overnight_pend_ct));
--dbms_output.put_line(lv_message);




if (lv_Immediate_pend_ct + lv_Overnight_pend_ct) > 0 then
    dw_mail_pkg.send
    ( p_sender_email => dw_glob_var.gv_storet_email,
       p_from => 'STORET Web Site <'||dw_glob_var.gv_storet_email||'>',
       p_to => dw_mail_pkg.array( dw_glob_var.gv_STORET_email),
       p_subject => 'Report of pending data requests  '||to_char(sysdate,'yyyy/mm/dd'),
       p_body => lv_message);
end if;
end;

/

