
  CREATE OR REPLACE PROCEDURE "STORETW"."DW_STATION_HUB_CUSTOM"
(v_FromStmt		IN	VARCHAR2,
v_WhereStmt		IN 	VARCHAR2,
v_StationCount		IN 	VARCHAR2,
v_filters		IN	VARCHAR2,
v_mode 			IN	VARCHAR2,
v_email			IN      VARCHAR2 default 'No_Email_Provided',
v_prefix		in      varchar2 default 'EPA',
v_Columns 		owa_util.ident_arr,
report_type 		varchar2 :='CUSTOM'
)
AS

v_exists 		boolean;
v_file_length 		number;
v_blocksize 		number;

program_path  		varchar2(1000) := null;
script_path   		varchar2(1000) := null;
image_path    		varchar2(1000) := null;
page_title    		varchar2(100);
--
--The out_file variable will contain the entire URL of the file created within
--the called download procedures.
--
out_file	  	varchar2(200);

lv_file_name varchar2(100);
lv_filetype varchar2(3);
lv_timestamp varchar2(20);
lv_file_length number;
lv_request_id dw_data_requests.request_id%type;
lv_email dw_data_requests.email_address%type;
lv_prefix varchar2(3);
lv_outfile_display varchar2(200);

BEGIN
    if v_mode = 'Online' then
	page_title :='Download Site Descriptions';
	DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path);
	htp.print('<form action="DW_station_download_zip" method=POST>');
	htp.para;
	htp.para;
	htp.para;
	htp.print('<center>');
	IF report_type = 'CUSTOM' THEN
		htp.print('You have requested to download a custom site description');
		DW_station_download_custom(v_FromStmt,v_WhereStmt,v_Columns,'NONE',null,null,v_mode,v_StationCount,v_filters,out_file,lv_request_id);
	END IF;

	utl_file.fgetattr(DW_GLOB_VAR.lv_iodir,out_file,v_exists,v_file_length,v_blocksize);
	  --****************************************************************************************
		--sug commented as part of station download
	--htp.print('<br><br>The size of your report download is <b>'||ROUND(v_file_length/1024,1)||'KB</b>');
	--htp.Br;
	--htp.Br;
	--htp.anchor(out_file,htf.bold('Download your file now...'));
	--****************************************************
	htp.Br;
	lv_file_length:=ROUND(v_file_length/1024,1);
	--lv_file_name:=substr(out_file,-22);
	--lv_filetype:=substr(lv_file_name,0,3);
	--lv_timestamp:=substr(lv_file_name,4,15);

	-- Record only when download is successful.
	--if lv_filetype in ('SDB','SDH','SDR','SDS') then
	--  dw_record_data_request(v_filters,lv_filetype,lv_timestamp,lv_file_length);
	--end if;
	--********************************************************
	--sug commented as part of station download
	--htp.Br;
	--htp.print('or, for large files, you may click below to compress before download');
	--htp.Br;
	htp.Br;
 	--htp.print('<a HREF="javascript:document.forms[1].submit();">Compress data file now...</a>');
	htp.print('<a HREF="javascript:document.forms[1].submit();">Download data file now...</a>');
	--**************************************************************
	htp.print('</center>');
	htp.print('<input type="hidden" name="out_file" value='||out_file||'>');
	DW_bottom_of_page(8);
  elsif v_mode in ('Immediate','Overnight') then
      if v_email is null then
        lv_email:='NoEmailProvided';
      else
        lv_email:=v_email;
      end if;
      if v_prefix is null then
        lv_prefix:='EPA';
      else
        lv_prefix:=v_prefix;
      end if;


    -- record Overnight/Immediate request and return a filename.
	page_title :='Station Download request via '||v_mode||' batch process';

	DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path);
           htp.print('<center>');

	IF report_type = 'CUSTOM' THEN
		htp.print('You have requested for a custom station download via '||v_mode||' batch processing.');
		DW_station_download_custom(v_FromStmt,v_WhereStmt,v_Columns,'NONE',lv_email,lv_prefix,v_mode,v_StationCount,v_filters,out_file,lv_request_id);
--lv_outfile_display:='Data_'||replace(out_file,'.txt','_Stations.txt');
lv_outfile_display:=replace(out_file,'.txt','');

	END IF;
          htp.print('The Request is successfully submitted.  A confirmation is sent to the email address you provided.');
          htp.br;
	  htp.br;
          htp.br;
          htp.print('<table cols=1 align="center" border=0>
           <tr><td align=Center><B>Request Information </B> </td></tr>
           <tr><td align=left>Request ID    : '||lv_request_id||'  </td></tr>
           <tr><td align=left>Request Type  : Station Download  </td></tr>
           <tr><td align=left>Record Count  : '||v_StationCount  ||'  </td></tr>
           <tr><td align=left>Request Mode  : '||v_mode   ||' batch </td></tr>
           <tr><td align=left>File Name     : '||lv_outfile_display||'.'||dw_glob_var.gv_cmprs_fl_ext ||'  </td></tr>
           <tr><td align=left>URL     : '||dw_glob_var.lv_download_path||lv_outfile_display||'.'||dw_glob_var.gv_cmprs_fl_ext ||'  </td></tr>
           <tr><td align=left>Email Address : '||lv_email||'  </td></tr>
           <tr><td> </td> </tr>
           <tr><td align=left>You will be notified when the request is processed.   </td></tr>
         </table>');

            htp.print('<form><input type="button" value="  <<Back  " width=40 onClick=Close_Onclick();></form></center>');

	DW_bottom_of_page(8);

  end if;

END;

/

