
  CREATE OR REPLACE PROCEDURE "STORETW"."DW_STATION_POPUP" (v_StationString char, v_org number,
    v_searchtype char, v_extref char)
AS
--v_OrgName varchar2(60);
v_OrgName varchar2(256);
v_StationStringCap varchar2(20) := UPPER(v_StationString);
script_path varchar2(1000);

-- Based on the search type that was selected on the Results by Station page
-- and passed in, one of the following queries are used to retrieve data for the
-- station list.

--   if search type is "Name",
--   select data where the Station Name matches the search string
CURSOR c_SearchNameList IS
	SELECT organization_id, station_id, station_name, pk_isn
		FROM FA_STATION
		WHERE UPPER(station_name) like v_StationStringCap||'%'
		AND location_point_type = '*POINT OF RECORD'
		AND fk_org = v_org
	ORDER BY station_name;

--   if search type is "ID",
--   select data where the Station ID matches the search string
CURSOR c_SearchIDList IS
	SELECT organization_id, station_id, station_name, pk_isn
		FROM FA_STATION
		WHERE station_ID like v_StationStringCap||'%'
		AND location_point_type = '*POINT OF RECORD'
		AND fk_org = v_org
	ORDER BY station_id;

--   if search type is "Label",
--   select data where the Station Label under the selected External Ref Scheme
--   matches the search string
CURSOR c_SearchLabelList IS
	SELECT b.organization_id, b.station_id, a.station_label, b.station_name, b.pk_isn
		FROM LU_STATION_ALIAS a, FA_STATION b
 		WHERE UPPER(a.station_label) like v_StationStringCap||'%'
		AND a.fk_station = b.pk_isn
		AND b.location_point_type = '*POINT OF RECORD'
		AND b.fk_org = v_org
		AND EXISTS
		(SELECT 'x' FROM LU_EXTERNAL_REF_SCHEME c
		 WHERE c.ref_scheme_acronym = rpad(v_extref,8,' ')
		 AND c.pk_isn = a.fk_ref_scheme
		 AND c.organization_id = b.organization_id)
	ORDER BY a.station_label;

BEGIN
script_path := DW_glob_var.lv_script_path;

-- get the org name to be displayed on the web page
select organization_name into v_OrgName
  From di_org
  where pk_isn = v_org;

htp.htmlOpen;
htp.headOpen;
htp.print('<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">');
htp.title( 'STORET: Station Search Results');
htp.print('<SCRIPT LANGUAGE="JavaScript1.2" SRC='||script_path||'>');
htp.print( '</SCRIPT>' );
htp.print('<basefont face="Arial, Helvetica, sans-serif" size="2">');
htp.headClose;
htp.print('<BODY onload=adjust_width_n(document.forms[0].d_station_list,"~","9~16~13~21~60","None","N");>');
htp.print( '<b>Select One or More Stations from the Organization: '||v_OrgName||'</b><br>' );
htp.print('<form name="select_stations">');
htp.print('<FONT style="font-size: 9pt; font-family: Courier New, Courier, monospace">');
htp.formSelectOpen('d_station_list', nsize => '10', cattributes => 'tabindex=1 multiple style="font-size: 8pt; font-family: Courier New, Courier, monospace"');
--htp.formSelectOption('Org ID~Station ID~Ext Ref Acrn~Ext Ref Label~Station Name', cattributes => 'value=0');
htp.formSelectOption('Org ID~Station ID~Alias Type~Station Alias~Station Name', cattributes => 'value=0');
htp.FormSelectOption('____________________________________________________________________________________________________________________________',cattributes => 'value=0');

if v_searchtype = 'Name' then
	FOR cv_station IN c_SearchNameList LOOP
		HTP.FormSelectOption(cv_station.organization_id||'~'||cv_station.station_id
              ||'~N/A~N/A~'||cv_station.station_name,cattributes => 'value ='||cv_station.pk_isn);
	END LOOP;
elsif v_searchtype = 'ID' or v_extref = 'STANDARD' then
	FOR cv_station IN c_SearchIDList LOOP
		HTP.FormSelectOption(cv_station.organization_id||'~'||cv_station.station_id
              ||'~N/A~N/A~'||cv_station.station_name,cattributes => 'value ='||cv_station.pk_isn);
	END LOOP;
else
	FOR cv_station IN c_SearchLabelList LOOP
		HTP.FormSelectOption(cv_station.organization_id||'~'||cv_station.station_id
              ||'~'||v_extref||'~'||cv_station.station_label||'~'||cv_station.station_name,cattributes => 'value ='||cv_station.pk_isn);
	END LOOP;
end if;
htp.FormSelectClose;
htp.print('</font> <br><font face="Arial"><INPUT TYPE="button" size="2" VALUE="Select" onclick="passback(''STATION'')"> <INPUT TYPE="button" VALUE="Cancel" onclick="Close_Onclick()"></font>' );
htp.formclose;
htp.bodyClose;
htp.htmlClose;
END;

/

