
  CREATE OR REPLACE PROCEDURE "STORETW"."DW_STATIONQUERY_COUNT" (
--Version2.6 Date2010-09-01
geographic 		char default NULL,
as_state 		number default 0,
as_county 		char default 'ALL',
v_county_code 		char default 'ALL',
MAX_LAT_DD 		number default 90,
dir_maxlat 		char default NULL,
MIN_LONG_DD 		number default 180,
dir_minlong		char default NULL,
MAX_LONG_DD 		number default 0,
dir_maxlong		char default NULL,
MIN_LAT_DD 		number default 0,
dir_minlat 		char default NULL,
as_huc 			char default 'ALL',
D_STYPE_LIST 		owa_util.ident_arr default DW_glob_var.empty,
from_mon1		char default 'JAN',
from_dd1		number default 1,
from_yyyy1		number default 1900,
end_mon1		char default TO_CHAR(SYSDATE,'MON'),
end_dd1			number default TO_NUMBER(TO_CHAR(SYSDATE,'DD')),
end_yyyy1		number default TO_NUMBER(TO_CHAR(SYSDATE,'YYYY')),
from_mon2		char default 'DUMMY',
from_dd2		number default 0,
from_yyyy2		number default 0,
end_mon2		char default 'DUMMY',
end_dd2			number default 0,
end_yyyy2		number default 0,
from_mon3		char default 'DUMMY',
from_dd3		number default 0,
from_yyyy3		number default 0,
end_mon3		char default 'DUMMY',
end_dd3			number default 0,
end_yyyy3		number default 0,
from_mon4		char default 'DUMMY',
from_dd4		number default 0,
from_yyyy4		number default 0,
end_mon4		char default 'DUMMY',
end_dd4			number default 0,
end_yyyy4		number default 0,
--characteristic 	char,
v_char_names		char default NULL,
as_char 		char default NULL,
AS_CHAR_ALIAS_TYPE	number default 0,
char_list		owa_util.ident_arr default DW_glob_var.empty,
taxon_filter 		char default 'ON',
d_org_list		number default 0,
d_proj_list		number default 0,
as_proj     		char default NULL,
V_STATION_NAMES		char default NULL,
AS_STATION		char default 'dummy',
station_list		owa_util.ident_arr default DW_glob_var.empty,
as_extref		char default NULL,
d_extref_list		number default 0,
d_medium_list       	owa_util.ident_arr default DW_glob_var.empty,
d_intent_list       	owa_util.ident_arr default DW_glob_var.empty,
d_community_list    	owa_util.ident_arr default DW_glob_var.empty,
searchtype		char default NULL,
result_type		char default 'REGULAR',
source_app               varchar2 default 'WATERSHED',
in_chartype_list   varchar2 default 'ALL',
in_chartype_names varchar2 default 'ALL',
-- station only
d_org_list2		owa_util.ident_arr default DW_glob_var.empty
)

AS
v_huc		NUMBER; -- station only
v_StationCount		NUMBER; -- station only
v_begin_date		date; -- station only
v_end_date		date; -- station only
v_char_flag		BOOLEAN := FALSE; -- station only
v_STN_org_id		FA_STATION.ORGANIZATION_ID%TYPE; -- station only
v_STN_id		FA_STATION.STATION_ID%TYPE; -- station only
-- 2010-07-14
v_station_org_id_list		VARCHAR2(2000); -- station only
v_station_id_list		VARCHAR2(2000); -- station only
v_STN_org_id_last	FA_STATION.ORGANIZATION_ID%TYPE; -- station only
v_CursorID		INTEGER;
v_SelectStmt		VARCHAR2(1000);
v_FromStmt		VARCHAR2(1000);
v_WhereStmt		VARCHAR2(3000);
v_SQLStmt		VARCHAR2(5000);
v_Dummy			INTEGER;
v_ResultCount		NUMBER;
v_stype_list		VARCHAR2(500);
v_StateName		varchar2(40);
v_stype_name_list 	varchar2(1000);
v_stype_name		varchar2(100);
v_char_list		varchar2(2000);
v_station_list		varchar2(2000);
v_org_list		varchar2(500);
v_org_id		varchar2(100);
v_org_id_list        varchar2(1000);
v_proj_list		varchar2(500);
v_proj_id		varchar2(100);
v_proj_id_list		varchar2(500);
v_begin_date1		date;
v_end_date1		date;
v_begin_date2		date;
v_end_date2		date;
v_begin_date3		date;
v_end_date3		date;
v_begin_date4		date;
v_end_date4		date;
v_fk_begin_date		number(12,0);
v_fk_end_date		number(12,0);
v_bio_flag		BOOLEAN := FALSE;
v_result_flag		BOOLEAN := FALSE;
v_date_flag		BOOLEAN := FALSE;
v_curr_date		varchar2(11) := to_char(SYSDATE,'DD-MON-YYYY');
-- ignore negative values on lat/long
v_maxlat		number := ABS(max_lat_dd);
v_minlat		number := ABS(min_lat_dd);
v_maxlong		number := ABS(max_long_dd);
v_minlong		number := ABS(min_long_dd);
v_medium_list     	varchar2(500);
v_medium_isn_list 	varchar2(50);
v_medium          	varchar2(20);
v_intent_isn_list 	varchar2(50);
v_intent_list     	varchar2(200);
v_intent          	varchar2(20);
v_taxon			boolean := FALSE;
v_community_isn_list  	varchar2(50);
v_community_list  	varchar2(500);
v_community       	varchar2(30);
v_rule_optimization	varchar2(10):= 'FALSE';
v_max_report_size	number:= 60000;
report_Type                  varchar2(30) :=null;
program_path  		varchar2(1000) := null;
script_path   		varchar2(1000) := null;
image_path    		varchar2(1000) := null;
page_title    		varchar2(100)  :='Station Search Summary';

v_num_repElement 	number;
v_repElement_count	number :=0;

help_file         varchar2(100);

v_filters varchar2(32000):= ''; -- ~ is the delimiter for dw_record_data_request
-- 2010-09-01 Search Paramater values: query parameters
v_parameters varchar2(32000):= '';

-- Variables for National Projects
cpk_isn           number := null;
--proj_cd		varchar2(100) := null;
proj_cd        varchar2(256) := null;
--proj_nm		varchar2(100) := null;
proj_nm        varchar2(256) := null;

-- WSHed summary variables
vR_SelectStmt		VARCHAR2(1000);
vR_FromStmt		VARCHAR2(1000);
vR_WhereStmt		VARCHAR2(3000);
vR_SQLStmt		VARCHAR2(5000);
vR_ResultCount		NUMBER :=0;

vB_SelectStmt		VARCHAR2(1000);
vB_FromStmt		VARCHAR2(1000);
vB_WhereStmt		VARCHAR2(3000);
vB_SQLStmt		VARCHAR2(5000);
vB_ResultCount		NUMBER :=0;

vH_SelectStmt		VARCHAR2(1000);
vH_FromStmt		VARCHAR2(1000);
vH_WhereStmt		VARCHAR2(3000);
vH_SQLStmt		VARCHAR2(5000);
vH_ResultCount		NUMBER :=0;

vmin_ResultCount		NUMBER;

--Cursor retrieves Station - Select Data Elements for Report
CURSOR cRepElement IS
	SELECT DISTINCT ELEMENT_NAME, STN_REPORT_NUMBER, STN_ELEMENT_DEFAULT, HELP_LINK
	FROM APP_COLUMN_NAME
	where STN_REPORT_NUMBER IS NOT NULL
	order by STN_REPORT_NUMBER;

--WShed summary
CURSOR cALLRepElement IS
	SELECT DISTINCT ELEMENT_NAME, ALL_REPORT_NUMBER, ALL_ELEMENT_DEFAULT, HELP_LINK
	FROM APP_COLUMN_NAME
	where ALL_REPORT_NUMBER IS NOT NULL
	order by ALL_REPORT_NUMBER;


--Cursor retreives National and Non-National Projects
CURSOR nat_proj_list IS
	select A.pk_isn, A.project_cd, ORG.organization_id from di_project A, di_org ORG where
	ORG.pk_isn = A.fk_org and
	A.project_cd = (select B.project_cd from di_project B where B.pk_isn = D_PROJ_LIST);

CURSOR proj_list IS
	select A.pk_isn, A.project_cd, ORG.organization_id from di_project A, di_org ORG where
	ORG.pk_isn = A.fk_org and A.pk_isn = D_PROJ_LIST;


procedure get_date_isn(v_begin_date DATE, v_end_date DATE) is
BEGIN
	SELECT pk_isn INTO v_fk_begin_date
		FROM DI_DATE
		WHERE full_date = v_begin_date;
	SELECT pk_isn INTO v_fk_end_date
		FROM DI_DATE
		WHERE full_date = v_end_date;
END;



BEGIN
	 -- Initialize SQL Statement: STATIONS
   -- Join Result Fact tables
    v_bio_flag := FALSE;
    v_result_flag := FALSE;
	 v_SelectStmt := 'SELECT count(distinct (FA.pk_isn)) INTO :StationCount';
	 v_FromStmt := 'FROM FA_STATION FA';
	 v_WhereStmt := ' WHERE 1=1';
	 --Wshed summary
	 vR_SelectStmt := 'SELECT distinct FRR.fk_station ';
	 vB_SelectStmt := 'SELECT distinct FRR.fk_station ';
	 vH_SelectStmt := 'SELECT distinct FRR.fk_station ';

	 vR_FromStmt := 'FROM FA_STATION FA, FA_REGULAR_RESULT FRR';
	 vB_FromStmt := 'FROM FA_STATION FA, FA_BIOLOGICAL_RESULT FBR';
	 vH_FromStmt := 'FROM FA_STATION FA, FA_HABITAT_RESULT FHR';

	 vR_WhereStmt := ' WHERE 1=1 and FA.PK_ISN=FRR.FK_STATION';
	 vB_WhereStmt := ' WHERE 1=1 and FA.PK_ISN=FBR.FK_STATION';
	 vH_WhereStmt := ' WHERE 1=1 and FA.PK_ISN=FHR.FK_STATION';

--Generate WHERE statement based on geographic search type
IF geographic = 'StateCounty' THEN
   -- Join Result Fact tables
    v_bio_flag := FALSE;
    v_result_flag := FALSE;
	IF as_state <> 0 THEN
		SELECT state_name into v_StateName
  			From di_geo_state
  			where pk_isn = as_state;
		IF v_County_Code <> 'ALL' THEN
			v_WhereStmt:= v_WhereStmt || ' AND FA.fk_geo_county IN ('||v_County_Code||')';
                        vR_WhereStmt := vR_WhereStmt || ' AND FRR.fk_geo_county IN ('||v_County_Code||')';
                        vB_WhereStmt := vB_WhereStmt || ' AND FBR.fk_geo_county IN ('||v_County_Code||')';
                        vH_WhereStmt := vH_WhereStmt || ' AND FHR.fk_geo_county IN ('||v_County_Code||')';
		ELSE
			v_WhereStmt:= v_WhereStmt || ' AND FA.fk_geo_state = '||as_state;
                        vR_WhereStmt := vR_WhereStmt || ' AND FRR.fk_geo_state = '||as_state;
                        vB_WhereStmt := vB_WhereStmt || ' AND FBR.fk_geo_state = '||as_state;
                        vH_WhereStmt := vH_WhereStmt || ' AND FHR.fk_geo_state = '||as_state;
		END IF;
	END IF;
ELSIF geographic = 'HUC' THEN
   -- Join Result Fact tables
    v_bio_flag := FALSE;
    v_result_flag := FALSE;
	IF as_huc <> 'ALL' THEN
	  --WShed Summary
	  v_WhereStmt:= v_WhereStmt || ' AND FA.generated_HUC = '''||as_huc||'''';
	  vR_WhereStmt:= vR_WhereStmt || ' AND FRR.generated_HUC = '''||as_huc||'''';
	  vB_WhereStmt:= vB_WhereStmt || ' AND FBR.generated_HUC = '''||as_huc||'''';
	  vH_WhereStmt:= vH_WhereStmt || ' AND FHR.generated_HUC = '''||as_huc||'''';

	END IF;
ELSIF geographic = 'LatLong' THEN
   -- Join Result Fact tables
    v_bio_flag := FALSE;
    v_result_flag := FALSE;
	IF MAX_LAT_DD = 90 AND MIN_LONG_DD = 180 AND MAX_LONG_DD = 0
	AND MIN_LAT_DD = 0 and dir_maxlat='NORTH'and dir_minlat='NORTH'
	and dir_maxlong='WEST' and dir_minlong='WEST'
	THEN
		--v_WhereStmt:= null;
            null;
	ELSE
		IF dir_maxlong = 'WEST' THEN
			v_maxlong := -1 * v_maxlong;
		END IF;
		IF dir_minlong = 'WEST' THEN
			v_minlong := -1 * v_minlong;
		END IF;
		IF dir_maxlat = 'SOUTH' THEN
			v_maxlat := -1 * v_maxlat;
		END IF;
		IF dir_minlat = 'SOUTH' THEN
			v_minlat := -1 * v_minlat;
		END IF;
		v_WhereStmt := v_WhereStmt || ' AND stn_latitude BETWEEN '||v_minlat||' AND '||v_maxlat||' AND
			stn_longitude BETWEEN '||v_minlong||' AND '||v_maxlong;
                vR_WhereStmt := vR_WhereStmt || ' AND FA.stn_latitude BETWEEN '||v_minlat||' AND '||v_maxlat||' AND
			FRR.stn_longitude BETWEEN '||v_minlong||' AND '||v_maxlong;
                vB_WhereStmt := vB_WhereStmt || ' AND FA.stn_latitude BETWEEN '||v_minlat||' AND '||v_maxlat||' AND
			FBR.stn_longitude BETWEEN '||v_minlong||' AND '||v_maxlong;
                vH_WhereStmt := vH_WhereStmt || ' AND FA.stn_latitude BETWEEN '||v_minlat||' AND '||v_maxlat||' AND
			FHR.stn_longitude BETWEEN '||v_minlong||' AND '||v_maxlong;
	END IF;
END IF;

--*********
--sug added station type list [STATION TYPE]
--Process station type list and add to WHERE statement if filtering
IF D_STYPE_LIST.LAST > 0 THEN
   -- Join Result Fact tables
    v_bio_flag := FALSE;
    v_result_flag := FALSE;
  IF D_STYPE_LIST(1) <> 'ALL' THEN
	FOR i IN 1 .. d_stype_list.LAST LOOP
		v_stype_list := v_stype_list||d_stype_list(i)||',';
--		SELECT primary_type||'-'||secondary_type INTO v_stype_name
		SELECT decode(secondary_type,null,primary_type,primary_type||'-'||secondary_type ) INTO v_stype_name
			FROM DI_STATN_TYPES
			WHERE PK_ISN = d_stype_list(i);
		v_stype_name_list := v_stype_name_list||v_stype_name||'<br>';
	END LOOP;
	v_stype_list := RTRIM(v_stype_list,',');
	v_WhereStmt := v_WhereStmt||' AND FA.fk_statn_types IN ('||v_stype_list||')';
        vR_WhereStmt := vR_WhereStmt||' AND FRR.fk_statn_types IN ('||v_stype_list||')';
        vB_WhereStmt := vB_WhereStmt||' AND FBR.fk_statn_types IN ('||v_stype_list||')';
        vH_WhereStmt := vH_WhereStmt||' AND FHR.fk_statn_types IN ('||v_stype_list||')';
  ELSE
	v_stype_name_list := 'ALL';
  END IF;
END IF;

--**********
--*
--TEST  WSheed summary
IF RESULT_TYPE ='ALLRESULTS' AND source_app = 'WATERSHED' THEN
  NULL;
ELSE
--Generate WHERE statement based on DATE ranges
   v_begin_date1 := TO_DATE(from_dd1||'-'||from_mon1||'-'||from_yyyy1,'DD-MON-YYYY');
   v_end_date1 := TO_DATE(end_dd1||'-'||end_mon1||'-'||end_yyyy1,'DD-MON-YYYY');
   IF v_begin_date1 = to_date('01-JAN-1900','DD-MON-YYYY') AND v_end_date1 = v_curr_date
     AND from_mon2 = 'DUMMY' AND end_mon2 = 'DUMMY'
     AND from_mon3 = 'DUMMY' AND end_mon3 = 'DUMMY'
     AND from_mon4 = 'DUMMY' AND end_mon4 = 'DUMMY' THEN
       null;
   ELSE
-- Join Result Fact tables
    v_result_flag := TRUE;
      get_date_isn(v_begin_date1,v_end_date1);
	--v_WhereStmt := v_WhereStmt||' AND (fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
        vR_WhereStmt := vR_WhereStmt||' AND (fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
        vB_WhereStmt := vB_WhereStmt||' AND (fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
        vH_WhereStmt := vH_WhereStmt||' AND (fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
	v_date_flag := TRUE;
   END IF;

  IF from_mon2 <> 'DUMMY' AND end_mon2 <> 'DUMMY' THEN
-- Join Result Fact tables
    v_result_flag := TRUE;
	v_begin_date2 := TO_DATE(from_dd2||'-'||from_mon2||'-'||from_yyyy2,'DD-MON-YYYY');
	v_end_date2 := TO_DATE(end_dd2||'-'||end_mon2||'-'||end_yyyy2,'DD-MON-YYYY');
	get_date_isn(v_begin_date2,v_end_date2);
	--v_WhereStmt := v_WhereStmt||' OR fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
        vR_WhereStmt := vR_WhereStmt||' OR fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
        vB_WhereStmt := vB_WhereStmt||' OR fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
        vH_WhereStmt := vH_WhereStmt||' OR fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
  END IF;

  IF from_mon3 <> 'DUMMY' AND end_mon3 <> 'DUMMY' THEN
-- Join Result Fact tables
    v_result_flag := TRUE;
	v_begin_date3 := TO_DATE(from_dd3||'-'||from_mon3||'-'||from_yyyy3,'DD-MON-YYYY');
	v_end_date3 := TO_DATE(end_dd3||'-'||end_mon3||'-'||end_yyyy3,'DD-MON-YYYY');
	get_date_isn(v_begin_date3,v_end_date3);
	--v_WhereStmt := v_WhereStmt||' OR fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
        vR_WhereStmt := vR_WhereStmt||' OR fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
        vB_WhereStmt := vB_WhereStmt||' OR fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
        vH_WhereStmt := vH_WhereStmt||' OR fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
  END IF;

  IF from_mon4 <> 'DUMMY' AND end_mon4 <> 'DUMMY' THEN
-- Join Result Fact tables
    v_result_flag := TRUE;
	v_begin_date4 := TO_DATE(from_dd4||'-'||from_mon4||'-'||from_yyyy4,'DD-MON-YYYY');
	v_end_date4 := TO_DATE(end_dd4||'-'||end_mon4||'-'||end_yyyy4,'DD-MON-YYYY');
	get_date_isn(v_begin_date4,v_end_date4);
	--v_WhereStmt := v_WhereStmt||' OR fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
        vR_WhereStmt := vR_WhereStmt||' OR fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
        vB_WhereStmt := vB_WhereStmt||' OR fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
        vH_WhereStmt := vH_WhereStmt||' OR fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
  END IF;
END IF;

IF v_date_flag = TRUE THEN
-- Join Result Fact tables
    v_result_flag := TRUE;
	--v_WhereStmt := v_WhereStmt||')';
        vR_WhereStmt := vR_WhereStmt||')';
        vB_WhereStmt := vB_WhereStmt||')';
        vH_WhereStmt := vH_WhereStmt||')';
END IF;

--end if;

--Process characteristic list and add to WHERE statement if filtering. Loop starts at 2 to
--ignore dummy value that is passed. Dummy is used to maintain column width.
IF char_list.LAST > 1 THEN
	FOR i IN 2 .. char_list.LAST LOOP
		v_char_list := v_char_list||char_list(i)||',';
	END LOOP;
-- Join Result Fact tables
    v_result_flag := FALSE;
	v_char_list := RTRIM(v_char_list,',');
	v_FromStmt := v_FromStmt||',STATION_CHAR';
	v_WhereStmt := v_WhereStmt||' AND fk_fa_statn = FA.pk_isn AND fk_char IN ('||v_char_list||')';
	--v_WhereStmt := v_WhereStmt||' AND fk_char IN ('||v_char_list||')';-- commented for CR-25
        vR_WhereStmt := vR_WhereStmt||' AND fk_char IN ('||v_char_list||')';
        vB_WhereStmt := vB_WhereStmt||' AND fk_char IN ('||v_char_list||')';
        vH_WhereStmt := vH_WhereStmt||' AND fk_char IN ('||v_char_list||')';
-- Join STATION_CHAR tables
	v_Char_Flag := TRUE;
END IF;


IF D_ORG_LIST <> 0 AND D_PROJ_LIST = 0 AND (station_list.LAST <= 1 OR station_list.count = 0)THEN
	V_ORG_LIST := D_ORG_LIST;
	SELECT organization_id INTO v_org_id
			FROM DI_ORG
			WHERE PK_ISN = d_org_list;
	v_org_id_list := v_org_id_list||v_org_id||'<br>';
	v_WhereStmt := v_WhereStmt||' AND fk_org IN ('||v_org_list||')';

	--WShed Summary
	 -- IF result_type = 'ALLRESULTS'  THEN
	  vR_WhereStmt := vR_WhereStmt||' AND FRR.fk_org IN ('||v_org_list||')';
		vB_WhereStmt := vB_WhereStmt||' AND FBR.fk_org IN ('||v_org_list||')';
		vH_WhereStmt := vH_WhereStmt||' AND FHR.fk_org IN ('||v_org_list||')';
	  --END IF;
END IF;

-- pre-National Project logic

IF D_PROJ_LIST <> 0 THEN
-- National and Non-National Projects flow through same logic.
-- Join Result Fact tables
    v_result_flag := TRUE;
		v_proj_list := '';
	IF D_ORG_LIST <= -1 THEN
		FOR nat_proj IN nat_proj_list LOOP
       		v_proj_list := v_proj_list||','||nat_proj.pk_isn;
			v_org_id_list := v_org_id_list||nat_proj.organization_id||'<br>';
		END LOOP;
	ELSE
		FOR nat_proj IN proj_list LOOP
        		v_proj_list := v_proj_list||','||nat_proj.pk_isn;
			v_org_id_list := v_org_id_list||nat_proj.organization_id||'<br>';
		END LOOP;
	END IF;
		v_proj_list := ltrim(v_proj_list,',');

-- National and Non-National Projects should have only 1 project code.  Value as_proj carries in
-- project name 'National Project' for national projects.  Variable proj_cd replaces as_proj with project code
-- concatenated with Project name.
		select project_name into proj_nm from di_project where pk_isn = D_PROJ_LIST;
		if instr(v_proj_list,',') <> 0 then proj_nm := 'National Project (e.g., '||proj_nm||')'; end if;
		select project_cd into proj_cd from di_project where pk_isn = D_PROJ_LIST;
		proj_cd := proj_cd||' - '||proj_nm;



		--IF result_type = 'REGULAR' THEN
    vR_FromStmt := vR_FromStmt||',REGULAR_RESULT_PROJECT';
		--END IF;
		--IF result_type = 'BIOLOGICAL' THEN
		vB_FromStmt := vB_FromStmt||',BIOLOGICAL_RESULT_PROJECT';
		--END IF;
		--IF result_type = 'HABITAT' THEN
		vH_FromStmt := vH_FromStmt||',HABITAT_RESULT_PROJECT';
		--END IF;

	--v_WhereStmt := v_WhereStmt||' AND fk_result = FA.pk_isn AND fk_project in('||v_proj_list||')';
          vR_WhereStmt := vR_WhereStmt||' AND fk_result = FRR.pk_isn AND fk_project in('||v_proj_list||')';
          vB_WhereStmt := vB_WhereStmt||' AND fk_result = FBR.pk_isn AND fk_project in('||v_proj_list||')';
          vH_WhereStmt := vH_WhereStmt||' AND fk_result = FHR.pk_isn AND fk_project in('||v_proj_list||')';
-- pre-National Project logic
--  	v_WhereStmt := v_WhereStmt||' AND fk_result = FA.pk_isn AND fk_project = ' ||v_proj_list;

	v_rule_optimization := 'TRUE';
--	v_SelectStmt := 'SELECT /*+ RULE*/ count(FA.pk_isn) INTO :ResultCount';
	v_SelectStmt := 'SELECT count(FA.pk_isn) INTO :StationCount';
END IF;

--Process Station list and add to WHERE statement if filtering. Loop starts at 2 to
--ignore dummy value that is passed. Dummy is used to maintain column width.
IF station_list.LAST > 1 THEN
	FOR i IN 2 .. station_list.LAST LOOP
		v_station_list := v_station_list||station_list(i)||',';
	END LOOP;
	v_station_list := RTRIM(v_station_list,',');
	v_WhereStmt := v_WhereStmt||' AND fk_station IN ('||v_station_list||')';
        vR_WhereStmt := vR_WhereStmt||' AND fk_station IN ('||v_station_list||')';
        vB_WhereStmt := vB_WhereStmt||' AND fk_station IN ('||v_station_list||')';
        vH_WhereStmt := vH_WhereStmt||' AND fk_station IN ('||v_station_list||')';
END IF;

--Process Intent list and add to WHERE statement if filtering.
IF d_intent_list.LAST > 0 THEN
  IF d_intent_list(1) <> 'ALL' THEN
-- Biological ONLY Result Fact tables: stations
    v_bio_flag := TRUE;
-- Join Result Fact tables
    v_result_flag := FALSE;
	FOR i IN 1 .. d_intent_list.LAST LOOP
		v_intent_isn_list := v_intent_isn_list||d_intent_list(i)||',';
            SELECT activity_intent INTO v_intent
            FROM di_activity_intent
            WHERE pk_isn = d_intent_list(i);
            v_intent_list := v_intent_list ||v_intent||'<br>';
            IF v_intent = 'Taxon Abundance' THEN    -- activity intent = taxon abundance
               v_taxon := TRUE;
            END IF;
	END LOOP;
	v_intent_isn_list := RTRIM(v_intent_isn_list,',');
	--v_WhereStmt := v_WhereStmt||' AND fk_act_intent IN ('||v_intent_isn_list||')';
        --vR_WhereStmt := vR_WhereStmt||' AND fk_act_intent IN ('||v_intent_isn_list||')';
        vB_WhereStmt := vB_WhereStmt||' AND fk_act_intent IN ('||v_intent_isn_list||')';
        --vH_WhereStmt := vH_WhereStmt||' AND fk_act_intent IN ('||v_intent_isn_list||')';
  ELSE
	v_intent_list := 'ALL';
      v_taxon := TRUE;
  END IF;
END IF;

--Process Community list and add to WHERE statement if filtering.
IF d_community_list.LAST > 0 THEN
  IF d_community_list(1) <> 'ALL' THEN
-- Biological ONLY Result Fact tables: stations
    v_bio_flag := TRUE;
-- Join Result Fact tables
    v_result_flag := FALSE;
  	FOR i IN 1 .. d_community_list.LAST LOOP
		v_community_isn_list := v_community_isn_list||d_community_list(i)||',';
            SELECT activity_community INTO v_community
            FROM di_community_sampled
            WHERE pk_isn = d_community_list(i);
            v_community_list := v_community_list ||v_community||'<br>';
	END LOOP;
	v_community_isn_list := RTRIM(v_community_isn_list,',');
	--v_WhereStmt := v_WhereStmt||' AND (fk_community_sampled IN ('||v_community_isn_list||') OR fk_community_sampled IS NULL)';
        --vR_WhereStmt := vR_WhereStmt||' AND (fk_community_sampled IN ('||v_community_isn_list||') OR fk_community_sampled IS NULL)';
        vB_WhereStmt := vB_WhereStmt||' AND (fk_community_sampled IN ('||v_community_isn_list||') OR fk_community_sampled IS NULL)';
        --vH_WhereStmt := vH_WhereStmt||' AND (fk_community_sampled IN ('||v_community_isn_list||') OR fk_community_sampled IS NULL)';
  ELSE
	v_community_list := 'ALL';
  END IF;
END IF;

--Process medium list and add to WHERE statement if filtering.
IF d_medium_list.LAST > 0 THEN
  IF d_medium_list(1) <> 'ALL' THEN
-- Biological ONLY Result Fact tables: stations
--    v_bio_flag := FALSE;
-- Join Result Fact tables
    v_result_flag := FALSE;
	FOR i IN 1 .. d_medium_list.LAST LOOP
		v_medium_isn_list := v_medium_isn_list||d_medium_list(i)||',';
            SELECT activity_medium INTO v_medium
            FROM di_activity_medium
            WHERE pk_isn = d_medium_list(i);
            v_medium_list := v_medium_list ||v_medium||'<br>';
	END LOOP;
	v_medium_isn_list := RTRIM(v_medium_isn_list,',');
IF v_char_flag THEN
	v_WhereStmt := v_WhereStmt||' AND fk_act_medium IN ('||v_medium_isn_list||')';
	v_FromStmt := v_FromStmt;
ELSE
	v_WhereStmt := v_WhereStmt||' AND fk_fa_statn = FA.pk_isn AND fk_act_medium IN ('||v_medium_isn_list||')';
	v_FromStmt := v_FromStmt||',STATION_CHAR';
END IF;
	--v_WhereStmt := v_WhereStmt||' AND fk_act_medium IN ('||v_medium_isn_list||')';
        vR_WhereStmt := vR_WhereStmt||' AND fk_act_medium IN ('||v_medium_isn_list||')';
        vB_WhereStmt := vB_WhereStmt||' AND fk_act_medium IN ('||v_medium_isn_list||')';
        --vH_WhereStmt := vH_WhereStmt||' AND fk_act_medium IN ('||v_medium_isn_list||')';
  ELSE
	v_medium_list := 'ALL';
  END IF;
END IF;

--process chartype_list
  --WShed Summary
	  IF result_type = 'ALLRESULTS'  AND source_app = 'WATERSHED' and in_chartype_list <> 'ALL' THEN
	  vR_WhereStmt:= vR_WhereStmt || ' AND exists (select 1 from characteristic_chartype cct, lu_chartype ct '
	  	||' where ct.pk_isn = cct.fk_chartype '
		||' and cct.fk_characteristic = FRR.fk_char '
		||' and ct.pk_isn in ('||in_chartype_list||'))';

	  vB_WhereStmt:= vB_WhereStmt || ' AND exists (select 1 from characteristic_chartype cct, lu_chartype ct '
	  	||' where ct.pk_isn = cct.fk_chartype '
		||' and cct.fk_characteristic = FBR.fk_char '
		||' and ct.pk_isn in ('||in_chartype_list||'))';

	  vH_WhereStmt:= vH_WhereStmt || ' AND exists (select 1 from characteristic_chartype cct, lu_chartype ct '
	  	||' where ct.pk_isn = cct.fk_chartype '
		||' and cct.fk_characteristic = FHR.fk_char '
		||' and ct.pk_isn in ('||in_chartype_list||'))';

	  END IF;

--Assemble sql statement
--v_SQLStmt := 'BEGIN '||v_SelectStmt||' '||v_FromStmt||' '||v_WhereStmt||' AND sd.location_point_type = ''*POINT OF RECORD'';END;';
--v_SQLStmt := 'BEGIN '||v_SelectStmt||' '||v_FromStmt||' '||v_WhereStmt||';END;';

--WShed Summary
     v_SQLStmt := 'BEGIN '||v_SelectStmt||' '||v_FromStmt||' '||v_WhereStmt||' ;END;';
     vR_SQLStmt := 'BEGIN '||' END;';
     vB_SQLStmt := 'BEGIN '||' END;';
     vH_SQLStmt := 'BEGIN '||' END;';
IF v_bio_flag  THEN
v_SQLStmt := 'BEGIN '||vB_SelectStmt||' '||vB_FromStmt||' '||vB_WhereStmt||';END;';
vR_SQLStmt := 'BEGIN '||' END;';
vB_SQLStmt := 'BEGIN '||vB_SelectStmt||' '||vB_FromStmt||' '||vB_WhereStmt||';END;';
vH_SQLStmt := 'BEGIN '||' END;';
END IF;
IF v_date_flag = TRUE THEN
-- Join Result Fact tables
    v_result_flag := TRUE;
END IF;
IF v_result_flag  THEN
--v_SQLStmt := 'BEGIN '||v_SelectStmt||' '||v_FromStmt||' '||v_WhereStmt||';END;';
--vR_SQLStmt := 'BEGIN '||vR_SelectStmt||' '||vR_FromStmt||' '||vR_WhereStmt||';END;';
--vB_SQLStmt := 'BEGIN '||vB_SelectStmt||' '||vB_FromStmt||' '||vB_WhereStmt||';END;';
--vH_SQLStmt := 'BEGIN '||vH_SelectStmt||' '||vH_FromStmt||' '||vH_WhereStmt||';END;';
v_SQLStmt :=  'BEGIN Select count(1) INTO :StationCount From ( ('||vR_SelectStmt||' '||vR_FromStmt||' '||vR_WhereStmt||') UNION '||
                   ' ('||vB_SelectStmt||' '||vB_FromStmt||' '||vB_WhereStmt||') UNION '||
                   ' ('||vH_SelectStmt||' '||vH_FromStmt||' '||vH_WhereStmt||') );END;';
vR_SQLStmt := 'BEGIN ('||vR_SelectStmt||' '||vR_FromStmt||' '||vR_WhereStmt||') END;';
vB_SQLStmt := 'BEGIN ('||vB_SelectStmt||' '||vB_FromStmt||' '||vB_WhereStmt||') END;';
vH_SQLStmt := 'BEGIN ('||vH_SelectStmt||' '||vH_FromStmt||' '||vH_WhereStmt||') END;';
END IF;


/*
--WShed Summary
--IF result_type = 'ALLRESULTS' THEN
-- REGULAR RESULTS COUNT
IF v_intent_list = 'ALL' and v_community_list = 'ALL' THEN
v_CursorID := DBMS_SQL.OPEN_CURSOR;
DBMS_SQL.PARSE(v_CursorID, vR_SQLStmt, DBMS_SQL.NATIVE);
DBMS_SQL.BIND_VARIABLE(v_CursorID, ':ResultCount', vR_ResultCount);
v_Dummy := DBMS_SQL.EXECUTE(v_CursorID);
DBMS_SQL.VARIABLE_VALUE(v_CursorID, ':ResultCount', vR_ResultCount);
DBMS_SQL.CLOSE_CURSOR(v_CursorID);

--BIO RESULTS COUNT
v_CursorID := DBMS_SQL.OPEN_CURSOR;
DBMS_SQL.PARSE(v_CursorID, vB_SQLStmt, DBMS_SQL.NATIVE);
DBMS_SQL.BIND_VARIABLE(v_CursorID, ':ResultCount', vB_ResultCount);
v_Dummy := DBMS_SQL.EXECUTE(v_CursorID);
DBMS_SQL.VARIABLE_VALUE(v_CursorID, ':ResultCount', vB_ResultCount);
DBMS_SQL.CLOSE_CURSOR(v_CursorID);

--HAB RESULT COUNT

v_CursorID := DBMS_SQL.OPEN_CURSOR;
DBMS_SQL.PARSE(v_CursorID, vH_SQLStmt, DBMS_SQL.NATIVE);
DBMS_SQL.BIND_VARIABLE(v_CursorID, ':ResultCount', vH_ResultCount);
v_Dummy := DBMS_SQL.EXECUTE(v_CursorID);
DBMS_SQL.VARIABLE_VALUE(v_CursorID, ':ResultCount', vH_ResultCount);
DBMS_SQL.CLOSE_CURSOR(v_CursorID);
end if;

if v_intent_list != 'ALL' or v_community_list != 'ALL' THEN
v_CursorID := DBMS_SQL.OPEN_CURSOR;
DBMS_SQL.PARSE(v_CursorID, vB_SQLStmt, DBMS_SQL.NATIVE);
DBMS_SQL.BIND_VARIABLE(v_CursorID, ':ResultCount', vB_ResultCount);
v_Dummy := DBMS_SQL.EXECUTE(v_CursorID);
DBMS_SQL.VARIABLE_VALUE(v_CursorID, ':ResultCount', vB_ResultCount);
DBMS_SQL.CLOSE_CURSOR(v_CursorID);
end if;
*/

/*
if v_intent_list <> 'ALL' or v_community_list <> 'ALL' THEN
v_ResultCount:=vB_ResultCount;
else
v_ResultCount:= (vR_ResultCount+vB_ResultCount+vH_ResultCount);
end if;
--identify the minimum count
--
vmin_ResultCount := 0;
if vr_resultcount > 0 then
vmin_ResultCount := vr_resultcount;
report_Type:='REGULAR';
end if;

if vb_resultcount > 0 then
  if ((vmin_ResultCount > vb_resultcount) or (vmin_ResultCount = 0)) then
    vmin_ResultCount:= vb_resultcount;
    report_Type:='BIOLOGICAL';
     end if;
end if;

if vh_resultcount > 0 then
  if ((vmin_ResultCount > vh_resultcount) or (vmin_ResultCount = 0)) then
    vmin_ResultCount:= vh_resultcount;
    report_Type:='HABITAT';
    end if;
end if;
*/

--/*else
--Process SQL statement and capture count value
--v_SQLStmt := 'BEGIN SELECT count(distinct(FA.pk_isn)) INTO :StationCount FROM FA_STATION FA Where FA.fk_geo_state = 5 AND FA.location_point_type = '||''''||'*POINT OF RECORD'||''''||' ;END;';
v_CursorID := DBMS_SQL.OPEN_CURSOR;
DBMS_SQL.PARSE(v_CursorID, v_SQLStmt, DBMS_SQL.NATIVE);
DBMS_SQL.BIND_VARIABLE(v_CursorID, ':StationCount', v_StationCount);
v_Dummy := DBMS_SQL.EXECUTE(v_CursorID);
DBMS_SQL.VARIABLE_VALUE(v_CursorID, ':StationCount', v_StationCount);
DBMS_SQL.CLOSE_CURSOR(v_CursorID);
--END IF;
--*/


--Generate HTML page

DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path);

-- 2010-09-01 Header for Search Parameter Values
v_parameters:=v_parameters||'Query Parameter Values: '||chr(10);

htp.print('<br><center><h4>Number of Stations Returned: '||TO_CHAR(v_StationCount,'999,999,999')||'</h4></center>');
--htp.print('<center>(Regular: '||TO_CHAR(vR_ResultCount,'999,999,999')||'; Biological: '||TO_CHAR(vB_ResultCount,'999,999,999')||'; Habitat: '||TO_CHAR(vH_ResultCount,'999,999,999')||
--      ')</center><table cols=1 border=1 width=500 align="CENTER"><tr><td><table cols=2 width="100%" cellspacing=10>');
if (v_StationCount < dw_glob_var.gv_rslt_Overnight_lmt AND v_ResultCount > 0) then
--htp.print('<br><form name=formz action="DW_result_hub_custom" method=POST>');
    htp.print('<br> <form name=formz action="DW_station_hub_custom" method=POST>
    <input type="hidden" name="v_FromStmt" value="'||v_FromStmt||'">
    <input type="hidden" name="v_WhereStmt" value="'||v_WhereStmt||'">
    <input type="hidden" name="v_StationCount" value="'||v_StationCount||'">
    <input type="hidden" name="v_filters" value="'||v_filters||'">
    <input type="hidden" name="v_mode" value="Online">');
htp.print('<table width=650 cols=1 border=1 align="center"><tr><td><table cols=3 cellspacing="10"
align="center">
<tr><td colspan=3><b><center>Select Report Type(s)</center></b></td></tr>
<tr>');
 if (vR_ResultCount > 0 and v_intent_list ='ALL' and v_community_list = 'ALL')then
      htp.print('<td><input type="checkbox" name="r_Type" value="REGULAR" CHECKED > REGULAR
('||vR_ResultCount||' record(s))</input></td>');

    else
      htp.print('<td><input type="checkbox" name="r_Type" value="REGULAR" disabled="disabled"> REGULAR(
'||vR_ResultCount||' record(s)) </input></td>');
     end if;
    if (vB_ResultCount > 0 or v_intent_list <>'ALL' or v_community_list <> 'ALL')then
      htp.print('<td><input type="checkbox" name="r_Type" value="BIOLOGICAL" CHECKED > BIOLOGICAL
('||vB_ResultCount||' record(s))</input></td>');

    else
      htp.print('<td><input type="checkbox" name="r_Type" value="BIOLOGICAL" disabled="disabled"> BIOLOGICAL
('||vB_ResultCount||' record(s))</input></td>');

    end if;
    if (vH_ResultCount > 0 and v_intent_list ='ALL' and v_community_list = 'ALL')then
      htp.print('<td><input type="checkbox" name="r_Type" value="HABITAT" CHECKED > HABITAT
('||vH_ResultCount||' record(s))</input></td>');

    else
      htp.print('<td><input type="checkbox" name="r_Type" value="HABITAT" disabled="disabled"> HABITAT
('||vH_ResultCount||' record(s))
      </input></td>');
    end if;
    end if;
 htp.print('</tr>
 <tr><td colspan=3></td></tr> </table></tr></td></table>');



htp.print('<table cols=1 border=1 width=500 align="CENTER"><tr><td><table cols=2 width="100%" cellspacing=10>');
htp.print( '<tr><td colspan=2 align="center"><b>Search Criteria</b></td></tr>' );

--Display geographic search parameters based on the selected search option
IF geographic = 'StateCounty' THEN
	IF as_state <> 0 THEN
	  v_filters:=v_filters||'~'||'State';
	  v_parameters:=v_parameters||'State: '||chr(9)||v_StateName||chr(10);
		IF v_County_Code <> 'ALL' THEN
  	   	  v_filters:=v_filters||'~'||'County';
  	   	  v_parameters:=v_parameters||'County: '||chr(9)||as_county||chr(10);
			htp.print( '<tr><td width="50%" align="right"><b>State: </td><td> '||v_StateName||'</b></td></tr>' );
			htp.print( '<tr><td align="right"><b>County: </td><td> '||as_county||'</b></td></tr>' );
		ELSE
			htp.print( '<tr><td width="50%" align="right"><b>State: </td><td> '||v_StateName||'</b></td></tr>' );
			htp.print( '<tr><td align="right"><b>County: </td><td> ALL</b></td></tr>' );
		END IF;
	ELSE
		htp.print( '<tr><td width="50%" align="right"><b>State: </td><td> ALL</b></td></tr>' );
		htp.print( '<tr><td align="right"><b>County: </td><td> ALL</b></td></tr>' );
	END IF;
ELSIF geographic = 'HUC' THEN
	IF as_huc IS NOT NULL THEN
           IF as_huc <> 'ALL' THEN
	       v_filters:=v_filters||'~'||'HUC';
	       v_parameters:=v_parameters||'HUC: '||chr(9)||as_huc||chr(10);
           END IF;
		htp.print( '<tr><td width="50%" align="right"><b>HUC: </td><td> '||as_huc||'</b></td></tr>' );
	ELSE
		htp.print( '<tr><td width="50%" align="right"><b>HUC: </td><td> ALL</b></td></tr>' );
	END IF;
ELSIF geographic = 'LatLong' THEN
	IF MAX_LAT_DD = 90 AND MIN_LONG_DD = -180 AND MAX_LONG_DD = 0 AND MIN_LAT_DD = 0 THEN
		htp.print( '<tr><td width="50%" align="right"><b>Latitude/Longitude: </td><td> ALL</b></td></tr>' );
	ELSE
/**
		htp.print( '<tr><td width="50%" align="right"><b>MIN Latitude: </td><td> '||MIN_LAT_DD||' '||dir_minlat||'</b></td></tr>' );
		htp.print( '<tr><td width="50%" align="right"><b>MAX Latitude: </td><td> '||MAX_LAT_DD||' '||dir_maxlat||'</b></td></tr>' );
		htp.print( '<tr><td width="50%" align="right"><b>MIN Longitude: </td><td> '||MIN_LONG_DD||' '||dir_minlong||'</b></td></tr>' );
		htp.print( '<tr><td width="50%" align="right"><b>MAX Longitude: </td><td> '||MAX_LONG_DD||' '||dir_maxlong||'</b></td></tr>' );
**/
   	   v_parameters:=v_parameters||'Latitude/Longitude: '||chr(10);
   	   v_parameters:=v_parameters||'North Limit: '||chr(9)||MAX_LAT_DD||' '||dir_maxlat||chr(10);
   	   v_parameters:=v_parameters||'South Limit: '||chr(9)||MIN_LAT_DD||' '||dir_minlat||chr(10);
   	   v_parameters:=v_parameters||'East Limit: '||chr(9)||MAX_LONG_DD||' '||dir_maxlong||chr(10);
   	   v_parameters:=v_parameters||'West Limit: '||chr(9)||MIN_LONG_DD||' '||dir_minlong||chr(10);
		htp.print( '<tr><td width="50%" align="right"><b>North Limit: </td><td> '||MAX_LAT_DD||' '||dir_maxlat||'</b></td></tr>' );
		htp.print( '<tr><td width="50%" align="right"><b>South Limit: </td><td> '||MIN_LAT_DD||' '||dir_minlat||'</b></td></tr>' );
		htp.print( '<tr><td width="50%" align="right"><b>East Limit: </td><td> '||MAX_LONG_DD||' '||dir_maxlong||'</b></td></tr>' );
		htp.print( '<tr><td width="50%" align="right"><b>West Limit: </td><td> '||MIN_LONG_DD||' '||dir_minlong||'</b></td></tr>' );

	END IF;
	IF MAX_LAT_DD = 90 AND MIN_LONG_DD = 180 AND MAX_LONG_DD = 0 AND MIN_LAT_DD = 0
 	 and dir_maxlat='NORTH'and dir_minlat='NORTH' and dir_maxlong='WEST' and dir_minlong='WEST'
	THEN
	  null;
	else
	  v_filters:=v_filters||'~'||'LatLong';
	end if;
END IF;

--htp.print( '<tr><td align="right" valign="top"><b>Station Type(s): </td><td> '||v_STYPE_Name_LIST||'</b></td></tr>' );

--sug added the station type filter [STATION TYPE]
--htp.print( '<tr><td width="50%" align="right" valign="top"><b>Station Type(s): </td><td> '||v_STYPE_Name_LIST||'</b></td></tr>' );

if v_STYPE_Name_LIST is null then
  null;
elsif v_STYPE_Name_LIST = 'ALL' THEN
htp.print( '<tr><td width="50%" align="right" valign="top"><b>Station Type(s): </td><td> '||v_STYPE_Name_LIST||'</b></td></tr>' );
  NULL;
ELSE
  v_filters:=v_filters||'~'||'StationType';
  v_parameters:=v_parameters||'StationType: '||chr(9)||v_STYPE_Name_LIST||chr(10);
  htp.print( '<tr><td width="50%" align="right" valign="top"><b>Station Type(s): </td><td> '||v_STYPE_Name_LIST||'</b></td></tr>' );

end if;
--*****


IF v_org_id_list IS NOT NULL THEN
	  v_filters:=v_filters||'~'||'Organization';
	  v_parameters:=v_parameters||'Organization(s): '||chr(9)||v_org_id_list||chr(10);
	htp.print( '<tr><td width="50%" align="right" valign="top"><b>Organization: </td><td> '||v_org_id_list||'</b></td></tr>');
END IF;

--IF v_proj_id_list IS NOT NULL THEN
IF v_proj_list IS NOT NULL THEN
	  v_filters:=v_filters||'~'||'Project';
	  v_parameters:=v_parameters||'Project(s): '||chr(9)||proj_cd||chr(10);
--	htp.print( '<tr><td align="right" valign="top"><b>Project: </td><td> '||as_proj||'</b></td></tr>');
	htp.print( '<tr><td align="right" valign="top"><b>Project: </td><td> '||proj_cd||'</b></td></tr>');
END IF;

IF TRIM(v_station_names) IS NOT NULL THEN
	 v_filters:=v_filters||'~'||'Organization';
	 v_filters:=v_filters||'~'||'Stations';
	 v_parameters:=v_parameters||'Organization/Stations: '||chr(10);
	 v_parameters:=v_parameters||'Station(s): '||chr(9)||v_station_names||chr(10);
  htp.print( '<tr><td width="50%" align="right" valign="top"><b>Station(s): </td><td> '||v_station_names||'</b></td></tr>');
END IF;

IF v_date_flag <> TRUE THEN
   IF result_type = 'ALLRESULTS' AND source_app = 'WATERSHED' THEN
     null;
   ELSE
	htp.print( '<tr><td width="50%" align="right" valign="top"><b>Activity Start Dates: </td><td> ALL</b></td></tr>');
   END IF;
ELSE
	 v_filters:=v_filters||'~'||'Act_StartDate';
	 v_parameters:=v_parameters||'Activity Start Date(s): '||chr(9)||to_char(v_begin_date1,'DD-MON-YYYY')||' to '||to_char(v_end_date1,'DD-MON-YYYY')||chr(10);
  	htp.print( '<tr><td width="50%" align="right" valign="top"><b>Activity Start Dates: </td><td> '||to_char(v_begin_date1,'DD-MON-YYYY')||' to '||to_char(v_end_date1,'DD-MON-YYYY')||'</b>');
  	IF v_begin_date2 IS NOT NULL THEN
	 v_parameters:=v_parameters||'                        '||chr(9)||to_char(v_begin_date2,'DD-MON-YYYY')||' to '||to_char(v_end_date2,'DD-MON-YYYY')||chr(10);
	  	htp.print('<BR>'|| to_char(v_begin_date2,'DD-MON-YYYY')||' to '||to_char(v_end_date2,'DD-MON-YYYY'));
  	END IF;
  	IF v_begin_date3 IS NOT NULL THEN
	 v_parameters:=v_parameters||'                        '||chr(9)||to_char(v_begin_date3,'DD-MON-YYYY')||' to '||to_char(v_end_date3,'DD-MON-YYYY')||chr(10);
	  	htp.print('<BR>'|| to_char(v_begin_date3,'DD-MON-YYYY')||' to '||to_char(v_end_date3,'DD-MON-YYYY'));
 	 END IF;
  	IF v_begin_date4 IS NOT NULL THEN
	 v_parameters:=v_parameters||'                        '||chr(9)||to_char(v_begin_date4,'DD-MON-YYYY')||' to '||to_char(v_end_date4,'DD-MON-YYYY')||chr(10);
	  	htp.print('<BR>'|| to_char(v_begin_date4,'DD-MON-YYYY')||' to '||to_char(v_end_date4,'DD-MON-YYYY'));
  	END IF;
	htp.print('</td></tr>');
END IF;

IF result_type = 'ALLRESULTS' AND source_app <> 'WATERSHED' THEN

--IF result_type = 'BIOLOGICAL' THEN
  htp.print( '<tr><td align="right" valign="top"><b>Intent(s): </td><td> '||v_intent_list||'</b></td></tr>');
       if v_intent_list = 'ALL' then
         null;
       else
	 v_filters:=v_filters||'~'||'Act_Intent';
	 v_parameters:=v_parameters||'Activity Intent: '||chr(9)||v_intent_list||chr(10);
       end if;

  IF v_taxon = TRUE THEN
       if v_community_list = 'ALL' then
         null;
       else
	 v_filters:=v_filters||'~'||'CommunitySampled';
	 v_parameters:=v_parameters||'Community Sampled: '||chr(9)||v_community_list||chr(10);
       end if;
    htp.print( '<tr><td align="right" valign="top"><b>Community Sampled: </td><td> '||v_community_list||'</b></td></tr>');
  END IF;
--END IF;

--IF result_type = 'REGULAR' THEN
  htp.print( '<tr><td align="right" valign="top"><b>Medium: </td><td> '||v_medium_list||'</b></td></tr>');
    IF v_medium_list = 'ALL' THEN
      NULL;
    ELSE
	 v_filters:=v_filters||'~'||'Act_Medium';
	 v_parameters:=v_parameters||'Activity Medium: '||chr(9)||v_medium_list||chr(10);
    END IF;
END IF;

IF TRIM(v_char_names) IS NULL THEN
  IF result_type = 'ALLRESULTS' AND source_app = 'WATERSHED' THEN
    NULL;
  ELSE
    htp.print( '<tr><td align="right" valign="top"><b>Characteristic(s): </td><td> ALL</b></td></tr>');
  END IF;
ELSE
  htp.print( '<tr><td align="right" valign="top"><b>Characteristic(s): </td><td> '||v_char_names||'</b></td></tr>');
  v_filters:=v_filters||'~'||'Characteristic';
  v_parameters:=v_parameters||'Characteristic(s): '||chr(9)||v_char_names||chr(10);
END IF;

IF result_type = 'ALLRESULTS'  AND source_app = 'WATERSHED' and in_chartype_names <> 'ALL' THEN
  htp.print( '<tr><td align="right" valign="top"><b>Characteristic Type(s): </td><td> '||in_chartype_names||'</b></td></tr>');
  v_filters:=v_filters||'~'||'Chartype';
  v_parameters:=v_parameters||'Characteristic Type(s): '||chr(9)||in_chartype_names||chr(10);
--v_filters:=v_filters||'~'||'Characteristic';
END IF;

--2010-09-01 Assign Variable for Email Message Body
v_filters:=v_filters||'~'||chr(10)||v_parameters;
--
--following are added for debug/development
htp.print('<tr><td width="50%" align="right" valign="top">Station SQL: '||v_SQLStmt||'</td></tr>' );
htp.print('<tr><td width="50%" align="right" valign="top">FRR SQL: '||vR_SQLStmt||'</td></tr>' );
htp.print('<tr><td width="50%" align="right" valign="top">FBR SQL: '||vB_SQLStmt||'</td></tr>' );
htp.print('<tr><td width="50%" align="right" valign="top">FHR SQL: '||vH_SQLStmt||'</td></tr>' );
--end of debug/develop
htp.print('</table></td></tr></table>');
--htp.print( '<br><br><b>'||v_SQLStmt||'<br><br></b>');
--Display report choices and report column select boxes

--following are added for debug/development
htp.print('v_SQLStmt: '||v_SQLStmt);
--htp.print('r_resultcount '||vr_resultcount);
--htp.print('b_resultcount '||vb_resultcount);
--htp.print('h_resultcount '||vh_resultcount);
--htp.print('min_resultcount '||vmin_resultcount);
--htp.print( '<tr><td width="50%" align="right" valign="top"><b>Station Type(s): </td><td> '||v_STYPE_Name_LIST||'</b></td></tr>' );
--end of debug/develop

--Display report choices and report column select boxes
IF v_StationCount = 0 THEN
	htp.print('<br><center> No Stations match your search criteria. Please select ''Back'' to modify your search.
	<form><input type="button" value="  <<Back  " width=40 onClick=Close_Onclick();></form></center>
');
ELSIF v_StationCount > dw_glob_var.gv_stn_Overnight_lmt THEN
	htp.print('<br><center> The number of Stations that match your search criteria has exceeded the <BR> allowable
Station Report size limit of '||TO_CHAR(dw_glob_var.gv_stn_Overnight_lmt,'999,999,999')||'.  Please select ''Back'' to modify your search.
	<form><input type="button" value="  <<Back  " width=40 onClick=Close_Onclick();></form></center>
');
ELSE
 -- Provide online/Immediate/Overnight options based on the count.
  if v_StationCount <= dw_glob_var.gv_stn_online_lmt then
    -- online processing
     htp.print('<br> <center> Select ''Back'' to modify search parameters and refine your query. <BR>Select ''Continue'' to generate a report based on your current selections. <BR>You may customize the content of your report by selecting Data Elements below.</center>');
    htp.print('<br> <form name=formz action="DW_STATION_HUB_custom" method=POST>
    <input type="hidden" name="v_FromStmt" value="'||v_FromStmt||'">
    <input type="hidden" name="v_WhereStmt" value="'||v_WhereStmt||'">
    <input type="hidden" name="v_StationCount" value="'||v_StationCount||'">
    <input type="hidden" name="v_filters" value="'||v_filters||'">
    <input type="hidden" name="v_mode" value="Online">
    <table cols=2 cellspacing=10 align="center" width=400><tr><td width=200>
     <center><input type="button" value="  <<Back  " width=40 onClick=Close_Onclick();></center></td><td width=200>
     <center><input type="button" value="Continue>>" width=40  onClick=submitReport();><left></td></tr>
    </table>');

  elsif (v_StationCount > dw_glob_var.gv_stn_online_lmt and v_StationCount <= dw_glob_var.gv_stn_Immediate_lmt) then
    -- provide Immediate and Overnight options
    htp.print('<br><center> Select ''Back'' to modify search parameters and refine your query. '||
              '<BR>Select Batch Processing to generate the report offline based on your current selections.  '||
              '<BR>You may customize the content of your report by selecting Data Elements below.</center>');
    htp.print('<form name=formz action="DW_STATION_HUB_custom" method=POST>
    <input type="hidden" name="v_FromStmt" value="'||v_FromStmt||'">
    <input type="hidden" name="v_WhereStmt" value="'||v_WhereStmt||'">
    <input type="hidden" name="v_StationCount" value="'||v_StationCount||'">
    <input type="hidden" name="v_filters" value="'||v_filters||'">
    <input type="hidden" name="v_mode" value="Immediate">
   <table cols=2 cellspacing=10 align="center" width=600>
    <tr><td colspan=2 align=left>Please enter your email address: <input type="text" size=50 maxlength=50 name=''v_email''></td></tr>
    <tr><td colspan=2 align=left>Please specify three characters to prefix your report name : <input type="text" size=3 maxlength=3 name=''v_prefix''></td>
    </tr>
     <tr><td width=100><input type="button" value="  <<Back  " width=40 onClick=Close_Onclick();></td>
         <td width=500>
             <table cols=1 border=.1>
             <tr><td>
               <table cols=2 border=0 cellspacing=10>
			<tr cellpadding = 10><td colspan=2 align=center><B>Batch Processing</B></td> </tr>
                  <tr cellpadding=10 >
                   <td width=230 align="center"><input type="button" value="Immediate" width=40 onClick=document.formz.v_mode.value=''Immediate'';valiDeferInput();></td>
                   <td width=230  align="center"><input type="button" value="Overnight"  width=40 onClick=document.formz.v_mode.value=''Overnight'';valiDeferInput();></td>
                  </tr>
                  <tr><td colspan=2  align=left>Note: Download files will exceed maximum limits for spread sheet applications (ie. EXCEL - Worksheet size: 65,536 Rows.)</td></tr>
               </table>
             </td></tr>
             </table>
        </td>
     </tr>
    </table>');

  elsif v_StationCount > dw_glob_var.gv_stn_Immediate_lmt and v_StationCount <= dw_glob_var.gv_stn_Overnight_lmt then
    -- provide Overnight option only
    htp.print('<br><center> Select ''Back'' to modify search parameters and refine your query. '||
              '<BR>Select Batch Processing to generate the report offline based on your current selections.  '||
              '<BR>You may customize the content of your report by selecting Data Elements below.</center>');
    htp.print('<br><form name=formz action="DW_STATION_HUB_custom" method=POST>
    <input type="hidden" name="v_FromStmt" value="'||v_FromStmt||'">
    <input type="hidden" name="v_WhereStmt" value="'||v_WhereStmt||'">
    <input type="hidden" name="v_StationCount" value="'||v_StationCount||'">
    <input type="hidden" name="v_filters" value="'||v_filters||'">
    <input type="hidden" name="v_mode" value="Overnight">
   <table cols=2 cellspacing=10 align="center" width=600>
    <tr><td colspan=2 align=left>Please enter your email address: <input type="text" size=50 maxlength=50 name=''v_email''></td></tr>
    <tr><td colspan=2 align=left>Please specify three characters to prefix your report name : <input type="text" size=3 maxlength=3 name=''v_prefix''></td>
    </tr>
     <tr><td width=100><input type="button" value="  <<Back  " width=40 onClick=Close_Onclick();></td>
         <td width=500>
             <table cols=1 border=.1>
             <tr><td>
               <table cols=1 border=0 cellspacing=10>
			<tr cellpadding = 10><td align=center><B>Batch Processing</B></td> </tr>
                  <tr cellpadding=10 >
                   <td align="center"><input type="button" value="Overnight"  width=40 onClick=document.formz.v_mode.value=''Overnight'';valiDeferInput();></td>
                  </tr>
                  <tr><td align=left>Note: Download files will exceed maximum limits for spread sheet applications (ie. EXCEL - Worksheet size: 65,536 Rows.)</td></tr>
               </table>
             </td></tr>
             </table>
        </td>
     </tr>
    </table>');
 end if;

htp.print('<table width=500 cols=1 border=1 align="center"><tr><td><table cols=2 cellspacing="10">
       <tr><td colspan=2><b><center>Select Data Elements for Report</center></b></td></tr>
       <tr><td valign="top" width="50%">
    ');

SELECT COUNT(DISTINCT(STN_REPORT_NUMBER)) INTO v_num_repElement
	FROM APP_COLUMN_NAME
	WHERE STN_REPORT_NUMBER IS NOT NULL;

FOR RepElement in cRepElement LOOP
	IF v_repElement_count >= v_num_repElement/2 THEN
		htp.print('</td><td valign="top">');
		v_repElement_count := 0;
	END IF;
	v_repElement_count := v_repElement_count +1;
	IF RepElement.STN_ELEMENT_DEFAULT = 'Y' THEN
		IF RepElement.HELP_LINK > 0 THEN
			help_file:=''''||DW_glob_var.lv_doc_path||'DW_storet_help.html#'||RepElement.HELP_LINK ||'''';
			htp.print('<input type="checkbox" name="v_Columns" CHECKED value="'||RepElement.stn_report_number||'">'||'<A HREF="javascript:openHelp('||help_file||')">'||RepElement.element_name||'</A>'||'<br>');
		ELSE
			htp.print('<input type="checkbox" name="v_Columns" CHECKED value="'||RepElement.stn_report_number||'">'||RepElement.element_name||'<br>');
		END IF;
	ELSE
		IF RepElement.HELP_LINK > 0 THEN
			help_file:=''''||DW_glob_var.lv_doc_path||'DW_storet_help.html#'||RepElement.HELP_LINK ||'''';
			htp.print('<input type="checkbox" name="v_Columns" value="'||RepElement.stn_report_number||'">'||'<A HREF="javascript:openHelp('||help_file||')">'||RepElement.element_name||'</A>'||'<br>');
		ELSE
			htp.print('<input type="checkbox" name="v_Columns" value="'||RepElement.stn_report_number||'">'||RepElement.element_name||'<br>');
		END IF;
	END IF;
END LOOP;

htp.print('
</td></tr></table>
<center>
<input type="button" value="Select All" onClick=longReport();>
<input type="button" value="Clear All" onClick=clearReport();>
<input type="RESET" value="Restore Defaults">
</center>
</td></tr><br></table><br>');
--************************************************************************************
--sug included the comment [HELP CHANGE]
htp.print('<table align=right>
<tr><td><font size=1>*Element Group.  Click to see the Element list</font></td></tr></table>');
--*************************************************************************************

if v_StationCount <= dw_glob_var.gv_stn_online_lmt then
  -- online processing
  htp.print('<table cols=2 cellspacing=10 align="center" width=400><tr><td width=200>
  <center><input type="button" value="  <<Back  " width=40 onClick=Close_Onclick();></center></td>
  <td width=200><left><input type="button" value="Continue>>" width=40  onClick=submitReport();><left></td></tr></table>
  </form>');
elsif (v_StationCount > dw_glob_var.gv_stn_online_lmt and v_StationCount <= dw_glob_var.gv_stn_Immediate_lmt) then
  -- provide Immediate and Overnight options
htp.print('<table cols=2 cellspacing=10 align="center" width=600>
   <tr><td width=100><input type="button" value="  <<Back  " width=40 onClick=Close_Onclick();></td>
         <td width=500>
             <table cols=1 border=.1>
             <tr><td>
               <table cols=2 border=0 cellspacing=10>
			<tr cellpadding = 10><td colspan=2 align=center><B>Batch Processing</B></td> </tr>
                  <tr cellpadding=10 >
                   <td width=230 align="center"><input type="button" value="Immediate" width=40 onClick=document.formz.v_mode.value=''Immediate'';valiDeferInput();></td>
                   <td width=230  align="center"><input type="button" value="Overnight"  width=40 onClick=document.formz.v_mode.value=''Overnight'';valiDeferInput();></td>
                  </tr>
                  <tr><td colspan=2  align=left>Note: Download files will exceed maximum limits for spread sheet applications (ie. EXCEL - Worksheet size: 65,536 Rows.)</td></tr>
               </table>
             </td></tr>
             </table>
        </td>
     </tr>
    </table>
  </form>');
elsif v_StationCount > dw_glob_var.gv_stn_Immediate_lmt and v_StationCount <= dw_glob_var.gv_stn_Overnight_lmt then
  -- provide Overnight option only
htp.print('<table cols=2 cellspacing=10 align="center" width=600>
     <tr><td width=100><input type="button" value="  <<Back  " width=40 onClick=Close_Onclick();></td>
         <td width=500>
             <table cols=1 border=.1>
             <tr><td>
               <table cols=1 border=0 cellspacing=10>
			<tr cellpadding = 10><td align=center><B>Batch Processing</B></td> </tr>
                  <tr cellpadding=10 >
                   <td align="center"><input type="button" value="Overnight"  width=40 onClick=document.formz.v_mode.value=''Overnight'';valiDeferInput();></td>
                  </tr>
                  <tr><td align=left>Note: Download files will exceed maximum limits for spread sheet applications (ie. EXCEL - Worksheet size: 65,536 Rows.)</td></tr>
               </table>
             </td></tr>
             </table>
        </td>
     </tr>
    </table>
  </form>');
end if;
end if;
DW_bottom_of_page(5);

END DW_STATIONQUERY_COUNT;

/

