
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_CONV_WGS84_LATLONG" (
   p_record_no   OUT NUMBER,
   p_comments    OUT VARCHAR2)
AS
   --in_nbr                 NUMBER;
   --status                 VARCHAR2 (200);
   --lv_message             VARCHAR2 (4000) := NULL;
   --lv_email_address       VARCHAR2 (100);

   CURSOR cstn
   IS
      SELECT s.rowid,
             s.latitude,
             s.longitude,
             gs.country_code,
             gs.state_postal_code,
             hd.id_code,
             s.fk_mad_hdatum,
             s.station_is_number,
             s.organization_id,
             s.location_point_type
        FROM storetw.fa_station s, storetw.di_geo_state gs, lu_mad_hdatum hd
       WHERE     s.fk_geo_state = gs.pk_isn(+)
             AND s.fk_mad_hdatum = hd.pk_isn(+)
             AND s.wgs84_latitude IS NULL
             AND s.wgs84_longitude IS NULL;

   /*
   CURSOR cstn_typ
   IS
      SELECT s.pk_isn, s.station_group_type, s.longitude
        FROM storetw.fa_station s
       WHERE    s.station_group_type IS NULL
             OR s.fk_primary_type IS NULL
             OR s.station_group_type = s.fk_primary_type;
   */

   -- geometry objects
   geom1                  MDSYS.sdo_geometry;
   geom2                  MDSYS.sdo_geometry;
   --local variables
   lv_lat                 storetw.fa_station.wgs84_latitude%TYPE;
   lv_long                storetw.fa_station.wgs84_longitude%TYPE;
   lv_wgs84_mad_hdatum    storetw.fa_station.fk_wgs84_hdatum%TYPE;
   lv_wgs84               storetw.fa_station.fk_wgs84_hdatum%TYPE;
   lv_state_postal_code   storetw.di_geo_state.state_postal_code%TYPE;
   lv_country_code        storetw.di_geo_state.country_code%TYPE;
   lv_cntr                NUMBER := 0;
   lv_convert             NUMBER (1) := 0;
   lv_srid                NUMBER (6, 0);
   --local variables
   lv_sgtype              storetw.fa_station.station_group_type%TYPE;
   lv_ptype               storetw.fa_station.fk_primary_type%TYPE;

   l_count                NUMBER := 0;
   l_count2               NUMBER := 0;
BEGIN
   /*
   lv_email_address := 'STORET@EPA.GOV';

   lv_message :=
         'Start of STORETW CONVERSION WGS84 LATITUDE / LONGITUDE. '
      || TO_CHAR (SYSDATE, 'dd-mon-yyyy hh24:mi');

   storetw.dw_mail_pkg.send (
      p_sender_email   => storetw.dw_glob_var.gv_storet_email,
      p_from           => 'STORET@EPA.GOV',
      p_to             => storetw.dw_mail_pkg.array (lv_email_address),
      p_subject        => 'STORETW CONVERSION WGS84 LATITUDE / LONGITUDE PROCEDURES',
      p_body           => lv_message);
   */

   --in_nbr := NULL;

   --status:='sucessful';

   -- Oracle srid for datum that need to be converted.
   --WGS72      8306
   --WGS84      8307
   --NAD83      8265
   --NAD27      8260
   --NAD27 US - Alaska   8254
   --NAD27 cANADA   8256
   --NAD27 MEXICO   8263
   --Puerto Rico ???

   -- fk of wgs84
   SELECT pk_isn
     INTO lv_wgs84
     FROM lu_mad_hdatum
    WHERE id_code = 'WGS84';

   FOR cstn_var IN cstn
   LOOP
      -- initialize variables
      lv_convert := 0;
      lv_srid := NULL;

      -- Determine if conversion is needed. If so, identify the source SRID.
      IF cstn_var.latitude IS NULL
      THEN
         lv_convert := -1;
      ELSIF cstn_var.id_code = 'WGS72'
      THEN
         lv_srid := etl_glob_var.srid_wgs72;
         lv_convert := 1;
      ELSIF cstn_var.id_code = 'WGS84'
      THEN
         lv_srid := etl_glob_var.srid_wgs84;
         lv_convert := 0;
      ELSIF cstn_var.id_code = 'UNKWN'
      THEN
         lv_srid := etl_glob_var.srid_wgs84;
         lv_convert := 0;
      ELSIF cstn_var.id_code = 'NAD83'
      THEN
         lv_srid := etl_glob_var.srid_nad83;
         lv_convert := 1;
      ELSIF cstn_var.id_code = 'NAD27'
      THEN
         -- fetch POINT OF RECORD country/state information.
         lv_country_code := NULL;
         lv_state_postal_code := NULL;

         IF cstn_var.location_point_type = '*POINT OF RECORD'
         THEN
            lv_state_postal_code := cstn_var.state_postal_code;
            lv_country_code := cstn_var.country_code;
         ELSE
            BEGIN
               SELECT country_code, state_postal_code
                 INTO lv_country_code, lv_state_postal_code
                 FROM storetw.fa_station fas, storetw.di_geo_state gs
                WHERE     fas.fk_geo_state = gs.pk_isn(+)
                      AND fas.station_is_number = cstn_var.station_is_number
                      AND fas.organization_id = cstn_var.organization_id
                      AND fas.location_point_type = '*POINT OF RECORD';
            EXCEPTION
               WHEN NO_DATA_FOUND
               THEN
                  lv_country_code := '00';
                  lv_state_postal_code := '00';
            END;
         END IF;

         IF lv_country_code = 'CN'
         THEN
            lv_srid := etl_glob_var.srid_nad27_canada;
            lv_convert := 1;
         ELSIF lv_country_code = 'MX'
         THEN
            lv_srid := etl_glob_var.srid_nad27_mexico;
            lv_convert := 1;
         ELSIF lv_country_code = 'US' AND lv_state_postal_code = 'AK'
         THEN
            lv_srid := etl_glob_var.srid_nad27_alaska;
            lv_convert := 1;
         ELSIF lv_country_code = 'US'
         THEN
            -- If not Alaska then it is considered continental US.
            lv_srid := etl_glob_var.srid_nad27;
            lv_convert := 1;
         ELSE
            lv_convert := 0;
         END IF;
      ELSE
         lv_convert := 0;
      END IF;


      IF lv_convert = 1
      THEN
         -- initialize/reset variables.
         geom1 := NULL;
         geom2 := NULL;
         lv_lat := NULL;
         lv_long := NULL;

         lv_wgs84_mad_hdatum := lv_wgs84;
         geom1 :=
            mdsys.sdo_geometry (
               2001,                                                -- a point
               lv_srid,                            -- source coordinate system
               mdsys.sdo_point_type (cstn_var.longitude,
                                     cstn_var.latitude,
                                     NULL),
               NULL,
               NULL);
         geom2 := mdsys.SDO_CS.transform (geom1,          -- convert to wgs 84
                                                etl_glob_var.srid_wgs84 -- target coordinate system
                                                                       );
         --pull the x/y back out
         lv_long := geom2.sdo_point.x;
         lv_lat := geom2.sdo_point.y;

         -- update
         UPDATE storetw.fa_station c
            SET c.wgs84_latitude = lv_lat,
                c.wgs84_longitude = lv_long,
                c.fk_wgs84_hdatum = lv_wgs84_mad_hdatum
          WHERE c.rowid = cstn_var.rowid;

         l_count := l_count + 1;

         --status:='sucessful';
         --status := 'successfull';
      ELSIF lv_convert = 0
      THEN
         UPDATE storetw.fa_station c
            SET c.wgs84_latitude = cstn_var.latitude,
                c.wgs84_longitude = cstn_var.longitude,
                c.fk_wgs84_hdatum = lv_wgs84         -- cstn_var.fk_mad_hdatum
          WHERE c.rowid = cstn_var.rowid;

         l_count2 := l_count2 + 1;
      ELSIF lv_convert = -1
      THEN
         NULL;
      END IF;

      -- perform intermediate commits.
      lv_cntr := lv_cntr + 1;

      IF lv_cntr > 10000
      THEN
         COMMIT;
         lv_cntr := 0;
      END IF;
   END LOOP;

   COMMIT;

   /*
   lv_message :=
         'End of STORETW CONVERSION WGS84 LATITUDE / LONGITUDE.  Status='
      || status
      || '.  Start Procedure to Update Spatial Column
'
      || TO_CHAR (SYSDATE, 'dd-mon-yyyy hh24:mi');

   storetw.dw_mail_pkg.send (
      p_sender_email   => storetw.dw_glob_var.gv_storet_email,
      p_from           => 'STORET@EPA.GOV',
      p_to             => storetw.dw_mail_pkg.array (lv_email_address),
      p_subject        => 'STORETW CONVERSION WGS84 LATITUDE / LONGITUDE PROCEDURES',
      p_body           => lv_message);
   */

   p_record_no := l_count + l_count2;
   p_comments := 'CNV1: '
        || l_count || '. CNV0: '
        || l_count2 || '.';

END;
/

