
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_DROP_INDEXES_B4_WQXETL" as
v_obj_stmt clob;
cursor c_indexes is
select table_name,index_name from user_indexes
where table_name ='FA_REGULAR_RESULT'
AND index_name NOT IN ('FA_REG_RES_SOURCE_SYSTEM','I_FA_REG_RESULT_SOURCEUID');

v_delete_stmt varchar2(4000);

begin

DELETE FROM MT_OBJECT_DDL_WQX_ETL;
COMMIT;


for cv in c_indexes loop
v_obj_stmt:=null;
v_obj_stmt:= dbms_metadata.get_ddl('INDEX',cv.index_name,'STORETW');

BEGIN
INSERT INTO MT_OBJECT_DDL_WQX_ETL
(TABLE_NAME ,
OBJECT_NAME ,
OBJECT_TYPE ,
OBJECT_DDL ,
DDL_GEN_DATE ,
OBJECT_DROP_DATE,
OBJECT_CREATE_DATE)
VALUES
(cv.table_name ,
cv.index_name,
'INDEX' ,
v_obj_stmt ,
sysdate ,
null,
null);

v_delete_stmt:=null;
v_delete_stmt:='drop index storetw.'||cv.index_name;


execute immediate v_delete_stmt;

update mt_object_ddl_wqx_etl
set object_drop_date=sysdate,
   OBJECT_DELETE_STATUS='YES'
where TABLE_NAME=cv.table_name
and OBJECT_NAME=cv.index_name
and OBJECT_TYPE='INDEX';
COMMIT;
exception when others then
rollback;
dbms_output.put_line('error recording/droping index '||cv.index_name);
update mt_object_ddl_wqx_etl
set OBJECT_DELETE_STATUS='NO'
where TABLE_NAME=cv.table_name
and OBJECT_NAME=cv.index_name
and OBJECT_TYPE='INDEX';
end;


end loop;
commit;

exception when others then
dbms_output.put_line('error occured '||sqlerrm);
commit;
end;


/

