
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_EI" as
  lv_message varchar2(32000):= null;
  lv_email_address varchar2(1000);
  v_body varchar2(32000):= null;
  v_query varchar2(32000):= null;

--
--Cursor retrieves ORG_ID, ORG_NAME, ORG_TYPE as reference metadata
--7-10minutes
CURSOR org_id IS
	SELECT rtrim("ORGANIZATION_ID")||chr(9)||rtrim("ORGANIZATION_NAME")||chr(10)  as "ORGANIZATION"
	FROM "STORETW"."DI_ORG"
	--WHERE LAST_CHANGE_DATE Between TO_DATE('15-Sep-2010 12:00:00 AM', 'dd-Mon-yyyy HH:MI:SS AM') and TO_DATE('22-Sep-2010 12:00:00 AM', 'dd-Mon-yyyy HH:MI:SS AM')
	WHERE PK_ISN in (
	(SELECT Distinct PK_ISN as FK_ORG FROM "STORETW"."DI_ORG"	WHERE LAST_CHANGE_DATE Between (sysdate-7) and (sysdate))
  --(SELECT Distinct PK_ISN as FK_ORG FROM "STORETW"."DI_ORG"	WHERE LAST_CHANGE_DATE Between TO_DATE('17-Aug-2011 12:00:00 AM', 'dd-Mon-yyyy HH:MI:SS AM') and TO_DATE('25-Aug-2011 12:00:00 AM', 'dd-Mon-yyyy HH:MI:SS AM'))
	UNION
	(SELECT Distinct FK_ORG  FROM "STORETW"."DI_PROJECT"	WHERE LAST_CHANGE_DATE Between (sysdate-7) and (sysdate))
--(SELECT Distinct FK_ORG  FROM "STORETW"."DI_PROJECT"	WHERE LAST_CHANGE_DATE Between TO_DATE('17-Aug-2011 12:00:00 AM', 'dd-Mon-yyyy HH:MI:SS AM') and TO_DATE('25-Aug-2011 12:00:00 AM', 'dd-Mon-yyyy HH:MI:SS AM'))
	UNION
	(SELECT Distinct FK_ORG  FROM "STORETW"."FA_STATION"	WHERE LAST_CHANGE_DATE Between (sysdate-7) and (sysdate))
  --(SELECT Distinct FK_ORG  FROM "STORETW"."FA_STATION"	WHERE LAST_CHANGE_DATE Between TO_DATE('17-Aug-2011 12:00:00 AM', 'dd-Mon-yyyy HH:MI:SS AM') and TO_DATE('25-Aug-2011 12:00:00 AM', 'dd-Mon-yyyy HH:MI:SS AM'))
	UNION
(SELECT Distinct FK_ORG  FROM "STORETW"."FA_REGULAR_RESULT"	WHERE LAST_CHANGE_DATE Between (sysdate-7) and (sysdate))
--(SELECT Distinct FK_ORG  FROM "STORETW"."FA_REGULAR_RESULT"	WHERE LAST_CHANGE_DATE Between TO_DATE('17-Aug-2011 12:00:00 AM', 'dd-Mon-yyyy HH:MI:SS AM') and TO_DATE('25-Aug-2011 12:00:00 AM', 'dd-Mon-yyyy HH:MI:SS AM'))
	UNION
(SELECT Distinct FK_ORG  FROM "STORETW"."FA_BIOLOGICAL_RESULT"	WHERE LAST_CHANGE_DATE Between (sysdate-7) and (sysdate))
-- (SELECT Distinct FK_ORG  FROM "STORETW"."FA_BIOLOGICAL_RESULT"	WHERE LAST_CHANGE_DATE Between TO_DATE('17-Aug-2011 12:00:00 AM', 'dd-Mon-yyyy HH:MI:SS AM') and TO_DATE('25-Aug-2011 12:00:00 AM', 'dd-Mon-yyyy HH:MI:SS AM'))
	UNION
(SELECT Distinct FK_ORG  FROM "STORETW"."FA_HABITAT_RESULT"	WHERE LAST_CHANGE_DATE Between (sysdate-7) and (sysdate))
--(SELECT Distinct FK_ORG  FROM "STORETW"."FA_HABITAT_RESULT"	WHERE LAST_CHANGE_DATE Between TO_DATE('17-Aug-2011 12:00:00 AM', 'dd-Mon-yyyy HH:MI:SS AM') and TO_DATE('25-Aug-2011 12:00:00 AM', 'dd-Mon-yyyy HH:MI:SS AM'))
	)
	ORDER BY ORGANIZATION_ID;

--
CURSOR org_count IS
	SELECT rtrim("ORGANIZATION_ID")||chr(9)||chr(9)||
	    NVL("ORGANIZATION_TYPE",'Private Industry')||chr(10)  as "ORGANIZATION"
	FROM "STORETW"."DI_ORG"
	--WHERE LAST_CHANGE_DATE Between TO_DATE('17-Aug-2011 12:00:00 AM', 'dd-Mon-yyyy HH:MI:SS AM') and TO_DATE('25-Aug-2011 12:00:00 AM', 'dd-Mon-yyyy HH:MI:SS AM')
	WHERE LAST_CHANGE_DATE Between (sysdate-7) and (sysdate)
	ORDER BY ORGANIZATION_ID;

--


BEGIN

--
execute immediate 'alter session set nls_date_format = '||''''||'dd-Mon-yy'||''''||'';
--
lv_message:=sqlerrm;


lv_email_address:='christian.kevin@epa.gov';
--
lv_message:='Start of Warehouse(STORETW) Inventory Report. '||to_char((sysdate),'dd-mon-yyyy hh24:mi')||chr(10)||lv_message;

 -- /*
--STORETW.dw_mail_pkg.send (p_sender_email => storetw.dw_glob_var.gv_storet_email, p_from => 'STORET@EPA.GOV',p_to =>
--storetw.dw_mail_pkg.array(lv_email_address), p_subject => 'STORET Warehouse Weekly (incremental) Refresh Report', p_body =>
--lv_message);
 -- */
 -- /*
STORETW.dw_mail_pkg.send (p_sender_email => storetw.dw_glob_var.gv_storet_email, p_from => 'STORET@EPA.GOV',p_to =>
storetw.dw_mail_pkg.array(lv_email_address), p_subject => 'Start of STORET Warehouse Weekly (incremental) Refresh Report. '||to_char((sysdate),'dd-mon-yyyy hh24:mi'), p_body =>
lv_message);
 -- */
SELECT
'Subject: CORRECTIONS: STORET Warehouse Weekly (incremental) Refresh Report. [station types]'||chr(10)||
chr(10)||
'From:	Kevin Christian'||chr(10)||
chr(10)||
'To:	Water Quality Monitoring Community'||chr(10)||
chr(10)||
chr(10)||
'The text report below contains the WQX data submission counts for'||chr(10)||
'following:'||chr(10)||
chr(10)||
'Organization ID are identified by Organization Name'||chr(10)||
'Results: Regular,Habitat, Biological'||chr(10)||
'Stations:'||chr(10)||
'Projects:'||chr(10)||
'Document/Graphics:'||chr(10)||
'Organizations:'||chr(10)||
chr(10)||
'The report details WQX Data Submission by Organization ID and Name.'||chr(10)||
'A simple text report queried from the STORET Warehouse Tables.'||chr(10)||
chr(10)||
'STORET Data Warehouse:  http://www.epa.gov/storet/dw_home.html '||chr(10)||
' Warehouse Refresh Cycle:  Weekly - Every Wednesday Night 5:00pm '||chr(10)||
' Pacific Time.'||chr(10)||
chr(10)||
'Note: This is a draft report. The automated report will be emailed to '||chr(10)||
'the STORET Listserver following each weekly Warehouse Refresh '||chr(10)||
'(Extract, Transform and Load) session used to publish '||chr(10)||
'WQX Data submission via the STORET Warehouse.'||chr(10)||
chr(10)||
'Comments should be directed to the STORET Helpdesk via email:'||chr(10)||
'storet@epa.gov'||chr(10)||
'Have a Nice Day!'||chr(10)||
chr(10)||
'Thanks.'||chr(10)||
'STORET Group.'||chr(10)||
'1-800-424-9067'||chr(10)
 INTO v_query
FROM DUAL;
--
v_body:=v_body||v_query;
--
--
select 'ORIGINAL Inventory Report Date: '||TO_DATE((sysdate-7), 'dd-Mon-yyyy HH:MI:SS AM')||' thru '||TO_DATE((sysdate), 'dd-Mon-yyyy HH:MI:SS AM')||chr(10)||chr(10)
INTO v_query from dual;
--
v_body:=v_body||v_query;
--
--
select chr(10)||'Reference Metadata:'||chr(10)||'ORGANIZATION_ID	ORGANIZATION_NAME'||chr(10)
INTO v_query from dual;
--
v_body:=v_body||v_query;
--
--
v_query := '';
-- Organization METADATA Report
OPEN org_id;
LOOP
FETCH org_id INTO v_query;
EXIT WHEN org_id%NOTFOUND;
--
--..... your code ....
		v_body:=v_body||v_query;
--
END LOOP;
CLOSE org_id;
--
--
select chr(10)||'Regular Result(s):'||chr(10)||'ORGANIZATION_ID	SAMPLE_COUNT	ACTIVITY_MEDIUM	RESULT_COUNT'||chr(10)
INTO v_query from dual;
--
v_body:=v_body||v_query;
-- Organization NEW Counts
OPEN org_count;
LOOP
FETCH org_count INTO v_query;
EXIT WHEN org_count%NOTFOUND;
--
--..... your code ....
		v_body:=v_body||v_query;
--
END LOOP;
CLOSE org_count;
--
--
lv_message:=v_body;
-- lv_email_address:='"STORET news and information" <storetinfo@lists.epa.gov>';
--lv_email_address:='storetinfo@lists.epa.gov';
lv_email_address:='christian.kevin@epa.gov';

STORETW.dw_mail_pkg.send (p_sender_email => storetw.dw_glob_var.gv_storet_email, p_from => 'STORET@EPA.GOV',p_to =>
storetw.dw_mail_pkg.array(lv_email_address), p_subject => 'STORET Warehouse Weekly (incremental) Refresh Report. '||to_char((sysdate),'dd-mon-yyyy hh24:mi'), p_body =>
lv_message);
--
--
lv_message:='End of Warehouse(STORETW) Inventory Report. '||to_char((sysdate),'dd-mon-yyyy hh24:mi');
lv_email_address:='christian.kevin@epa.gov';

STORETW.dw_mail_pkg.send (p_sender_email => storetw.dw_glob_var.gv_storet_email, p_from => 'STORET@EPA.GOV',p_to =>
storetw.dw_mail_pkg.array(lv_email_address), p_subject => 'End of STORET Warehouse Weekly (incremental) Refresh Report. '||to_char((sysdate),'dd-mon-yyyy hh24:mi'), p_body =>
lv_message);


exception when others then

lv_message:=sqlerrm;
lv_email_address:='christian.kevin@epa.gov';
 --  /*
STORETW.dw_mail_pkg.send (p_sender_email => storetw.dw_glob_var.gv_storet_email, p_from => 'STORET@EPA.GOV',p_to =>
storetw.dw_mail_pkg.array(lv_email_address), p_subject => 'ERROR during STORET Warehouse Weekly (incremental) Refresh Report.'||to_char((sysdate),'dd-mon-yyyy hh24:mi'), p_body =>
lv_message);
 -- */

--execute storetw.sp_email_inventory
--
END;

/

