
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_INSERTINTOACTIVITYPROJECT" (
    p_record_no out number,
    p_comments  out varchar2)
AS
   CURSOR cur_stg_activity_project
   IS
        SELECT s.prj_uid AS prj_uid,
               s.act_uid AS act_uid,
               s.res_type AS res_type,
               s.status AS status,
               s.ROWID AS row_id
          FROM stg_activity_project s
         WHERE s.status = 'N'
      ORDER BY s.res_type, s.prj_uid, s.act_uid;

   p_prj_uid          stg_activity_project.prj_uid%TYPE := -1;
   p_project_pk_isn   di_project.pk_isn%TYPE := -1;
   err_msg            VARCHAR2 (256) := '';

   l_reg_res          NUMBER := 0;
   l_hab_res          NUMBER := 0;
   l_bio_res          NUMBER := 0;
   l_act_prj          NUMBER := 0;
   l_prj_err          NUMBER := 0;
   l_ins_err          NUMBER := 0;
   l_res_err          NUMBER := 0;
BEGIN
   FOR c_stg_a_p IN cur_stg_activity_project
   LOOP
      BEGIN
         err_msg := '';

         IF p_prj_uid <> c_stg_a_p.prj_uid
         THEN
            BEGIN
               SELECT d.pk_isn
                 INTO p_project_pk_isn
                 FROM di_project d
                WHERE     d.source_system = 'WQX'
                      AND d.source_uid = c_stg_a_p.prj_uid;
            EXCEPTION
               WHEN NO_DATA_FOUND
               THEN
                  err_msg :=
                        'no data found in di_project for prj_uid '
                     || TO_CHAR (c_stg_a_p.prj_uid);
                  p_project_pk_isn := -1;
               WHEN TOO_MANY_ROWS
               THEN
                  err_msg :=
                        'too many rows found in di_project for prj_uid '
                     || TO_CHAR (c_stg_a_p.prj_uid);
                  p_project_pk_isn := -1;
            END;

            IF p_project_pk_isn <> -1
            THEN
               p_prj_uid := c_stg_a_p.prj_uid;
            ELSE
               p_prj_uid := -1;
            END IF;
         END IF;

         IF p_project_pk_isn < 0
         THEN
            UPDATE stg_activity_project sap
               SET sap.status = 'E', sap.error_msg = err_msg
             WHERE sap.ROWID = c_stg_a_p.row_id;

            COMMIT;

            l_prj_err := l_prj_err + 1;
         ELSE
            BEGIN
               CASE c_stg_a_p.res_type
                  WHEN 'R'
                  THEN
                     MERGE INTO regular_result_project x
                          USING (SELECT p_project_pk_isn AS prj_pk_isn,
                                        r.pk_isn
                                   FROM fa_regular_result r
                                  WHERE     r.source_system = 'WQX'
                                        AND r.source_uid = c_stg_a_p.act_uid) z
                             ON (    x.fk_project = z.prj_pk_isn
                                 AND x.fk_result = z.pk_isn)
                     WHEN NOT MATCHED
                     THEN
                        INSERT     (fk_project, fk_result)
                            VALUES (z.prj_pk_isn, z.pk_isn);

                     l_reg_res := l_reg_res + sql%rowcount;
                  WHEN 'B'
                  THEN
                     MERGE INTO biological_result_project x
                          USING (SELECT p_project_pk_isn AS prj_pk_isn,
                                        r.pk_isn
                                   FROM fa_biological_result r
                                  WHERE     r.source_system = 'WQX'
                                        AND r.source_uid = c_stg_a_p.act_uid) z
                             ON (    x.fk_project = z.prj_pk_isn
                                 AND x.fk_result = z.pk_isn)
                     WHEN NOT MATCHED
                     THEN
                        INSERT     (fk_project, fk_result)
                            VALUES (z.prj_pk_isn, z.pk_isn);

                     l_bio_res := l_bio_res + sql%rowcount;
                  WHEN 'H'
                  THEN
                     MERGE INTO habitat_result_project x
                          USING (SELECT p_project_pk_isn AS prj_pk_isn,
                                        r.pk_isn
                                   FROM fa_habitat_result r
                                  WHERE     r.source_system = 'WQX'
                                        AND r.source_uid = c_stg_a_p.act_uid) z
                             ON (    x.fk_project = z.prj_pk_isn
                                 AND x.fk_result = z.pk_isn)
                     WHEN NOT MATCHED
                     THEN
                        INSERT     (fk_project, fk_result)
                            VALUES (z.prj_pk_isn, z.pk_isn);

                     l_hab_res := l_hab_res + sql%rowcount;
               END CASE;

               IF SQL%NOTFOUND
               THEN
                  UPDATE stg_activity_project sap
                     SET sap.status = 'E',
                         sap.error_msg =
                               'No data found in result table for source_uid '
                            || TO_CHAR (c_stg_a_p.act_uid)
                   WHERE sap.ROWID = c_stg_a_p.row_id;

                   l_res_err := l_res_err + 1;
               ELSE
                  UPDATE stg_activity_project sap
                     SET sap.status = 'C', sap.error_msg = ''
                   WHERE sap.ROWID = c_stg_a_p.row_id;

                  l_act_prj := l_act_prj + 1;
               END IF;

               COMMIT;
            EXCEPTION
               WHEN OTHERS
               THEN
                  ROLLBACK;
                  err_msg := SUBSTR (SQLERRM, 1, 230);

                  UPDATE stg_activity_project sap
                     SET sap.status = 'E',
                         sap.error_msg = 'Insert error: ' || err_msg
                   WHERE sap.ROWID = c_stg_a_p.row_id;

                  COMMIT;

                  l_ins_err := l_ins_err + 1;
            END;
         END IF;
      END;
   END LOOP;

   p_record_no := l_reg_res + l_bio_res + l_hab_res;
   p_comments := 'ACP: '
        || l_act_prj || '. RRP: '
        || l_reg_res || '. BRP: '
        || l_bio_res || '. HRP: '
        || l_hab_res || '. ERRPRJ: '
        || l_prj_err || '. ERRINS: '
        || l_ins_err || '. SKP: '
        || l_res_err || '. ';

END;
/

