
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_RE-CREATE_INDEX_FA_RESULT" AS

x VARCHAR2(1); -- to test exception...

BEGIN


--SPOOL FA_REGULAR_RESULT_RTRIM.LOG


-- drop temp table indexes
begin
execute immediate 'DROP INDEX "STORETW"."IFAR_LT_STN_ID_OID"' ;
exception when others then null;
end;
--
--ALTER TABLE "STORETW"."FA_REGULAR_RESULT" MODIFY("STATION_ID" VARCHAR2(256 char));
begin
execute immediate 'ALTER TABLE "STORETW"."FA_REGULAR_RESULT" MODIFY("STATION_ID" VARCHAR2(256 char))' ;
exception when others then null;
end;
--
UPDATE STORETW.FA_REGULAR_RESULT frr SET (STATION_ID) =
	(SELECT STATION_ID
	FROM storetw.fa_station fs
	WHERE FRR.ORGANIZATION_ID = fs.ORGANIZATION_ID and FRR.STATION_ID = fs.STATION_ID and FRR.FK_STATION = fs.PK_ISN);
commit;
--
begin
execute immediate 'CREATE INDEX "STORETW"."IFAR_LT_STN_ID_OID"
    ON "STORETW"."FA_REGULAR_RESULT"  (LOWER(TRIM("STATION_ID")),
    LOWER(TRIM("ORGANIZATION_ID")))
    TABLESPACE "STORETINDX" PCTFREE 10 INITRANS 2 MAXTRANS 255
    STORAGE ( INITIAL 2997878784 NEXT 0K MINEXTENTS 1 MAXEXTENTS
    2147483645 PCTINCREASE 0)
    NOLOGGING' ;
exception when others then null;
end;
--
--SPOOL OFF

-- to test exception...
--select sc.TRIBAL_WATER_QUALITY_MEASURE into x from station_char sc
--    Where sc.TRIBAL_WATER_QUALITY_MEASURE ='Y';

RETURN;


END;

/

