
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_REFRESH_PROJ_STATN_CHAR" (
   p_record_no   OUT NUMBER,
   p_comments    OUT VARCHAR2)
AS
   l_res        NUMBER := 0;
   l_reg        NUMBER := 0;
   l_hab        NUMBER := 0;
   l_bio        NUMBER := 0;
   l_prj        NUMBER := 0;
   l_comments   VARCHAR2 (4000) := '';
BEGIN
   /*
   UPDATE di_characteristic c
      SET c.chartype =
             (SELECT ct.chartype
                FROM characteristic_chartype cc, lu_chartype ct
               WHERE     cc.fk_chartype = ct.pk_isn
                     AND cc.fk_characteristic = c.pk_isn)
    WHERE c.chartype IS NULL;

   l_chr := SQL%ROWCOUNT;

   COMMIT;
   */


   EXECUTE IMMEDIATE 'TRUNCATE TABLE storetw.ws_project_station_char_temp';

   FOR c
      IN (SELECT index_name
            FROM all_indexes
           WHERE     owner = 'STORETW'
                 AND table_name = 'WS_PROJECT_STATION_CHAR_TEMP')
   LOOP
      BEGIN
         EXECUTE IMMEDIATE 'DROP INDEX ' || c.index_name;
      EXCEPTION
         WHEN OTHERS
         THEN
            l_comments :=
                  l_comments
               || 'Drop '
               || c.index_name
               || ' failed: '
               || SQLCODE
               || '. ';
      END;
   END LOOP;


   /*
   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX ibwspsc_fk_projt';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;


   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX ibwspsc_fk_chart';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;


   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX ibwspsc_fk_stationt';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;


   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX ibwspsc_fk_orgt';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;
   */


   INSERT /*+ APPEND */
         INTO  ws_project_station_char_temp (fk_project,
                                             fk_char,
                                             act_min_start_date,
                                             act_max_start_stop_date,
                                             fk_station,
                                             result_count)
        SELECT /*+PARALLEL(frp 4) PARALLEL(fr 4)*/
               fk_project,
               fk_char,
               MIN (activity_start_date_time) AS act_min_start_date,
               CASE
                  WHEN MAX (activity_stop_date_time) >
                          MAX (activity_start_date_time)
                  THEN
                     MAX (activity_stop_date_time)
                  ELSE
                     MAX (activity_start_date_time)
               END
                  AS act_max_start_stop_date,
               fr.fk_station,
               COUNT (1) result_count
          FROM fa_regular_result fr, regular_result_project frp
         WHERE frp.fk_result = fr.pk_isn AND fk_char IS NOT NULL
      GROUP BY fk_project, fk_char, fk_station;

   l_reg := SQL%ROWCOUNT;

   COMMIT;


   INSERT /*+ APPEND */
         INTO  ws_project_station_char_temp (fk_project,
                                             fk_char,
                                             act_min_start_date,
                                             act_max_start_stop_date,
                                             fk_station,
                                             result_count)
        SELECT /*+PARALLEL(frp 4) PARALLEL(fr 4)*/
               fk_project,
               fk_char,
               MIN (activity_start_date_time) AS act_min_start_date,
               CASE
                  WHEN MAX (activity_stop_date_time) >
                          MAX (activity_start_date_time)
                  THEN
                     MAX (activity_stop_date_time)
                  ELSE
                     MAX (activity_start_date_time)
               END
                  AS act_max_start_stop_date,
               fr.fk_station,
               COUNT (1) result_count
          FROM fa_biological_result fr, biological_result_project frp
         WHERE     frp.fk_result = fr.pk_isn
               AND fk_char IS NOT NULL
               AND generated_huc IS NOT NULL
      GROUP BY fk_project, fk_char, fk_station;

   l_bio := SQL%ROWCOUNT;

   COMMIT;


   INSERT /*+ APPEND */
         INTO  ws_project_station_char_temp (fk_project,
                                             fk_char,
                                             act_min_start_date,
                                             act_max_start_stop_date,
                                             fk_station,
                                             result_count)
        SELECT /*+PARALLEL(frp 4) PARALLEL(fr 4)*/
               fk_project,
               fk_char,
               MIN (activity_start_date_time) AS act_min_start_date,
               CASE
                  WHEN MAX (activity_stop_date_time) >
                          MAX (activity_start_date_time)
                  THEN
                     MAX (activity_stop_date_time)
                  ELSE
                     MAX (activity_start_date_time)
               END
                  AS act_max_start_stop_date,
               fr.fk_station,
               COUNT (1) result_count
          FROM fa_habitat_result fr, habitat_result_project frp
         WHERE     frp.fk_result = fr.pk_isn
               AND fk_char IS NOT NULL
               AND generated_huc IS NOT NULL
      GROUP BY fk_project, fk_char, fk_station;

   l_hab := SQL%ROWCOUNT;

   COMMIT;


   BEGIN
       EXECUTE IMMEDIATE
          'CREATE BITMAP INDEX ibwspsc_fk_projt ON ws_project_station_char_temp(fk_project) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create ibwspsc_fk_projt failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
       EXECUTE IMMEDIATE
          'CREATE BITMAP INDEX ibwspsc_fk_chart ON ws_project_station_char_temp(fk_char) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create ibwspsc_fk_chart failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
       EXECUTE IMMEDIATE
          'CREATE BITMAP INDEX ibwspsc_fk_stationt ON ws_project_station_char_temp(fk_station) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create ibwspsc_fk_stationt failed: '
            || SQLCODE
            || '. ';
   END;


   DBMS_STATS.gather_table_stats (
      ownname            => 'STORETW',
      tabname            => 'WS_PROJECT_STATION_CHAR_TEMP',
      cascade            => TRUE,
      estimate_percent   => DBMS_STATS.auto_sample_size);


   EXECUTE IMMEDIATE 'TRUNCATE TABLE storetw.ws_project_station_char';

   FOR c
      IN (SELECT index_name
            FROM all_indexes
           WHERE     owner = 'STORETW'
                 AND table_name = 'WS_PROJECT_STATION_CHAR')
   LOOP
      BEGIN
         EXECUTE IMMEDIATE 'DROP INDEX ' || c.index_name;
      EXCEPTION
         WHEN OTHERS
         THEN
            l_comments :=
                  l_comments
               || 'Drop '
               || c.index_name
               || ' failed: '
               || SQLCODE
               || '. ';
      END;
   END LOOP;

   /*
   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX iwsps_orgid';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;

   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX iwsps_orgid_projcd';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;

   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX iwsps_orgid_stnid';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;

   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX iwsps_latitude';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;

   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX iwsps_longitude';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;

   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX iwsps_fk_proj';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;

   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX iwsps_huc';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;

   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX iwsps_chartype';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;

   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX iwsps_lat_long_proj';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;
   */

   INSERT /*+ APPEND */
         INTO  ws_project_station_char (fk_project,
                                        fk_char,
                                        hydrologic_unit_code,
                                        project_cd,
                                        organization_id,
                                        organization_name,
                                        station_id,
                                        station_name,
                                        stn_std_latitude,
                                        stn_std_longitude,
                                        act_min_start_date,
                                        act_max_start_stop_date,
                                        characteristic_name,
                                        chartype,
                                        fk_station,
                                        result_count)
      SELECT /*+PARALLEL(a 4)*/
             a.fk_project,
             a.fk_char,
             s.generated_huc,
             p.project_cd,
             o.organization_id,
             o.organization_name,
             s.station_id,
             s.station_name,
             s.std_latitude,
             s.std_longitude,
             a.act_min_start_date,
             a.act_max_start_stop_date,
             c.display_name,
             NVL (c.chartype, 'null'),
             a.fk_station,
             a.result_count
        FROM (  SELECT /*+PARALLEL(aa 4)*/
                       aa.fk_project,
                       aa.fk_char,
                       MIN (aa.act_min_start_date) act_min_start_date,
                       MAX (aa.act_max_start_stop_date) act_max_start_stop_date,
                       aa.fk_station,
                       SUM (aa.result_count) result_count
                  FROM ws_project_station_char_temp aa
              GROUP BY aa.fk_project,
                       aa.fk_char,
                       aa.fk_station,
                       aa.fk_org) a,
             fa_station s,
             di_project p,
             di_characteristic c,
             di_org o
       WHERE     a.fk_char = c.pk_isn
             AND a.fk_station = s.pk_isn
             AND a.fk_project = p.pk_isn
             AND p.fk_org = o.pk_isn;

   l_res := sql%rowcount;

   COMMIT;


   BEGIN
       EXECUTE IMMEDIATE
          'CREATE BITMAP INDEX iwsps_orgid ON ws_project_station_char(lower(trim(organization_id))) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iwsps_orgid failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
       EXECUTE IMMEDIATE
          'CREATE BITMAP INDEX iwsps_orgid_projcd ON ws_project_station_char(lower(trim(organization_id)), lower(trim(project_cd))) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iwsps_orgid_projcd failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
       EXECUTE IMMEDIATE
          'CREATE BITMAP INDEX iwsps_orgid_stnid ON ws_project_station_char(lower(trim(organization_id)), lower(trim(station_id))) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iwsps_orgid_stnid failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
       EXECUTE IMMEDIATE
          'CREATE INDEX iwsps_latitude ON ws_project_station_char(stn_std_latitude) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iwsps_latitude failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
       EXECUTE IMMEDIATE
          'CREATE INDEX iwsps_longitude ON ws_project_station_char(stn_std_longitude) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iwsps_longitude failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
       EXECUTE IMMEDIATE
          'CREATE INDEX iwsps_lat_long_proj ON ws_project_station_char(stn_std_latitude, stn_std_longitude, fk_project) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iwsps_lat_long_proj failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
       EXECUTE IMMEDIATE
          'CREATE BITMAP INDEX iwsps_fk_proj ON ws_project_station_char(fk_project) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iwsps_fk_proj failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
       EXECUTE IMMEDIATE
          'CREATE BITMAP INDEX iwsps_huc ON ws_project_station_char(LOWER(TRIM(hydrologic_unit_code))) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iwsps_huc failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
       EXECUTE IMMEDIATE
          'CREATE BITMAP INDEX iwsps_chartype ON ws_project_station_char(organization_id,project_cd,chartype) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iwsps_chartype failed: '
            || SQLCODE
            || '. ';
   END;


   DBMS_STATS.gather_table_stats (
      ownname            => 'STORETW',
      tabname            => 'WS_PROJECT_STATION_CHAR',
      cascade            => TRUE,
      estimate_percent   => DBMS_STATS.auto_sample_size);

   DBMS_STATS.gather_table_stats (
      ownname            => 'STORETW',
      tabname            => 'DI_PROJECT',
      cascade            => TRUE,
      estimate_percent   => DBMS_STATS.auto_sample_size);

   UPDATE di_project p
      SET (p.project_por_start, p.project_por_end) =
             (SELECT MIN (pc.act_min_start_date),
                     MAX (pc.act_max_start_stop_date)
                FROM ws_project_station_char pc
               WHERE pc.fk_project = p.pk_isn);

   l_prj := sql%rowcount;

   COMMIT;

   p_record_no := l_res;
   p_comments :=
         l_comments
      || 'INS: '
      || l_res || '. RR: '
      || l_reg || '. BR: '
      || l_bio || '. HR: '
      || l_hab || '. PRJ: '
      || l_prj || '.';

END;
/

