
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_REFRESH_WS_HUC_CHAR_SUMMARY" (
   p_record_no   OUT NUMBER,
   p_comments    OUT VARCHAR2)
AS
   l_res        NUMBER := 0;
   l_comments   VARCHAR2 (4000) := '';
BEGIN

   EXECUTE IMMEDIATE 'TRUNCATE TABLE storetw.ws_huc_char_summary';


   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX iws_hc_huc';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Drop iws_hc_huc failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX iws_hc_huc_chartypeid';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Drop iws_hc_huc_chartypeid failed: '
            || SQLCODE
            || '. ';
   END;

   /*
   BEGIN
      EXECUTE IMMEDIATE 'GRANT SELECT ON ws_huc_char_summary TO storetweb';

   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;
   */

   INSERT /*+ APPEND */
         INTO  ws_huc_char_summary (hydrologic_unit_code,
                                    characteristic_id,
                                    chartype_id,
                                    char_display_name,
                                    chartype_name,
                                    result_count,
                                    char_act_start_date,
                                    char_act_stop_date)
      SELECT /*+PARALLEL(a 4)*/
             a.hydrologic_unit_code,
             a.characteristic_id,
             lu_chartype.pk_isn AS chartype_id,
             NVL (a.char_display_name, di_characteristic.display_name)
                AS char_display_name,
             NVL (lu_chartype.chartype,
                  di_characteristic.characteristic_group_type)
                AS chartype_name,
             a.result_count,
             a.char_act_start_date,
             a.char_act_stop_date
        FROM characteristic_chartype,
             di_characteristic,
             lu_chartype,
             (  SELECT /*+PARALLEL(ws_station_data 4)*/
                       b.hydrologic_unit_code,
                       b.characteristic_id,
                       NVL (b.char_display_name,
                            di_characteristic.display_name)
                          AS char_display_name,
                       SUM (b.char_result_count) AS result_count,
                       MIN (b.min_activity_start_date_time)
                          AS char_act_start_date,
                       MAX (b.max_activity_stop_date_time)
                          AS char_act_stop_date
                  FROM ws_station_data b, di_characteristic
                 WHERE     b.hydrologic_unit_code IS NOT NULL
                       AND di_characteristic.pk_isn = b.characteristic_id
              GROUP BY b.hydrologic_unit_code,
                       b.characteristic_id,
                       NVL (b.char_display_name,
                            di_characteristic.display_name)) a
       WHERE     a.characteristic_id =
                    characteristic_chartype.fk_characteristic
             AND characteristic_chartype.fk_chartype = lu_chartype.pk_isn
             AND di_characteristic.pk_isn =
                    characteristic_chartype.fk_characteristic;


   l_res := SQL%ROWCOUNT;

   COMMIT;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE INDEX iws_hc_huc ON ws_huc_char_summary(TRIM(hydrologic_unit_code)) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iws_hc_huc failed: '
            || SQLCODE
            || '. ';
   END;

   BEGIN
      EXECUTE IMMEDIATE
         'CREATE INDEX iws_hc_huc_chartypeid ON ws_huc_char_summary(TRIM(hydrologic_unit_code),LOWER(TRIM(chartype_name))) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iws_hc_huc_chartypeid failed: '
            || SQLCODE
            || '. ';
   END;

   DBMS_STATS.gather_table_stats (
      ownname            => 'STORETW',
      tabname            => 'WS_HUC_CHAR_SUMMARY',
      cascade            => TRUE,
      estimate_percent   => DBMS_STATS.auto_sample_size);

   p_record_no := l_res;
   p_comments :=
         l_comments
      || 'INS: '
      || l_res
      || '.';

END;
/

