
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_REFRESH_WS_ORG_CHAR_SUMMARY" (
   p_record_no   OUT NUMBER,
   p_comments    OUT VARCHAR2)
AS
   l_res        NUMBER := 0;
   l_comments   VARCHAR2 (4000) := '';
BEGIN

   EXECUTE IMMEDIATE 'TRUNCATE TABLE storetw.ws_huc_org_char_summary';

   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX iws_hoc_huc';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Drop iws_hoc_huc failed: '
            || SQLCODE
            || '. ';
   END;

   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX iws_hoc_huc_orgid_chartypeid';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Drop iws_hoc_huc_orgid_chartypeid failed: '
            || SQLCODE
            || '. ';
   END;

   /*
   BEGIN
      EXECUTE IMMEDIATE
         'GRANT SELECT ON storetw.ws_huc_org_char_summary TO storetweb';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;
   */


   INSERT /*+ APPEND */
         INTO  storetw.ws_huc_org_char_summary (hydrologic_unit_code,
                                                organization_id,
                                                characteristic_id,
                                                chartype_id,
                                                char_display_name,
                                                chartype_name,
                                                result_count,
                                                char_act_start_date,
                                                char_act_stop_date)
      SELECT /*+PARALLEL(a 4)*/
             a.hydrologic_unit_code,
             a.organization_id,
             a.characteristic_id,
             lu_chartype.pk_isn AS chartype_id,
             NVL (a.char_display_name, di_characteristic.display_name)
                AS char_display_name,
             lu_chartype.chartype AS chartype_name,
             a.result_count,
             a.char_act_start_date,
             a.char_act_stop_date
        FROM characteristic_chartype,
             di_characteristic,
             lu_chartype,
             (  SELECT /*+PARALLEL(ws_station_data 4)*/
                       b.hydrologic_unit_code,
                       b.organization_id,
                       b.characteristic_id,
                       NVL (b.char_display_name,
                            di_characteristic.display_name)
                          AS char_display_name,
                       SUM (b.char_result_count) AS result_count,
                       MIN (b.min_activity_start_date_time)
                          AS char_act_start_date,
                       MAX (b.max_activity_stop_date_time)
                          AS char_act_stop_date
                  FROM storetw.ws_station_data b, di_characteristic
                 WHERE     b.hydrologic_unit_code IS NOT NULL
                       AND b.characteristic_id = di_characteristic.pk_isn
              GROUP BY b.hydrologic_unit_code,
                       b.organization_id,
                       b.characteristic_id,
                       NVL (b.char_display_name,
                            di_characteristic.display_name)) a
       WHERE     a.characteristic_id =
                    characteristic_chartype.fk_characteristic
             AND characteristic_chartype.fk_chartype = lu_chartype.pk_isn
             AND characteristic_chartype.fk_characteristic =
                    di_characteristic.pk_isn;

   l_res := SQL%ROWCOUNT;

   COMMIT;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE INDEX iws_hoc_huc on ws_huc_org_char_summary(TRIM(hydrologic_unit_code)) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iws_hoc_huc failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE INDEX iws_hoc_huc_orgid_chartypeid ON ws_huc_org_char_summary(TRIM(hydrologic_unit_code),LOWER(TRIM(organization_id)),LOWER(TRIM(chartype_name))) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iws_hoc_huc_orgid_chartypeid failed: '
            || SQLCODE
            || '. ';
   END;

   DBMS_STATS.gather_table_stats (
      ownname            => 'STORETW',
      tabname            => 'WS_HUC_ORG_CHAR_SUMMARY',
      cascade            => TRUE,
      estimate_percent   => DBMS_STATS.auto_sample_size);

   p_record_no := l_res;
   p_comments :=
         l_comments
      || 'INS: '
      || l_res
      || '.';

END;
/

