
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_REFRESH_WS_STATION_DATA" (
   p_record_no   OUT NUMBER,
   p_comments    OUT VARCHAR2)
AS
    l_res       NUMBER := 0;
    l_comments  VARCHAR2(4000) := '';
BEGIN
   /*
   BEGIN
      EXECUTE IMMEDIATE 'CREATE INDEX i_cctype_fk_char ON characteristic_chartype(fk_characteristic) TABLESPACE storetindx ';

   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;

   BEGIN
      EXECUTE IMMEDIATE 'CREATE INDEX i_cctype_fk_chartype ON characteristic_chartype(fk_chartype) TABLESPACE storetindx ';

   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;

   BEGIN
      EXECUTE IMMEDIATE 'CREATE INDEX i_ctype_pkisn ON lu_chartype(pk_isn) TABLESPACE storetindx ';

   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;
   */

   /*
   DELETE FROM storetw.characteristic_chartype a
         WHERE a.fk_chartype IN (SELECT b.pk_isn
                                   FROM storetw.lu_chartype b
                                  WHERE b.chartype = 'Measure N');

   COMMIT;

   DELETE FROM characteristic_chartype a
         WHERE NOT EXISTS
                  (SELECT 1
                     FROM lu_chartype b
                    WHERE b.pk_isn = a.fk_chartype);

   COMMIT;

   DELETE FROM lu_chartype a
         WHERE a.chartype = 'Measure N';

   COMMIT;
   */


   DBMS_STATS.gather_table_stats (
      ownname            => 'STORETW',
      tabname            => 'CHARACTERISTIC_CHARTYPE',
      cascade            => TRUE,
      estimate_percent   => DBMS_STATS.auto_sample_size);

   DBMS_STATS.gather_table_stats (
      ownname            => 'STORETW',
      tabname            => 'LU_CHARTYPE',
      cascade            => TRUE,
      estimate_percent   => DBMS_STATS.auto_sample_size);


   EXECUTE IMMEDIATE 'TRUNCATE TABLE storetw.ws_station_data';


   FOR c IN (SELECT index_name
               FROM all_indexes
              WHERE owner = 'STORETW' AND table_name = 'WS_STATION_DATA')
   LOOP
      BEGIN
         EXECUTE IMMEDIATE 'DROP INDEX ' || c.index_name;
      EXCEPTION
         WHEN OTHERS
         THEN
            l_comments :=
                  l_comments
               || 'Drop '
               || c.index_name
               || ' failed: '
               || SQLCODE
               || '. ';
      END;
   END LOOP;

   /*
   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX iws_wst_char_id';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;

   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX iws_wst_huc_org_statn';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;

   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX iws_wst_huc';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;
   */


   INSERT INTO /*+ APPEND */
              storetw.ws_station_data (hydrologic_unit_code,
                                       organization_id,
                                       organization_name,
                                       station_id,
                                       station_name,
                                       min_activity_start_date_time,
                                       max_activity_stop_date_time,
                                       rslt_min_value_measure,
                                       rslt_max_value_measure,
                                       rslt_measure_unit,
                                       characteristic_id,
                                       char_display_name,
                                       characteristic_group_type,
                                       char_result_count,
                                       unique_station_identifier,
                                       std_latitude,
                                       std_longitude,
                                       fk_station)
        SELECT /*+PARALLEL(station_char 4)*/
               NVL (TRIM (station_char.hydrologic_unit_code), generated_huc)
                  AS hydrologic_unit_code,
               NVL (TRIM (station_char.organization_id),
                    fa_station.organization_id)
                  AS organization_id,
               organization_name,
               TRIM (station_char.station_id) AS station_id,
               NVL (station_char.station_name, fa_station.station_name),
               act_min_start_date AS min_activity_start_date_time,
               act_max_start_stop_date AS max_activity_stop_date_time,
               rslt_min_value_measure,
               rslt_max_value_measure,
               rslt_measure_unit,
               fk_char AS characteristic_id,
               NVL (station_char.display_name, di_characteristic.display_name)
                  AS char_display_name,
               di_characteristic.characteristic_group_type,
               result_count AS char_result_count,
                  TRIM (station_char.organization_id)
               || ','
               || TRIM (station_char.station_id)
                  AS unique_station_identifier,
               fa_station.std_latitude,
               fa_station.std_longitude,
               fa_station.pk_isn
          FROM station_char,
               di_org,
               fa_station,
               storetw.di_characteristic
         WHERE     di_org.organization_id = station_char.organization_id
               AND station_char.fk_fa_statn = fa_station.pk_isn
               AND di_characteristic.pk_isn = fk_char
               AND TRIM (UPPER (fa_station.location_point_type)) =
                      '*POINT OF RECORD'
      ORDER BY fk_char;

   l_res := SQL%ROWCOUNT;

   COMMIT;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE INDEX iws_wst_char_id ON ws_station_data(characteristic_id) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iws_wst_char_id failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE INDEX iws_wst_huc_org_statn ON ws_station_data(hydrologic_unit_code,organization_id,station_id) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iws_wst_huc_org_statn failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE INDEX iws_wst_huc ON ws_station_data(hydrologic_unit_code) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iws_wst_huc failed: '
            || SQLCODE
            || '. ';
   END;

   DBMS_STATS.gather_table_stats (
      ownname            => 'STORETW',
      tabname            => 'WS_STATION_DATA',
      cascade            => TRUE,
      estimate_percent   => DBMS_STATS.auto_sample_size);

   p_record_no := l_res;
   p_comments :=
         l_comments
      || 'INS: '
      || l_res
      || '.';

END sp_refresh_ws_station_data;
/

