
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_REFRESH_WS_STATION_SUMMARY" (
   p_record_no   OUT NUMBER,
   p_comments    OUT VARCHAR2)
AS
   l_res        NUMBER := 0;
   l_comments   VARCHAR2 (4000) := '';
BEGIN

   EXECUTE IMMEDIATE 'TRUNCATE TABLE ws_station_summary';

   FOR c IN (SELECT index_name
               FROM all_indexes
              WHERE owner = 'STORETW' AND table_name = 'WS_STATION_SUMMARY')
   LOOP
      BEGIN
         EXECUTE IMMEDIATE 'DROP INDEX ' || c.index_name;
      EXCEPTION
         WHEN OTHERS
         THEN
            l_comments :=
                  l_comments
               || 'Drop '
               || c.index_name
               || ' failed: '
               || SQLCODE
               || '. ';
      END;
   END LOOP;

   /*
   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX iws_ss_unique_station_id';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;

   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX iws_ss_huc';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;

   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX iws_ss_chartype_station_org';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;

   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX iws_ss_huc_station_org';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;

   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX iws_ss_huc_org_id';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;



   BEGIN
      EXECUTE IMMEDIATE 'TRUNCATE TABLE ws_station_summary';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;

   --grants
   BEGIN
      EXECUTE IMMEDIATE 'GRANT SELECT ON ws_station_summary TO storetweb';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;
   */


   INSERT /*+ APPEND */
         INTO  storetw.ws_station_summary (organization_id,
                                           station_id,
                                           characteristic_id,
                                           chartype_id,
                                           hydrologic_unit_code,
                                           organization_name,
                                           station_name,
                                           min_activity_start_date_time,
                                           max_activity_stop_date_time,
                                           rslt_min_value_measure,
                                           rslt_max_value_measure,
                                           rslt_measure_unit,
                                           chartype,
                                           char_display_name,
                                           characteristic_result_count,
                                           unique_station_identifier,
                                           std_latitude,
                                           std_longitude,
                                           fk_station)
      SELECT /*+PARALLEL(ws_station_data 4)*/
             NVL (ws_station_data.organization_id,
                  fa_station.organization_id)
                AS organization_id,
             ws_station_data.station_id,
             characteristic_id,
             lu_chartype.pk_isn AS chartype_id,
             ws_station_data.hydrologic_unit_code,
             ws_station_data.organization_name,
             fa_station.station_name,
             min_activity_start_date_time AS min_activity_start_date_time,
             max_activity_stop_date_time AS max_activity_stop_date_time,
             rslt_min_value_measure,
             rslt_max_value_measure,
             rslt_measure_unit,
             lu_chartype.chartype,
             NVL (ws_station_data.char_display_name,
                  di_characteristic.display_name)
                AS char_display_name,
             char_result_count AS characteristic_result_count,
             unique_station_identifier,
             fa_station.std_latitude,
             fa_station.std_longitude,
             fa_station.pk_isn
        FROM storetw.ws_station_data,
             storetw.lu_chartype,
             storetw.characteristic_chartype,
             storetw.di_characteristic,
             storetw.fa_station,
             di_org
       WHERE     di_org.organization_id = ws_station_data.organization_id
             AND ws_station_data.characteristic_id =
                    characteristic_chartype.fk_characteristic
             AND characteristic_chartype.fk_chartype = lu_chartype.pk_isn
             AND ws_station_data.characteristic_id = di_characteristic.pk_isn
             AND ws_station_data.fk_station = fa_station.pk_isn
             AND TRIM (UPPER (fa_station.location_point_type)) =
                    '*POINT OF RECORD';

   l_res := SQL%ROWCOUNT;

   COMMIT;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE INDEX iws_ss_char_id ON storetw.ws_station_summary(characteristic_id) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iws_ss_char_id failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE INDEX iws_ss_unique_station_id ON storetw.ws_station_summary(LOWER(TRIM(unique_station_identifier))) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iws_ss_unique_station_id failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE INDEX iws_ss_huc_org_id ON storetw.ws_station_summary(TRIM(hydrologic_unit_code), LOWER(TRIM(organization_id))) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iws_ss_huc_org_id failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE INDEX iws_ss_huc ON storetw.ws_station_summary(TRIM(hydrologic_unit_code)) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iws_ss_huc failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE INDEX iws_ss_huc_station_org ON storetw.ws_station_summary(TRIM(hydrologic_unit_code),LOWER(TRIM(station_id)), LOWER(TRIM(organization_id))) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iws_ss_huc_station_org failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE INDEX iws_ss_chartype_station_org ON storetw.ws_station_summary(LOWER(TRIM(chartype)), LOWER(TRIM(station_id)), LOWER(TRIM(organization_id))) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iws_ss_chartype_station_org failed: '
            || SQLCODE
            || '. ';
   END;


   DBMS_STATS.GATHER_TABLE_STATS (
      ownname            => 'STORETW',
      tabname            => 'WS_STATION_SUMMARY',
      cascade            => TRUE,
      estimate_percent   => DBMS_STATS.auto_sample_size);

   p_record_no := l_res;
   p_comments :=
         l_comments
      || 'INS: '
      || l_res
      || '.';

END;
/

