
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_UPD_RES_TBLS_HUC"               (
	p_limiter	NUMBER DEFAULT NULL, -- Number of rows to fetch from cursor per batch
	p_dryrun	BOOLEAN DEFAULT TRUE -- If true, no commits are made.
)
AS
	my_cursor SYS_REFCURSOR;
	str_sql VARCHAR2(4000);
	str_sql2 VARCHAR2(4000);
	num_records NUMBER;
	num_limiter NUMBER;
	TYPE tbl_pks IS TABLE OF NUMBER;
	TYPE tbl_hucs IS TABLE OF VARCHAR2(256);
	ary_pks tbl_pks;
	ary_hucs tbl_hucs;
	update_count NUMBER;

-- update fa_regular_result for station table huc assignment by result record last change date
-- Assumption SP_UPDATE_FA_STATION_HUC has completed station HUC8, HUC12, etc. assignment
-- update fa_regular_result for station table huc assignment by result record last change date
-- cursor thru station list by unique identifier (fk_station)
-- fa-station new/updated records have NULLs for generated columns: GENERATED_HUC,WGS84_latlong,GEOM, STD_latlong
-- Spatial column based on 1. SP_CONV_WGS84_LATLONG, 2. SP_UPDATE_GEOMWGS84_LATLONG, 3. SP_UPDATE_FA_STATION_HUC
-- Station Generated HUC procedure assigns HUC based on spatial column
-- update all station owned result records
BEGIN
	dbms_output.put_line(systimestamp() || ' - Starting SP_UPDATE_RESULT_TABLES_HUC...');
	update_count := 0;

	dbms_output.put_line(systimestamp() || ' - Querying for updates to fa_biological_result...');

	str_sql := 'SELECT '
				|| 'COUNT(distinct fk_station) '
				|| 'FROM storetw.fa_biological_result b '
				|| 'WHERE b.generated_huc IS NULL '
				|| 'OR b.fk_gen_db_cat IS NULL '
				|| 'OR fk_station in (select pk_isn  from storetw.fa_station where std_latitude is null) ';

	EXECUTE IMMEDIATE str_sql INTO num_records;

	dbms_output.put_line(systimestamp() || ' - Found ' || num_records || ' records to update in fa_biological_result.');

	IF num_records > 0
	THEN
		IF p_limiter IS NULL
		THEN
			num_limiter := num_records;

		ELSE
			IF num_records > p_limiter
			THEN
				num_limiter := p_limiter;
			ELSE
				num_limiter := num_records;
			END IF;

		END IF;

		str_sql := 'SELECT '
				|| 'a.pk_isn, a.generated_huc , a.fk_gen_db_cat '
				|| 'FROM storetw.fa_station a '
				|| 'WHERE pk_isn in ( '
				|| 'SELECT '
				|| 'distinct fk_station '
				|| 'FROM storetw.fa_biological_result b '
				|| 'WHERE b.generated_huc IS NULL '
				|| 'OR b.fk_gen_db_cat IS NULL '
				|| 'OR fk_station in (select pk_isn  from storetw.fa_station where std_latitude is null) '
				|| ') ';


		OPEN my_cursor FOR str_sql;

		LOOP
			FETCH my_cursor BULK COLLECT
				INTO ary_pks, ary_hucs LIMIT num_limiter;
			EXIT WHEN ary_pks.COUNT = 0;

			FOR i IN 1 .. ary_pks.COUNT
			LOOP
				str_sql2 := 'UPDATE storetw.fa_biological_result a '
							|| 'SET a.generated_huc = :p01, '
							|| 'a.fk_gen_db_cat =  '||''''||''''
							|| 'WHERE a.fk_station = :p02 ';

				EXECUTE IMMEDIATE str_sql2
				USING
				ary_hucs(i), ary_pks(i);

				update_count := update_count +1;

				IF p_dryrun
				THEN
					dbms_output.put_line(systimestamp() || ' - Dry run. ' || str_sql2 || '...');
				END IF;

			END LOOP;

			IF NOT p_dryrun
			THEN
				COMMIT;
			END IF;

		END LOOP;
	END IF;


	IF p_dryrun
	THEN
		ROLLBACK;
		dbms_output.put_line(systimestamp() || ' - Dry run. ' || update_count || ' updates not committed.');
	ELSE
		dbms_output.put_line(systimestamp() || ' - ' || update_count || ' updates committed.');
	END IF;

END SP_UPD_RES_TBLS_HUC;
/

