
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_UPDATE_FA_STN_HUC"
AS
   my_cursor    SYS_REFCURSOR;
   str_sql      VARCHAR2(4000);
   str_sql2     VARCHAR2(4000);
   num_records  NUMBER;
   num_limiter  NUMBER;
   TYPE tbl_plks IS TABLE OF NUMBER;
   TYPE tbl_pts  IS TABLE OF SDO_GEOMETRY;
   ary_pks      tbl_plks;
   ary_sdo      tbl_pts;
   str_huc8     VARCHAR2(8);
   str_huc12    VARCHAR2(12);
   p_limiter   NUMBER DEFAULT NULL;

BEGIN

   -----------------------------------------------------------------------------
   -- Step 10
   -- Check over incoming parameters
   -----------------------------------------------------------------------------

   -----------------------------------------------------------------------------
   -- Step 20
   -- Check the count of records to process
   -----------------------------------------------------------------------------
   str_sql := 'SELECT '
           || 'COUNT(1) '
           || 'FROM '
           || 'storetw.fa_station a '
           || 'WHERE '
           || '( a.generated_huc IS NULL ) '
           || '';

   EXECUTE IMMEDIATE str_sql INTO num_records ;

   IF num_records = 0
   THEN
      RETURN;
   END IF;

   -----------------------------------------------------------------------------
   -- Step 30
   -- Apply the limiter
   -----------------------------------------------------------------------------
      p_limiter := 100;
   IF p_limiter IS NULL
   THEN
      num_limiter := num_records;

   ELSE
      IF num_records > p_limiter
      THEN
         num_limiter := p_limiter;
      ELSE
         num_limiter := num_records;
      END IF;

   END IF;

   -----------------------------------------------------------------------------
   -- Step 40
   -- Open a cursor to the records in question
   -----------------------------------------------------------------------------
   str_sql := 'SELECT '
           || 'a.pk_isn, '
           || 'a.geom '
           || 'FROM '
           || 'storetw.fa_station a '
           || 'WHERE '
           || '( a.generated_huc IS NULL ) '
           || '';

   OPEN my_cursor FOR str_sql ;


   LOOP
      FETCH my_cursor BULK COLLECT INTO ary_pks,ary_sdo LIMIT 100;
      EXIT WHEN ary_pks.COUNT = 0;

      FOR i IN 1 .. ary_pks.COUNT
      LOOP

         IF ary_sdo(i) IS NOT NULL
         THEN

            str_huc8  := SP_fetch_legacy_huc8(ary_sdo(i));
            str_huc12 := SP_fetch_wbd_huc12(ary_sdo(i));

            str_sql2 := 'UPDATE storetw.fa_station a '
                     || 'SET (a.generated_huc,a.huctwelvedigitcode) = ('
                     || '   SELECT :p01,:p02 FROM dual '
                     || ') '
                     || 'WHERE a.pk_isn = :p03 ';

            EXECUTE IMMEDIATE str_sql2
            USING
            str_huc8, str_huc12, ary_pks(i);

         END IF;

      END LOOP;

      COMMIT;

   END LOOP;

 UPDATE STORETW.FA_STATION fs SET (FK_GEN_DB_CAT) =
       (SELECT ddc.pk_isn FROM storetw.di_db_cat ddc 	WHERE fs.GENERATED_HUC = ddc.HYDROLOGIC_UNIT_CODE )
  where FK_GEN_DB_CAT is NULL;
  commit;

END SP_update_fa_stn_huc;
/

