
  CREATE TABLE "STORETW"."DI_PROJECT"
   (	"PK_ISN" NUMBER NOT NULL ENABLE,
	"TSMPROJ_IS_NUMBER" NUMBER(12,0),
	"TSMPROJ_ORG_ID" VARCHAR2(256),
	"PROJECT_CD" VARCHAR2(256 CHAR),
	"PROJECT_NAME" VARCHAR2(256 CHAR),
	"START_DATE" DATE,
	"PLANNED_DURATION" VARCHAR2(256 CHAR),
	"LAST_USERID" VARCHAR2(100),
	"LAST_CHANGE_DATE" DATE DEFAULT systimestamp,
	"FK_ORG" NUMBER(12,0),
	"PURPOSE" VARCHAR2(4000 CHAR),
	"STUDY_AREA" VARCHAR2(4000 CHAR),
	"PROJECT_DESIGN" VARCHAR2(4000 CHAR),
	"OBTAIN_PLAN" VARCHAR2(4000 CHAR),
	"QUALITY_ASSURANCE" VARCHAR2(4000 CHAR),
	"QUALITY_OBJECTIVES" VARCHAR2(4000 CHAR),
	"BLOB_TITLE" VARCHAR2(256 CHAR),
	"BLOB_ID" VARCHAR2(256),
	"PROJECT_DESCRIPTION" VARCHAR2(4000),
	"SOURCE_SYSTEM" VARCHAR2(256 CHAR),
	"SOURCE_UID" NUMBER(20,0),
	"QA_APPROVAL_AGENCY" VARCHAR2(256),
	"FK_QA_AGENCY" NUMBER,
	"QA_APPROVED" VARCHAR2(256),
	"SAMPLING_DESIGN_TYPE_CD" VARCHAR2(256),
	"PROJECT_POR_START" DATE,
	"PROJECT_POR_END" DATE,
	"LAST_TRANSACTION_ID" VARCHAR2(100)
   ) ;
  ALTER TABLE "STORETW"."DI_PROJECT" ADD CONSTRAINT "PK_PROJECT" PRIMARY KEY ("PK_ISN") ENABLE;


  CREATE INDEX "STORETW"."I_DI_PROJECT_SOURCEUID" ON "STORETW"."DI_PROJECT" ("SOURCE_SYSTEM", "SOURCE_UID")
  ;


  CREATE BITMAP INDEX "STORETW"."I_DI_PROJECT_FN_ORG_ID" ON "STORETW"."DI_PROJECT" (LOWER("TSMPROJ_ORG_ID"))
  ;


  CREATE BITMAP INDEX "STORETW"."I_DI_PROJECT_FN_PROJECT_CD" ON "STORETW"."DI_PROJECT" (LOWER("PROJECT_CD"))
  ;


  CREATE UNIQUE INDEX "STORETW"."PK_PROJECT" ON "STORETW"."DI_PROJECT" ("PK_ISN")
  ;


  CREATE INDEX "STORETW"."IPR_ISN_ORGID" ON "STORETW"."DI_PROJECT" ("TSMPROJ_IS_NUMBER", "TSMPROJ_ORG_ID")
  ;

