
  CREATE TABLE "STORETW"."FA_ACTIVITY_METRIC"
   (	"PK_ISN" NUMBER NOT NULL DISABLE,
	"ACTIVITY_ID" VARCHAR2(256 CHAR),
	"ORGANIZATION_ID" VARCHAR2(256 CHAR),
	"METRICTYPE_ID" VARCHAR2(256 CHAR),
	"ACT_METRIC_SCORE" VARCHAR2(256 CHAR),
	"ACT_METRIC_VALUE" VARCHAR2(256 CHAR),
	"ACT_METRIC_UNIT" VARCHAR2(256 CHAR),
	"ACT_METRIC_COMMENT" VARCHAR2(256 CHAR),
	"FK_ORG" NUMBER(12,0),
	"FK_METRICTYPE" NUMBER(12,0),
	"SOURCE_SYSTEM" VARCHAR2(256),
	"SOURCE_ACT_UID" NUMBER,
	"SOURCE_UID" NUMBER,
	"LAST_CHANGE_DATE" DATE DEFAULT systimestamp,
	"LAST_USERID" VARCHAR2(100),
	"LAST_TRANSACTION_ID" VARCHAR2(100),
	"STATION_ID" VARCHAR2(256 CHAR),
	"STATION_NAME" VARCHAR2(256 CHAR),
	"STN_LATITUDE" NUMBER,
	"STN_LONGITUDE" NUMBER,
	"STN_HDATUM" CHAR(12 CHAR),
	"STN_STD_LATITUDE" NUMBER,
	"STN_STD_LONGITUDE" NUMBER,
	"STN_STD_HDATUM" CHAR(12 CHAR),
	"HYDROLOGIC_UNIT_CODE" CHAR(8 CHAR),
	"GENERATED_HUC" CHAR(8 CHAR),
	"TRIP_NAME" VARCHAR2(256 CHAR),
	"ACTIVITY_START_DATE_TIME" DATE,
	"ACT_START_TIME_ZONE" VARCHAR2(5 CHAR),
	"ACTIVITY_STOP_DATE_TIME" DATE,
	"ACT_STOP_TIME_ZONE" VARCHAR2(5 CHAR),
	"ACTIVITY_MEDIUM" VARCHAR2(20 CHAR),
	"ACTIVITY_MATRIX" VARCHAR2(256 CHAR),
	"ACTIVITY_TYPE" VARCHAR2(256 CHAR),
	"ACTIVITY_CATEGORY" VARCHAR2(256 CHAR),
	"REPLICATE_NUMBER" NUMBER(3,0),
	"ACTIVITY_INTENT" VARCHAR2(20 CHAR),
	"ACTIVITY_COMMUNITY" VARCHAR2(256 CHAR),
	"ACTIVITY_SUBJECT_TAXON" VARCHAR2(69 CHAR),
	"LOCATION_POINT_TYPE" CHAR(16 CHAR),
	"POINT_SEQUENCE_NUMBER" NUMBER,
	"POINT_NAME" VARCHAR2(30 CHAR),
	"ACTIVITY_LATITUDE" NUMBER,
	"ACTIVITY_LONGITUDE" NUMBER,
	"ACT_STD_LATITUDE" NUMBER,
	"ACT_STD_LONGITUDE" NUMBER,
	"ACT_STD_HDATUM" CHAR(12 CHAR),
	"WELL_NUMBER" CHAR(15 CHAR),
	"PIPE_NUMBER" CHAR(15 CHAR),
	"MAP_SCALE" VARCHAR2(20 CHAR),
	"ACTIVITY_DEPTH" VARCHAR2(256 CHAR),
	"ACTIVITY_DEPTH_UNIT" VARCHAR2(256 CHAR),
	"ACTIVITY_UPPER_DEPTH" VARCHAR2(256 CHAR),
	"ACTIVITY_REL_DEPTH" CHAR(15 CHAR),
	"ACTIVITY_LOWER_DEPTH" VARCHAR2(256 CHAR),
	"ACTIVITY_DEPTH_REF_POINT" VARCHAR2(256 CHAR),
	"UPR_LWR_DEPTH_UNIT" VARCHAR2(256 CHAR),
	"FIELD_PROCEDURE_ID" VARCHAR2(256 CHAR),
	"FIELD_GEAR_ID" VARCHAR2(256 CHAR),
	"METRIC_CONTEXT" VARCHAR2(256 CHAR),
	"METRIC_NAME" VARCHAR2(256 CHAR),
	"FORMULA_DESC" VARCHAR2(4000 CHAR),
	"METRIC_SCALE" VARCHAR2(256 CHAR),
	"CITATION_IS_NUMBER" NUMBER(20,0),
	"CITATION_ID" VARCHAR2(256 CHAR),
	"CITATION_TITLE" VARCHAR2(1999 CHAR),
	"CITATION_AUTHOR" VARCHAR2(256 CHAR),
	"PBLSHR_ORG_NAME" VARCHAR2(256 CHAR),
	"PUBLISHING_YEAR" VARCHAR2(256 CHAR),
	"VOL_AND_PAGE" VARCHAR2(256 CHAR),
	"REFERENCE_ID" VARCHAR2(256 CHAR),
	"CITATION_COMMENT" VARCHAR2(4000 CHAR),
	"FISHED_DURATION" CHAR(15 CHAR),
	"BOAT_SPEED" CHAR(15 CHAR),
	"PASS_COUNT" NUMBER,
	"PASS_LENGTH" CHAR(10 CHAR),
	"SAMPLING_DURATION" VARCHAR2(256 CHAR),
	"ACTIVITY_IS_NUMBER" NUMBER(12,0),
	"ACTIVITY_ISN" NUMBER,
	"FK_STATION" NUMBER(12,0),
	"FK_DB_CAT" NUMBER(12,0),
	"FK_GEN_DB_CAT" NUMBER(12,0),
	"FK_GEO_COUNTY" NUMBER(12,0),
	"FK_GEO_STATE" NUMBER(12,0),
	"FK_ACT_MAD_HDATUM" NUMBER(12,0),
	"FK_ACT_MAD_HMETHOD" NUMBER(12,0),
	"FK_DATE_ACT_START" NUMBER(12,0),
	"FK_ACT_MEDIUM" NUMBER(12,0),
	"FK_ACT_MATRIX" NUMBER(12,0),
	"FK_ACT_INTENT" NUMBER(12,0),
	"FK_COMMUNITY_SAMPLED" NUMBER(12,0),
	"FK_GROUP_TYPE" NUMBER(12,0),
	"TSRUOM_ORG_ID" VARCHAR2(256 CHAR),
	"PORTABLE_DATA_LOGGER" VARCHAR2(34 CHAR),
	"FK_STN_ACT_PT" NUMBER(12,0),
	"FK_STATN_TYPES" NUMBER(12,0),
	"CONTAINER_DESC" VARCHAR2(256 CHAR),
	"TEMP_PRESERVN_TYPE" VARCHAR2(25 CHAR),
	"PRESRV_STRGE_PRCDR" VARCHAR2(256 CHAR),
	"BLOB_ID" VARCHAR2(25 CHAR),
	"BLOB_TITLE" VARCHAR2(256 CHAR),
	"ACT_BLOB_ID" VARCHAR2(25 CHAR),
	"ACT_BLOB_TITLE" VARCHAR2(256 CHAR),
	"ACTIVITY_COMMENT" VARCHAR2(4000 CHAR),
	"PROJECT_ID" VARCHAR2(256 CHAR),
	"TRIBAL_WATER_QUALITY_MEASURE" CHAR(1 CHAR),
	"ACTIVITY_COND_ORG_TEXT" VARCHAR2(256 CHAR),
	"SMPRP_TRANSPORT_STORAGE_DESC" VARCHAR2(1999 CHAR),
	"ETL_ID" VARCHAR2(256 CHAR),
	"TOW_CURRENT_SPEED" VARCHAR2(256 CHAR),
	"TOW_NET_MESH_SIZE" VARCHAR2(256 CHAR),
	"TOW_NET_SURFACE_AREA" VARCHAR2(256 CHAR),
	"NON_TOW_CURRENT_SPEED" VARCHAR2(256 CHAR),
	"NON_TOW_NET_MESH_SIZE" VARCHAR2(256 CHAR),
	"NON_TOW_NET_SURFACE_AREA" VARCHAR2(256 CHAR),
	"REACH_LENGTH" VARCHAR2(256 CHAR),
	"REACH_WIDTH" VARCHAR2(256 CHAR),
	"SAMPLE_COMPONENT_NAME" VARCHAR2(256 CHAR),
	"PLACE_IN_SERIES" VARCHAR2(256 CHAR),
	"TOXICITY_TEST_TYPE" VARCHAR2(256 CHAR),
	"HORIZONTAL_ACCURACY_MEASURE" VARCHAR2(256 CHAR),
	"LAB_ACCRED_AUTHORITY" VARCHAR2(256 CHAR),
	"SAMPLING_POINT_NAME" VARCHAR2(256 CHAR),
	"FK_DATE_LC" NUMBER(12,0),
	"SGO_INDICATOR" CHAR(1),
	"ORGANIZATION_IS_NUMBER" VARCHAR2(10),
	"ALL_RESULT_DETECTION_LIMIT" VARCHAR2(2000 CHAR),
	"ANALYSIS_DATE_TIME" DATE,
	"ANALYSIS_TIME_ZONE" VARCHAR2(256 CHAR),
	"ANALYTICAL_METHOD_LIST_AGENCY" VARCHAR2(256 CHAR),
	"ANALYTICAL_PROCEDURE_ID" VARCHAR2(256 CHAR),
	"ANALYTICAL_PROCEDURE_SOURCE" VARCHAR2(256 CHAR),
	"BIAS" VARCHAR2(256 CHAR),
	"BIOPART_NAME" VARCHAR2(30 CHAR),
	"CAS_NUMBER" VARCHAR2(500 CHAR),
	"CELL_FORM" VARCHAR2(256 CHAR),
	"CELL_SHAPE" VARCHAR2(256 CHAR),
	"CHARACTERISTIC_DESCRIPTION" VARCHAR2(256 CHAR),
	"CHARACTERISTIC_NAME" VARCHAR2(256 CHAR),
	"COMMON_CLASS_DESC" VARCHAR2(256 CHAR),
	"CONFIDENCE_LEVEL" VARCHAR2(256 CHAR),
	"DURATION_BASIS" VARCHAR2(256 CHAR),
	"FEEDING_GROUP" VARCHAR2(256 CHAR),
	"FK_BIOPART" NUMBER(12,0),
	"FK_CHAR" NUMBER(12,0),
	"FK_UNIT_CONVERSION" NUMBER(12,0),
	"HABIT" VARCHAR2(256 CHAR),
	"INDIVIDUAL_NUMBER" NUMBER,
	"LAB_CERTIFIED" VARCHAR2(1 CHAR),
	"LAB_NAME" VARCHAR2(60 CHAR),
	"LAB_REMARK" VARCHAR2(256 CHAR),
	"PARTICLE_SIZE" VARCHAR2(40 CHAR),
	"PHYS_BIO_INDICATOR" VARCHAR2(1 CHAR),
	"POLLUTION_TOLERANCE" VARCHAR2(256 CHAR),
	"PRECISION" VARCHAR2(256 CHAR),
	"PRIMARY_CLASS_DESC" VARCHAR2(256 CHAR),
	"RESULT_COMMENT" VARCHAR2(4000 CHAR),
	"RESULT_IS_NUMBER" NUMBER(12,0),
	"RESULT_MEAS_QUAL_CODE" VARCHAR2(256 CHAR),
	"RESULT_UNIT" VARCHAR2(256 CHAR),
	"RESULT_VALUE" NUMBER,
	"RESULT_VALUE_STATUS" VARCHAR2(12 CHAR),
	"RESULT_VALUE_TEXT" VARCHAR2(256 CHAR),
	"RESULT_VALUE_TYPE" VARCHAR2(256 CHAR),
	"SAMPLE_FRACTION_TYPE" VARCHAR2(256 CHAR),
	"SECONDARY_CLASS_DESC" VARCHAR2(256 CHAR),
	"STATISTIC_TYPE" VARCHAR2(256 CHAR),
	"STD_UNIT" VARCHAR2(240 CHAR),
	"STD_VALUE" NUMBER,
	"TEMPERATURE_BASIS_LEVEL" VARCHAR2(256 CHAR),
	"TROPHIC_LEVEL" VARCHAR2(256 CHAR),
	"VOLTINISM" VARCHAR2(256 CHAR),
	"WEIGHT_BASIS_TYPE" VARCHAR2(256 CHAR),
	"RESULT_DEPTH_ALT_REF_PT_TXT" VARCHAR2(256 CHAR),
	"RESULT_DEPTH_MEAS_VALUE" VARCHAR2(256 CHAR),
	"RESULT_DEPTH_MEAS_UNIT_CODE" VARCHAR2(256 CHAR),
	"LAB_SAMP_PRP_START_DATE_TIME" DATE,
	"LAB_SAMP_PRP_START_TMZONE" VARCHAR2(5 CHAR),
	"LAB_SAMP_PRP_END_DATE_TIME" DATE,
	"LAB_SAMP_PRP_END_TMZONE" VARCHAR2(5 CHAR),
	"LAB_SAMP_PRP_DILUTION_FACTOR" VARCHAR2(256 CHAR),
	"LAB_SAMP_PRP_METHOD_ID" VARCHAR2(256 CHAR),
	"LAB_SAMP_PRP_METHOD_CONTEXT" VARCHAR2(256 CHAR),
	"LAB_SAMP_PRP_METHOD_QUAL_TYPE" VARCHAR2(256 CHAR),
	"FREQUENCY_CLASS" VARCHAR2(256 CHAR),
	"LOWER_BOUND_AMOUNT" NUMBER,
	"UPPER_BOUND_AMOUNT" NUMBER,
	"SPECIES_ID" VARCHAR2(256 CHAR),
	"INDIVIDUAL_ID" VARCHAR2(256 CHAR),
	"POLLUTION_TOLERANCE_SCALE" VARCHAR2(256),
	"RESULT_GROUP_SUMMARY_CT_WT" VARCHAR2(256 CHAR),
	"TAXONOMIST_ACCRED_AUTHORITY" VARCHAR2(256 CHAR),
	"TAXONOMIST_ACCRED_YN" VARCHAR2(1 CHAR),
	"CONFIDENCE_INTERVAL" VARCHAR2(256),
	"UPPER_CONF_LIMIT" VARCHAR2(256),
	"LOWER_CONF_LIMIT" VARCHAR2(256),
	"LAB_ID" CHAR(8 CHAR),
	"LAB_BATCH_ID" CHAR(12 CHAR),
	"CORRECTION_INDICATOR" VARCHAR2(1 CHAR),
	"RECOVERY_INDICATOR" VARCHAR2(1 CHAR),
	"DILUTION_INDICATOR" VARCHAR2(1 CHAR),
	"TEXT_RESULT" VARCHAR2(4000 CHAR),
	"ANALYTICAL_METHOD_LIST_VER" VARCHAR2(256),
	"METRIC_DETAIL_CITATION_ID" VARCHAR2(256 CHAR),
	"TAXON_DETAIL_CITATION_ID" VARCHAR2(256 CHAR)
   ) ;
  ALTER TABLE "STORETW"."FA_ACTIVITY_METRIC" ADD CONSTRAINT "PK_ACTMET" PRIMARY KEY ("PK_ISN") ENABLE;


  CREATE UNIQUE INDEX "STORETW"."PK_ACTMET" ON "STORETW"."FA_ACTIVITY_METRIC" ("PK_ISN")
  ;


  CREATE INDEX "STORETW"."DBSS_FA_ACTIVITY_METRIC_NDX1" ON "STORETW"."FA_ACTIVITY_METRIC" ("SOURCE_ACT_UID", "SOURCE_SYSTEM")
  ;


  CREATE INDEX "STORETW"."IFAM_LT_ORG_ID" ON "STORETW"."FA_ACTIVITY_METRIC" (LOWER(TRIM("ORGANIZATION_ID")))
  ;


  CREATE INDEX "STORETW"."IFAM_LT_STN_ID_OID" ON "STORETW"."FA_ACTIVITY_METRIC" (LOWER(TRIM("STATION_ID")), LOWER(TRIM("ORGANIZATION_ID")))
  ;


  CREATE INDEX "STORETW"."IAM_INDEX3" ON "STORETW"."FA_ACTIVITY_METRIC" ("ACTIVITY_ID", "ACTIVITY_ISN")
  ;


  CREATE INDEX "STORETW"."IAM_FK_METNAME_OID" ON "STORETW"."FA_ACTIVITY_METRIC" (LOWER(TRIM("METRIC_NAME")), LOWER(TRIM("ORGANIZATION_ID")))
  ;


  CREATE INDEX "STORETW"."IAM_FK_METTYPEID_OID" ON "STORETW"."FA_ACTIVITY_METRIC" (LOWER(TRIM("METRICTYPE_ID")), LOWER(TRIM("ORGANIZATION_ID")))
  ;


  CREATE INDEX "STORETW"."IAM_FK_METNAME" ON "STORETW"."FA_ACTIVITY_METRIC" (LOWER(TRIM("METRIC_NAME")))
  ;


  CREATE INDEX "STORETW"."IAM_FK_METTYPEID" ON "STORETW"."FA_ACTIVITY_METRIC" (LOWER(TRIM("METRICTYPE_ID")))
  ;


  CREATE INDEX "STORETW"."IAM_STN_ACT_PT" ON "STORETW"."FA_ACTIVITY_METRIC" ("FK_STN_ACT_PT")
  ;


  CREATE INDEX "STORETW"."IAM_DATE_LAT_LONG" ON "STORETW"."FA_ACTIVITY_METRIC" ("FK_DATE_ACT_START", "STN_LATITUDE", "STN_LONGITUDE")
  ;


  CREATE INDEX "STORETW"."IAM_LAT_LONG" ON "STORETW"."FA_ACTIVITY_METRIC" ("STN_LATITUDE", "STN_LONGITUDE")
  ;


  CREATE INDEX "STORETW"."IAM_HUC" ON "STORETW"."FA_ACTIVITY_METRIC" ("GENERATED_HUC")
  ;


  CREATE INDEX "STORETW"."IAM_STATION" ON "STORETW"."FA_ACTIVITY_METRIC" ("FK_STATION")
  ;


  CREATE INDEX "STORETW"."IAM_GEN_DB_CAT" ON "STORETW"."FA_ACTIVITY_METRIC" ("FK_GEN_DB_CAT")
  ;


  CREATE INDEX "STORETW"."IAM_DB_CAT" ON "STORETW"."FA_ACTIVITY_METRIC" ("FK_DB_CAT")
  ;


  CREATE INDEX "STORETW"."IAM_GEO2" ON "STORETW"."FA_ACTIVITY_METRIC" ("FK_GEO_COUNTY")
  ;


  CREATE INDEX "STORETW"."IAM_ACTIVITY_ISN" ON "STORETW"."FA_ACTIVITY_METRIC" ("ACTIVITY_ISN")
  ;


  CREATE INDEX "STORETW"."IAM_DATE" ON "STORETW"."FA_ACTIVITY_METRIC" ("FK_DATE_ACT_START")
  ;


  CREATE INDEX "STORETW"."IAM_ACT_IS_NUM_ORG_ID" ON "STORETW"."FA_ACTIVITY_METRIC" ("ACTIVITY_IS_NUMBER", "ORGANIZATION_ID")
  ;


  ALTER TABLE "STORETW"."FA_ACTIVITY_METRIC" ADD CONSTRAINT "AM_FK_ACTIVITY_INTENT" FOREIGN KEY ("FK_ACT_INTENT")
	  REFERENCES "STORETW"."DI_ACTIVITY_INTENT" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_ACTIVITY_METRIC" ADD CONSTRAINT "AM_FK_ACT_MAD_HDATUM" FOREIGN KEY ("FK_ACT_MAD_HDATUM")
	  REFERENCES "STORETW"."LU_MAD_HDATUM" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_ACTIVITY_METRIC" ADD CONSTRAINT "AM_FK_ACT_MAD_HMETHOD" FOREIGN KEY ("FK_ACT_MAD_HMETHOD")
	  REFERENCES "STORETW"."LU_MAD_HMETHOD" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_ACTIVITY_METRIC" ADD CONSTRAINT "AM_FK_ACT_MEDIUM" FOREIGN KEY ("FK_ACT_MEDIUM")
	  REFERENCES "STORETW"."DI_ACTIVITY_MEDIUM" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_ACTIVITY_METRIC" ADD CONSTRAINT "AM_FK_BIOPART" FOREIGN KEY ("FK_BIOPART")
	  REFERENCES "STORETW"."DI_BIOPART" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_ACTIVITY_METRIC" ADD CONSTRAINT "AM_FK_CHAR" FOREIGN KEY ("FK_CHAR")
	  REFERENCES "STORETW"."DI_CHARACTERISTIC" ("PK_ISN") ENABLE;
  ALTER TABLE "STORETW"."FA_ACTIVITY_METRIC" ADD CONSTRAINT "AM_FK_COMMUNITY_SAMPLED" FOREIGN KEY ("FK_COMMUNITY_SAMPLED")
	  REFERENCES "STORETW"."DI_COMMUNITY_SAMPLED" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_ACTIVITY_METRIC" ADD CONSTRAINT "AM_FK_DATE_ACT_START" FOREIGN KEY ("FK_DATE_ACT_START")
	  REFERENCES "STORETW"."DI_DATE" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_ACTIVITY_METRIC" ADD CONSTRAINT "AM_FK_DATE_LC" FOREIGN KEY ("FK_DATE_LC")
	  REFERENCES "STORETW"."DI_DATE" ("PK_ISN") ENABLE;
  ALTER TABLE "STORETW"."FA_ACTIVITY_METRIC" ADD CONSTRAINT "AM_FK_GROUP_TYPE" FOREIGN KEY ("FK_GROUP_TYPE")
	  REFERENCES "STORETW"."DI_GROUP_TYPE" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_ACTIVITY_METRIC" ADD CONSTRAINT "AM_FK_SD_DB_CAT" FOREIGN KEY ("FK_DB_CAT")
	  REFERENCES "STORETW"."DI_DB_CAT" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_ACTIVITY_METRIC" ADD CONSTRAINT "AM_FK_SD_GEN_DB_CAT" FOREIGN KEY ("FK_GEN_DB_CAT")
	  REFERENCES "STORETW"."DI_DB_CAT" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_ACTIVITY_METRIC" ADD CONSTRAINT "AM_FK_SD_GEO_COUNTY" FOREIGN KEY ("FK_GEO_COUNTY")
	  REFERENCES "STORETW"."DI_GEO_COUNTY" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_ACTIVITY_METRIC" ADD CONSTRAINT "AM_FK_SD_GEO_STATE" FOREIGN KEY ("FK_GEO_STATE")
	  REFERENCES "STORETW"."DI_GEO_STATE" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_ACTIVITY_METRIC" ADD CONSTRAINT "AM_FK_STATN_TYPES" FOREIGN KEY ("FK_STATN_TYPES")
	  REFERENCES "STORETW"."DI_STATN_TYPES" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_ACTIVITY_METRIC" ADD CONSTRAINT "AM_FK_UNIT_CONVERSION" FOREIGN KEY ("FK_UNIT_CONVERSION")
	  REFERENCES "STORETW"."LU_UNIT_CONVERSION" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_ACTIVITY_METRIC" ADD CONSTRAINT "FK_ACTMET_ORG" FOREIGN KEY ("FK_ORG")
	  REFERENCES "STORETW"."DI_ORG" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_ACTIVITY_METRIC" ADD CONSTRAINT "FK_METTYP" FOREIGN KEY ("FK_METRICTYPE")
	  REFERENCES "STORETW"."LU_METRICTYPE" ("PK_ISN") DISABLE;

