
  CREATE TABLE "STORETW"."FA_BIO_HABITAT_INDEX"
   (	"PK_ISN" NUMBER NOT NULL ENABLE,
	"ORGANIZATION_ID" VARCHAR2(256 CHAR),
	"STATION_ID" VARCHAR2(256 CHAR),
	"BIOHAB_INDEX_ID" VARCHAR2(256 CHAR),
	"CALCULATED_DATE" VARCHAR2(10 CHAR),
	"QUALIFIER_CODE" VARCHAR2(256 CHAR),
	"BHI_SCORE" VARCHAR2(256 CHAR),
	"INDEXTYPE_ID" VARCHAR2(256 CHAR),
	"FK_INDEX" NUMBER(12,0),
	"FK_ORG" NUMBER(12,0),
	"FK_STATION" NUMBER(12,0),
	"SOURCE_SYSTEM" VARCHAR2(256),
	"SOURCE_UID" NUMBER,
	"BIOHAB_INDEX_COMMENT" VARCHAR2(4000),
	"LAST_TRANSACTION_ID" VARCHAR2(100 CHAR),
	"LAST_USERID" VARCHAR2(100 CHAR),
	"LAST_CHANGE_DATE" DATE,
	"INDEXTYPE_NAME" VARCHAR2(256 CHAR),
	"BIOHAB_INDEX_TYPE_SCALE" VARCHAR2(256 CHAR),
	"CITATION_ID" VARCHAR2(256 CHAR),
	"FK_DATE_LC" NUMBER(12,0)
   ) ;
  ALTER TABLE "STORETW"."FA_BIO_HABITAT_INDEX" ADD CONSTRAINT "PK_BIO_HABITAT_IDX" PRIMARY KEY ("PK_ISN") ENABLE;


  CREATE UNIQUE INDEX "STORETW"."PK_BIO_HABITAT_IDX" ON "STORETW"."FA_BIO_HABITAT_INDEX" ("PK_ISN")
  ;


  CREATE INDEX "STORETW"."IBHI_SOURCEUID" ON "STORETW"."FA_BIO_HABITAT_INDEX" ("SOURCE_SYSTEM", "SOURCE_UID")
  ;


  ALTER TABLE "STORETW"."FA_BIO_HABITAT_INDEX" ADD CONSTRAINT "FK_BIO_HB_IDX_ORG" FOREIGN KEY ("FK_ORG")
	  REFERENCES "STORETW"."DI_ORG" ("PK_ISN") ENABLE;
  ALTER TABLE "STORETW"."FA_BIO_HABITAT_INDEX" ADD CONSTRAINT "FK_IDXTYP" FOREIGN KEY ("FK_INDEX")
	  REFERENCES "STORETW"."LU_INDEXTYPE" ("PK_ISN") ENABLE;

