
  CREATE TABLE "STORETW"."FA_BIOLOGICAL_RESULT"
   (	"PK_ISN" NUMBER NOT NULL DISABLE,
	"ORGANIZATION_ID" VARCHAR2(256),
	"ORGANIZATION_IS_NUMBER" NUMBER(20,0),
	"STATION_ID" VARCHAR2(256 CHAR),
	"STATION_NAME" VARCHAR2(256),
	"STN_LATITUDE" NUMBER,
	"STN_LONGITUDE" NUMBER,
	"STN_HDATUM" CHAR(12),
	"STN_STD_LATITUDE" NUMBER,
	"STN_STD_LONGITUDE" NUMBER,
	"STN_STD_HDATUM" CHAR(12),
	"HYDROLOGIC_UNIT_CODE" CHAR(8),
	"GENERATED_HUC" CHAR(8),
	"SGO_INDICATOR" CHAR(1),
	"STATION_VISIT_ID" CHAR(3),
	"VISIT_START_DATE_TIME" DATE,
	"VISIT_START_TIME_ZONE" CHAR(3),
	"VISIT_STOP_DATE_TIME" DATE,
	"VISIT_STOP_TIME_ZONE" CHAR(3),
	"TRIP_ID" VARCHAR2(256),
	"TRIP_NAME" VARCHAR2(256),
	"ACTIVITY_ID" VARCHAR2(256),
	"ACTIVITY_START_DATE_TIME" DATE,
	"ACT_START_TIME_ZONE" VARCHAR2(256),
	"ACTIVITY_STOP_DATE_TIME" DATE,
	"ACT_STOP_TIME_ZONE" VARCHAR2(256),
	"ACTIVITY_MEDIUM" VARCHAR2(20),
	"ACTIVITY_TYPE" VARCHAR2(256),
	"ACTIVITY_CATEGORY" VARCHAR2(256),
	"REPLICATE_NUMBER" NUMBER(3,0),
	"ACTIVITY_INTENT" VARCHAR2(20),
	"ACTIVITY_COMMUNITY" VARCHAR2(256),
	"ACTIVITY_SUBJECT_TAXON" VARCHAR2(69),
	"BIOPART_NAME" VARCHAR2(30),
	"FIELD_SET" VARCHAR2(130),
	"LOCATION_POINT_TYPE" CHAR(16),
	"POINT_SEQUENCE_NUMBER" NUMBER,
	"POINT_NAME" VARCHAR2(30),
	"ACTIVITY_LATITUDE" NUMBER,
	"ACTIVITY_LONGITUDE" NUMBER,
	"ACT_STD_LATITUDE" NUMBER,
	"ACT_STD_LONGITUDE" NUMBER,
	"ACT_STD_HDATUM" CHAR(12),
	"WELL_NUMBER" CHAR(15),
	"PIPE_NUMBER" CHAR(15),
	"MAP_SCALE" VARCHAR2(20),
	"ACTIVITY_DEPTH" VARCHAR2(256),
	"ACTIVITY_DEPTH_UNIT" VARCHAR2(256),
	"ACTIVITY_UPPER_DEPTH" VARCHAR2(256),
	"ACTIVITY_REL_DEPTH" CHAR(15),
	"ACTIVITY_LOWER_DEPTH" VARCHAR2(256),
	"UPR_LWR_DEPTH_UNIT" VARCHAR2(256),
	"FIELD_PROCEDURE_ID" VARCHAR2(256),
	"FIELD_GEAR_ID" VARCHAR2(256),
	"GEAR_CONFIG_ID" VARCHAR2(256),
	"CHARACTERISTIC_GROUP_TYPE" VARCHAR2(256 CHAR),
	"CHARACTERISTIC_NAME" VARCHAR2(256 CHAR),
	"CAS_NUMBER" VARCHAR2(500),
	"EPA_REG_NUMBER" VARCHAR2(500),
	"ITIS_NUMBER" VARCHAR2(500),
	"SAMPLE_FRACTION_TYPE" VARCHAR2(256),
	"RESULT_VALUE_TYPE" VARCHAR2(256),
	"STATISTIC_TYPE" VARCHAR2(256),
	"RESULT_VALUE_TEXT" VARCHAR2(256),
	"RESULT_VALUE" NUMBER,
	"RESULT_UNIT" VARCHAR2(256),
	"STD_VALUE" NUMBER,
	"STD_UNIT" VARCHAR2(240),
	"RESULT_COMMENT" VARCHAR2(4000),
	"TEXT_RESULT" VARCHAR2(4000),
	"WEIGHT_BASIS_TYPE" VARCHAR2(256),
	"TEMPERATURE_BASIS_LEVEL" VARCHAR2(256),
	"DURATION_BASIS" VARCHAR2(256),
	"PARTICLE_SIZE" VARCHAR2(40),
	"DISTANCE_MEASURE_FROM" VARCHAR2(20),
	"DISTANCE_MEASURE_TO" VARCHAR2(20),
	"ANALYTICAL_PROCEDURE_SOURCE" VARCHAR2(256),
	"ANALYTICAL_PROCEDURE_ID" VARCHAR2(256),
	"DETECTION_LIMIT" VARCHAR2(25),
	"DETECTION_LIMIT_DESCRIPTION" VARCHAR2(256),
	"LOWER_QUANTITATION_LIMIT" CHAR(30 CHAR),
	"UPPER_QUANTITATION_LIMIT" CHAR(30 CHAR),
	"LAB_REMARK" VARCHAR2(256),
	"DILUTION_INDICATOR" CHAR(1),
	"RECOVERY_INDICATOR" CHAR(1),
	"CORRECTION_INDICATOR" CHAR(1),
	"LAB_ID" CHAR(8),
	"LAB_NAME" VARCHAR2(60),
	"LAB_CERTIFIED" VARCHAR2(1),
	"LAB_BATCH_ID" CHAR(12),
	"ANALYSIS_DATE_TIME" DATE,
	"ANALYSIS_TIME_ZONE" VARCHAR2(256),
	"REPLICATE_ANALYSIS_COUNT" NUMBER,
	"PRECISION" VARCHAR2(256),
	"BIAS" VARCHAR2(256),
	"CONFIDENCE_LEVEL" VARCHAR2(256),
	"CONF_LVL_CORR_BIAS" CHAR(1),
	"TR_START_POINT_NAME" VARCHAR2(30),
	"TR_START_LATITUDE" NUMBER,
	"TR_START_LONGITUDE" NUMBER,
	"TR_START_HDATUM" CHAR(12),
	"TR_START_DEPTH" CHAR(15),
	"TR_START_STD_LATITUDE" NUMBER,
	"TR_START_STD_LONGITUDE" NUMBER,
	"TR_START_STD_HDATUM" CHAR(12),
	"TR_STOP_POINT_NAME" VARCHAR2(30),
	"TR_STOP_LATITUDE" NUMBER,
	"TR_STOP_LONGITUDE" NUMBER,
	"TR_STOP_HDATUM" CHAR(12),
	"TR_STOP_DEPTH" CHAR(15),
	"TR_STOP_STD_LATITUDE" NUMBER,
	"TR_STOP_STD_LONGITUDE" NUMBER,
	"TR_STOP_STD_HDATUM" CHAR(12),
	"FISHED_DURATION" CHAR(15),
	"BOAT_SPEED" CHAR(15),
	"FISHED_DISTANCE" CHAR(10),
	"REL_CURRENT_DIR" NUMBER(3,0),
	"REL_WIND_DIR" NUMBER(3,0),
	"TRAWL_COMMENT" VARCHAR2(254),
	"VOLTAGE_MEASURE" NUMBER(6,3),
	"CURRENT_TYPE_CODE" CHAR(2),
	"AMPERAGE_MEASURE" NUMBER(6,3),
	"PASS_COUNT" NUMBER,
	"PASS_LENGTH" CHAR(10),
	"PULSE_RATE" NUMBER(3,0),
	"ELECTROSHOCK_COMMENT" VARCHAR2(254),
	"TOTAL_ENERGZD_TIME" CHAR(15),
	"SAMPLING_DURATION" VARCHAR2(256),
	"ORIENTATION_TO_CURRENT" CHAR(15),
	"TRAP_NET_COMMENT" VARCHAR2(254),
	"BIO_GROUP_ID" CHAR(8),
	"BIO_GROUP_TYPE" VARCHAR2(32),
	"BIO_GROUP_SUBJECT_TXN" VARCHAR2(69),
	"BIO_GROUP_DESCRIPTION" VARCHAR2(1999),
	"FEEDING_GROUP" VARCHAR2(256),
	"POLLUTION_TOLERANCE" VARCHAR2(256),
	"TROPHIC_LEVEL" VARCHAR2(256),
	"HABIT" VARCHAR2(256),
	"VOLTINISM" VARCHAR2(256),
	"CELL_SHAPE" VARCHAR2(256),
	"CELL_FORM" VARCHAR2(256),
	"NUMBER_IN_GROUP" NUMBER,
	"BIO_GROUP_COUNT_TYPE" CHAR(10),
	"PHYS_BIO_INDICATOR" CHAR(1),
	"GROUP_DESC_SEX" CHAR(15),
	"GROUP_DESC_LIFESTAGE" VARCHAR2(25),
	"COMMON_CLASS_DESC" VARCHAR2(256),
	"PRIMARY_CLASS_DESC" VARCHAR2(256),
	"SECONDARY_CLASS_DESC" VARCHAR2(256),
	"LOWER_BOUND_AMOUNT" NUMBER,
	"UPPER_BOUND_AMOUNT" NUMBER,
	"BIO_RCI_UNITS" CHAR(10),
	"INDIVIDUAL_NUMBER" NUMBER,
	"RESULT_VALUE_STATUS" VARCHAR2(12 CHAR),
	"ACTIVITY_IS_NUMBER" NUMBER(12,0),
	"RESULT_IS_NUMBER" NUMBER(12,0),
	"ACTIVITY_ISN" NUMBER,
	"FK_ORG" NUMBER(12,0),
	"FK_STATION" NUMBER(12,0),
	"FK_CHAR" NUMBER(12,0),
	"FK_DB_CAT" NUMBER(12,0),
	"FK_GEN_DB_CAT" NUMBER(12,0),
	"FK_GEO_COUNTY" NUMBER(12,0),
	"FK_GEO_STATE" NUMBER(12,0),
	"FK_ACT_MAD_HDATUM" NUMBER(12,0),
	"FK_ACT_MAD_HMETHOD" NUMBER(12,0),
	"FK_DATE_ACT_START" NUMBER(12,0),
	"FK_ACT_MEDIUM" NUMBER(12,0),
	"FK_ACT_INTENT" NUMBER(12,0),
	"FK_COMMUNITY_SAMPLED" NUMBER(12,0),
	"FK_SUBJECT_TAXON" NUMBER(12,0),
	"FK_BIOPART" NUMBER(12,0),
	"FK_GROUP_TYPE" NUMBER(12,0),
	"FK_UNIT_CONVERSION" NUMBER(12,0),
	"TSRUOM_ORG_ID" VARCHAR2(256),
	"FK_STN_ACT_PT" NUMBER(12,0),
	"FK_STATN_TYPES" NUMBER(12,0),
	"LAST_USERID" VARCHAR2(100),
	"LAST_CHANGE_DATE" DATE DEFAULT systimestamp,
	"CONTAINER_DESC" VARCHAR2(256),
	"TEMP_PRESERVN_TYPE" VARCHAR2(25),
	"PRESRV_STRGE_PRCDR" VARCHAR2(256 CHAR),
	"BLOB_ID" VARCHAR2(25),
	"BLOB_TITLE" VARCHAR2(256),
	"ACT_BLOB_ID" VARCHAR2(25),
	"ACT_BLOB_TITLE" VARCHAR2(256),
	"ACTIVITY_COMMENT" VARCHAR2(4000 CHAR),
	"ACTIVITY_DEPTH_REF_POINT" VARCHAR2(256),
	"PROJECT_ID" VARCHAR2(4000 CHAR),
	"TRIBAL_WATER_QUALITY_MEASURE" CHAR(1 CHAR),
	"ACTIVITY_COND_ORG_TEXT" VARCHAR2(256 CHAR),
	"RESULT_MEAS_QUAL_CODE" VARCHAR2(256 CHAR),
	"RESULT_DEPTH_MEAS_VALUE" VARCHAR2(256 CHAR),
	"RESULT_DEPTH_MEAS_UNIT_CODE" VARCHAR2(256 CHAR),
	"RESULT_DEPTH_ALT_REF_PT_TXT" VARCHAR2(256 CHAR),
	"ANALYTICAL_METHOD_LIST_AGENCY" VARCHAR2(256),
	"ANALYTICAL_METHOD_LIST_VER" VARCHAR2(256),
	"SMPRP_TRANSPORT_STORAGE_DESC" VARCHAR2(1999),
	"SOURCE_SYSTEM" VARCHAR2(256 CHAR),
	"SOURCE_UID" NUMBER(20,0),
	"ETL_ID" VARCHAR2(256),
	"TOW_CURRENT_SPEED" VARCHAR2(256),
	"TOW_NET_MESH_SIZE" VARCHAR2(256),
	"TOW_NET_SURFACE_AREA" VARCHAR2(256),
	"NON_TOW_CURRENT_SPEED" VARCHAR2(256),
	"NON_TOW_NET_MESH_SIZE" VARCHAR2(256),
	"NON_TOW_NET_SURFACE_AREA" VARCHAR2(256),
	"REACH_LENGTH" VARCHAR2(256),
	"REACH_WIDTH" VARCHAR2(256),
	"SAMPLE_COMPONENT_NAME" VARCHAR2(256),
	"PLACE_IN_SERIES" VARCHAR2(256),
	"TOXICITY_TEST_TYPE" VARCHAR2(256),
	"HORIZONTAL_ACCURACY_MEASURE" VARCHAR2(256),
	"LAB_ACCRED_AUTHORITY" VARCHAR2(256),
	"SUBSTANCE_DILUTION_FACTOR" VARCHAR2(256),
	"TAXONOMIST_ACCRED_AUTHORITY" VARCHAR2(256),
	"TAXONOMIST_ACCRED_YN" VARCHAR2(256),
	"TAXON_DETAIL_CITATION_ID" VARCHAR2(256),
	"POLLUTION_TOLERANCE_SCALE" VARCHAR2(256),
	"RESULT_GROUP_SUMMARY_CT_WT" VARCHAR2(256),
	"LAB_SAMP_PRP_METHOD_ID" VARCHAR2(256),
	"LAB_SAMP_PRP_METHOD_CONTEXT" VARCHAR2(256),
	"LAB_SAMP_PRP_METHOD_QUAL_TYPE" VARCHAR2(256),
	"LAB_SAMP_PRP_START_DATE_TIME" DATE,
	"LAB_SAMP_PRP_START_TMZONE" VARCHAR2(256),
	"LAB_SAMP_PRP_END_DATE_TIME" DATE,
	"LAB_SAMP_PRP_END_TMZONE" VARCHAR2(256),
	"LAB_SAMP_PRP_DILUTION_FACTOR" VARCHAR2(256),
	"SAMPLING_POINT_NAME" VARCHAR2(256),
	"LAST_TRANSACTION_ID" VARCHAR2(100),
	"CHARACTERISTIC_DESCRIPTION" VARCHAR2(256),
	"FK_DATE_LC" NUMBER(12,0),
	"DETECTION_LIMIT_UNIT" CHAR(10),
	"ALL_RESULT_DETECTION_LIMIT" VARCHAR2(2000),
	"FREQUENCY_CLASS" VARCHAR2(256 CHAR),
	"SPECIES_ID" VARCHAR2(256 CHAR),
	"INDIVIDUAL_ID" VARCHAR2(256 CHAR),
	"CONFIDENCE_INTERVAL" VARCHAR2(256),
	"UPPER_CONF_LIMIT" VARCHAR2(256),
	"LOWER_CONF_LIMIT" VARCHAR2(256)
   ) ;
  ALTER TABLE "STORETW"."FA_BIOLOGICAL_RESULT" ADD CONSTRAINT "PK_BIOLOGICAL_RESULT" PRIMARY KEY ("PK_ISN") ENABLE;


  CREATE BITMAP INDEX "STORETW"."IBR_OID" ON "STORETW"."FA_BIOLOGICAL_RESULT" ("ORGANIZATION_ID")
  ;


  CREATE BITMAP INDEX "STORETW"."IBR_FK_STATN_TYPES" ON "STORETW"."FA_BIOLOGICAL_RESULT" ("FK_STATN_TYPES")
  ;


  CREATE BITMAP INDEX "STORETW"."IBR_FK_ORG" ON "STORETW"."FA_BIOLOGICAL_RESULT" ("FK_ORG")
  ;


  CREATE BITMAP INDEX "STORETW"."IBR_FK_ACT_INTENT" ON "STORETW"."FA_BIOLOGICAL_RESULT" ("FK_ACT_INTENT")
  ;


  CREATE BITMAP INDEX "STORETW"."IBR_FK_COMMUNITY_SAMPLED" ON "STORETW"."FA_BIOLOGICAL_RESULT" ("FK_COMMUNITY_SAMPLED")
  ;


  CREATE BITMAP INDEX "STORETW"."IBR_FK_ACT_MEDIUM" ON "STORETW"."FA_BIOLOGICAL_RESULT" ("FK_ACT_MEDIUM")
  ;


  CREATE BITMAP INDEX "STORETW"."IBR_FK_CHAR" ON "STORETW"."FA_BIOLOGICAL_RESULT" ("FK_CHAR")
  ;


  CREATE BITMAP INDEX "STORETW"."IBR_FK_DATE_ACT_START" ON "STORETW"."FA_BIOLOGICAL_RESULT" ("FK_DATE_ACT_START")
  ;


  CREATE BITMAP INDEX "STORETW"."IBR_FK_GEN_DB_CAT" ON "STORETW"."FA_BIOLOGICAL_RESULT" ("FK_GEN_DB_CAT")
  ;


  CREATE BITMAP INDEX "STORETW"."IBR_FK_GEO_COUNTY" ON "STORETW"."FA_BIOLOGICAL_RESULT" ("FK_GEO_COUNTY")
  ;


  CREATE BITMAP INDEX "STORETW"."IBR_FK_GEO_STATE" ON "STORETW"."FA_BIOLOGICAL_RESULT" ("FK_GEO_STATE")
  ;


  CREATE BITMAP INDEX "STORETW"."IBR_FK_STATION" ON "STORETW"."FA_BIOLOGICAL_RESULT" ("FK_STATION")
  ;


  CREATE UNIQUE INDEX "STORETW"."PK_BIOLOGICAL_RESULT" ON "STORETW"."FA_BIOLOGICAL_RESULT" ("PK_ISN")
  ;


  CREATE INDEX "STORETW"."IBR_ACT_IS_NUM_ORG_ID" ON "STORETW"."FA_BIOLOGICAL_RESULT" ("ACTIVITY_IS_NUMBER", "ORGANIZATION_ID")
  ;


  CREATE INDEX "STORETW"."IFBR_LCDATE" ON "STORETW"."FA_BIOLOGICAL_RESULT" ("LAST_CHANGE_DATE")
  ;


  CREATE INDEX "STORETW"."IBR_HUC" ON "STORETW"."FA_BIOLOGICAL_RESULT" ("GENERATED_HUC")
  ;


  CREATE INDEX "STORETW"."I_FA_BIO_RESULT_SOURCEUID" ON "STORETW"."FA_BIOLOGICAL_RESULT" ("SOURCE_SYSTEM", "SOURCE_UID")
  ;


  CREATE INDEX "STORETW"."IBR_LAT_LONG" ON "STORETW"."FA_BIOLOGICAL_RESULT" ("STN_LATITUDE", "STN_LONGITUDE")
  ;


  CREATE INDEX "STORETW"."IBR_ACTIVITY_ISN" ON "STORETW"."FA_BIOLOGICAL_RESULT" ("ACTIVITY_ISN")
  ;


  CREATE INDEX "STORETW"."IBR_LBRMK_01" ON "STORETW"."FA_BIOLOGICAL_RESULT" ("RESULT_IS_NUMBER", "ORGANIZATION_ID")
  ;


  ALTER TABLE "STORETW"."FA_BIOLOGICAL_RESULT" ADD CONSTRAINT "BR_FK_ACTIVITY_INTENT" FOREIGN KEY ("FK_ACT_INTENT")
	  REFERENCES "STORETW"."DI_ACTIVITY_INTENT" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_BIOLOGICAL_RESULT" ADD CONSTRAINT "BR_FK_ACT_MAD_HDATUM" FOREIGN KEY ("FK_ACT_MAD_HDATUM")
	  REFERENCES "STORETW"."LU_MAD_HDATUM" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_BIOLOGICAL_RESULT" ADD CONSTRAINT "BR_FK_ACT_MAD_HMETHOD" FOREIGN KEY ("FK_ACT_MAD_HMETHOD")
	  REFERENCES "STORETW"."LU_MAD_HMETHOD" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_BIOLOGICAL_RESULT" ADD CONSTRAINT "BR_FK_ACT_MEDIUM" FOREIGN KEY ("FK_ACT_MEDIUM")
	  REFERENCES "STORETW"."DI_ACTIVITY_MEDIUM" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_BIOLOGICAL_RESULT" ADD CONSTRAINT "BR_FK_BIOPART" FOREIGN KEY ("FK_BIOPART")
	  REFERENCES "STORETW"."DI_BIOPART" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_BIOLOGICAL_RESULT" ADD CONSTRAINT "BR_FK_COMMUNITY_SAMPLED" FOREIGN KEY ("FK_COMMUNITY_SAMPLED")
	  REFERENCES "STORETW"."DI_COMMUNITY_SAMPLED" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_BIOLOGICAL_RESULT" ADD CONSTRAINT "BR_FK_DATE_ACT_START" FOREIGN KEY ("FK_DATE_ACT_START")
	  REFERENCES "STORETW"."DI_DATE" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_BIOLOGICAL_RESULT" ADD CONSTRAINT "BR_FK_DATE_LC" FOREIGN KEY ("FK_DATE_LC")
	  REFERENCES "STORETW"."DI_DATE" ("PK_ISN") ENABLE;
  ALTER TABLE "STORETW"."FA_BIOLOGICAL_RESULT" ADD CONSTRAINT "BR_FK_GROUP_TYPE" FOREIGN KEY ("FK_GROUP_TYPE")
	  REFERENCES "STORETW"."DI_GROUP_TYPE" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_BIOLOGICAL_RESULT" ADD CONSTRAINT "BR_FK_SD_DB_CAT" FOREIGN KEY ("FK_DB_CAT")
	  REFERENCES "STORETW"."DI_DB_CAT" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_BIOLOGICAL_RESULT" ADD CONSTRAINT "BR_FK_SD_GEN_DB_CAT" FOREIGN KEY ("FK_GEN_DB_CAT")
	  REFERENCES "STORETW"."DI_DB_CAT" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_BIOLOGICAL_RESULT" ADD CONSTRAINT "BR_FK_SD_GEO_COUNTY" FOREIGN KEY ("FK_GEO_COUNTY")
	  REFERENCES "STORETW"."DI_GEO_COUNTY" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_BIOLOGICAL_RESULT" ADD CONSTRAINT "BR_FK_SD_GEO_STATE" FOREIGN KEY ("FK_GEO_STATE")
	  REFERENCES "STORETW"."DI_GEO_STATE" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_BIOLOGICAL_RESULT" ADD CONSTRAINT "BR_FK_SD_ORG" FOREIGN KEY ("FK_ORG")
	  REFERENCES "STORETW"."DI_ORG" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_BIOLOGICAL_RESULT" ADD CONSTRAINT "BR_FK_STATN_TYPES" FOREIGN KEY ("FK_STATN_TYPES")
	  REFERENCES "STORETW"."DI_STATN_TYPES" ("PK_ISN") DISABLE;

