
  CREATE TABLE "STORETW"."FA_REGULAR_RESULT"
   (	"PK_ISN" NUMBER NOT NULL DISABLE,
	"ORGANIZATION_ID" VARCHAR2(256),
	"ORGANIZATION_IS_NUMBER" NUMBER(20,0),
	"STATION_ID" VARCHAR2(256 CHAR),
	"STATION_NAME" VARCHAR2(256),
	"ACTIVITY_START_DATE_TIME" DATE,
	"ACT_START_TIME_ZONE" VARCHAR2(256),
	"TRIP_ID" VARCHAR2(256),
	"TRIP_NAME" VARCHAR2(256),
	"STATION_VISIT_ID" CHAR(3 CHAR),
	"CHARACTERISTIC_GROUP_TYPE" VARCHAR2(256 CHAR),
	"CHARACTERISTIC_NAME" VARCHAR2(256 CHAR),
	"RESULT_VALUE" NUMBER,
	"RESULT_UNIT" VARCHAR2(256),
	"RESULT_VALUE_TEXT" VARCHAR2(256),
	"SAMPLE_FRACTION_TYPE" VARCHAR2(256),
	"RESULT_VALUE_TYPE" VARCHAR2(256),
	"STATISTIC_TYPE" VARCHAR2(256),
	"RESULT_VALUE_STATUS" VARCHAR2(12 CHAR),
	"WEIGHT_BASIS_TYPE" VARCHAR2(256),
	"TEMPERATURE_BASIS_LEVEL" VARCHAR2(256),
	"DURATION_BASIS" VARCHAR2(256),
	"ANALYTICAL_PROCEDURE_SOURCE" VARCHAR2(256),
	"ANALYTICAL_PROCEDURE_ID" VARCHAR2(256),
	"LAB_ID" CHAR(8 CHAR),
	"LAB_NAME" VARCHAR2(60 CHAR),
	"LAB_CERTIFIED" VARCHAR2(1),
	"LAB_BATCH_ID" CHAR(12 CHAR),
	"ANALYSIS_DATE_TIME" DATE,
	"ANALYSIS_TIME_ZONE" VARCHAR2(256),
	"LOWER_QUANTITATION_LIMIT" CHAR(30 CHAR),
	"UPPER_QUANTITATION_LIMIT" CHAR(30 CHAR),
	"DETECTION_LIMIT" VARCHAR2(25 CHAR),
	"DETECTION_LIMIT_UNIT" CHAR(10 CHAR),
	"DETECTION_LIMIT_DESCRIPTION" VARCHAR2(256),
	"LAB_REMARK" VARCHAR2(256),
	"DISTANCE_MEASURE_FROM" VARCHAR2(20 CHAR),
	"DISTANCE_MEASURE_TO" VARCHAR2(20 CHAR),
	"PARTICLE_SIZE" VARCHAR2(40 CHAR),
	"REPLICATE_ANALYSIS_COUNT" NUMBER,
	"PRECISION" VARCHAR2(256),
	"CONFIDENCE_LEVEL" VARCHAR2(256),
	"DILUTION_INDICATOR" CHAR(1 CHAR),
	"RECOVERY_INDICATOR" CHAR(1 CHAR),
	"CORRECTION_INDICATOR" CHAR(1 CHAR),
	"STN_LATITUDE" NUMBER,
	"STN_LONGITUDE" NUMBER,
	"STN_HDATUM" CHAR(12 CHAR),
	"STN_STD_LATITUDE" NUMBER,
	"STN_STD_LONGITUDE" NUMBER,
	"STN_STD_HDATUM" CHAR(12 CHAR),
	"HYDROLOGIC_UNIT_CODE" CHAR(8 CHAR),
	"GENERATED_HUC" CHAR(8 CHAR),
	"RESULT_IS_NUMBER" NUMBER,
	"ACTIVITY_MEDIUM" VARCHAR2(20 CHAR),
	"FK_STATION" NUMBER(12,0),
	"FK_ORG" NUMBER(12,0),
	"FK_DB_CAT" NUMBER(12,0),
	"FK_GEN_DB_CAT" NUMBER(12,0),
	"FK_GEO_COUNTY" NUMBER(12,0),
	"FK_GEO_STATE" NUMBER(12,0),
	"FK_DATE_ACT_START" NUMBER(12,0),
	"FK_ACT_MEDIUM" NUMBER(12,0),
	"FK_ACT_MATRIX" NUMBER(12,0),
	"ACTIVITY_IS_NUMBER" NUMBER(12,0),
	"FK_CHAR" NUMBER(12,0),
	"FK_UNIT_CONVERSION" NUMBER(12,0),
	"ACTIVITY_ID" VARCHAR2(256),
	"REPLICATE_NUMBER" NUMBER(3,0),
	"ACTIVITY_TYPE" VARCHAR2(256),
	"ACTIVITY_CATEGORY" VARCHAR2(256),
	"ACTIVITY_INTENT" VARCHAR2(20 CHAR),
	"LOCATION_POINT_TYPE" CHAR(16 CHAR),
	"POINT_SEQUENCE_NUMBER" NUMBER(5,0),
	"WELL_NUMBER" CHAR(15 CHAR),
	"PIPE_NUMBER" CHAR(15 CHAR),
	"ACTIVITY_STOP_DATE_TIME" DATE,
	"ACT_STOP_TIME_ZONE" VARCHAR2(256),
	"ACTIVITY_REL_DEPTH" CHAR(15 CHAR),
	"ACTIVITY_DEPTH" VARCHAR2(256),
	"ACTIVITY_DEPTH_UNIT" VARCHAR2(256),
	"ACTIVITY_UPPER_DEPTH" VARCHAR2(256),
	"ACTIVITY_LOWER_DEPTH" VARCHAR2(256),
	"UPR_LWR_DEPTH_UNIT" VARCHAR2(256),
	"FIELD_PROCEDURE_ID" VARCHAR2(256),
	"GEAR_CONFIG_ID" VARCHAR2(256),
	"ACTIVITY_LATITUDE" NUMBER,
	"ACTIVITY_LONGITUDE" NUMBER,
	"ACT_STD_LATITUDE" NUMBER,
	"ACT_STD_LONGITUDE" NUMBER,
	"ACT_STD_HDATUM" CHAR(12 CHAR),
	"STD_VALUE" NUMBER,
	"STD_UNIT" VARCHAR2(10 CHAR),
	"FK_ACT_MAD_HDATUM" NUMBER(12,0),
	"FK_ACT_MAD_HMETHOD" NUMBER(12,0),
	"ACTIVITY_ISN" NUMBER,
	"VISIT_START_DATE_TIME" DATE,
	"VISIT_START_TIME_ZONE" CHAR(3 CHAR),
	"VISIT_STOP_DATE_TIME" DATE,
	"VISIT_STOP_TIME_ZONE" CHAR(3 CHAR),
	"ACTIVITY_MATRIX" VARCHAR2(256),
	"FIELD_SET" VARCHAR2(130 CHAR),
	"POINT_NAME" VARCHAR2(30 CHAR),
	"SGO_INDICATOR" CHAR(1 CHAR),
	"MAP_SCALE" VARCHAR2(20 CHAR),
	"FIELD_GEAR_ID" VARCHAR2(256),
	"BIAS" VARCHAR2(256),
	"CONF_LVL_CORR_BIAS" CHAR(1 CHAR),
	"RESULT_COMMENT" VARCHAR2(4000 CHAR),
	"TEXT_RESULT" VARCHAR2(4000 CHAR),
	"CAS_NUMBER" VARCHAR2(500 CHAR),
	"EPA_REG_NUMBER" VARCHAR2(500 CHAR),
	"ITIS_NUMBER" VARCHAR2(500 CHAR),
	"CONTAINER_DESC" VARCHAR2(256),
	"TEMP_PRESERVN_TYPE" VARCHAR2(25 CHAR),
	"PRESRV_STRGE_PRCDR" VARCHAR2(256 CHAR),
	"PORTABLE_DATA_LOGGER" VARCHAR2(34 CHAR),
	"FK_STN_ACT_PT" NUMBER(12,0),
	"FK_STATN_TYPES" NUMBER(12,0),
	"LAST_USERID" VARCHAR2(100 CHAR),
	"LAST_CHANGE_DATE" DATE,
	"BLOB_ID" VARCHAR2(25 CHAR),
	"BLOB_TITLE" VARCHAR2(256),
	"ACT_BLOB_ID" VARCHAR2(25 CHAR),
	"ACT_BLOB_TITLE" VARCHAR2(256),
	"ACTIVITY_COMMENT" VARCHAR2(4000 CHAR),
	"ACTIVITY_DEPTH_REF_POINT" VARCHAR2(256 CHAR),
	"PROJECT_ID" VARCHAR2(4000 CHAR),
	"TRIBAL_WATER_QUALITY_MEASURE" CHAR(1 CHAR),
	"RESULT_MEAS_QUAL_CODE" VARCHAR2(256 CHAR),
	"ACTIVITY_COND_ORG_TEXT" VARCHAR2(256 CHAR),
	"RESULT_DEPTH_MEAS_VALUE" VARCHAR2(256 CHAR),
	"RESULT_DEPTH_MEAS_UNIT_CODE" VARCHAR2(256 CHAR),
	"RESULT_DEPTH_ALT_REF_PT_TXT" VARCHAR2(256 CHAR),
	"ANALYTICAL_METHOD_LIST_AGENCY" VARCHAR2(256),
	"ANALYTICAL_METHOD_LIST_VER" VARCHAR2(256),
	"SMPRP_TRANSPORT_STORAGE_DESC" VARCHAR2(1999),
	"SOURCE_SYSTEM" VARCHAR2(256 CHAR),
	"SOURCE_UID" NUMBER(20,0),
	"ETL_ID" VARCHAR2(256),
	"HORIZONTAL_ACCURACY_MEASURE" VARCHAR2(256),
	"LAB_ACCRED_AUTHORITY" VARCHAR2(256),
	"METHOD_SPECIATION" VARCHAR2(256),
	"LAB_SAMP_PRP_METHOD_ID" VARCHAR2(256),
	"LAB_SAMP_PRP_METHOD_CONTEXT" VARCHAR2(256),
	"LAB_SAMP_PRP_METHOD_QUAL_TYPE" VARCHAR2(256),
	"LAB_SAMP_PRP_START_DATE_TIME" DATE,
	"LAB_SAMP_PRP_START_TMZONE" VARCHAR2(256),
	"LAB_SAMP_PRP_END_DATE_TIME" DATE,
	"LAB_SAMP_PRP_END_TMZONE" VARCHAR2(256),
	"LAB_SAMP_PRP_DILUTION_FACTOR" VARCHAR2(256),
	"SAMPLING_POINT_NAME" VARCHAR2(256),
	"LAST_TRANSACTION_ID" VARCHAR2(256),
	"FK_DATE_LC" NUMBER(12,0),
	"ALL_RESULT_DETECTION_LIMIT" VARCHAR2(2000),
	"CONFIDENCE_INTERVAL" VARCHAR2(256),
	"UPPER_CONF_LIMIT" VARCHAR2(256),
	"LOWER_CONF_LIMIT" VARCHAR2(256)
   ) ;
  ALTER TABLE "STORETW"."FA_REGULAR_RESULT" ADD CONSTRAINT "PK_REGULAR_RESULT" PRIMARY KEY ("PK_ISN") ENABLE;


  CREATE BITMAP INDEX "STORETW"."IFAR_ACTIVITY_ID" ON "STORETW"."FA_REGULAR_RESULT" ("ACTIVITY_ID")
  ;


  CREATE BITMAP INDEX "STORETW"."IRE_FK_GEO_COUNTY" ON "STORETW"."FA_REGULAR_RESULT" ("FK_GEO_COUNTY")
  ;


  CREATE BITMAP INDEX "STORETW"."IRE_FK_STATN_TYPES" ON "STORETW"."FA_REGULAR_RESULT" ("FK_STATN_TYPES")
  ;


  CREATE BITMAP INDEX "STORETW"."IRE_FK_GEO_STATE" ON "STORETW"."FA_REGULAR_RESULT" ("FK_GEO_STATE")
  ;


  CREATE INDEX "STORETW"."IFAR_LT_STN_ID_OID" ON "STORETW"."FA_REGULAR_RESULT" (LOWER(TRIM("STATION_ID")), LOWER(TRIM("ORGANIZATION_ID")))
  ;


  CREATE INDEX "STORETW"."IFAR_LT_CHAR_NAME_OID" ON "STORETW"."FA_REGULAR_RESULT" (LOWER(TRIM("CHARACTERISTIC_NAME")), LOWER(TRIM("ORGANIZATION_ID")))
  ;


  CREATE INDEX "STORETW"."IFAR_LT_ORG_ID" ON "STORETW"."FA_REGULAR_RESULT" (LOWER(TRIM("ORGANIZATION_ID")))
  ;


  CREATE UNIQUE INDEX "STORETW"."PK_REGULAR_RESULT" ON "STORETW"."FA_REGULAR_RESULT" ("PK_ISN")
  ;


  CREATE INDEX "STORETW"."IRE_ACTBLOB" ON "STORETW"."FA_REGULAR_RESULT" ("ACT_BLOB_TITLE")
  ;


  CREATE INDEX "STORETW"."IRE_BLOB" ON "STORETW"."FA_REGULAR_RESULT" ("BLOB_TITLE")
  ;


  CREATE INDEX "STORETW"."IRE_GEN_HUC" ON "STORETW"."FA_REGULAR_RESULT" ("GENERATED_HUC")
  ;


  CREATE INDEX "STORETW"."IRE_LAT_LONG" ON "STORETW"."FA_REGULAR_RESULT" ("STN_LATITUDE", "STN_LONGITUDE")
  ;


  CREATE INDEX "STORETW"."IRE_ACITIVTY_ISN" ON "STORETW"."FA_REGULAR_RESULT" ("ACTIVITY_ISN")
  ;


  CREATE INDEX "STORETW"."IFA_RESULT_LBRMK_01" ON "STORETW"."FA_REGULAR_RESULT" ("RESULT_IS_NUMBER", "ORGANIZATION_ID")
  ;


  CREATE INDEX "STORETW"."IRE_ACT_IS_NUM_ORG_ID" ON "STORETW"."FA_REGULAR_RESULT" ("ACTIVITY_IS_NUMBER", "ORGANIZATION_ID")
  ;


  CREATE INDEX "STORETW"."IFRR_LCDATE" ON "STORETW"."FA_REGULAR_RESULT" ("LAST_CHANGE_DATE")
  ;


  CREATE INDEX "STORETW"."I_FA_REG_RESULT_SOURCEUID" ON "STORETW"."FA_REGULAR_RESULT" ("SOURCE_SYSTEM", "SOURCE_UID")
  ;


  CREATE BITMAP INDEX "STORETW"."IRE_FK_STATION" ON "STORETW"."FA_REGULAR_RESULT" ("FK_STATION")
  ;


  CREATE BITMAP INDEX "STORETW"."IRE_FK_DATE_ACT_START" ON "STORETW"."FA_REGULAR_RESULT" ("FK_DATE_ACT_START")
  ;


  CREATE BITMAP INDEX "STORETW"."IRE_FK_ORG" ON "STORETW"."FA_REGULAR_RESULT" ("FK_ORG")
  ;


  CREATE BITMAP INDEX "STORETW"."IRE_FK_DB_CAT" ON "STORETW"."FA_REGULAR_RESULT" ("FK_DB_CAT")
  ;


  CREATE BITMAP INDEX "STORETW"."IRE_FK_CHAR" ON "STORETW"."FA_REGULAR_RESULT" ("FK_CHAR")
  ;


  CREATE BITMAP INDEX "STORETW"."IRE_FK_ACT_MEDIUM" ON "STORETW"."FA_REGULAR_RESULT" ("FK_ACT_MEDIUM")
  ;


  CREATE BITMAP INDEX "STORETW"."IRE_FK_GEN_DB_CAT" ON "STORETW"."FA_REGULAR_RESULT" ("FK_GEN_DB_CAT")
  ;


  ALTER TABLE "STORETW"."FA_REGULAR_RESULT" ADD CONSTRAINT "RE_FK_ACT_MAD_HDATUM" FOREIGN KEY ("FK_ACT_MAD_HDATUM")
	  REFERENCES "STORETW"."LU_MAD_HDATUM" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_REGULAR_RESULT" ADD CONSTRAINT "RE_FK_ACT_MAD_HMETHOD" FOREIGN KEY ("FK_ACT_MAD_HMETHOD")
	  REFERENCES "STORETW"."LU_MAD_HMETHOD" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_REGULAR_RESULT" ADD CONSTRAINT "RE_FK_ACT_MEDIUM" FOREIGN KEY ("FK_ACT_MEDIUM")
	  REFERENCES "STORETW"."DI_ACTIVITY_MEDIUM" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_REGULAR_RESULT" ADD CONSTRAINT "RE_FK_CHAR" FOREIGN KEY ("FK_CHAR")
	  REFERENCES "STORETW"."DI_CHARACTERISTIC" ("PK_ISN") ENABLE;
  ALTER TABLE "STORETW"."FA_REGULAR_RESULT" ADD CONSTRAINT "RE_FK_DATE_ACT_START" FOREIGN KEY ("FK_DATE_ACT_START")
	  REFERENCES "STORETW"."DI_DATE" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_REGULAR_RESULT" ADD CONSTRAINT "RE_FK_DATE_LC" FOREIGN KEY ("FK_DATE_LC")
	  REFERENCES "STORETW"."DI_DATE" ("PK_ISN") ENABLE;
  ALTER TABLE "STORETW"."FA_REGULAR_RESULT" ADD CONSTRAINT "RE_FK_SD_DB_CAT" FOREIGN KEY ("FK_DB_CAT")
	  REFERENCES "STORETW"."DI_DB_CAT" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_REGULAR_RESULT" ADD CONSTRAINT "RE_FK_SD_GEN_DB_CAT" FOREIGN KEY ("FK_GEN_DB_CAT")
	  REFERENCES "STORETW"."DI_DB_CAT" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_REGULAR_RESULT" ADD CONSTRAINT "RE_FK_SD_GEO_COUNTY" FOREIGN KEY ("FK_GEO_COUNTY")
	  REFERENCES "STORETW"."DI_GEO_COUNTY" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_REGULAR_RESULT" ADD CONSTRAINT "RE_FK_SD_GEO_STATE" FOREIGN KEY ("FK_GEO_STATE")
	  REFERENCES "STORETW"."DI_GEO_STATE" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_REGULAR_RESULT" ADD CONSTRAINT "RE_FK_SD_ORG" FOREIGN KEY ("FK_ORG")
	  REFERENCES "STORETW"."DI_ORG" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."FA_REGULAR_RESULT" ADD CONSTRAINT "RE_FK_STATN_TYPES" FOREIGN KEY ("FK_STATN_TYPES")
	  REFERENCES "STORETW"."DI_STATN_TYPES" ("PK_ISN") DISABLE;

