
  CREATE TABLE "STORETW"."FA_STATION"
   (	"STATION_ID" VARCHAR2(256),
	"STATION_NAME" VARCHAR2(256),
	"ORGANIZATION_ID" VARCHAR2(256),
	"LOCATION_POINT_TYPE" CHAR(16 CHAR),
	"POINT_SEQUENCE_NUMBER" NUMBER(4,0),
	"WELL_NUMBER" CHAR(15 CHAR),
	"PIPE_NUMBER" CHAR(15 CHAR),
	"LATITUDE" NUMBER(9,7),
	"LONGITUDE" NUMBER(10,7),
	"MAP_SCALE" VARCHAR2(20 CHAR),
	"ELEVATION" CHAR(15 CHAR),
	"HYDROLOGIC_UNIT_CODE" CHAR(8 CHAR),
	"GENERATED_HUC" CHAR(8 CHAR),
	"RF1_SEGMENT_CODE" VARCHAR2(3 CHAR),
	"RF1_SEGMENT_NAME" VARCHAR2(30 CHAR),
	"RF1_MILEAGE" NUMBER(5,2),
	"ON_REACH_IND" CHAR(1 CHAR),
	"NRCS_WATERSHED_ID" CHAR(8 CHAR),
	"OTHER_ESTUARY_NAME" VARCHAR2(30 CHAR),
	"GREAT_LAKE_NAME" CHAR(15 CHAR),
	"OCEAN_NAME" CHAR(14 CHAR),
	"NATV_AMERICAN_LAND_NAME" VARCHAR2(256 CHAR),
	"FRS_KEY_IDENTIFIER" VARCHAR2(36 CHAR),
	"STATION_VISITED" CHAR(3 CHAR),
	"STATION_IS_NUMBER" NUMBER(12,0),
	"ORGANIZATION_IS_NUMBER" NUMBER(20,0),
	"STATION_GROUP_TYPE" VARCHAR2(256 CHAR),
	"SGO_INDICATOR" CHAR(1 CHAR),
	"WELL_NAME" VARCHAR2(40 CHAR),
	"NAICS_CODE" VARCHAR2(30 CHAR),
	"SPRING_TYPE_IMPROVEMENT" CHAR(14 CHAR),
	"SPRING_PERMANENCE" CHAR(12 CHAR),
	"SPRING_USGS_GEOLOGIC_UNIT" VARCHAR2(100 CHAR),
	"SPRING_OTHER_NAME" VARCHAR2(120 CHAR),
	"SPRING_USGS_LITHOLOGIC_UNIT" VARCHAR2(135 CHAR),
	"POINT_NAME" VARCHAR2(30 CHAR),
	"BLOB_TITLE" VARCHAR2(60 CHAR),
	"TSMALP_IS_NUMBER" NUMBER,
	"DESCRIPTION_TEXT" VARCHAR2(4000 CHAR),
	"LAST_USERID" VARCHAR2(100),
	"LAST_CHANGE_DATE" DATE DEFAULT systimestamp,
	"PROJECT_ID" CHAR(8 CHAR),
	"TRIBAL_WATER_QUALITY_MEASURE" CHAR(1 CHAR),
	"HORIZONTAL_ACCURACY" CHAR(15 CHAR),
	"FK_DB_CAT" NUMBER(12,0),
	"FK_GEN_DB_CAT" NUMBER(12,0),
	"FK_GEO_STATE" NUMBER(12,0),
	"FK_GEO_COUNTY" NUMBER(12,0),
	"FK_MAD_HMETHOD" NUMBER(12,0),
	"FK_MAD_HDATUM" NUMBER(12,0),
	"FK_MAD_VMETHOD" NUMBER(12,0),
	"FK_MAD_VDATUM" NUMBER(12,0),
	"STD_LATITUDE" NUMBER(9,7),
	"STD_LONGITUDE" NUMBER(10,7),
	"FK_STD_HDATUM" NUMBER(12,0),
	"FK_ORG" NUMBER(12,0),
	"FK_STATN_TYPES" NUMBER(12,0),
	"FK_ESTRY_PRIMARY" NUMBER(12,0),
	"FK_ESTRY_SECONDARY" NUMBER(12,0),
	"BLOB_ID" VARCHAR2(25),
	"FK_PRIMARY_TYPE" VARCHAR2(256),
	"FK_SECONDARY_TYPE" VARCHAR2(256),
	"FK_HORIZONTAL_DATUM" VARCHAR2(254),
	"FK_GEOPOSITIONING_METHOD" VARCHAR2(254),
	"FK_ELEVATION_DATUM" VARCHAR2(254),
	"FK_ELEVATION_METHOD" VARCHAR2(254),
	"FK_PRIMARY_ESTUARY" VARCHAR2(30),
	"FK_SECONDARY_ESTUARY" VARCHAR2(30),
	"FK_COUNTRY_CODE" CHAR(2),
	"FK_STATE_POSTAL_CODE" CHAR(2),
	"SOURCE_SYSTEM" VARCHAR2(256 CHAR),
	"SOURCE_UID" NUMBER(20,0),
	"GEOM" "MDSYS"."SDO_GEOMETRY" ,
	"WELL_TYPE_NAME" VARCHAR2(256),
	"WELL_FORMATION_TYPE" VARCHAR2(256),
	"WELL_HOLE_DEPTH" VARCHAR2(256),
	"WELL_AQUIFER_NAME" VARCHAR2(256),
	"PK_ISN" NUMBER(38,0),
	"OBJECTID" NUMBER(*,0),
	"FK_GEN_GEO_STATE" NUMBER(12,0),
	"FK_GEN_GEO_COUNTY" NUMBER(12,0),
	"ELEVATION_UNIT" CHAR(15 CHAR),
	"GEN_HUCTWELVEDIGITCODE" VARCHAR2(12 CHAR),
	"WGS84_LATITUDE" NUMBER(9,7),
	"WGS84_LONGITUDE" NUMBER(10,7),
	"FK_WGS84_HDATUM" NUMBER(12,0),
	"LAST_TRANSACTION_ID" VARCHAR2(100),
	"FK_DATE_LC" NUMBER(12,0),
	"PROGRAM_INDICATOR" VARCHAR2(256 CHAR),
	"ELEVATION_BK" CHAR(15 CHAR),
	"FK_GEO_COUNTY_BK" NUMBER(12,0),
	"FK_GEO_STATE_BK" NUMBER(12,0),
	"WELL_HOLE_DEPTH_UNIT" VARCHAR2(256 CHAR),
	"TRIBAL_LAND_INDICATOR" VARCHAR2(1 CHAR),
	"HUCTWELVEDIGITCODE" VARCHAR2(12 CHAR)
   ) ;
  ALTER TABLE "STORETW"."FA_STATION" ADD CONSTRAINT "PK_STATION" PRIMARY KEY ("PK_ISN") ENABLE;


  CREATE UNIQUE INDEX "STORETW"."R49_SDE_ROWID_UK" ON "STORETW"."FA_STATION" ("OBJECTID")
  ;


  CREATE INDEX "STORETW"."FA_STN_LOC_IX" ON "STORETW"."FA_STATION" ("GEOM")
   INDEXTYPE IS "MDSYS"."SPATIAL_INDEX"  PARAMETERS (' ');


  CREATE BITMAP INDEX "STORETW"."ISD_STATION_ID" ON "STORETW"."FA_STATION" (LOWER("STATION_ID"))
  ;


  CREATE BITMAP INDEX "STORETW"."ISD_ORGANIZATION_ID" ON "STORETW"."FA_STATION" (LOWER("ORGANIZATION_ID"))
  ;


  CREATE BITMAP INDEX "STORETW"."ISD_FK_GEO_STATE" ON "STORETW"."FA_STATION" ("FK_GEO_STATE")
  ;


  CREATE BITMAP INDEX "STORETW"."ISD_FK_GEO_COUNTY" ON "STORETW"."FA_STATION" ("FK_GEO_COUNTY")
  ;


  CREATE BITMAP INDEX "STORETW"."ISD_FK_DB_CAT" ON "STORETW"."FA_STATION" ("FK_DB_CAT")
  ;


  CREATE BITMAP INDEX "STORETW"."ISD_FK_STATN_TYPES" ON "STORETW"."FA_STATION" ("FK_STATN_TYPES")
  ;


  CREATE BITMAP INDEX "STORETW"."ISD_FK_ORG" ON "STORETW"."FA_STATION" ("FK_ORG")
  ;


  CREATE BITMAP INDEX "STORETW"."ISD_FK_GEN_DB_CAT" ON "STORETW"."FA_STATION" ("FK_GEN_DB_CAT")
  ;


  CREATE BITMAP INDEX "STORETW"."ISD_FK_GEN_GEO_COUNTY" ON "STORETW"."FA_STATION" ("FK_GEN_GEO_COUNTY")
  ;


  CREATE BITMAP INDEX "STORETW"."ISD_FK_GEN_GEO_STATE" ON "STORETW"."FA_STATION" ("FK_GEN_GEO_STATE")
  ;


  CREATE INDEX "STORETW"."ISD_GEN_HUC" ON "STORETW"."FA_STATION" ("GENERATED_HUC")
  ;


  CREATE INDEX "STORETW"."SD_OID_SID" ON "STORETW"."FA_STATION" ("ORGANIZATION_ID", "STATION_ID")
  ;


  CREATE INDEX "STORETW"."ISD_HUC" ON "STORETW"."FA_STATION" ("HYDROLOGIC_UNIT_CODE")
  ;


  CREATE INDEX "STORETW"."IFS_LCDATE" ON "STORETW"."FA_STATION" ("LAST_CHANGE_DATE")
  ;


  CREATE INDEX "STORETW"."SD_STD_LONG_LAT" ON "STORETW"."FA_STATION" ("STD_LONGITUDE", "STD_LATITUDE")
  ;


  CREATE INDEX "STORETW"."SD_STD_LAT_LONG" ON "STORETW"."FA_STATION" ("STD_LATITUDE", "STD_LONGITUDE")
  ;


  CREATE INDEX "STORETW"."SD_LONG_LAT" ON "STORETW"."FA_STATION" ("LONGITUDE", "LATITUDE")
  ;


  CREATE INDEX "STORETW"."SD_LAT_LONG" ON "STORETW"."FA_STATION" ("LATITUDE", "LONGITUDE")
  ;


  CREATE UNIQUE INDEX "STORETW"."PK_STATION" ON "STORETW"."FA_STATION" ("PK_ISN")
  ;


  CREATE INDEX "STORETW"."ISD_FK_ESTRY_SECONDARY" ON "STORETW"."FA_STATION" ("FK_ESTRY_SECONDARY")
  ;


  CREATE INDEX "STORETW"."ISD_FK_ESTRY_PRIMARY" ON "STORETW"."FA_STATION" ("FK_ESTRY_PRIMARY")
  ;


  CREATE INDEX "STORETW"."ISD_STD_MAD_HDATUM" ON "STORETW"."FA_STATION" ("FK_STD_HDATUM")
  ;


  CREATE INDEX "STORETW"."ISD_MAD_VDATUM" ON "STORETW"."FA_STATION" ("FK_MAD_VDATUM")
  ;


  CREATE INDEX "STORETW"."ISD_MAD_HDATUM" ON "STORETW"."FA_STATION" ("FK_MAD_HDATUM")
  ;


  CREATE INDEX "STORETW"."ISD_MAD_VMETHOD" ON "STORETW"."FA_STATION" ("FK_MAD_VMETHOD")
  ;


  CREATE INDEX "STORETW"."ISD_MAD_HMETHOD" ON "STORETW"."FA_STATION" ("FK_MAD_HMETHOD")
  ;


  CREATE INDEX "STORETW"."SD_OID_ALP" ON "STORETW"."FA_STATION" ("ORGANIZATION_ID", "TSMALP_IS_NUMBER")
  ;


  CREATE INDEX "STORETW"."SD_OISN" ON "STORETW"."FA_STATION" ("ORGANIZATION_IS_NUMBER")
  ;


  CREATE INDEX "STORETW"."SD_SISN_OID" ON "STORETW"."FA_STATION" ("STATION_IS_NUMBER", "ORGANIZATION_ID")
  ;


  CREATE INDEX "STORETW"."SD_SID_OID" ON "STORETW"."FA_STATION" ("STATION_ID", "ORGANIZATION_ID")
  ;


  CREATE INDEX "STORETW"."ISD_SOURCEUID" ON "STORETW"."FA_STATION" ("SOURCE_SYSTEM", "SOURCE_UID")
  ;


  CREATE BITMAP INDEX "STORETW"."IWS_BITMAP_FA_STATION_VISITED" ON "STORETW"."FA_STATION" ("STATION_VISITED")
  ;


  CREATE BITMAP INDEX "STORETW"."FA_STN_QW_ORG_ID" ON "STORETW"."FA_STATION" ("ORGANIZATION_ID")
  ;


  CREATE BITMAP INDEX "STORETW"."FA_STN_QW_STA_GROUP_TYPE" ON "STORETW"."FA_STATION" ("STATION_GROUP_TYPE")
  ;


  CREATE BITMAP INDEX "STORETW"."ISD_LOCATION_POINT_TYPE" ON "STORETW"."FA_STATION" ("LOCATION_POINT_TYPE")
  ;


  CREATE BITMAP INDEX "STORETW"."FA_STN_QW_ORG_STA" ON "STORETW"."FA_STATION" ("ORGANIZATION_ID"||'-'||"STATION_ID")
  ;


  CREATE INDEX "STORETW"."FA_STATION_F01" ON "STORETW"."FA_STATION" (CAST("PK_ISN" AS INTEGER))
  ;


  ALTER TABLE "STORETW"."FA_STATION" ADD CONSTRAINT "FK_SD_DATE_LC" FOREIGN KEY ("FK_DATE_LC")
	  REFERENCES "STORETW"."DI_DATE" ("PK_ISN") ENABLE;
  ALTER TABLE "STORETW"."FA_STATION" ADD CONSTRAINT "FK_SD_DB_CAT" FOREIGN KEY ("FK_DB_CAT")
	  REFERENCES "STORETW"."DI_DB_CAT" ("PK_ISN") ENABLE;
  ALTER TABLE "STORETW"."FA_STATION" ADD CONSTRAINT "FK_SD_ESTRY_PRIMARY" FOREIGN KEY ("FK_ESTRY_PRIMARY")
	  REFERENCES "STORETW"."LU_ESTRY_PRIMARY" ("PK_ISN") ENABLE;
  ALTER TABLE "STORETW"."FA_STATION" ADD CONSTRAINT "FK_SD_ESTRY_SECONDARY" FOREIGN KEY ("FK_ESTRY_SECONDARY")
	  REFERENCES "STORETW"."LU_ESTRY_SECONDARY" ("PK_ISN") ENABLE;
  ALTER TABLE "STORETW"."FA_STATION" ADD CONSTRAINT "FK_SD_GEN_DB_CAT" FOREIGN KEY ("FK_GEN_DB_CAT")
	  REFERENCES "STORETW"."DI_DB_CAT" ("PK_ISN") ENABLE;
  ALTER TABLE "STORETW"."FA_STATION" ADD CONSTRAINT "FK_SD_GEO_COUNTY" FOREIGN KEY ("FK_GEO_COUNTY")
	  REFERENCES "STORETW"."DI_GEO_COUNTY" ("PK_ISN") ENABLE;
  ALTER TABLE "STORETW"."FA_STATION" ADD CONSTRAINT "FK_SD_GEO_STATE" FOREIGN KEY ("FK_GEO_STATE")
	  REFERENCES "STORETW"."DI_GEO_STATE" ("PK_ISN") ENABLE;
  ALTER TABLE "STORETW"."FA_STATION" ADD CONSTRAINT "FK_SD_MAD_HDATUM" FOREIGN KEY ("FK_MAD_HDATUM")
	  REFERENCES "STORETW"."LU_MAD_HDATUM" ("PK_ISN") ENABLE;
  ALTER TABLE "STORETW"."FA_STATION" ADD CONSTRAINT "FK_SD_MAD_HMETHOD" FOREIGN KEY ("FK_MAD_HMETHOD")
	  REFERENCES "STORETW"."LU_MAD_HMETHOD" ("PK_ISN") ENABLE;
  ALTER TABLE "STORETW"."FA_STATION" ADD CONSTRAINT "FK_SD_MAD_VDATUM" FOREIGN KEY ("FK_MAD_VDATUM")
	  REFERENCES "STORETW"."LU_MAD_VDATUM" ("PK_ISN") ENABLE;
  ALTER TABLE "STORETW"."FA_STATION" ADD CONSTRAINT "FK_SD_MAD_VMETHOD" FOREIGN KEY ("FK_MAD_VMETHOD")
	  REFERENCES "STORETW"."LU_MAD_VMETHOD" ("PK_ISN") ENABLE;
  ALTER TABLE "STORETW"."FA_STATION" ADD CONSTRAINT "FK_SD_ORG" FOREIGN KEY ("FK_ORG")
	  REFERENCES "STORETW"."DI_ORG" ("PK_ISN") ENABLE;
  ALTER TABLE "STORETW"."FA_STATION" ADD CONSTRAINT "FK_SD_STATN_TYPES" FOREIGN KEY ("FK_STATN_TYPES")
	  REFERENCES "STORETW"."DI_STATN_TYPES" ("PK_ISN") ENABLE;
  ALTER TABLE "STORETW"."FA_STATION" ADD CONSTRAINT "FK_SD_STD_MAD_HDATUM" FOREIGN KEY ("FK_STD_HDATUM")
	  REFERENCES "STORETW"."LU_MAD_HDATUM" ("PK_ISN") ENABLE;

