
  CREATE TABLE "STORETW"."STATION_CHAR"
   (	"FK_CHAR" NUMBER(12,0) NOT NULL DISABLE,
	"FK_FA_STATN" NUMBER,
	"HYDROLOGIC_UNIT_CODE" CHAR(8 CHAR),
	"ORGANIZATION_ID" VARCHAR2(256),
	"STATION_ID" VARCHAR2(256),
	"STATION_NAME" VARCHAR2(256),
	"DISPLAY_NAME" VARCHAR2(256 CHAR) NOT NULL DISABLE,
	"SEARCH_NAME" VARCHAR2(256 CHAR) NOT NULL DISABLE,
	"CHAR_TYPE_CODE" CHAR(1),
	"REGULAR_COUNT" NUMBER,
	"BIOLOGICAL_COUNT" NUMBER,
	"HABITAT_COUNT" NUMBER,
	"ACT_MIN_START_DATE" DATE,
	"ACT_MAX_START_DATE" DATE,
	"ACT_MAX_START_STOP_DATE" DATE,
	"RESULT_COUNT" NUMBER,
	"TRIBAL_WATER_QUALITY_MEASURE" CHAR(1 CHAR),
	"RSLT_MIN_VALUE_MEASURE" NUMBER,
	"RSLT_MAX_VALUE_MEASURE" NUMBER,
	"RSLT_AVG_VALUE_MEASURE" NUMBER,
	"RSLT_MEASURE_UNIT" VARCHAR2(10 CHAR),
	"STN_STD_LATITUDE" NUMBER,
	"STN_STD_LONGITUDE" NUMBER,
	"ORGANIZATION_NAME" VARCHAR2(256 CHAR)
   ) ;
  ALTER TABLE "STORETW"."STATION_CHAR" ADD CONSTRAINT "TRIBAL_Y_OR_N" CHECK (TRIBAL_WATER_QUALITY_MEASURE='Y' or TRIBAL_WATER_QUALITY_MEASURE='N') DISABLE;


  CREATE BITMAP INDEX "STORETW"."ISC_HYDROLOGIC_UNIT_CODE" ON "STORETW"."STATION_CHAR" ("HYDROLOGIC_UNIT_CODE")
  ;


  CREATE BITMAP INDEX "STORETW"."ISC_STATION_ID" ON "STORETW"."STATION_CHAR" (LOWER("STATION_ID"))
  ;


  CREATE BITMAP INDEX "STORETW"."ISC_ORGANIZATION_ID" ON "STORETW"."STATION_CHAR" (LOWER("ORGANIZATION_ID"))
  ;


  CREATE INDEX "STORETW"."ISC_SEARCH_NAME" ON "STORETW"."STATION_CHAR" ("SEARCH_NAME")
  ;


  CREATE BITMAP INDEX "STORETW"."ISC_FK_FA_STATN" ON "STORETW"."STATION_CHAR" ("FK_FA_STATN")
  ;


  CREATE BITMAP INDEX "STORETW"."ISC_FK_CHAR" ON "STORETW"."STATION_CHAR" ("FK_CHAR")
  ;


  ALTER TABLE "STORETW"."STATION_CHAR" ADD CONSTRAINT "ISC_FK_CHAR" FOREIGN KEY ("FK_CHAR")
	  REFERENCES "STORETW"."DI_CHARACTERISTIC" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."STATION_CHAR" ADD CONSTRAINT "ISC_FK_FA_STATN" FOREIGN KEY ("FK_FA_STATN")
	  REFERENCES "STORETW"."FA_STATION" ("PK_ISN") DISABLE;

