
  CREATE TABLE "STORETW"."STATION_CHAR_MEDIUM"
   (	"FK_CHAR" NUMBER(12,0),
	"FK_ACT_MEDIUM" NUMBER(12,0),
	"FK_FA_STATN" NUMBER(12,0),
	"FK_ORG" NUMBER(12,0),
	"FK_GEN_DB_CAT" NUMBER(12,0),
	"HYDROLOGIC_UNIT_CODE" CHAR(8 CHAR),
	"ORGANIZATION_ID" VARCHAR2(256),
	"STATION_ID" VARCHAR2(256 CHAR),
	"STATION_NAME" VARCHAR2(256),
	"DISPLAY_NAME" VARCHAR2(256 CHAR),
	"SEARCH_NAME" VARCHAR2(256 CHAR),
	"CHAR_TYPE_CODE" CHAR(1),
	"REGULAR_COUNT" NUMBER,
	"BIOLOGICAL_COUNT" NUMBER,
	"HABITAT_COUNT" NUMBER,
	"ACT_MIN_START_DATE" DATE,
	"ACT_MAX_START_DATE" DATE,
	"ACT_MAX_START_STOP_DATE" DATE,
	"RESULT_COUNT" NUMBER,
	"CHARTYPE" VARCHAR2(256 CHAR),
	"RSLT_MIN_VALUE_MEASURE" NUMBER,
	"RSLT_MAX_VALUE_MEASURE" NUMBER,
	"RSLT_AVG_VALUE_MEASURE" NUMBER,
	"RSLT_MEASURE_UNIT" VARCHAR2(10 CHAR),
	"LAST_CHANGE_DATE" DATE,
	"FK_DATE_ACT_MIN_START" NUMBER(12,0),
	"FK_DATE_ACT_MAX_START" NUMBER(12,0)
   ) ;


  CREATE BITMAP INDEX "STORETW"."ISCM_FK_FA_STATN" ON "STORETW"."STATION_CHAR_MEDIUM" ("FK_FA_STATN")
  ;


  CREATE BITMAP INDEX "STORETW"."ISCM_FK_DATE_ACT_MAX_START" ON "STORETW"."STATION_CHAR_MEDIUM" ("FK_DATE_ACT_MAX_START")
  ;


  CREATE BITMAP INDEX "STORETW"."ISCM_FK_DATE_ACT_MIN_START" ON "STORETW"."STATION_CHAR_MEDIUM" ("FK_DATE_ACT_MIN_START")
  ;


  CREATE INDEX "STORETW"."ISCM_SEARCH_NAME" ON "STORETW"."STATION_CHAR_MEDIUM" ("SEARCH_NAME")
  ;


  CREATE BITMAP INDEX "STORETW"."ISCM_FK_ACT_MEDIUM" ON "STORETW"."STATION_CHAR_MEDIUM" ("FK_ACT_MEDIUM")
  ;


  CREATE BITMAP INDEX "STORETW"."ISCM_FK_CHAR" ON "STORETW"."STATION_CHAR_MEDIUM" ("FK_CHAR")
  ;


  ALTER TABLE "STORETW"."STATION_CHAR_MEDIUM" ADD CONSTRAINT "ISCM_FK_ACT_MEDIUM" FOREIGN KEY ("FK_ACT_MEDIUM")
	  REFERENCES "STORETW"."DI_ACTIVITY_MEDIUM" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."STATION_CHAR_MEDIUM" ADD CONSTRAINT "ISCM_FK_CHAR" FOREIGN KEY ("FK_CHAR")
	  REFERENCES "STORETW"."DI_CHARACTERISTIC" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."STATION_CHAR_MEDIUM" ADD CONSTRAINT "ISCM_FK_DATE_ACT_MAX_START" FOREIGN KEY ("FK_DATE_ACT_MAX_START")
	  REFERENCES "STORETW"."DI_DATE" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."STATION_CHAR_MEDIUM" ADD CONSTRAINT "ISCM_FK_DATE_ACT_MIN_START" FOREIGN KEY ("FK_DATE_ACT_MIN_START")
	  REFERENCES "STORETW"."DI_DATE" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."STATION_CHAR_MEDIUM" ADD CONSTRAINT "ISCM_FK_FA_STATN" FOREIGN KEY ("FK_FA_STATN")
	  REFERENCES "STORETW"."FA_STATION" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."STATION_CHAR_MEDIUM" ADD CONSTRAINT "ISCM_FK_GEN_DB_CAT" FOREIGN KEY ("FK_GEN_DB_CAT")
	  REFERENCES "STORETW"."DI_DB_CAT" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."STATION_CHAR_MEDIUM" ADD CONSTRAINT "ISCM_FK_ORG" FOREIGN KEY ("FK_ORG")
	  REFERENCES "STORETW"."DI_ORG" ("PK_ISN") DISABLE;

