
  CREATE TABLE "STORETW"."STATION_CHAR_PROJECT"
   (	"FK_STATION" NUMBER(12,0) NOT NULL DISABLE,
	"FK_CHAR" NUMBER(12,0) NOT NULL DISABLE,
	"FK_PROJECT" NUMBER(12,0) NOT NULL DISABLE,
	"FK_ORG" NUMBER(12,0) NOT NULL DISABLE,
	"FK_GEN_DB_CAT" NUMBER(12,0),
	"RESULT_COUNT" NUMBER NOT NULL DISABLE,
	"REGULAR_COUNT" NUMBER,
	"BIOLOGICAL_COUNT" NUMBER,
	"HABITAT_COUNT" NUMBER,
	"STATION_ID" VARCHAR2(256 CHAR),
	"STATION_NAME" VARCHAR2(256 CHAR),
	"STN_STD_LATITUDE" NUMBER,
	"STN_STD_LONGITUDE" NUMBER,
	"CHARTYPE" VARCHAR2(256 CHAR),
	"CHARACTERISTIC_NAME" VARCHAR2(256 CHAR),
	"PROJECT_CD" VARCHAR2(256 CHAR),
	"PROJECT_NAME" VARCHAR2(256 CHAR),
	"PROJECT_POR_START" DATE,
	"PROJECT_POR_END" DATE,
	"ORGANIZATION_ID" VARCHAR2(256 CHAR),
	"ORGANIZATION_NAME" VARCHAR2(256 CHAR),
	"HYDROLOGIC_UNIT_CODE" VARCHAR2(8 CHAR)
   ) ;


  CREATE BITMAP INDEX "STORETW"."ISCP_ORGANIZATION_ID" ON "STORETW"."STATION_CHAR_PROJECT" (LOWER("ORGANIZATION_ID"))
  ;


  CREATE BITMAP INDEX "STORETW"."ISCP_STATION_ID" ON "STORETW"."STATION_CHAR_PROJECT" (LOWER("STATION_ID"))
  ;


  CREATE INDEX "STORETW"."ISCP_LAT_LONG" ON "STORETW"."STATION_CHAR_PROJECT" ("STN_STD_LATITUDE", "STN_STD_LONGITUDE")
  ;


  CREATE BITMAP INDEX "STORETW"."ISCP_HYDROLOGIC_UNIT_CODE" ON "STORETW"."STATION_CHAR_PROJECT" ("HYDROLOGIC_UNIT_CODE")
  ;


  CREATE BITMAP INDEX "STORETW"."ISCP_PROJECT_CD" ON "STORETW"."STATION_CHAR_PROJECT" (LOWER("PROJECT_CD"))
  ;


  ALTER TABLE "STORETW"."STATION_CHAR_PROJECT" ADD CONSTRAINT "ISCP_FK_CHAR" FOREIGN KEY ("FK_CHAR")
	  REFERENCES "STORETW"."DI_CHARACTERISTIC" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."STATION_CHAR_PROJECT" ADD CONSTRAINT "ISCP_FK_GEN_DB_CAT" FOREIGN KEY ("FK_GEN_DB_CAT")
	  REFERENCES "STORETW"."DI_DB_CAT" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."STATION_CHAR_PROJECT" ADD CONSTRAINT "ISCP_FK_ORG" FOREIGN KEY ("FK_ORG")
	  REFERENCES "STORETW"."DI_ORG" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."STATION_CHAR_PROJECT" ADD CONSTRAINT "ISCP_FK_PROJECT" FOREIGN KEY ("FK_PROJECT")
	  REFERENCES "STORETW"."DI_PROJECT" ("PK_ISN") DISABLE;
  ALTER TABLE "STORETW"."STATION_CHAR_PROJECT" ADD CONSTRAINT "ISCP_FK_STATION" FOREIGN KEY ("FK_STATION")
	  REFERENCES "STORETW"."FA_STATION" ("PK_ISN") DISABLE;

