
  CREATE TABLE "STORETW"."STATION_CHAR_YEAR"
   (	"FK_CHAR" NUMBER(12,0),
	"FK_FA_STATN" NUMBER(12,0),
	"FK_ORG" NUMBER(12,0),
	"FK_GEN_GEO_STATE" NUMBER(12,0),
	"FK_GEN_GEO_COUNTY" NUMBER(12,0),
	"FK_GEN_DB_CAT" NUMBER(12,0),
	"FK_GEN_DB_CAT12" NUMBER(12,0),
	"STATE_NAME" VARCHAR2(256),
	"ORGANIZATION_ID" VARCHAR2(256),
	"STATION_ID" VARCHAR2(256),
	"STATION_NAME" VARCHAR2(256),
	"DISPLAY_NAME" VARCHAR2(256 CHAR),
	"REGULAR_COUNT" NUMBER,
	"HABITAT_COUNT" NUMBER,
	"BIOLOGICAL_COUNT" NUMBER,
	"METRIC_COUNT" NUMBER,
	"INDEX_COUNT" NUMBER,
	"ACT_START_YEAR_DATE" NUMBER,
	"RESULT_COUNT" NUMBER
   ) ;


  CREATE BITMAP INDEX "STORETW"."ISCY_FK_CHAR" ON "STORETW"."STATION_CHAR_YEAR" ("FK_CHAR")
  ;


  CREATE BITMAP INDEX "STORETW"."ISCY_ACT_START_YEAR_DATE" ON "STORETW"."STATION_CHAR_YEAR" ("ACT_START_YEAR_DATE")
  ;


  CREATE INDEX "STORETW"."ISCY_STATE_NAME" ON "STORETW"."STATION_CHAR_YEAR" ("STATE_NAME")
  ;


  CREATE BITMAP INDEX "STORETW"."ISCY_FK_FA_STATN" ON "STORETW"."STATION_CHAR_YEAR" ("FK_FA_STATN")
  ;


  CREATE BITMAP INDEX "STORETW"."ISCY_FK_GEN_GEO_STATE" ON "STORETW"."STATION_CHAR_YEAR" ("FK_GEN_GEO_STATE")
  ;

