
  CREATE TABLE "STORETW"."STATION_PROJECT"
   (	"FK_PROJECT" NUMBER NOT NULL ENABLE,
	"FK_STATION" NUMBER NOT NULL ENABLE,
	"STATION_WEIGHT" VARCHAR2(256 CHAR),
	"WEIGHT_UNIT_CODE" VARCHAR2(256 CHAR),
	"STRATUM" VARCHAR2(256 CHAR),
	"STATION_WEIGHT_CATEGORY" VARCHAR2(256 CHAR),
	"SITE_STATUS" VARCHAR2(256 CHAR),
	"ORGANIZATION_ID" VARCHAR2(256),
	"STATION_ID" VARCHAR2(256),
	"PROJECT_CD" VARCHAR2(256 CHAR),
	"STATION_WEIGHT_COMMENT" VARCHAR2(4000),
	"REFERENCE_LOCATION_CODE" VARCHAR2(256),
	"CITATION_ID" VARCHAR2(256),
	"REFERENCE_LOC_END_DATE" DATE,
	"REFERENCE_LOC_START_DATE" DATE,
	"LAST_CHANGE_DATE" DATE DEFAULT systimestamp
   ) ;
  ALTER TABLE "STORETW"."STATION_PROJECT" ADD CONSTRAINT "PK_STATION_PROJECT" PRIMARY KEY ("FK_PROJECT", "FK_STATION") ENABLE;


  CREATE BITMAP INDEX "STORETW"."ISP_ORGANIZATION_ID" ON "STORETW"."STATION_PROJECT" (LOWER("ORGANIZATION_ID"))
  ;


  CREATE BITMAP INDEX "STORETW"."ISP_PROJECT_CD" ON "STORETW"."STATION_PROJECT" (LOWER("PROJECT_CD"))
  ;


  CREATE BITMAP INDEX "STORETW"."ISP_STATION_ID" ON "STORETW"."STATION_PROJECT" (LOWER("STATION_ID"))
  ;


  CREATE UNIQUE INDEX "STORETW"."PK_STATION_PROJECT" ON "STORETW"."STATION_PROJECT" ("FK_PROJECT", "FK_STATION")
  ;


  CREATE BITMAP INDEX "STORETW"."ISP_FK_PROJECT" ON "STORETW"."STATION_PROJECT" ("FK_PROJECT")
  ;


  CREATE BITMAP INDEX "STORETW"."ISP_FK_STATION" ON "STORETW"."STATION_PROJECT" ("FK_STATION")
  ;


  ALTER TABLE "STORETW"."STATION_PROJECT" ADD CONSTRAINT "RE_STN_PROJ_FK_PROJ" FOREIGN KEY ("FK_PROJECT")
	  REFERENCES "STORETW"."DI_PROJECT" ("PK_ISN") ON DELETE CASCADE ENABLE;

