
  CREATE TABLE "STORETW"."WS_HUC_CHAR_SUMMARY"
   (	"HYDROLOGIC_UNIT_CODE" VARCHAR2(12 CHAR) NOT NULL ENABLE,
	"CHARACTERISTIC_ID" NUMBER(12,0) NOT NULL ENABLE,
	"CHARTYPE_ID" NUMBER(12,0) NOT NULL ENABLE,
	"CHAR_DISPLAY_NAME" VARCHAR2(256 CHAR),
	"CHARTYPE_NAME" VARCHAR2(256 CHAR),
	"RESULT_COUNT" NUMBER(12,0),
	"CHAR_ACT_START_DATE" DATE,
	"CHAR_ACT_STOP_DATE" DATE
   ) ;
  ALTER TABLE "STORETW"."WS_HUC_CHAR_SUMMARY" ADD CONSTRAINT "PK_WS_HUC_CHAR_SUMMARY" PRIMARY KEY ("CHARACTERISTIC_ID", "CHARTYPE_ID", "HYDROLOGIC_UNIT_CODE") ENABLE;


  CREATE UNIQUE INDEX "STORETW"."PK_WS_HUC_CHAR_SUMMARY" ON "STORETW"."WS_HUC_CHAR_SUMMARY" ("CHARACTERISTIC_ID", "CHARTYPE_ID", "HYDROLOGIC_UNIT_CODE")
  ;


  CREATE INDEX "STORETW"."IWS_HC_HUC_CHARTYPEID" ON "STORETW"."WS_HUC_CHAR_SUMMARY" (TRIM("HYDROLOGIC_UNIT_CODE"), LOWER(TRIM("CHARTYPE_NAME")))
  ;


  CREATE INDEX "STORETW"."IWS_HC_HUC" ON "STORETW"."WS_HUC_CHAR_SUMMARY" (TRIM("HYDROLOGIC_UNIT_CODE"))
  ;

