
  CREATE TABLE "STORETW"."WS_HUC_ORG_CHAR_SUMMARY"
   (	"HYDROLOGIC_UNIT_CODE" VARCHAR2(12 CHAR) NOT NULL ENABLE,
	"ORGANIZATION_ID" VARCHAR2(256) NOT NULL ENABLE,
	"CHARACTERISTIC_ID" NUMBER(12,0) NOT NULL ENABLE,
	"CHARTYPE_ID" NUMBER(12,0) NOT NULL ENABLE,
	"CHAR_DISPLAY_NAME" VARCHAR2(256 CHAR),
	"CHARTYPE_NAME" VARCHAR2(256 CHAR),
	"RESULT_COUNT" NUMBER(12,0),
	"CHAR_ACT_START_DATE" DATE,
	"CHAR_ACT_STOP_DATE" DATE
   ) ;
  ALTER TABLE "STORETW"."WS_HUC_ORG_CHAR_SUMMARY" ADD CONSTRAINT "PK_WS_HUC_ORG_CHAR_SUMMARY" PRIMARY KEY ("ORGANIZATION_ID", "HYDROLOGIC_UNIT_CODE", "CHARACTERISTIC_ID", "CHARTYPE_ID") ENABLE;


  CREATE UNIQUE INDEX "STORETW"."PK_WS_HUC_ORG_CHAR_SUMMARY" ON "STORETW"."WS_HUC_ORG_CHAR_SUMMARY" ("ORGANIZATION_ID", "HYDROLOGIC_UNIT_CODE", "CHARACTERISTIC_ID", "CHARTYPE_ID")
  ;


  CREATE INDEX "STORETW"."IWS_HOC_HUC_ORGID_CHARTYPEID" ON "STORETW"."WS_HUC_ORG_CHAR_SUMMARY" (TRIM("HYDROLOGIC_UNIT_CODE"), LOWER(TRIM("ORGANIZATION_ID")), LOWER(TRIM("CHARTYPE_NAME")))
  ;


  CREATE INDEX "STORETW"."IWS_HOC_HUC" ON "STORETW"."WS_HUC_ORG_CHAR_SUMMARY" (TRIM("HYDROLOGIC_UNIT_CODE"))
  ;

