
  CREATE TABLE "STORETW"."WS_STATION_DATA"
   (	"HYDROLOGIC_UNIT_CODE" VARCHAR2(12 CHAR),
	"ORGANIZATION_ID" VARCHAR2(256),
	"ORGANIZATION_NAME" VARCHAR2(256),
	"STATION_ID" VARCHAR2(256),
	"STATION_NAME" VARCHAR2(256),
	"STD_LATITUDE" NUMBER(9,7),
	"STD_LONGITUDE" NUMBER(10,7),
	"MIN_ACTIVITY_START_DATE_TIME" DATE,
	"MAX_ACTIVITY_STOP_DATE_TIME" DATE,
	"CHARACTERISTIC_ID" NUMBER(12,0),
	"CHAR_DISPLAY_NAME" VARCHAR2(256 CHAR),
	"CHAR_RESULT_COUNT" NUMBER(12,0),
	"UNIQUE_STATION_IDENTIFIER" VARCHAR2(280 CHAR),
	"CHARACTERISTIC_GROUP_TYPE" VARCHAR2(256 CHAR),
	"RSLT_MIN_VALUE_MEASURE" NUMBER,
	"RSLT_MAX_VALUE_MEASURE" NUMBER,
	"RSLT_AVG_VALUE_MEASURE" NUMBER,
	"RSLT_MEASURE_UNIT" VARCHAR2(10 CHAR),
	"FK_STATION" NUMBER
   ) ;


  CREATE INDEX "STORETW"."IWS_WST_CHAR_ID" ON "STORETW"."WS_STATION_DATA" ("CHARACTERISTIC_ID")
  ;


  CREATE INDEX "STORETW"."IWS_WST_HUC" ON "STORETW"."WS_STATION_DATA" ("HYDROLOGIC_UNIT_CODE")
  ;


  CREATE INDEX "STORETW"."IWS_WST_HUC_ORG_STATN" ON "STORETW"."WS_STATION_DATA" ("HYDROLOGIC_UNIT_CODE", "ORGANIZATION_ID", "STATION_ID")
  ;

