
  CREATE TABLE "STORETW"."WS_STATION_SUMMARY"
   (	"ORGANIZATION_ID" VARCHAR2(256),
	"STATION_ID" VARCHAR2(256),
	"CHARACTERISTIC_ID" NUMBER(12,0),
	"CHARTYPE_ID" NUMBER(12,0),
	"HYDROLOGIC_UNIT_CODE" VARCHAR2(12 CHAR),
	"ORGANIZATION_NAME" VARCHAR2(256),
	"STATION_NAME" VARCHAR2(256),
	"STD_LATITUDE" NUMBER(9,7),
	"STD_LONGITUDE" NUMBER(10,7),
	"MIN_ACTIVITY_START_DATE_TIME" DATE,
	"MAX_ACTIVITY_STOP_DATE_TIME" DATE,
	"CHARTYPE" VARCHAR2(256 CHAR),
	"CHAR_DISPLAY_NAME" VARCHAR2(256 CHAR),
	"CHARACTERISTIC_RESULT_COUNT" NUMBER(12,0),
	"UNIQUE_STATION_IDENTIFIER" VARCHAR2(280 CHAR),
	"CHAR_ACT_START_DATE" DATE,
	"CHAR_ACT_STOP_DATE" DATE,
	"CHARACTERISTIC_GROUP_TYPE" VARCHAR2(256 CHAR),
	"RSLT_MIN_VALUE_MEASURE" NUMBER,
	"RSLT_MAX_VALUE_MEASURE" NUMBER,
	"RSLT_AVG_VALUE_MEASURE" NUMBER,
	"RSLT_MEASURE_UNIT" VARCHAR2(10 CHAR),
	"FK_STATION" NUMBER
   )  ENABLE ROW MOVEMENT ;


  CREATE INDEX "STORETW"."IWS_SS_UNIQUE_STATION_ID" ON "STORETW"."WS_STATION_SUMMARY" (LOWER(TRIM("UNIQUE_STATION_IDENTIFIER")))
  ;


  CREATE INDEX "STORETW"."IWS_SS_CHARTYPE_STATION_ORG" ON "STORETW"."WS_STATION_SUMMARY" (LOWER(TRIM("CHARTYPE")), LOWER(TRIM("STATION_ID")), LOWER(TRIM("ORGANIZATION_ID")))
  ;


  CREATE INDEX "STORETW"."IWS_SS_HUC_STATION_ORG" ON "STORETW"."WS_STATION_SUMMARY" (TRIM("HYDROLOGIC_UNIT_CODE"), LOWER(TRIM("STATION_ID")), LOWER(TRIM("ORGANIZATION_ID")))
  ;


  CREATE INDEX "STORETW"."IWS_SS_HUC" ON "STORETW"."WS_STATION_SUMMARY" (TRIM("HYDROLOGIC_UNIT_CODE"))
  ;


  CREATE INDEX "STORETW"."IWS_SS_HUC_ORG_ID" ON "STORETW"."WS_STATION_SUMMARY" (TRIM("HYDROLOGIC_UNIT_CODE"), LOWER(TRIM("ORGANIZATION_ID")))
  ;


  CREATE INDEX "STORETW"."IWS_SS_CHAR_ID" ON "STORETW"."WS_STATION_SUMMARY" ("CHARACTERISTIC_ID")
  ;

