
  CREATE OR REPLACE FORCE VIEW "STORETW"."STATION_VIEW" ("PKISNIDENTIFIER", "ORGANIZATIONIDENTIFIER", "ORGANIZATIONFORMALNAME", "MONITORINGLOCATIONIDENTIFIER", "MONITORINGLOCATIONNAME", "MONITORINGLOCATIONTYPENAME", "LATITUDEMEASURE", "LONGITUDEMEASURE", "HORIZONTALREFERENCEDATUMCODE", "HORIZONTALREFERENCEDATUMNAME", "HORIZONTALCOLLECTIONMETHODNAME", "SOURCEMAPSCALENUMBER", "VERTICALMEASUREVALUE", "VERTICALMEASUREUNITCODE", "VERTICALREFERENCEDATUMCODE", "VERTICALREFERENCEDATUMNAME", "VERTICALCOLLECTIONMETHODTEXT", "COUNTRYNAME", "STATENAME", "COUNTYNAME", "COUNTRYCODE", "FIPSSTATECODE", "FIPSCOUNTYCODE", "HUCEIGHTDIGITCODE", "HUCEIGHTDIGITNAME", "RF1SEGMENTCODE", "RF1SEGMENTNAME", "RF1MILEAGEMEASURE", "ONREACHINDICATOR", "NRCSWATERSHEDIDENTIFIER", "PRIMARYESTUARYNAME", "SECONDARYESTUARYNAME", "OTHERESTUARYNAME", "GREATLAKENAME", "OCEANNAME", "NATIVEAMERICANLANDNAME", "FRSKEYIDENTIFIER", "STATIONSGOINDICATOR", "STATIONVISITED", "PROGRAMINDICATOR", "HUCTWELVEDIGITCODE", "SHAPE", "OBJECTID") AS
  SELECT sd.PK_ISN PkISNIdentifier,
--   DATABASE_REFRESH_DATE DatabaseRefreshDate,
   sd.ORGANIZATION_ID OrganizationIdentifier,
   org.ORGANIZATION_NAME OrganizationFormalName,
   sd.STATION_ID MonitoringLocationIdentifier,
   REPLACE(REPLACE(sd.STATION_NAME, '-',' '), '&','and')  MonitoringLocationName,
   st.PRIMARY_TYPE MonitoringLocationTypeName,
--        st.SECONDARY_TYPE SecondaryTypeName,
--   sd.WELL_NUMBER WellNumber,
--   sd.PIPE_NUMBER PipeNumber,
--   sd.LOCATION_POINT_TYPE MonitoringLocationPointTypeName,
--   sd.POINT_SEQUENCE_NUMBER PointSequenceNumber,
   sd.WGS84_LATITUDE LatitudeMeasure,
   sd.WGS84_LONGITUDE LongitudeMeasure,
--   hd.ID_CODE HorizontalReferenceDatumCode,
--   hd.HORIZONTAL_DATUM HorizontalReferenceDatumName,
   'WGS84' HorizontalReferenceDatumCode,
   'World Geodetic System 1984' HorizontalReferenceDatumName,
   hm.GEOPOSITIONING_METHOD HorizontalCollectionMethodName,
   sd.MAP_SCALE SourceMapScaleNumber,
   sd.ELEVATION VerticalMeasureValue,
   sd.ELEVATION_UNIT VerticalMeasureUnitCode,
   vd.ID_CODE VerticalReferenceDatumCode,
   vd.ELEVATION_DATUM VerticalReferenceDatumName,
   vm.ELEVATION_METHOD VerticalCollectionMethodText,
   gs.COUNTRY_NAME CountryName,
--   sd.STATE_POSTAL_CODE StateZIPCode,
   gs.STATE_NAME StateName,
   gc.COUNTY_NAME CountyName,
   gs.COUNTRY_CODE CountryCode,
   gs.FIPS_STATE_CODE FIPSStateCode,
   gc.FIPS_COUNTY_CODE FIPSCountyCode,
   sd.GENERATED_HUC HUCEightDigitCode,
   ca.HYDROLOGIC_UNIT_NAME HUCEightDigitName,
   sd.RF1_SEGMENT_CODE RF1SegmentCode,
   sd.RF1_SEGMENT_NAME RF1SegmentName,
   sd.RF1_MILEAGE RF1MileageMeasure,
   sd.ON_REACH_IND OnReachIndicator,
--   sd.RF3_RIVER_REACH_CODE RF3RiverReachCode,
   sd.NRCS_WATERSHED_ID NRCSWatershedIdentifier,
   ep.PRIMARY_ESTUARY PrimaryEstuaryName,
   es.SECONDARY_ESTUARY SecondaryEstuaryName,
   sd.OTHER_ESTUARY_NAME OtherEstuaryName,
   sd.GREAT_LAKE_NAME GreatLakeName,
   sd.OCEAN_NAME OceanName,
   sd.NATV_AMERICAN_LAND_NAME NativeAmericanLandName,
   sd.FRS_KEY_IDENTIFIER FRSKeyIdentifier,
   sd.SGO_INDICATOR StationSGOIndicator,
   sd.STATION_VISITED StationVisited,
   sd.PROGRAM_INDICATOR ProgramIndicator,
   sd.huctwelvedigitcode,
   sd.GEOM AS shape,
   CAST(sd.PK_ISN AS INTEGER) AS objectid
FROM    storetw.FA_STATION sd,
   storetw.DI_ORG org,
   storetw.DI_STATN_TYPES st,
   storetw.LU_MAD_HDATUM hd,
   storetw.LU_MAD_HMETHOD hm,
   storetw.LU_MAD_VDATUM vd,
   storetw.LU_MAD_VMETHOD vm,
   storetw.DI_GEO_STATE gs,
   storetw.DI_GEO_COUNTY gc,
   storetw.DI_DB_CAT ca,
   storetw.LU_ESTRY_PRIMARY ep,
   storetw.LU_ESTRY_SECONDARY es
WHERE
   sd.FK_ORG = org.PK_ISN (+) AND
   FK_STATN_TYPES = st.PK_ISN (+)AND
   FK_WGS84_HDATUM = hd.PK_ISN (+) AND
   FK_MAD_HMETHOD = hm.PK_ISN (+) AND
   sd.FK_MAD_VDATUM = vd.PK_ISN (+) AND
   sd.FK_MAD_VMETHOD = vm.PK_ISN (+) AND
   sd.FK_GEO_STATE = gs.PK_ISN (+) AND
   sd.FK_GEO_COUNTY = gc.PK_ISN(+) AND
   sd.FK_GEN_DB_CAT = ca.PK_ISN (+) AND
   sd.FK_ESTRY_PRIMARY = ep.PK_ISN (+) AND
      sd.FK_ESTRY_SECONDARY = es.PK_ISN (+) AND
   sd.LOCATION_POINT_TYPE = '*POINT OF RECORD';

