# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.4
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.



from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_gdal', [dirname(__file__)])
        except ImportError:
            import _gdal
            return _gdal
        if fp is not None:
            try:
                _mod = imp.load_module('_gdal', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _gdal = swig_import_helper()
    del swig_import_helper
else:
    import _gdal
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


def _swig_setattr_nondynamic_method(set):
    def set_attr(self,name,value):
        if (name == "thisown"): return self.this.own(value)
        if hasattr(self,name) or (name == "this"):
            set(self,name,value)
        else:
            raise AttributeError("You cannot add attributes to %s" % self)
    return set_attr


have_warned = 0
def deprecation_warn( module ):
  global have_warned

  if have_warned == 1:
      return

  have_warned = 1

  from warnings import warn
  warn('%s.py was placed in a namespace, it is now available as osgeo.%s' % (module,module),
       DeprecationWarning)


from gdalconst import *
import gdalconst


import sys
byteorders = {"little": "<",
              "big": ">"}
array_modes = { gdalconst.GDT_Int16:    ("%si2" % byteorders[sys.byteorder]),
                gdalconst.GDT_UInt16:   ("%su2" % byteorders[sys.byteorder]),
                gdalconst.GDT_Int32:    ("%si4" % byteorders[sys.byteorder]),
                gdalconst.GDT_UInt32:   ("%su4" % byteorders[sys.byteorder]),
                gdalconst.GDT_Float32:  ("%sf4" % byteorders[sys.byteorder]),
                gdalconst.GDT_Float64:  ("%sf8" % byteorders[sys.byteorder]),
                gdalconst.GDT_CFloat32: ("%sf4" % byteorders[sys.byteorder]),
                gdalconst.GDT_CFloat64: ("%sf8" % byteorders[sys.byteorder]),
                gdalconst.GDT_Byte:     ("%st8" % byteorders[sys.byteorder]),
}

def RGBFile2PCTFile( src_filename, dst_filename ):
  src_ds = Open(src_filename)
  if src_ds is None or src_ds == 'NULL':
      return 1

  ct = ColorTable()
  err = ComputeMedianCutPCT( src_ds.GetRasterBand(1),
                             src_ds.GetRasterBand(2),
                             src_ds.GetRasterBand(3),
                             256, ct )
  if err != 0:
      return err

  gtiff_driver = GetDriverByName('GTiff')
  if gtiff_driver is None:
      return 1

  dst_ds = gtiff_driver.Create( dst_filename,
                                src_ds.RasterXSize, src_ds.RasterYSize )
  dst_ds.GetRasterBand(1).SetRasterColorTable( ct )

  err = DitherRGB2PCT( src_ds.GetRasterBand(1),
                       src_ds.GetRasterBand(2),
                       src_ds.GetRasterBand(3),
                       dst_ds.GetRasterBand(1),
                       ct )
  dst_ds = None
  src_ds = None

  return 0


def GetUseExceptions(*args):
  """GetUseExceptions() -> int"""
  return _gdal.GetUseExceptions(*args)

def UseExceptions(*args):
  """UseExceptions()"""
  return _gdal.UseExceptions(*args)

def DontUseExceptions(*args):
  """DontUseExceptions()"""
  return _gdal.DontUseExceptions(*args)

def VSIFReadL(*args):
  """VSIFReadL(unsigned int nMembSize, unsigned int nMembCount, VSILFILE fp) -> unsigned int"""
  return _gdal.VSIFReadL(*args)
def _is_str_or_unicode(o):
    return isinstance(o, str) or str(type(o)) == "<type 'unicode'>"

def InfoOptions(options = [], format = 'text', deserialize = True,
         computeMinMax = False, reportHistograms = False, reportProj4 = False,
         stats = False, approxStats = False, computeChecksum = False,
         showGCPs = True, showMetadata = True, showRAT = True, showColorTable = True,
         listMDD = False, showFileList = True, allMetadata = False,
         extraMDDomains = None):
    """ Create a InfoOptions() object that can be passed to gdal.Info()
        options can be be an array of strings, a string or let empty and filled from other keywords."""
    import copy

    if _is_str_or_unicode(options):
        new_options = ParseCommandLine(options)
        format = 'text'
        if '-json' in new_options:
            format = 'json'
    else:
        new_options = copy.copy(options)
        if format == 'json':
            new_options += ['-json']
        if computeMinMax:
            new_options += ['-mm']
        if reportHistograms:
            new_options += ['-hist']
        if reportProj4:
            new_options += ['-proj4']
        if stats:
            new_options += ['-stats']
        if approxStats:
            new_options += ['-approx_stats']
        if computeChecksum:
            new_options += ['-checksum']
        if not showGCPs:
            new_options += ['-nogcp']
        if not showMetadata:
            new_options += ['-nomd']
        if not showRAT:
            new_options += ['-norat']
        if not showColorTable:
            new_options += ['-noct']
        if listMDD:
            new_options += ['-listmdd']
        if not showFileList:
            new_options += ['-nofl']
        if allMetadata:
            new_options += ['-mdd', 'all']
        if extraMDDomains is not None:
            for mdd in extraMDDomains:
                new_options += ['-mdd', mdd]

    return (GDALInfoOptions(new_options), format, deserialize)

def Info(ds, **kwargs):
    """ Return information on a dataset.
        Arguments are :
          ds --- a Dataset object or a filename
        Keyword arguments are :
          options --- return of gdal.InfoOptions(), string or array of strings
          other keywords arguments of gdal.InfoOptions()
        If options is provided as a gdal.InfoOptions() object, other keywords are ignored. """
    if 'options' not in kwargs or type(kwargs['options']) == type([]) or _is_str_or_unicode(kwargs['options']):
        (opts, format, deserialize) = InfoOptions(**kwargs)
    else:
        (opts, format, deserialize) = kwargs['options']
    if _is_str_or_unicode(ds):
        ds = Open(ds)
    ret = InfoInternal(ds, opts)
    if format == 'json' and deserialize:
        import json
        ret = json.loads(ret)
    return ret

def _strHighPrec(x):
    return x if _is_str_or_unicode(x) else '%.18g' % x

def TranslateOptions(options = [], format = None,
              outputType = GDT_Unknown, bandList = None, maskBand = None,
              width = 0, height = 0, widthPct = 0.0, heightPct = 0.0,
              xRes = 0.0, yRes = 0.0,
              creationOptions = None, srcWin = None, projWin = None, projWinSRS = None, strict = False,
              unscale = False, scaleParams = None, exponents = None,
              outputBounds = None, metadataOptions = None,
              outputSRS = None, GCPs = None,
              noData = None, rgbExpand = None,
              stats = False, rat = True, resampleAlg = None,
              callback = None, callback_data = None):
    """ Create a TranslateOptions() object that can be passed to gdal.Translate()
        Keyword arguments are :
          options --- can be be an array of strings, a string or let empty and filled from other keywords.
          format --- output format ("GTiff", etc...)
          outputType --- output type (gdal.GDT_Byte, etc...)
          bandList --- array of band numbers (index start at 1)
          maskBand --- mask band to generate or not ("none", "auto", "mask", 1, ...)
          width --- width of the output raster in pixel
          height --- height of the output raster in pixel
          widthPct --- width of the output raster in percentage (100 = original width)
          heightPct --- height of the output raster in percentage (100 = original height)
          xRes --- output horizontal resolution
          yRes --- output vertical resolution
          creationOptions --- list of creation options
          srcWin --- subwindow in pixels to extract: [left_x, top_y, width, height]
          projWin --- subwindow in projected coordinates to extract: [ulx, uly, lrx, lry]
          projWinSRS --- SRS in which projWin is expressed
          strict --- strict mode
          unscale --- unscale values with scale and offset metadata
          scaleParams --- list of scale parameters, each of the form [src_min,src_max] or [src_min,src_max,dst_min,dst_max]
          exponents --- list of exponentiation parameters
          outputBounds --- assigned output bounds: [ulx, uly, lrx, lry]
          metadataOptions --- list of metadata options
          outputSRS --- assigned output SRS
          GCPs --- list of GCPs
          noData --- nodata value (or "none" to unset it)
          rgbExpand --- Color palette expansion mode: "gray", "rgb", "rgba"
          stats --- whether to calculate statistics
          rat --- whether to write source RAT
          resampleAlg --- resampling mode
          callback --- callback method
          callback_data --- user data for callback
    """
    import copy

    if _is_str_or_unicode(options):
        new_options = ParseCommandLine(options)
    else:
        new_options = copy.copy(options)
        if format is not None:
            new_options += ['-of', format]
        if outputType != GDT_Unknown:
            new_options += ['-ot', GetDataTypeName(outputType) ]
        if maskBand != None:
            new_options += ['-mask', str(maskBand) ]
        if bandList != None:
            for b in bandList:
                new_options += ['-b', str(b) ]
        if width != 0 or height != 0:
            new_options += ['-outsize', str(width), str(height)]
        elif widthPct != 0 and heightPct != 0:
            new_options += ['-outsize', str(widthPct) + '%%', str(heightPct) + '%%']
        if creationOptions is not None:
            for opt in creationOptions:
                new_options += ['-co', opt ]
        if srcWin is not None:
            new_options += ['-srcwin', _strHighPrec(srcWin[0]), _strHighPrec(srcWin[1]), _strHighPrec(srcWin[2]), _strHighPrec(srcWin[3])]
        if strict:
            new_options += ['-strict']
        if unscale:
            new_options += ['-unscale']
        if scaleParams:
            for scaleParam in scaleParams:
                new_options += ['-scale']
                for v in scaleParam:
                    new_options += [ str(v) ]
        if exponents:
            for exponent in exponents:
                new_options += ['-exponent', _strHighPrec(exponent)]
        if outputBounds is not None:
            new_options += ['-a_ullr', _strHighPrec(outputBounds[0]), _strHighPrec(outputBounds[1]), _strHighPrec(outputBounds[2]), _strHighPrec(outputBounds[3])]
        if metadataOptions is not None:
            for opt in metadataOptions:
                new_options += ['-mo', opt ]
        if outputSRS is not None:
            new_options += ['-a_srs', str(outputSRS) ]
        if GCPs is not None:
            for gcp in GCPs:
                new_options += ['-gcp', _strHighPrec(gcp.GCPPixel), _strHighPrec(gcp.GCPLine), _strHighPrec(gcp.GCPX), str(gcp.GCPY), _strHighPrec(gcp.GCPZ) ]
        if projWin is not None:
            new_options += ['-projwin', _strHighPrec(projWin[0]), _strHighPrec(projWin[1]), _strHighPrec(projWin[2]), _strHighPrec(projWin[3])]
        if projWinSRS is not None:
            new_options += ['-projwin_srs', str(projWinSRS) ]
        if noData is not None:
            new_options += ['-a_nodata', _strHighPrec(noData) ]
        if rgbExpand is not None:
            new_options += ['-expand', str(rgbExpand) ]
        if stats:
            new_options += ['-stats']
        if not rat:
            new_options += ['-norat']
        if resampleAlg is not None:
            if resampleAlg == GRA_NearestNeighbour:
                new_options += ['-r', 'near']
            elif resampleAlg == GRA_Bilinear:
                new_options += ['-r', 'bilinear']
            elif resampleAlg == GRA_Cubic:
                new_options += ['-r', 'cubic']
            elif resampleAlg == GRA_CubicSpline:
                new_options += ['-r', 'cubicspline']
            elif resampleAlg == GRA_Lanczos:
                new_options += ['-r', 'lanczos']
            elif resampleAlg == GRA_Average:
                new_options += ['-r', 'average']
            elif resampleAlg == GRA_Mode:
                new_options += ['-r', 'mode']
            else:
                new_options += ['-r', str(resampleAlg) ]
        if xRes != 0 and yRes != 0:
            new_options += ['-tr', _strHighPrec(xRes), _strHighPrec(yRes) ]

    return (GDALTranslateOptions(new_options), callback, callback_data)

def Translate(destName, srcDS, **kwargs):
    """ Convert a dataset.
        Arguments are :
          destName --- Output dataset name
          srcDS --- a Dataset object or a filename
        Keyword arguments are :
          options --- return of gdal.TranslateOptions(), string or array of strings
          other keywords arguments of gdal.TranslateOptions()
        If options is provided as a gdal.TranslateOptions() object, other keywords are ignored. """

    if 'options' not in kwargs or type(kwargs['options']) == type([]) or _is_str_or_unicode(kwargs['options']):
        (opts, callback, callback_data) = TranslateOptions(**kwargs)
    else:
        (opts, callback, callback_data) = kwargs['options']
    if _is_str_or_unicode(srcDS):
        srcDS = Open(srcDS)

    return TranslateInternal(destName, srcDS, opts, callback, callback_data)

def WarpOptions(options = [], format = None,
         outputBounds = None,
         outputBoundsSRS = None,
         xRes = None, yRes = None, targetAlignedPixels = False,
         width = 0, height = 0,
         srcSRS = None, dstSRS = None,
         srcAlpha = False, dstAlpha = False,
         warpOptions = None, errorThreshold = None,
         warpMemoryLimit = None, creationOptions = None, outputType = GDT_Unknown,
         workingType = GDT_Unknown, resampleAlg = None,
         srcNodata = None, dstNodata = None, multithread = False,
         tps = False, rpc = False, geoloc = False, polynomialOrder = None,
         transformerOptions = None, cutlineDSName = None,
         cutlineLayer = None, cutlineWhere = None, cutlineSQL = None, cutlineBlend = None, cropToCutline = False,
         copyMetadata = True, metadataConflictValue = None,
         setColorInterpretation = False,
         callback = None, callback_data = None):
    """ Create a WarpOptions() object that can be passed to gdal.Warp()
        Keyword arguments are :
          options --- can be be an array of strings, a string or let empty and filled from other keywords.
          format --- output format ("GTiff", etc...)
          outputBounds --- output bounds as (minX, minY, maxX, maxY) in target SRS
          outputBoundsSRS --- SRS in which output bounds are expressed, in the case they are not expressed in dstSRS
          xRes, yRes --- output resolution in target SRS
          targetAlignedPixels --- whether to force output bounds to be multiple of output resolution
          width --- width of the output raster in pixel
          height --- height of the output raster in pixel
          srcSRS --- source SRS
          dstSRS --- output SRS
          srcAlpha --- whether to force the last band of the input dataset to be considered as an alpha band
          dstAlpha --- whether to force the creation of an output alpha band
          outputType --- output type (gdal.GDT_Byte, etc...)
          workingType --- working type (gdal.GDT_Byte, etc...)
          warpOptions --- list of warping options
          errorThreshold --- error threshold for approximation transformer (in pixels)
          warpMemoryLimit --- size of working buffer in bytes
          resampleAlg --- resampling mode
          creationOptions --- list of creation options
          srcNodata --- source nodata value(s)
          dstNodata --- output nodata value(s)
          multithread --- whether to multithread computation and I/O operations
          tps --- whether to use Thin Plate Spline GCP transformer
          rpc --- whether to use RPC transformer
          geoloc --- whether to use GeoLocation array transformer
          polynomialOrder --- order of polynomial GCP interpolation
          transformerOptions --- list of transformer options
          cutlineDSName --- cutline dataset name
          cutlineLayer --- cutline layer name
          cutlineWhere --- cutline WHERE clause
          cutlineSQL --- cutline SQL statement
          cutlineBlend --- cutline blend distance in pixels
          cropToCutline --- whether to use cutline extent for output bounds
          copyMetadata --- whether to copy source metadata
          metadataConflictValue --- metadata data conflict value
          setColorInterpretation --- whether to force color interpretation of input bands to output bands
          callback --- callback method
          callback_data --- user data for callback
    """
    import copy

    if _is_str_or_unicode(options):
        new_options = ParseCommandLine(options)
    else:
        new_options = copy.copy(options)
        if format is not None:
            new_options += ['-of', format]
        if outputType != GDT_Unknown:
            new_options += ['-ot', GetDataTypeName(outputType) ]
        if workingType != GDT_Unknown:
            new_options += ['-wt', GetDataTypeName(workingType) ]
        if outputBounds is not None:
            new_options += ['-te', _strHighPrec(outputBounds[0]), _strHighPrec(outputBounds[1]), _strHighPrec(outputBounds[2]), _strHighPrec(outputBounds[3]) ]
        if outputBoundsSRS is not None:
            new_options += ['-te_srs', str(outputBoundsSRS) ]
        if xRes is not None and yRes is not None:
            new_options += ['-tr', _strHighPrec(xRes), _strHighPrec(yRes) ]
        if width != 0 or height != 0:
            new_options += ['-ts', str(width), str(height)]
        if srcSRS is not None:
            new_options += ['-s_srs', str(srcSRS) ]
        if dstSRS is not None:
            new_options += ['-t_srs', str(dstSRS) ]
        if targetAlignedPixels:
            new_options += ['-tap']
        if srcAlpha:
            new_options += ['-srcalpha']
        if dstAlpha:
            new_options += ['-dstalpha']
        if warpOptions is not None:
            for opt in warpOptions:
                new_options += ['-wo', str(opt)]
        if errorThreshold is not None:
            new_options += ['-et', _strHighPrec(errorThreshold)]
        if resampleAlg is not None:
            if resampleAlg == GRIORA_NearestNeighbour:
                new_options += ['-r', 'near']
            elif resampleAlg == GRIORA_Bilinear:
                new_options += ['-rb']
            elif resampleAlg == GRIORA_Cubic:
                new_options += ['-rc']
            elif resampleAlg == GRIORA_CubicSpline:
                new_options += ['-rcs']
            elif resampleAlg == GRIORA_Lanczos:
                new_options += ['-r', 'lanczos']
            elif resampleAlg == GRIORA_Average:
                new_options += ['-r', 'average']
            elif resampleAlg == GRIORA_Mode:
                new_options += ['-r', 'mode']
            elif resampleAlg == GRIORA_Gauss:
                new_options += ['-r', 'gauss']
            else:
                new_options += ['-r', str(resampleAlg) ]
        if warpMemoryLimit is not None:
            new_options += ['-wm', str(warpMemoryLimit) ]
        if creationOptions is not None:
            for opt in creationOptions:
                new_options += ['-co', opt ]
        if srcNodata is not None:
            new_options += ['-srcnodata', str(srcNodata) ]
        if dstNodata is not None:
            new_options += ['-dstnodata', str(dstNodata) ]
        if multithread:
            new_options += ['-multi']
        if tps:
            new_options += ['-tps']
        if rpc:
            new_options += ['-rpc']
        if geoloc:
            new_options += ['-geoloc']
        if polynomialOrder is not None:
            new_options += ['-order', str(polynomialOrder)]
        if transformerOptions is not None:
            for opt in transformerOptions:
                new_options += ['-to', opt ]
        if cutlineDSName is not None:
            new_options += ['-cutline', str(cutlineDSName) ]
        if cutlineLayer is not None:
            new_options += ['-cl', str(cutlineLayer) ]
        if cutlineWhere is not None:
            new_options += ['-cwhere', str(cutlineWhere) ]
        if cutlineSQL is not None:
            new_options += ['-csql', str(cutlineSQL) ]
        if cutlineBlend is not None:
            new_options += ['-cblend', str(cutlineBlend) ]
        if cropToCutline:
            new_options += ['-crop_to_cutline']
        if not copyMetadata:
            new_options += ['-nomd']
        if metadataConflictValue:
            new_options += ['-cvmd', str(metadataConflictValue) ]
        if setColorInterpretation:
            new_options += ['-setci']

    return (GDALWarpAppOptions(new_options), callback, callback_data)

def Warp(destNameOrDestDS, srcDSOrSrcDSTab, **kwargs):
    """ Warp one or several datasets.
        Arguments are :
          destNameOrDestDS --- Output dataset name or object
          srcDSOrSrcDSTab --- an array of Dataset objects or filenames, or a Dataset object or a filename
        Keyword arguments are :
          options --- return of gdal.WarpOptions(), string or array of strings
          other keywords arguments of gdal.WarpOptions()
        If options is provided as a gdal.WarpOptions() object, other keywords are ignored. """

    if 'options' not in kwargs or type(kwargs['options']) == type([]) or _is_str_or_unicode(kwargs['options']):
        (opts, callback, callback_data) = WarpOptions(**kwargs)
    else:
        (opts, callback, callback_data) = kwargs['options']
    if _is_str_or_unicode(srcDSOrSrcDSTab):
        srcDSTab = [Open(srcDSOrSrcDSTab)]
    elif type(srcDSOrSrcDSTab) == type([]):
        srcDSTab = []
        for elt in srcDSOrSrcDSTab:
            if _is_str_or_unicode(elt):
                srcDSTab.append(Open(elt))
            else:
                srcDSTab.append(elt)
    else:
        srcDSTab = [ srcDSOrSrcDSTab ]

    if _is_str_or_unicode(destNameOrDestDS):
        return wrapper_GDALWarpDestName(destNameOrDestDS, srcDSTab, opts, callback, callback_data)
    else:
        return wrapper_GDALWarpDestDS(destNameOrDestDS, srcDSTab, opts, callback, callback_data)


def VectorTranslateOptions(options = [], format = None,
         accessMode = None,
         srcSRS = None, dstSRS = None, reproject = True,
         SQLStatement = None, SQLDialect = None, where = None, selectFields = None,
         addFields = False,
         forceNullable = False,
         spatFilter = None, spatSRS = None,
         datasetCreationOptions = None,
         layerCreationOptions = None,
         layers = None,
         layerName = None,
         geometryType = None,
         dim = None,
         segmentizeMaxDist= None,
         zField = None,
         skipFailures = False,
         limit = None,
         callback = None, callback_data = None):
    """ Create a VectorTranslateOptions() object that can be passed to gdal.VectorTranslate()
        Keyword arguments are :
          options --- can be be an array of strings, a string or let empty and filled from other keywords.
          format --- output format ("ESRI Shapefile", etc...)
          accessMode --- None for creation, 'update', 'append', 'overwrite'
          srcSRS --- source SRS
          dstSRS --- output SRS (with reprojection if reproject = True)
          reproject --- whether to do reprojection
          SQLStatement --- SQL statement to apply to the source dataset
          SQLDialect --- SQL dialect ('OGRSQL', 'SQLITE', ...)
          where --- WHERE clause to apply to source layer(s)
          selectFields --- list of fields to select
          addFields --- whether to add new fields found in source layers (to be used with accessMode == 'append')
          forceNullable --- whether to drop NOT NULL constraints on newly created fields
          spatFilter --- spatial filter as (minX, minY, maxX, maxY) bounding box
          spatSRS --- SRS in which the spatFilter is expressed. If not specified, it is assumed to be the one of the layer(s)
          datasetCreationOptions --- list of dataset creation options
          layerCreationOptions --- list of layer creation options
          layers --- list of layers to convert
          layerName --- output layer name
          geometryType --- output layer geometry type ('POINT', ....)
          dim --- output dimension ('XY', 'XYZ', 'XYM', 'XYZM', 'layer_dim')
          segmentizeMaxDist --- maximum distance between consecutive nodes of a line geometry
          zField --- name of field to use to set the Z component of geometries
          skipFailures --- whether to skip failures
          limit -- maximum number of features to read per layer
          callback --- callback method
          callback_data --- user data for callback
    """
    import copy

    if _is_str_or_unicode(options):
        new_options = ParseCommandLine(options)
    else:
        new_options = copy.copy(options)
        if format is not None:
            new_options += ['-f', format]
        if srcSRS is not None:
            new_options += ['-s_srs', str(srcSRS) ]
        if dstSRS is not None:
            if reproject:
                new_options += ['-t_srs', str(dstSRS) ]
            else:
                new_options += ['-a_srs', str(dstSRS) ]
        if SQLStatement is not None:
            new_options += ['-sql', str(SQLStatement) ]
        if SQLDialect is not None:
            new_options += ['-dialect', str(SQLDialect) ]
        if where is not None:
            new_options += ['-where', str(where) ]
        if accessMode is not None:
            if accessMode == 'update':
                new_options += ['-update']
            elif accessMode == 'append':
                new_options += ['-append']
            elif accessMode == 'overwrite':
                new_options += ['-overwrite']
            else:
                raise Exception('unhandled accessMode')
        if addFields:
            new_options += ['-addfields']
        if forceNullable:
            new_options += ['-forceNullable']
        if selectFields is not None:
            val = ''
            for item in selectFields:
                if len(val)>0:
                    val += ','
                val += item
            new_options += ['-select', val]
        if datasetCreationOptions is not None:
            for opt in datasetCreationOptions:
                new_options += ['-dsco', opt ]
        if layerCreationOptions is not None:
            for opt in layerCreationOptions:
                new_options += ['-lco', opt ]
        if layers is not None:
            if _is_str_or_unicode(layers):
                new_options += [ layers ]
            else:
                for lyr in layers:
                    new_options += [ lyr ]
        if segmentizeMaxDist is not None:
            new_options += ['-segmentize', str(segmentizeMaxDist) ]
        if spatFilter is not None:
            new_options += ['-spat', str(spatFilter[0]), str(spatFilter[1]), str(spatFilter[2]), str(spatFilter[3]) ]
        if spatSRS is not None:
            new_options += ['-spat_srs', str(spatSRS) ]
        if layerName is not None:
            new_options += ['-nln', layerName]
        if geometryType is not None:
            new_options += ['-nlt', geometryType]
        if dim is not None:
            new_options += ['-dim', dim]
        if zField is not None:
            new_options += ['-zfield', zField]
        if skipFailures:
            new_options += ['-skip']
        if limit is not None:
            new_options += ['-limit', str(limit)]
    if callback is not None:
        new_options += [ '-progress' ]

    return (GDALVectorTranslateOptions(new_options), callback, callback_data)

def VectorTranslate(destNameOrDestDS, srcDS, **kwargs):
    """ Convert one vector dataset
        Arguments are :
          destNameOrDestDS --- Output dataset name or object
          srcDS --- a Dataset object or a filename
        Keyword arguments are :
          options --- return of gdal.VectorTranslateOptions(), string or array of strings
          other keywords arguments of gdal.VectorTranslateOptions()
        If options is provided as a gdal.VectorTranslateOptions() object, other keywords are ignored. """

    if 'options' not in kwargs or type(kwargs['options']) == type([]) or _is_str_or_unicode(kwargs['options']):
        (opts, callback, callback_data) = VectorTranslateOptions(**kwargs)
    else:
        (opts, callback, callback_data) = kwargs['options']
    if _is_str_or_unicode(srcDS):
        srcDS = OpenEx(srcDS, OF_VECTOR)

    if _is_str_or_unicode(destNameOrDestDS):
        return wrapper_GDALVectorTranslateDestName(destNameOrDestDS, srcDS, opts, callback, callback_data)
    else:
        return wrapper_GDALVectorTranslateDestDS(destNameOrDestDS, srcDS, opts, callback, callback_data)

def DEMProcessingOptions(options = [], colorFilename = None, format = None,
              creationOptions = None, computeEdges = False, alg = 'Horn', band = 1,
              zFactor = None, scale = None, azimuth = None, altitude = None,
              combined = False, multiDirectional = False,
              slopeFormat = None, trigonometric = False, zeroForFlat = False,
              addAlpha = None,
              callback = None, callback_data = None):
    """ Create a DEMProcessingOptions() object that can be passed to gdal.DEMProcessing()
        Keyword arguments are :
          options --- can be be an array of strings, a string or let empty and filled from other keywords.
          colorFilename --- (mandatory for "color-relief") name of file that contains palette definition for the "color-relief" processing.
          format --- output format ("GTiff", etc...)
          creationOptions --- list of creation options
          computeEdges --- whether to compute values at raster edges.
          alg --- 'ZevenbergenThorne' or 'Horn'
          band --- source band number to use
          zFactor --- (hillshade only) vertical exaggeration used to pre-multiply the elevations.
          scale --- ratio of vertical units to horizontal.
          azimuth --- (hillshade only) azimuth of the light, in degrees. 0 if it comes from the top of the raster, 90 from the east, ... The default value, 315, should rarely be changed as it is the value generally used to generate shaded maps.
          altitude ---(hillshade only) altitude of the light, in degrees. 90 if the light comes from above the DEM, 0 if it is raking light.
          combined --- (hillshade only) whether to compute combined shading, a combination of slope and oblique shading.
          multiDirectional --- (hillshade only) whether to compute multi-directional shading
          slopeformat --- (slope only) "degree" or "percent".
          trigonometric --- (aspect only) whether to return trigonometric angle instead of azimuth. Thus 0deg means East, 90deg North, 180deg West, 270deg South.
          zeroForFlat --- (aspect only) whether to return 0 for flat areas with slope=0, instead of -9999.
          addAlpha --- adds an alpha band to the output file (only for processing = 'color-relief')
          callback --- callback method
          callback_data --- user data for callback
    """
    import copy

    if _is_str_or_unicode(options):
        new_options = ParseCommandLine(options)
    else:
        new_options = copy.copy(options)
        if format is not None:
            new_options += ['-of', format]
        if creationOptions is not None:
            for opt in creationOptions:
                new_options += ['-co', opt ]
        if computeEdges:
            new_options += ['-compute_edges' ]
        if alg ==  'ZevenbergenThorne':
            new_options += ['-alg', 'ZevenbergenThorne']
        new_options += ['-b', str(band) ]
        if zFactor is not None:
            new_options += ['-z', str(zFactor) ]
        if scale is not None:
            new_options += ['-s', str(scale) ]
        if azimuth is not None:
            new_options += ['-az', str(azimuth) ]
        if altitude is not None:
            new_options += ['-alt', str(altitude) ]
        if combined:
            new_options += ['-combined' ]
        if multiDirectional:
            new_options += ['-multidirectional' ]
        if slopeFormat == 'percent':
            new_options += ['-p' ]
        if trigonometric:
            new_options += ['-trigonometric' ]
        if zeroForFlat:
            new_options += ['-zero_for_flat' ]
        if addAlpha:
            new_options += [ '-alpha' ]

    return (GDALDEMProcessingOptions(new_options), colorFilename, callback, callback_data)

def DEMProcessing(destName, srcDS, processing, **kwargs):
    """ Apply a DEM processing.
        Arguments are :
          destName --- Output dataset name
          srcDS --- a Dataset object or a filename
          processing --- one of "hillshade", "slope", "aspect", "color-relief", "TRI", "TPI", "Roughness"
        Keyword arguments are :
          options --- return of gdal.DEMProcessingOptions(), string or array of strings
          other keywords arguments of gdal.DEMProcessingOptions()
        If options is provided as a gdal.DEMProcessingOptions() object, other keywords are ignored. """

    if 'options' not in kwargs or type(kwargs['options']) == type([]) or _is_str_or_unicode(kwargs['options']):
        (opts, colorFilename, callback, callback_data) = DEMProcessingOptions(**kwargs)
    else:
        (opts, colorFilename, callback, callback_data) = kwargs['options']
    if _is_str_or_unicode(srcDS):
        srcDS = Open(srcDS)

    return DEMProcessingInternal(destName, srcDS, processing, colorFilename, opts, callback, callback_data)


def NearblackOptions(options = [], format = None,
         creationOptions = None, white = False, colors = None,
         maxNonBlack = None, nearDist = None, setAlpha = False, setMask = False,
         callback = None, callback_data = None):
    """ Create a NearblackOptions() object that can be passed to gdal.Nearblack()
        Keyword arguments are :
          options --- can be be an array of strings, a string or let empty and filled from other keywords.
          format --- output format ("GTiff", etc...)
          creationOptions --- list of creation options
          white --- whether to search for nearly white (255) pixels instead of nearly black pixels.
          colors --- list of colors  to search for, e.g. ((0,0,0),(255,255,255)). The pixels that are considered as the collar are set to 0
          maxNonBlack --- number of non-black (or other searched colors specified with white / colors) pixels that can be encountered before the giving up search inwards. Defaults to 2.
          nearDist --- select how far from black, white or custom colors the pixel values can be and still considered near black, white or custom color.  Defaults to 15.
          setAlpha --- adds an alpha band to the output file.
          setMask --- adds a mask band to the output file.
          callback --- callback method
          callback_data --- user data for callback
    """
    import copy

    if _is_str_or_unicode(options):
        new_options = ParseCommandLine(options)
    else:
        new_options = copy.copy(options)
        if format is not None:
            new_options += ['-of', format]
        if creationOptions is not None:
            for opt in creationOptions:
                new_options += ['-co', opt ]
        if white:
            new_options += ['-white']
        if colors is not None:
            for color in colors:
                color_str = ''
                for cpt in color:
                    if color_str != '':
                        color_str += ','
                    color_str += str(cpt)
                new_options += ['-color',color_str]
        if maxNonBlack is not None:
            new_options += ['-nb', str(maxNonBlack) ]
        if nearDist is not None:
            new_options += ['-near', str(nearDist) ]
        if setAlpha:
            new_options += ['-setalpha']
        if setMask:
            new_options += ['-setmask']

    return (GDALNearblackOptions(new_options), callback, callback_data)

def Nearblack(destNameOrDestDS, srcDS, **kwargs):
    """ Convert nearly black/white borders to exact value.
        Arguments are :
          destNameOrDestDS --- Output dataset name or object
          srcDS --- a Dataset object or a filename
        Keyword arguments are :
          options --- return of gdal.NearblackOptions(), string or array of strings
          other keywords arguments of gdal.NearblackOptions()
        If options is provided as a gdal.NearblackOptions() object, other keywords are ignored. """

    if 'options' not in kwargs or type(kwargs['options']) == type([]) or _is_str_or_unicode(kwargs['options']):
        (opts, callback, callback_data) = NearblackOptions(**kwargs)
    else:
        (opts, callback, callback_data) = kwargs['options']
    if _is_str_or_unicode(srcDS):
        srcDS = OpenEx(srcDS)

    if _is_str_or_unicode(destNameOrDestDS):
        return wrapper_GDALNearblackDestName(destNameOrDestDS, srcDS, opts, callback, callback_data)
    else:
        return wrapper_GDALNearblackDestDS(destNameOrDestDS, srcDS, opts, callback, callback_data)


def GridOptions(options = [], format = None,
              outputType = GDT_Unknown,
              width = 0, height = 0,
              creationOptions = None,
              outputBounds = None,
              outputSRS = None,
              noData = None,
              algorithm = None,
              layers = None,
              SQLStatement = None,
              where = None,
              spatFilter = None,
              zfield = None,
              z_increase = None,
              z_multiply = None,
              callback = None, callback_data = None):
    """ Create a GridOptions() object that can be passed to gdal.Grid()
        Keyword arguments are :
          options --- can be be an array of strings, a string or let empty and filled from other keywords.
          format --- output format ("GTiff", etc...)
          outputType --- output type (gdal.GDT_Byte, etc...)
          width --- width of the output raster in pixel
          height --- height of the output raster in pixel
          creationOptions --- list of creation options
          outputBounds --- assigned output bounds: [ulx, uly, lrx, lry]
          outputSRS --- assigned output SRS
          noData --- nodata value
          algorithm --- e.g "invdist:power=2.0:smoothing=0.0:radius1=0.0:radius2=0.0:angle=0.0:max_points=0:min_points=0:nodata=0.0"
          layers --- list of layers to convert
          SQLStatement --- SQL statement to apply to the source dataset
          where --- WHERE clause to apply to source layer(s)
          spatFilter --- spatial filter as (minX, minY, maxX, maxY) bounding box
          zfield --- Identifies an attribute field on the features to be used to get a Z value from. This value overrides Z value read from feature geometry record.
          z_increase --- Addition to the attribute field on the features to be used to get a Z value from. The addition should be the same unit as Z value. The result value will be Z value + Z increase value. The default value is 0.
          z_multiply - Multiplication ratio for Z field. This can be used for shift from e.g. foot to meters or from  elevation to deep. The result value will be (Z value + Z increase value) * Z multiply value.  The default value is 1.
          callback --- callback method
          callback_data --- user data for callback
    """
    import copy

    if _is_str_or_unicode(options):
        new_options = ParseCommandLine(options)
    else:
        new_options = copy.copy(options)
        if format is not None:
            new_options += ['-of', format]
        if outputType != GDT_Unknown:
            new_options += ['-ot', GetDataTypeName(outputType) ]
        if width != 0 or height != 0:
            new_options += ['-outsize', str(width), str(height)]
        if creationOptions is not None:
            for opt in creationOptions:
                new_options += ['-co', opt ]
        if outputBounds is not None:
            new_options += ['-txe', _strHighPrec(outputBounds[0]), _strHighPrec(outputBounds[2]), '-tye', _strHighPrec(outputBounds[1]), _strHighPrec(outputBounds[3])]
        if outputSRS is not None:
            new_options += ['-a_srs', str(outputSRS) ]
        if algorithm is not None:
            new_options += ['-a', algorithm ]
        if layers is not None:
            if type(layers) == type(()) or type(layers) == type([]):
                for layer in layers:
                    new_options += ['-l', layer]
            else:
                new_options += ['-l', layers]
        if SQLStatement is not None:
            new_options += ['-sql', str(SQLStatement) ]
        if where is not None:
            new_options += ['-where', str(where) ]
        if zfield is not None:
            new_options += ['-zfield', zfield ]
        if z_increase is not None:
            new_options += ['-z_increase', str(z_increase) ]
        if z_multiply is not None:
            new_options += ['-z_multiply', str(z_multiply) ]
        if spatFilter is not None:
            new_options += ['-spat', str(spatFilter[0]), str(spatFilter[1]), str(spatFilter[2]), str(spatFilter[3]) ]

    return (GDALGridOptions(new_options), callback, callback_data)

def Grid(destName, srcDS, **kwargs):
    """ Create raster from the scattered data.
        Arguments are :
          destName --- Output dataset name
          srcDS --- a Dataset object or a filename
        Keyword arguments are :
          options --- return of gdal.GridOptions(), string or array of strings
          other keywords arguments of gdal.GridOptions()
        If options is provided as a gdal.GridOptions() object, other keywords are ignored. """

    if 'options' not in kwargs or type(kwargs['options']) == type([]) or _is_str_or_unicode(kwargs['options']):
        (opts, callback, callback_data) = GridOptions(**kwargs)
    else:
        (opts, callback, callback_data) = kwargs['options']
    if _is_str_or_unicode(srcDS):
        srcDS = OpenEx(srcDS, OF_VECTOR)

    return GridInternal(destName, srcDS, opts, callback, callback_data)

def RasterizeOptions(options = [], format = None,
         outputType = GDT_Unknown,
         creationOptions = None, noData = None, initValues = None,
         outputBounds = None, outputSRS = None,
         transformerOptions = None,
         width = None, height = None,
         xRes = None, yRes = None, targetAlignedPixels = False,
         bands = None, inverse = False, allTouched = False,
         burnValues = None, attribute = None, useZ = False, layers = None,
         SQLStatement = None, SQLDialect = None, where = None, optim = None,
         callback = None, callback_data = None):
    """ Create a RasterizeOptions() object that can be passed to gdal.Rasterize()
        Keyword arguments are :
          options --- can be be an array of strings, a string or let empty and filled from other keywords.
          format --- output format ("GTiff", etc...)
          outputType --- output type (gdal.GDT_Byte, etc...)
          creationOptions --- list of creation options
          outputBounds --- assigned output bounds: [minx, miny, maxx, maxy]
          outputSRS --- assigned output SRS
          transformerOptions --- list of transformer options
          width --- width of the output raster in pixel
          height --- height of the output raster in pixel
          xRes, yRes --- output resolution in target SRS
          targetAlignedPixels --- whether to force output bounds to be multiple of output resolution
          noData --- nodata value
          initValues --- Value or list of values to pre-initialize the output image bands with.  However, it is not marked as the nodata value in the output file.  If only one value is given, the same value is used in all the bands.
          bands --- list of output bands to burn values into
          inverse --- whether to invert rasterization, i.e. burn the fixed burn value, or the burn value associated  with the first feature into all parts of the image not inside the provided a polygon.
          allTouched -- whether to enable the ALL_TOUCHED rasterization option so that all pixels touched by lines or polygons will be updated, not just those on the line render path, or whose center point is within the polygon.
          burnValues -- list of fixed values to burn into each band for all objects. Excusive with attribute.
          attribute --- identifies an attribute field on the features to be used for a burn-in value. The value will be burned into all output bands. Excusive with burnValues.
          useZ --- whether to indicate that a burn value should be extracted from the "Z" values of the feature. These values are added to the burn value given by burnValues or attribute if provided. As of now, only points and lines are drawn in 3D.
          layers --- list of layers from the datasource that will be used for input features.
          SQLStatement --- SQL statement to apply to the source dataset
          SQLDialect --- SQL dialect ('OGRSQL', 'SQLITE', ...)
          where --- WHERE clause to apply to source layer(s)
          callback --- callback method
          callback_data --- user data for callback
    """
    import copy

    if _is_str_or_unicode(options):
        new_options = ParseCommandLine(options)
    else:
        new_options = copy.copy(options)
        if format is not None:
            new_options += ['-of', format]
        if outputType != GDT_Unknown:
            new_options += ['-ot', GetDataTypeName(outputType) ]
        if creationOptions is not None:
            for opt in creationOptions:
                new_options += ['-co', opt ]
        if bands is not None:
            for b in bands:
                new_options += ['-b', str(b) ]
        if noData is not None:
            new_options += ['-a_nodata', str(noData) ]
        if initValues is not None:
            if type(initValues) == type(()) or type(initValues) == type([]):
                for val in initValues:
                    new_options += ['-init', str(val) ]
            else:
                new_options += ['-init', str(initValues) ]
        if outputBounds is not None:
            new_options += ['-te', _strHighPrec(outputBounds[0]), _strHighPrec(outputBounds[1]), _strHighPrec(outputBounds[2]), _strHighPrec(outputBounds[3])]
        if outputSRS is not None:
            new_options += ['-a_srs', str(outputSRS) ]
        if transformerOptions is not None:
            for opt in transformerOptions:
                new_options += ['-to', opt ]
        if width is not None and height is not None:
            new_options += ['-ts', str(width), str(height)]
        if xRes is not None and yRes is not None:
            new_options += ['-tr', _strHighPrec(xRes), _strHighPrec(yRes)]
        if targetAlignedPixels:
            new_options += ['-tap']
        if inverse:
            new_options += ['-i']
        if allTouched:
            new_options += ['-at']
        if burnValues is not None:
            if attribute is not None:
                raise Exception('burnValues and attribute option are exclusive.')
            if type(burnValues) == type(()) or type(burnValues) == type([]):
                for val in burnValues:
                    new_options += ['-burn', str(val) ]
            else:
                new_options += ['-burn', str(burnValues) ]
        if attribute is not None:
            new_options += ['-a', attribute]
        if useZ:
            new_options += ['-3d']
        if layers is not None:
            if type(layers) == type(()) or type(layers) == type([]):
                for layer in layers:
                    new_options += ['-l', layer]
            else:
                new_options += ['-l', layers]
        if SQLStatement is not None:
            new_options += ['-sql', str(SQLStatement) ]
        if SQLDialect is not None:
            new_options += ['-dialect', str(SQLDialect) ]
        if where is not None:
            new_options += ['-where', str(where) ]
        if optim is not None:
            new_options += ['-optim', str(optim) ]

    return (GDALRasterizeOptions(new_options), callback, callback_data)

def Rasterize(destNameOrDestDS, srcDS, **kwargs):
    """ Burns vector geometries into a raster
        Arguments are :
          destNameOrDestDS --- Output dataset name or object
          srcDS --- a Dataset object or a filename
        Keyword arguments are :
          options --- return of gdal.RasterizeOptions(), string or array of strings
          other keywords arguments of gdal.RasterizeOptions()
        If options is provided as a gdal.RasterizeOptions() object, other keywords are ignored. """

    if 'options' not in kwargs or type(kwargs['options']) == type([]) or _is_str_or_unicode(kwargs['options']):
        (opts, callback, callback_data) = RasterizeOptions(**kwargs)
    else:
        (opts, callback, callback_data) = kwargs['options']
    if _is_str_or_unicode(srcDS):
        srcDS = OpenEx(srcDS, OF_VECTOR)

    if _is_str_or_unicode(destNameOrDestDS):
        return wrapper_GDALRasterizeDestName(destNameOrDestDS, srcDS, opts, callback, callback_data)
    else:
        return wrapper_GDALRasterizeDestDS(destNameOrDestDS, srcDS, opts, callback, callback_data)


def BuildVRTOptions(options = [],
                    resolution = None,
                    outputBounds = None,
                    xRes = None, yRes = None,
                    targetAlignedPixels = None,
                    separate = None,
                    bandList = None,
                    addAlpha = None,
                    resampleAlg = None,
                    outputSRS = None,
                    allowProjectionDifference = None,
                    srcNodata = None,
                    VRTNodata = None,
                    hideNodata = None,
                    callback = None, callback_data = None):
    """ Create a BuildVRTOptions() object that can be passed to gdal.BuildVRT()
        Keyword arguments are :
          options --- can be be an array of strings, a string or let empty and filled from other keywords..
          resolution --- 'highest', 'lowest', 'average', 'user'.
          outputBounds --- output bounds as (minX, minY, maxX, maxY) in target SRS.
          xRes, yRes --- output resolution in target SRS.
          targetAlignedPixels --- whether to force output bounds to be multiple of output resolution.
          separate --- whether each source file goes into a separate stacked band in the VRT band.
          bandList --- array of band numbers (index start at 1).
          addAlpha --- whether to add an alpha mask band to the VRT when the source raster have none.
          resampleAlg --- resampling mode.
          outputSRS --- assigned output SRS.
          allowProjectionDifference --- whether to accept input datasets have not the same projection. Note: they will *not* be reprojected.
          srcNodata --- source nodata value(s).
          VRTNodata --- nodata values at the VRT band level.
          hideNodata --- whether to make the VRT band not report the NoData value.
          callback --- callback method.
          callback_data --- user data for callback.
    """
    import copy

    if _is_str_or_unicode(options):
        new_options = ParseCommandLine(options)
    else:
        new_options = copy.copy(options)
        if resolution is not None:
            new_options += ['-resolution', str(resolution) ]
        if outputBounds is not None:
            new_options += ['-te', _strHighPrec(outputBounds[0]), _strHighPrec(outputBounds[1]), _strHighPrec(outputBounds[2]), _strHighPrec(outputBounds[3])]
        if xRes is not None and yRes is not None:
            new_options += ['-tr', _strHighPrec(xRes), _strHighPrec(yRes)]
        if targetAlignedPixels:
            new_options += ['-tap']
        if separate:
            new_options += ['-separate']
        if bandList != None:
            for b in bandList:
                new_options += ['-b', str(b) ]
        if addAlpha:
            new_options += ['-addalpha']
        if resampleAlg is not None:
            if resampleAlg == GRIORA_NearestNeighbour:
                new_options += ['-r', 'near']
            elif resampleAlg == GRIORA_Bilinear:
                new_options += ['-rb']
            elif resampleAlg == GRIORA_Cubic:
                new_options += ['-rc']
            elif resampleAlg == GRIORA_CubicSpline:
                new_options += ['-rcs']
            elif resampleAlg == GRIORA_Lanczos:
                new_options += ['-r', 'lanczos']
            elif resampleAlg == GRIORA_Average:
                new_options += ['-r', 'average']
            elif resampleAlg == GRIORA_Mode:
                new_options += ['-r', 'mode']
            elif resampleAlg == GRIORA_Gauss:
                new_options += ['-r', 'gauss']
            else:
                new_options += ['-r', str(resampleAlg) ]
        if outputSRS is not None:
            new_options += ['-a_srs', str(outputSRS) ]
        if allowProjectionDifference:
            new_options += ['-allow_projection_difference']
        if srcNodata is not None:
            new_options += ['-srcnodata', str(srcNodata) ]
        if VRTNodata is not None:
            new_options += ['-vrtnodata', str(VRTNodata) ]
        if hideNodata:
            new_options += ['-hidenodata']

    return (GDALBuildVRTOptions(new_options), callback, callback_data)

def BuildVRT(destName, srcDSOrSrcDSTab, **kwargs):
    """ Build a VRT from a list of datasets.
        Arguments are :
          destName --- Output dataset name
          srcDSOrSrcDSTab --- an array of Dataset objects or filenames, or a Dataset object or a filename
        Keyword arguments are :
          options --- return of gdal.BuildVRTOptions(), string or array of strings
          other keywords arguments of gdal.BuildVRTOptions()
        If options is provided as a gdal.BuildVRTOptions() object, other keywords are ignored. """

    if 'options' not in kwargs or type(kwargs['options']) == type([]) or _is_str_or_unicode(kwargs['options']):
        (opts, callback, callback_data) = BuildVRTOptions(**kwargs)
    else:
        (opts, callback, callback_data) = kwargs['options']

    srcDSTab = []
    srcDSNamesTab = []
    if _is_str_or_unicode(srcDSOrSrcDSTab):
        srcDSNamesTab = [ srcDSOrSrcDSTab ]
    elif type(srcDSOrSrcDSTab) == type([]):
        for elt in srcDSOrSrcDSTab:
            if _is_str_or_unicode(elt):
                srcDSNamesTab.append(elt)
            else:
                srcDSTab.append(elt)
        if len(srcDSTab) != 0 and len(srcDSNamesTab) != 0:
            raise Exception('Mix of names and dataset objects not supported')
    else:
        srcDSTab = [ srcDSOrSrcDSTab ]

    if len(srcDSTab) > 0:
        return BuildVRTInternalObjects(destName, srcDSTab, opts, callback, callback_data)
    else:
        return BuildVRTInternalNames(destName, srcDSNamesTab, opts, callback, callback_data)



def Debug(*args):
  """Debug(char msg_class, char message)"""
  return _gdal.Debug(*args)

def SetErrorHandler(*args):
  """SetErrorHandler(char pszCallbackName = None) -> CPLErr"""
  return _gdal.SetErrorHandler(*args)

def PushErrorHandler(*args):
  """PushErrorHandler(CPLErrorHandler pfnErrorHandler = 0) -> CPLErr"""
  return _gdal.PushErrorHandler(*args)

def PopErrorHandler(*args):
  """PopErrorHandler()"""
  return _gdal.PopErrorHandler(*args)

def Error(*args):
  """Error(CPLErr msg_class = CE_Failure, int err_code = 0, char msg = "error")"""
  return _gdal.Error(*args)

def GOA2GetAuthorizationURL(*args):
  """GOA2GetAuthorizationURL(char pszScope) -> retStringAndCPLFree"""
  return _gdal.GOA2GetAuthorizationURL(*args)

def GOA2GetRefreshToken(*args):
  """GOA2GetRefreshToken(char pszAuthToken, char pszScope) -> retStringAndCPLFree"""
  return _gdal.GOA2GetRefreshToken(*args)

def GOA2GetAccessToken(*args):
  """GOA2GetAccessToken(char pszRefreshToken, char pszScope) -> retStringAndCPLFree"""
  return _gdal.GOA2GetAccessToken(*args)

def ErrorReset(*args):
  """ErrorReset()"""
  return _gdal.ErrorReset(*args)

def EscapeString(*args, **kwargs):
  """EscapeString(int len, int scheme = CPLES_SQL) -> retStringAndCPLFree"""
  return _gdal.EscapeString(*args, **kwargs)

def GetLastErrorNo(*args):
  """GetLastErrorNo() -> int"""
  return _gdal.GetLastErrorNo(*args)

def GetLastErrorType(*args):
  """GetLastErrorType() -> int"""
  return _gdal.GetLastErrorType(*args)

def GetLastErrorMsg(*args):
  """GetLastErrorMsg() -> char"""
  return _gdal.GetLastErrorMsg(*args)

def GetErrorCounter(*args):
  """GetErrorCounter() -> unsigned int"""
  return _gdal.GetErrorCounter(*args)

def VSIGetLastErrorNo(*args):
  """VSIGetLastErrorNo() -> int"""
  return _gdal.VSIGetLastErrorNo(*args)

def VSIGetLastErrorMsg(*args):
  """VSIGetLastErrorMsg() -> char"""
  return _gdal.VSIGetLastErrorMsg(*args)

def PushFinderLocation(*args):
  """PushFinderLocation(char utf8_path)"""
  return _gdal.PushFinderLocation(*args)

def PopFinderLocation(*args):
  """PopFinderLocation()"""
  return _gdal.PopFinderLocation(*args)

def FinderClean(*args):
  """FinderClean()"""
  return _gdal.FinderClean(*args)

def FindFile(*args):
  """FindFile(char pszClass, char utf8_path) -> char"""
  return _gdal.FindFile(*args)

def ReadDir(*args):
  """ReadDir(char utf8_path, int nMaxFiles = 0) -> char"""
  return _gdal.ReadDir(*args)

def ReadDirRecursive(*args):
  """ReadDirRecursive(char utf8_path) -> char"""
  return _gdal.ReadDirRecursive(*args)

def SetConfigOption(*args):
  """SetConfigOption(char pszKey, char pszValue)"""
  return _gdal.SetConfigOption(*args)

def GetConfigOption(*args):
  """GetConfigOption(char pszKey, char pszDefault = None) -> char"""
  return _gdal.GetConfigOption(*args)

def CPLBinaryToHex(*args):
  """CPLBinaryToHex(int nBytes) -> retStringAndCPLFree"""
  return _gdal.CPLBinaryToHex(*args)

def CPLHexToBinary(*args):
  """CPLHexToBinary(char pszHex, int pnBytes) -> GByte"""
  return _gdal.CPLHexToBinary(*args)

def FileFromMemBuffer(*args):
  """FileFromMemBuffer(char utf8_path, GIntBig nBytes)"""
  return _gdal.FileFromMemBuffer(*args)

def Unlink(*args):
  """Unlink(char utf8_path) -> VSI_RETVAL"""
  return _gdal.Unlink(*args)

def HasThreadSupport(*args):
  """HasThreadSupport() -> int"""
  return _gdal.HasThreadSupport(*args)

def Mkdir(*args):
  """Mkdir(char utf8_path, int mode) -> VSI_RETVAL"""
  return _gdal.Mkdir(*args)

def Rmdir(*args):
  """Rmdir(char utf8_path) -> VSI_RETVAL"""
  return _gdal.Rmdir(*args)

def MkdirRecursive(*args):
  """MkdirRecursive(char utf8_path, int mode) -> VSI_RETVAL"""
  return _gdal.MkdirRecursive(*args)

def RmdirRecursive(*args):
  """RmdirRecursive(char utf8_path) -> VSI_RETVAL"""
  return _gdal.RmdirRecursive(*args)

def Rename(*args):
  """Rename(char pszOld, char pszNew) -> VSI_RETVAL"""
  return _gdal.Rename(*args)

def GetActualURL(*args):
  """GetActualURL(char utf8_path) -> char"""
  return _gdal.GetActualURL(*args)

def GetSignedURL(*args):
  """GetSignedURL(char utf8_path, char options = None) -> retStringAndCPLFree"""
  return _gdal.GetSignedURL(*args)

def GetFileSystemsPrefixes(*args):
  """GetFileSystemsPrefixes() -> char"""
  return _gdal.GetFileSystemsPrefixes(*args)

def GetFileSystemOptions(*args):
  """GetFileSystemOptions(char utf8_path) -> char"""
  return _gdal.GetFileSystemOptions(*args)
VSI_STAT_EXISTS_FLAG = _gdal.VSI_STAT_EXISTS_FLAG
VSI_STAT_NATURE_FLAG = _gdal.VSI_STAT_NATURE_FLAG
VSI_STAT_SIZE_FLAG = _gdal.VSI_STAT_SIZE_FLAG
class StatBuf(object):
    """Proxy of C++ StatBuf class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    mode = _swig_property(_gdal.StatBuf_mode_get)
    size = _swig_property(_gdal.StatBuf_size_get)
    mtime = _swig_property(_gdal.StatBuf_mtime_get)
    def __init__(self, *args): 
        """__init__(self, StatBuf psStatBuf) -> StatBuf"""
        this = _gdal.new_StatBuf(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _gdal.delete_StatBuf
    __del__ = lambda self : None;
    def IsDirectory(self, *args):
        """IsDirectory(self) -> int"""
        return _gdal.StatBuf_IsDirectory(self, *args)

StatBuf_swigregister = _gdal.StatBuf_swigregister
StatBuf_swigregister(StatBuf)


def VSIStatL(*args):
  """VSIStatL(char utf8_path, int nFlags = 0) -> int"""
  return _gdal.VSIStatL(*args)

def VSIFOpenL(*args):
  """VSIFOpenL(char utf8_path, char pszMode) -> VSILFILE"""
  return _gdal.VSIFOpenL(*args)

def VSIFOpenExL(*args):
  """VSIFOpenExL(char utf8_path, char pszMode, int bSetError) -> VSILFILE"""
  return _gdal.VSIFOpenExL(*args)

def VSIFEofL(*args):
  """VSIFEofL(VSILFILE fp) -> int"""
  return _gdal.VSIFEofL(*args)

def VSIFCloseL(*args):
  """VSIFCloseL(VSILFILE fp) -> VSI_RETVAL"""
  return _gdal.VSIFCloseL(*args)

def VSIFSeekL(*args):
  """VSIFSeekL(VSILFILE fp, GIntBig offset, int whence) -> int"""
  return _gdal.VSIFSeekL(*args)

def VSIFTellL(*args):
  """VSIFTellL(VSILFILE fp) -> GIntBig"""
  return _gdal.VSIFTellL(*args)

def VSIFTruncateL(*args):
  """VSIFTruncateL(VSILFILE fp, GIntBig length) -> int"""
  return _gdal.VSIFTruncateL(*args)

def VSISupportsSparseFiles(*args):
  """VSISupportsSparseFiles(char utf8_path) -> int"""
  return _gdal.VSISupportsSparseFiles(*args)
VSI_RANGE_STATUS_UNKNOWN = _gdal.VSI_RANGE_STATUS_UNKNOWN
VSI_RANGE_STATUS_DATA = _gdal.VSI_RANGE_STATUS_DATA
VSI_RANGE_STATUS_HOLE = _gdal.VSI_RANGE_STATUS_HOLE

def VSIFGetRangeStatusL(*args):
  """VSIFGetRangeStatusL(VSILFILE fp, GIntBig offset, GIntBig length) -> int"""
  return _gdal.VSIFGetRangeStatusL(*args)

def VSIFWriteL(*args):
  """VSIFWriteL(int nLen, int size, int memb, VSILFILE fp) -> int"""
  return _gdal.VSIFWriteL(*args)

def VSICurlClearCache(*args):
  """VSICurlClearCache()"""
  return _gdal.VSICurlClearCache(*args)

def ParseCommandLine(*args):
  """ParseCommandLine(char utf8_path) -> char"""
  return _gdal.ParseCommandLine(*args)
class MajorObject(object):
    """Proxy of C++ GDALMajorObjectShadow class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    def GetDescription(self, *args):
        """GetDescription(self) -> char"""
        return _gdal.MajorObject_GetDescription(self, *args)

    def SetDescription(self, *args):
        """SetDescription(self, char pszNewDesc)"""
        return _gdal.MajorObject_SetDescription(self, *args)

    def GetMetadataDomainList(self, *args):
        """GetMetadataDomainList(self) -> char"""
        return _gdal.MajorObject_GetMetadataDomainList(self, *args)

    def GetMetadata_Dict(self, *args):
        """GetMetadata_Dict(self, char pszDomain = "") -> char"""
        return _gdal.MajorObject_GetMetadata_Dict(self, *args)

    def GetMetadata_List(self, *args):
        """GetMetadata_List(self, char pszDomain = "") -> char"""
        return _gdal.MajorObject_GetMetadata_List(self, *args)

    def SetMetadata(self, *args):
        """
        SetMetadata(self, char papszMetadata, char pszDomain = "") -> CPLErr
        SetMetadata(self, char pszMetadataString, char pszDomain = "") -> CPLErr
        """
        return _gdal.MajorObject_SetMetadata(self, *args)

    def GetMetadataItem(self, *args):
        """GetMetadataItem(self, char pszName, char pszDomain = "") -> char"""
        return _gdal.MajorObject_GetMetadataItem(self, *args)

    def SetMetadataItem(self, *args):
        """SetMetadataItem(self, char pszName, char pszValue, char pszDomain = "") -> CPLErr"""
        return _gdal.MajorObject_SetMetadataItem(self, *args)

    def GetMetadata( self, domain = '' ):
      if domain[:4] == 'xml:':
        return self.GetMetadata_List( domain )
      return self.GetMetadata_Dict( domain )

MajorObject_swigregister = _gdal.MajorObject_swigregister
MajorObject_swigregister(MajorObject)

class Driver(MajorObject):
    """Proxy of C++ GDALDriverShadow class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    ShortName = _swig_property(_gdal.Driver_ShortName_get)
    LongName = _swig_property(_gdal.Driver_LongName_get)
    HelpTopic = _swig_property(_gdal.Driver_HelpTopic_get)
    def Create(self, *args, **kwargs):
        """
        Create(self, char utf8_path, int xsize, int ysize, int bands = 1, 
            GDALDataType eType = GDT_Byte, char options = None) -> Dataset
        """
        return _gdal.Driver_Create(self, *args, **kwargs)

    def CreateCopy(self, *args, **kwargs):
        """
        CreateCopy(self, char utf8_path, Dataset src, int strict = 1, char options = None, 
            GDALProgressFunc callback = 0, 
            void callback_data = None) -> Dataset
        """
        return _gdal.Driver_CreateCopy(self, *args, **kwargs)

    def Delete(self, *args):
        """Delete(self, char utf8_path) -> CPLErr"""
        return _gdal.Driver_Delete(self, *args)

    def Rename(self, *args):
        """Rename(self, char newName, char oldName) -> CPLErr"""
        return _gdal.Driver_Rename(self, *args)

    def CopyFiles(self, *args):
        """CopyFiles(self, char newName, char oldName) -> CPLErr"""
        return _gdal.Driver_CopyFiles(self, *args)

    def Register(self, *args):
        """Register(self) -> int"""
        return _gdal.Driver_Register(self, *args)

    def Deregister(self, *args):
        """Deregister(self)"""
        return _gdal.Driver_Deregister(self, *args)

Driver_swigregister = _gdal.Driver_swigregister
Driver_swigregister(Driver)

import ogr
import osr
class ColorEntry(object):
    """Proxy of C++ GDALColorEntry class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    c1 = _swig_property(_gdal.ColorEntry_c1_get, _gdal.ColorEntry_c1_set)
    c2 = _swig_property(_gdal.ColorEntry_c2_get, _gdal.ColorEntry_c2_set)
    c3 = _swig_property(_gdal.ColorEntry_c3_get, _gdal.ColorEntry_c3_set)
    c4 = _swig_property(_gdal.ColorEntry_c4_get, _gdal.ColorEntry_c4_set)
ColorEntry_swigregister = _gdal.ColorEntry_swigregister
ColorEntry_swigregister(ColorEntry)

class GCP(object):
    """Proxy of C++ GDAL_GCP class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    GCPX = _swig_property(_gdal.GCP_GCPX_get, _gdal.GCP_GCPX_set)
    GCPY = _swig_property(_gdal.GCP_GCPY_get, _gdal.GCP_GCPY_set)
    GCPZ = _swig_property(_gdal.GCP_GCPZ_get, _gdal.GCP_GCPZ_set)
    GCPPixel = _swig_property(_gdal.GCP_GCPPixel_get, _gdal.GCP_GCPPixel_set)
    GCPLine = _swig_property(_gdal.GCP_GCPLine_get, _gdal.GCP_GCPLine_set)
    Info = _swig_property(_gdal.GCP_Info_get, _gdal.GCP_Info_set)
    Id = _swig_property(_gdal.GCP_Id_get, _gdal.GCP_Id_set)
    def __init__(self, *args): 
        """
        __init__(self, double x = 0.0, double y = 0.0, double z = 0.0, double pixel = 0.0, 
            double line = 0.0, char info = "", 
            char id = "") -> GCP
        """
        this = _gdal.new_GCP(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _gdal.delete_GCP
    __del__ = lambda self : None;
    def __str__(self):
      str = '%s (%.2fP,%.2fL) -> (%.7fE,%.7fN,%.2f) %s '\
            % (self.Id, self.GCPPixel, self.GCPLine,
               self.GCPX, self.GCPY, self.GCPZ, self.Info )
      return str

    def serialize(self,with_Z=0):
      base = [CXT_Element,'GCP']
      base.append([CXT_Attribute,'Id',[CXT_Text,self.Id]])
      pixval = '%0.15E' % self.GCPPixel
      lineval = '%0.15E' % self.GCPLine
      xval = '%0.15E' % self.GCPX
      yval = '%0.15E' % self.GCPY
      zval = '%0.15E' % self.GCPZ
      base.append([CXT_Attribute,'Pixel',[CXT_Text,pixval]])
      base.append([CXT_Attribute,'Line',[CXT_Text,lineval]])
      base.append([CXT_Attribute,'X',[CXT_Text,xval]])
      base.append([CXT_Attribute,'Y',[CXT_Text,yval]])
      if with_Z:
          base.append([CXT_Attribute,'Z',[CXT_Text,zval]])
      return base

GCP_swigregister = _gdal.GCP_swigregister
GCP_swigregister(GCP)


def GDAL_GCP_GCPX_get(*args):
  """GDAL_GCP_GCPX_get(GCP gcp) -> double"""
  return _gdal.GDAL_GCP_GCPX_get(*args)

def GDAL_GCP_GCPX_set(*args):
  """GDAL_GCP_GCPX_set(GCP gcp, double dfGCPX)"""
  return _gdal.GDAL_GCP_GCPX_set(*args)

def GDAL_GCP_GCPY_get(*args):
  """GDAL_GCP_GCPY_get(GCP gcp) -> double"""
  return _gdal.GDAL_GCP_GCPY_get(*args)

def GDAL_GCP_GCPY_set(*args):
  """GDAL_GCP_GCPY_set(GCP gcp, double dfGCPY)"""
  return _gdal.GDAL_GCP_GCPY_set(*args)

def GDAL_GCP_GCPZ_get(*args):
  """GDAL_GCP_GCPZ_get(GCP gcp) -> double"""
  return _gdal.GDAL_GCP_GCPZ_get(*args)

def GDAL_GCP_GCPZ_set(*args):
  """GDAL_GCP_GCPZ_set(GCP gcp, double dfGCPZ)"""
  return _gdal.GDAL_GCP_GCPZ_set(*args)

def GDAL_GCP_GCPPixel_get(*args):
  """GDAL_GCP_GCPPixel_get(GCP gcp) -> double"""
  return _gdal.GDAL_GCP_GCPPixel_get(*args)

def GDAL_GCP_GCPPixel_set(*args):
  """GDAL_GCP_GCPPixel_set(GCP gcp, double dfGCPPixel)"""
  return _gdal.GDAL_GCP_GCPPixel_set(*args)

def GDAL_GCP_GCPLine_get(*args):
  """GDAL_GCP_GCPLine_get(GCP gcp) -> double"""
  return _gdal.GDAL_GCP_GCPLine_get(*args)

def GDAL_GCP_GCPLine_set(*args):
  """GDAL_GCP_GCPLine_set(GCP gcp, double dfGCPLine)"""
  return _gdal.GDAL_GCP_GCPLine_set(*args)

def GDAL_GCP_Info_get(*args):
  """GDAL_GCP_Info_get(GCP gcp) -> char"""
  return _gdal.GDAL_GCP_Info_get(*args)

def GDAL_GCP_Info_set(*args):
  """GDAL_GCP_Info_set(GCP gcp, char pszInfo)"""
  return _gdal.GDAL_GCP_Info_set(*args)

def GDAL_GCP_Id_get(*args):
  """GDAL_GCP_Id_get(GCP gcp) -> char"""
  return _gdal.GDAL_GCP_Id_get(*args)

def GDAL_GCP_Id_set(*args):
  """GDAL_GCP_Id_set(GCP gcp, char pszId)"""
  return _gdal.GDAL_GCP_Id_set(*args)

def GCPsToGeoTransform(*args):
  """GCPsToGeoTransform(int nGCPs, int bApproxOK = 1) -> RETURN_NONE"""
  return _gdal.GCPsToGeoTransform(*args)
class VirtualMem(object):
    """Proxy of C++ CPLVirtualMemShadow class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdal.delete_VirtualMem
    __del__ = lambda self : None;
    def GetAddr(self, *args):
        """GetAddr(self)"""
        return _gdal.VirtualMem_GetAddr(self, *args)

    def Pin(self, *args):
        """Pin(self, size_t start_offset = 0, size_t nsize = 0, int bWriteOp = 0)"""
        return _gdal.VirtualMem_Pin(self, *args)

VirtualMem_swigregister = _gdal.VirtualMem_swigregister
VirtualMem_swigregister(VirtualMem)

class AsyncReader(object):
    """Proxy of C++ GDALAsyncReaderShadow class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdal.delete_AsyncReader
    __del__ = lambda self : None;
    def GetNextUpdatedRegion(self, *args):
        """GetNextUpdatedRegion(self, double timeout) -> GDALAsyncStatusType"""
        return _gdal.AsyncReader_GetNextUpdatedRegion(self, *args)

    def GetBuffer(self, *args):
        """GetBuffer(self)"""
        return _gdal.AsyncReader_GetBuffer(self, *args)

    def LockBuffer(self, *args):
        """LockBuffer(self, double timeout) -> int"""
        return _gdal.AsyncReader_LockBuffer(self, *args)

    def UnlockBuffer(self, *args):
        """UnlockBuffer(self)"""
        return _gdal.AsyncReader_UnlockBuffer(self, *args)

AsyncReader_swigregister = _gdal.AsyncReader_swigregister
AsyncReader_swigregister(AsyncReader)

class Dataset(MajorObject):
    """Proxy of C++ GDALDatasetShadow class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    RasterXSize = _swig_property(_gdal.Dataset_RasterXSize_get)
    RasterYSize = _swig_property(_gdal.Dataset_RasterYSize_get)
    RasterCount = _swig_property(_gdal.Dataset_RasterCount_get)
    __swig_destroy__ = _gdal.delete_Dataset
    __del__ = lambda self : None;
    def GetDriver(self, *args):
        """GetDriver(self) -> Driver"""
        return _gdal.Dataset_GetDriver(self, *args)

    def GetRasterBand(self, *args):
        """GetRasterBand(self, int nBand) -> Band"""
        return _gdal.Dataset_GetRasterBand(self, *args)

    def GetProjection(self, *args):
        """GetProjection(self) -> char"""
        return _gdal.Dataset_GetProjection(self, *args)

    def GetProjectionRef(self, *args):
        """GetProjectionRef(self) -> char"""
        return _gdal.Dataset_GetProjectionRef(self, *args)

    def SetProjection(self, *args):
        """SetProjection(self, char prj) -> CPLErr"""
        return _gdal.Dataset_SetProjection(self, *args)

    def GetGeoTransform(self, *args, **kwargs):
        """GetGeoTransform(self, int can_return_null = None)"""
        return _gdal.Dataset_GetGeoTransform(self, *args, **kwargs)

    def SetGeoTransform(self, *args):
        """SetGeoTransform(self, double argin) -> CPLErr"""
        return _gdal.Dataset_SetGeoTransform(self, *args)

    def BuildOverviews(self, *args, **kwargs):
        """
        BuildOverviews(self, char resampling = "NEAREST", int overviewlist = 0, 
            GDALProgressFunc callback = 0, void callback_data = None) -> int
        """
        return _gdal.Dataset_BuildOverviews(self, *args, **kwargs)

    def GetGCPCount(self, *args):
        """GetGCPCount(self) -> int"""
        return _gdal.Dataset_GetGCPCount(self, *args)

    def GetGCPProjection(self, *args):
        """GetGCPProjection(self) -> char"""
        return _gdal.Dataset_GetGCPProjection(self, *args)

    def GetGCPs(self, *args):
        """GetGCPs(self)"""
        return _gdal.Dataset_GetGCPs(self, *args)

    def SetGCPs(self, *args):
        """SetGCPs(self, int nGCPs, char pszGCPProjection) -> CPLErr"""
        return _gdal.Dataset_SetGCPs(self, *args)

    def FlushCache(self, *args):
        """FlushCache(self)"""
        return _gdal.Dataset_FlushCache(self, *args)

    def AddBand(self, *args, **kwargs):
        """AddBand(self, GDALDataType datatype = GDT_Byte, char options = None) -> CPLErr"""
        return _gdal.Dataset_AddBand(self, *args, **kwargs)

    def CreateMaskBand(self, *args):
        """CreateMaskBand(self, int nFlags) -> CPLErr"""
        return _gdal.Dataset_CreateMaskBand(self, *args)

    def GetFileList(self, *args):
        """GetFileList(self) -> char"""
        return _gdal.Dataset_GetFileList(self, *args)

    def WriteRaster(self, *args, **kwargs):
        """
        WriteRaster(self, int xoff, int yoff, int xsize, int ysize, GIntBig buf_len, 
            int buf_xsize = None, int buf_ysize = None, 
            GDALDataType buf_type = None, int band_list = 0, 
            GIntBig buf_pixel_space = None, GIntBig buf_line_space = None, 
            GIntBig buf_band_space = None) -> CPLErr
        """
        return _gdal.Dataset_WriteRaster(self, *args, **kwargs)

    def AdviseRead(self, *args):
        """
        AdviseRead(self, int xoff, int yoff, int xsize, int ysize, int buf_xsize = None, 
            int buf_ysize = None, GDALDataType buf_type = None, 
            int band_list = 0, char options = None) -> CPLErr
        """
        return _gdal.Dataset_AdviseRead(self, *args)

    def BeginAsyncReader(self, *args, **kwargs):
        """
        BeginAsyncReader(self, int xOff, int yOff, int xSize, int ySize, int buf_len, 
            int buf_xsize, int buf_ysize, GDALDataType bufType = (GDALDataType) 0, 
            int band_list = 0, 
            int nPixelSpace = 0, int nLineSpace = 0, 
            int nBandSpace = 0, char options = None) -> AsyncReader
        """
        return _gdal.Dataset_BeginAsyncReader(self, *args, **kwargs)

    def EndAsyncReader(self, *args):
        """EndAsyncReader(self, AsyncReader ario)"""
        return _gdal.Dataset_EndAsyncReader(self, *args)

    def GetVirtualMem(self, *args, **kwargs):
        """
        GetVirtualMem(self, GDALRWFlag eRWFlag, int nXOff, int nYOff, int nXSize, 
            int nYSize, int nBufXSize, int nBufYSize, 
            GDALDataType eBufType, int band_list, int bIsBandSequential, 
            size_t nCacheSize, size_t nPageSizeHint, 
            char options = None) -> VirtualMem
        """
        return _gdal.Dataset_GetVirtualMem(self, *args, **kwargs)

    def GetTiledVirtualMem(self, *args, **kwargs):
        """
        GetTiledVirtualMem(self, GDALRWFlag eRWFlag, int nXOff, int nYOff, int nXSize, 
            int nYSize, int nTileXSize, int nTileYSize, 
            GDALDataType eBufType, int band_list, GDALTileOrganization eTileOrganization, 
            size_t nCacheSize, 
            char options = None) -> VirtualMem
        """
        return _gdal.Dataset_GetTiledVirtualMem(self, *args, **kwargs)

    def CreateLayer(self, *args, **kwargs):
        """
        CreateLayer(self, char name, SpatialReference srs = None, OGRwkbGeometryType geom_type = wkbUnknown, 
            char options = None) -> Layer
        """
        return _gdal.Dataset_CreateLayer(self, *args, **kwargs)

    def CopyLayer(self, *args, **kwargs):
        """CopyLayer(self, Layer src_layer, char new_name, char options = None) -> Layer"""
        return _gdal.Dataset_CopyLayer(self, *args, **kwargs)

    def DeleteLayer(self, *args):
        """DeleteLayer(self, int index) -> OGRErr"""
        return _gdal.Dataset_DeleteLayer(self, *args)

    def GetLayerCount(self, *args):
        """GetLayerCount(self) -> int"""
        return _gdal.Dataset_GetLayerCount(self, *args)

    def GetLayerByIndex(self, *args):
        """GetLayerByIndex(self, int index = 0) -> Layer"""
        return _gdal.Dataset_GetLayerByIndex(self, *args)

    def GetLayerByName(self, *args):
        """GetLayerByName(self, char layer_name) -> Layer"""
        return _gdal.Dataset_GetLayerByName(self, *args)

    def ResetReading(self, *args):
        """ResetReading(self)"""
        return _gdal.Dataset_ResetReading(self, *args)

    def GetNextFeature(self, *args, **kwargs):
        """
        GetNextFeature(self, bool include_layer = True, bool include_pct = False, 
            GDALProgressFunc callback = 0, void callback_data = None) -> Feature
        """
        return _gdal.Dataset_GetNextFeature(self, *args, **kwargs)

    def TestCapability(self, *args):
        """TestCapability(self, char cap) -> bool"""
        return _gdal.Dataset_TestCapability(self, *args)

    def ExecuteSQL(self, *args, **kwargs):
        """ExecuteSQL(self, char statement, Geometry spatialFilter = None, char dialect = "") -> Layer"""
        return _gdal.Dataset_ExecuteSQL(self, *args, **kwargs)

    def ReleaseResultSet(self, *args):
        """ReleaseResultSet(self, Layer layer)"""
        return _gdal.Dataset_ReleaseResultSet(self, *args)

    def GetStyleTable(self, *args):
        """GetStyleTable(self) -> StyleTable"""
        return _gdal.Dataset_GetStyleTable(self, *args)

    def SetStyleTable(self, *args):
        """SetStyleTable(self, StyleTable table)"""
        return _gdal.Dataset_SetStyleTable(self, *args)

    def StartTransaction(self, *args, **kwargs):
        """StartTransaction(self, int force = True) -> OGRErr"""
        return _gdal.Dataset_StartTransaction(self, *args, **kwargs)

    def CommitTransaction(self, *args):
        """CommitTransaction(self) -> OGRErr"""
        return _gdal.Dataset_CommitTransaction(self, *args)

    def RollbackTransaction(self, *args):
        """RollbackTransaction(self) -> OGRErr"""
        return _gdal.Dataset_RollbackTransaction(self, *args)

    def ReadRaster1(self, *args, **kwargs):
        """
        ReadRaster1(self, int xoff, int yoff, int xsize, int ysize, int buf_xsize = None, 
            int buf_ysize = None, GDALDataType buf_type = None, 
            int band_list = 0, GIntBig buf_pixel_space = None, 
            GIntBig buf_line_space = None, 
            GIntBig buf_band_space = None, GDALRIOResampleAlg resample_alg = GRIORA_NearestNeighbour, 
            GDALProgressFunc callback = 0, 
            void callback_data = None) -> CPLErr
        """
        return _gdal.Dataset_ReadRaster1(self, *args, **kwargs)

    def ReadAsArray(self, xoff=0, yoff=0, xsize=None, ysize=None, buf_obj=None,
                    buf_xsize = None, buf_ysize = None, buf_type = None,
                    resample_alg = GRIORA_NearestNeighbour,
                    callback = None,
                    callback_data = None):
        """ Reading a chunk of a GDAL band into a numpy array. The optional (buf_xsize,buf_ysize,buf_type)
        parameters should generally not be specified if buf_obj is specified. The array is returned"""

        import gdalnumeric
        return gdalnumeric.DatasetReadAsArray( self, xoff, yoff, xsize, ysize, buf_obj,
                                               buf_xsize, buf_ysize, buf_type,
                                               resample_alg = resample_alg,
                                               callback = callback,
                                               callback_data = callback_data )

    def WriteRaster(self, xoff, yoff, xsize, ysize,
                    buf_string,
                    buf_xsize = None, buf_ysize = None, buf_type = None,
                    band_list = None,
                    buf_pixel_space = None, buf_line_space = None, buf_band_space = None ):

        if buf_xsize is None:
            buf_xsize = xsize;
        if buf_ysize is None:
            buf_ysize = ysize;
        if band_list is None:
            band_list = range(1,self.RasterCount+1)
        if buf_type is None:
            buf_type = self.GetRasterBand(1).DataType

        return _gdal.Dataset_WriteRaster(self,
                 xoff, yoff, xsize, ysize,
                buf_string, buf_xsize, buf_ysize, buf_type, band_list,
                buf_pixel_space, buf_line_space, buf_band_space )

    def ReadRaster(self, xoff = 0, yoff = 0, xsize = None, ysize = None,
                   buf_xsize = None, buf_ysize = None, buf_type = None,
                   band_list = None,
                   buf_pixel_space = None, buf_line_space = None, buf_band_space = None,
                   resample_alg = GRIORA_NearestNeighbour,
                   callback = None,
                   callback_data = None):

        if xsize is None:
            xsize = self.RasterXSize
        if ysize is None:
            ysize = self.RasterYSize
        if band_list is None:
            band_list = range(1,self.RasterCount+1)
        if buf_xsize is None:
            buf_xsize = xsize;
        if buf_ysize is None:
            buf_ysize = ysize;

        if buf_type is None:
            buf_type = self.GetRasterBand(1).DataType;

        return _gdal.Dataset_ReadRaster1(self, xoff, yoff, xsize, ysize,
                                            buf_xsize, buf_ysize, buf_type,
                                            band_list, buf_pixel_space, buf_line_space, buf_band_space,
                                          resample_alg, callback, callback_data )

    def GetVirtualMemArray(self, eAccess = gdalconst.GF_Read, xoff=0, yoff=0,
                           xsize=None, ysize=None, bufxsize=None, bufysize=None,
                           datatype = None, band_list = None, band_sequential = True,
                           cache_size = 10 * 1024 * 1024, page_size_hint = 0,
                           options = None):
        """Return a NumPy array for the dataset, seen as a virtual memory mapping.
           If there are several bands and band_sequential = True, an element is
           accessed with array[band][y][x].
           If there are several bands and band_sequential = False, an element is
           accessed with array[y][x][band].
           If there is only one band, an element is accessed with array[y][x].
           Any reference to the array must be dropped before the last reference to the
           related dataset is also dropped.
        """
        import gdalnumeric
        if xsize is None:
            xsize = self.RasterXSize
        if ysize is None:
            ysize = self.RasterYSize
        if bufxsize is None:
            bufxsize = self.RasterXSize
        if bufysize is None:
            bufysize = self.RasterYSize
        if datatype is None:
            datatype = self.GetRasterBand(1).DataType
        if band_list is None:
            band_list = range(1,self.RasterCount+1)
        if options is None:
            virtualmem = self.GetVirtualMem(eAccess,xoff,yoff,xsize,ysize,bufxsize,bufysize,datatype,band_list,band_sequential,cache_size,page_size_hint)
        else:
            virtualmem = self.GetVirtualMem(eAccess,xoff,yoff,xsize,ysize,bufxsize,bufysize,datatype,band_list,band_sequential,cache_size,page_size_hint, options)
        return gdalnumeric.VirtualMemGetArray( virtualmem )

    def GetTiledVirtualMemArray(self, eAccess = gdalconst.GF_Read, xoff=0, yoff=0,
                           xsize=None, ysize=None, tilexsize=256, tileysize=256,
                           datatype = None, band_list = None, tile_organization = gdalconst.GTO_BSQ,
                           cache_size = 10 * 1024 * 1024, options = None):
        """Return a NumPy array for the dataset, seen as a virtual memory mapping with
           a tile organization.
           If there are several bands and tile_organization = gdal.GTO_TIP, an element is
           accessed with array[tiley][tilex][y][x][band].
           If there are several bands and tile_organization = gdal.GTO_BIT, an element is
           accessed with array[tiley][tilex][band][y][x].
           If there are several bands and tile_organization = gdal.GTO_BSQ, an element is
           accessed with array[band][tiley][tilex][y][x].
           If there is only one band, an element is accessed with array[tiley][tilex][y][x].
           Any reference to the array must be dropped before the last reference to the
           related dataset is also dropped.
        """
        import gdalnumeric
        if xsize is None:
            xsize = self.RasterXSize
        if ysize is None:
            ysize = self.RasterYSize
        if datatype is None:
            datatype = self.GetRasterBand(1).DataType
        if band_list is None:
            band_list = range(1,self.RasterCount+1)
        if options is None:
            virtualmem = self.GetTiledVirtualMem(eAccess,xoff,yoff,xsize,ysize,tilexsize,tileysize,datatype,band_list,tile_organization,cache_size)
        else:
            virtualmem = self.GetTiledVirtualMem(eAccess,xoff,yoff,xsize,ysize,tilexsize,tileysize,datatype,band_list,tile_organization,cache_size, options)
        return gdalnumeric.VirtualMemGetArray( virtualmem )

    def GetSubDatasets(self):
        sd_list = []

        sd = self.GetMetadata('SUBDATASETS')
        if sd is None:
            return sd_list

        i = 1
        while 'SUBDATASET_'+str(i)+'_NAME' in sd:
            sd_list.append( ( sd['SUBDATASET_'+str(i)+'_NAME'],
                              sd['SUBDATASET_'+str(i)+'_DESC'] ) )
            i = i + 1
        return sd_list

    def BeginAsyncReader(self, xoff, yoff, xsize, ysize, buf_obj = None, buf_xsize = None, buf_ysize = None, buf_type = None, band_list = None, options=[]):
        if band_list is None:
            band_list = range(1, self.RasterCount + 1)
        if buf_xsize is None:
            buf_xsize = 0;
        if buf_ysize is None:
            buf_ysize = 0;
        if buf_type is None:
            buf_type = GDT_Byte

        if buf_xsize <= 0:
            buf_xsize = xsize
        if buf_ysize <= 0:
            buf_ysize = ysize

        if buf_obj is None:
            from sys import version_info
            nRequiredSize = int(buf_xsize * buf_ysize * len(band_list) * (_gdal.GetDataTypeSize(buf_type) / 8))
            if version_info >= (3,0,0):
                buf_obj_ar = [ None ]
                exec("buf_obj_ar[0] = b' ' * nRequiredSize")
                buf_obj = buf_obj_ar[0]
            else:
                buf_obj = ' ' * nRequiredSize
        return _gdal.Dataset_BeginAsyncReader(self, xoff, yoff, xsize, ysize, buf_obj, buf_xsize, buf_ysize, buf_type, band_list,  0, 0, 0, options)

    def GetLayer(self,iLayer=0):
        """Return the layer given an index or a name"""
        if isinstance(iLayer, str):
            return self.GetLayerByName(str(iLayer))
        elif isinstance(iLayer, int):
            return self.GetLayerByIndex(iLayer)
        else:
            raise TypeError("Input %s is not of String or Int type" % type(iLayer))

    def DeleteLayer(self, value):
        """Deletes the layer given an index or layer name"""
        if isinstance(value, str):
            for i in range(self.GetLayerCount()):
                name = self.GetLayer(i).GetName()
                if name == value:
                    return _gdal.Dataset_DeleteLayer(self, i)
            raise ValueError("Layer %s not found to delete" % value)
        elif isinstance(value, int):
            return _gdal.Dataset_DeleteLayer(self, value)
        else:
            raise TypeError("Input %s is not of String or Int type" % type(value))

Dataset_swigregister = _gdal.Dataset_swigregister
Dataset_swigregister(Dataset)

class Band(MajorObject):
    """Proxy of C++ GDALRasterBandShadow class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    XSize = _swig_property(_gdal.Band_XSize_get)
    YSize = _swig_property(_gdal.Band_YSize_get)
    DataType = _swig_property(_gdal.Band_DataType_get)
    def GetDataset(self, *args):
        """GetDataset(self) -> Dataset"""
        return _gdal.Band_GetDataset(self, *args)

    def GetBand(self, *args):
        """GetBand(self) -> int"""
        return _gdal.Band_GetBand(self, *args)

    def GetBlockSize(self, *args):
        """GetBlockSize(self)"""
        return _gdal.Band_GetBlockSize(self, *args)

    def GetActualBlockSize(self, *args):
        """GetActualBlockSize(self, int nXBlockOff, int nYBlockOff)"""
        return _gdal.Band_GetActualBlockSize(self, *args)

    def GetColorInterpretation(self, *args):
        """GetColorInterpretation(self) -> GDALColorInterp"""
        return _gdal.Band_GetColorInterpretation(self, *args)

    def GetRasterColorInterpretation(self, *args):
        """GetRasterColorInterpretation(self) -> GDALColorInterp"""
        return _gdal.Band_GetRasterColorInterpretation(self, *args)

    def SetColorInterpretation(self, *args):
        """SetColorInterpretation(self, GDALColorInterp val) -> CPLErr"""
        return _gdal.Band_SetColorInterpretation(self, *args)

    def SetRasterColorInterpretation(self, *args):
        """SetRasterColorInterpretation(self, GDALColorInterp val) -> CPLErr"""
        return _gdal.Band_SetRasterColorInterpretation(self, *args)

    def GetNoDataValue(self, *args):
        """GetNoDataValue(self)"""
        return _gdal.Band_GetNoDataValue(self, *args)

    def SetNoDataValue(self, *args):
        """SetNoDataValue(self, double d) -> CPLErr"""
        return _gdal.Band_SetNoDataValue(self, *args)

    def DeleteNoDataValue(self, *args):
        """DeleteNoDataValue(self) -> CPLErr"""
        return _gdal.Band_DeleteNoDataValue(self, *args)

    def GetUnitType(self, *args):
        """GetUnitType(self) -> char"""
        return _gdal.Band_GetUnitType(self, *args)

    def SetUnitType(self, *args):
        """SetUnitType(self, char val) -> CPLErr"""
        return _gdal.Band_SetUnitType(self, *args)

    def GetRasterCategoryNames(self, *args):
        """GetRasterCategoryNames(self) -> char"""
        return _gdal.Band_GetRasterCategoryNames(self, *args)

    def SetRasterCategoryNames(self, *args):
        """SetRasterCategoryNames(self, char names) -> CPLErr"""
        return _gdal.Band_SetRasterCategoryNames(self, *args)

    def GetMinimum(self, *args):
        """GetMinimum(self)"""
        return _gdal.Band_GetMinimum(self, *args)

    def GetMaximum(self, *args):
        """GetMaximum(self)"""
        return _gdal.Band_GetMaximum(self, *args)

    def GetOffset(self, *args):
        """GetOffset(self)"""
        return _gdal.Band_GetOffset(self, *args)

    def GetScale(self, *args):
        """GetScale(self)"""
        return _gdal.Band_GetScale(self, *args)

    def SetOffset(self, *args):
        """SetOffset(self, double val) -> CPLErr"""
        return _gdal.Band_SetOffset(self, *args)

    def SetScale(self, *args):
        """SetScale(self, double val) -> CPLErr"""
        return _gdal.Band_SetScale(self, *args)

    def GetStatistics(self, *args):
        """GetStatistics(self, int approx_ok, int force) -> CPLErr"""
        return _gdal.Band_GetStatistics(self, *args)

    def ComputeStatistics(self, *args):
        """ComputeStatistics(self, bool approx_ok, GDALProgressFunc callback = 0, void callback_data = None) -> CPLErr"""
        return _gdal.Band_ComputeStatistics(self, *args)

    def SetStatistics(self, *args):
        """SetStatistics(self, double min, double max, double mean, double stddev) -> CPLErr"""
        return _gdal.Band_SetStatistics(self, *args)

    def GetOverviewCount(self, *args):
        """GetOverviewCount(self) -> int"""
        return _gdal.Band_GetOverviewCount(self, *args)

    def GetOverview(self, *args):
        """GetOverview(self, int i) -> Band"""
        return _gdal.Band_GetOverview(self, *args)

    def Checksum(self, *args, **kwargs):
        """Checksum(self, int xoff = 0, int yoff = 0, int xsize = None, int ysize = None) -> int"""
        return _gdal.Band_Checksum(self, *args, **kwargs)

    def ComputeRasterMinMax(self, *args):
        """ComputeRasterMinMax(self, int approx_ok = 0)"""
        return _gdal.Band_ComputeRasterMinMax(self, *args)

    def ComputeBandStats(self, *args):
        """ComputeBandStats(self, int samplestep = 1)"""
        return _gdal.Band_ComputeBandStats(self, *args)

    def Fill(self, *args):
        """Fill(self, double real_fill, double imag_fill = 0.0) -> CPLErr"""
        return _gdal.Band_Fill(self, *args)

    def WriteRaster(self, *args, **kwargs):
        """
        WriteRaster(self, int xoff, int yoff, int xsize, int ysize, GIntBig buf_len, 
            int buf_xsize = None, int buf_ysize = None, 
            int buf_type = None, GIntBig buf_pixel_space = None, 
            GIntBig buf_line_space = None) -> CPLErr
        """
        return _gdal.Band_WriteRaster(self, *args, **kwargs)

    def FlushCache(self, *args):
        """FlushCache(self)"""
        return _gdal.Band_FlushCache(self, *args)

    def GetRasterColorTable(self, *args):
        """GetRasterColorTable(self) -> ColorTable"""
        return _gdal.Band_GetRasterColorTable(self, *args)

    def GetColorTable(self, *args):
        """GetColorTable(self) -> ColorTable"""
        return _gdal.Band_GetColorTable(self, *args)

    def SetRasterColorTable(self, *args):
        """SetRasterColorTable(self, ColorTable arg) -> int"""
        return _gdal.Band_SetRasterColorTable(self, *args)

    def SetColorTable(self, *args):
        """SetColorTable(self, ColorTable arg) -> int"""
        return _gdal.Band_SetColorTable(self, *args)

    def GetDefaultRAT(self, *args):
        """GetDefaultRAT(self) -> RasterAttributeTable"""
        return _gdal.Band_GetDefaultRAT(self, *args)

    def SetDefaultRAT(self, *args):
        """SetDefaultRAT(self, RasterAttributeTable table) -> int"""
        return _gdal.Band_SetDefaultRAT(self, *args)

    def GetMaskBand(self, *args):
        """GetMaskBand(self) -> Band"""
        return _gdal.Band_GetMaskBand(self, *args)

    def GetMaskFlags(self, *args):
        """GetMaskFlags(self) -> int"""
        return _gdal.Band_GetMaskFlags(self, *args)

    def CreateMaskBand(self, *args):
        """CreateMaskBand(self, int nFlags) -> CPLErr"""
        return _gdal.Band_CreateMaskBand(self, *args)

    def GetHistogram(self, *args, **kwargs):
        """
        GetHistogram(self, double min = -0.5, double max = 255.5, int buckets = 256, 
            int include_out_of_range = 0, int approx_ok = 1, 
            GDALProgressFunc callback = 0, void callback_data = None) -> CPLErr
        """
        return _gdal.Band_GetHistogram(self, *args, **kwargs)

    def GetDefaultHistogram(self, *args, **kwargs):
        """
        GetDefaultHistogram(self, double min_ret = None, double max_ret = None, int buckets_ret = None, 
            GUIntBig ppanHistogram = None, 
            int force = 1, GDALProgressFunc callback = 0, 
            void callback_data = None) -> CPLErr
        """
        return _gdal.Band_GetDefaultHistogram(self, *args, **kwargs)

    def SetDefaultHistogram(self, *args):
        """SetDefaultHistogram(self, double min, double max, int buckets_in) -> CPLErr"""
        return _gdal.Band_SetDefaultHistogram(self, *args)

    def HasArbitraryOverviews(self, *args):
        """HasArbitraryOverviews(self) -> bool"""
        return _gdal.Band_HasArbitraryOverviews(self, *args)

    def GetCategoryNames(self, *args):
        """GetCategoryNames(self) -> char"""
        return _gdal.Band_GetCategoryNames(self, *args)

    def SetCategoryNames(self, *args):
        """SetCategoryNames(self, char papszCategoryNames) -> CPLErr"""
        return _gdal.Band_SetCategoryNames(self, *args)

    def GetVirtualMem(self, *args, **kwargs):
        """
        GetVirtualMem(self, GDALRWFlag eRWFlag, int nXOff, int nYOff, int nXSize, 
            int nYSize, int nBufXSize, int nBufYSize, 
            GDALDataType eBufType, size_t nCacheSize, size_t nPageSizeHint, 
            char options = None) -> VirtualMem
        """
        return _gdal.Band_GetVirtualMem(self, *args, **kwargs)

    def GetVirtualMemAuto(self, *args, **kwargs):
        """GetVirtualMemAuto(self, GDALRWFlag eRWFlag, char options = None) -> VirtualMem"""
        return _gdal.Band_GetVirtualMemAuto(self, *args, **kwargs)

    def GetTiledVirtualMem(self, *args, **kwargs):
        """
        GetTiledVirtualMem(self, GDALRWFlag eRWFlag, int nXOff, int nYOff, int nXSize, 
            int nYSize, int nTileXSize, int nTileYSize, 
            GDALDataType eBufType, size_t nCacheSize, char options = None) -> VirtualMem
        """
        return _gdal.Band_GetTiledVirtualMem(self, *args, **kwargs)

    def GetDataCoverageStatus(self, *args):
        """GetDataCoverageStatus(self, int nXOff, int nYOff, int nXSize, int nYSize, int nMaskFlagStop = 0) -> int"""
        return _gdal.Band_GetDataCoverageStatus(self, *args)

    def AdviseRead(self, *args):
        """
        AdviseRead(self, int xoff, int yoff, int xsize, int ysize, int buf_xsize = None, 
            int buf_ysize = None, GDALDataType buf_type = None, 
            char options = None) -> CPLErr
        """
        return _gdal.Band_AdviseRead(self, *args)

    def ReadRaster1(self, *args, **kwargs):
        """
        ReadRaster1(self, double xoff, double yoff, double xsize, double ysize, 
            int buf_xsize = None, int buf_ysize = None, 
            int buf_type = None, GIntBig buf_pixel_space = None, 
            GIntBig buf_line_space = None, GDALRIOResampleAlg resample_alg = GRIORA_NearestNeighbour, 
            GDALProgressFunc callback = 0, 
            void callback_data = None) -> CPLErr
        """
        return _gdal.Band_ReadRaster1(self, *args, **kwargs)

    def ReadBlock(self, *args, **kwargs):
        """ReadBlock(self, int xoff, int yoff) -> CPLErr"""
        return _gdal.Band_ReadBlock(self, *args, **kwargs)

    def ComputeStatistics(self, *args):
      """ComputeStatistics(Band self, bool approx_ok, GDALProgressFunc callback=0, void * callback_data=None) -> CPLErr"""

      # For backward compatibility. New SWIG has stricter typing and really
      # enforces bool
      approx_ok = args[0]
      if approx_ok == 0:
          approx_ok = False
      elif approx_ok == 1:
          approx_ok = True
      new_args = [ approx_ok ]
      for arg in args[1:]:
          new_args.append( arg )

      return _gdal.Band_ComputeStatistics(self, *new_args)


    def ReadRaster(self, xoff = 0, yoff = 0, xsize = None, ysize = None,
                     buf_xsize = None, buf_ysize = None, buf_type = None,
                     buf_pixel_space = None, buf_line_space = None,
                     resample_alg = GRIORA_NearestNeighbour,
                     callback = None,
                     callback_data = None):

        if xsize is None:
            xsize = self.XSize
        if ysize is None:
            ysize = self.YSize

        return _gdal.Band_ReadRaster1(self, xoff, yoff, xsize, ysize,
                                      buf_xsize, buf_ysize, buf_type,
                                      buf_pixel_space, buf_line_space,
                                      resample_alg, callback, callback_data)

    def ReadAsArray(self, xoff=0, yoff=0, win_xsize=None, win_ysize=None,
                    buf_xsize=None, buf_ysize=None, buf_type=None, buf_obj=None,
                    resample_alg = GRIORA_NearestNeighbour,
                    callback = None,
                    callback_data = None):
        """ Reading a chunk of a GDAL band into a numpy array. The optional (buf_xsize,buf_ysize,buf_type)
        parameters should generally not be specified if buf_obj is specified. The array is returned"""

        import gdalnumeric

        return gdalnumeric.BandReadAsArray( self, xoff, yoff,
                                            win_xsize, win_ysize,
                                            buf_xsize, buf_ysize, buf_type, buf_obj,
                                            resample_alg = resample_alg,
                                            callback = callback,
                                            callback_data = callback_data)

    def WriteArray(self, array, xoff=0, yoff=0,
                   resample_alg = GRIORA_NearestNeighbour,
                   callback = None,
                   callback_data = None):
        import gdalnumeric

        return gdalnumeric.BandWriteArray( self, array, xoff, yoff,
                                           resample_alg = resample_alg,
                                           callback = callback,
                                           callback_data = callback_data )

    def GetVirtualMemArray(self, eAccess = gdalconst.GF_Read, xoff=0, yoff=0,
                           xsize=None, ysize=None, bufxsize=None, bufysize=None,
                           datatype = None,
                           cache_size = 10 * 1024 * 1024, page_size_hint = 0,
                           options = None):
          """Return a NumPy array for the band, seen as a virtual memory mapping.
             An element is accessed with array[y][x].
             Any reference to the array must be dropped before the last reference to the
             related dataset is also dropped.
          """
          import gdalnumeric
          if xsize is None:
              xsize = self.XSize
          if ysize is None:
              ysize = self.YSize
          if bufxsize is None:
              bufxsize = self.XSize
          if bufysize is None:
              bufysize = self.YSize
          if datatype is None:
              datatype = self.DataType
          if options is None:
              virtualmem = self.GetVirtualMem(eAccess,xoff,yoff,xsize,ysize,bufxsize,bufysize,datatype,cache_size,page_size_hint)
          else:
              virtualmem = self.GetVirtualMem(eAccess,xoff,yoff,xsize,ysize,bufxsize,bufysize,datatype,cache_size,page_size_hint,options)
          return gdalnumeric.VirtualMemGetArray( virtualmem )

    def GetVirtualMemAutoArray(self, eAccess = gdalconst.GF_Read, options = None):
          """Return a NumPy array for the band, seen as a virtual memory mapping.
             An element is accessed with array[y][x].
             Any reference to the array must be dropped before the last reference to the
             related dataset is also dropped.
          """
          import gdalnumeric
          if options is None:
              virtualmem = self.GetVirtualMemAuto(eAccess)
          else:
              virtualmem = self.GetVirtualMemAuto(eAccess,options)
          return gdalnumeric.VirtualMemGetArray( virtualmem )

    def GetTiledVirtualMemArray(self, eAccess = gdalconst.GF_Read, xoff=0, yoff=0,
                             xsize=None, ysize=None, tilexsize=256, tileysize=256,
                             datatype = None,
                             cache_size = 10 * 1024 * 1024, options = None):
          """Return a NumPy array for the band, seen as a virtual memory mapping with
             a tile organization.
             An element is accessed with array[tiley][tilex][y][x].
             Any reference to the array must be dropped before the last reference to the
             related dataset is also dropped.
          """
          import gdalnumeric
          if xsize is None:
              xsize = self.XSize
          if ysize is None:
              ysize = self.YSize
          if datatype is None:
              datatype = self.DataType
          if options is None:
              virtualmem = self.GetTiledVirtualMem(eAccess,xoff,yoff,xsize,ysize,tilexsize,tileysize,datatype,cache_size)
          else:
              virtualmem = self.GetTiledVirtualMem(eAccess,xoff,yoff,xsize,ysize,tilexsize,tileysize,datatype,cache_size,options)
          return gdalnumeric.VirtualMemGetArray( virtualmem )

    def __get_array_interface__(self):
        shape = [1, self.XSize, self.YSize]


Band_swigregister = _gdal.Band_swigregister
Band_swigregister(Band)

class ColorTable(object):
    """Proxy of C++ GDALColorTableShadow class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args, **kwargs): 
        """__init__(self, GDALPaletteInterp palette = GPI_RGB) -> ColorTable"""
        this = _gdal.new_ColorTable(*args, **kwargs)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _gdal.delete_ColorTable
    __del__ = lambda self : None;
    def Clone(self, *args):
        """Clone(self) -> ColorTable"""
        return _gdal.ColorTable_Clone(self, *args)

    def GetPaletteInterpretation(self, *args):
        """GetPaletteInterpretation(self) -> GDALPaletteInterp"""
        return _gdal.ColorTable_GetPaletteInterpretation(self, *args)

    def GetCount(self, *args):
        """GetCount(self) -> int"""
        return _gdal.ColorTable_GetCount(self, *args)

    def GetColorEntry(self, *args):
        """GetColorEntry(self, int entry) -> ColorEntry"""
        return _gdal.ColorTable_GetColorEntry(self, *args)

    def GetColorEntryAsRGB(self, *args):
        """GetColorEntryAsRGB(self, int entry, ColorEntry centry) -> int"""
        return _gdal.ColorTable_GetColorEntryAsRGB(self, *args)

    def SetColorEntry(self, *args):
        """SetColorEntry(self, int entry, ColorEntry centry)"""
        return _gdal.ColorTable_SetColorEntry(self, *args)

    def CreateColorRamp(self, *args):
        """
        CreateColorRamp(self, int nStartIndex, ColorEntry startcolor, int nEndIndex, 
            ColorEntry endcolor)
        """
        return _gdal.ColorTable_CreateColorRamp(self, *args)

ColorTable_swigregister = _gdal.ColorTable_swigregister
ColorTable_swigregister(ColorTable)

class RasterAttributeTable(object):
    """Proxy of C++ GDALRasterAttributeTableShadow class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self) -> RasterAttributeTable"""
        this = _gdal.new_RasterAttributeTable(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _gdal.delete_RasterAttributeTable
    __del__ = lambda self : None;
    def Clone(self, *args):
        """Clone(self) -> RasterAttributeTable"""
        return _gdal.RasterAttributeTable_Clone(self, *args)

    def GetColumnCount(self, *args):
        """GetColumnCount(self) -> int"""
        return _gdal.RasterAttributeTable_GetColumnCount(self, *args)

    def GetNameOfCol(self, *args):
        """GetNameOfCol(self, int iCol) -> char"""
        return _gdal.RasterAttributeTable_GetNameOfCol(self, *args)

    def GetUsageOfCol(self, *args):
        """GetUsageOfCol(self, int iCol) -> GDALRATFieldUsage"""
        return _gdal.RasterAttributeTable_GetUsageOfCol(self, *args)

    def GetTypeOfCol(self, *args):
        """GetTypeOfCol(self, int iCol) -> GDALRATFieldType"""
        return _gdal.RasterAttributeTable_GetTypeOfCol(self, *args)

    def GetColOfUsage(self, *args):
        """GetColOfUsage(self, GDALRATFieldUsage eUsage) -> int"""
        return _gdal.RasterAttributeTable_GetColOfUsage(self, *args)

    def GetRowCount(self, *args):
        """GetRowCount(self) -> int"""
        return _gdal.RasterAttributeTable_GetRowCount(self, *args)

    def GetValueAsString(self, *args):
        """GetValueAsString(self, int iRow, int iCol) -> char"""
        return _gdal.RasterAttributeTable_GetValueAsString(self, *args)

    def GetValueAsInt(self, *args):
        """GetValueAsInt(self, int iRow, int iCol) -> int"""
        return _gdal.RasterAttributeTable_GetValueAsInt(self, *args)

    def GetValueAsDouble(self, *args):
        """GetValueAsDouble(self, int iRow, int iCol) -> double"""
        return _gdal.RasterAttributeTable_GetValueAsDouble(self, *args)

    def SetValueAsString(self, *args):
        """SetValueAsString(self, int iRow, int iCol, char pszValue)"""
        return _gdal.RasterAttributeTable_SetValueAsString(self, *args)

    def SetValueAsInt(self, *args):
        """SetValueAsInt(self, int iRow, int iCol, int nValue)"""
        return _gdal.RasterAttributeTable_SetValueAsInt(self, *args)

    def SetValueAsDouble(self, *args):
        """SetValueAsDouble(self, int iRow, int iCol, double dfValue)"""
        return _gdal.RasterAttributeTable_SetValueAsDouble(self, *args)

    def SetRowCount(self, *args):
        """SetRowCount(self, int nCount)"""
        return _gdal.RasterAttributeTable_SetRowCount(self, *args)

    def CreateColumn(self, *args):
        """CreateColumn(self, char pszName, GDALRATFieldType eType, GDALRATFieldUsage eUsage) -> int"""
        return _gdal.RasterAttributeTable_CreateColumn(self, *args)

    def GetLinearBinning(self, *args):
        """GetLinearBinning(self) -> bool"""
        return _gdal.RasterAttributeTable_GetLinearBinning(self, *args)

    def SetLinearBinning(self, *args):
        """SetLinearBinning(self, double dfRow0Min, double dfBinSize) -> int"""
        return _gdal.RasterAttributeTable_SetLinearBinning(self, *args)

    def GetRowOfValue(self, *args):
        """GetRowOfValue(self, double dfValue) -> int"""
        return _gdal.RasterAttributeTable_GetRowOfValue(self, *args)

    def ChangesAreWrittenToFile(self, *args):
        """ChangesAreWrittenToFile(self) -> int"""
        return _gdal.RasterAttributeTable_ChangesAreWrittenToFile(self, *args)

    def DumpReadable(self, *args):
        """DumpReadable(self)"""
        return _gdal.RasterAttributeTable_DumpReadable(self, *args)

    def WriteArray(self, array, field, start=0):
        import gdalnumeric

        return gdalnumeric.RATWriteArray(self, array, field, start)

    def ReadAsArray(self, field, start=0, length=None):
        import gdalnumeric

        return gdalnumeric.RATReadArray(self, field, start, length)

RasterAttributeTable_swigregister = _gdal.RasterAttributeTable_swigregister
RasterAttributeTable_swigregister(RasterAttributeTable)


def TermProgress_nocb(*args, **kwargs):
  """TermProgress_nocb(double dfProgress, char pszMessage = None, void pData = None) -> int"""
  return _gdal.TermProgress_nocb(*args, **kwargs)
TermProgress = _gdal.TermProgress

def ComputeMedianCutPCT(*args, **kwargs):
  """
    ComputeMedianCutPCT(Band red, Band green, Band blue, int num_colors, ColorTable colors, 
        GDALProgressFunc callback = 0, 
        void callback_data = None) -> int
    """
  return _gdal.ComputeMedianCutPCT(*args, **kwargs)
ComputeMedianCutPCT = _gdal.ComputeMedianCutPCT

def DitherRGB2PCT(*args, **kwargs):
  """
    DitherRGB2PCT(Band red, Band green, Band blue, Band target, ColorTable colors, 
        GDALProgressFunc callback = 0, 
        void callback_data = None) -> int
    """
  return _gdal.DitherRGB2PCT(*args, **kwargs)
DitherRGB2PCT = _gdal.DitherRGB2PCT

def ReprojectImage(*args, **kwargs):
  """
    ReprojectImage(Dataset src_ds, Dataset dst_ds, char src_wkt = None, 
        char dst_wkt = None, GDALResampleAlg eResampleAlg = GRA_NearestNeighbour, 
        double WarpMemoryLimit = 0.0, 
        double maxerror = 0.0, GDALProgressFunc callback = 0, 
        void callback_data = None, 
        char options = None) -> CPLErr
    """
  return _gdal.ReprojectImage(*args, **kwargs)
ReprojectImage = _gdal.ReprojectImage

def ComputeProximity(*args, **kwargs):
  """
    ComputeProximity(Band srcBand, Band proximityBand, char options = None, 
        GDALProgressFunc callback = 0, void callback_data = None) -> int
    """
  return _gdal.ComputeProximity(*args, **kwargs)
ComputeProximity = _gdal.ComputeProximity

def RasterizeLayer(*args, **kwargs):
  """
    RasterizeLayer(Dataset dataset, int bands, Layer layer, void pfnTransformer = None, 
        void pTransformArg = None, 
        int burn_values = 0, char options = None, GDALProgressFunc callback = 0, 
        void callback_data = None) -> int
    """
  return _gdal.RasterizeLayer(*args, **kwargs)
RasterizeLayer = _gdal.RasterizeLayer

def Polygonize(*args, **kwargs):
  """
    Polygonize(Band srcBand, Band maskBand, Layer outLayer, int iPixValField, 
        char options = None, GDALProgressFunc callback = 0, 
        void callback_data = None) -> int
    """
  return _gdal.Polygonize(*args, **kwargs)
Polygonize = _gdal.Polygonize

def FPolygonize(*args, **kwargs):
  """
    FPolygonize(Band srcBand, Band maskBand, Layer outLayer, int iPixValField, 
        char options = None, GDALProgressFunc callback = 0, 
        void callback_data = None) -> int
    """
  return _gdal.FPolygonize(*args, **kwargs)
FPolygonize = _gdal.FPolygonize

def FillNodata(*args, **kwargs):
  """
    FillNodata(Band targetBand, Band maskBand, double maxSearchDist, 
        int smoothingIterations, char options = None, 
        GDALProgressFunc callback = 0, void callback_data = None) -> int
    """
  return _gdal.FillNodata(*args, **kwargs)
FillNodata = _gdal.FillNodata

def SieveFilter(*args, **kwargs):
  """
    SieveFilter(Band srcBand, Band maskBand, Band dstBand, int threshold, 
        int connectedness = 4, char options = None, 
        GDALProgressFunc callback = 0, void callback_data = None) -> int
    """
  return _gdal.SieveFilter(*args, **kwargs)
SieveFilter = _gdal.SieveFilter

def RegenerateOverviews(*args, **kwargs):
  """
    RegenerateOverviews(Band srcBand, int overviewBandCount, char resampling = "average", 
        GDALProgressFunc callback = 0, 
        void callback_data = None) -> int
    """
  return _gdal.RegenerateOverviews(*args, **kwargs)
RegenerateOverviews = _gdal.RegenerateOverviews

def RegenerateOverview(*args, **kwargs):
  """
    RegenerateOverview(Band srcBand, Band overviewBand, char resampling = "average", 
        GDALProgressFunc callback = 0, void callback_data = None) -> int
    """
  return _gdal.RegenerateOverview(*args, **kwargs)
RegenerateOverview = _gdal.RegenerateOverview

def ContourGenerate(*args, **kwargs):
  """
    ContourGenerate(Band srcBand, double contourInterval, double contourBase, 
        int fixedLevelCount, int useNoData, double noDataValue, 
        Layer dstLayer, int idField, 
        int elevField, GDALProgressFunc callback = 0, 
        void callback_data = None) -> int
    """
  return _gdal.ContourGenerate(*args, **kwargs)
ContourGenerate = _gdal.ContourGenerate

def AutoCreateWarpedVRT(*args):
  """
    AutoCreateWarpedVRT(Dataset src_ds, char src_wkt = None, char dst_wkt = None, 
        GDALResampleAlg eResampleAlg = GRA_NearestNeighbour, 
        double maxerror = 0.0) -> Dataset
    """
  return _gdal.AutoCreateWarpedVRT(*args)
AutoCreateWarpedVRT = _gdal.AutoCreateWarpedVRT

def CreatePansharpenedVRT(*args):
  """CreatePansharpenedVRT(char pszXML, Band panchroBand, int nInputSpectralBands) -> Dataset"""
  return _gdal.CreatePansharpenedVRT(*args)
CreatePansharpenedVRT = _gdal.CreatePansharpenedVRT
class GDALTransformerInfoShadow(object):
    """Proxy of C++ GDALTransformerInfoShadow class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdal.delete_GDALTransformerInfoShadow
    __del__ = lambda self : None;
    def TransformPoint(self, *args):
        """
        TransformPoint(self, int bDstToSrc, double inout) -> int
        TransformPoint(self, int bDstToSrc, double x, double y, double z = 0.0) -> int
        """
        return _gdal.GDALTransformerInfoShadow_TransformPoint(self, *args)

    def TransformPoints(self, *args):
        """TransformPoints(self, int bDstToSrc, int nCount) -> int"""
        return _gdal.GDALTransformerInfoShadow_TransformPoints(self, *args)

    def TransformGeolocations(self, *args, **kwargs):
        """
        TransformGeolocations(self, Band xBand, Band yBand, Band zBand, GDALProgressFunc callback = 0, 
            void callback_data = None, char options = None) -> int
        """
        return _gdal.GDALTransformerInfoShadow_TransformGeolocations(self, *args, **kwargs)

GDALTransformerInfoShadow_swigregister = _gdal.GDALTransformerInfoShadow_swigregister
GDALTransformerInfoShadow_swigregister(GDALTransformerInfoShadow)


def Transformer(*args):
  """Transformer(Dataset src, Dataset dst, char options) -> GDALTransformerInfoShadow"""
  return _gdal.Transformer(*args)
Transformer = _gdal.Transformer

def ApplyVerticalShiftGrid(*args, **kwargs):
  """
    ApplyVerticalShiftGrid(Dataset src_ds, Dataset grid_ds, bool inverse = False, 
        double srcUnitToMeter = 1.0, double dstUnitToMeter = 1.0, 
        char options = None) -> Dataset
    """
  return _gdal.ApplyVerticalShiftGrid(*args, **kwargs)
ApplyVerticalShiftGrid = _gdal.ApplyVerticalShiftGrid

def ApplyGeoTransform(*args):
  """ApplyGeoTransform(double padfGeoTransform, double dfPixel, double dfLine)"""
  return _gdal.ApplyGeoTransform(*args)
ApplyGeoTransform = _gdal.ApplyGeoTransform

def InvGeoTransform(*args):
  """InvGeoTransform(double gt_in) -> RETURN_NONE"""
  return _gdal.InvGeoTransform(*args)
InvGeoTransform = _gdal.InvGeoTransform

def VersionInfo(*args):
  """VersionInfo(char request = "VERSION_NUM") -> char"""
  return _gdal.VersionInfo(*args)
VersionInfo = _gdal.VersionInfo

def AllRegister(*args):
  """AllRegister()"""
  return _gdal.AllRegister(*args)
AllRegister = _gdal.AllRegister

def GDALDestroyDriverManager(*args):
  """GDALDestroyDriverManager()"""
  return _gdal.GDALDestroyDriverManager(*args)
GDALDestroyDriverManager = _gdal.GDALDestroyDriverManager

def GetCacheMax(*args):
  """GetCacheMax() -> GIntBig"""
  return _gdal.GetCacheMax(*args)
GetCacheMax = _gdal.GetCacheMax

def GetCacheUsed(*args):
  """GetCacheUsed() -> GIntBig"""
  return _gdal.GetCacheUsed(*args)
GetCacheUsed = _gdal.GetCacheUsed

def SetCacheMax(*args):
  """SetCacheMax(GIntBig nBytes)"""
  return _gdal.SetCacheMax(*args)
SetCacheMax = _gdal.SetCacheMax

def GetDataTypeSize(*args):
  """GetDataTypeSize(GDALDataType eDataType) -> int"""
  return _gdal.GetDataTypeSize(*args)
GetDataTypeSize = _gdal.GetDataTypeSize

def DataTypeIsComplex(*args):
  """DataTypeIsComplex(GDALDataType eDataType) -> int"""
  return _gdal.DataTypeIsComplex(*args)
DataTypeIsComplex = _gdal.DataTypeIsComplex

def GetDataTypeName(*args):
  """GetDataTypeName(GDALDataType eDataType) -> char"""
  return _gdal.GetDataTypeName(*args)
GetDataTypeName = _gdal.GetDataTypeName

def GetDataTypeByName(*args):
  """GetDataTypeByName(char pszDataTypeName) -> GDALDataType"""
  return _gdal.GetDataTypeByName(*args)
GetDataTypeByName = _gdal.GetDataTypeByName

def GetColorInterpretationName(*args):
  """GetColorInterpretationName(GDALColorInterp eColorInterp) -> char"""
  return _gdal.GetColorInterpretationName(*args)
GetColorInterpretationName = _gdal.GetColorInterpretationName

def GetPaletteInterpretationName(*args):
  """GetPaletteInterpretationName(GDALPaletteInterp ePaletteInterp) -> char"""
  return _gdal.GetPaletteInterpretationName(*args)
GetPaletteInterpretationName = _gdal.GetPaletteInterpretationName

def DecToDMS(*args):
  """DecToDMS(double arg0, char arg1, int arg2 = 2) -> char"""
  return _gdal.DecToDMS(*args)
DecToDMS = _gdal.DecToDMS

def PackedDMSToDec(*args):
  """PackedDMSToDec(double dfPacked) -> double"""
  return _gdal.PackedDMSToDec(*args)
PackedDMSToDec = _gdal.PackedDMSToDec

def DecToPackedDMS(*args):
  """DecToPackedDMS(double dfDec) -> double"""
  return _gdal.DecToPackedDMS(*args)
DecToPackedDMS = _gdal.DecToPackedDMS

def ParseXMLString(*args):
  """ParseXMLString(char pszXMLString) -> CPLXMLNode"""
  return _gdal.ParseXMLString(*args)
ParseXMLString = _gdal.ParseXMLString

def SerializeXMLTree(*args):
  """SerializeXMLTree(CPLXMLNode xmlnode) -> retStringAndCPLFree"""
  return _gdal.SerializeXMLTree(*args)
SerializeXMLTree = _gdal.SerializeXMLTree

def GetJPEG2000Structure(*args):
  """GetJPEG2000Structure(char pszFilename, char options = None) -> CPLXMLNode"""
  return _gdal.GetJPEG2000Structure(*args)
GetJPEG2000Structure = _gdal.GetJPEG2000Structure

def GetJPEG2000StructureAsString(*args):
  """GetJPEG2000StructureAsString(char pszFilename, char options = None) -> retStringAndCPLFree"""
  return _gdal.GetJPEG2000StructureAsString(*args)
GetJPEG2000StructureAsString = _gdal.GetJPEG2000StructureAsString

def GetDriverCount(*args):
  """GetDriverCount() -> int"""
  return _gdal.GetDriverCount(*args)
GetDriverCount = _gdal.GetDriverCount

def GetDriverByName(*args):
  """GetDriverByName(char name) -> Driver"""
  return _gdal.GetDriverByName(*args)
GetDriverByName = _gdal.GetDriverByName

def GetDriver(*args):
  """GetDriver(int i) -> Driver"""
  return _gdal.GetDriver(*args)
GetDriver = _gdal.GetDriver

def Open(*args):
  """Open(char utf8_path, GDALAccess eAccess = GA_ReadOnly) -> Dataset"""
  return _gdal.Open(*args)
Open = _gdal.Open

def OpenEx(*args, **kwargs):
  """
    OpenEx(char utf8_path, unsigned int nOpenFlags = 0, char allowed_drivers = None, 
        char open_options = None, 
        char sibling_files = None) -> Dataset
    """
  return _gdal.OpenEx(*args, **kwargs)
OpenEx = _gdal.OpenEx

def OpenShared(*args):
  """OpenShared(char utf8_path, GDALAccess eAccess = GA_ReadOnly) -> Dataset"""
  return _gdal.OpenShared(*args)
OpenShared = _gdal.OpenShared

def IdentifyDriver(*args):
  """IdentifyDriver(char utf8_path, char papszSiblings = None) -> Driver"""
  return _gdal.IdentifyDriver(*args)
IdentifyDriver = _gdal.IdentifyDriver

def IdentifyDriverEx(*args, **kwargs):
  """
    IdentifyDriverEx(char utf8_path, unsigned int nIdentifyFlags = 0, char allowed_drivers = None, 
        char sibling_files = None) -> Driver
    """
  return _gdal.IdentifyDriverEx(*args, **kwargs)
IdentifyDriverEx = _gdal.IdentifyDriverEx

def GeneralCmdLineProcessor(*args):
  """GeneralCmdLineProcessor(char papszArgv, int nOptions = 0) -> char"""
  return _gdal.GeneralCmdLineProcessor(*args)
GeneralCmdLineProcessor = _gdal.GeneralCmdLineProcessor
__version__ = _gdal.VersionInfo("RELEASE_NAME")

class GDALInfoOptions(object):
    """Proxy of C++ GDALInfoOptions class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, char options) -> GDALInfoOptions"""
        this = _gdal.new_GDALInfoOptions(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _gdal.delete_GDALInfoOptions
    __del__ = lambda self : None;
GDALInfoOptions_swigregister = _gdal.GDALInfoOptions_swigregister
GDALInfoOptions_swigregister(GDALInfoOptions)


def InfoInternal(*args):
  """InfoInternal(Dataset hDataset, GDALInfoOptions infoOptions) -> retStringAndCPLFree"""
  return _gdal.InfoInternal(*args)
InfoInternal = _gdal.InfoInternal
class GDALTranslateOptions(object):
    """Proxy of C++ GDALTranslateOptions class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, char options) -> GDALTranslateOptions"""
        this = _gdal.new_GDALTranslateOptions(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _gdal.delete_GDALTranslateOptions
    __del__ = lambda self : None;
GDALTranslateOptions_swigregister = _gdal.GDALTranslateOptions_swigregister
GDALTranslateOptions_swigregister(GDALTranslateOptions)


def TranslateInternal(*args):
  """
    TranslateInternal(char dest, Dataset dataset, GDALTranslateOptions translateOptions, 
        GDALProgressFunc callback = 0, 
        void callback_data = None) -> Dataset
    """
  return _gdal.TranslateInternal(*args)
TranslateInternal = _gdal.TranslateInternal
class GDALWarpAppOptions(object):
    """Proxy of C++ GDALWarpAppOptions class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, char options) -> GDALWarpAppOptions"""
        this = _gdal.new_GDALWarpAppOptions(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _gdal.delete_GDALWarpAppOptions
    __del__ = lambda self : None;
GDALWarpAppOptions_swigregister = _gdal.GDALWarpAppOptions_swigregister
GDALWarpAppOptions_swigregister(GDALWarpAppOptions)


def wrapper_GDALWarpDestDS(*args):
  """
    wrapper_GDALWarpDestDS(Dataset dstDS, int object_list_count, GDALWarpAppOptions warpAppOptions, 
        GDALProgressFunc callback = 0, 
        void callback_data = None) -> int
    """
  return _gdal.wrapper_GDALWarpDestDS(*args)
wrapper_GDALWarpDestDS = _gdal.wrapper_GDALWarpDestDS

def wrapper_GDALWarpDestName(*args):
  """
    wrapper_GDALWarpDestName(char dest, int object_list_count, GDALWarpAppOptions warpAppOptions, 
        GDALProgressFunc callback = 0, 
        void callback_data = None) -> Dataset
    """
  return _gdal.wrapper_GDALWarpDestName(*args)
wrapper_GDALWarpDestName = _gdal.wrapper_GDALWarpDestName
class GDALVectorTranslateOptions(object):
    """Proxy of C++ GDALVectorTranslateOptions class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, char options) -> GDALVectorTranslateOptions"""
        this = _gdal.new_GDALVectorTranslateOptions(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _gdal.delete_GDALVectorTranslateOptions
    __del__ = lambda self : None;
GDALVectorTranslateOptions_swigregister = _gdal.GDALVectorTranslateOptions_swigregister
GDALVectorTranslateOptions_swigregister(GDALVectorTranslateOptions)


def wrapper_GDALVectorTranslateDestDS(*args):
  """
    wrapper_GDALVectorTranslateDestDS(Dataset dstDS, Dataset srcDS, GDALVectorTranslateOptions options, 
        GDALProgressFunc callback = 0, 
        void callback_data = None) -> int
    """
  return _gdal.wrapper_GDALVectorTranslateDestDS(*args)
wrapper_GDALVectorTranslateDestDS = _gdal.wrapper_GDALVectorTranslateDestDS

def wrapper_GDALVectorTranslateDestName(*args):
  """
    wrapper_GDALVectorTranslateDestName(char dest, Dataset srcDS, GDALVectorTranslateOptions options, 
        GDALProgressFunc callback = 0, void callback_data = None) -> Dataset
    """
  return _gdal.wrapper_GDALVectorTranslateDestName(*args)
wrapper_GDALVectorTranslateDestName = _gdal.wrapper_GDALVectorTranslateDestName
class GDALDEMProcessingOptions(object):
    """Proxy of C++ GDALDEMProcessingOptions class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, char options) -> GDALDEMProcessingOptions"""
        this = _gdal.new_GDALDEMProcessingOptions(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _gdal.delete_GDALDEMProcessingOptions
    __del__ = lambda self : None;
GDALDEMProcessingOptions_swigregister = _gdal.GDALDEMProcessingOptions_swigregister
GDALDEMProcessingOptions_swigregister(GDALDEMProcessingOptions)


def DEMProcessingInternal(*args):
  """
    DEMProcessingInternal(char dest, Dataset dataset, char pszProcessing, char pszColorFilename, 
        GDALDEMProcessingOptions options, 
        GDALProgressFunc callback = 0, void callback_data = None) -> Dataset
    """
  return _gdal.DEMProcessingInternal(*args)
DEMProcessingInternal = _gdal.DEMProcessingInternal
class GDALNearblackOptions(object):
    """Proxy of C++ GDALNearblackOptions class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, char options) -> GDALNearblackOptions"""
        this = _gdal.new_GDALNearblackOptions(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _gdal.delete_GDALNearblackOptions
    __del__ = lambda self : None;
GDALNearblackOptions_swigregister = _gdal.GDALNearblackOptions_swigregister
GDALNearblackOptions_swigregister(GDALNearblackOptions)


def wrapper_GDALNearblackDestDS(*args):
  """
    wrapper_GDALNearblackDestDS(Dataset dstDS, Dataset srcDS, GDALNearblackOptions options, 
        GDALProgressFunc callback = 0, void callback_data = None) -> int
    """
  return _gdal.wrapper_GDALNearblackDestDS(*args)
wrapper_GDALNearblackDestDS = _gdal.wrapper_GDALNearblackDestDS

def wrapper_GDALNearblackDestName(*args):
  """
    wrapper_GDALNearblackDestName(char dest, Dataset srcDS, GDALNearblackOptions options, 
        GDALProgressFunc callback = 0, void callback_data = None) -> Dataset
    """
  return _gdal.wrapper_GDALNearblackDestName(*args)
wrapper_GDALNearblackDestName = _gdal.wrapper_GDALNearblackDestName
class GDALGridOptions(object):
    """Proxy of C++ GDALGridOptions class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, char options) -> GDALGridOptions"""
        this = _gdal.new_GDALGridOptions(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _gdal.delete_GDALGridOptions
    __del__ = lambda self : None;
GDALGridOptions_swigregister = _gdal.GDALGridOptions_swigregister
GDALGridOptions_swigregister(GDALGridOptions)


def GridInternal(*args):
  """
    GridInternal(char dest, Dataset dataset, GDALGridOptions options, 
        GDALProgressFunc callback = 0, void callback_data = None) -> Dataset
    """
  return _gdal.GridInternal(*args)
GridInternal = _gdal.GridInternal
class GDALRasterizeOptions(object):
    """Proxy of C++ GDALRasterizeOptions class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, char options) -> GDALRasterizeOptions"""
        this = _gdal.new_GDALRasterizeOptions(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _gdal.delete_GDALRasterizeOptions
    __del__ = lambda self : None;
GDALRasterizeOptions_swigregister = _gdal.GDALRasterizeOptions_swigregister
GDALRasterizeOptions_swigregister(GDALRasterizeOptions)


def wrapper_GDALRasterizeDestDS(*args):
  """
    wrapper_GDALRasterizeDestDS(Dataset dstDS, Dataset srcDS, GDALRasterizeOptions options, 
        GDALProgressFunc callback = 0, void callback_data = None) -> int
    """
  return _gdal.wrapper_GDALRasterizeDestDS(*args)
wrapper_GDALRasterizeDestDS = _gdal.wrapper_GDALRasterizeDestDS

def wrapper_GDALRasterizeDestName(*args):
  """
    wrapper_GDALRasterizeDestName(char dest, Dataset srcDS, GDALRasterizeOptions options, 
        GDALProgressFunc callback = 0, void callback_data = None) -> Dataset
    """
  return _gdal.wrapper_GDALRasterizeDestName(*args)
wrapper_GDALRasterizeDestName = _gdal.wrapper_GDALRasterizeDestName
class GDALBuildVRTOptions(object):
    """Proxy of C++ GDALBuildVRTOptions class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, char options) -> GDALBuildVRTOptions"""
        this = _gdal.new_GDALBuildVRTOptions(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _gdal.delete_GDALBuildVRTOptions
    __del__ = lambda self : None;
GDALBuildVRTOptions_swigregister = _gdal.GDALBuildVRTOptions_swigregister
GDALBuildVRTOptions_swigregister(GDALBuildVRTOptions)


def BuildVRTInternalObjects(*args):
  """
    BuildVRTInternalObjects(char dest, int object_list_count, GDALBuildVRTOptions options, 
        GDALProgressFunc callback = 0, void callback_data = None) -> Dataset
    """
  return _gdal.BuildVRTInternalObjects(*args)
BuildVRTInternalObjects = _gdal.BuildVRTInternalObjects

def BuildVRTInternalNames(*args):
  """
    BuildVRTInternalNames(char dest, char source_filenames, GDALBuildVRTOptions options, 
        GDALProgressFunc callback = 0, void callback_data = None) -> Dataset
    """
  return _gdal.BuildVRTInternalNames(*args)
BuildVRTInternalNames = _gdal.BuildVRTInternalNames


