      subroutine ddmrate4(ny,nr,r,gain,loss)
      implicit none
c
c----CAMx v7Beta6 190902
c
c     DDMRATE4 computes species production and loss rates
c     needed only for DDM rate constant sensitivity
c
c     Copyright 1996 - 2019
c     Ramboll
c     Created by the CMC version 5.2.6
c
c --- Subroutines Called:
c        none
c
c --- Called by:
c        EBISOLV
c
c --- Argument definitions:
c        ny   - dimension of gain and loss
c        nr   - dimension of r
c        r    - reaction rates (hr-1)
c        gain - species production (ppm/hr)
c        loss - species destruction (ppm/hr)
c
c --- Includes:
      include "camx.prm"
      include "chmdat.inc"
      include "ddmchm.inc"
c
c --- Arguments:
      integer ny, nr
      real    loss(ny+1), gain(ny+1)
      real    r(nr)
c
c --- Entry Point:
c
c
c-----Calculate the species rates
c
c
c    NO   NO2    O3     O   O1D    OH   HO2  HONO   PNA   PAN
c  C2O3   NO3  N2O5     I    IO   OIO
c
        Loss(lNO   )= +         r(  3)+         r(  4)+( 2.000)*r( 24)
     &                +         r( 25)+         r( 29)+         r( 40)
     &                +         r( 41)+         r( 53)+         r( 61)
     &                +         r( 68)+         r( 71)+         r( 75)
     &                +         r( 79)+         r( 83)+         r(102)
     &                +         r(144)+         r(160)+         r(168)
     &                +         r(173)+         r(178)+         r(199)
     &                +         r(215)+         r(220)
c
        Gain(lNO   )= +         r(  1)+         r(  5)+         r( 28)
     &                +         r( 30)+         r( 42)+         r( 43)
     &                +         r( 68)
c
        Loss(lNO2  )= +         r(  1)+         r(  5)+         r(  6)
     &                +         r( 26)+         r( 30)+         r( 36)
     &                +         r( 41)+         r( 45)+         r( 48)
     &                +         r( 54)+         r( 62)+         r(132)
     &                +         r(184)+         r(200)+         r(216)
c
        Gain(lNO2  )= +         r(  3)+         r(  4)+( 2.000)*r( 24)
     &                +         r( 25)+         r( 27)+( 2.000)*r( 29)
     &                +         r( 30)+         r( 31)+         r( 32)
     &                +         r( 33)+         r( 34)+( 2.000)*r( 35)
     &                +         r( 37)+         r( 38)+         r( 42)
     &                +         r( 44)+         r( 47)+         r( 49)
     &                +( 0.590)*r( 50)+         r( 51)+         r( 53)
     &                +         r( 55)+( 0.600)*r( 56)+         r( 61)
     &                +         r( 63)+( 0.600)*r( 64)+         r( 71)
        Gain(lNO2  ) = Gain(lNO2  )
     &                +         r( 75)+         r( 79)+         r( 92)
     &                +         r(102)+( 0.500)*r(136)+( 0.500)*r(139)
     &                +( 0.500)*r(142)+( 0.900)*r(144)+( 0.350)*r(150)
     &                +( 0.142)*r(153)+         r(160)+( 0.444)*r(163)
     &                +( 0.470)*r(166)+( 0.918)*r(168)+( 0.860)*r(173)
     &                +( 0.860)*r(178)+( 0.500)*r(192)+         r(199)
     &                +         r(201)+( 0.500)*r(205)+         r(206)
     &                +         r(215)+         r(220)
c
        Loss(lO3   )= +         r(  3)+         r(  7)+         r(  8)
     &                +         r(  9)+         r( 12)+         r( 13)
     &                +         r( 26)+         r( 34)+         r(135)
     &                +         r(138)+         r(141)+         r(149)
     &                +         r(152)+         r(165)+         r(191)
     &                +         r(195)+         r(211)+         r(222)
c
        Gain(lO3   )= +         r(  2)+( 0.150)*r( 57)+( 0.150)*r( 65)
     &                +( 0.150)*r(202)
c
        Loss(lO    )= +         r(  2)+         r(  4)+         r(  5)
     &                +         r(  6)+         r(  7)+         r( 14)
     &                +         r( 15)+         r( 23)+         r( 31)
c
        Gain(lO    )= +         r(  1)+         r(  8)+         r( 10)
     &                +         r( 16)+         r( 27)+         r(212)
c
        Loss(lO1D  )= +         r( 10)+         r( 11)
c
        Gain(lO1D  )= +         r(  9)
c
        Loss(lOH   )= +         r( 12)+         r( 14)+( 2.000)*r( 16)
     &                +( 2.000)*r( 17)+         r( 18)+         r( 22)
     &                +         r( 32)+         r( 40)+         r( 44)
     &                +         r( 45)+         r( 46)+         r( 51)
     &                +         r( 52)+         r( 87)+         r( 89)
     &                +         r( 91)+         r( 93)+         r( 94)
     &                +         r( 95)+         r( 96)+         r(104)
     &                +         r(107)+         r(110)+         r(113)
     &                +         r(118)+         r(119)+         r(120)
        Loss(lOH   ) = Loss(lOH   )
     &                +         r(121)+         r(122)+         r(123)
     &                +         r(124)+         r(127)+         r(128)
     &                +         r(129)+         r(133)+         r(134)
     &                +         r(137)+         r(140)+         r(143)
     &                +         r(151)+         r(155)+         r(158)
     &                +         r(163)+         r(164)+         r(167)
     &                +         r(172)+         r(177)+         r(182)
     &                +         r(186)+         r(190)+         r(194)
        Loss(lOH   ) = Loss(lOH   )
     &                +         r(197)+         r(205)+         r(206)
     &                +         r(208)+         r(218)+         r(231)
     &                +         r(232)
c
        Gain(lOH   )= +( 2.000)*r( 11)+         r( 13)+         r( 15)
     &                +( 2.000)*r( 21)+         r( 23)+         r( 25)
     &                +         r( 33)+         r( 43)+         r( 47)
     &                +( 0.410)*r( 50)+( 0.440)*r( 57)+( 0.440)*r( 65)
     &                +( 0.400)*r( 87)+         r( 88)+( 0.400)*r( 89)
     &                +         r( 90)+( 0.200)*r(103)+( 0.190)*r(111)
     &                +( 0.700)*r(133)+( 0.160)*r(135)+( 0.334)*r(138)
     &                +( 0.500)*r(141)+( 0.120)*r(145)+( 0.266)*r(149)
     &                +( 0.461)*r(152)+( 0.933)*r(155)+         r(156)
        Gain(lOH   ) = Gain(lOH   )
     &                +( 1.125)*r(159)+( 0.125)*r(160)+( 0.100)*r(161)
     &                +( 0.125)*r(162)+( 0.570)*r(165)+( 0.118)*r(167)
     &                +( 0.100)*r(172)+( 0.244)*r(177)+( 0.500)*r(191)
     &                +( 0.500)*r(195)+( 0.440)*r(202)+         r(210)
c
        Loss(lHO2  )= +         r( 13)+         r( 15)+         r( 18)
     &                +( 2.000)*r( 19)+( 2.000)*r( 20)+         r( 25)
     &                +         r( 33)+         r( 48)+         r( 57)
     &                +         r( 65)+         r( 69)+         r( 72)
     &                +         r( 76)+         r( 80)+         r( 84)
     &                +         r(100)+         r(103)+         r(145)
     &                +         r(159)+         r(170)+         r(175)
     &                +         r(179)+         r(185)+         r(202)
     &                +         r(214)
c
        Gain(lHO2  )= +         r( 12)+         r( 14)+         r( 22)
     &                +         r( 23)+         r( 32)+         r( 49)
     &                +( 0.590)*r( 50)+         r( 52)+         r( 69)
     &                +         r( 71)+( 0.900)*r( 73)+( 0.370)*r( 74)
     &                +         r( 75)+( 0.800)*r( 77)+( 0.600)*r( 78)
     &                +( 0.800)*r( 85)+         r( 90)+         r( 93)
     &                +         r( 96)+( 2.000)*r( 97)+         r( 99)
     &                +         r(101)+         r(102)+( 0.200)*r(103)
     &                +         r(106)+         r(109)+( 0.200)*r(110)
        Gain(lHO2  ) = Gain(lHO2  )
     &                +( 1.400)*r(111)+         r(113)+( 2.000)*r(114)
     &                +         r(115)+         r(116)+         r(119)
     &                +         r(120)+         r(123)+( 0.900)*r(124)
     &                +         r(131)+( 0.300)*r(133)+( 0.160)*r(135)
     &                +( 0.080)*r(138)+( 0.818)*r(144)+( 0.120)*r(145)
     &                +( 0.728)*r(146)+( 0.728)*r(147)+         r(148)
     &                +( 0.066)*r(149)+( 0.137)*r(151)+( 0.398)*r(152)
     &                +( 0.760)*r(154)+( 0.825)*r(159)+( 0.825)*r(160)
        Gain(lHO2  ) = Gain(lHO2  )
     &                +( 0.660)*r(161)+( 0.825)*r(162)+( 0.530)*r(167)
     &                +( 0.918)*r(168)+         r(169)+         r(171)
     &                +( 0.180)*r(172)+( 0.860)*r(173)+         r(174)
     &                +         r(176)+( 0.155)*r(177)+( 0.860)*r(178)
     &                +         r(180)+         r(181)+         r(182)
     &                +         r(188)+( 0.700)*r(189)+         r(193)
     &                +( 0.560)*r(195)+( 0.200)*r(197)+( 0.800)*r(199)
c
        Loss(lHONO )= +( 2.000)*r( 42)+         r( 43)+         r( 44)
c
        Gain(lHONO )= +         r( 40)+( 2.000)*r( 41)+         r(188)
c
        Loss(lPNA  )= +         r( 49)+         r( 50)+         r( 51)
c
        Gain(lPNA  )= +         r( 48)
c
        Loss(lPAN  )= +         r( 55)+         r( 56)
c
        Gain(lPAN  )= +         r( 54)
c
        Loss(lC2O3 )= +         r( 53)+         r( 54)+         r( 57)
     &                +         r( 58)+( 2.000)*r( 59)+         r( 60)
     &                +         r( 73)+         r( 77)+         r( 81)
     &                +         r( 85)+         r(146)+         r(161)
     &                +         r(169)+         r(174)+         r(180)
     &                +         r(203)
c
        Gain(lC2O3 )= +         r( 55)+( 0.600)*r( 56)+         r( 58)
     &                +         r( 95)+         r(104)+         r(105)
     &                +( 0.800)*r(110)+         r(112)+         r(116)
     &                +         r(117)+         r(118)+( 0.500)*r(125)
     &                +( 0.620)*r(126)+         r(127)+( 0.269)*r(151)
     &                +( 0.143)*r(152)+( 0.208)*r(154)+( 0.300)*r(189)
     &                +( 0.600)*r(191)+( 0.120)*r(195)
c
        Loss(lNO3  )= +         r( 27)+         r( 28)+         r( 29)
     &                +         r( 30)+         r( 31)+         r( 32)
     &                +         r( 33)+         r( 34)+( 2.000)*r( 35)
     &                +         r( 36)+         r( 99)+         r(105)
     &                +         r(108)+         r(112)+         r(115)
     &                +         r(117)+         r(136)+         r(139)
     &                +         r(142)+         r(150)+         r(153)
     &                +         r(157)+         r(166)+         r(183)
     &                +         r(187)+         r(192)+         r(196)
        Loss(lNO3  ) = Loss(lNO3  )
     &                +         r(198)+         r(233)
c
        Gain(lNO3  )= +         r(  6)+         r( 26)+         r( 37)
     &                +         r( 38)+         r( 46)+( 0.410)*r( 50)
     &                +( 0.400)*r( 56)+( 0.400)*r( 64)+( 0.185)*r(163)
     &                +         r(223)
c
        Loss(lN2O5 )= +         r( 37)+         r( 38)+         r( 39)
c
        Gain(lN2O5 )= +         r( 36)
c
        Loss(lI    )= +         r(211)
c
        Gain(lI    )= +( 2.000)*r(209)+         r(210)+         r(212)
     &                +( 0.400)*r(213)+         r(215)+         r(217)
     &                +         r(221)+         r(223)
c
        Loss(lIO   )= +         r(212)+( 2.000)*r(213)+         r(214)
     &                +         r(215)+         r(216)+         r(219)
c
        Gain(lIO   )= +         r(211)+         r(220)
c
        Loss(lOIO  )= +         r(217)+         r(218)+         r(219)
     &                +         r(220)
c
        Gain(lOIO  )= +( 0.400)*r(213)+         r(221)
c
c
      return
      end

