      subroutine ebirxn5(ny,nr,yh,H2O,M,O2,CH4,H2,rk,r)
      implicit none
c
c----CAMx v7Beta6 190902
c
c     EBIRXN5 computes reaction rates for the EBI solver
c
c     Copyright 1996 - 2018
c     Ramboll
c     Created by the CMC version 5.2.6
c
c --- Subroutines Called:
c        none
c
c --- Called by:
c        EBISOLV
c
c --- Argument definitions:
c        ny  - dimension of y
c        nr  - dimension of r and rk
c        yh  - current y (ppm)
c        H2O - water vapor Concentration (ppm)
c        M   - total gas Concentration (ppm)
c        O2  - oxygen Concentration (ppm)
c        CH4 - methane Concentration (ppm)
c        H2  - hydrogen Concentration (ppm)
c        rk  - rate constants (units ppm hr)
c        r   - reaction rates (hr-1)
c
c --- Includes:
      include "camx.prm"
      include "chmdat.inc"
      include "ddmchm.inc"
c
c --- Arguments:
      integer ny, nr
      real    yh(ny+1)
      real    r(nr), rk(nr)
      real    H2O,M,O2,CH4,H2
c
c --- Local variables:
      real    N2
c
c --- Entry point
c
      N2  = M - O2
c
c --- Calculate reaction rates
c
      r(  1) = rk(  1)*yh(lNO2)
      r(  2) = rk(  2)*yh(lO3P)*O2*M
      r(  3) = rk(  3)*yh(lO3P)*yh(lO3)
      r(  4) = rk(  4)*yh(lO3P)*yh(lNO)
      r(  5) = rk(  5)*yh(lO3P)*yh(lNO2)
      r(  6) = rk(  6)*yh(lO3P)*yh(lNO2)
      r(  7) = rk(  7)*yh(lO3)*yh(lNO)
      r(  8) = rk(  8)*yh(lO3)*yh(lNO2)
      r(  9) = rk(  9)*yh(lNO)*yh(lNO3)
      r( 10) = rk( 10)*yh(lNO)*yh(lNO)*O2
      r( 11) = rk( 11)*yh(lNO2)*yh(lNO3)
      r( 12) = rk( 12)*yh(lN2O5)
      r( 13) = rk( 13)*yh(lN2O5)*H2O
      r( 14) = rk( 14)*yh(lN2O5)*H2O*H2O
      r( 15) = rk( 15)*yh(lNO2)*yh(lNO3)
      r( 16) = rk( 16)*yh(lNO3)
      r( 17) = rk( 17)*yh(lNO3)
      r( 18) = rk( 18)*yh(lO3)
      r( 19) = rk( 19)*yh(lO3)
      r( 20) = rk( 20)*yh(lO1D)*H2O
      r( 21) = rk( 21)*yh(lO1D)*M
      r( 22) = rk( 22)*yh(lOH)*yh(lNO)
      r( 23) = rk( 23)*yh(lHONO)
      r( 24) = rk( 24)*yh(lOH)*yh(lHONO)
      r( 25) = rk( 25)*yh(lOH)*yh(lNO2)
      r( 26) = rk( 26)*yh(lOH)*yh(lNO3)
      r( 27) = rk( 27)*yh(lOH)*yh(lHNO3)
      r( 28) = rk( 28)*yh(lHNO3)
      r( 29) = rk( 29)*yh(lOH)*yh(lCO)
      r( 30) = rk( 30)*yh(lOH)*yh(lO3)
      r( 31) = rk( 31)*yh(lHO2)*yh(lNO)
      r( 32) = rk( 32)*yh(lHO2)*yh(lNO2)
      r( 33) = rk( 33)*yh(lPNA)
      r( 34) = rk( 34)*yh(lPNA)
      r( 35) = rk( 35)*yh(lPNA)*yh(lOH)
      r( 36) = rk( 36)*yh(lHO2)*yh(lO3)
      r( 37) = rk( 37)*yh(lHO2)*yh(lHO2)
      r( 38) = rk( 38)*yh(lHO2)*yh(lHO2)*H2O
      r( 39) = rk( 39)*yh(lNO3)*yh(lHO2)
      r( 40) = rk( 40)*yh(lNO3)*yh(lNO3)
      r( 41) = rk( 41)*yh(lH2O2)
      r( 42) = rk( 42)*yh(lH2O2)*yh(lOH)
      r( 43) = rk( 43)*yh(lOH)*yh(lHO2)
      r( 44) = rk( 44)*yh(lOH)*yh(lSO2)
      r( 45) = rk( 45)*yh(lOH)*H2
      r( 46) = rk( 46)*yh(lMEO2)*yh(lNO)
      r( 47) = rk( 47)*yh(lMEO2)*yh(lHO2)
      r( 48) = rk( 48)*yh(lMEO2)*yh(lHO2)
      r( 49) = rk( 49)*yh(lMEO2)*yh(lNO3)
      r( 50) = rk( 50)*yh(lMEO2)*yh(lMEO2)
      r( 51) = rk( 51)*yh(lMEO2)*yh(lMEO2)
      r( 52) = rk( 52)*yh(lRO2C)*yh(lNO)
      r( 53) = rk( 53)*yh(lRO2C)*yh(lHO2)
      r( 54) = rk( 54)*yh(lRO2C)*yh(lNO3)
      r( 55) = rk( 55)*yh(lRO2C)*yh(lMEO2)
      r( 56) = rk( 56)*yh(lRO2C)*yh(lRO2C)
      r( 57) = rk( 57)*yh(lRO2X)*yh(lNO)
      r( 58) = rk( 58)*yh(lRO2X)*yh(lHO2)
      r( 59) = rk( 59)*yh(lRO2X)*yh(lNO3)
      r( 60) = rk( 60)*yh(lRO2X)*yh(lMEO2)
      r( 61) = rk( 61)*yh(lRO2X)*yh(lRO2C)
      r( 62) = rk( 62)*yh(lRO2X)*yh(lRO2X)
      r( 63) = rk( 63)*yh(lMCO3)*yh(lNO2)
      r( 64) = rk( 64)*yh(lPAN)
      r( 65) = rk( 65)*yh(lPAN)
      r( 66) = rk( 66)*yh(lMCO3)*yh(lNO)
      r( 67) = rk( 67)*yh(lMCO3)*yh(lHO2)
      r( 68) = rk( 68)*yh(lMCO3)*yh(lNO3)
      r( 69) = rk( 69)*yh(lMCO3)*yh(lMEO2)
      r( 70) = rk( 70)*yh(lMCO3)*yh(lRO2C)
      r( 71) = rk( 71)*yh(lMCO3)*yh(lRO2X)
      r( 72) = rk( 72)*yh(lMCO3)*yh(lMCO3)
      r( 73) = rk( 73)*yh(lRCO3)*yh(lNO2)
      r( 74) = rk( 74)*yh(lPAN2)
      r( 75) = rk( 75)*yh(lPAN2)
      r( 76) = rk( 76)*yh(lRCO3)*yh(lNO)
      r( 77) = rk( 77)*yh(lRCO3)*yh(lHO2)
      r( 78) = rk( 78)*yh(lRCO3)*yh(lNO3)
      r( 79) = rk( 79)*yh(lRCO3)*yh(lMEO2)
      r( 80) = rk( 80)*yh(lRCO3)*yh(lRO2C)
      r( 81) = rk( 81)*yh(lRCO3)*yh(lRO2X)
      r( 82) = rk( 82)*yh(lRCO3)*yh(lMCO3)
      r( 83) = rk( 83)*yh(lRCO3)*yh(lRCO3)
      r( 84) = rk( 84)*yh(lBZC3)*yh(lNO2)
      r( 85) = rk( 85)*yh(lPBZN)
      r( 86) = rk( 86)*yh(lPBZN)
      r( 87) = rk( 87)*yh(lBZC3)*yh(lNO)
      r( 88) = rk( 88)*yh(lBZC3)*yh(lHO2)
      r( 89) = rk( 89)*yh(lBZC3)*yh(lNO3)
      r( 90) = rk( 90)*yh(lBZC3)*yh(lMEO2)
      r( 91) = rk( 91)*yh(lBZC3)*yh(lRO2C)
      r( 92) = rk( 92)*yh(lBZC3)*yh(lRO2X)
      r( 93) = rk( 93)*yh(lBZC3)*yh(lMCO3)
      r( 94) = rk( 94)*yh(lBZC3)*yh(lRCO3)
      r( 95) = rk( 95)*yh(lBZC3)*yh(lBZC3)
      r( 96) = rk( 96)*yh(lMAC3)*yh(lNO2)
      r( 97) = rk( 97)*yh(lMPAN)
      r( 98) = rk( 98)*yh(lMPAN)
      r( 99) = rk( 99)*yh(lMAC3)*yh(lNO)
      r(100) = rk(100)*yh(lMAC3)*yh(lHO2)
      r(101) = rk(101)*yh(lMAC3)*yh(lNO3)
      r(102) = rk(102)*yh(lMAC3)*yh(lMEO2)
      r(103) = rk(103)*yh(lMAC3)*yh(lRO2C)
      r(104) = rk(104)*yh(lMAC3)*yh(lRO2X)
      r(105) = rk(105)*yh(lMAC3)*yh(lMCO3)
      r(106) = rk(106)*yh(lMAC3)*yh(lRCO3)
      r(107) = rk(107)*yh(lMAC3)*yh(lBZC3)
      r(108) = rk(108)*yh(lMAC3)*yh(lMAC3)
      r(109) = rk(109)*yh(lTBUO)*yh(lNO2)
      r(110) = rk(110)*yh(lTBUO)
      r(111) = rk(111)*yh(lBZO)*yh(lNO2)
      r(112) = rk(112)*yh(lBZO)*yh(lHO2)
      r(113) = rk(113)*yh(lBZO)
      r(114) = rk(114)*yh(lXHO2)*yh(lNO)
      r(115) = rk(115)*yh(lXHO2)*yh(lHO2)
      r(116) = rk(116)*yh(lXHO2)*yh(lNO3)
      r(117) = rk(117)*yh(lXHO2)*yh(lMEO2)
      r(118) = rk(118)*yh(lXHO2)*yh(lRO2C)
      r(119) = rk(119)*yh(lXHO2)*yh(lRO2X)
      r(120) = rk(120)*yh(lXHO2)*yh(lMCO3)
      r(121) = rk(121)*yh(lXHO2)*yh(lRCO3)
      r(122) = rk(122)*yh(lXHO2)*yh(lBZC3)
      r(123) = rk(123)*yh(lXHO2)*yh(lMAC3)
      r(124) = rk(124)*yh(lXOH)*yh(lNO)
      r(125) = rk(125)*yh(lXOH)*yh(lHO2)
      r(126) = rk(126)*yh(lXOH)*yh(lNO3)
      r(127) = rk(127)*yh(lXOH)*yh(lMEO2)
      r(128) = rk(128)*yh(lXOH)*yh(lRO2C)
      r(129) = rk(129)*yh(lXOH)*yh(lRO2X)
      r(130) = rk(130)*yh(lXOH)*yh(lMCO3)
      r(131) = rk(131)*yh(lXOH)*yh(lRCO3)
      r(132) = rk(132)*yh(lXOH)*yh(lBZC3)
      r(133) = rk(133)*yh(lXOH)*yh(lMAC3)
      r(134) = rk(134)*yh(lXNO2)*yh(lNO)
      r(135) = rk(135)*yh(lXNO2)*yh(lHO2)
      r(136) = rk(136)*yh(lXNO2)*yh(lNO3)
      r(137) = rk(137)*yh(lXNO2)*yh(lMEO2)
      r(138) = rk(138)*yh(lXNO2)*yh(lRO2C)
      r(139) = rk(139)*yh(lXNO2)*yh(lRO2X)
      r(140) = rk(140)*yh(lXNO2)*yh(lMCO3)
      r(141) = rk(141)*yh(lXNO2)*yh(lRCO3)
      r(142) = rk(142)*yh(lXNO2)*yh(lBZC3)
      r(143) = rk(143)*yh(lXNO2)*yh(lMAC3)
      r(144) = rk(144)*yh(lXMEO)*yh(lNO)
      r(145) = rk(145)*yh(lXMEO)*yh(lHO2)
      r(146) = rk(146)*yh(lXMEO)*yh(lNO3)
      r(147) = rk(147)*yh(lXMEO)*yh(lMEO2)
      r(148) = rk(148)*yh(lXMEO)*yh(lRO2C)
      r(149) = rk(149)*yh(lXMEO)*yh(lRO2X)
      r(150) = rk(150)*yh(lXMEO)*yh(lMCO3)
      r(151) = rk(151)*yh(lXMEO)*yh(lRCO3)
      r(152) = rk(152)*yh(lXMEO)*yh(lBZC3)
      r(153) = rk(153)*yh(lXMEO)*yh(lMAC3)
      r(154) = rk(154)*yh(lXMC3)*yh(lNO)
      r(155) = rk(155)*yh(lXMC3)*yh(lHO2)
      r(156) = rk(156)*yh(lXMC3)*yh(lNO3)
      r(157) = rk(157)*yh(lXMC3)*yh(lMEO2)
      r(158) = rk(158)*yh(lXMC3)*yh(lRO2C)
      r(159) = rk(159)*yh(lXMC3)*yh(lRO2X)
      r(160) = rk(160)*yh(lXMC3)*yh(lMCO3)
      r(161) = rk(161)*yh(lXMC3)*yh(lRCO3)
      r(162) = rk(162)*yh(lXMC3)*yh(lBZC3)
      r(163) = rk(163)*yh(lXMC3)*yh(lMAC3)
      r(164) = rk(164)*yh(lXRC3)*yh(lNO)
      r(165) = rk(165)*yh(lXRC3)*yh(lHO2)
      r(166) = rk(166)*yh(lXRC3)*yh(lNO3)
      r(167) = rk(167)*yh(lXRC3)*yh(lMEO2)
      r(168) = rk(168)*yh(lXRC3)*yh(lRO2C)
      r(169) = rk(169)*yh(lXRC3)*yh(lRO2X)
      r(170) = rk(170)*yh(lXRC3)*yh(lMCO3)
      r(171) = rk(171)*yh(lXRC3)*yh(lRCO3)
      r(172) = rk(172)*yh(lXRC3)*yh(lBZC3)
      r(173) = rk(173)*yh(lXRC3)*yh(lMAC3)
      r(174) = rk(174)*yh(lXMA3)*yh(lNO)
      r(175) = rk(175)*yh(lXMA3)*yh(lHO2)
      r(176) = rk(176)*yh(lXMA3)*yh(lNO3)
      r(177) = rk(177)*yh(lXMA3)*yh(lMEO2)
      r(178) = rk(178)*yh(lXMA3)*yh(lRO2C)
      r(179) = rk(179)*yh(lXMA3)*yh(lRO2X)
      r(180) = rk(180)*yh(lXMA3)*yh(lMCO3)
      r(181) = rk(181)*yh(lXMA3)*yh(lRCO3)
      r(182) = rk(182)*yh(lXMA3)*yh(lBZC3)
      r(183) = rk(183)*yh(lXMA3)*yh(lMAC3)
      r(184) = rk(184)*yh(lXTBU)*yh(lNO)
      r(185) = rk(185)*yh(lXTBU)*yh(lHO2)
      r(186) = rk(186)*yh(lXTBU)*yh(lNO3)
      r(187) = rk(187)*yh(lXTBU)*yh(lMEO2)
      r(188) = rk(188)*yh(lXTBU)*yh(lRO2C)
      r(189) = rk(189)*yh(lXTBU)*yh(lRO2X)
      r(190) = rk(190)*yh(lXTBU)*yh(lMCO3)
      r(191) = rk(191)*yh(lXTBU)*yh(lRCO3)
      r(192) = rk(192)*yh(lXTBU)*yh(lBZC3)
      r(193) = rk(193)*yh(lXTBU)*yh(lMAC3)
      r(194) = rk(194)*yh(lXCO)*yh(lNO)
      r(195) = rk(195)*yh(lXCO)*yh(lHO2)
      r(196) = rk(196)*yh(lXCO)*yh(lNO3)
      r(197) = rk(197)*yh(lXCO)*yh(lMEO2)
      r(198) = rk(198)*yh(lXCO)*yh(lRO2C)
      r(199) = rk(199)*yh(lXCO)*yh(lRO2X)
      r(200) = rk(200)*yh(lXCO)*yh(lMCO3)
      r(201) = rk(201)*yh(lXCO)*yh(lRCO3)
      r(202) = rk(202)*yh(lXCO)*yh(lBZC3)
      r(203) = rk(203)*yh(lXCO)*yh(lMAC3)
      r(204) = rk(204)*yh(lHCHO)
      r(205) = rk(205)*yh(lHCHO)
      r(206) = rk(206)*yh(lHCHO)*yh(lOH)
      r(207) = rk(207)*yh(lHCHO)*yh(lNO3)
      r(208) = rk(208)*yh(lCCHO)*yh(lOH)
      r(209) = rk(209)*yh(lCCHO)
      r(210) = rk(210)*yh(lCCHO)*yh(lNO3)
      r(211) = rk(211)*yh(lRCHO)*yh(lOH)
      r(212) = rk(212)*yh(lRCHO)
      r(213) = rk(213)*yh(lRCHO)*yh(lNO3)
      r(214) = rk(214)*yh(lACET)*yh(lOH)
      r(215) = rk(215)*yh(lACET)
      r(216) = rk(216)*yh(lMEK)*yh(lOH)
      r(217) = rk(217)*yh(lMEK)
      r(218) = rk(218)*yh(lMEOH)*yh(lOH)
      r(219) = rk(219)*yh(lFACD)*yh(lOH)
      r(220) = rk(220)*yh(lAACD)*yh(lOH)
      r(221) = rk(221)*yh(lPACD)*yh(lOH)
      r(222) = rk(222)*yh(lCOOH)*yh(lOH)
      r(223) = rk(223)*yh(lCOOH)
      r(224) = rk(224)*yh(lROOH)*yh(lOH)
      r(225) = rk(225)*yh(lROOH)
      r(226) = rk(226)*yh(lR6PX)*yh(lOH)
      r(227) = rk(227)*yh(lR6PX)
      r(228) = rk(228)*yh(lRAPX)*yh(lOH)
      r(229) = rk(229)*yh(lRAPX)
      r(230) = rk(230)*yh(lGLY)
      r(231) = rk(231)*yh(lGLY)
      r(232) = rk(232)*yh(lGLY)*yh(lOH)
      r(233) = rk(233)*yh(lGLY)*yh(lNO3)
      r(234) = rk(234)*yh(lMGLY)
      r(235) = rk(235)*yh(lMGLY)*yh(lOH)
      r(236) = rk(236)*yh(lMGLY)*yh(lNO3)
      r(237) = rk(237)*yh(lBACL)
      r(238) = rk(238)*yh(lCRES)*yh(lOH)
      r(239) = rk(239)*yh(lCRES)*yh(lNO3)
      r(240) = rk(240)*yh(lNPHE)*yh(lOH)
      r(241) = rk(241)*yh(lNPHE)
      r(242) = rk(242)*yh(lNPHE)
      r(243) = rk(243)*yh(lBALD)*yh(lOH)
      r(244) = rk(244)*yh(lBALD)
      r(245) = rk(245)*yh(lBALD)*yh(lNO3)
      r(246) = rk(246)*yh(lAFG1)*yh(lOH)
      r(247) = rk(247)*yh(lAFG1)*yh(lO3)
      r(248) = rk(248)*yh(lAFG1)
      r(249) = rk(249)*yh(lAFG2)*yh(lOH)
      r(250) = rk(250)*yh(lAFG2)*yh(lO3)
      r(251) = rk(251)*yh(lAFG2)
      r(252) = rk(252)*yh(lAFG3)*yh(lOH)
      r(253) = rk(253)*yh(lAFG3)*yh(lO3)
      r(254) = rk(254)*yh(lMACR)*yh(lOH)
      r(255) = rk(255)*yh(lMACR)*yh(lO3)
      r(256) = rk(256)*yh(lMACR)*yh(lNO3)
      r(257) = rk(257)*yh(lMACR)*yh(lO3P)
      r(258) = rk(258)*yh(lMACR)
      r(259) = rk(259)*yh(lMVK)*yh(lOH)
      r(260) = rk(260)*yh(lMVK)*yh(lO3)
      r(261) = rk(261)*yh(lMVK)*yh(lO3P)
      r(262) = rk(262)*yh(lMVK)
      r(263) = rk(263)*yh(lIPRD)*yh(lOH)
      r(264) = rk(264)*yh(lIPRD)*yh(lO3)
      r(265) = rk(265)*yh(lIPRD)*yh(lNO3)
      r(266) = rk(266)*yh(lIPRD)
      r(267) = rk(267)*yh(lPRD2)*yh(lOH)
      r(268) = rk(268)*yh(lPRD2)
      r(269) = rk(269)*yh(lRNO3)*yh(lOH)
      r(270) = rk(270)*yh(lRNO3)
      r(271) = rk(271)*yh(lGLYD)*yh(lOH)
      r(272) = rk(272)*yh(lGLYD)
      r(273) = rk(273)*yh(lGLYD)*yh(lNO3)
      r(274) = rk(274)*yh(lACRO)*yh(lOH)
      r(275) = rk(275)*yh(lACRO)*yh(lO3)
      r(276) = rk(276)*yh(lACRO)*yh(lNO3)
      r(277) = rk(277)*yh(lACRO)*yh(lO3P)
      r(278) = rk(278)*yh(lACRO)
      r(279) = rk(279)*yh(lCO3H)*yh(lOH)
      r(280) = rk(280)*yh(lCO3H)
      r(281) = rk(281)*yh(lRO3H)*yh(lOH)
      r(282) = rk(282)*yh(lRO3H)
      r(283) = rk(283)*yh(lXHCH)*yh(lNO)
      r(284) = rk(284)*yh(lXHCH)*yh(lHO2)
      r(285) = rk(285)*yh(lXHCH)*yh(lNO3)
      r(286) = rk(286)*yh(lXHCH)*yh(lMEO2)
      r(287) = rk(287)*yh(lXHCH)*yh(lRO2C)
      r(288) = rk(288)*yh(lXHCH)*yh(lRO2X)
      r(289) = rk(289)*yh(lXHCH)*yh(lMCO3)
      r(290) = rk(290)*yh(lXHCH)*yh(lRCO3)
      r(291) = rk(291)*yh(lXHCH)*yh(lBZC3)
      r(292) = rk(292)*yh(lXHCH)*yh(lMAC3)
      r(293) = rk(293)*yh(lXCCH)*yh(lNO)
      r(294) = rk(294)*yh(lXCCH)*yh(lHO2)
      r(295) = rk(295)*yh(lXCCH)*yh(lNO3)
      r(296) = rk(296)*yh(lXCCH)*yh(lMEO2)
      r(297) = rk(297)*yh(lXCCH)*yh(lRO2C)
      r(298) = rk(298)*yh(lXCCH)*yh(lRO2X)
      r(299) = rk(299)*yh(lXCCH)*yh(lMCO3)
      r(300) = rk(300)*yh(lXCCH)*yh(lRCO3)
      r(301) = rk(301)*yh(lXCCH)*yh(lBZC3)
      r(302) = rk(302)*yh(lXCCH)*yh(lMAC3)
      r(303) = rk(303)*yh(lXRCH)*yh(lNO)
      r(304) = rk(304)*yh(lXRCH)*yh(lHO2)
      r(305) = rk(305)*yh(lXRCH)*yh(lNO3)
      r(306) = rk(306)*yh(lXRCH)*yh(lMEO2)
      r(307) = rk(307)*yh(lXRCH)*yh(lRO2C)
      r(308) = rk(308)*yh(lXRCH)*yh(lRO2X)
      r(309) = rk(309)*yh(lXRCH)*yh(lMCO3)
      r(310) = rk(310)*yh(lXRCH)*yh(lRCO3)
      r(311) = rk(311)*yh(lXRCH)*yh(lBZC3)
      r(312) = rk(312)*yh(lXRCH)*yh(lMAC3)
      r(313) = rk(313)*yh(lXACE)*yh(lNO)
      r(314) = rk(314)*yh(lXACE)*yh(lHO2)
      r(315) = rk(315)*yh(lXACE)*yh(lNO3)
      r(316) = rk(316)*yh(lXACE)*yh(lMEO2)
      r(317) = rk(317)*yh(lXACE)*yh(lRO2C)
      r(318) = rk(318)*yh(lXACE)*yh(lRO2X)
      r(319) = rk(319)*yh(lXACE)*yh(lMCO3)
      r(320) = rk(320)*yh(lXACE)*yh(lRCO3)
      r(321) = rk(321)*yh(lXACE)*yh(lBZC3)
      r(322) = rk(322)*yh(lXACE)*yh(lMAC3)
      r(323) = rk(323)*yh(lXMEK)*yh(lNO)
      r(324) = rk(324)*yh(lXMEK)*yh(lHO2)
      r(325) = rk(325)*yh(lXMEK)*yh(lNO3)
      r(326) = rk(326)*yh(lXMEK)*yh(lMEO2)
      r(327) = rk(327)*yh(lXMEK)*yh(lRO2C)
      r(328) = rk(328)*yh(lXMEK)*yh(lRO2X)
      r(329) = rk(329)*yh(lXMEK)*yh(lMCO3)
      r(330) = rk(330)*yh(lXMEK)*yh(lRCO3)
      r(331) = rk(331)*yh(lXMEK)*yh(lBZC3)
      r(332) = rk(332)*yh(lXMEK)*yh(lMAC3)
      r(333) = rk(333)*yh(lXPD2)*yh(lNO)
      r(334) = rk(334)*yh(lXPD2)*yh(lHO2)
      r(335) = rk(335)*yh(lXPD2)*yh(lNO3)
      r(336) = rk(336)*yh(lXPD2)*yh(lMEO2)
      r(337) = rk(337)*yh(lXPD2)*yh(lRO2C)
      r(338) = rk(338)*yh(lXPD2)*yh(lRO2X)
      r(339) = rk(339)*yh(lXPD2)*yh(lMCO3)
      r(340) = rk(340)*yh(lXPD2)*yh(lRCO3)
      r(341) = rk(341)*yh(lXPD2)*yh(lBZC3)
      r(342) = rk(342)*yh(lXPD2)*yh(lMAC3)
      r(343) = rk(343)*yh(lXGLY)*yh(lNO)
      r(344) = rk(344)*yh(lXGLY)*yh(lHO2)
      r(345) = rk(345)*yh(lXGLY)*yh(lNO3)
      r(346) = rk(346)*yh(lXGLY)*yh(lMEO2)
      r(347) = rk(347)*yh(lXGLY)*yh(lRO2C)
      r(348) = rk(348)*yh(lXGLY)*yh(lRO2X)
      r(349) = rk(349)*yh(lXGLY)*yh(lMCO3)
      r(350) = rk(350)*yh(lXGLY)*yh(lRCO3)
      r(351) = rk(351)*yh(lXGLY)*yh(lBZC3)
      r(352) = rk(352)*yh(lXGLY)*yh(lMAC3)
      r(353) = rk(353)*yh(lXMGL)*yh(lNO)
      r(354) = rk(354)*yh(lXMGL)*yh(lHO2)
      r(355) = rk(355)*yh(lXMGL)*yh(lNO3)
      r(356) = rk(356)*yh(lXMGL)*yh(lMEO2)
      r(357) = rk(357)*yh(lXMGL)*yh(lRO2C)
      r(358) = rk(358)*yh(lXMGL)*yh(lRO2X)
      r(359) = rk(359)*yh(lXMGL)*yh(lMCO3)
      r(360) = rk(360)*yh(lXMGL)*yh(lRCO3)
      r(361) = rk(361)*yh(lXMGL)*yh(lBZC3)
      r(362) = rk(362)*yh(lXMGL)*yh(lMAC3)
      r(363) = rk(363)*yh(lXBAC)*yh(lNO)
      r(364) = rk(364)*yh(lXBAC)*yh(lHO2)
      r(365) = rk(365)*yh(lXBAC)*yh(lNO3)
      r(366) = rk(366)*yh(lXBAC)*yh(lMEO2)
      r(367) = rk(367)*yh(lXBAC)*yh(lRO2C)
      r(368) = rk(368)*yh(lXBAC)*yh(lRO2X)
      r(369) = rk(369)*yh(lXBAC)*yh(lMCO3)
      r(370) = rk(370)*yh(lXBAC)*yh(lRCO3)
      r(371) = rk(371)*yh(lXBAC)*yh(lBZC3)
      r(372) = rk(372)*yh(lXBAC)*yh(lMAC3)
      r(373) = rk(373)*yh(lXBAL)*yh(lNO)
      r(374) = rk(374)*yh(lXBAL)*yh(lHO2)
      r(375) = rk(375)*yh(lXBAL)*yh(lNO3)
      r(376) = rk(376)*yh(lXBAL)*yh(lMEO2)
      r(377) = rk(377)*yh(lXBAL)*yh(lRO2C)
      r(378) = rk(378)*yh(lXBAL)*yh(lRO2X)
      r(379) = rk(379)*yh(lXBAL)*yh(lMCO3)
      r(380) = rk(380)*yh(lXBAL)*yh(lRCO3)
      r(381) = rk(381)*yh(lXBAL)*yh(lBZC3)
      r(382) = rk(382)*yh(lXBAL)*yh(lMAC3)
      r(383) = rk(383)*yh(lXAF1)*yh(lNO)
      r(384) = rk(384)*yh(lXAF1)*yh(lHO2)
      r(385) = rk(385)*yh(lXAF1)*yh(lNO3)
      r(386) = rk(386)*yh(lXAF1)*yh(lMEO2)
      r(387) = rk(387)*yh(lXAF1)*yh(lRO2C)
      r(388) = rk(388)*yh(lXAF1)*yh(lRO2X)
      r(389) = rk(389)*yh(lXAF1)*yh(lMCO3)
      r(390) = rk(390)*yh(lXAF1)*yh(lRCO3)
      r(391) = rk(391)*yh(lXAF1)*yh(lBZC3)
      r(392) = rk(392)*yh(lXAF1)*yh(lMAC3)
      r(393) = rk(393)*yh(lXAF2)*yh(lNO)
      r(394) = rk(394)*yh(lXAF2)*yh(lHO2)
      r(395) = rk(395)*yh(lXAF2)*yh(lNO3)
      r(396) = rk(396)*yh(lXAF2)*yh(lMEO2)
      r(397) = rk(397)*yh(lXAF2)*yh(lRO2C)
      r(398) = rk(398)*yh(lXAF2)*yh(lRO2X)
      r(399) = rk(399)*yh(lXAF2)*yh(lMCO3)
      r(400) = rk(400)*yh(lXAF2)*yh(lRCO3)
      r(401) = rk(401)*yh(lXAF2)*yh(lBZC3)
      r(402) = rk(402)*yh(lXAF2)*yh(lMAC3)
      r(403) = rk(403)*yh(lXAF3)*yh(lNO)
      r(404) = rk(404)*yh(lXAF3)*yh(lHO2)
      r(405) = rk(405)*yh(lXAF3)*yh(lNO3)
      r(406) = rk(406)*yh(lXAF3)*yh(lMEO2)
      r(407) = rk(407)*yh(lXAF3)*yh(lRO2C)
      r(408) = rk(408)*yh(lXAF3)*yh(lRO2X)
      r(409) = rk(409)*yh(lXAF3)*yh(lMCO3)
      r(410) = rk(410)*yh(lXAF3)*yh(lRCO3)
      r(411) = rk(411)*yh(lXAF3)*yh(lBZC3)
      r(412) = rk(412)*yh(lXAF3)*yh(lMAC3)
      r(413) = rk(413)*yh(lXMAC)*yh(lNO)
      r(414) = rk(414)*yh(lXMAC)*yh(lHO2)
      r(415) = rk(415)*yh(lXMAC)*yh(lNO3)
      r(416) = rk(416)*yh(lXMAC)*yh(lMEO2)
      r(417) = rk(417)*yh(lXMAC)*yh(lRO2C)
      r(418) = rk(418)*yh(lXMAC)*yh(lRO2X)
      r(419) = rk(419)*yh(lXMAC)*yh(lMCO3)
      r(420) = rk(420)*yh(lXMAC)*yh(lRCO3)
      r(421) = rk(421)*yh(lXMAC)*yh(lBZC3)
      r(422) = rk(422)*yh(lXMAC)*yh(lMAC3)
      r(423) = rk(423)*yh(lXMVK)*yh(lNO)
      r(424) = rk(424)*yh(lXMVK)*yh(lHO2)
      r(425) = rk(425)*yh(lXMVK)*yh(lNO3)
      r(426) = rk(426)*yh(lXMVK)*yh(lMEO2)
      r(427) = rk(427)*yh(lXMVK)*yh(lRO2C)
      r(428) = rk(428)*yh(lXMVK)*yh(lRO2X)
      r(429) = rk(429)*yh(lXMVK)*yh(lMCO3)
      r(430) = rk(430)*yh(lXMVK)*yh(lRCO3)
      r(431) = rk(431)*yh(lXMVK)*yh(lBZC3)
      r(432) = rk(432)*yh(lXMVK)*yh(lMAC3)
      r(433) = rk(433)*yh(lXIPR)*yh(lNO)
      r(434) = rk(434)*yh(lXIPR)*yh(lHO2)
      r(435) = rk(435)*yh(lXIPR)*yh(lNO3)
      r(436) = rk(436)*yh(lXIPR)*yh(lMEO2)
      r(437) = rk(437)*yh(lXIPR)*yh(lRO2C)
      r(438) = rk(438)*yh(lXIPR)*yh(lRO2X)
      r(439) = rk(439)*yh(lXIPR)*yh(lMCO3)
      r(440) = rk(440)*yh(lXIPR)*yh(lRCO3)
      r(441) = rk(441)*yh(lXIPR)*yh(lBZC3)
      r(442) = rk(442)*yh(lXIPR)*yh(lMAC3)
      r(443) = rk(443)*yh(lXRN3)*yh(lNO)
      r(444) = rk(444)*yh(lXRN3)*yh(lHO2)
      r(445) = rk(445)*yh(lXRN3)*yh(lNO3)
      r(446) = rk(446)*yh(lXRN3)*yh(lMEO2)
      r(447) = rk(447)*yh(lXRN3)*yh(lRO2C)
      r(448) = rk(448)*yh(lXRN3)*yh(lRO2X)
      r(449) = rk(449)*yh(lXRN3)*yh(lMCO3)
      r(450) = rk(450)*yh(lXRN3)*yh(lRCO3)
      r(451) = rk(451)*yh(lXRN3)*yh(lBZC3)
      r(452) = rk(452)*yh(lXRN3)*yh(lMAC3)
      r(453) = rk(453)*yh(lYRPX)*yh(lNO)
      r(454) = rk(454)*yh(lYRPX)*yh(lHO2)
      r(455) = rk(455)*yh(lYRPX)*yh(lNO3)
      r(456) = rk(456)*yh(lYRPX)*yh(lMEO2)
      r(457) = rk(457)*yh(lYRPX)*yh(lRO2C)
      r(458) = rk(458)*yh(lYRPX)*yh(lRO2X)
      r(459) = rk(459)*yh(lYRPX)*yh(lMCO3)
      r(460) = rk(460)*yh(lYRPX)*yh(lRCO3)
      r(461) = rk(461)*yh(lYRPX)*yh(lBZC3)
      r(462) = rk(462)*yh(lYRPX)*yh(lMAC3)
      r(463) = rk(463)*yh(lY6PX)*yh(lNO)
      r(464) = rk(464)*yh(lY6PX)*yh(lHO2)
      r(465) = rk(465)*yh(lY6PX)*yh(lNO3)
      r(466) = rk(466)*yh(lY6PX)*yh(lMEO2)
      r(467) = rk(467)*yh(lY6PX)*yh(lRO2C)
      r(468) = rk(468)*yh(lY6PX)*yh(lRO2X)
      r(469) = rk(469)*yh(lY6PX)*yh(lMCO3)
      r(470) = rk(470)*yh(lY6PX)*yh(lRCO3)
      r(471) = rk(471)*yh(lY6PX)*yh(lBZC3)
      r(472) = rk(472)*yh(lY6PX)*yh(lMAC3)
      r(473) = rk(473)*yh(lYAPX)*yh(lNO)
      r(474) = rk(474)*yh(lYAPX)*yh(lHO2)
      r(475) = rk(475)*yh(lYAPX)*yh(lNO3)
      r(476) = rk(476)*yh(lYAPX)*yh(lMEO2)
      r(477) = rk(477)*yh(lYAPX)*yh(lRO2C)
      r(478) = rk(478)*yh(lYAPX)*yh(lRO2X)
      r(479) = rk(479)*yh(lYAPX)*yh(lMCO3)
      r(480) = rk(480)*yh(lYAPX)*yh(lRCO3)
      r(481) = rk(481)*yh(lYAPX)*yh(lBZC3)
      r(482) = rk(482)*yh(lYAPX)*yh(lMAC3)
      r(483) = rk(483)*yh(lZRN3)*yh(lNO)
      r(484) = rk(484)*yh(lZRN3)*yh(lHO2)
      r(485) = rk(485)*yh(lZRN3)*yh(lNO3)
      r(486) = rk(486)*yh(lZRN3)*yh(lMEO2)
      r(487) = rk(487)*yh(lZRN3)*yh(lRO2C)
      r(488) = rk(488)*yh(lZRN3)*yh(lRO2X)
      r(489) = rk(489)*yh(lZRN3)*yh(lMCO3)
      r(490) = rk(490)*yh(lZRN3)*yh(lRCO3)
      r(491) = rk(491)*yh(lZRN3)*yh(lBZC3)
      r(492) = rk(492)*yh(lZRN3)*yh(lMAC3)
      r(493) = rk(493)*yh(lXGLD)*yh(lNO)
      r(494) = rk(494)*yh(lXGLD)*yh(lHO2)
      r(495) = rk(495)*yh(lXGLD)*yh(lNO3)
      r(496) = rk(496)*yh(lXGLD)*yh(lMEO2)
      r(497) = rk(497)*yh(lXGLD)*yh(lRO2C)
      r(498) = rk(498)*yh(lXGLD)*yh(lRO2X)
      r(499) = rk(499)*yh(lXGLD)*yh(lMCO3)
      r(500) = rk(500)*yh(lXGLD)*yh(lRCO3)
      r(501) = rk(501)*yh(lXGLD)*yh(lBZC3)
      r(502) = rk(502)*yh(lXGLD)*yh(lMAC3)
      r(503) = rk(503)*yh(lXACR)*yh(lNO)
      r(504) = rk(504)*yh(lXACR)*yh(lHO2)
      r(505) = rk(505)*yh(lXACR)*yh(lNO3)
      r(506) = rk(506)*yh(lXACR)*yh(lMEO2)
      r(507) = rk(507)*yh(lXACR)*yh(lRO2C)
      r(508) = rk(508)*yh(lXACR)*yh(lRO2X)
      r(509) = rk(509)*yh(lXACR)*yh(lMCO3)
      r(510) = rk(510)*yh(lXACR)*yh(lRCO3)
      r(511) = rk(511)*yh(lXACR)*yh(lBZC3)
      r(512) = rk(512)*yh(lXACR)*yh(lMAC3)
      r(513) = rk(513)*CH4*yh(lOH)
      r(514) = rk(514)*yh(lETHE)*yh(lOH)
      r(515) = rk(515)*yh(lETHE)*yh(lO3)
      r(516) = rk(516)*yh(lETHE)*yh(lNO3)
      r(517) = rk(517)*yh(lETHE)*yh(lO3P)
      r(518) = rk(518)*yh(lPRPE)*yh(lOH)
      r(519) = rk(519)*yh(lPRPE)*yh(lO3)
      r(520) = rk(520)*yh(lPRPE)*yh(lNO3)
      r(521) = rk(521)*yh(lPRPE)*yh(lO3P)
      r(522) = rk(522)*yh(lBD13)*yh(lOH)
      r(523) = rk(523)*yh(lBD13)*yh(lO3)
      r(524) = rk(524)*yh(lBD13)*yh(lNO3)
      r(525) = rk(525)*yh(lBD13)*yh(lO3P)
      r(526) = rk(526)*yh(lISOP)*yh(lOH)
      r(527) = rk(527)*yh(lISOP)*yh(lO3)
      r(528) = rk(528)*yh(lISOP)*yh(lNO3)
      r(529) = rk(529)*yh(lISOP)*yh(lO3P)
      r(530) = rk(530)*yh(lAPIN)*yh(lOH)
      r(531) = rk(531)*yh(lAPIN)*yh(lO3)
      r(532) = rk(532)*yh(lAPIN)*yh(lNO3)
      r(533) = rk(533)*yh(lAPIN)*yh(lO3P)
      r(534) = rk(534)*yh(lACYE)*yh(lOH)
      r(535) = rk(535)*yh(lACYE)*yh(lO3)
      r(536) = rk(536)*yh(lBENZ)*yh(lOH)
      r(537) = rk(537)*yh(lTOLU)*yh(lOH)
      r(538) = rk(538)*yh(lMXYL)*yh(lOH)
      r(539) = rk(539)*yh(lOXYL)*yh(lOH)
      r(540) = rk(540)*yh(lPXYL)*yh(lOH)
      r(541) = rk(541)*yh(lB124)*yh(lOH)
      r(542) = rk(542)*yh(lETOH)*yh(lOH)
      r(543) = rk(543)*yh(lALK1)*yh(lOH)
      r(544) = rk(544)*yh(lALK2)*yh(lOH)
      r(545) = rk(545)*yh(lALK3)*yh(lOH)
      r(546) = rk(546)*yh(lALK4)*yh(lOH)
      r(547) = rk(547)*yh(lALK5)*yh(lOH)
      r(548) = rk(548)*yh(lOLE1)*yh(lOH)
      r(549) = rk(549)*yh(lOLE1)*yh(lO3)
      r(550) = rk(550)*yh(lOLE1)*yh(lNO3)
      r(551) = rk(551)*yh(lOLE1)*yh(lO3P)
      r(552) = rk(552)*yh(lOLE2)*yh(lOH)
      r(553) = rk(553)*yh(lOLE2)*yh(lO3)
      r(554) = rk(554)*yh(lOLE2)*yh(lNO3)
      r(555) = rk(555)*yh(lOLE2)*yh(lO3P)
      r(556) = rk(556)*yh(lARO1)*yh(lOH)
      r(557) = rk(557)*yh(lARO2)*yh(lOH)
      r(558) = rk(558)*yh(lTERP)*yh(lOH)
      r(559) = rk(559)*yh(lTERP)*yh(lO3)
      r(560) = rk(560)*yh(lTERP)*yh(lNO3)
      r(561) = rk(561)*yh(lTERP)*yh(lO3P)
      r(562) = rk(562)*yh(lSESQ)*yh(lOH)
      r(563) = rk(563)*yh(lSESQ)*yh(lO3)
      r(564) = rk(564)*yh(lSESQ)*yh(lNO3)
      r(565) = rk(565)*yh(lSESQ)*yh(lO3P)
c
      return
      end

