      subroutine hddmjac4(njac,nrxn,H2O,M,O2,CH4,H2,flg,jac,y,rk)
      implicit none
c
c----CAMx v7Beta6 190902
c
c     HDDMJAC4 computes a full Jacobian for HDDM
c
c     Copyright 1996 - 2019
c     Ramboll
c     Created by the CMC version 5.2.6
c
c     Routines Called:
c        none
c
c     Called by:
c        HDDMCHEM
c
      include "camx.prm"
      include "chmdat.inc"
      include "ddmchm.inc"
c
      integer njac, nrxn, i, j
      real H2O, M, O2, CH4, H2, N2, flg
      real jac(njac+1,njac+1), y(njac+1), rk(nrxn)
c
c --- Entry point
c
      N2  = M - O2
c

          JAC(lNO2 ,lNO2 )= +         rk(  1)*flg
     &                      +         rk(  5)    *y(lO)
     &                      +         rk(  6)    *y(lO)
     &                      +         rk( 26)    *y(lO3)
     &                      +         rk( 30)    *y(lNO3)
     &                      +(-1.000)*rk( 30)    *y(lNO3)
     &                      +         rk( 36)    *y(lNO3)
     &                      +         rk( 41)    *y(lNO)*H2O
     &                      +         rk( 45)    *y(lOH)
          JAC(lNO2 ,lNO2 )=JAC(lNO2 ,lNO2 )
     &                      +         rk( 48)    *y(lHO2)
     &                      +         rk( 54)    *y(lC2O3)
     &                      +         rk( 62)    *y(lCXO3)
     &                      +         rk(132)    *y(lROR)
     &                      +         rk(184)    *y(lCRO)
     &                      +         rk(200)    *y(lOPO3)
     &                      +         rk(216)    *y(lIO)
          JAC(lNO2 ,lNO  )= +(-1.000)*rk(  3)    *y(lO3)
     &                      +(-1.000)*rk(  4)    *y(lO)*M
     &                      +(-4.000)*rk( 24)    *y(lNO)*O2
     &                      +(-1.000)*rk( 25)    *y(lHO2)
     &                      +(-2.000)*rk( 29)    *y(lNO3)
     &                      +         rk( 41)    *y(lNO2)*H2O
     &                      +(-1.000)*rk( 53)    *y(lC2O3)
     &                      +(-1.000)*rk( 61)    *y(lCXO3)
     &                      +(-1.000)*rk( 71)    *y(lMEO2)
          JAC(lNO2 ,lNO  )=JAC(lNO2 ,lNO  )
     &                      +(-1.000)*rk( 75)    *y(lXO2H)
     &                      +(-1.000)*rk( 79)    *y(lXO2)
     &                      +(-1.000)*rk(102)    *y(lHCO3)
     &                      +(-0.900)*rk(144)    *y(lISO2)
     &                      +(-1.000)*rk(160)    *y(lEPX2)
     &                      +(-0.918)*rk(168)    *y(lBZO2)
     &                      +(-0.860)*rk(173)    *y(lTO2)
     &                      +(-0.860)*rk(178)    *y(lXLO2)
          JAC(lNO2 ,lNO  )=JAC(lNO2 ,lNO  )
     &                      +(-1.000)*rk(199)    *y(lOPO3)
     &                      +(-1.000)*rk(215)    *y(lIO)
     &                      +(-1.000)*rk(220)    *y(lOIO)
          JAC(lNO2 ,lO   )= +(-1.000)*rk(  4)    *y(lNO)*M
     &                      +         rk(  5)    *y(lNO2)
     &                      +         rk(  6)    *y(lNO2)
     &                      +(-1.000)*rk( 31)    *y(lNO3)
          JAC(lNO2 ,lO3  )= +(-1.000)*rk(  3)    *y(lNO)
     &                      +         rk( 26)    *y(lNO2)
     &                      +(-1.000)*rk( 34)    *y(lNO3)
          JAC(lNO2 ,lNO3 )= +(-1.000)*rk( 27)*flg
     &                      +(-2.000)*rk( 29)    *y(lNO)
     &                      +         rk( 30)    *y(lNO2)
     &                      +(-1.000)*rk( 30)    *y(lNO2)
     &                      +(-1.000)*rk( 31)    *y(lO)
     &                      +(-1.000)*rk( 32)    *y(lOH)
     &                      +(-1.000)*rk( 33)    *y(lHO2)
     &                      +(-1.000)*rk( 34)    *y(lO3)
     &                      +(-4.000)*rk( 35)    *y(lNO3)
          JAC(lNO2 ,lNO3 )=JAC(lNO2 ,lNO3 )
     &                      +         rk( 36)    *y(lNO2)
     &                      +(-0.500)*rk(136)    *y(lETH)
     &                      +(-0.500)*rk(139)    *y(lOLE)
     &                      +(-0.500)*rk(142)    *y(lIOLE)
     &                      +(-0.350)*rk(150)    *y(lISOP)
     &                      +(-0.142)*rk(153)    *y(lISPD)
     &                      +(-0.470)*rk(166)    *y(lTERP)
     &                      +(-0.500)*rk(192)    *y(lXOPN)
          JAC(lNO2 ,lOH  )= +(-1.000)*rk( 32)    *y(lNO3)
     &                      +(-1.000)*rk( 44)    *y(lHONO)
     &                      +         rk( 45)    *y(lNO2)
     &                      +(-1.000)*rk( 51)    *y(lPNA)
     &                      +(-0.444)*rk(163)    *y(lINTR)
     &                      +(-0.500)*rk(205)    *y(lOPAN)
     &                      +(-1.000)*rk(206)    *y(lPANX)
          JAC(lNO2 ,lHO2 )= +(-1.000)*rk( 25)    *y(lNO)
     &                      +(-1.000)*rk( 33)    *y(lNO3)
     &                      +         rk( 48)    *y(lNO2)
          JAC(lNO2 ,lN2O5)= +(-1.000)*rk( 37)*flg
     &                      +(-1.000)*rk( 38)*flg
          JAC(lNO2 ,lHNO3)= +(-1.000)*rk( 47)*flg
          JAC(lNO2 ,lHONO)= +(-2.000)*rk( 42)    *y(lHONO)
     &                      +(-1.000)*rk( 44)    *y(lOH)
          JAC(lNO2 ,lPNA )= +(-1.000)*rk( 49)*flg
     &                      +(-0.590)*rk( 50)*flg
     &                      +(-1.000)*rk( 51)    *y(lOH)
          JAC(lNO2 ,lC2O3)= +(-1.000)*rk( 53)    *y(lNO)
     &                      +         rk( 54)    *y(lNO2)
          JAC(lNO2 ,lMEO2)= +(-1.000)*rk( 71)    *y(lNO)
          JAC(lNO2 ,lPAN )= +(-1.000)*rk( 55)*flg
     &                      +(-0.600)*rk( 56)*flg
          JAC(lNO2 ,lCXO3)= +(-1.000)*rk( 61)    *y(lNO)
     &                      +         rk( 62)    *y(lNO2)
          JAC(lNO2 ,lXO2H)= +(-1.000)*rk( 75)    *y(lNO)
          JAC(lNO2 ,lPANX)= +(-1.000)*rk( 63)*flg
     &                      +(-0.600)*rk( 64)*flg
     &                      +(-1.000)*rk(206)    *y(lOH)
          JAC(lNO2 ,lXO2 )= +(-1.000)*rk( 79)    *y(lNO)
          JAC(lNO2 ,lNTR1)= +(-1.000)*rk( 92)*flg
          JAC(lNO2 ,lHCO3)= +(-1.000)*rk(102)    *y(lNO)
          JAC(lNO2 ,lROR )= +         rk(132)    *y(lNO2)
          JAC(lNO2 ,lETH )= +(-0.500)*rk(136)    *y(lNO3)
          JAC(lNO2 ,lOLE )= +(-0.500)*rk(139)    *y(lNO3)
          JAC(lNO2 ,lIOLE)= +(-0.500)*rk(142)    *y(lNO3)
          JAC(lNO2 ,lISOP)= +(-0.350)*rk(150)    *y(lNO3)
          JAC(lNO2 ,lISO2)= +(-0.900)*rk(144)    *y(lNO)
          JAC(lNO2 ,lINTR)= +(-0.444)*rk(163)    *y(lOH)
          JAC(lNO2 ,lISPD)= +(-0.142)*rk(153)    *y(lNO3)
          JAC(lNO2 ,lOPO3)= +(-1.000)*rk(199)    *y(lNO)
     &                      +         rk(200)    *y(lNO2)
          JAC(lNO2 ,lEPX2)= +(-1.000)*rk(160)    *y(lNO)
          JAC(lNO2 ,lTERP)= +(-0.470)*rk(166)    *y(lNO3)
          JAC(lNO2 ,lBZO2)= +(-0.918)*rk(168)    *y(lNO)
          JAC(lNO2 ,lTO2 )= +(-0.860)*rk(173)    *y(lNO)
          JAC(lNO2 ,lXOPN)= +(-0.500)*rk(192)    *y(lNO3)
          JAC(lNO2 ,lXLO2)= +(-0.860)*rk(178)    *y(lNO)
          JAC(lNO2 ,lCRO )= +         rk(184)    *y(lNO2)
          JAC(lNO2 ,lOPAN)= +(-1.000)*rk(201)*flg
     &                      +(-0.500)*rk(205)    *y(lOH)
          JAC(lNO2 ,lIO  )= +(-1.000)*rk(215)    *y(lNO)
     &                      +         rk(216)    *y(lNO2)
          JAC(lNO2 ,lOIO )= +(-1.000)*rk(220)    *y(lNO)
          JAC(lNO  ,lNO2 )= +(-1.000)*rk(  1)*flg
     &                      +(-1.000)*rk(  5)    *y(lO)
     &                      +(-1.000)*rk( 30)    *y(lNO3)
     &                      +         rk( 41)    *y(lNO)*H2O
          JAC(lNO  ,lNO  )= +         rk(  3)    *y(lO3)
     &                      +         rk(  4)    *y(lO)*M
     &                      +( 4.000)*rk( 24)    *y(lNO)*O2
     &                      +         rk( 25)    *y(lHO2)
     &                      +         rk( 29)    *y(lNO3)
     &                      +         rk( 40)    *y(lOH)
     &                      +         rk( 41)    *y(lNO2)*H2O
     &                      +         rk( 53)    *y(lC2O3)
     &                      +         rk( 61)    *y(lCXO3)
          JAC(lNO  ,lNO  )=JAC(lNO  ,lNO  )
     &                      +         rk( 68)    *y(lRO2)
     &                      +(-1.000)*rk( 68)    *y(lRO2)
     &                      +         rk( 71)    *y(lMEO2)
     &                      +         rk( 75)    *y(lXO2H)
     &                      +         rk( 79)    *y(lXO2)
     &                      +         rk( 83)    *y(lXO2N)
     &                      +         rk(102)    *y(lHCO3)
     &                      +         rk(144)    *y(lISO2)
          JAC(lNO  ,lNO  )=JAC(lNO  ,lNO  )
     &                      +         rk(160)    *y(lEPX2)
     &                      +         rk(168)    *y(lBZO2)
     &                      +         rk(173)    *y(lTO2)
     &                      +         rk(178)    *y(lXLO2)
     &                      +         rk(199)    *y(lOPO3)
     &                      +         rk(215)    *y(lIO)
     &                      +         rk(220)    *y(lOIO)
          JAC(lNO  ,lO   )= +         rk(  4)    *y(lNO)*M
     &                      +(-1.000)*rk(  5)    *y(lNO2)
          JAC(lNO  ,lO3  )= +         rk(  3)    *y(lNO)
          JAC(lNO  ,lNO3 )= +(-1.000)*rk( 28)*flg
     &                      +         rk( 29)    *y(lNO)
     &                      +(-1.000)*rk( 30)    *y(lNO2)
          JAC(lNO  ,lOH  )= +         rk( 40)    *y(lNO)
          JAC(lNO  ,lHO2 )= +         rk( 25)    *y(lNO)
          JAC(lNO  ,lHONO)= +(-2.000)*rk( 42)    *y(lHONO)
     &                      +(-1.000)*rk( 43)*flg
          JAC(lNO  ,lC2O3)= +         rk( 53)    *y(lNO)
          JAC(lNO  ,lMEO2)= +         rk( 71)    *y(lNO)
          JAC(lNO  ,lRO2 )= +         rk( 68)    *y(lNO)
     &                      +(-1.000)*rk( 68)    *y(lNO)
          JAC(lNO  ,lCXO3)= +         rk( 61)    *y(lNO)
          JAC(lNO  ,lXO2H)= +         rk( 75)    *y(lNO)
          JAC(lNO  ,lXO2 )= +         rk( 79)    *y(lNO)
          JAC(lNO  ,lXO2N)= +         rk( 83)    *y(lNO)
          JAC(lNO  ,lHCO3)= +         rk(102)    *y(lNO)
          JAC(lNO  ,lISO2)= +         rk(144)    *y(lNO)
          JAC(lNO  ,lOPO3)= +         rk(199)    *y(lNO)
          JAC(lNO  ,lEPX2)= +         rk(160)    *y(lNO)
          JAC(lNO  ,lBZO2)= +         rk(168)    *y(lNO)
          JAC(lNO  ,lTO2 )= +         rk(173)    *y(lNO)
          JAC(lNO  ,lXLO2)= +         rk(178)    *y(lNO)
          JAC(lNO  ,lIO  )= +         rk(215)    *y(lNO)
          JAC(lNO  ,lOIO )= +         rk(220)    *y(lNO)
          JAC(lO   ,lNO2 )= +(-1.000)*rk(  1)*flg
     &                      +         rk(  5)    *y(lO)
     &                      +         rk(  6)    *y(lO)
          JAC(lO   ,lNO  )= +         rk(  4)    *y(lO)*M
          JAC(lO   ,lO   )= +         rk(  2)*flg*O2*M
     &                      +         rk(  4)    *y(lNO)*M
     &                      +         rk(  5)    *y(lNO2)
     &                      +         rk(  6)    *y(lNO2)
     &                      +         rk(  7)    *y(lO3)
     &                      +         rk( 14)    *y(lOH)
     &                      +         rk( 15)    *y(lHO2)
     &                      +         rk( 23)    *y(lH2O2)
     &                      +         rk( 31)    *y(lNO3)
          JAC(lO   ,lO3  )= +         rk(  7)    *y(lO)
     &                      +(-1.000)*rk(  8)*flg
          JAC(lO   ,lNO3 )= +(-1.000)*rk( 27)*flg
     &                      +         rk( 31)    *y(lO)
          JAC(lO   ,lO1D )= +(-1.000)*rk( 10)*flg*M
          JAC(lO   ,lOH  )= +         rk( 14)    *y(lO)
     &                      +(-2.000)*rk( 16)    *y(lOH)
          JAC(lO   ,lHO2 )= +         rk( 15)    *y(lO)
          JAC(lO   ,lH2O2)= +         rk( 23)    *y(lO)
          JAC(lO   ,lIO  )= +(-1.000)*rk(212)*flg
          JAC(lO3  ,lNO2 )= +         rk( 26)    *y(lO3)
          JAC(lO3  ,lNO  )= +         rk(  3)    *y(lO3)
          JAC(lO3  ,lO   )= +(-1.000)*rk(  2)*flg*O2*M
     &                      +         rk(  7)    *y(lO3)
          JAC(lO3  ,lO3  )= +         rk(  3)    *y(lNO)
     &                      +         rk(  7)    *y(lO)
     &                      +         rk(  8)*flg
     &                      +         rk(  9)*flg
     &                      +         rk( 12)    *y(lOH)
     &                      +         rk( 13)    *y(lHO2)
     &                      +         rk( 26)    *y(lNO2)
     &                      +         rk( 34)    *y(lNO3)
     &                      +         rk(135)    *y(lETH)
          JAC(lO3  ,lO3  )=JAC(lO3  ,lO3  )
     &                      +         rk(138)    *y(lOLE)
     &                      +         rk(141)    *y(lIOLE)
     &                      +         rk(149)    *y(lISOP)
     &                      +         rk(152)    *y(lISPD)
     &                      +         rk(165)    *y(lTERP)
     &                      +         rk(191)    *y(lXOPN)
     &                      +         rk(195)    *y(lOPEN)
     &                      +         rk(211)    *y(lI)
          JAC(lO3  ,lO3  )=JAC(lO3  ,lO3  )
     &                      +         rk(222)    *y(lI2O2)
          JAC(lO3  ,lNO3 )= +         rk( 34)    *y(lO3)
          JAC(lO3  ,lOH  )= +         rk( 12)    *y(lO3)
          JAC(lO3  ,lHO2 )= +         rk( 13)    *y(lO3)
     &                      +(-0.150)*rk( 57)    *y(lC2O3)
     &                      +(-0.150)*rk( 65)    *y(lCXO3)
     &                      +(-0.150)*rk(202)    *y(lOPO3)
          JAC(lO3  ,lC2O3)= +(-0.150)*rk( 57)    *y(lHO2)
          JAC(lO3  ,lCXO3)= +(-0.150)*rk( 65)    *y(lHO2)
          JAC(lO3  ,lETH )= +         rk(135)    *y(lO3)
          JAC(lO3  ,lOLE )= +         rk(138)    *y(lO3)
          JAC(lO3  ,lIOLE)= +         rk(141)    *y(lO3)
          JAC(lO3  ,lISOP)= +         rk(149)    *y(lO3)
          JAC(lO3  ,lISPD)= +         rk(152)    *y(lO3)
          JAC(lO3  ,lOPO3)= +(-0.150)*rk(202)    *y(lHO2)
          JAC(lO3  ,lTERP)= +         rk(165)    *y(lO3)
          JAC(lO3  ,lOPEN)= +         rk(195)    *y(lO3)
          JAC(lO3  ,lXOPN)= +         rk(191)    *y(lO3)
          JAC(lO3  ,lI   )= +         rk(211)    *y(lO3)
          JAC(lO3  ,lI2O2)= +         rk(222)    *y(lO3)
          JAC(lNO3 ,lNO2 )= +(-1.000)*rk(  6)    *y(lO)
     &                      +(-1.000)*rk( 26)    *y(lO3)
     &                      +         rk( 30)    *y(lNO3)
     &                      +         rk( 36)    *y(lNO3)
          JAC(lNO3 ,lNO  )= +         rk( 29)    *y(lNO3)
          JAC(lNO3 ,lO   )= +(-1.000)*rk(  6)    *y(lNO2)
     &                      +         rk( 31)    *y(lNO3)
          JAC(lNO3 ,lO3  )= +(-1.000)*rk( 26)    *y(lNO2)
     &                      +         rk( 34)    *y(lNO3)
          JAC(lNO3 ,lNO3 )= +         rk( 27)*flg
     &                      +         rk( 28)*flg
     &                      +         rk( 29)    *y(lNO)
     &                      +         rk( 30)    *y(lNO2)
     &                      +         rk( 31)    *y(lO)
     &                      +         rk( 32)    *y(lOH)
     &                      +         rk( 33)    *y(lHO2)
     &                      +         rk( 34)    *y(lO3)
     &                      +( 4.000)*rk( 35)    *y(lNO3)
          JAC(lNO3 ,lNO3 )=JAC(lNO3 ,lNO3 )
     &                      +         rk( 36)    *y(lNO2)
     &                      +         rk( 99)    *y(lFORM)
     &                      +         rk(105)    *y(lALD2)
     &                      +         rk(108)    *y(lALDX)
     &                      +         rk(112)    *y(lGLYD)
     &                      +         rk(115)    *y(lGLY)
     &                      +         rk(117)    *y(lMGLY)
     &                      +         rk(136)    *y(lETH)
          JAC(lNO3 ,lNO3 )=JAC(lNO3 ,lNO3 )
     &                      +         rk(139)    *y(lOLE)
     &                      +         rk(142)    *y(lIOLE)
     &                      +         rk(150)    *y(lISOP)
     &                      +         rk(153)    *y(lISPD)
     &                      +         rk(157)    *y(lHPLD)
     &                      +         rk(166)    *y(lTERP)
     &                      +         rk(183)    *y(lCRES)
     &                      +         rk(187)    *y(lCRON)
          JAC(lNO3 ,lNO3 )=JAC(lNO3 ,lNO3 )
     &                      +         rk(192)    *y(lXOPN)
     &                      +         rk(196)    *y(lOPEN)
     &                      +         rk(198)    *y(lCAT1)
     &                      +         rk(233)    *y(lDMS)
          JAC(lNO3 ,lOH  )= +         rk( 32)    *y(lNO3)
     &                      +(-1.000)*rk( 46)    *y(lHNO3)
     &                      +(-0.185)*rk(163)    *y(lINTR)
          JAC(lNO3 ,lHO2 )= +         rk( 33)    *y(lNO3)
          JAC(lNO3 ,lN2O5)= +(-1.000)*rk( 37)*flg
     &                      +(-1.000)*rk( 38)*flg
          JAC(lNO3 ,lHNO3)= +(-1.000)*rk( 46)    *y(lOH)
          JAC(lNO3 ,lPNA )= +(-0.410)*rk( 50)*flg
          JAC(lNO3 ,lPAN )= +(-0.400)*rk( 56)*flg
          JAC(lNO3 ,lALD2)= +         rk(105)    *y(lNO3)
          JAC(lNO3 ,lPANX)= +(-0.400)*rk( 64)*flg
          JAC(lNO3 ,lFORM)= +         rk( 99)    *y(lNO3)
          JAC(lNO3 ,lALDX)= +         rk(108)    *y(lNO3)
          JAC(lNO3 ,lGLYD)= +         rk(112)    *y(lNO3)
          JAC(lNO3 ,lGLY )= +         rk(115)    *y(lNO3)
          JAC(lNO3 ,lMGLY)= +         rk(117)    *y(lNO3)
          JAC(lNO3 ,lETH )= +         rk(136)    *y(lNO3)
          JAC(lNO3 ,lOLE )= +         rk(139)    *y(lNO3)
          JAC(lNO3 ,lIOLE)= +         rk(142)    *y(lNO3)
          JAC(lNO3 ,lISOP)= +         rk(150)    *y(lNO3)
          JAC(lNO3 ,lINTR)= +(-0.185)*rk(163)    *y(lOH)
          JAC(lNO3 ,lISPD)= +         rk(153)    *y(lNO3)
          JAC(lNO3 ,lHPLD)= +         rk(157)    *y(lNO3)
          JAC(lNO3 ,lTERP)= +         rk(166)    *y(lNO3)
          JAC(lNO3 ,lCRES)= +         rk(183)    *y(lNO3)
          JAC(lNO3 ,lOPEN)= +         rk(196)    *y(lNO3)
          JAC(lNO3 ,lXOPN)= +         rk(192)    *y(lNO3)
          JAC(lNO3 ,lCAT1)= +         rk(198)    *y(lNO3)
          JAC(lNO3 ,lCRON)= +         rk(187)    *y(lNO3)
          JAC(lNO3 ,lINO3)= +(-1.000)*rk(223)*flg
          JAC(lNO3 ,lDMS )= +         rk(233)    *y(lNO3)
          JAC(lO1D ,lO3  )= +(-1.000)*rk(  9)*flg
          JAC(lO1D ,lO1D )= +         rk( 10)*flg*M
     &                      +         rk( 11)*flg*H2O
          JAC(lOH  ,lNO2 )= +         rk( 45)    *y(lOH)
          JAC(lOH  ,lNO  )= +(-1.000)*rk( 25)    *y(lHO2)
     &                      +         rk( 40)    *y(lOH)
     &                      +(-0.125)*rk(160)    *y(lEPX2)
          JAC(lOH  ,lO   )= +         rk( 14)    *y(lOH)
     &                      +(-1.000)*rk( 15)    *y(lHO2)
     &                      +(-1.000)*rk( 23)    *y(lH2O2)
          JAC(lOH  ,lO3  )= +         rk( 12)    *y(lOH)
     &                      +(-1.000)*rk( 13)    *y(lHO2)
     &                      +(-0.160)*rk(135)    *y(lETH)
     &                      +(-0.334)*rk(138)    *y(lOLE)
     &                      +(-0.500)*rk(141)    *y(lIOLE)
     &                      +(-0.266)*rk(149)    *y(lISOP)
     &                      +(-0.461)*rk(152)    *y(lISPD)
     &                      +(-0.570)*rk(165)    *y(lTERP)
     &                      +(-0.500)*rk(191)    *y(lXOPN)
          JAC(lOH  ,lO3  )=JAC(lOH  ,lO3  )
     &                      +(-0.500)*rk(195)    *y(lOPEN)
          JAC(lOH  ,lNO3 )= +         rk( 32)    *y(lOH)
     &                      +(-1.000)*rk( 33)    *y(lHO2)
          JAC(lOH  ,lO1D )= +(-2.000)*rk( 11)*flg*H2O
          JAC(lOH  ,lOH  )= +         rk( 12)    *y(lO3)
     &                      +         rk( 14)    *y(lO)
     &                      +( 4.000)*rk( 16)    *y(lOH)
     &                      +( 4.000)*rk( 17)    *y(lOH)
     &                      +         rk( 18)    *y(lHO2)
     &                      +         rk( 22)    *y(lH2O2)
     &                      +         rk( 32)    *y(lNO3)
     &                      +         rk( 40)    *y(lNO)
     &                      +         rk( 44)    *y(lHONO)
          JAC(lOH  ,lOH  )=JAC(lOH  ,lOH  )
     &                      +         rk( 45)    *y(lNO2)
     &                      +         rk( 46)    *y(lHNO3)
     &                      +         rk( 51)    *y(lPNA)
     &                      +         rk( 52)    *y(lSO2)
     &                      +         rk( 87)    *y(lMEPX)
     &                      +(-0.400)*rk( 87)    *y(lMEPX)
     &                      +         rk( 89)    *y(lROOH)
     &                      +(-0.400)*rk( 89)    *y(lROOH)
          JAC(lOH  ,lOH  )=JAC(lOH  ,lOH  )
     &                      +         rk( 91)    *y(lNTR1)
     &                      +         rk( 93)    *y(lFACD)
     &                      +         rk( 94)    *y(lAACD)
     &                      +         rk( 95)    *y(lPACD)
     &                      +         rk( 96)    *y(lFORM)
     &                      +         rk(104)    *y(lALD2)
     &                      +         rk(107)    *y(lALDX)
     &                      +         rk(110)    *y(lGLYD)
          JAC(lOH  ,lOH  )=JAC(lOH  ,lOH  )
     &                      +         rk(113)    *y(lGLY)
     &                      +         rk(118)    *y(lMGLY)
     &                      +         rk(119)*flg*H2
     &                      +         rk(120)    *y(lCO)
     &                      +         rk(121)*flg*CH4
     &                      +         rk(122)    *y(lETHA)
     &                      +         rk(123)    *y(lMEOH)
     &                      +         rk(124)    *y(lETOH)
          JAC(lOH  ,lOH  )=JAC(lOH  ,lOH  )
     &                      +         rk(127)    *y(lACET)
     &                      +         rk(128)    *y(lPRPA)
     &                      +         rk(129)    *y(lPAR)
     &                      +         rk(133)    *y(lETHY)
     &                      +(-0.700)*rk(133)    *y(lETHY)
     &                      +         rk(134)    *y(lETH)
     &                      +         rk(137)    *y(lOLE)
     &                      +         rk(140)    *y(lIOLE)
          JAC(lOH  ,lOH  )=JAC(lOH  ,lOH  )
     &                      +         rk(143)    *y(lISOP)
     &                      +         rk(151)    *y(lISPD)
     &                      +         rk(155)    *y(lISPX)
     &                      +(-0.933)*rk(155)    *y(lISPX)
     &                      +         rk(158)    *y(lEPOX)
     &                      +         rk(163)    *y(lINTR)
     &                      +         rk(164)    *y(lTERP)
     &                      +         rk(167)    *y(lBENZ)
          JAC(lOH  ,lOH  )=JAC(lOH  ,lOH  )
     &                      +(-0.118)*rk(167)    *y(lBENZ)
     &                      +         rk(172)    *y(lTOL)
     &                      +(-0.100)*rk(172)    *y(lTOL)
     &                      +         rk(177)    *y(lXYL)
     &                      +(-0.244)*rk(177)    *y(lXYL)
     &                      +         rk(182)    *y(lCRES)
     &                      +         rk(186)    *y(lCRON)
     &                      +         rk(190)    *y(lXOPN)
          JAC(lOH  ,lOH  )=JAC(lOH  ,lOH  )
     &                      +         rk(194)    *y(lOPEN)
     &                      +         rk(197)    *y(lCAT1)
     &                      +         rk(205)    *y(lOPAN)
     &                      +         rk(206)    *y(lPANX)
     &                      +         rk(208)    *y(lECH4)
     &                      +         rk(218)    *y(lOIO)
     &                      +         rk(231)    *y(lDMS)
     &                      +         rk(232)    *y(lDMS)*O2
          JAC(lOH  ,lHO2 )= +(-1.000)*rk( 13)    *y(lO3)
     &                      +(-1.000)*rk( 15)    *y(lO)
     &                      +         rk( 18)    *y(lOH)
     &                      +(-1.000)*rk( 25)    *y(lNO)
     &                      +(-1.000)*rk( 33)    *y(lNO3)
     &                      +(-0.440)*rk( 57)    *y(lC2O3)
     &                      +(-0.440)*rk( 65)    *y(lCXO3)
     &                      +(-0.200)*rk(103)    *y(lHCO3)
     &                      +(-0.120)*rk(145)    *y(lISO2)
          JAC(lOH  ,lHO2 )=JAC(lOH  ,lHO2 )
     &                      +(-1.125)*rk(159)    *y(lEPX2)
     &                      +(-0.440)*rk(202)    *y(lOPO3)
          JAC(lOH  ,lH2O2)= +(-2.000)*rk( 21)*flg
     &                      +         rk( 22)    *y(lOH)
     &                      +(-1.000)*rk( 23)    *y(lO)
          JAC(lOH  ,lHNO3)= +         rk( 46)    *y(lOH)
     &                      +(-1.000)*rk( 47)*flg
          JAC(lOH  ,lHONO)= +(-1.000)*rk( 43)*flg
     &                      +         rk( 44)    *y(lOH)
          JAC(lOH  ,lPNA )= +(-0.410)*rk( 50)*flg
     &                      +         rk( 51)    *y(lOH)
          JAC(lOH  ,lSO2 )= +         rk( 52)    *y(lOH)
          JAC(lOH  ,lC2O3)= +(-0.440)*rk( 57)    *y(lHO2)
     &                      +(-0.100)*rk(161)    *y(lEPX2)
          JAC(lOH  ,lRO2 )= +(-0.125)*rk(162)    *y(lEPX2)
          JAC(lOH  ,lPACD)= +         rk( 95)    *y(lOH)
          JAC(lOH  ,lAACD)= +         rk( 94)    *y(lOH)
          JAC(lOH  ,lCXO3)= +(-0.440)*rk( 65)    *y(lHO2)
          JAC(lOH  ,lALD2)= +         rk(104)    *y(lOH)
          JAC(lOH  ,lPANX)= +         rk(206)    *y(lOH)
          JAC(lOH  ,lFORM)= +         rk( 96)    *y(lOH)
          JAC(lOH  ,lMEPX)= +         rk( 87)    *y(lOH)
     &                      +(-0.400)*rk( 87)    *y(lOH)
     &                      +(-1.000)*rk( 88)*flg
          JAC(lOH  ,lMEOH)= +         rk(123)    *y(lOH)
          JAC(lOH  ,lROOH)= +         rk( 89)    *y(lOH)
     &                      +(-0.400)*rk( 89)    *y(lOH)
     &                      +(-1.000)*rk( 90)*flg
          JAC(lOH  ,lNTR1)= +         rk( 91)    *y(lOH)
          JAC(lOH  ,lFACD)= +         rk( 93)    *y(lOH)
          JAC(lOH  ,lCO  )= +         rk(120)    *y(lOH)
          JAC(lOH  ,lHCO3)= +(-0.200)*rk(103)    *y(lHO2)
          JAC(lOH  ,lALDX)= +         rk(107)    *y(lOH)
          JAC(lOH  ,lGLYD)= +         rk(110)    *y(lOH)
     &                      +(-0.190)*rk(111)*flg
          JAC(lOH  ,lGLY )= +         rk(113)    *y(lOH)
          JAC(lOH  ,lMGLY)= +         rk(118)    *y(lOH)
          JAC(lOH  ,lETHA)= +         rk(122)    *y(lOH)
          JAC(lOH  ,lETOH)= +         rk(124)    *y(lOH)
          JAC(lOH  ,lPAR )= +         rk(129)    *y(lOH)
          JAC(lOH  ,lACET)= +         rk(127)    *y(lOH)
          JAC(lOH  ,lPRPA)= +         rk(128)    *y(lOH)
          JAC(lOH  ,lETHY)= +         rk(133)    *y(lOH)
     &                      +(-0.700)*rk(133)    *y(lOH)
          JAC(lOH  ,lETH )= +         rk(134)    *y(lOH)
     &                      +(-0.160)*rk(135)    *y(lO3)
          JAC(lOH  ,lOLE )= +         rk(137)    *y(lOH)
     &                      +(-0.334)*rk(138)    *y(lO3)
          JAC(lOH  ,lIOLE)= +         rk(140)    *y(lOH)
     &                      +(-0.500)*rk(141)    *y(lO3)
          JAC(lOH  ,lISOP)= +         rk(143)    *y(lOH)
     &                      +(-0.266)*rk(149)    *y(lO3)
          JAC(lOH  ,lISO2)= +(-0.120)*rk(145)    *y(lHO2)
          JAC(lOH  ,lINTR)= +         rk(163)    *y(lOH)
          JAC(lOH  ,lISPD)= +         rk(151)    *y(lOH)
     &                      +(-0.461)*rk(152)    *y(lO3)
          JAC(lOH  ,lISPX)= +         rk(155)    *y(lOH)
     &                      +(-0.933)*rk(155)    *y(lOH)
          JAC(lOH  ,lHPLD)= +(-1.000)*rk(156)*flg
          JAC(lOH  ,lOPO3)= +(-0.440)*rk(202)    *y(lHO2)
          JAC(lOH  ,lEPOX)= +         rk(158)    *y(lOH)
          JAC(lOH  ,lEPX2)= +(-1.125)*rk(159)    *y(lHO2)
     &                      +(-0.125)*rk(160)    *y(lNO)
     &                      +(-0.100)*rk(161)    *y(lC2O3)
     &                      +(-0.125)*rk(162)    *y(lRO2)
          JAC(lOH  ,lTERP)= +         rk(164)    *y(lOH)
     &                      +(-0.570)*rk(165)    *y(lO3)
          JAC(lOH  ,lBENZ)= +         rk(167)    *y(lOH)
     &                      +(-0.118)*rk(167)    *y(lOH)
          JAC(lOH  ,lCRES)= +         rk(182)    *y(lOH)
          JAC(lOH  ,lOPEN)= +         rk(194)    *y(lOH)
     &                      +(-0.500)*rk(195)    *y(lO3)
          JAC(lOH  ,lTOL )= +         rk(172)    *y(lOH)
     &                      +(-0.100)*rk(172)    *y(lOH)
          JAC(lOH  ,lXOPN)= +         rk(190)    *y(lOH)
     &                      +(-0.500)*rk(191)    *y(lO3)
          JAC(lOH  ,lXYL )= +         rk(177)    *y(lOH)
     &                      +(-0.244)*rk(177)    *y(lOH)
          JAC(lOH  ,lCAT1)= +         rk(197)    *y(lOH)
          JAC(lOH  ,lCRON)= +         rk(186)    *y(lOH)
          JAC(lOH  ,lOPAN)= +         rk(205)    *y(lOH)
          JAC(lOH  ,lECH4)= +         rk(208)    *y(lOH)
          JAC(lOH  ,lHOI )= +(-1.000)*rk(210)*flg
          JAC(lOH  ,lOIO )= +         rk(218)    *y(lOH)
          JAC(lOH  ,lDMS )= +         rk(231)    *y(lOH)
     &                      +         rk(232)    *y(lOH)*O2
          JAC(lHO2 ,lNO2 )= +         rk( 48)    *y(lHO2)
          JAC(lHO2 ,lNO  )= +         rk( 25)    *y(lHO2)
     &                      +(-1.000)*rk( 71)    *y(lMEO2)
     &                      +(-1.000)*rk( 75)    *y(lXO2H)
     &                      +(-1.000)*rk(102)    *y(lHCO3)
     &                      +(-0.818)*rk(144)    *y(lISO2)
     &                      +(-0.825)*rk(160)    *y(lEPX2)
     &                      +(-0.918)*rk(168)    *y(lBZO2)
     &                      +(-0.860)*rk(173)    *y(lTO2)
     &                      +(-0.860)*rk(178)    *y(lXLO2)
          JAC(lHO2 ,lNO  )=JAC(lHO2 ,lNO  )
     &                      +(-0.800)*rk(199)    *y(lOPO3)
          JAC(lHO2 ,lO   )= +(-1.000)*rk( 14)    *y(lOH)
     &                      +         rk( 15)    *y(lHO2)
     &                      +(-1.000)*rk( 23)    *y(lH2O2)
          JAC(lHO2 ,lO3  )= +(-1.000)*rk( 12)    *y(lOH)
     &                      +         rk( 13)    *y(lHO2)
     &                      +(-0.160)*rk(135)    *y(lETH)
     &                      +(-0.080)*rk(138)    *y(lOLE)
     &                      +(-0.066)*rk(149)    *y(lISOP)
     &                      +(-0.398)*rk(152)    *y(lISPD)
     &                      +(-0.560)*rk(195)    *y(lOPEN)
          JAC(lHO2 ,lNO3 )= +(-1.000)*rk( 32)    *y(lOH)
     &                      +         rk( 33)    *y(lHO2)
     &                      +(-1.000)*rk( 99)    *y(lFORM)
     &                      +(-1.000)*rk(115)    *y(lGLY)
          JAC(lHO2 ,lOH  )= +(-1.000)*rk( 12)    *y(lO3)
     &                      +(-1.000)*rk( 14)    *y(lO)
     &                      +         rk( 18)    *y(lHO2)
     &                      +(-1.000)*rk( 22)    *y(lH2O2)
     &                      +(-1.000)*rk( 32)    *y(lNO3)
     &                      +(-1.000)*rk( 52)    *y(lSO2)
     &                      +(-1.000)*rk( 93)    *y(lFACD)
     &                      +(-1.000)*rk( 96)    *y(lFORM)
     &                      +(-0.200)*rk(110)    *y(lGLYD)
          JAC(lHO2 ,lOH  )=JAC(lHO2 ,lOH  )
     &                      +(-1.000)*rk(113)    *y(lGLY)
     &                      +(-1.000)*rk(119)*flg*H2
     &                      +(-1.000)*rk(120)    *y(lCO)
     &                      +(-1.000)*rk(123)    *y(lMEOH)
     &                      +(-0.900)*rk(124)    *y(lETOH)
     &                      +(-0.300)*rk(133)    *y(lETHY)
     &                      +(-0.137)*rk(151)    *y(lISPD)
     &                      +(-0.530)*rk(167)    *y(lBENZ)
          JAC(lHO2 ,lOH  )=JAC(lHO2 ,lOH  )
     &                      +(-0.180)*rk(172)    *y(lTOL)
     &                      +(-0.155)*rk(177)    *y(lXYL)
     &                      +(-1.000)*rk(182)    *y(lCRES)
     &                      +(-0.200)*rk(197)    *y(lCAT1)
          JAC(lHO2 ,lHO2 )= +         rk( 13)    *y(lO3)
     &                      +         rk( 15)    *y(lO)
     &                      +         rk( 18)    *y(lOH)
     &                      +( 4.000)*rk( 19)    *y(lHO2)
     &                      +( 4.000)*rk( 20)    *y(lHO2)*H2O
     &                      +         rk( 25)    *y(lNO)
     &                      +         rk( 33)    *y(lNO3)
     &                      +         rk( 48)    *y(lNO2)
     &                      +         rk( 57)    *y(lC2O3)
          JAC(lHO2 ,lHO2 )=JAC(lHO2 ,lHO2 )
     &                      +         rk( 65)    *y(lCXO3)
     &                      +         rk( 69)    *y(lRO2)
     &                      +(-1.000)*rk( 69)    *y(lRO2)
     &                      +         rk( 72)    *y(lMEO2)
     &                      +         rk( 76)    *y(lXO2H)
     &                      +         rk( 80)    *y(lXO2)
     &                      +         rk( 84)    *y(lXO2N)
     &                      +         rk(100)    *y(lFORM)
          JAC(lHO2 ,lHO2 )=JAC(lHO2 ,lHO2 )
     &                      +         rk(103)    *y(lHCO3)
     &                      +(-0.200)*rk(103)    *y(lHCO3)
     &                      +         rk(145)    *y(lISO2)
     &                      +(-0.120)*rk(145)    *y(lISO2)
     &                      +         rk(159)    *y(lEPX2)
     &                      +(-0.825)*rk(159)    *y(lEPX2)
     &                      +         rk(170)    *y(lBZO2)
     &                      +         rk(175)    *y(lTO2)
          JAC(lHO2 ,lHO2 )=JAC(lHO2 ,lHO2 )
     &                      +         rk(179)    *y(lXLO2)
     &                      +         rk(185)    *y(lCRO)
     &                      +         rk(202)    *y(lOPO3)
     &                      +         rk(214)    *y(lIO)
          JAC(lHO2 ,lH2O2)= +(-1.000)*rk( 22)    *y(lOH)
     &                      +(-1.000)*rk( 23)    *y(lO)
          JAC(lHO2 ,lPNA )= +(-1.000)*rk( 49)*flg
     &                      +(-0.590)*rk( 50)*flg
          JAC(lHO2 ,lSO2 )= +(-1.000)*rk( 52)    *y(lOH)
          JAC(lHO2 ,lC2O3)= +         rk( 57)    *y(lHO2)
     &                      +(-0.900)*rk( 73)    *y(lMEO2)
     &                      +(-0.800)*rk( 77)    *y(lXO2H)
     &                      +(-0.800)*rk( 85)    *y(lXO2N)
     &                      +(-0.728)*rk(146)    *y(lISO2)
     &                      +(-0.660)*rk(161)    *y(lEPX2)
     &                      +(-1.000)*rk(169)    *y(lBZO2)
     &                      +(-1.000)*rk(174)    *y(lTO2)
     &                      +(-1.000)*rk(180)    *y(lXLO2)
          JAC(lHO2 ,lMEO2)= +(-1.000)*rk( 71)    *y(lNO)
     &                      +         rk( 72)    *y(lHO2)
     &                      +(-0.900)*rk( 73)    *y(lC2O3)
     &                      +(-0.370)*rk( 74)    *y(lRO2)
          JAC(lHO2 ,lRO2 )= +         rk( 69)    *y(lHO2)
     &                      +(-1.000)*rk( 69)    *y(lHO2)
     &                      +(-0.370)*rk( 74)    *y(lMEO2)
     &                      +(-0.600)*rk( 78)    *y(lXO2H)
     &                      +(-0.728)*rk(147)    *y(lISO2)
     &                      +(-0.825)*rk(162)    *y(lEPX2)
     &                      +(-1.000)*rk(171)    *y(lBZO2)
     &                      +(-1.000)*rk(176)    *y(lTO2)
     &                      +(-1.000)*rk(181)    *y(lXLO2)
          JAC(lHO2 ,lCXO3)= +         rk( 65)    *y(lHO2)
          JAC(lHO2 ,lALD2)= +(-1.000)*rk(106)*flg
          JAC(lHO2 ,lXO2H)= +(-1.000)*rk( 75)    *y(lNO)
     &                      +         rk( 76)    *y(lHO2)
     &                      +(-0.800)*rk( 77)    *y(lC2O3)
     &                      +(-0.600)*rk( 78)    *y(lRO2)
          JAC(lHO2 ,lFORM)= +(-1.000)*rk( 96)    *y(lOH)
     &                      +(-2.000)*rk( 97)*flg
     &                      +(-1.000)*rk( 99)    *y(lNO3)
     &                      +         rk(100)    *y(lHO2)
          JAC(lHO2 ,lMEOH)= +(-1.000)*rk(123)    *y(lOH)
          JAC(lHO2 ,lROOH)= +(-1.000)*rk( 90)*flg
          JAC(lHO2 ,lXO2 )= +         rk( 80)    *y(lHO2)
          JAC(lHO2 ,lXO2N)= +         rk( 84)    *y(lHO2)
     &                      +(-0.800)*rk( 85)    *y(lC2O3)
          JAC(lHO2 ,lFACD)= +(-1.000)*rk( 93)    *y(lOH)
          JAC(lHO2 ,lCO  )= +(-1.000)*rk(120)    *y(lOH)
          JAC(lHO2 ,lHCO3)= +(-1.000)*rk(101)*flg
     &                      +(-1.000)*rk(102)    *y(lNO)
     &                      +         rk(103)    *y(lHO2)
     &                      +(-0.200)*rk(103)    *y(lHO2)
          JAC(lHO2 ,lALDX)= +(-1.000)*rk(109)*flg
          JAC(lHO2 ,lGLYD)= +(-0.200)*rk(110)    *y(lOH)
     &                      +(-1.400)*rk(111)*flg
          JAC(lHO2 ,lGLY )= +(-1.000)*rk(113)    *y(lOH)
     &                      +(-2.000)*rk(114)*flg
     &                      +(-1.000)*rk(115)    *y(lNO3)
          JAC(lHO2 ,lMGLY)= +(-1.000)*rk(116)*flg
          JAC(lHO2 ,lETOH)= +(-0.900)*rk(124)    *y(lOH)
          JAC(lHO2 ,lROR )= +(-1.000)*rk(131)*flg*O2
          JAC(lHO2 ,lETHY)= +(-0.300)*rk(133)    *y(lOH)
          JAC(lHO2 ,lETH )= +(-0.160)*rk(135)    *y(lO3)
          JAC(lHO2 ,lOLE )= +(-0.080)*rk(138)    *y(lO3)
          JAC(lHO2 ,lISOP)= +(-0.066)*rk(149)    *y(lO3)
          JAC(lHO2 ,lISO2)= +(-0.818)*rk(144)    *y(lNO)
     &                      +         rk(145)    *y(lHO2)
     &                      +(-0.120)*rk(145)    *y(lHO2)
     &                      +(-0.728)*rk(146)    *y(lC2O3)
     &                      +(-0.728)*rk(147)    *y(lRO2)
     &                      +(-1.000)*rk(148)*flg
          JAC(lHO2 ,lISPD)= +(-0.137)*rk(151)    *y(lOH)
     &                      +(-0.398)*rk(152)    *y(lO3)
     &                      +(-0.760)*rk(154)*flg
          JAC(lHO2 ,lOPO3)= +(-0.800)*rk(199)    *y(lNO)
     &                      +         rk(202)    *y(lHO2)
          JAC(lHO2 ,lEPX2)= +         rk(159)    *y(lHO2)
     &                      +(-0.825)*rk(159)    *y(lHO2)
     &                      +(-0.825)*rk(160)    *y(lNO)
     &                      +(-0.660)*rk(161)    *y(lC2O3)
     &                      +(-0.825)*rk(162)    *y(lRO2)
          JAC(lHO2 ,lBENZ)= +(-0.530)*rk(167)    *y(lOH)
          JAC(lHO2 ,lCRES)= +(-1.000)*rk(182)    *y(lOH)
          JAC(lHO2 ,lBZO2)= +(-0.918)*rk(168)    *y(lNO)
     &                      +(-1.000)*rk(169)    *y(lC2O3)
     &                      +         rk(170)    *y(lHO2)
     &                      +(-1.000)*rk(171)    *y(lRO2)
          JAC(lHO2 ,lOPEN)= +(-1.000)*rk(193)*flg
     &                      +(-0.560)*rk(195)    *y(lO3)
          JAC(lHO2 ,lTOL )= +(-0.180)*rk(172)    *y(lOH)
          JAC(lHO2 ,lTO2 )= +(-0.860)*rk(173)    *y(lNO)
     &                      +(-1.000)*rk(174)    *y(lC2O3)
     &                      +         rk(175)    *y(lHO2)
     &                      +(-1.000)*rk(176)    *y(lRO2)
          JAC(lHO2 ,lXOPN)= +(-0.700)*rk(189)*flg
          JAC(lHO2 ,lXYL )= +(-0.155)*rk(177)    *y(lOH)
          JAC(lHO2 ,lXLO2)= +(-0.860)*rk(178)    *y(lNO)
     &                      +         rk(179)    *y(lHO2)
     &                      +(-1.000)*rk(180)    *y(lC2O3)
     &                      +(-1.000)*rk(181)    *y(lRO2)
          JAC(lHO2 ,lCRO )= +         rk(185)    *y(lHO2)
          JAC(lHO2 ,lCAT1)= +(-0.200)*rk(197)    *y(lOH)
          JAC(lHO2 ,lCRON)= +(-1.000)*rk(188)*flg
          JAC(lHO2 ,lIO  )= +         rk(214)    *y(lHO2)
          JAC(lH2O2,lO   )= +         rk( 23)    *y(lH2O2)
          JAC(lH2O2,lO3  )= +(-0.040)*rk(138)    *y(lOLE)
     &                      +(-0.080)*rk(141)    *y(lIOLE)
          JAC(lH2O2,lOH  )= +(-2.000)*rk( 17)    *y(lOH)
     &                      +         rk( 22)    *y(lH2O2)
          JAC(lH2O2,lHO2 )= +(-2.000)*rk( 19)    *y(lHO2)
     &                      +(-2.000)*rk( 20)    *y(lHO2)*H2O
          JAC(lH2O2,lH2O2)= +         rk( 21)*flg
     &                      +         rk( 22)    *y(lOH)
     &                      +         rk( 23)    *y(lO)
          JAC(lH2O2,lOLE )= +(-0.040)*rk(138)    *y(lO3)
          JAC(lH2O2,lIOLE)= +(-0.080)*rk(141)    *y(lO3)
          JAC(lN2O5,lNO2 )= +(-1.000)*rk( 36)    *y(lNO3)
          JAC(lN2O5,lNO3 )= +(-1.000)*rk( 36)    *y(lNO2)
          JAC(lN2O5,lN2O5)= +         rk( 37)*flg
     &                      +         rk( 38)*flg
     &                      +         rk( 39)*flg*H2O
          JAC(lHNO3,lNO2 )= +(-1.000)*rk( 45)    *y(lOH)
          JAC(lHNO3,lNO3 )= +(-1.000)*rk( 99)    *y(lFORM)
     &                      +(-1.000)*rk(105)    *y(lALD2)
     &                      +(-1.000)*rk(108)    *y(lALDX)
     &                      +(-1.000)*rk(112)    *y(lGLYD)
     &                      +(-1.000)*rk(115)    *y(lGLY)
     &                      +(-1.000)*rk(117)    *y(lMGLY)
     &                      +(-0.717)*rk(153)    *y(lISPD)
     &                      +(-1.000)*rk(157)    *y(lHPLD)
     &                      +(-1.000)*rk(183)    *y(lCRES)
          JAC(lHNO3,lNO3 )=JAC(lHNO3,lNO3 )
     &                      +(-1.000)*rk(187)    *y(lCRON)
     &                      +(-1.000)*rk(196)    *y(lOPEN)
     &                      +(-1.000)*rk(198)    *y(lCAT1)
     &                      +(-1.000)*rk(233)    *y(lDMS)
          JAC(lHNO3,lOH  )= +(-1.000)*rk( 45)    *y(lNO2)
     &                      +         rk( 46)    *y(lHNO3)
          JAC(lHNO3,lN2O5)= +(-2.000)*rk( 39)*flg*H2O
          JAC(lHNO3,lHNO3)= +         rk( 46)    *y(lOH)
     &                      +         rk( 47)*flg
          JAC(lHNO3,lALD2)= +(-1.000)*rk(105)    *y(lNO3)
          JAC(lHNO3,lFORM)= +(-1.000)*rk( 99)    *y(lNO3)
          JAC(lHNO3,lNTR2)= +(-1.000)*rk(207)*flg
          JAC(lHNO3,lALDX)= +(-1.000)*rk(108)    *y(lNO3)
          JAC(lHNO3,lGLYD)= +(-1.000)*rk(112)    *y(lNO3)
          JAC(lHNO3,lGLY )= +(-1.000)*rk(115)    *y(lNO3)
          JAC(lHNO3,lMGLY)= +(-1.000)*rk(117)    *y(lNO3)
          JAC(lHNO3,lINTR)= +(-1.000)*rk(229)*flg
          JAC(lHNO3,lISPD)= +(-0.717)*rk(153)    *y(lNO3)
          JAC(lHNO3,lHPLD)= +(-1.000)*rk(157)    *y(lNO3)
          JAC(lHNO3,lCRES)= +(-1.000)*rk(183)    *y(lNO3)
          JAC(lHNO3,lOPEN)= +(-1.000)*rk(196)    *y(lNO3)
          JAC(lHNO3,lCAT1)= +(-1.000)*rk(198)    *y(lNO3)
          JAC(lHNO3,lCRON)= +(-1.000)*rk(187)    *y(lNO3)
          JAC(lHNO3,lINO3)= +(-1.000)*rk(224)*flg*H2O
          JAC(lHNO3,lDMS )= +(-1.000)*rk(233)    *y(lNO3)
          JAC(lHONO,lNO2 )= +(-2.000)*rk( 41)    *y(lNO)*H2O
          JAC(lHONO,lNO  )= +(-1.000)*rk( 40)    *y(lOH)
     &                      +(-2.000)*rk( 41)    *y(lNO2)*H2O
          JAC(lHONO,lOH  )= +(-1.000)*rk( 40)    *y(lNO)
     &                      +         rk( 44)    *y(lHONO)
          JAC(lHONO,lHONO)= +( 4.000)*rk( 42)    *y(lHONO)
     &                      +         rk( 43)*flg
     &                      +         rk( 44)    *y(lOH)
          JAC(lHONO,lCRON)= +(-1.000)*rk(188)*flg
          JAC(lPNA ,lNO2 )= +(-1.000)*rk( 48)    *y(lHO2)
          JAC(lPNA ,lOH  )= +         rk( 51)    *y(lPNA)
          JAC(lPNA ,lHO2 )= +(-1.000)*rk( 48)    *y(lNO2)
          JAC(lPNA ,lPNA )= +         rk( 49)*flg
     &                      +         rk( 50)*flg
     &                      +         rk( 51)    *y(lOH)
          JAC(lSO2 ,lNO3 )= +(-1.000)*rk(233)    *y(lDMS)
          JAC(lSO2 ,lOH  )= +         rk( 52)    *y(lSO2)
     &                      +(-1.000)*rk(231)    *y(lDMS)
          JAC(lSO2 ,lSO2 )= +         rk( 52)    *y(lOH)
     &                      +         rk(230)*flg
          JAC(lSO2 ,lDMS )= +(-1.000)*rk(231)    *y(lOH)
     &                      +(-1.000)*rk(233)    *y(lNO3)
          JAC(lSULF,lOH  )= +(-1.000)*rk( 52)    *y(lSO2)
     &                      +(-1.000)*rk(232)    *y(lDMS)*O2
          JAC(lSULF,lSO2 )= +(-1.000)*rk( 52)    *y(lOH)
     &                      +(-1.000)*rk(230)*flg
          JAC(lSULF,lDMS )= +(-1.000)*rk(232)    *y(lOH)*O2
          JAC(lC2O3,lNO2 )= +         rk( 54)    *y(lC2O3)
          JAC(lC2O3,lNO  )= +         rk( 53)    *y(lC2O3)
          JAC(lC2O3,lO3  )= +(-0.143)*rk(152)    *y(lISPD)
     &                      +(-0.600)*rk(191)    *y(lXOPN)
     &                      +(-0.120)*rk(195)    *y(lOPEN)
          JAC(lC2O3,lNO3 )= +(-1.000)*rk(105)    *y(lALD2)
     &                      +(-1.000)*rk(112)    *y(lGLYD)
     &                      +(-1.000)*rk(117)    *y(lMGLY)
          JAC(lC2O3,lOH  )= +(-1.000)*rk( 95)    *y(lPACD)
     &                      +(-1.000)*rk(104)    *y(lALD2)
     &                      +(-0.800)*rk(110)    *y(lGLYD)
     &                      +(-1.000)*rk(118)    *y(lMGLY)
     &                      +(-1.000)*rk(127)    *y(lACET)
     &                      +(-0.269)*rk(151)    *y(lISPD)
          JAC(lC2O3,lHO2 )= +         rk( 57)    *y(lC2O3)
          JAC(lC2O3,lC2O3)= +         rk( 53)    *y(lNO)
     &                      +         rk( 54)    *y(lNO2)
     &                      +         rk( 57)    *y(lHO2)
     &                      +         rk( 58)    *y(lRO2)
     &                      +(-1.000)*rk( 58)    *y(lRO2)
     &                      +( 4.000)*rk( 59)    *y(lC2O3)
     &                      +         rk( 60)    *y(lCXO3)
     &                      +         rk( 73)    *y(lMEO2)
     &                      +         rk( 77)    *y(lXO2H)
          JAC(lC2O3,lC2O3)=JAC(lC2O3,lC2O3)
     &                      +         rk( 81)    *y(lXO2)
     &                      +         rk( 85)    *y(lXO2N)
     &                      +         rk(146)    *y(lISO2)
     &                      +         rk(161)    *y(lEPX2)
     &                      +         rk(169)    *y(lBZO2)
     &                      +         rk(174)    *y(lTO2)
     &                      +         rk(180)    *y(lXLO2)
     &                      +         rk(203)    *y(lOPO3)
          JAC(lC2O3,lMEO2)= +         rk( 73)    *y(lC2O3)
          JAC(lC2O3,lRO2 )= +         rk( 58)    *y(lC2O3)
     &                      +(-1.000)*rk( 58)    *y(lC2O3)
          JAC(lC2O3,lPAN )= +(-1.000)*rk( 55)*flg
     &                      +(-0.600)*rk( 56)*flg
          JAC(lC2O3,lPACD)= +(-1.000)*rk( 95)    *y(lOH)
          JAC(lC2O3,lCXO3)= +         rk( 60)    *y(lC2O3)
          JAC(lC2O3,lALD2)= +(-1.000)*rk(104)    *y(lOH)
     &                      +(-1.000)*rk(105)    *y(lNO3)
          JAC(lC2O3,lXO2H)= +         rk( 77)    *y(lC2O3)
          JAC(lC2O3,lXO2 )= +         rk( 81)    *y(lC2O3)
          JAC(lC2O3,lXO2N)= +         rk( 85)    *y(lC2O3)
          JAC(lC2O3,lGLYD)= +(-0.800)*rk(110)    *y(lOH)
     &                      +(-1.000)*rk(112)    *y(lNO3)
          JAC(lC2O3,lMGLY)= +(-1.000)*rk(116)*flg
     &                      +(-1.000)*rk(117)    *y(lNO3)
     &                      +(-1.000)*rk(118)    *y(lOH)
          JAC(lC2O3,lKET )= +(-0.500)*rk(125)*flg
          JAC(lC2O3,lACET)= +(-0.620)*rk(126)*flg
     &                      +(-1.000)*rk(127)    *y(lOH)
          JAC(lC2O3,lISO2)= +         rk(146)    *y(lC2O3)
          JAC(lC2O3,lISPD)= +(-0.269)*rk(151)    *y(lOH)
     &                      +(-0.143)*rk(152)    *y(lO3)
     &                      +(-0.208)*rk(154)*flg
          JAC(lC2O3,lOPO3)= +         rk(203)    *y(lC2O3)
          JAC(lC2O3,lEPX2)= +         rk(161)    *y(lC2O3)
          JAC(lC2O3,lBZO2)= +         rk(169)    *y(lC2O3)
          JAC(lC2O3,lOPEN)= +(-0.120)*rk(195)    *y(lO3)
          JAC(lC2O3,lTO2 )= +         rk(174)    *y(lC2O3)
          JAC(lC2O3,lXOPN)= +(-0.300)*rk(189)*flg
     &                      +(-0.600)*rk(191)    *y(lO3)
          JAC(lC2O3,lXLO2)= +         rk(180)    *y(lC2O3)
          JAC(lMEO2,lNO  )= +(-1.000)*rk( 53)    *y(lC2O3)
     &                      +         rk( 71)    *y(lMEO2)
          JAC(lMEO2,lNO3 )= +(-1.000)*rk(233)    *y(lDMS)
          JAC(lMEO2,lOH  )= +(-0.600)*rk( 87)    *y(lMEPX)
     &                      +(-1.000)*rk( 94)    *y(lAACD)
     &                      +(-1.000)*rk(121)*flg*CH4
     &                      +(-0.115)*rk(151)    *y(lISPD)
     &                      +(-1.000)*rk(208)    *y(lECH4)
     &                      +(-1.000)*rk(231)    *y(lDMS)
     &                      +(-1.000)*rk(232)    *y(lDMS)*O2
          JAC(lMEO2,lHO2 )= +(-0.440)*rk( 57)    *y(lC2O3)
     &                      +         rk( 72)    *y(lMEO2)
          JAC(lMEO2,lC2O3)= +(-1.000)*rk( 53)    *y(lNO)
     &                      +(-0.440)*rk( 57)    *y(lHO2)
     &                      +(-4.000)*rk( 59)    *y(lC2O3)
     &                      +(-1.000)*rk( 60)    *y(lCXO3)
     &                      +         rk( 73)    *y(lMEO2)
     &                      +(-0.900)*rk( 73)    *y(lMEO2)
     &                      +(-0.800)*rk( 77)    *y(lXO2H)
     &                      +(-0.800)*rk( 81)    *y(lXO2)
     &                      +(-0.800)*rk( 85)    *y(lXO2N)
          JAC(lMEO2,lC2O3)=JAC(lMEO2,lC2O3)
     &                      +(-0.800)*rk(146)    *y(lISO2)
     &                      +(-0.800)*rk(161)    *y(lEPX2)
     &                      +(-1.000)*rk(169)    *y(lBZO2)
     &                      +(-1.000)*rk(174)    *y(lTO2)
     &                      +(-1.000)*rk(180)    *y(lXLO2)
     &                      +(-1.000)*rk(203)    *y(lOPO3)
          JAC(lMEO2,lMEO2)= +         rk( 71)    *y(lNO)
     &                      +         rk( 72)    *y(lHO2)
     &                      +         rk( 73)    *y(lC2O3)
     &                      +(-0.900)*rk( 73)    *y(lC2O3)
     &                      +         rk( 74)    *y(lRO2)
          JAC(lMEO2,lRO2 )= +         rk( 74)    *y(lMEO2)
          JAC(lMEO2,lPAN )= +(-0.400)*rk( 56)*flg
          JAC(lMEO2,lAACD)= +(-1.000)*rk( 94)    *y(lOH)
          JAC(lMEO2,lCXO3)= +(-1.000)*rk( 60)    *y(lC2O3)
          JAC(lMEO2,lALD2)= +(-1.000)*rk(106)*flg
          JAC(lMEO2,lXO2H)= +(-0.800)*rk( 77)    *y(lC2O3)
          JAC(lMEO2,lMEPX)= +(-0.600)*rk( 87)    *y(lOH)
     &                      +(-1.000)*rk( 88)*flg
          JAC(lMEO2,lXO2 )= +(-0.800)*rk( 81)    *y(lC2O3)
          JAC(lMEO2,lXO2N)= +(-0.800)*rk( 85)    *y(lC2O3)
          JAC(lMEO2,lKET )= +(-0.500)*rk(125)*flg
          JAC(lMEO2,lACET)= +(-1.380)*rk(126)*flg
          JAC(lMEO2,lISO2)= +(-0.800)*rk(146)    *y(lC2O3)
          JAC(lMEO2,lISPD)= +(-0.115)*rk(151)    *y(lOH)
     &                      +(-0.340)*rk(154)*flg
          JAC(lMEO2,lOPO3)= +(-1.000)*rk(203)    *y(lC2O3)
          JAC(lMEO2,lEPX2)= +(-0.800)*rk(161)    *y(lC2O3)
          JAC(lMEO2,lBZO2)= +(-1.000)*rk(169)    *y(lC2O3)
          JAC(lMEO2,lTO2 )= +(-1.000)*rk(174)    *y(lC2O3)
          JAC(lMEO2,lXLO2)= +(-1.000)*rk(180)    *y(lC2O3)
          JAC(lMEO2,lECH4)= +(-1.000)*rk(208)    *y(lOH)
          JAC(lMEO2,lDMS )= +(-1.000)*rk(231)    *y(lOH)
     &                      +(-1.000)*rk(232)    *y(lOH)*O2
     &                      +(-1.000)*rk(233)    *y(lNO3)
          JAC(lRO2 ,lNO  )= +(-1.000)*rk( 53)    *y(lC2O3)
     &                      +(-1.000)*rk( 61)    *y(lCXO3)
     &                      +         rk( 68)    *y(lRO2)
     &                      +(-0.082)*rk(144)    *y(lISO2)
          JAC(lRO2 ,lO3  )= +(-0.150)*rk(138)    *y(lOLE)
     &                      +(-0.300)*rk(141)    *y(lIOLE)
     &                      +(-0.200)*rk(149)    *y(lISOP)
     &                      +(-0.940)*rk(165)    *y(lTERP)
     &                      +(-0.300)*rk(191)    *y(lXOPN)
          JAC(lRO2 ,lNO3 )= +(-0.500)*rk(115)    *y(lGLY)
     &                      +(-1.000)*rk(117)    *y(lMGLY)
     &                      +(-1.000)*rk(136)    *y(lETH)
     &                      +(-1.000)*rk(139)    *y(lOLE)
     &                      +(-1.000)*rk(142)    *y(lIOLE)
     &                      +(-1.000)*rk(150)    *y(lISOP)
     &                      +(-0.284)*rk(153)    *y(lISPD)
     &                      +(-1.280)*rk(166)    *y(lTERP)
     &                      +(-0.700)*rk(183)    *y(lCRES)
          JAC(lRO2 ,lNO3 )=JAC(lRO2 ,lNO3 )
     &                      +(-1.000)*rk(192)    *y(lXOPN)
          JAC(lRO2 ,lOH  )= +(-0.600)*rk( 87)    *y(lMEPX)
     &                      +(-0.600)*rk( 89)    *y(lROOH)
     &                      +(-1.000)*rk( 94)    *y(lAACD)
     &                      +(-0.200)*rk(113)    *y(lGLY)
     &                      +(-1.000)*rk(121)*flg*CH4
     &                      +(-1.000)*rk(122)    *y(lETHA)
     &                      +(-0.100)*rk(124)    *y(lETOH)
     &                      +(-1.000)*rk(127)    *y(lACET)
     &                      +(-1.000)*rk(134)    *y(lETH)
          JAC(lRO2 ,lOH  )=JAC(lRO2 ,lOH  )
     &                      +(-1.195)*rk(137)    *y(lOLE)
     &                      +(-1.000)*rk(140)    *y(lIOLE)
     &                      +(-1.000)*rk(143)    *y(lISOP)
     &                      +(-0.658)*rk(151)    *y(lISPD)
     &                      +(-0.067)*rk(155)    *y(lISPX)
     &                      +(-1.000)*rk(158)    *y(lEPOX)
     &                      +(-1.000)*rk(163)    *y(lINTR)
     &                      +(-1.500)*rk(164)    *y(lTERP)
          JAC(lRO2 ,lOH  )=JAC(lRO2 ,lOH  )
     &                      +(-0.352)*rk(167)    *y(lBENZ)
     &                      +(-0.720)*rk(172)    *y(lTOL)
     &                      +(-0.602)*rk(177)    *y(lXYL)
     &                      +(-0.020)*rk(182)    *y(lCRES)
     &                      +(-2.000)*rk(190)    *y(lXOPN)
     &                      +(-0.400)*rk(194)    *y(lOPEN)
     &                      +(-1.000)*rk(208)    *y(lECH4)
          JAC(lRO2 ,lHO2 )= +(-0.440)*rk( 57)    *y(lC2O3)
     &                      +(-0.440)*rk( 65)    *y(lCXO3)
     &                      +         rk( 69)    *y(lRO2)
     &                      +(-0.440)*rk(202)    *y(lOPO3)
          JAC(lRO2 ,lC2O3)= +(-1.000)*rk( 53)    *y(lNO)
     &                      +(-0.440)*rk( 57)    *y(lHO2)
     &                      +         rk( 58)    *y(lRO2)
     &                      +(-4.000)*rk( 59)    *y(lC2O3)
     &                      +(-2.000)*rk( 60)    *y(lCXO3)
     &                      +(-0.900)*rk( 73)    *y(lMEO2)
     &                      +(-0.800)*rk( 77)    *y(lXO2H)
     &                      +(-0.800)*rk( 81)    *y(lXO2)
     &                      +(-0.800)*rk( 85)    *y(lXO2N)
          JAC(lRO2 ,lC2O3)=JAC(lRO2 ,lC2O3)
     &                      +(-0.872)*rk(146)    *y(lISO2)
     &                      +(-0.800)*rk(161)    *y(lEPX2)
     &                      +(-1.000)*rk(169)    *y(lBZO2)
     &                      +(-1.000)*rk(174)    *y(lTO2)
     &                      +(-1.000)*rk(180)    *y(lXLO2)
     &                      +(-2.000)*rk(203)    *y(lOPO3)
          JAC(lRO2 ,lMEO2)= +(-0.900)*rk( 73)    *y(lC2O3)
     &                      +         rk( 74)    *y(lRO2)
     &                      +(-1.000)*rk( 74)    *y(lRO2)
          JAC(lRO2 ,lRO2 )= +         rk( 58)    *y(lC2O3)
     &                      +         rk( 66)    *y(lCXO3)
     &                      +(-0.800)*rk( 66)    *y(lCXO3)
     &                      +         rk( 68)    *y(lNO)
     &                      +         rk( 69)    *y(lHO2)
     &                      +( 4.000)*rk( 70)    *y(lRO2)
     &                      +         rk( 74)    *y(lMEO2)
     &                      +(-1.000)*rk( 74)    *y(lMEO2)
     &                      +         rk( 78)    *y(lXO2H)
          JAC(lRO2 ,lRO2 )=JAC(lRO2 ,lRO2 )
     &                      +(-1.000)*rk( 78)    *y(lXO2H)
     &                      +         rk( 82)    *y(lXO2)
     &                      +(-1.000)*rk( 82)    *y(lXO2)
     &                      +         rk( 86)    *y(lXO2N)
     &                      +(-1.000)*rk( 86)    *y(lXO2N)
     &                      +         rk(147)    *y(lISO2)
     &                      +(-1.072)*rk(147)    *y(lISO2)
     &                      +         rk(162)    *y(lEPX2)
          JAC(lRO2 ,lRO2 )=JAC(lRO2 ,lRO2 )
     &                      +(-1.000)*rk(162)    *y(lEPX2)
     &                      +         rk(171)    *y(lBZO2)
     &                      +(-1.000)*rk(171)    *y(lBZO2)
     &                      +         rk(176)    *y(lTO2)
     &                      +(-1.000)*rk(176)    *y(lTO2)
     &                      +         rk(181)    *y(lXLO2)
     &                      +(-1.000)*rk(181)    *y(lXLO2)
     &                      +         rk(204)    *y(lOPO3)
          JAC(lRO2 ,lRO2 )=JAC(lRO2 ,lRO2 )
     &                      +(-1.800)*rk(204)    *y(lOPO3)
          JAC(lRO2 ,lPAN )= +(-0.400)*rk( 56)*flg
          JAC(lRO2 ,lAACD)= +(-1.000)*rk( 94)    *y(lOH)
          JAC(lRO2 ,lCXO3)= +(-2.000)*rk( 60)    *y(lC2O3)
     &                      +(-1.000)*rk( 61)    *y(lNO)
     &                      +(-0.440)*rk( 65)    *y(lHO2)
     &                      +         rk( 66)    *y(lRO2)
     &                      +(-0.800)*rk( 66)    *y(lRO2)
     &                      +(-4.000)*rk( 67)    *y(lCXO3)
          JAC(lRO2 ,lALD2)= +(-1.000)*rk(106)*flg
          JAC(lRO2 ,lXO2H)= +(-0.800)*rk( 77)    *y(lC2O3)
     &                      +         rk( 78)    *y(lRO2)
     &                      +(-1.000)*rk( 78)    *y(lRO2)
          JAC(lRO2 ,lPANX)= +(-0.400)*rk( 64)*flg
          JAC(lRO2 ,lMEPX)= +(-0.600)*rk( 87)    *y(lOH)
     &                      +(-1.000)*rk( 88)*flg
          JAC(lRO2 ,lROOH)= +(-0.600)*rk( 89)    *y(lOH)
          JAC(lRO2 ,lXO2 )= +(-0.800)*rk( 81)    *y(lC2O3)
     &                      +         rk( 82)    *y(lRO2)
     &                      +(-1.000)*rk( 82)    *y(lRO2)
          JAC(lRO2 ,lXO2N)= +(-0.800)*rk( 85)    *y(lC2O3)
     &                      +         rk( 86)    *y(lRO2)
     &                      +(-1.000)*rk( 86)    *y(lRO2)
          JAC(lRO2 ,lALDX)= +(-1.000)*rk(109)*flg
          JAC(lRO2 ,lGLYD)= +(-0.110)*rk(111)*flg
          JAC(lRO2 ,lGLY )= +(-0.200)*rk(113)    *y(lOH)
     &                      +(-0.500)*rk(115)    *y(lNO3)
          JAC(lRO2 ,lMGLY)= +(-1.000)*rk(117)    *y(lNO3)
          JAC(lRO2 ,lETHA)= +(-1.000)*rk(122)    *y(lOH)
          JAC(lRO2 ,lETOH)= +(-0.100)*rk(124)    *y(lOH)
          JAC(lRO2 ,lKET )= +(-1.000)*rk(125)*flg
          JAC(lRO2 ,lACET)= +(-1.380)*rk(126)*flg
     &                      +(-1.000)*rk(127)    *y(lOH)
          JAC(lRO2 ,lXPRP)= +(-1.000)*rk(225)*flg
     &                      +(-1.000)*rk(226)*flg
          JAC(lRO2 ,lXPAR)= +(-1.000)*rk(227)*flg
     &                      +(-1.000)*rk(228)*flg
          JAC(lRO2 ,lROR )= +(-0.980)*rk(130)*flg
          JAC(lRO2 ,lETH )= +(-1.000)*rk(134)    *y(lOH)
     &                      +(-1.000)*rk(136)    *y(lNO3)
          JAC(lRO2 ,lOLE )= +(-1.195)*rk(137)    *y(lOH)
     &                      +(-0.150)*rk(138)    *y(lO3)
     &                      +(-1.000)*rk(139)    *y(lNO3)
          JAC(lRO2 ,lIOLE)= +(-1.000)*rk(140)    *y(lOH)
     &                      +(-0.300)*rk(141)    *y(lO3)
     &                      +(-1.000)*rk(142)    *y(lNO3)
          JAC(lRO2 ,lISOP)= +(-1.000)*rk(143)    *y(lOH)
     &                      +(-0.200)*rk(149)    *y(lO3)
     &                      +(-1.000)*rk(150)    *y(lNO3)
          JAC(lRO2 ,lISO2)= +(-0.082)*rk(144)    *y(lNO)
     &                      +(-0.872)*rk(146)    *y(lC2O3)
     &                      +         rk(147)    *y(lRO2)
     &                      +(-1.072)*rk(147)    *y(lRO2)
          JAC(lRO2 ,lINTR)= +(-1.000)*rk(163)    *y(lOH)
          JAC(lRO2 ,lISPD)= +(-0.658)*rk(151)    *y(lOH)
     &                      +(-0.284)*rk(153)    *y(lNO3)
     &                      +(-0.840)*rk(154)*flg
          JAC(lRO2 ,lISPX)= +(-0.067)*rk(155)    *y(lOH)
          JAC(lRO2 ,lOPO3)= +(-0.440)*rk(202)    *y(lHO2)
     &                      +(-2.000)*rk(203)    *y(lC2O3)
     &                      +         rk(204)    *y(lRO2)
     &                      +(-1.800)*rk(204)    *y(lRO2)
          JAC(lRO2 ,lEPOX)= +(-1.000)*rk(158)    *y(lOH)
          JAC(lRO2 ,lEPX2)= +(-0.800)*rk(161)    *y(lC2O3)
     &                      +         rk(162)    *y(lRO2)
     &                      +(-1.000)*rk(162)    *y(lRO2)
          JAC(lRO2 ,lTERP)= +(-1.500)*rk(164)    *y(lOH)
     &                      +(-0.940)*rk(165)    *y(lO3)
     &                      +(-1.280)*rk(166)    *y(lNO3)
          JAC(lRO2 ,lBENZ)= +(-0.352)*rk(167)    *y(lOH)
          JAC(lRO2 ,lCRES)= +(-0.020)*rk(182)    *y(lOH)
     &                      +(-0.700)*rk(183)    *y(lNO3)
          JAC(lRO2 ,lBZO2)= +(-1.000)*rk(169)    *y(lC2O3)
     &                      +         rk(171)    *y(lRO2)
     &                      +(-1.000)*rk(171)    *y(lRO2)
          JAC(lRO2 ,lOPEN)= +(-0.400)*rk(194)    *y(lOH)
          JAC(lRO2 ,lTOL )= +(-0.720)*rk(172)    *y(lOH)
          JAC(lRO2 ,lTO2 )= +(-1.000)*rk(174)    *y(lC2O3)
     &                      +         rk(176)    *y(lRO2)
     &                      +(-1.000)*rk(176)    *y(lRO2)
          JAC(lRO2 ,lXOPN)= +(-2.000)*rk(190)    *y(lOH)
     &                      +(-0.300)*rk(191)    *y(lO3)
     &                      +(-1.000)*rk(192)    *y(lNO3)
          JAC(lRO2 ,lXYL )= +(-0.602)*rk(177)    *y(lOH)
          JAC(lRO2 ,lXLO2)= +(-1.000)*rk(180)    *y(lC2O3)
     &                      +         rk(181)    *y(lRO2)
     &                      +(-1.000)*rk(181)    *y(lRO2)
          JAC(lRO2 ,lECH4)= +(-1.000)*rk(208)    *y(lOH)
          JAC(lPAN ,lNO2 )= +(-1.000)*rk( 54)    *y(lC2O3)
          JAC(lPAN ,lC2O3)= +(-1.000)*rk( 54)    *y(lNO2)
          JAC(lPAN ,lPAN )= +         rk( 55)*flg
     &                      +         rk( 56)*flg
          JAC(lPACD,lOH  )= +         rk( 95)    *y(lPACD)
          JAC(lPACD,lHO2 )= +(-0.410)*rk( 57)    *y(lC2O3)
     &                      +(-0.410)*rk( 65)    *y(lCXO3)
     &                      +(-0.410)*rk(202)    *y(lOPO3)
          JAC(lPACD,lC2O3)= +(-0.410)*rk( 57)    *y(lHO2)
          JAC(lPACD,lPACD)= +         rk( 95)    *y(lOH)
          JAC(lPACD,lCXO3)= +(-0.410)*rk( 65)    *y(lHO2)
          JAC(lPACD,lOPO3)= +(-0.410)*rk(202)    *y(lHO2)
          JAC(lAACD,lO3  )= +(-0.130)*rk(138)    *y(lOLE)
     &                      +(-0.080)*rk(141)    *y(lIOLE)
          JAC(lAACD,lOH  )= +         rk( 94)    *y(lAACD)
          JAC(lAACD,lHO2 )= +(-0.150)*rk( 57)    *y(lC2O3)
     &                      +(-0.150)*rk( 65)    *y(lCXO3)
     &                      +(-0.150)*rk(202)    *y(lOPO3)
          JAC(lAACD,lC2O3)= +(-0.150)*rk( 57)    *y(lHO2)
     &                      +(-0.100)*rk( 73)    *y(lMEO2)
     &                      +(-0.200)*rk( 77)    *y(lXO2H)
     &                      +(-0.200)*rk( 81)    *y(lXO2)
     &                      +(-0.200)*rk( 85)    *y(lXO2N)
     &                      +(-0.200)*rk(146)    *y(lISO2)
     &                      +(-0.200)*rk(161)    *y(lEPX2)
          JAC(lAACD,lMEO2)= +(-0.100)*rk( 73)    *y(lC2O3)
          JAC(lAACD,lRO2 )= +(-0.200)*rk(204)    *y(lOPO3)
          JAC(lAACD,lAACD)= +         rk( 94)    *y(lOH)
          JAC(lAACD,lCXO3)= +(-0.150)*rk( 65)    *y(lHO2)
          JAC(lAACD,lXO2H)= +(-0.200)*rk( 77)    *y(lC2O3)
          JAC(lAACD,lXO2 )= +(-0.200)*rk( 81)    *y(lC2O3)
          JAC(lAACD,lXO2N)= +(-0.200)*rk( 85)    *y(lC2O3)
          JAC(lAACD,lOLE )= +(-0.130)*rk(138)    *y(lO3)
          JAC(lAACD,lIOLE)= +(-0.080)*rk(141)    *y(lO3)
          JAC(lAACD,lISO2)= +(-0.200)*rk(146)    *y(lC2O3)
          JAC(lAACD,lOPO3)= +(-0.150)*rk(202)    *y(lHO2)
     &                      +(-0.200)*rk(204)    *y(lRO2)
          JAC(lAACD,lEPX2)= +(-0.200)*rk(161)    *y(lC2O3)
          JAC(lCXO3,lNO2 )= +         rk( 62)    *y(lCXO3)
          JAC(lCXO3,lNO  )= +         rk( 61)    *y(lCXO3)
     &                      +(-0.200)*rk(199)    *y(lOPO3)
          JAC(lCXO3,lO3  )= +(-0.200)*rk(149)    *y(lISOP)
     &                      +(-0.390)*rk(165)    *y(lTERP)
          JAC(lCXO3,lNO3 )= +(-1.000)*rk(108)    *y(lALDX)
     &                      +(-0.717)*rk(153)    *y(lISPD)
          JAC(lCXO3,lOH  )= +(-1.000)*rk(107)    *y(lALDX)
          JAC(lCXO3,lHO2 )= +         rk( 65)    *y(lCXO3)
          JAC(lCXO3,lC2O3)= +         rk( 60)    *y(lCXO3)
          JAC(lCXO3,lRO2 )= +         rk( 66)    *y(lCXO3)
          JAC(lCXO3,lCXO3)= +         rk( 60)    *y(lC2O3)
     &                      +         rk( 61)    *y(lNO)
     &                      +         rk( 62)    *y(lNO2)
     &                      +         rk( 65)    *y(lHO2)
     &                      +         rk( 66)    *y(lRO2)
     &                      +( 4.000)*rk( 67)    *y(lCXO3)
          JAC(lCXO3,lPANX)= +(-1.000)*rk( 63)*flg
     &                      +(-0.600)*rk( 64)*flg
          JAC(lCXO3,lALDX)= +(-1.000)*rk(107)    *y(lOH)
     &                      +(-1.000)*rk(108)    *y(lNO3)
          JAC(lCXO3,lKET )= +(-0.500)*rk(125)*flg
          JAC(lCXO3,lISOP)= +(-0.200)*rk(149)    *y(lO3)
          JAC(lCXO3,lISPD)= +(-0.717)*rk(153)    *y(lNO3)
          JAC(lCXO3,lOPO3)= +(-0.200)*rk(199)    *y(lNO)
          JAC(lCXO3,lTERP)= +(-0.390)*rk(165)    *y(lO3)
          JAC(lALD2,lNO  )= +(-1.000)*rk( 61)    *y(lCXO3)
          JAC(lALD2,lO3  )= +(-0.295)*rk(138)    *y(lOLE)
     &                      +(-0.732)*rk(141)    *y(lIOLE)
     &                      +(-0.040)*rk(152)    *y(lISPD)
     &                      +(-0.100)*rk(191)    *y(lXOPN)
     &                      +(-0.020)*rk(195)    *y(lOPEN)
          JAC(lALD2,lNO3 )= +         rk(105)    *y(lALD2)
     &                      +(-0.250)*rk(139)    *y(lOLE)
     &                      +(-0.500)*rk(142)    *y(lIOLE)
          JAC(lALD2,lOH  )= +         rk(104)    *y(lALD2)
     &                      +(-0.991)*rk(122)    *y(lETHA)
     &                      +(-0.950)*rk(124)    *y(lETOH)
     &                      +(-0.488)*rk(137)    *y(lOLE)
     &                      +(-1.300)*rk(140)    *y(lIOLE)
     &                      +(-1.000)*rk(206)    *y(lPANX)
          JAC(lALD2,lHO2 )= +(-0.440)*rk( 65)    *y(lCXO3)
          JAC(lALD2,lC2O3)= +(-1.000)*rk( 60)    *y(lCXO3)
          JAC(lALD2,lRO2 )= +(-0.800)*rk( 66)    *y(lCXO3)
          JAC(lALD2,lCXO3)= +(-1.000)*rk( 60)    *y(lC2O3)
     &                      +(-1.000)*rk( 61)    *y(lNO)
     &                      +(-0.440)*rk( 65)    *y(lHO2)
     &                      +(-0.800)*rk( 66)    *y(lRO2)
     &                      +(-4.000)*rk( 67)    *y(lCXO3)
          JAC(lALD2,lALD2)= +         rk(104)    *y(lOH)
     &                      +         rk(105)    *y(lNO3)
     &                      +         rk(106)*flg
          JAC(lALD2,lPANX)= +(-0.400)*rk( 64)*flg
     &                      +(-1.000)*rk(206)    *y(lOH)
          JAC(lALD2,lALDX)= +(-1.000)*rk(109)*flg
          JAC(lALD2,lETHA)= +(-0.991)*rk(122)    *y(lOH)
          JAC(lALD2,lETOH)= +(-0.950)*rk(124)    *y(lOH)
          JAC(lALD2,lKET )= +(-0.500)*rk(125)*flg
          JAC(lALD2,lROR )= +(-0.740)*rk(130)*flg
          JAC(lALD2,lOLE )= +(-0.488)*rk(137)    *y(lOH)
     &                      +(-0.295)*rk(138)    *y(lO3)
     &                      +(-0.250)*rk(139)    *y(lNO3)
          JAC(lALD2,lIOLE)= +(-1.300)*rk(140)    *y(lOH)
     &                      +(-0.732)*rk(141)    *y(lO3)
     &                      +(-0.500)*rk(142)    *y(lNO3)
          JAC(lALD2,lISPD)= +(-0.040)*rk(152)    *y(lO3)
          JAC(lALD2,lOPEN)= +(-0.020)*rk(195)    *y(lO3)
          JAC(lALD2,lXOPN)= +(-0.100)*rk(191)    *y(lO3)
          JAC(lXO2H,lNO  )= +(-1.000)*rk( 61)    *y(lCXO3)
     &                      +         rk( 75)    *y(lXO2H)
     &                      +(-0.082)*rk(144)    *y(lISO2)
          JAC(lXO2H,lO3  )= +(-0.150)*rk(138)    *y(lOLE)
     &                      +(-0.300)*rk(141)    *y(lIOLE)
     &                      +(-0.070)*rk(165)    *y(lTERP)
     &                      +(-0.300)*rk(191)    *y(lXOPN)
          JAC(lXO2H,lNO3 )= +(-0.500)*rk(136)    *y(lETH)
     &                      +(-0.480)*rk(139)    *y(lOLE)
     &                      +(-0.480)*rk(142)    *y(lIOLE)
     &                      +(-0.640)*rk(150)    *y(lISOP)
     &                      +(-0.142)*rk(153)    *y(lISPD)
     &                      +(-0.280)*rk(166)    *y(lTERP)
     &                      +(-0.120)*rk(183)    *y(lCRES)
     &                      +(-0.450)*rk(192)    *y(lXOPN)
          JAC(lXO2H,lOH  )= +(-0.540)*rk( 89)    *y(lROOH)
     &                      +(-0.991)*rk(122)    *y(lETHA)
     &                      +(-0.100)*rk(124)    *y(lETOH)
     &                      +(-1.000)*rk(134)    *y(lETH)
     &                      +(-0.976)*rk(137)    *y(lOLE)
     &                      +(-1.000)*rk(140)    *y(lIOLE)
     &                      +(-0.370)*rk(163)    *y(lINTR)
     &                      +(-0.750)*rk(164)    *y(lTERP)
     &                      +(-0.070)*rk(172)    *y(lTOL)
          JAC(lXO2H,lOH  )=JAC(lXO2H,lOH  )
     &                      +(-0.058)*rk(177)    *y(lXYL)
     &                      +(-2.000)*rk(190)    *y(lXOPN)
     &                      +(-0.400)*rk(194)    *y(lOPEN)
          JAC(lXO2H,lHO2 )= +(-0.440)*rk( 65)    *y(lCXO3)
     &                      +         rk( 76)    *y(lXO2H)
     &                      +(-0.440)*rk(202)    *y(lOPO3)
          JAC(lXO2H,lC2O3)= +(-1.000)*rk( 60)    *y(lCXO3)
     &                      +         rk( 77)    *y(lXO2H)
     &                      +(-0.072)*rk(146)    *y(lISO2)
          JAC(lXO2H,lRO2 )= +(-0.800)*rk( 66)    *y(lCXO3)
     &                      +         rk( 78)    *y(lXO2H)
     &                      +(-0.072)*rk(147)    *y(lISO2)
     &                      +(-0.800)*rk(204)    *y(lOPO3)
          JAC(lXO2H,lCXO3)= +(-1.000)*rk( 60)    *y(lC2O3)
     &                      +(-1.000)*rk( 61)    *y(lNO)
     &                      +(-0.440)*rk( 65)    *y(lHO2)
     &                      +(-0.800)*rk( 66)    *y(lRO2)
     &                      +(-4.000)*rk( 67)    *y(lCXO3)
          JAC(lXO2H,lXO2H)= +         rk( 75)    *y(lNO)
     &                      +         rk( 76)    *y(lHO2)
     &                      +         rk( 77)    *y(lC2O3)
     &                      +         rk( 78)    *y(lRO2)
          JAC(lXO2H,lPANX)= +(-0.400)*rk( 64)*flg
          JAC(lXO2H,lROOH)= +(-0.540)*rk( 89)    *y(lOH)
          JAC(lXO2H,lALDX)= +(-1.000)*rk(109)*flg
          JAC(lXO2H,lGLYD)= +(-0.110)*rk(111)*flg
          JAC(lXO2H,lETHA)= +(-0.991)*rk(122)    *y(lOH)
          JAC(lXO2H,lETOH)= +(-0.100)*rk(124)    *y(lOH)
          JAC(lXO2H,lKET )= +(-0.500)*rk(125)*flg
          JAC(lXO2H,lXPRP)= +(-1.000)*rk(226)*flg
          JAC(lXO2H,lXPAR)= +(-0.126)*rk(228)*flg
          JAC(lXO2H,lROR )= +(-0.940)*rk(130)*flg
          JAC(lXO2H,lETH )= +(-1.000)*rk(134)    *y(lOH)
     &                      +(-0.500)*rk(136)    *y(lNO3)
          JAC(lXO2H,lOLE )= +(-0.976)*rk(137)    *y(lOH)
     &                      +(-0.150)*rk(138)    *y(lO3)
     &                      +(-0.480)*rk(139)    *y(lNO3)
          JAC(lXO2H,lIOLE)= +(-1.000)*rk(140)    *y(lOH)
     &                      +(-0.300)*rk(141)    *y(lO3)
     &                      +(-0.480)*rk(142)    *y(lNO3)
          JAC(lXO2H,lISOP)= +(-0.640)*rk(150)    *y(lNO3)
          JAC(lXO2H,lISO2)= +(-0.082)*rk(144)    *y(lNO)
     &                      +(-0.072)*rk(146)    *y(lC2O3)
     &                      +(-0.072)*rk(147)    *y(lRO2)
          JAC(lXO2H,lINTR)= +(-0.370)*rk(163)    *y(lOH)
          JAC(lXO2H,lISPD)= +(-0.142)*rk(153)    *y(lNO3)
     &                      +(-0.340)*rk(154)*flg
          JAC(lXO2H,lOPO3)= +(-0.440)*rk(202)    *y(lHO2)
     &                      +(-0.800)*rk(204)    *y(lRO2)
          JAC(lXO2H,lTERP)= +(-0.750)*rk(164)    *y(lOH)
     &                      +(-0.070)*rk(165)    *y(lO3)
     &                      +(-0.280)*rk(166)    *y(lNO3)
          JAC(lXO2H,lCRES)= +(-0.120)*rk(183)    *y(lNO3)
          JAC(lXO2H,lOPEN)= +(-0.400)*rk(194)    *y(lOH)
          JAC(lXO2H,lTOL )= +(-0.070)*rk(172)    *y(lOH)
          JAC(lXO2H,lXOPN)= +(-1.000)*rk(189)*flg
     &                      +(-2.000)*rk(190)    *y(lOH)
     &                      +(-0.300)*rk(191)    *y(lO3)
     &                      +(-0.450)*rk(192)    *y(lNO3)
          JAC(lXO2H,lXYL )= +(-0.058)*rk(177)    *y(lOH)
          JAC(lPANX,lNO2 )= +(-1.000)*rk( 62)    *y(lCXO3)
          JAC(lPANX,lOH  )= +         rk(206)    *y(lPANX)
          JAC(lPANX,lCXO3)= +(-1.000)*rk( 62)    *y(lNO2)
          JAC(lPANX,lPANX)= +         rk( 63)*flg
     &                      +         rk( 64)*flg
     &                      +         rk(206)    *y(lOH)
          JAC(lFORM,lNO  )= +(-1.000)*rk( 71)    *y(lMEO2)
     &                      +(-0.673)*rk(144)    *y(lISO2)
     &                      +(-0.375)*rk(160)    *y(lEPX2)
          JAC(lFORM,lO3  )= +(-1.000)*rk(135)    *y(lETH)
     &                      +(-0.555)*rk(138)    *y(lOLE)
     &                      +(-0.128)*rk(141)    *y(lIOLE)
     &                      +(-0.600)*rk(149)    *y(lISOP)
     &                      +(-0.231)*rk(152)    *y(lISPD)
     &                      +(-0.240)*rk(165)    *y(lTERP)
     &                      +(-0.080)*rk(195)    *y(lOPEN)
          JAC(lFORM,lNO3 )= +         rk( 99)    *y(lFORM)
     &                      +(-1.125)*rk(136)    *y(lETH)
     &                      +(-0.500)*rk(139)    *y(lOLE)
     &                      +(-0.350)*rk(150)    *y(lISOP)
     &                      +(-1.000)*rk(233)    *y(lDMS)
          JAC(lFORM,lOH  )= +(-0.400)*rk( 87)    *y(lMEPX)
     &                      +         rk( 96)    *y(lFORM)
     &                      +(-1.000)*rk(123)    *y(lMEOH)
     &                      +(-0.078)*rk(124)    *y(lETOH)
     &                      +(-1.000)*rk(127)    *y(lACET)
     &                      +(-1.560)*rk(134)    *y(lETH)
     &                      +(-0.781)*rk(137)    *y(lOLE)
     &                      +(-0.592)*rk(163)    *y(lINTR)
     &                      +(-0.280)*rk(164)    *y(lTERP)
          JAC(lFORM,lOH  )=JAC(lFORM,lOH  )
     &                      +(-0.140)*rk(197)    *y(lCAT1)
     &                      +(-1.000)*rk(231)    *y(lDMS)
          JAC(lFORM,lHO2 )= +(-0.100)*rk( 72)    *y(lMEO2)
     &                      +         rk(100)    *y(lFORM)
     &                      +(-0.120)*rk(145)    *y(lISO2)
     &                      +(-0.375)*rk(159)    *y(lEPX2)
          JAC(lFORM,lC2O3)= +(-1.000)*rk( 73)    *y(lMEO2)
     &                      +(-0.598)*rk(146)    *y(lISO2)
     &                      +(-0.300)*rk(161)    *y(lEPX2)
          JAC(lFORM,lMEO2)= +(-1.000)*rk( 71)    *y(lNO)
     &                      +(-0.100)*rk( 72)    *y(lHO2)
     &                      +(-1.000)*rk( 73)    *y(lC2O3)
     &                      +(-0.685)*rk( 74)    *y(lRO2)
          JAC(lFORM,lRO2 )= +(-0.685)*rk( 74)    *y(lMEO2)
     &                      +(-0.598)*rk(147)    *y(lISO2)
     &                      +(-0.375)*rk(162)    *y(lEPX2)
          JAC(lFORM,lFORM)= +         rk( 96)    *y(lOH)
     &                      +         rk( 97)*flg
     &                      +         rk( 98)*flg
     &                      +         rk( 99)    *y(lNO3)
     &                      +         rk(100)    *y(lHO2)
          JAC(lFORM,lMEPX)= +(-0.400)*rk( 87)    *y(lOH)
          JAC(lFORM,lMEOH)= +(-1.000)*rk(123)    *y(lOH)
          JAC(lFORM,lHCO3)= +(-1.000)*rk(101)*flg
          JAC(lFORM,lGLYD)= +(-0.740)*rk(111)*flg
          JAC(lFORM,lETOH)= +(-0.078)*rk(124)    *y(lOH)
          JAC(lFORM,lACET)= +(-1.000)*rk(127)    *y(lOH)
          JAC(lFORM,lETH )= +(-1.560)*rk(134)    *y(lOH)
     &                      +(-1.000)*rk(135)    *y(lO3)
     &                      +(-1.125)*rk(136)    *y(lNO3)
          JAC(lFORM,lOLE )= +(-0.781)*rk(137)    *y(lOH)
     &                      +(-0.555)*rk(138)    *y(lO3)
     &                      +(-0.500)*rk(139)    *y(lNO3)
          JAC(lFORM,lIOLE)= +(-0.128)*rk(141)    *y(lO3)
          JAC(lFORM,lISOP)= +(-0.600)*rk(149)    *y(lO3)
     &                      +(-0.350)*rk(150)    *y(lNO3)
          JAC(lFORM,lISO2)= +(-0.673)*rk(144)    *y(lNO)
     &                      +(-0.120)*rk(145)    *y(lHO2)
     &                      +(-0.598)*rk(146)    *y(lC2O3)
     &                      +(-0.598)*rk(147)    *y(lRO2)
          JAC(lFORM,lINTR)= +(-0.592)*rk(163)    *y(lOH)
          JAC(lFORM,lISPD)= +(-0.231)*rk(152)    *y(lO3)
     &                      +(-0.260)*rk(154)*flg
          JAC(lFORM,lEPX2)= +(-0.375)*rk(159)    *y(lHO2)
     &                      +(-0.375)*rk(160)    *y(lNO)
     &                      +(-0.300)*rk(161)    *y(lC2O3)
     &                      +(-0.375)*rk(162)    *y(lRO2)
          JAC(lFORM,lTERP)= +(-0.280)*rk(164)    *y(lOH)
     &                      +(-0.240)*rk(165)    *y(lO3)
          JAC(lFORM,lOPEN)= +(-0.080)*rk(195)    *y(lO3)
          JAC(lFORM,lCAT1)= +(-0.140)*rk(197)    *y(lOH)
          JAC(lFORM,lCRON)= +(-1.000)*rk(188)*flg
          JAC(lFORM,lDMS )= +(-1.000)*rk(231)    *y(lOH)
     &                      +(-1.000)*rk(233)    *y(lNO3)
          JAC(lMEPX,lOH  )= +         rk( 87)    *y(lMEPX)
          JAC(lMEPX,lHO2 )= +(-0.900)*rk( 72)    *y(lMEO2)
     &                      +(-0.500)*rk(103)    *y(lHCO3)
          JAC(lMEPX,lMEO2)= +(-0.900)*rk( 72)    *y(lHO2)
          JAC(lMEPX,lMEPX)= +         rk( 87)    *y(lOH)
     &                      +         rk( 88)*flg
          JAC(lMEPX,lHCO3)= +(-0.500)*rk(103)    *y(lHO2)
          JAC(lMEOH,lOH  )= +         rk(123)    *y(lMEOH)
          JAC(lMEOH,lMEO2)= +(-0.315)*rk( 74)    *y(lRO2)
          JAC(lMEOH,lRO2 )= +(-0.315)*rk( 74)    *y(lMEO2)
          JAC(lMEOH,lMEOH)= +         rk(123)    *y(lOH)
          JAC(lMEOH,lGLYD)= +(-0.150)*rk(111)*flg
          JAC(lROOH,lOH  )= +         rk( 89)    *y(lROOH)
          JAC(lROOH,lHO2 )= +(-1.000)*rk( 76)    *y(lXO2H)
     &                      +(-1.000)*rk( 80)    *y(lXO2)
     &                      +(-1.000)*rk( 84)    *y(lXO2N)
          JAC(lROOH,lXO2H)= +(-1.000)*rk( 76)    *y(lHO2)
          JAC(lROOH,lROOH)= +         rk( 89)    *y(lOH)
     &                      +         rk( 90)*flg
          JAC(lROOH,lXO2 )= +(-1.000)*rk( 80)    *y(lHO2)
          JAC(lROOH,lXO2N)= +(-1.000)*rk( 84)    *y(lHO2)
          JAC(lXO2 ,lNO  )= +         rk( 79)    *y(lXO2)
          JAC(lXO2 ,lO3  )= +(-0.200)*rk(149)    *y(lISOP)
     &                      +(-0.690)*rk(165)    *y(lTERP)
          JAC(lXO2 ,lNO3 )= +(-0.500)*rk(115)    *y(lGLY)
     &                      +(-1.000)*rk(117)    *y(lMGLY)
     &                      +(-0.500)*rk(136)    *y(lETH)
     &                      +(-0.480)*rk(139)    *y(lOLE)
     &                      +(-0.480)*rk(142)    *y(lIOLE)
     &                      +(-0.330)*rk(150)    *y(lISOP)
     &                      +(-0.142)*rk(153)    *y(lISPD)
     &                      +(-0.750)*rk(166)    *y(lTERP)
     &                      +(-0.480)*rk(183)    *y(lCRES)
          JAC(lXO2 ,lNO3 )=JAC(lXO2 ,lNO3 )
     &                      +(-0.450)*rk(192)    *y(lXOPN)
          JAC(lXO2 ,lOH  )= +(-0.200)*rk(113)    *y(lGLY)
     &                      +(-1.000)*rk(127)    *y(lACET)
     &                      +(-0.195)*rk(137)    *y(lOLE)
     &                      +(-0.521)*rk(151)    *y(lISPD)
     &                      +(-0.630)*rk(163)    *y(lINTR)
     &                      +(-0.500)*rk(164)    *y(lTERP)
          JAC(lXO2 ,lHO2 )= +         rk( 80)    *y(lXO2)
          JAC(lXO2 ,lC2O3)= +         rk( 81)    *y(lXO2)
     &                      +(-1.000)*rk(203)    *y(lOPO3)
          JAC(lXO2 ,lRO2 )= +         rk( 82)    *y(lXO2)
          JAC(lXO2 ,lXO2 )= +         rk( 79)    *y(lNO)
     &                      +         rk( 80)    *y(lHO2)
     &                      +         rk( 81)    *y(lC2O3)
     &                      +         rk( 82)    *y(lRO2)
          JAC(lXO2 ,lGLY )= +(-0.200)*rk(113)    *y(lOH)
     &                      +(-0.500)*rk(115)    *y(lNO3)
          JAC(lXO2 ,lMGLY)= +(-1.000)*rk(117)    *y(lNO3)
          JAC(lXO2 ,lACET)= +(-1.000)*rk(127)    *y(lOH)
          JAC(lXO2 ,lXPAR)= +(-0.874)*rk(228)*flg
          JAC(lXO2 ,lETH )= +(-0.500)*rk(136)    *y(lNO3)
          JAC(lXO2 ,lOLE )= +(-0.195)*rk(137)    *y(lOH)
     &                      +(-0.480)*rk(139)    *y(lNO3)
          JAC(lXO2 ,lIOLE)= +(-0.480)*rk(142)    *y(lNO3)
          JAC(lXO2 ,lISOP)= +(-0.200)*rk(149)    *y(lO3)
     &                      +(-0.330)*rk(150)    *y(lNO3)
          JAC(lXO2 ,lINTR)= +(-0.630)*rk(163)    *y(lOH)
          JAC(lXO2 ,lISPD)= +(-0.521)*rk(151)    *y(lOH)
     &                      +(-0.142)*rk(153)    *y(lNO3)
     &                      +(-0.160)*rk(154)*flg
          JAC(lXO2 ,lOPO3)= +(-1.000)*rk(203)    *y(lC2O3)
          JAC(lXO2 ,lTERP)= +(-0.500)*rk(164)    *y(lOH)
     &                      +(-0.690)*rk(165)    *y(lO3)
     &                      +(-0.750)*rk(166)    *y(lNO3)
          JAC(lXO2 ,lCRES)= +(-0.480)*rk(183)    *y(lNO3)
          JAC(lXO2 ,lXOPN)= +(-0.450)*rk(192)    *y(lNO3)
          JAC(lXO2N,lNO  )= +         rk( 83)    *y(lXO2N)
          JAC(lXO2N,lO3  )= +(-0.180)*rk(165)    *y(lTERP)
          JAC(lXO2N,lNO3 )= +(-0.040)*rk(139)    *y(lOLE)
     &                      +(-0.040)*rk(142)    *y(lIOLE)
     &                      +(-0.030)*rk(150)    *y(lISOP)
     &                      +(-0.250)*rk(166)    *y(lTERP)
     &                      +(-0.100)*rk(183)    *y(lCRES)
     &                      +(-0.100)*rk(192)    *y(lXOPN)
          JAC(lXO2N,lOH  )= +(-0.060)*rk( 89)    *y(lROOH)
     &                      +(-0.009)*rk(122)    *y(lETHA)
     &                      +(-0.024)*rk(137)    *y(lOLE)
     &                      +(-0.022)*rk(151)    *y(lISPD)
     &                      +(-0.250)*rk(164)    *y(lTERP)
     &                      +(-0.020)*rk(182)    *y(lCRES)
          JAC(lXO2N,lHO2 )= +         rk( 84)    *y(lXO2N)
          JAC(lXO2N,lC2O3)= +         rk( 85)    *y(lXO2N)
          JAC(lXO2N,lRO2 )= +         rk( 86)    *y(lXO2N)
          JAC(lXO2N,lROOH)= +(-0.060)*rk( 89)    *y(lOH)
          JAC(lXO2N,lXO2N)= +         rk( 83)    *y(lNO)
     &                      +         rk( 84)    *y(lHO2)
     &                      +         rk( 85)    *y(lC2O3)
     &                      +         rk( 86)    *y(lRO2)
          JAC(lXO2N,lETHA)= +(-0.009)*rk(122)    *y(lOH)
          JAC(lXO2N,lXPRP)= +(-1.000)*rk(225)*flg
          JAC(lXO2N,lXPAR)= +(-1.000)*rk(227)*flg
          JAC(lXO2N,lROR )= +(-0.040)*rk(130)*flg
          JAC(lXO2N,lOLE )= +(-0.024)*rk(137)    *y(lOH)
     &                      +(-0.040)*rk(139)    *y(lNO3)
          JAC(lXO2N,lIOLE)= +(-0.040)*rk(142)    *y(lNO3)
          JAC(lXO2N,lISOP)= +(-0.030)*rk(150)    *y(lNO3)
          JAC(lXO2N,lISPD)= +(-0.022)*rk(151)    *y(lOH)
          JAC(lXO2N,lTERP)= +(-0.250)*rk(164)    *y(lOH)
     &                      +(-0.180)*rk(165)    *y(lO3)
     &                      +(-0.250)*rk(166)    *y(lNO3)
          JAC(lXO2N,lCRES)= +(-0.020)*rk(182)    *y(lOH)
     &                      +(-0.100)*rk(183)    *y(lNO3)
          JAC(lXO2N,lXOPN)= +(-0.100)*rk(192)    *y(lNO3)
          JAC(lNTR1,lNO2 )= +(-1.000)*rk(132)    *y(lROR)
          JAC(lNTR1,lNO  )= +(-0.500)*rk( 83)    *y(lXO2N)
          JAC(lNTR1,lNO3 )= +(-0.500)*rk(136)    *y(lETH)
     &                      +(-0.500)*rk(139)    *y(lOLE)
     &                      +(-0.500)*rk(142)    *y(lIOLE)
          JAC(lNTR1,lOH  )= +         rk( 91)    *y(lNTR1)
          JAC(lNTR1,lXO2N)= +(-0.500)*rk( 83)    *y(lNO)
          JAC(lNTR1,lNTR1)= +         rk( 91)    *y(lOH)
     &                      +         rk( 92)*flg
          JAC(lNTR1,lROR )= +(-1.000)*rk(132)    *y(lNO2)
          JAC(lNTR1,lETH )= +(-0.500)*rk(136)    *y(lNO3)
          JAC(lNTR1,lOLE )= +(-0.500)*rk(139)    *y(lNO3)
          JAC(lNTR1,lIOLE)= +(-0.500)*rk(142)    *y(lNO3)
          JAC(lNTR2,lNO  )= +(-0.500)*rk( 83)    *y(lXO2N)
     &                      +(-0.082)*rk(168)    *y(lBZO2)
     &                      +(-0.140)*rk(173)    *y(lTO2)
     &                      +(-0.140)*rk(178)    *y(lXLO2)
          JAC(lNTR2,lNO3 )= +(-0.650)*rk(150)    *y(lISOP)
     &                      +(-0.142)*rk(153)    *y(lISPD)
     &                      +(-0.530)*rk(166)    *y(lTERP)
     &                      +(-1.000)*rk(187)    *y(lCRON)
     &                      +(-0.500)*rk(192)    *y(lXOPN)
          JAC(lNTR2,lOH  )= +(-1.000)*rk( 91)    *y(lNTR1)
     &                      +(-0.266)*rk(163)    *y(lINTR)
     &                      +(-1.000)*rk(186)    *y(lCRON)
     &                      +(-0.500)*rk(205)    *y(lOPAN)
          JAC(lNTR2,lXO2N)= +(-0.500)*rk( 83)    *y(lNO)
          JAC(lNTR2,lNTR1)= +(-1.000)*rk( 91)    *y(lOH)
          JAC(lNTR2,lNTR2)= +         rk(207)*flg
          JAC(lNTR2,lISOP)= +(-0.650)*rk(150)    *y(lNO3)
          JAC(lNTR2,lINTR)= +(-0.266)*rk(163)    *y(lOH)
          JAC(lNTR2,lISPD)= +(-0.142)*rk(153)    *y(lNO3)
          JAC(lNTR2,lTERP)= +(-0.530)*rk(166)    *y(lNO3)
          JAC(lNTR2,lBZO2)= +(-0.082)*rk(168)    *y(lNO)
          JAC(lNTR2,lTO2 )= +(-0.140)*rk(173)    *y(lNO)
          JAC(lNTR2,lXOPN)= +(-0.500)*rk(192)    *y(lNO3)
          JAC(lNTR2,lXLO2)= +(-0.140)*rk(178)    *y(lNO)
          JAC(lNTR2,lCRON)= +(-1.000)*rk(186)    *y(lOH)
     &                      +(-1.000)*rk(187)    *y(lNO3)
          JAC(lNTR2,lOPAN)= +(-0.500)*rk(205)    *y(lOH)
          JAC(lFACD,lNO  )= +(-1.000)*rk(102)    *y(lHCO3)
          JAC(lFACD,lO3  )= +(-0.370)*rk(135)    *y(lETH)
     &                      +(-0.090)*rk(138)    *y(lOLE)
     &                      +(-0.150)*rk(152)    *y(lISPD)
          JAC(lFACD,lOH  )= +         rk( 93)    *y(lFACD)
     &                      +(-0.300)*rk(133)    *y(lETHY)
     &                      +(-0.185)*rk(163)    *y(lINTR)
          JAC(lFACD,lHO2 )= +(-0.500)*rk(103)    *y(lHCO3)
     &                      +(-0.074)*rk(159)    *y(lEPX2)
          JAC(lFACD,lFACD)= +         rk( 93)    *y(lOH)
          JAC(lFACD,lHCO3)= +(-1.000)*rk(102)    *y(lNO)
     &                      +(-0.500)*rk(103)    *y(lHO2)
          JAC(lFACD,lETHY)= +(-0.300)*rk(133)    *y(lOH)
          JAC(lFACD,lETH )= +(-0.370)*rk(135)    *y(lO3)
          JAC(lFACD,lOLE )= +(-0.090)*rk(138)    *y(lO3)
          JAC(lFACD,lINTR)= +(-0.185)*rk(163)    *y(lOH)
          JAC(lFACD,lISPD)= +(-0.150)*rk(152)    *y(lO3)
          JAC(lFACD,lEPX2)= +(-0.074)*rk(159)    *y(lHO2)
          JAC(lCO  ,lNO  )= +(-0.251)*rk(160)    *y(lEPX2)
     &                      +(-0.500)*rk(199)    *y(lOPO3)
          JAC(lCO  ,lO3  )= +(-0.510)*rk(135)    *y(lETH)
     &                      +(-0.378)*rk(138)    *y(lOLE)
     &                      +(-0.245)*rk(141)    *y(lIOLE)
     &                      +(-0.066)*rk(149)    *y(lISOP)
     &                      +(-0.543)*rk(152)    *y(lISPD)
     &                      +(-0.001)*rk(165)    *y(lTERP)
     &                      +(-0.500)*rk(191)    *y(lXOPN)
     &                      +(-1.980)*rk(195)    *y(lOPEN)
          JAC(lCO  ,lNO3 )= +(-1.000)*rk( 99)    *y(lFORM)
     &                      +(-1.500)*rk(115)    *y(lGLY)
          JAC(lCO  ,lOH  )= +(-1.000)*rk( 96)    *y(lFORM)
     &                      +(-1.800)*rk(113)    *y(lGLY)
     &                      +(-1.000)*rk(118)    *y(lMGLY)
     &                      +         rk(120)    *y(lCO)
     &                      +(-0.300)*rk(133)    *y(lETHY)
     &                      +(-0.137)*rk(151)    *y(lISPD)
     &                      +(-1.000)*rk(205)    *y(lOPAN)
          JAC(lCO  ,lHO2 )= +(-0.251)*rk(159)    *y(lEPX2)
          JAC(lCO  ,lC2O3)= +(-0.200)*rk(161)    *y(lEPX2)
          JAC(lCO  ,lRO2 )= +(-0.251)*rk(162)    *y(lEPX2)
          JAC(lCO  ,lALD2)= +(-1.000)*rk(106)*flg
          JAC(lCO  ,lFORM)= +(-1.000)*rk( 96)    *y(lOH)
     &                      +(-1.000)*rk( 97)*flg
     &                      +(-1.000)*rk( 98)*flg
     &                      +(-1.000)*rk( 99)    *y(lNO3)
          JAC(lCO  ,lCO  )= +         rk(120)    *y(lOH)
          JAC(lCO  ,lALDX)= +(-1.000)*rk(109)*flg
          JAC(lCO  ,lGLYD)= +(-0.890)*rk(111)*flg
          JAC(lCO  ,lGLY )= +(-1.800)*rk(113)    *y(lOH)
     &                      +(-2.000)*rk(114)*flg
     &                      +(-1.500)*rk(115)    *y(lNO3)
          JAC(lCO  ,lMGLY)= +(-1.000)*rk(116)*flg
     &                      +(-1.000)*rk(118)    *y(lOH)
          JAC(lCO  ,lACET)= +(-0.380)*rk(126)*flg
          JAC(lCO  ,lETHY)= +(-0.300)*rk(133)    *y(lOH)
          JAC(lCO  ,lETH )= +(-0.510)*rk(135)    *y(lO3)
          JAC(lCO  ,lOLE )= +(-0.378)*rk(138)    *y(lO3)
          JAC(lCO  ,lIOLE)= +(-0.245)*rk(141)    *y(lO3)
          JAC(lCO  ,lISOP)= +(-0.066)*rk(149)    *y(lO3)
          JAC(lCO  ,lISPD)= +(-0.137)*rk(151)    *y(lOH)
     &                      +(-0.543)*rk(152)    *y(lO3)
          JAC(lCO  ,lOPO3)= +(-0.500)*rk(199)    *y(lNO)
          JAC(lCO  ,lEPX2)= +(-0.251)*rk(159)    *y(lHO2)
     &                      +(-0.251)*rk(160)    *y(lNO)
     &                      +(-0.200)*rk(161)    *y(lC2O3)
     &                      +(-0.251)*rk(162)    *y(lRO2)
          JAC(lCO  ,lTERP)= +(-0.001)*rk(165)    *y(lO3)
          JAC(lCO  ,lOPEN)= +(-1.000)*rk(193)*flg
     &                      +(-1.980)*rk(195)    *y(lO3)
          JAC(lCO  ,lXOPN)= +(-0.700)*rk(189)*flg
     &                      +(-0.500)*rk(191)    *y(lO3)
          JAC(lCO  ,lOPAN)= +(-1.000)*rk(205)    *y(lOH)
          JAC(lHCO3,lNO  )= +         rk(102)    *y(lHCO3)
          JAC(lHCO3,lHO2 )= +(-1.000)*rk(100)    *y(lFORM)
     &                      +         rk(103)    *y(lHCO3)
          JAC(lHCO3,lFORM)= +(-1.000)*rk(100)    *y(lHO2)
          JAC(lHCO3,lHCO3)= +         rk(101)*flg
     &                      +         rk(102)    *y(lNO)
     &                      +         rk(103)    *y(lHO2)
          JAC(lALDX,lO3  )= +(-0.270)*rk(138)    *y(lOLE)
     &                      +(-0.442)*rk(141)    *y(lIOLE)
     &                      +(-0.150)*rk(149)    *y(lISOP)
     &                      +(-0.210)*rk(165)    *y(lTERP)
          JAC(lALDX,lNO3 )= +         rk(108)    *y(lALDX)
     &                      +(-0.375)*rk(139)    *y(lOLE)
     &                      +(-0.625)*rk(142)    *y(lIOLE)
     &                      +(-0.470)*rk(166)    *y(lTERP)
          JAC(lALDX,lOH  )= +         rk(107)    *y(lALDX)
     &                      +(-0.488)*rk(137)    *y(lOLE)
     &                      +(-0.700)*rk(140)    *y(lIOLE)
     &                      +(-0.029)*rk(155)    *y(lISPX)
     &                      +(-0.078)*rk(163)    *y(lINTR)
     &                      +(-0.470)*rk(164)    *y(lTERP)
          JAC(lALDX,lHO2 )= +(-0.440)*rk(202)    *y(lOPO3)
          JAC(lALDX,lC2O3)= +(-1.000)*rk(203)    *y(lOPO3)
          JAC(lALDX,lRO2 )= +(-0.800)*rk(204)    *y(lOPO3)
          JAC(lALDX,lALDX)= +         rk(107)    *y(lOH)
     &                      +         rk(108)    *y(lNO3)
     &                      +         rk(109)*flg
          JAC(lALDX,lXPRP)= +(-0.268)*rk(226)*flg
          JAC(lALDX,lXPAR)= +(-0.126)*rk(228)*flg
          JAC(lALDX,lROR )= +(-0.370)*rk(130)*flg
          JAC(lALDX,lOLE )= +(-0.488)*rk(137)    *y(lOH)
     &                      +(-0.270)*rk(138)    *y(lO3)
     &                      +(-0.375)*rk(139)    *y(lNO3)
          JAC(lALDX,lIOLE)= +(-0.700)*rk(140)    *y(lOH)
     &                      +(-0.442)*rk(141)    *y(lO3)
     &                      +(-0.625)*rk(142)    *y(lNO3)
          JAC(lALDX,lISOP)= +(-0.150)*rk(149)    *y(lO3)
          JAC(lALDX,lINTR)= +(-0.078)*rk(163)    *y(lOH)
          JAC(lALDX,lISPX)= +(-0.029)*rk(155)    *y(lOH)
          JAC(lALDX,lOPO3)= +(-0.440)*rk(202)    *y(lHO2)
     &                      +(-1.000)*rk(203)    *y(lC2O3)
     &                      +(-0.800)*rk(204)    *y(lRO2)
          JAC(lALDX,lTERP)= +(-0.470)*rk(164)    *y(lOH)
     &                      +(-0.210)*rk(165)    *y(lO3)
     &                      +(-0.470)*rk(166)    *y(lNO3)
          JAC(lGLYD,lNO  )= +(-0.275)*rk(160)    *y(lEPX2)
          JAC(lGLYD,lNO3 )= +         rk(112)    *y(lGLYD)
     &                      +(-0.113)*rk(153)    *y(lISPD)
          JAC(lGLYD,lOH  )= +         rk(110)    *y(lGLYD)
     &                      +(-0.011)*rk(124)    *y(lETOH)
     &                      +(-0.220)*rk(134)    *y(lETH)
     &                      +(-0.269)*rk(151)    *y(lISPD)
     &                      +(-0.331)*rk(163)    *y(lINTR)
          JAC(lGLYD,lHO2 )= +(-0.275)*rk(159)    *y(lEPX2)
          JAC(lGLYD,lC2O3)= +(-0.220)*rk(161)    *y(lEPX2)
          JAC(lGLYD,lRO2 )= +(-0.275)*rk(162)    *y(lEPX2)
          JAC(lGLYD,lGLYD)= +         rk(110)    *y(lOH)
     &                      +         rk(111)*flg
     &                      +         rk(112)    *y(lNO3)
          JAC(lGLYD,lETOH)= +(-0.011)*rk(124)    *y(lOH)
          JAC(lGLYD,lETH )= +(-0.220)*rk(134)    *y(lOH)
          JAC(lGLYD,lINTR)= +(-0.331)*rk(163)    *y(lOH)
          JAC(lGLYD,lISPD)= +(-0.269)*rk(151)    *y(lOH)
     &                      +(-0.113)*rk(153)    *y(lNO3)
     &                      +(-0.128)*rk(154)*flg
          JAC(lGLYD,lEPX2)= +(-0.275)*rk(159)    *y(lHO2)
     &                      +(-0.275)*rk(160)    *y(lNO)
     &                      +(-0.220)*rk(161)    *y(lC2O3)
     &                      +(-0.275)*rk(162)    *y(lRO2)
          JAC(lGLY ,lNO  )= +(-0.275)*rk(160)    *y(lEPX2)
     &                      +(-0.918)*rk(168)    *y(lBZO2)
     &                      +(-0.417)*rk(173)    *y(lTO2)
     &                      +(-0.221)*rk(178)    *y(lXLO2)
     &                      +(-0.500)*rk(199)    *y(lOPO3)
          JAC(lGLY ,lO3  )= +(-0.075)*rk(138)    *y(lOLE)
     &                      +(-0.240)*rk(141)    *y(lIOLE)
     &                      +(-0.170)*rk(152)    *y(lISPD)
     &                      +(-1.400)*rk(195)    *y(lOPEN)
          JAC(lGLY ,lNO3 )= +         rk(115)    *y(lGLY)
     &                      +(-0.240)*rk(183)    *y(lCRES)
          JAC(lGLY ,lOH  )= +(-0.200)*rk(110)    *y(lGLYD)
     &                      +         rk(113)    *y(lGLY)
     &                      +(-0.700)*rk(133)    *y(lETHY)
     &                      +(-0.025)*rk(182)    *y(lCRES)
     &                      +(-0.400)*rk(190)    *y(lXOPN)
     &                      +(-0.400)*rk(194)    *y(lOPEN)
     &                      +(-0.500)*rk(205)    *y(lOPAN)
          JAC(lGLY ,lHO2 )= +(-0.275)*rk(159)    *y(lEPX2)
          JAC(lGLY ,lC2O3)= +(-0.220)*rk(161)    *y(lEPX2)
     &                      +(-1.000)*rk(169)    *y(lBZO2)
     &                      +(-0.480)*rk(174)    *y(lTO2)
     &                      +(-0.260)*rk(180)    *y(lXLO2)
          JAC(lGLY ,lRO2 )= +(-0.275)*rk(162)    *y(lEPX2)
     &                      +(-1.000)*rk(171)    *y(lBZO2)
     &                      +(-0.480)*rk(176)    *y(lTO2)
     &                      +(-0.260)*rk(181)    *y(lXLO2)
          JAC(lGLY ,lGLYD)= +(-0.200)*rk(110)    *y(lOH)
     &                      +(-0.110)*rk(111)*flg
          JAC(lGLY ,lGLY )= +         rk(113)    *y(lOH)
     &                      +         rk(114)*flg
     &                      +         rk(115)    *y(lNO3)
          JAC(lGLY ,lETHY)= +(-0.700)*rk(133)    *y(lOH)
          JAC(lGLY ,lOLE )= +(-0.075)*rk(138)    *y(lO3)
          JAC(lGLY ,lIOLE)= +(-0.240)*rk(141)    *y(lO3)
          JAC(lGLY ,lISPD)= +(-0.170)*rk(152)    *y(lO3)
          JAC(lGLY ,lOPO3)= +(-0.500)*rk(199)    *y(lNO)
          JAC(lGLY ,lEPX2)= +(-0.275)*rk(159)    *y(lHO2)
     &                      +(-0.275)*rk(160)    *y(lNO)
     &                      +(-0.220)*rk(161)    *y(lC2O3)
     &                      +(-0.275)*rk(162)    *y(lRO2)
          JAC(lGLY ,lCRES)= +(-0.025)*rk(182)    *y(lOH)
     &                      +(-0.240)*rk(183)    *y(lNO3)
          JAC(lGLY ,lBZO2)= +(-0.918)*rk(168)    *y(lNO)
     &                      +(-1.000)*rk(169)    *y(lC2O3)
     &                      +(-1.000)*rk(171)    *y(lRO2)
          JAC(lGLY ,lOPEN)= +(-0.400)*rk(194)    *y(lOH)
     &                      +(-1.400)*rk(195)    *y(lO3)
          JAC(lGLY ,lTO2 )= +(-0.417)*rk(173)    *y(lNO)
     &                      +(-0.480)*rk(174)    *y(lC2O3)
     &                      +(-0.480)*rk(176)    *y(lRO2)
          JAC(lGLY ,lXOPN)= +(-0.400)*rk(189)*flg
     &                      +(-0.400)*rk(190)    *y(lOH)
          JAC(lGLY ,lXLO2)= +(-0.221)*rk(178)    *y(lNO)
     &                      +(-0.260)*rk(180)    *y(lC2O3)
     &                      +(-0.260)*rk(181)    *y(lRO2)
          JAC(lGLY ,lOPAN)= +(-0.500)*rk(205)    *y(lOH)
          JAC(lMGLY,lNO  )= +(-0.275)*rk(160)    *y(lEPX2)
     &                      +(-0.443)*rk(173)    *y(lTO2)
     &                      +(-0.675)*rk(178)    *y(lXLO2)
          JAC(lMGLY,lO3  )= +(-0.075)*rk(138)    *y(lOLE)
     &                      +(-0.060)*rk(141)    *y(lIOLE)
     &                      +(-0.531)*rk(152)    *y(lISPD)
     &                      +(-1.200)*rk(191)    *y(lXOPN)
     &                      +(-0.240)*rk(195)    *y(lOPEN)
          JAC(lMGLY,lNO3 )= +         rk(117)    *y(lMGLY)
     &                      +(-0.113)*rk(153)    *y(lISPD)
     &                      +(-0.240)*rk(183)    *y(lCRES)
     &                      +(-0.250)*rk(192)    *y(lXOPN)
          JAC(lMGLY,lOH  )= +         rk(118)    *y(lMGLY)
     &                      +(-0.115)*rk(151)    *y(lISPD)
     &                      +(-1.000)*rk(190)    *y(lXOPN)
          JAC(lMGLY,lHO2 )= +(-0.275)*rk(159)    *y(lEPX2)
          JAC(lMGLY,lC2O3)= +(-0.220)*rk(161)    *y(lEPX2)
     &                      +(-0.520)*rk(174)    *y(lTO2)
     &                      +(-0.770)*rk(180)    *y(lXLO2)
          JAC(lMGLY,lRO2 )= +(-0.275)*rk(162)    *y(lEPX2)
     &                      +(-0.520)*rk(176)    *y(lTO2)
     &                      +(-0.770)*rk(181)    *y(lXLO2)
          JAC(lMGLY,lMGLY)= +         rk(116)*flg
     &                      +         rk(117)    *y(lNO3)
     &                      +         rk(118)    *y(lOH)
          JAC(lMGLY,lOLE )= +(-0.075)*rk(138)    *y(lO3)
          JAC(lMGLY,lIOLE)= +(-0.060)*rk(141)    *y(lO3)
          JAC(lMGLY,lISPD)= +(-0.115)*rk(151)    *y(lOH)
     &                      +(-0.531)*rk(152)    *y(lO3)
     &                      +(-0.113)*rk(153)    *y(lNO3)
          JAC(lMGLY,lEPX2)= +(-0.275)*rk(159)    *y(lHO2)
     &                      +(-0.275)*rk(160)    *y(lNO)
     &                      +(-0.220)*rk(161)    *y(lC2O3)
     &                      +(-0.275)*rk(162)    *y(lRO2)
          JAC(lMGLY,lCRES)= +(-0.240)*rk(183)    *y(lNO3)
          JAC(lMGLY,lOPEN)= +(-0.240)*rk(195)    *y(lO3)
          JAC(lMGLY,lTO2 )= +(-0.443)*rk(173)    *y(lNO)
     &                      +(-0.520)*rk(174)    *y(lC2O3)
     &                      +(-0.520)*rk(176)    *y(lRO2)
          JAC(lMGLY,lXOPN)= +(-1.000)*rk(190)    *y(lOH)
     &                      +(-1.200)*rk(191)    *y(lO3)
     &                      +(-0.250)*rk(192)    *y(lNO3)
          JAC(lMGLY,lXLO2)= +(-0.675)*rk(178)    *y(lNO)
     &                      +(-0.770)*rk(180)    *y(lC2O3)
     &                      +(-0.770)*rk(181)    *y(lRO2)
          JAC(lETHA,lOH  )= +         rk(122)    *y(lETHA)
          JAC(lETHA,lETHA)= +         rk(122)    *y(lOH)
          JAC(lETOH,lOH  )= +         rk(124)    *y(lETOH)
          JAC(lETOH,lETOH)= +         rk(124)    *y(lOH)
          JAC(lKET ,lKET )= +         rk(125)*flg
          JAC(lKET ,lROR )= +(-0.200)*rk(130)*flg
     &                      +(-1.000)*rk(131)*flg*O2
          JAC(lPAR ,lNO  )= +(-2.175)*rk(160)    *y(lEPX2)
          JAC(lPAR ,lO3  )= +( 0.790)*rk(138)    *y(lOLE)
     &                      +(-0.290)*rk(141)    *y(lIOLE)
     &                      +(-0.350)*rk(149)    *y(lISOP)
     &                      +(-7.000)*rk(165)    *y(lTERP)
          JAC(lPAR ,lNO3 )= +         rk(139)    *y(lOLE)
     &                      +(-1.000)*rk(142)    *y(lIOLE)
     &                      +(-0.717)*rk(153)    *y(lISPD)
          JAC(lPAR ,lOH  )= +         rk(129)    *y(lPAR)
     &                      +( 0.730)*rk(137)    *y(lOLE)
     &                      +(-0.117)*rk(151)    *y(lISPD)
     &                      +(-2.700)*rk(163)    *y(lINTR)
     &                      +(-1.660)*rk(164)    *y(lTERP)
          JAC(lPAR ,lHO2 )= +(-2.175)*rk(159)    *y(lEPX2)
          JAC(lPAR ,lC2O3)= +(-1.740)*rk(161)    *y(lEPX2)
          JAC(lPAR ,lRO2 )= +(-2.175)*rk(162)    *y(lEPX2)
          JAC(lPAR ,lKET )= +( 2.500)*rk(125)*flg
          JAC(lPAR ,lPAR )= +         rk(129)    *y(lOH)
          JAC(lPAR ,lXPRP)= +(-0.268)*rk(226)*flg
          JAC(lPAR ,lXPAR)= +( 0.126)*rk(228)*flg
          JAC(lPAR ,lROR )= +( 2.700)*rk(130)*flg
          JAC(lPAR ,lOLE )= +( 0.730)*rk(137)    *y(lOH)
     &                      +( 0.790)*rk(138)    *y(lO3)
     &                      +         rk(139)    *y(lNO3)
          JAC(lPAR ,lIOLE)= +(-0.290)*rk(141)    *y(lO3)
     &                      +(-1.000)*rk(142)    *y(lNO3)
          JAC(lPAR ,lISOP)= +(-0.350)*rk(149)    *y(lO3)
          JAC(lPAR ,lINTR)= +(-2.700)*rk(163)    *y(lOH)
          JAC(lPAR ,lISPD)= +(-0.117)*rk(151)    *y(lOH)
     &                      +(-0.717)*rk(153)    *y(lNO3)
     &                      +(-0.240)*rk(154)*flg
          JAC(lPAR ,lEPX2)= +(-2.175)*rk(159)    *y(lHO2)
     &                      +(-2.175)*rk(160)    *y(lNO)
     &                      +(-1.740)*rk(161)    *y(lC2O3)
     &                      +(-2.175)*rk(162)    *y(lRO2)
          JAC(lPAR ,lTERP)= +(-1.660)*rk(164)    *y(lOH)
     &                      +(-7.000)*rk(165)    *y(lO3)
          JAC(lACET,lO3  )= +(-0.170)*rk(152)    *y(lISPD)
          JAC(lACET,lOH  )= +         rk(127)    *y(lACET)
     &                      +(-0.137)*rk(151)    *y(lISPD)
          JAC(lACET,lACET)= +         rk(126)*flg
     &                      +         rk(127)    *y(lOH)
          JAC(lACET,lXPRP)= +(-0.732)*rk(226)*flg
          JAC(lACET,lROR )= +(-0.420)*rk(130)*flg
          JAC(lACET,lISPD)= +(-0.137)*rk(151)    *y(lOH)
     &                      +(-0.170)*rk(152)    *y(lO3)
     &                      +(-0.170)*rk(154)*flg
          JAC(lPRPA,lOH  )= +         rk(128)    *y(lPRPA)
          JAC(lPRPA,lPRPA)= +         rk(128)    *y(lOH)
          JAC(lXPRP,lOH  )= +(-1.000)*rk(128)    *y(lPRPA)
          JAC(lXPRP,lPRPA)= +(-1.000)*rk(128)    *y(lOH)
          JAC(lXPRP,lXPRP)= +         rk(225)*flg
     &                      +         rk(226)*flg
          JAC(lXPAR,lOH  )= +(-1.000)*rk(129)    *y(lPAR)
          JAC(lXPAR,lPAR )= +(-1.000)*rk(129)    *y(lOH)
          JAC(lXPAR,lXPAR)= +         rk(227)*flg
     &                      +         rk(228)*flg
          JAC(lROR ,lNO2 )= +         rk(132)    *y(lROR)
          JAC(lROR ,lXPAR)= +(-0.874)*rk(228)*flg
          JAC(lROR ,lROR )= +         rk(130)*flg
     &                      +(-0.020)*rk(130)*flg
     &                      +         rk(131)*flg*O2
     &                      +         rk(132)    *y(lNO2)
          JAC(lETHY,lOH  )= +         rk(133)    *y(lETHY)
          JAC(lETHY,lETHY)= +         rk(133)    *y(lOH)
          JAC(lETH ,lO3  )= +         rk(135)    *y(lETH)
          JAC(lETH ,lNO3 )= +         rk(136)    *y(lETH)
          JAC(lETH ,lOH  )= +         rk(134)    *y(lETH)
          JAC(lETH ,lETH )= +         rk(134)    *y(lOH)
     &                      +         rk(135)    *y(lO3)
     &                      +         rk(136)    *y(lNO3)
          JAC(lOLE ,lO3  )= +         rk(138)    *y(lOLE)
          JAC(lOLE ,lNO3 )= +         rk(139)    *y(lOLE)
          JAC(lOLE ,lOH  )= +         rk(137)    *y(lOLE)
     &                      +(-0.098)*rk(163)    *y(lINTR)
          JAC(lOLE ,lOLE )= +         rk(137)    *y(lOH)
     &                      +         rk(138)    *y(lO3)
     &                      +         rk(139)    *y(lNO3)
          JAC(lOLE ,lINTR)= +(-0.098)*rk(163)    *y(lOH)
          JAC(lOLE ,lISPD)= +(-0.240)*rk(154)*flg
          JAC(lIOLE,lO3  )= +         rk(141)    *y(lIOLE)
          JAC(lIOLE,lNO3 )= +         rk(142)    *y(lIOLE)
          JAC(lIOLE,lOH  )= +         rk(140)    *y(lIOLE)
     &                      +(-0.029)*rk(155)    *y(lISPX)
          JAC(lIOLE,lIOLE)= +         rk(140)    *y(lOH)
     &                      +         rk(141)    *y(lO3)
     &                      +         rk(142)    *y(lNO3)
          JAC(lIOLE,lISPX)= +(-0.029)*rk(155)    *y(lOH)
          JAC(lISOP,lO3  )= +         rk(149)    *y(lISOP)
          JAC(lISOP,lNO3 )= +         rk(150)    *y(lISOP)
          JAC(lISOP,lOH  )= +         rk(143)    *y(lISOP)
          JAC(lISOP,lISOP)= +         rk(143)    *y(lOH)
     &                      +         rk(149)    *y(lO3)
     &                      +         rk(150)    *y(lNO3)
          JAC(lISO2,lNO  )= +         rk(144)    *y(lISO2)
          JAC(lISO2,lOH  )= +(-1.000)*rk(143)    *y(lISOP)
     &                      +(-0.067)*rk(155)    *y(lISPX)
          JAC(lISO2,lHO2 )= +         rk(145)    *y(lISO2)
          JAC(lISO2,lC2O3)= +         rk(146)    *y(lISO2)
          JAC(lISO2,lRO2 )= +         rk(147)    *y(lISO2)
          JAC(lISO2,lISOP)= +(-1.000)*rk(143)    *y(lOH)
          JAC(lISO2,lISO2)= +         rk(144)    *y(lNO)
     &                      +         rk(145)    *y(lHO2)
     &                      +         rk(146)    *y(lC2O3)
     &                      +         rk(147)    *y(lRO2)
     &                      +         rk(148)*flg
          JAC(lISO2,lISPX)= +(-0.067)*rk(155)    *y(lOH)
          JAC(lINTR,lNO  )= +(-0.100)*rk(144)    *y(lISO2)
          JAC(lINTR,lOH  )= +         rk(163)    *y(lINTR)
     &                      +(-0.104)*rk(163)    *y(lINTR)
          JAC(lINTR,lISO2)= +(-0.100)*rk(144)    *y(lNO)
          JAC(lINTR,lINTR)= +         rk(163)    *y(lOH)
     &                      +(-0.104)*rk(163)    *y(lOH)
     &                      +         rk(229)*flg
          JAC(lISPD,lNO  )= +(-0.900)*rk(144)    *y(lISO2)
          JAC(lISPD,lO3  )= +(-0.650)*rk(149)    *y(lISOP)
     &                      +         rk(152)    *y(lISPD)
          JAC(lISPD,lNO3 )= +(-0.350)*rk(150)    *y(lISOP)
     &                      +         rk(153)    *y(lISPD)
     &                      +(-1.000)*rk(157)    *y(lHPLD)
          JAC(lISPD,lOH  )= +         rk(151)    *y(lISPD)
          JAC(lISPD,lHO2 )= +(-0.120)*rk(145)    *y(lISO2)
          JAC(lISPD,lC2O3)= +(-1.000)*rk(146)    *y(lISO2)
          JAC(lISPD,lRO2 )= +(-1.000)*rk(147)    *y(lISO2)
          JAC(lISPD,lISOP)= +(-0.650)*rk(149)    *y(lO3)
     &                      +(-0.350)*rk(150)    *y(lNO3)
          JAC(lISPD,lISO2)= +(-0.900)*rk(144)    *y(lNO)
     &                      +(-0.120)*rk(145)    *y(lHO2)
     &                      +(-1.000)*rk(146)    *y(lC2O3)
     &                      +(-1.000)*rk(147)    *y(lRO2)
          JAC(lISPD,lISPD)= +         rk(151)    *y(lOH)
     &                      +         rk(152)    *y(lO3)
     &                      +         rk(153)    *y(lNO3)
     &                      +         rk(154)*flg
          JAC(lISPD,lHPLD)= +(-1.000)*rk(156)*flg
     &                      +(-1.000)*rk(157)    *y(lNO3)
          JAC(lISPX,lOH  )= +         rk(155)    *y(lISPX)
          JAC(lISPX,lHO2 )= +(-0.880)*rk(145)    *y(lISO2)
          JAC(lISPX,lISO2)= +(-0.880)*rk(145)    *y(lHO2)
          JAC(lISPX,lISPX)= +         rk(155)    *y(lOH)
          JAC(lHPLD,lNO3 )= +         rk(157)    *y(lHPLD)
          JAC(lHPLD,lISO2)= +(-1.000)*rk(148)*flg
          JAC(lHPLD,lHPLD)= +         rk(156)*flg
     &                      +         rk(157)    *y(lNO3)
          JAC(lOPO3,lNO2 )= +         rk(200)    *y(lOPO3)
          JAC(lOPO3,lNO  )= +         rk(199)    *y(lOPO3)
          JAC(lOPO3,lNO3 )= +(-0.480)*rk(183)    *y(lCRES)
     &                      +(-1.000)*rk(196)    *y(lOPEN)
          JAC(lOPO3,lOH  )= +(-0.457)*rk(151)    *y(lISPD)
     &                      +(-0.600)*rk(194)    *y(lOPEN)
          JAC(lOPO3,lHO2 )= +         rk(202)    *y(lOPO3)
          JAC(lOPO3,lC2O3)= +         rk(203)    *y(lOPO3)
          JAC(lOPO3,lRO2 )= +         rk(204)    *y(lOPO3)
          JAC(lOPO3,lISPD)= +(-0.457)*rk(151)    *y(lOH)
          JAC(lOPO3,lOPO3)= +         rk(199)    *y(lNO)
     &                      +         rk(200)    *y(lNO2)
     &                      +         rk(202)    *y(lHO2)
     &                      +         rk(203)    *y(lC2O3)
     &                      +         rk(204)    *y(lRO2)
          JAC(lOPO3,lCRES)= +(-0.480)*rk(183)    *y(lNO3)
          JAC(lOPO3,lOPEN)= +(-1.000)*rk(193)*flg
     &                      +(-0.600)*rk(194)    *y(lOH)
     &                      +(-1.000)*rk(196)    *y(lNO3)
          JAC(lOPO3,lOPAN)= +(-1.000)*rk(201)*flg
          JAC(lEPOX,lOH  )= +(-0.904)*rk(155)    *y(lISPX)
     &                      +         rk(158)    *y(lEPOX)
          JAC(lEPOX,lISPX)= +(-0.904)*rk(155)    *y(lOH)
          JAC(lEPOX,lEPOX)= +         rk(158)    *y(lOH)
          JAC(lEPX2,lNO  )= +         rk(160)    *y(lEPX2)
          JAC(lEPX2,lOH  )= +(-1.000)*rk(158)    *y(lEPOX)
          JAC(lEPX2,lHO2 )= +         rk(159)    *y(lEPX2)
          JAC(lEPX2,lC2O3)= +         rk(161)    *y(lEPX2)
          JAC(lEPX2,lRO2 )= +         rk(162)    *y(lEPX2)
          JAC(lEPX2,lEPOX)= +(-1.000)*rk(158)    *y(lOH)
          JAC(lEPX2,lEPX2)= +         rk(159)    *y(lHO2)
     &                      +         rk(160)    *y(lNO)
     &                      +         rk(161)    *y(lC2O3)
     &                      +         rk(162)    *y(lRO2)
          JAC(lTERP,lO3  )= +         rk(165)    *y(lTERP)
          JAC(lTERP,lNO3 )= +         rk(166)    *y(lTERP)
          JAC(lTERP,lOH  )= +         rk(164)    *y(lTERP)
          JAC(lTERP,lTERP)= +         rk(164)    *y(lOH)
     &                      +         rk(165)    *y(lO3)
     &                      +         rk(166)    *y(lNO3)
          JAC(lBENZ,lOH  )= +         rk(167)    *y(lBENZ)
          JAC(lBENZ,lBENZ)= +         rk(167)    *y(lOH)
          JAC(lCRES,lNO3 )= +         rk(183)    *y(lCRES)
          JAC(lCRES,lOH  )= +(-0.530)*rk(167)    *y(lBENZ)
     &                      +(-0.180)*rk(172)    *y(lTOL)
     &                      +(-0.155)*rk(177)    *y(lXYL)
     &                      +         rk(182)    *y(lCRES)
          JAC(lCRES,lHO2 )= +(-1.000)*rk(185)    *y(lCRO)
          JAC(lCRES,lBENZ)= +(-0.530)*rk(167)    *y(lOH)
          JAC(lCRES,lCRES)= +         rk(182)    *y(lOH)
     &                      +         rk(183)    *y(lNO3)
          JAC(lCRES,lTOL )= +(-0.180)*rk(172)    *y(lOH)
          JAC(lCRES,lXYL )= +(-0.155)*rk(177)    *y(lOH)
          JAC(lCRES,lCRO )= +(-1.000)*rk(185)    *y(lHO2)
          JAC(lBZO2,lNO  )= +         rk(168)    *y(lBZO2)
          JAC(lBZO2,lOH  )= +(-0.352)*rk(167)    *y(lBENZ)
          JAC(lBZO2,lHO2 )= +         rk(170)    *y(lBZO2)
          JAC(lBZO2,lC2O3)= +         rk(169)    *y(lBZO2)
          JAC(lBZO2,lRO2 )= +         rk(171)    *y(lBZO2)
          JAC(lBZO2,lBENZ)= +(-0.352)*rk(167)    *y(lOH)
          JAC(lBZO2,lBZO2)= +         rk(168)    *y(lNO)
     &                      +         rk(169)    *y(lC2O3)
     &                      +         rk(170)    *y(lHO2)
     &                      +         rk(171)    *y(lRO2)
          JAC(lOPEN,lNO  )= +(-0.918)*rk(168)    *y(lBZO2)
     &                      +(-0.660)*rk(173)    *y(lTO2)
     &                      +(-0.300)*rk(178)    *y(lXLO2)
          JAC(lOPEN,lO3  )= +         rk(195)    *y(lOPEN)
          JAC(lOPEN,lNO3 )= +(-0.250)*rk(192)    *y(lXOPN)
     &                      +         rk(196)    *y(lOPEN)
          JAC(lOPEN,lOH  )= +(-0.118)*rk(167)    *y(lBENZ)
     &                      +(-0.100)*rk(172)    *y(lTOL)
     &                      +(-0.025)*rk(182)    *y(lCRES)
     &                      +         rk(194)    *y(lOPEN)
          JAC(lOPEN,lC2O3)= +(-1.000)*rk(169)    *y(lBZO2)
     &                      +(-0.770)*rk(174)    *y(lTO2)
     &                      +(-0.350)*rk(180)    *y(lXLO2)
          JAC(lOPEN,lRO2 )= +(-1.000)*rk(171)    *y(lBZO2)
     &                      +(-0.770)*rk(176)    *y(lTO2)
     &                      +(-0.350)*rk(181)    *y(lXLO2)
          JAC(lOPEN,lBENZ)= +(-0.118)*rk(167)    *y(lOH)
          JAC(lOPEN,lCRES)= +(-0.025)*rk(182)    *y(lOH)
          JAC(lOPEN,lBZO2)= +(-0.918)*rk(168)    *y(lNO)
     &                      +(-1.000)*rk(169)    *y(lC2O3)
     &                      +(-1.000)*rk(171)    *y(lRO2)
          JAC(lOPEN,lOPEN)= +         rk(193)*flg
     &                      +         rk(194)    *y(lOH)
     &                      +         rk(195)    *y(lO3)
     &                      +         rk(196)    *y(lNO3)
          JAC(lOPEN,lTOL )= +(-0.100)*rk(172)    *y(lOH)
          JAC(lOPEN,lTO2 )= +(-0.660)*rk(173)    *y(lNO)
     &                      +(-0.770)*rk(174)    *y(lC2O3)
     &                      +(-0.770)*rk(176)    *y(lRO2)
          JAC(lOPEN,lXOPN)= +(-0.250)*rk(192)    *y(lNO3)
          JAC(lOPEN,lXLO2)= +(-0.300)*rk(178)    *y(lNO)
     &                      +(-0.350)*rk(180)    *y(lC2O3)
     &                      +(-0.350)*rk(181)    *y(lRO2)
          JAC(lOPEN,lCRON)= +(-1.000)*rk(188)*flg
          JAC(lTOL ,lOH  )= +         rk(172)    *y(lTOL)
          JAC(lTOL ,lTOL )= +         rk(172)    *y(lOH)
          JAC(lTO2 ,lNO  )= +         rk(173)    *y(lTO2)
          JAC(lTO2 ,lOH  )= +(-0.650)*rk(172)    *y(lTOL)
          JAC(lTO2 ,lHO2 )= +         rk(175)    *y(lTO2)
          JAC(lTO2 ,lC2O3)= +         rk(174)    *y(lTO2)
          JAC(lTO2 ,lRO2 )= +         rk(176)    *y(lTO2)
          JAC(lTO2 ,lTOL )= +(-0.650)*rk(172)    *y(lOH)
          JAC(lTO2 ,lTO2 )= +         rk(173)    *y(lNO)
     &                      +         rk(174)    *y(lC2O3)
     &                      +         rk(175)    *y(lHO2)
     &                      +         rk(176)    *y(lRO2)
          JAC(lXOPN,lNO  )= +(-0.200)*rk(173)    *y(lTO2)
     &                      +(-0.560)*rk(178)    *y(lXLO2)
          JAC(lXOPN,lO3  )= +         rk(191)    *y(lXOPN)
          JAC(lXOPN,lNO3 )= +         rk(192)    *y(lXOPN)
          JAC(lXOPN,lOH  )= +(-0.244)*rk(177)    *y(lXYL)
     &                      +         rk(190)    *y(lXOPN)
          JAC(lXOPN,lC2O3)= +(-0.230)*rk(174)    *y(lTO2)
     &                      +(-0.650)*rk(180)    *y(lXLO2)
          JAC(lXOPN,lRO2 )= +(-0.230)*rk(176)    *y(lTO2)
     &                      +(-0.650)*rk(181)    *y(lXLO2)
          JAC(lXOPN,lTO2 )= +(-0.200)*rk(173)    *y(lNO)
     &                      +(-0.230)*rk(174)    *y(lC2O3)
     &                      +(-0.230)*rk(176)    *y(lRO2)
          JAC(lXOPN,lXOPN)= +         rk(189)*flg
     &                      +         rk(190)    *y(lOH)
     &                      +         rk(191)    *y(lO3)
     &                      +         rk(192)    *y(lNO3)
          JAC(lXOPN,lXYL )= +(-0.244)*rk(177)    *y(lOH)
          JAC(lXOPN,lXLO2)= +(-0.560)*rk(178)    *y(lNO)
     &                      +(-0.650)*rk(180)    *y(lC2O3)
     &                      +(-0.650)*rk(181)    *y(lRO2)
          JAC(lXYL ,lOH  )= +         rk(177)    *y(lXYL)
          JAC(lXYL ,lXYL )= +         rk(177)    *y(lOH)
          JAC(lXLO2,lNO  )= +         rk(178)    *y(lXLO2)
          JAC(lXLO2,lOH  )= +(-0.544)*rk(177)    *y(lXYL)
          JAC(lXLO2,lHO2 )= +         rk(179)    *y(lXLO2)
          JAC(lXLO2,lC2O3)= +         rk(180)    *y(lXLO2)
          JAC(lXLO2,lRO2 )= +         rk(181)    *y(lXLO2)
          JAC(lXLO2,lXYL )= +(-0.544)*rk(177)    *y(lOH)
          JAC(lXLO2,lXLO2)= +         rk(178)    *y(lNO)
     &                      +         rk(179)    *y(lHO2)
     &                      +         rk(180)    *y(lC2O3)
     &                      +         rk(181)    *y(lRO2)
          JAC(lCRO ,lNO2 )= +         rk(184)    *y(lCRO)
          JAC(lCRO ,lNO3 )= +(-0.300)*rk(183)    *y(lCRES)
     &                      +(-0.500)*rk(187)    *y(lCRON)
     &                      +(-1.000)*rk(198)    *y(lCAT1)
          JAC(lCRO ,lOH  )= +(-0.200)*rk(182)    *y(lCRES)
     &                      +(-0.500)*rk(186)    *y(lCRON)
     &                      +(-0.500)*rk(197)    *y(lCAT1)
          JAC(lCRO ,lHO2 )= +         rk(185)    *y(lCRO)
          JAC(lCRO ,lCRES)= +(-0.200)*rk(182)    *y(lOH)
     &                      +(-0.300)*rk(183)    *y(lNO3)
          JAC(lCRO ,lCRO )= +         rk(184)    *y(lNO2)
     &                      +         rk(185)    *y(lHO2)
          JAC(lCRO ,lCAT1)= +(-0.500)*rk(197)    *y(lOH)
     &                      +(-1.000)*rk(198)    *y(lNO3)
          JAC(lCRO ,lCRON)= +(-0.500)*rk(186)    *y(lOH)
     &                      +(-0.500)*rk(187)    *y(lNO3)
          JAC(lCAT1,lNO3 )= +         rk(198)    *y(lCAT1)
          JAC(lCAT1,lOH  )= +(-0.732)*rk(182)    *y(lCRES)
     &                      +         rk(197)    *y(lCAT1)
          JAC(lCAT1,lCRES)= +(-0.732)*rk(182)    *y(lOH)
          JAC(lCAT1,lCAT1)= +         rk(197)    *y(lOH)
     &                      +         rk(198)    *y(lNO3)
          JAC(lCRON,lNO2 )= +(-1.000)*rk(184)    *y(lCRO)
          JAC(lCRON,lNO3 )= +         rk(187)    *y(lCRON)
          JAC(lCRON,lOH  )= +         rk(186)    *y(lCRON)
          JAC(lCRON,lCRO )= +(-1.000)*rk(184)    *y(lNO2)
          JAC(lCRON,lCRON)= +         rk(186)    *y(lOH)
     &                      +         rk(187)    *y(lNO3)
     &                      +         rk(188)*flg
          JAC(lOPAN,lNO2 )= +(-1.000)*rk(200)    *y(lOPO3)
          JAC(lOPAN,lOH  )= +         rk(205)    *y(lOPAN)
          JAC(lOPAN,lOPO3)= +(-1.000)*rk(200)    *y(lNO2)
          JAC(lOPAN,lOPAN)= +         rk(201)*flg
     &                      +         rk(205)    *y(lOH)
          JAC(lECH4,lOH  )= +         rk(208)    *y(lECH4)
          JAC(lECH4,lECH4)= +         rk(208)    *y(lOH)
          JAC(lI2  ,lI2  )= +         rk(209)*flg
          JAC(lI   ,lNO  )= +(-1.000)*rk(215)    *y(lIO)
          JAC(lI   ,lO3  )= +         rk(211)    *y(lI)
          JAC(lI   ,lI2  )= +(-2.000)*rk(209)*flg
          JAC(lI   ,lI   )= +         rk(211)    *y(lO3)
          JAC(lI   ,lHOI )= +(-1.000)*rk(210)*flg
          JAC(lI   ,lIO  )= +(-1.000)*rk(212)*flg
     &                      +(-0.800)*rk(213)    *y(lIO)
     &                      +(-1.000)*rk(215)    *y(lNO)
          JAC(lI   ,lOIO )= +(-1.000)*rk(217)*flg
          JAC(lI   ,lI2O2)= +(-1.000)*rk(221)*flg
          JAC(lI   ,lINO3)= +(-1.000)*rk(223)*flg
          JAC(lHOI ,lHO2 )= +(-1.000)*rk(214)    *y(lIO)
          JAC(lHOI ,lHOI )= +         rk(210)*flg
          JAC(lHOI ,lIO  )= +(-1.000)*rk(214)    *y(lHO2)
          JAC(lHOI ,lINO3)= +(-1.000)*rk(224)*flg*H2O
          JAC(lIO  ,lNO2 )= +         rk(216)    *y(lIO)
          JAC(lIO  ,lNO  )= +         rk(215)    *y(lIO)
     &                      +(-1.000)*rk(220)    *y(lOIO)
          JAC(lIO  ,lO3  )= +(-1.000)*rk(211)    *y(lI)
          JAC(lIO  ,lHO2 )= +         rk(214)    *y(lIO)
          JAC(lIO  ,lI   )= +(-1.000)*rk(211)    *y(lO3)
          JAC(lIO  ,lIO  )= +         rk(212)*flg
     &                      +( 4.000)*rk(213)    *y(lIO)
     &                      +         rk(214)    *y(lHO2)
     &                      +         rk(215)    *y(lNO)
     &                      +         rk(216)    *y(lNO2)
     &                      +         rk(219)    *y(lOIO)
          JAC(lIO  ,lOIO )= +         rk(219)    *y(lIO)
     &                      +(-1.000)*rk(220)    *y(lNO)
          JAC(lOIO ,lNO  )= +         rk(220)    *y(lOIO)
          JAC(lOIO ,lOH  )= +         rk(218)    *y(lOIO)
          JAC(lOIO ,lIO  )= +(-0.800)*rk(213)    *y(lIO)
     &                      +         rk(219)    *y(lOIO)
          JAC(lOIO ,lOIO )= +         rk(217)*flg
     &                      +         rk(218)    *y(lOH)
     &                      +         rk(219)    *y(lIO)
     &                      +         rk(220)    *y(lNO)
          JAC(lOIO ,lI2O2)= +(-1.000)*rk(221)*flg
          JAC(lI2O2,lO3  )= +         rk(222)    *y(lI2O2)
          JAC(lI2O2,lIO  )= +(-1.200)*rk(213)    *y(lIO)
          JAC(lI2O2,lI2O2)= +         rk(221)*flg
     &                      +         rk(222)    *y(lO3)
          JAC(lINO3,lNO2 )= +(-1.000)*rk(216)    *y(lIO)
          JAC(lINO3,lIO  )= +(-1.000)*rk(216)    *y(lNO2)
          JAC(lINO3,lINO3)= +         rk(223)*flg
     &                      +         rk(224)*flg*H2O
          JAC(lHIO3,lOH  )= +(-1.000)*rk(218)    *y(lOIO)
          JAC(lHIO3,lOIO )= +(-1.000)*rk(218)    *y(lOH)
          JAC(lIXOY,lO3  )= +(-1.000)*rk(222)    *y(lI2O2)
          JAC(lIXOY,lIO  )= +(-1.000)*rk(219)    *y(lOIO)
          JAC(lIXOY,lOIO )= +(-1.000)*rk(219)    *y(lIO)
          JAC(lIXOY,lI2O2)= +(-1.000)*rk(222)    *y(lO3)
          JAC(lDMS ,lNO3 )= +         rk(233)    *y(lDMS)
          JAC(lDMS ,lOH  )= +         rk(231)    *y(lDMS)
     &                      +         rk(232)    *y(lDMS)*O2
          JAC(lDMS ,lDMS )= +         rk(231)    *y(lOH)
     &                      +         rk(232)    *y(lOH)*O2
     &                      +         rk(233)    *y(lNO3)
c
      do j=1,njac
        do i=1,njac
          jac(i,j) = -jac(i,j)
        enddo
      enddo
c
      return
c
      end
