      subroutine hddmjac6(njac,nrxn,H2O,M,O2,CH4,H2,flg,jac,y,rk)
      implicit none
c
c----CAMx v7Beta6 190902
c
c     HDDMJAC6 computes a full Jacobian for HDDM
c
c     Copyright 1996 - 2018
c     Ramboll
c     Created by the CMC version 5.2.6
c
c     Routines Called:
c        none
c
c     Called by:
c        HDDMCHEM
c
      include "camx.prm"
      include "chmdat.inc"
      include "ddmchm.inc"
c
      integer njac, nrxn, i, j
      real H2O, M, O2, CH4, H2, N2, flg
      real jac(njac+1,njac+1), y(njac+1), rk(nrxn)
c
c --- Entry point
c
      N2  = M - O2
c

          JAC(lNO2 ,lNO2 )= +         rk(  1)*flg
     &                      +         rk(  4)    *y(lO)
     &                      +         rk(  5)    *y(lO)
     &                      +         rk(  7)    *y(lO3)
     &                      +         rk( 17)    *y(lNO3)
     &                      +(-1.000)*rk( 17)    *y(lNO3)
     &                      +         rk( 18)    *y(lNO3)
     &                      +         rk( 23)    *y(lNO)*H2O
     &                      +         rk( 28)    *y(lOH)
          JAC(lNO2 ,lNO2 )=JAC(lNO2 ,lNO2 )
     &                      +         rk( 31)    *y(lHO2)
     &                      +         rk( 89)    *y(lC2O3)
     &                      +         rk(104)    *y(lCXO3)
     &                      +         rk(118)    *y(lROR)
     &                      +         rk(136)    *y(lCRO)
     &                      +         rk(148)    *y(lISOP)
          JAC(lNO2 ,lNO  )= +(-1.000)*rk(  3)    *y(lO3)
     &                      +(-1.000)*rk(  6)    *y(lO)
     &                      +(-2.000)*rk( 16)    *y(lNO3)
     &                      +(-4.000)*rk( 22)    *y(lNO)*O2
     &                      +         rk( 23)    *y(lNO2)*H2O
     &                      +(-1.000)*rk( 30)    *y(lHO2)
     &                      +(-1.000)*rk( 54)    *y(lXO2)
     &                      +(-1.000)*rk( 68)    *y(lMEO2)
     &                      +(-1.000)*rk( 81)    *y(lHCO3)
          JAC(lNO2 ,lNO  )=JAC(lNO2 ,lNO  )
     &                      +(-1.000)*rk( 88)    *y(lC2O3)
     &                      +(-1.000)*rk(103)    *y(lCXO3)
     &                      +(-0.900)*rk(132)    *y(lTO2)
          JAC(lNO2 ,lO   )= +         rk(  4)    *y(lNO2)
     &                      +         rk(  5)    *y(lNO2)
     &                      +(-1.000)*rk(  6)    *y(lNO)
     &                      +(-1.000)*rk( 46)    *y(lNO3)
          JAC(lNO2 ,lO3  )= +(-1.000)*rk(  3)    *y(lNO)
     &                      +         rk(  7)    *y(lNO2)
     &                      +(-1.000)*rk( 49)    *y(lNO3)
          JAC(lNO2 ,lNO3 )= +(-1.000)*rk( 14)*flg
     &                      +(-2.000)*rk( 16)    *y(lNO)
     &                      +         rk( 17)    *y(lNO2)
     &                      +(-1.000)*rk( 17)    *y(lNO2)
     &                      +         rk( 18)    *y(lNO2)
     &                      +(-1.000)*rk( 46)    *y(lO)
     &                      +(-1.000)*rk( 47)    *y(lOH)
     &                      +(-1.000)*rk( 49)    *y(lO3)
     &                      +(-4.000)*rk( 50)    *y(lNO3)
          JAC(lNO2 ,lNO3 )=JAC(lNO2 ,lNO3 )
     &                      +(-1.000)*rk(122)    *y(lOLE)
     &                      +(-1.000)*rk(126)    *y(lETH)
     &                      +(-1.000)*rk(130)    *y(lIOLE)
     &                      +(-0.200)*rk(147)    *y(lISOP)
     &                      +(-0.470)*rk(156)    *y(lTERP)
          JAC(lNO2 ,lOH  )= +(-1.000)*rk( 26)    *y(lHONO)
     &                      +         rk( 28)    *y(lNO2)
     &                      +(-1.000)*rk( 33)    *y(lPNA)
     &                      +(-1.000)*rk( 47)    *y(lNO3)
     &                      +(-1.000)*rk(107)    *y(lPANX)
          JAC(lNO2 ,lHO2 )= +(-1.000)*rk( 30)    *y(lNO)
     &                      +         rk( 31)    *y(lNO2)
          JAC(lNO2 ,lN2O5)= +(-1.000)*rk( 21)*flg
     &                      +(-1.000)*rk( 53)*flg
          JAC(lNO2 ,lHNO3)= +(-1.000)*rk( 52)*flg
          JAC(lNO2 ,lHONO)= +(-1.000)*rk( 26)    *y(lOH)
     &                      +(-2.000)*rk( 27)    *y(lHONO)
          JAC(lNO2 ,lPNA )= +(-1.000)*rk( 32)*flg
     &                      +(-1.000)*rk( 33)    *y(lOH)
     &                      +(-0.610)*rk( 51)*flg
          JAC(lNO2 ,lXO2 )= +(-1.000)*rk( 54)    *y(lNO)
          JAC(lNO2 ,lNTR )= +(-1.000)*rk( 62)*flg
          JAC(lNO2 ,lMEO2)= +(-1.000)*rk( 68)    *y(lNO)
          JAC(lNO2 ,lHCO3)= +(-1.000)*rk( 81)    *y(lNO)
          JAC(lNO2 ,lC2O3)= +(-1.000)*rk( 88)    *y(lNO)
     &                      +         rk( 89)    *y(lNO2)
          JAC(lNO2 ,lPAN )= +(-1.000)*rk( 90)*flg
     &                      +(-1.000)*rk( 91)*flg
          JAC(lNO2 ,lCXO3)= +(-1.000)*rk(103)    *y(lNO)
     &                      +         rk(104)    *y(lNO2)
          JAC(lNO2 ,lPANX)= +(-1.000)*rk(105)*flg
     &                      +(-1.000)*rk(106)*flg
     &                      +(-1.000)*rk(107)    *y(lOH)
          JAC(lNO2 ,lROR )= +         rk(118)    *y(lNO2)
          JAC(lNO2 ,lOLE )= +(-1.000)*rk(122)    *y(lNO3)
          JAC(lNO2 ,lETH )= +(-1.000)*rk(126)    *y(lNO3)
          JAC(lNO2 ,lIOLE)= +(-1.000)*rk(130)    *y(lNO3)
          JAC(lNO2 ,lTO2 )= +(-0.900)*rk(132)    *y(lNO)
          JAC(lNO2 ,lCRO )= +         rk(136)    *y(lNO2)
          JAC(lNO2 ,lISOP)= +(-0.200)*rk(147)    *y(lNO3)
     &                      +         rk(148)    *y(lNO2)
          JAC(lNO2 ,lTERP)= +(-0.470)*rk(156)    *y(lNO3)
          JAC(lNO  ,lNO2 )= +(-1.000)*rk(  1)*flg
     &                      +(-1.000)*rk(  4)    *y(lO)
     &                      +(-1.000)*rk( 17)    *y(lNO3)
     &                      +         rk( 23)    *y(lNO)*H2O
     &                      +(-0.200)*rk(148)    *y(lISOP)
          JAC(lNO  ,lNO  )= +         rk(  3)    *y(lO3)
     &                      +         rk(  6)    *y(lO)
     &                      +         rk( 16)    *y(lNO3)
     &                      +( 4.000)*rk( 22)    *y(lNO)*O2
     &                      +         rk( 23)    *y(lNO2)*H2O
     &                      +         rk( 24)    *y(lOH)
     &                      +         rk( 30)    *y(lHO2)
     &                      +         rk( 54)    *y(lXO2)
     &                      +         rk( 55)    *y(lXO2N)
          JAC(lNO  ,lNO  )=JAC(lNO  ,lNO  )
     &                      +         rk( 68)    *y(lMEO2)
     &                      +         rk( 81)    *y(lHCO3)
     &                      +         rk( 88)    *y(lC2O3)
     &                      +         rk(103)    *y(lCXO3)
     &                      +         rk(132)    *y(lTO2)
          JAC(lNO  ,lO   )= +(-1.000)*rk(  4)    *y(lNO2)
     &                      +         rk(  6)    *y(lNO)
          JAC(lNO  ,lO3  )= +         rk(  3)    *y(lNO)
          JAC(lNO  ,lNO3 )= +(-1.000)*rk( 15)*flg
     &                      +         rk( 16)    *y(lNO)
     &                      +(-1.000)*rk( 17)    *y(lNO2)
          JAC(lNO  ,lOH  )= +         rk( 24)    *y(lNO)
          JAC(lNO  ,lHO2 )= +         rk( 30)    *y(lNO)
          JAC(lNO  ,lHONO)= +(-1.000)*rk( 25)*flg
     &                      +(-2.000)*rk( 27)    *y(lHONO)
          JAC(lNO  ,lXO2 )= +         rk( 54)    *y(lNO)
          JAC(lNO  ,lXO2N)= +         rk( 55)    *y(lNO)
          JAC(lNO  ,lMEO2)= +         rk( 68)    *y(lNO)
          JAC(lNO  ,lHCO3)= +         rk( 81)    *y(lNO)
          JAC(lNO  ,lC2O3)= +         rk( 88)    *y(lNO)
          JAC(lNO  ,lCXO3)= +         rk(103)    *y(lNO)
          JAC(lNO  ,lTO2 )= +         rk(132)    *y(lNO)
          JAC(lNO  ,lISOP)= +(-0.200)*rk(148)    *y(lNO2)
          JAC(lO   ,lNO2 )= +(-1.000)*rk(  1)*flg
     &                      +         rk(  4)    *y(lO)
     &                      +         rk(  5)    *y(lO)
          JAC(lO   ,lNO  )= +         rk(  6)    *y(lO)
          JAC(lO   ,lO   )= +         rk(  2)*flg*O2*M
     &                      +         rk(  4)    *y(lNO2)
     &                      +         rk(  5)    *y(lNO2)
     &                      +         rk(  6)    *y(lNO)
     &                      +         rk( 40)    *y(lOH)
     &                      +         rk( 44)    *y(lHO2)
     &                      +         rk( 45)    *y(lH2O2)
     &                      +         rk( 46)    *y(lNO3)
     &                      +         rk( 77)    *y(lFORM)
          JAC(lO   ,lO   )=JAC(lO   ,lO   )
     &                      +         rk( 84)    *y(lALD2)
     &                      +         rk( 99)    *y(lALDX)
     &                      +         rk(119)    *y(lOLE)
     &                      +         rk(123)    *y(lETH)
     &                      +         rk(127)    *y(lIOLE)
     &                      +         rk(144)    *y(lISOP)
     &                      +         rk(153)    *y(lTERP)
          JAC(lO   ,lO3  )= +(-1.000)*rk(  8)*flg
     &                      +(-0.500)*rk(129)    *y(lIOLE)
          JAC(lO   ,lNO3 )= +(-1.000)*rk( 14)*flg
     &                      +         rk( 46)    *y(lO)
          JAC(lO   ,lO1D )= +(-1.000)*rk( 10)*flg*M
          JAC(lO   ,lOH  )= +         rk( 40)    *y(lO)
     &                      +(-2.000)*rk( 41)    *y(lOH)
          JAC(lO   ,lHO2 )= +         rk( 44)    *y(lO)
          JAC(lO   ,lH2O2)= +         rk( 45)    *y(lO)
          JAC(lO   ,lFORM)= +         rk( 77)    *y(lO)
          JAC(lO   ,lALD2)= +         rk( 84)    *y(lO)
          JAC(lO   ,lALDX)= +         rk( 99)    *y(lO)
          JAC(lO   ,lOLE )= +         rk(119)    *y(lO)
          JAC(lO   ,lETH )= +         rk(123)    *y(lO)
          JAC(lO   ,lIOLE)= +         rk(127)    *y(lO)
     &                      +(-0.500)*rk(129)    *y(lO3)
          JAC(lO   ,lISOP)= +         rk(144)    *y(lO)
          JAC(lO   ,lTERP)= +         rk(153)    *y(lO)
          JAC(lO3  ,lNO2 )= +         rk(  7)    *y(lO3)
          JAC(lO3  ,lNO  )= +         rk(  3)    *y(lO3)
          JAC(lO3  ,lO   )= +(-1.000)*rk(  2)*flg*O2*M
          JAC(lO3  ,lO3  )= +         rk(  3)    *y(lNO)
     &                      +         rk(  7)    *y(lNO2)
     &                      +         rk(  8)*flg
     &                      +         rk(  9)*flg
     &                      +         rk( 12)    *y(lOH)
     &                      +         rk( 13)    *y(lHO2)
     &                      +         rk( 49)    *y(lNO3)
     &                      +         rk(121)    *y(lOLE)
     &                      +         rk(125)    *y(lETH)
          JAC(lO3  ,lO3  )=JAC(lO3  ,lO3  )
     &                      +         rk(129)    *y(lIOLE)
     &                      +         rk(140)    *y(lOPEN)
     &                      +         rk(146)    *y(lISOP)
     &                      +         rk(150)    *y(lISPD)
     &                      +         rk(155)    *y(lTERP)
          JAC(lO3  ,lNO3 )= +         rk( 49)    *y(lO3)
          JAC(lO3  ,lOH  )= +         rk( 12)    *y(lO3)
          JAC(lO3  ,lHO2 )= +         rk( 13)    *y(lO3)
     &                      +(-0.200)*rk( 92)    *y(lC2O3)
     &                      +(-0.200)*rk(108)    *y(lCXO3)
          JAC(lO3  ,lC2O3)= +(-0.200)*rk( 92)    *y(lHO2)
          JAC(lO3  ,lCXO3)= +(-0.200)*rk(108)    *y(lHO2)
          JAC(lO3  ,lOLE )= +         rk(121)    *y(lO3)
          JAC(lO3  ,lETH )= +         rk(125)    *y(lO3)
          JAC(lO3  ,lIOLE)= +         rk(129)    *y(lO3)
          JAC(lO3  ,lOPEN)= +         rk(140)    *y(lO3)
          JAC(lO3  ,lISOP)= +         rk(146)    *y(lO3)
          JAC(lO3  ,lISPD)= +         rk(150)    *y(lO3)
          JAC(lO3  ,lTERP)= +         rk(155)    *y(lO3)
          JAC(lNO3 ,lNO2 )= +(-1.000)*rk(  5)    *y(lO)
     &                      +(-1.000)*rk(  7)    *y(lO3)
     &                      +         rk( 17)    *y(lNO3)
     &                      +         rk( 18)    *y(lNO3)
          JAC(lNO3 ,lNO  )= +         rk( 16)    *y(lNO3)
          JAC(lNO3 ,lO   )= +(-1.000)*rk(  5)    *y(lNO2)
     &                      +         rk( 46)    *y(lNO3)
          JAC(lNO3 ,lO3  )= +(-1.000)*rk(  7)    *y(lNO2)
     &                      +         rk( 49)    *y(lNO3)
          JAC(lNO3 ,lNO3 )= +         rk( 14)*flg
     &                      +         rk( 15)*flg
     &                      +         rk( 16)    *y(lNO)
     &                      +         rk( 17)    *y(lNO2)
     &                      +         rk( 18)    *y(lNO2)
     &                      +         rk( 46)    *y(lO)
     &                      +         rk( 47)    *y(lOH)
     &                      +         rk( 48)    *y(lHO2)
     &                      +         rk( 49)    *y(lO3)
          JAC(lNO3 ,lNO3 )=JAC(lNO3 ,lNO3 )
     &                      +( 4.000)*rk( 50)    *y(lNO3)
     &                      +         rk( 78)    *y(lFORM)
     &                      +         rk( 86)    *y(lALD2)
     &                      +         rk(101)    *y(lALDX)
     &                      +         rk(122)    *y(lOLE)
     &                      +         rk(126)    *y(lETH)
     &                      +         rk(130)    *y(lIOLE)
     &                      +         rk(135)    *y(lCRES)
          JAC(lNO3 ,lNO3 )=JAC(lNO3 ,lNO3 )
     &                      +         rk(147)    *y(lISOP)
     &                      +         rk(151)    *y(lISPD)
     &                      +         rk(156)    *y(lTERP)
          JAC(lNO3 ,lOH  )= +(-1.000)*rk( 29)    *y(lHNO3)
     &                      +         rk( 47)    *y(lNO3)
          JAC(lNO3 ,lHO2 )= +         rk( 48)    *y(lNO3)
          JAC(lNO3 ,lN2O5)= +(-1.000)*rk( 21)*flg
     &                      +(-1.000)*rk( 53)*flg
          JAC(lNO3 ,lHNO3)= +(-1.000)*rk( 29)    *y(lOH)
          JAC(lNO3 ,lPNA )= +(-0.390)*rk( 51)*flg
          JAC(lNO3 ,lFORM)= +         rk( 78)    *y(lNO3)
          JAC(lNO3 ,lALD2)= +         rk( 86)    *y(lNO3)
          JAC(lNO3 ,lALDX)= +         rk(101)    *y(lNO3)
          JAC(lNO3 ,lOLE )= +         rk(122)    *y(lNO3)
          JAC(lNO3 ,lETH )= +         rk(126)    *y(lNO3)
          JAC(lNO3 ,lIOLE)= +         rk(130)    *y(lNO3)
          JAC(lNO3 ,lCRES)= +         rk(135)    *y(lNO3)
          JAC(lNO3 ,lISOP)= +         rk(147)    *y(lNO3)
          JAC(lNO3 ,lISPD)= +         rk(151)    *y(lNO3)
          JAC(lNO3 ,lTERP)= +         rk(156)    *y(lNO3)
          JAC(lO1D ,lO3  )= +(-1.000)*rk(  9)*flg
          JAC(lO1D ,lO1D )= +         rk( 10)*flg*M
     &                      +         rk( 11)*flg*H2O
     &                      +         rk( 38)*flg*H2
          JAC(lOH  ,lNO2 )= +         rk( 28)    *y(lOH)
          JAC(lOH  ,lNO  )= +         rk( 24)    *y(lOH)
     &                      +(-1.000)*rk( 30)    *y(lHO2)
          JAC(lOH  ,lO   )= +         rk( 40)    *y(lOH)
     &                      +(-1.000)*rk( 44)    *y(lHO2)
     &                      +(-1.000)*rk( 45)    *y(lH2O2)
     &                      +(-1.000)*rk( 77)    *y(lFORM)
     &                      +(-1.000)*rk( 84)    *y(lALD2)
     &                      +(-1.000)*rk( 99)    *y(lALDX)
     &                      +(-0.100)*rk(119)    *y(lOLE)
     &                      +(-0.300)*rk(123)    *y(lETH)
          JAC(lOH  ,lO3  )= +         rk( 12)    *y(lOH)
     &                      +(-1.000)*rk( 13)    *y(lHO2)
     &                      +(-0.100)*rk(121)    *y(lOLE)
     &                      +(-0.130)*rk(125)    *y(lETH)
     &                      +(-0.500)*rk(129)    *y(lIOLE)
     &                      +(-0.080)*rk(140)    *y(lOPEN)
     &                      +(-0.266)*rk(146)    *y(lISOP)
     &                      +(-0.268)*rk(150)    *y(lISPD)
     &                      +(-0.570)*rk(155)    *y(lTERP)
          JAC(lOH  ,lNO3 )= +         rk( 47)    *y(lOH)
          JAC(lOH  ,lO1D )= +(-2.000)*rk( 11)*flg*H2O
     &                      +(-1.000)*rk( 38)*flg*H2
          JAC(lOH  ,lOH  )= +         rk( 12)    *y(lO3)
     &                      +         rk( 24)    *y(lNO)
     &                      +         rk( 26)    *y(lHONO)
     &                      +         rk( 28)    *y(lNO2)
     &                      +         rk( 29)    *y(lHNO3)
     &                      +         rk( 33)    *y(lPNA)
     &                      +         rk( 37)    *y(lH2O2)
     &                      +         rk( 39)*flg*H2
     &                      +         rk( 40)    *y(lO)
          JAC(lOH  ,lOH  )=JAC(lOH  ,lOH  )
     &                      +( 4.000)*rk( 41)    *y(lOH)
     &                      +( 4.000)*rk( 42)    *y(lOH)
     &                      +         rk( 43)    *y(lHO2)
     &                      +         rk( 47)    *y(lNO3)
     &                      +         rk( 61)    *y(lNTR)
     &                      +         rk( 63)    *y(lSO2)
     &                      +         rk( 64)    *y(lROOH)
     &                      +         rk( 66)    *y(lCO)
          JAC(lOH  ,lOH  )=JAC(lOH  ,lOH  )
     &                      +         rk( 67)*flg*CH4
     &                      +         rk( 71)    *y(lMEPX)
     &                      +         rk( 73)    *y(lMEOH)
     &                      +         rk( 74)    *y(lFORM)
     &                      +         rk( 83)    *y(lFACD)
     &                      +         rk( 85)    *y(lALD2)
     &                      +         rk( 96)    *y(lPACD)
     &                      +         rk( 98)    *y(lAACD)
          JAC(lOH  ,lOH  )=JAC(lOH  ,lOH  )
     &                      +         rk(100)    *y(lALDX)
     &                      +         rk(107)    *y(lPANX)
     &                      +         rk(113)    *y(lETHA)
     &                      +         rk(114)    *y(lETOH)
     &                      +         rk(115)    *y(lPAR)
     &                      +         rk(120)    *y(lOLE)
     &                      +         rk(124)    *y(lETH)
     &                      +         rk(128)    *y(lIOLE)
          JAC(lOH  ,lOH  )=JAC(lOH  ,lOH  )
     &                      +         rk(131)    *y(lTOL)
     &                      +         rk(134)    *y(lCRES)
     &                      +         rk(139)    *y(lOPEN)
     &                      +         rk(141)    *y(lXYL)
     &                      +         rk(142)    *y(lMGLY)
     &                      +         rk(145)    *y(lISOP)
     &                      +         rk(149)    *y(lISPD)
     &                      +         rk(154)    *y(lTERP)
          JAC(lOH  ,lHO2 )= +(-1.000)*rk( 13)    *y(lO3)
     &                      +(-1.000)*rk( 30)    *y(lNO)
     &                      +         rk( 43)    *y(lOH)
     &                      +(-1.000)*rk( 44)    *y(lO)
          JAC(lOH  ,lHNO3)= +         rk( 29)    *y(lOH)
     &                      +(-1.000)*rk( 52)*flg
          JAC(lOH  ,lHONO)= +(-1.000)*rk( 25)*flg
     &                      +         rk( 26)    *y(lOH)
          JAC(lOH  ,lPNA )= +         rk( 33)    *y(lOH)
     &                      +(-0.390)*rk( 51)*flg
          JAC(lOH  ,lH2O2)= +(-2.000)*rk( 36)*flg
     &                      +         rk( 37)    *y(lOH)
     &                      +(-1.000)*rk( 45)    *y(lO)
          JAC(lOH  ,lNTR )= +         rk( 61)    *y(lOH)
          JAC(lOH  ,lROOH)= +         rk( 64)    *y(lOH)
     &                      +(-1.000)*rk( 65)*flg
          JAC(lOH  ,lFORM)= +         rk( 74)    *y(lOH)
     &                      +(-1.000)*rk( 77)    *y(lO)
          JAC(lOH  ,lALD2)= +(-1.000)*rk( 84)    *y(lO)
     &                      +         rk( 85)    *y(lOH)
          JAC(lOH  ,lALDX)= +(-1.000)*rk( 99)    *y(lO)
     &                      +         rk(100)    *y(lOH)
          JAC(lOH  ,lPAR )= +         rk(115)    *y(lOH)
          JAC(lOH  ,lSO2 )= +         rk( 63)    *y(lOH)
          JAC(lOH  ,lCO  )= +         rk( 66)    *y(lOH)
          JAC(lOH  ,lMEPX)= +         rk( 71)    *y(lOH)
     &                      +(-1.000)*rk( 72)*flg
          JAC(lOH  ,lMEOH)= +         rk( 73)    *y(lOH)
          JAC(lOH  ,lFACD)= +         rk( 83)    *y(lOH)
          JAC(lOH  ,lPACD)= +         rk( 96)    *y(lOH)
     &                      +(-1.000)*rk( 97)*flg
          JAC(lOH  ,lAACD)= +         rk( 98)    *y(lOH)
          JAC(lOH  ,lPANX)= +         rk(107)    *y(lOH)
          JAC(lOH  ,lETHA)= +         rk(113)    *y(lOH)
          JAC(lOH  ,lETOH)= +         rk(114)    *y(lOH)
          JAC(lOH  ,lOLE )= +(-0.100)*rk(119)    *y(lO)
     &                      +         rk(120)    *y(lOH)
     &                      +(-0.100)*rk(121)    *y(lO3)
          JAC(lOH  ,lETH )= +(-0.300)*rk(123)    *y(lO)
     &                      +         rk(124)    *y(lOH)
     &                      +(-0.130)*rk(125)    *y(lO3)
          JAC(lOH  ,lIOLE)= +         rk(128)    *y(lOH)
     &                      +(-0.500)*rk(129)    *y(lO3)
          JAC(lOH  ,lTOL )= +         rk(131)    *y(lOH)
          JAC(lOH  ,lCRES)= +         rk(134)    *y(lOH)
          JAC(lOH  ,lOPEN)= +         rk(139)    *y(lOH)
     &                      +(-0.080)*rk(140)    *y(lO3)
          JAC(lOH  ,lMGLY)= +         rk(142)    *y(lOH)
          JAC(lOH  ,lXYL )= +         rk(141)    *y(lOH)
          JAC(lOH  ,lISOP)= +         rk(145)    *y(lOH)
     &                      +(-0.266)*rk(146)    *y(lO3)
          JAC(lOH  ,lISPD)= +         rk(149)    *y(lOH)
     &                      +(-0.268)*rk(150)    *y(lO3)
          JAC(lOH  ,lTERP)= +         rk(154)    *y(lOH)
     &                      +(-0.570)*rk(155)    *y(lO3)
          JAC(lHO2 ,lNO2 )= +         rk( 31)    *y(lHO2)
     &                      +(-0.800)*rk(148)    *y(lISOP)
          JAC(lHO2 ,lNO  )= +         rk( 30)    *y(lHO2)
     &                      +(-1.000)*rk( 68)    *y(lMEO2)
     &                      +(-1.000)*rk( 81)    *y(lHCO3)
     &                      +(-1.000)*rk(103)    *y(lCXO3)
     &                      +(-0.900)*rk(132)    *y(lTO2)
          JAC(lHO2 ,lO   )= +(-1.000)*rk( 40)    *y(lOH)
     &                      +         rk( 44)    *y(lHO2)
     &                      +(-1.000)*rk( 45)    *y(lH2O2)
     &                      +(-1.000)*rk( 77)    *y(lFORM)
     &                      +(-0.300)*rk(119)    *y(lOLE)
     &                      +(-1.700)*rk(123)    *y(lETH)
     &                      +(-0.100)*rk(127)    *y(lIOLE)
     &                      +(-0.250)*rk(144)    *y(lISOP)
          JAC(lHO2 ,lO3  )= +(-1.000)*rk( 12)    *y(lOH)
     &                      +         rk( 13)    *y(lHO2)
     &                      +(-0.440)*rk(121)    *y(lOLE)
     &                      +(-0.130)*rk(125)    *y(lETH)
     &                      +(-0.500)*rk(129)    *y(lIOLE)
     &                      +(-0.760)*rk(140)    *y(lOPEN)
     &                      +(-0.066)*rk(146)    *y(lISOP)
     &                      +(-0.154)*rk(150)    *y(lISPD)
     &                      +(-0.070)*rk(155)    *y(lTERP)
          JAC(lHO2 ,lNO3 )= +(-1.000)*rk( 47)    *y(lOH)
     &                      +         rk( 48)    *y(lHO2)
     &                      +(-1.000)*rk( 78)    *y(lFORM)
     &                      +(-1.000)*rk(130)    *y(lIOLE)
     &                      +(-0.800)*rk(147)    *y(lISOP)
     &                      +(-0.925)*rk(151)    *y(lISPD)
     &                      +(-0.280)*rk(156)    *y(lTERP)
          JAC(lHO2 ,lO1D )= +(-1.000)*rk( 38)*flg*H2
          JAC(lHO2 ,lOH  )= +(-1.000)*rk( 12)    *y(lO3)
     &                      +(-1.000)*rk( 37)    *y(lH2O2)
     &                      +(-1.000)*rk( 39)*flg*H2
     &                      +(-1.000)*rk( 40)    *y(lO)
     &                      +         rk( 43)    *y(lHO2)
     &                      +(-1.000)*rk( 47)    *y(lNO3)
     &                      +(-1.000)*rk( 61)    *y(lNTR)
     &                      +(-1.000)*rk( 63)    *y(lSO2)
     &                      +(-1.000)*rk( 66)    *y(lCO)
          JAC(lHO2 ,lOH  )=JAC(lHO2 ,lOH  )
     &                      +(-0.300)*rk( 71)    *y(lMEPX)
     &                      +(-1.000)*rk( 73)    *y(lMEOH)
     &                      +(-1.000)*rk( 74)    *y(lFORM)
     &                      +(-1.000)*rk( 83)    *y(lFACD)
     &                      +(-1.000)*rk(113)    *y(lETHA)
     &                      +(-1.000)*rk(114)    *y(lETOH)
     &                      +(-0.110)*rk(115)    *y(lPAR)
     &                      +(-0.950)*rk(120)    *y(lOLE)
          JAC(lHO2 ,lOH  )=JAC(lHO2 ,lOH  )
     &                      +(-1.000)*rk(124)    *y(lETH)
     &                      +(-1.000)*rk(128)    *y(lIOLE)
     &                      +(-0.440)*rk(131)    *y(lTOL)
     &                      +(-0.600)*rk(134)    *y(lCRES)
     &                      +(-2.000)*rk(139)    *y(lOPEN)
     &                      +(-0.700)*rk(141)    *y(lXYL)
     &                      +(-0.912)*rk(145)    *y(lISOP)
     &                      +(-0.503)*rk(149)    *y(lISPD)
          JAC(lHO2 ,lOH  )=JAC(lHO2 ,lOH  )
     &                      +(-0.750)*rk(154)    *y(lTERP)
          JAC(lHO2 ,lHO2 )= +         rk( 13)    *y(lO3)
     &                      +         rk( 30)    *y(lNO)
     &                      +         rk( 31)    *y(lNO2)
     &                      +( 4.000)*rk( 34)    *y(lHO2)
     &                      +( 4.000)*rk( 35)    *y(lHO2)*H2O
     &                      +         rk( 43)    *y(lOH)
     &                      +         rk( 44)    *y(lO)
     &                      +         rk( 48)    *y(lNO3)
     &                      +         rk( 56)    *y(lXO2)
          JAC(lHO2 ,lHO2 )=JAC(lHO2 ,lHO2 )
     &                      +         rk( 57)    *y(lXO2N)
     &                      +         rk( 69)    *y(lMEO2)
     &                      +         rk( 79)    *y(lFORM)
     &                      +         rk( 82)    *y(lHCO3)
     &                      +         rk( 92)    *y(lC2O3)
     &                      +         rk(108)    *y(lCXO3)
     &                      +         rk(137)    *y(lCRO)
          JAC(lHO2 ,lPNA )= +(-1.000)*rk( 32)*flg
     &                      +(-0.610)*rk( 51)*flg
          JAC(lHO2 ,lH2O2)= +(-1.000)*rk( 37)    *y(lOH)
     &                      +(-1.000)*rk( 45)    *y(lO)
          JAC(lHO2 ,lXO2 )= +         rk( 56)    *y(lHO2)
          JAC(lHO2 ,lXO2N)= +         rk( 57)    *y(lHO2)
          JAC(lHO2 ,lNTR )= +(-1.000)*rk( 61)    *y(lOH)
     &                      +(-1.000)*rk( 62)*flg
          JAC(lHO2 ,lROOH)= +(-1.000)*rk( 65)*flg
          JAC(lHO2 ,lFORM)= +(-1.000)*rk( 74)    *y(lOH)
     &                      +(-2.000)*rk( 75)*flg
     &                      +(-1.000)*rk( 77)    *y(lO)
     &                      +(-1.000)*rk( 78)    *y(lNO3)
     &                      +         rk( 79)    *y(lHO2)
          JAC(lHO2 ,lALD2)= +(-1.000)*rk( 87)*flg
          JAC(lHO2 ,lALDX)= +(-1.000)*rk(102)*flg
          JAC(lHO2 ,lPAR )= +(-0.110)*rk(115)    *y(lOH)
          JAC(lHO2 ,lSO2 )= +(-1.000)*rk( 63)    *y(lOH)
          JAC(lHO2 ,lCO  )= +(-1.000)*rk( 66)    *y(lOH)
          JAC(lHO2 ,lMEO2)= +(-1.000)*rk( 68)    *y(lNO)
     &                      +         rk( 69)    *y(lHO2)
     &                      +(-1.480)*rk( 70)    *y(lMEO2)
     &                      +(-0.900)*rk( 93)    *y(lC2O3)
     &                      +(-1.000)*rk(109)    *y(lCXO3)
          JAC(lHO2 ,lMEPX)= +(-0.300)*rk( 71)    *y(lOH)
     &                      +(-1.000)*rk( 72)*flg
          JAC(lHO2 ,lMEOH)= +(-1.000)*rk( 73)    *y(lOH)
          JAC(lHO2 ,lHCO3)= +(-1.000)*rk( 80)*flg
     &                      +(-1.000)*rk( 81)    *y(lNO)
     &                      +         rk( 82)    *y(lHO2)
          JAC(lHO2 ,lFACD)= +(-1.000)*rk( 83)    *y(lOH)
          JAC(lHO2 ,lC2O3)= +         rk( 92)    *y(lHO2)
     &                      +(-0.900)*rk( 93)    *y(lMEO2)
     &                      +(-1.000)*rk(112)    *y(lCXO3)
          JAC(lHO2 ,lCXO3)= +(-1.000)*rk(103)    *y(lNO)
     &                      +         rk(108)    *y(lHO2)
     &                      +(-1.000)*rk(109)    *y(lMEO2)
     &                      +(-4.000)*rk(111)    *y(lCXO3)
     &                      +(-1.000)*rk(112)    *y(lC2O3)
          JAC(lHO2 ,lETHA)= +(-1.000)*rk(113)    *y(lOH)
          JAC(lHO2 ,lETOH)= +(-1.000)*rk(114)    *y(lOH)
          JAC(lHO2 ,lROR )= +(-0.940)*rk(116)*flg
     &                      +(-1.000)*rk(117)*flg
          JAC(lHO2 ,lOLE )= +(-0.300)*rk(119)    *y(lO)
     &                      +(-0.950)*rk(120)    *y(lOH)
     &                      +(-0.440)*rk(121)    *y(lO3)
          JAC(lHO2 ,lETH )= +(-1.700)*rk(123)    *y(lO)
     &                      +(-1.000)*rk(124)    *y(lOH)
     &                      +(-0.130)*rk(125)    *y(lO3)
          JAC(lHO2 ,lIOLE)= +(-0.100)*rk(127)    *y(lO)
     &                      +(-1.000)*rk(128)    *y(lOH)
     &                      +(-0.500)*rk(129)    *y(lO3)
     &                      +(-1.000)*rk(130)    *y(lNO3)
          JAC(lHO2 ,lTOL )= +(-0.440)*rk(131)    *y(lOH)
          JAC(lHO2 ,lCRES)= +(-0.600)*rk(134)    *y(lOH)
          JAC(lHO2 ,lTO2 )= +(-0.900)*rk(132)    *y(lNO)
     &                      +(-1.000)*rk(133)*flg
          JAC(lHO2 ,lOPEN)= +(-1.000)*rk(138)*flg
     &                      +(-2.000)*rk(139)    *y(lOH)
     &                      +(-0.760)*rk(140)    *y(lO3)
          JAC(lHO2 ,lCRO )= +         rk(137)    *y(lHO2)
          JAC(lHO2 ,lMGLY)= +(-1.000)*rk(143)*flg
          JAC(lHO2 ,lXYL )= +(-0.700)*rk(141)    *y(lOH)
          JAC(lHO2 ,lISOP)= +(-0.250)*rk(144)    *y(lO)
     &                      +(-0.912)*rk(145)    *y(lOH)
     &                      +(-0.066)*rk(146)    *y(lO3)
     &                      +(-0.800)*rk(147)    *y(lNO3)
     &                      +(-0.800)*rk(148)    *y(lNO2)
          JAC(lHO2 ,lISPD)= +(-0.503)*rk(149)    *y(lOH)
     &                      +(-0.154)*rk(150)    *y(lO3)
     &                      +(-0.925)*rk(151)    *y(lNO3)
     &                      +(-1.033)*rk(152)*flg
          JAC(lHO2 ,lTERP)= +(-0.750)*rk(154)    *y(lOH)
     &                      +(-0.070)*rk(155)    *y(lO3)
     &                      +(-0.280)*rk(156)    *y(lNO3)
          JAC(lN2O5,lNO2 )= +(-1.000)*rk( 18)    *y(lNO3)
          JAC(lN2O5,lNO3 )= +(-1.000)*rk( 18)    *y(lNO2)
          JAC(lN2O5,lN2O5)= +         rk( 19)*flg*H2O
     &                      +         rk( 20)*flg*H2O*H2O
     &                      +         rk( 21)*flg
     &                      +         rk( 53)*flg
          JAC(lHNO3,lNO2 )= +(-1.000)*rk( 28)    *y(lOH)
          JAC(lHNO3,lNO3 )= +(-1.000)*rk( 48)    *y(lHO2)
     &                      +(-1.000)*rk( 78)    *y(lFORM)
     &                      +(-1.000)*rk( 86)    *y(lALD2)
     &                      +(-1.000)*rk(101)    *y(lALDX)
     &                      +(-1.000)*rk(135)    *y(lCRES)
     &                      +(-0.150)*rk(151)    *y(lISPD)
          JAC(lHNO3,lOH  )= +(-1.000)*rk( 28)    *y(lNO2)
     &                      +         rk( 29)    *y(lHNO3)
     &                      +(-1.000)*rk( 61)    *y(lNTR)
          JAC(lHNO3,lHO2 )= +(-1.000)*rk( 48)    *y(lNO3)
          JAC(lHNO3,lN2O5)= +(-2.000)*rk( 19)*flg*H2O
     &                      +(-2.000)*rk( 20)*flg*H2O*H2O
          JAC(lHNO3,lHNO3)= +         rk( 29)    *y(lOH)
     &                      +         rk( 52)*flg
          JAC(lHNO3,lNTR )= +(-1.000)*rk( 61)    *y(lOH)
          JAC(lHNO3,lFORM)= +(-1.000)*rk( 78)    *y(lNO3)
          JAC(lHNO3,lALD2)= +(-1.000)*rk( 86)    *y(lNO3)
          JAC(lHNO3,lALDX)= +(-1.000)*rk(101)    *y(lNO3)
          JAC(lHNO3,lCRES)= +(-1.000)*rk(135)    *y(lNO3)
          JAC(lHNO3,lISPD)= +(-0.150)*rk(151)    *y(lNO3)
          JAC(lHONO,lNO2 )= +(-2.000)*rk( 23)    *y(lNO)*H2O
          JAC(lHONO,lNO  )= +(-2.000)*rk( 23)    *y(lNO2)*H2O
     &                      +(-1.000)*rk( 24)    *y(lOH)
          JAC(lHONO,lOH  )= +(-1.000)*rk( 24)    *y(lNO)
     &                      +         rk( 26)    *y(lHONO)
          JAC(lHONO,lHONO)= +         rk( 25)*flg
     &                      +         rk( 26)    *y(lOH)
     &                      +( 4.000)*rk( 27)    *y(lHONO)
          JAC(lPNA ,lNO2 )= +(-1.000)*rk( 31)    *y(lHO2)
          JAC(lPNA ,lOH  )= +         rk( 33)    *y(lPNA)
          JAC(lPNA ,lHO2 )= +(-1.000)*rk( 31)    *y(lNO2)
          JAC(lPNA ,lPNA )= +         rk( 32)*flg
     &                      +         rk( 33)    *y(lOH)
     &                      +         rk( 51)*flg
          JAC(lH2O2,lO   )= +         rk( 45)    *y(lH2O2)
          JAC(lH2O2,lOH  )= +         rk( 37)    *y(lH2O2)
     &                      +(-2.000)*rk( 42)    *y(lOH)
          JAC(lH2O2,lHO2 )= +(-2.000)*rk( 34)    *y(lHO2)
     &                      +(-2.000)*rk( 35)    *y(lHO2)*H2O
          JAC(lH2O2,lH2O2)= +         rk( 36)*flg
     &                      +         rk( 37)    *y(lOH)
     &                      +         rk( 45)    *y(lO)
          JAC(lXO2 ,lNO2 )= +(-1.000)*rk(148)    *y(lISOP)
          JAC(lXO2 ,lNO  )= +         rk( 54)    *y(lXO2)
     &                      +(-1.000)*rk(103)    *y(lCXO3)
          JAC(lXO2 ,lO   )= +(-0.200)*rk(119)    *y(lOLE)
     &                      +(-0.700)*rk(123)    *y(lETH)
     &                      +(-0.100)*rk(127)    *y(lIOLE)
     &                      +(-0.250)*rk(144)    *y(lISOP)
          JAC(lXO2 ,lO3  )= +(-0.220)*rk(121)    *y(lOLE)
     &                      +(-0.030)*rk(140)    *y(lOPEN)
     &                      +(-0.200)*rk(146)    *y(lISOP)
     &                      +(-0.064)*rk(150)    *y(lISPD)
     &                      +(-0.760)*rk(155)    *y(lTERP)
          JAC(lXO2 ,lNO3 )= +(-0.910)*rk(122)    *y(lOLE)
     &                      +(-1.000)*rk(126)    *y(lETH)
     &                      +(-1.000)*rk(147)    *y(lISOP)
     &                      +(-0.075)*rk(151)    *y(lISPD)
     &                      +(-1.030)*rk(156)    *y(lTERP)
          JAC(lXO2 ,lOH  )= +(-1.000)*rk( 64)    *y(lROOH)
     &                      +(-0.300)*rk( 71)    *y(lMEPX)
     &                      +(-0.991)*rk(113)    *y(lETHA)
     &                      +(-0.100)*rk(114)    *y(lETOH)
     &                      +(-0.870)*rk(115)    *y(lPAR)
     &                      +(-0.800)*rk(120)    *y(lOLE)
     &                      +(-1.000)*rk(124)    *y(lETH)
     &                      +(-1.000)*rk(128)    *y(lIOLE)
     &                      +(-0.080)*rk(131)    *y(lTOL)
          JAC(lXO2 ,lOH  )=JAC(lXO2 ,lOH  )
     &                      +(-0.600)*rk(134)    *y(lCRES)
     &                      +(-1.000)*rk(139)    *y(lOPEN)
     &                      +(-0.500)*rk(141)    *y(lXYL)
     &                      +(-1.000)*rk(142)    *y(lMGLY)
     &                      +(-0.991)*rk(145)    *y(lISOP)
     &                      +(-0.713)*rk(149)    *y(lISPD)
     &                      +(-1.250)*rk(154)    *y(lTERP)
          JAC(lXO2 ,lHO2 )= +         rk( 56)    *y(lXO2)
          JAC(lXO2 ,lXO2 )= +         rk( 54)    *y(lNO)
     &                      +         rk( 56)    *y(lHO2)
     &                      +( 4.000)*rk( 58)    *y(lXO2)
     &                      +         rk( 60)    *y(lXO2N)
     &                      +         rk( 94)    *y(lC2O3)
     &                      +         rk(110)    *y(lCXO3)
          JAC(lXO2 ,lXO2N)= +         rk( 60)    *y(lXO2)
          JAC(lXO2 ,lROOH)= +(-1.000)*rk( 64)    *y(lOH)
          JAC(lXO2 ,lPAR )= +(-0.870)*rk(115)    *y(lOH)
          JAC(lXO2 ,lMEO2)= +(-0.900)*rk(109)    *y(lCXO3)
          JAC(lXO2 ,lMEPX)= +(-0.300)*rk( 71)    *y(lOH)
          JAC(lXO2 ,lC2O3)= +         rk( 94)    *y(lXO2)
     &                      +(-1.000)*rk(112)    *y(lCXO3)
          JAC(lXO2 ,lCXO3)= +(-1.000)*rk(103)    *y(lNO)
     &                      +(-0.900)*rk(109)    *y(lMEO2)
     &                      +         rk(110)    *y(lXO2)
     &                      +(-4.000)*rk(111)    *y(lCXO3)
     &                      +(-1.000)*rk(112)    *y(lC2O3)
          JAC(lXO2 ,lETHA)= +(-0.991)*rk(113)    *y(lOH)
          JAC(lXO2 ,lETOH)= +(-0.100)*rk(114)    *y(lOH)
          JAC(lXO2 ,lROR )= +(-0.960)*rk(116)*flg
          JAC(lXO2 ,lOLE )= +(-0.200)*rk(119)    *y(lO)
     &                      +(-0.800)*rk(120)    *y(lOH)
     &                      +(-0.220)*rk(121)    *y(lO3)
     &                      +(-0.910)*rk(122)    *y(lNO3)
          JAC(lXO2 ,lETH )= +(-0.700)*rk(123)    *y(lO)
     &                      +(-1.000)*rk(124)    *y(lOH)
     &                      +(-1.000)*rk(126)    *y(lNO3)
          JAC(lXO2 ,lIOLE)= +(-0.100)*rk(127)    *y(lO)
     &                      +(-1.000)*rk(128)    *y(lOH)
          JAC(lXO2 ,lTOL )= +(-0.080)*rk(131)    *y(lOH)
          JAC(lXO2 ,lCRES)= +(-0.600)*rk(134)    *y(lOH)
          JAC(lXO2 ,lOPEN)= +(-1.000)*rk(139)    *y(lOH)
     &                      +(-0.030)*rk(140)    *y(lO3)
          JAC(lXO2 ,lMGLY)= +(-1.000)*rk(142)    *y(lOH)
          JAC(lXO2 ,lXYL )= +(-0.500)*rk(141)    *y(lOH)
          JAC(lXO2 ,lISOP)= +(-0.250)*rk(144)    *y(lO)
     &                      +(-0.991)*rk(145)    *y(lOH)
     &                      +(-0.200)*rk(146)    *y(lO3)
     &                      +(-1.000)*rk(147)    *y(lNO3)
     &                      +(-1.000)*rk(148)    *y(lNO2)
          JAC(lXO2 ,lISPD)= +(-0.713)*rk(149)    *y(lOH)
     &                      +(-0.064)*rk(150)    *y(lO3)
     &                      +(-0.075)*rk(151)    *y(lNO3)
     &                      +(-0.700)*rk(152)*flg
          JAC(lXO2 ,lTERP)= +(-1.250)*rk(154)    *y(lOH)
     &                      +(-0.760)*rk(155)    *y(lO3)
     &                      +(-1.030)*rk(156)    *y(lNO3)
          JAC(lXO2N,lNO  )= +         rk( 55)    *y(lXO2N)
          JAC(lXO2N,lO   )= +(-0.010)*rk(119)    *y(lOLE)
          JAC(lXO2N,lO3  )= +(-0.180)*rk(155)    *y(lTERP)
          JAC(lXO2N,lNO3 )= +(-0.090)*rk(122)    *y(lOLE)
     &                      +(-0.250)*rk(156)    *y(lTERP)
          JAC(lXO2N,lOH  )= +(-0.009)*rk(113)    *y(lETHA)
     &                      +(-0.130)*rk(115)    *y(lPAR)
     &                      +(-0.088)*rk(145)    *y(lISOP)
     &                      +(-0.250)*rk(154)    *y(lTERP)
          JAC(lXO2N,lHO2 )= +         rk( 57)    *y(lXO2N)
          JAC(lXO2N,lXO2 )= +         rk( 60)    *y(lXO2N)
          JAC(lXO2N,lXO2N)= +         rk( 55)    *y(lNO)
     &                      +         rk( 57)    *y(lHO2)
     &                      +( 4.000)*rk( 59)    *y(lXO2N)
     &                      +         rk( 60)    *y(lXO2)
          JAC(lXO2N,lPAR )= +(-0.130)*rk(115)    *y(lOH)
          JAC(lXO2N,lETHA)= +(-0.009)*rk(113)    *y(lOH)
          JAC(lXO2N,lROR )= +(-0.040)*rk(116)*flg
          JAC(lXO2N,lOLE )= +(-0.010)*rk(119)    *y(lO)
     &                      +(-0.090)*rk(122)    *y(lNO3)
          JAC(lXO2N,lISOP)= +(-0.088)*rk(145)    *y(lOH)
          JAC(lXO2N,lTERP)= +(-0.250)*rk(154)    *y(lOH)
     &                      +(-0.180)*rk(155)    *y(lO3)
     &                      +(-0.250)*rk(156)    *y(lNO3)
          JAC(lNTR ,lNO2 )= +(-1.000)*rk(118)    *y(lROR)
     &                      +(-1.000)*rk(136)    *y(lCRO)
     &                      +(-0.800)*rk(148)    *y(lISOP)
          JAC(lNTR ,lNO  )= +(-1.000)*rk( 55)    *y(lXO2N)
     &                      +(-0.100)*rk(132)    *y(lTO2)
          JAC(lNTR ,lNO3 )= +(-0.800)*rk(147)    *y(lISOP)
     &                      +(-0.850)*rk(151)    *y(lISPD)
     &                      +(-0.530)*rk(156)    *y(lTERP)
          JAC(lNTR ,lOH  )= +         rk( 61)    *y(lNTR)
          JAC(lNTR ,lXO2N)= +(-1.000)*rk( 55)    *y(lNO)
          JAC(lNTR ,lNTR )= +         rk( 61)    *y(lOH)
     &                      +         rk( 62)*flg
          JAC(lNTR ,lROR )= +(-1.000)*rk(118)    *y(lNO2)
          JAC(lNTR ,lTO2 )= +(-0.100)*rk(132)    *y(lNO)
          JAC(lNTR ,lCRO )= +(-1.000)*rk(136)    *y(lNO2)
          JAC(lNTR ,lISOP)= +(-0.800)*rk(147)    *y(lNO3)
     &                      +(-0.800)*rk(148)    *y(lNO2)
          JAC(lNTR ,lISPD)= +(-0.850)*rk(151)    *y(lNO3)
          JAC(lNTR ,lTERP)= +(-0.530)*rk(156)    *y(lNO3)
          JAC(lROOH,lOH  )= +         rk( 64)    *y(lROOH)
          JAC(lROOH,lHO2 )= +(-1.000)*rk( 56)    *y(lXO2)
     &                      +(-1.000)*rk( 57)    *y(lXO2N)
          JAC(lROOH,lXO2 )= +(-1.000)*rk( 56)    *y(lHO2)
          JAC(lROOH,lXO2N)= +(-1.000)*rk( 57)    *y(lHO2)
          JAC(lROOH,lROOH)= +         rk( 64)    *y(lOH)
     &                      +         rk( 65)*flg
          JAC(lFORM,lNO  )= +(-1.000)*rk( 68)    *y(lMEO2)
          JAC(lFORM,lO   )= +         rk( 77)    *y(lFORM)
     &                      +(-0.200)*rk(119)    *y(lOLE)
     &                      +(-1.000)*rk(123)    *y(lETH)
     &                      +(-0.500)*rk(144)    *y(lISOP)
          JAC(lFORM,lO3  )= +(-0.740)*rk(121)    *y(lOLE)
     &                      +(-1.000)*rk(125)    *y(lETH)
     &                      +(-0.250)*rk(129)    *y(lIOLE)
     &                      +(-0.700)*rk(140)    *y(lOPEN)
     &                      +(-0.600)*rk(146)    *y(lISOP)
     &                      +(-0.150)*rk(150)    *y(lISPD)
     &                      +(-0.240)*rk(155)    *y(lTERP)
          JAC(lFORM,lNO3 )= +         rk( 78)    *y(lFORM)
     &                      +(-1.000)*rk(122)    *y(lOLE)
     &                      +(-2.000)*rk(126)    *y(lETH)
     &                      +(-0.282)*rk(151)    *y(lISPD)
          JAC(lFORM,lOH  )= +(-0.330)*rk( 61)    *y(lNTR)
     &                      +(-1.000)*rk( 73)    *y(lMEOH)
     &                      +         rk( 74)    *y(lFORM)
     &                      +(-0.100)*rk(114)    *y(lETOH)
     &                      +(-0.800)*rk(120)    *y(lOLE)
     &                      +(-1.560)*rk(124)    *y(lETH)
     &                      +(-1.000)*rk(139)    *y(lOPEN)
     &                      +(-0.629)*rk(145)    *y(lISOP)
     &                      +(-0.167)*rk(149)    *y(lISPD)
          JAC(lFORM,lOH  )=JAC(lFORM,lOH  )
     &                      +(-0.280)*rk(154)    *y(lTERP)
          JAC(lFORM,lHO2 )= +         rk( 79)    *y(lFORM)
          JAC(lFORM,lNTR )= +(-0.330)*rk( 61)    *y(lOH)
     &                      +(-0.330)*rk( 62)*flg
          JAC(lFORM,lFORM)= +         rk( 74)    *y(lOH)
     &                      +         rk( 75)*flg
     &                      +         rk( 76)*flg
     &                      +         rk( 77)    *y(lO)
     &                      +         rk( 78)    *y(lNO3)
     &                      +         rk( 79)    *y(lHO2)
          JAC(lFORM,lMEO2)= +(-1.000)*rk( 68)    *y(lNO)
     &                      +(-2.740)*rk( 70)    *y(lMEO2)
     &                      +(-1.000)*rk( 93)    *y(lC2O3)
     &                      +(-0.100)*rk(109)    *y(lCXO3)
          JAC(lFORM,lMEPX)= +(-1.000)*rk( 72)*flg
          JAC(lFORM,lMEOH)= +(-1.000)*rk( 73)    *y(lOH)
          JAC(lFORM,lHCO3)= +(-1.000)*rk( 80)*flg
          JAC(lFORM,lC2O3)= +(-1.000)*rk( 93)    *y(lMEO2)
          JAC(lFORM,lCXO3)= +(-0.100)*rk(109)    *y(lMEO2)
          JAC(lFORM,lETOH)= +(-0.100)*rk(114)    *y(lOH)
          JAC(lFORM,lOLE )= +(-0.200)*rk(119)    *y(lO)
     &                      +(-0.800)*rk(120)    *y(lOH)
     &                      +(-0.740)*rk(121)    *y(lO3)
     &                      +(-1.000)*rk(122)    *y(lNO3)
          JAC(lFORM,lETH )= +(-1.000)*rk(123)    *y(lO)
     &                      +(-1.560)*rk(124)    *y(lOH)
     &                      +(-1.000)*rk(125)    *y(lO3)
     &                      +(-2.000)*rk(126)    *y(lNO3)
          JAC(lFORM,lIOLE)= +(-0.250)*rk(129)    *y(lO3)
          JAC(lFORM,lOPEN)= +(-1.000)*rk(139)    *y(lOH)
     &                      +(-0.700)*rk(140)    *y(lO3)
          JAC(lFORM,lISOP)= +(-0.500)*rk(144)    *y(lO)
     &                      +(-0.629)*rk(145)    *y(lOH)
     &                      +(-0.600)*rk(146)    *y(lO3)
          JAC(lFORM,lISPD)= +(-0.167)*rk(149)    *y(lOH)
     &                      +(-0.150)*rk(150)    *y(lO3)
     &                      +(-0.282)*rk(151)    *y(lNO3)
     &                      +(-0.900)*rk(152)*flg
          JAC(lFORM,lTERP)= +(-0.280)*rk(154)    *y(lOH)
     &                      +(-0.240)*rk(155)    *y(lO3)
          JAC(lALD2,lNO  )= +(-1.000)*rk(103)    *y(lCXO3)
          JAC(lALD2,lO   )= +         rk( 84)    *y(lALD2)
     &                      +(-0.200)*rk(119)    *y(lOLE)
     &                      +(-1.240)*rk(127)    *y(lIOLE)
          JAC(lALD2,lO3  )= +(-0.180)*rk(121)    *y(lOLE)
     &                      +(-0.650)*rk(129)    *y(lIOLE)
     &                      +(-0.020)*rk(150)    *y(lISPD)
          JAC(lALD2,lNO3 )= +         rk( 86)    *y(lALD2)
     &                      +(-0.350)*rk(122)    *y(lOLE)
     &                      +(-1.180)*rk(130)    *y(lIOLE)
          JAC(lALD2,lOH  )= +(-0.330)*rk( 61)    *y(lNTR)
     &                      +(-0.500)*rk( 64)    *y(lROOH)
     &                      +         rk( 85)    *y(lALD2)
     &                      +(-1.000)*rk(107)    *y(lPANX)
     &                      +(-0.991)*rk(113)    *y(lETHA)
     &                      +(-0.900)*rk(114)    *y(lETOH)
     &                      +(-0.060)*rk(115)    *y(lPAR)
     &                      +(-0.330)*rk(120)    *y(lOLE)
     &                      +(-1.300)*rk(128)    *y(lIOLE)
          JAC(lALD2,lOH  )=JAC(lALD2,lOH  )
     &                      +(-0.252)*rk(149)    *y(lISPD)
          JAC(lALD2,lXO2 )= +(-0.900)*rk(110)    *y(lCXO3)
          JAC(lALD2,lNTR )= +(-0.330)*rk( 61)    *y(lOH)
     &                      +(-0.330)*rk( 62)*flg
          JAC(lALD2,lROOH)= +(-0.500)*rk( 64)    *y(lOH)
     &                      +(-0.500)*rk( 65)*flg
          JAC(lALD2,lALD2)= +         rk( 84)    *y(lO)
     &                      +         rk( 85)    *y(lOH)
     &                      +         rk( 86)    *y(lNO3)
     &                      +         rk( 87)*flg
          JAC(lALD2,lPAR )= +(-0.060)*rk(115)    *y(lOH)
          JAC(lALD2,lMEO2)= +(-0.900)*rk(109)    *y(lCXO3)
          JAC(lALD2,lC2O3)= +(-1.000)*rk(112)    *y(lCXO3)
          JAC(lALD2,lCXO3)= +(-1.000)*rk(103)    *y(lNO)
     &                      +(-0.900)*rk(109)    *y(lMEO2)
     &                      +(-0.900)*rk(110)    *y(lXO2)
     &                      +(-4.000)*rk(111)    *y(lCXO3)
     &                      +(-1.000)*rk(112)    *y(lC2O3)
          JAC(lALD2,lPANX)= +(-1.000)*rk(107)    *y(lOH)
          JAC(lALD2,lETHA)= +(-0.991)*rk(113)    *y(lOH)
          JAC(lALD2,lETOH)= +(-0.900)*rk(114)    *y(lOH)
          JAC(lALD2,lROR )= +(-0.600)*rk(116)*flg
          JAC(lALD2,lOLE )= +(-0.200)*rk(119)    *y(lO)
     &                      +(-0.330)*rk(120)    *y(lOH)
     &                      +(-0.180)*rk(121)    *y(lO3)
     &                      +(-0.350)*rk(122)    *y(lNO3)
          JAC(lALD2,lIOLE)= +(-1.240)*rk(127)    *y(lO)
     &                      +(-1.300)*rk(128)    *y(lOH)
     &                      +(-0.650)*rk(129)    *y(lO3)
     &                      +(-1.180)*rk(130)    *y(lNO3)
          JAC(lALD2,lISPD)= +(-0.252)*rk(149)    *y(lOH)
     &                      +(-0.020)*rk(150)    *y(lO3)
     &                      +(-0.067)*rk(152)*flg
          JAC(lALDX,lNO2 )= +(-0.800)*rk(148)    *y(lISOP)
          JAC(lALDX,lO   )= +         rk( 99)    *y(lALDX)
     &                      +(-0.300)*rk(119)    *y(lOLE)
     &                      +(-0.660)*rk(127)    *y(lIOLE)
     &                      +(-0.150)*rk(153)    *y(lTERP)
          JAC(lALDX,lO3  )= +(-0.320)*rk(121)    *y(lOLE)
     &                      +(-0.350)*rk(129)    *y(lIOLE)
     &                      +(-0.030)*rk(140)    *y(lOPEN)
     &                      +(-0.150)*rk(146)    *y(lISOP)
     &                      +(-0.210)*rk(155)    *y(lTERP)
          JAC(lALDX,lNO3 )= +         rk(101)    *y(lALDX)
     &                      +(-0.560)*rk(122)    *y(lOLE)
     &                      +(-0.640)*rk(130)    *y(lIOLE)
     &                      +(-0.800)*rk(147)    *y(lISOP)
     &                      +(-0.357)*rk(151)    *y(lISPD)
     &                      +(-0.470)*rk(156)    *y(lTERP)
          JAC(lALDX,lOH  )= +(-0.330)*rk( 61)    *y(lNTR)
     &                      +(-0.500)*rk( 64)    *y(lROOH)
     &                      +         rk(100)    *y(lALDX)
     &                      +(-0.050)*rk(114)    *y(lETOH)
     &                      +(-0.050)*rk(115)    *y(lPAR)
     &                      +(-0.620)*rk(120)    *y(lOLE)
     &                      +(-0.220)*rk(124)    *y(lETH)
     &                      +(-0.700)*rk(128)    *y(lIOLE)
     &                      +(-0.120)*rk(149)    *y(lISPD)
          JAC(lALDX,lOH  )=JAC(lALDX,lOH  )
     &                      +(-0.470)*rk(154)    *y(lTERP)
          JAC(lALDX,lNTR )= +(-0.330)*rk( 61)    *y(lOH)
     &                      +(-0.330)*rk( 62)*flg
          JAC(lALDX,lROOH)= +(-0.500)*rk( 64)    *y(lOH)
     &                      +(-0.500)*rk( 65)*flg
          JAC(lALDX,lALDX)= +         rk( 99)    *y(lO)
     &                      +         rk(100)    *y(lOH)
     &                      +         rk(101)    *y(lNO3)
     &                      +         rk(102)*flg
          JAC(lALDX,lPAR )= +(-0.050)*rk(115)    *y(lOH)
          JAC(lALDX,lETOH)= +(-0.050)*rk(114)    *y(lOH)
          JAC(lALDX,lROR )= +(-0.500)*rk(116)*flg
          JAC(lALDX,lOLE )= +(-0.300)*rk(119)    *y(lO)
     &                      +(-0.620)*rk(120)    *y(lOH)
     &                      +(-0.320)*rk(121)    *y(lO3)
     &                      +(-0.560)*rk(122)    *y(lNO3)
          JAC(lALDX,lETH )= +(-0.220)*rk(124)    *y(lOH)
          JAC(lALDX,lIOLE)= +(-0.660)*rk(127)    *y(lO)
     &                      +(-0.700)*rk(128)    *y(lOH)
     &                      +(-0.350)*rk(129)    *y(lO3)
     &                      +(-0.640)*rk(130)    *y(lNO3)
          JAC(lALDX,lOPEN)= +(-0.030)*rk(140)    *y(lO3)
          JAC(lALDX,lISOP)= +(-0.150)*rk(146)    *y(lO3)
     &                      +(-0.800)*rk(147)    *y(lNO3)
     &                      +(-0.800)*rk(148)    *y(lNO2)
          JAC(lALDX,lISPD)= +(-0.120)*rk(149)    *y(lOH)
     &                      +(-0.357)*rk(151)    *y(lNO3)
          JAC(lALDX,lTERP)= +(-0.150)*rk(153)    *y(lO)
     &                      +(-0.470)*rk(154)    *y(lOH)
     &                      +(-0.210)*rk(155)    *y(lO3)
     &                      +(-0.470)*rk(156)    *y(lNO3)
          JAC(lPAR ,lNO2 )= +(-2.400)*rk(148)    *y(lISOP)
          JAC(lPAR ,lO   )= +(-0.200)*rk(119)    *y(lOLE)
     &                      +(-0.100)*rk(127)    *y(lIOLE)
     &                      +(-0.250)*rk(144)    *y(lISOP)
     &                      +(-5.120)*rk(153)    *y(lTERP)
          JAC(lPAR ,lO3  )= +         rk(121)    *y(lOLE)
     &                      +(-0.350)*rk(146)    *y(lISOP)
     &                      +(-0.360)*rk(150)    *y(lISPD)
     &                      +(-7.000)*rk(155)    *y(lTERP)
          JAC(lPAR ,lNO3 )= +         rk(122)    *y(lOLE)
     &                      +(-2.400)*rk(147)    *y(lISOP)
     &                      +(-1.282)*rk(151)    *y(lISPD)
          JAC(lPAR ,lOH  )= +( 0.660)*rk( 61)    *y(lNTR)
     &                      +         rk(115)    *y(lPAR)
     &                      +( 0.110)*rk(115)    *y(lPAR)
     &                      +( 0.700)*rk(120)    *y(lOLE)
     &                      +(-1.100)*rk(141)    *y(lXYL)
     &                      +(-1.565)*rk(149)    *y(lISPD)
     &                      +(-1.660)*rk(154)    *y(lTERP)
          JAC(lPAR ,lNTR )= +( 0.660)*rk( 61)    *y(lOH)
     &                      +( 0.660)*rk( 62)*flg
          JAC(lPAR ,lPAR )= +         rk(115)    *y(lOH)
     &                      +( 0.110)*rk(115)    *y(lOH)
          JAC(lPAR ,lROR )= +( 2.100)*rk(116)*flg
          JAC(lPAR ,lOLE )= +(-0.200)*rk(119)    *y(lO)
     &                      +( 0.700)*rk(120)    *y(lOH)
     &                      +         rk(121)    *y(lO3)
     &                      +         rk(122)    *y(lNO3)
          JAC(lPAR ,lIOLE)= +(-0.100)*rk(127)    *y(lO)
          JAC(lPAR ,lXYL )= +(-1.100)*rk(141)    *y(lOH)
          JAC(lPAR ,lISOP)= +(-0.250)*rk(144)    *y(lO)
     &                      +(-0.350)*rk(146)    *y(lO3)
     &                      +(-2.400)*rk(147)    *y(lNO3)
     &                      +(-2.400)*rk(148)    *y(lNO2)
          JAC(lPAR ,lISPD)= +(-1.565)*rk(149)    *y(lOH)
     &                      +(-0.360)*rk(150)    *y(lO3)
     &                      +(-1.282)*rk(151)    *y(lNO3)
     &                      +(-0.832)*rk(152)*flg
          JAC(lPAR ,lTERP)= +(-5.120)*rk(153)    *y(lO)
     &                      +(-1.660)*rk(154)    *y(lOH)
     &                      +(-7.000)*rk(155)    *y(lO3)
          JAC(lSO2 ,lOH  )= +         rk( 63)    *y(lSO2)
          JAC(lSO2 ,lSO2 )= +         rk( 63)    *y(lOH)
          JAC(lSULF,lOH  )= +(-1.000)*rk( 63)    *y(lSO2)
          JAC(lSULF,lSO2 )= +(-1.000)*rk( 63)    *y(lOH)
          JAC(lCO  ,lO   )= +(-1.000)*rk( 77)    *y(lFORM)
     &                      +(-0.200)*rk(119)    *y(lOLE)
     &                      +(-1.000)*rk(123)    *y(lETH)
     &                      +(-0.100)*rk(127)    *y(lIOLE)
          JAC(lCO  ,lO3  )= +(-0.330)*rk(121)    *y(lOLE)
     &                      +(-0.630)*rk(125)    *y(lETH)
     &                      +(-0.250)*rk(129)    *y(lIOLE)
     &                      +(-0.690)*rk(140)    *y(lOPEN)
     &                      +(-0.066)*rk(146)    *y(lISOP)
     &                      +(-0.225)*rk(150)    *y(lISPD)
     &                      +(-0.001)*rk(155)    *y(lTERP)
          JAC(lCO  ,lNO3 )= +(-1.000)*rk( 78)    *y(lFORM)
     &                      +(-0.643)*rk(151)    *y(lISPD)
          JAC(lCO  ,lOH  )= +         rk( 66)    *y(lCO)
     &                      +(-1.000)*rk( 74)    *y(lFORM)
     &                      +(-2.000)*rk(139)    *y(lOPEN)
     &                      +(-0.334)*rk(149)    *y(lISPD)
          JAC(lCO  ,lFORM)= +(-1.000)*rk( 74)    *y(lOH)
     &                      +(-1.000)*rk( 75)*flg
     &                      +(-1.000)*rk( 76)*flg
     &                      +(-1.000)*rk( 77)    *y(lO)
     &                      +(-1.000)*rk( 78)    *y(lNO3)
          JAC(lCO  ,lALD2)= +(-1.000)*rk( 87)*flg
          JAC(lCO  ,lALDX)= +(-1.000)*rk(102)*flg
          JAC(lCO  ,lCO  )= +         rk( 66)    *y(lOH)
          JAC(lCO  ,lOLE )= +(-0.200)*rk(119)    *y(lO)
     &                      +(-0.330)*rk(121)    *y(lO3)
          JAC(lCO  ,lETH )= +(-1.000)*rk(123)    *y(lO)
     &                      +(-0.630)*rk(125)    *y(lO3)
          JAC(lCO  ,lIOLE)= +(-0.100)*rk(127)    *y(lO)
     &                      +(-0.250)*rk(129)    *y(lO3)
          JAC(lCO  ,lOPEN)= +(-1.000)*rk(138)*flg
     &                      +(-2.000)*rk(139)    *y(lOH)
     &                      +(-0.690)*rk(140)    *y(lO3)
          JAC(lCO  ,lMGLY)= +(-1.000)*rk(143)*flg
          JAC(lCO  ,lISOP)= +(-0.066)*rk(146)    *y(lO3)
          JAC(lCO  ,lISPD)= +(-0.334)*rk(149)    *y(lOH)
     &                      +(-0.225)*rk(150)    *y(lO3)
     &                      +(-0.643)*rk(151)    *y(lNO3)
     &                      +(-0.333)*rk(152)*flg
          JAC(lCO  ,lTERP)= +(-0.001)*rk(155)    *y(lO3)
          JAC(lMEO2,lNO  )= +         rk( 68)    *y(lMEO2)
     &                      +(-1.000)*rk( 88)    *y(lC2O3)
          JAC(lMEO2,lOH  )= +(-1.000)*rk( 67)*flg*CH4
     &                      +(-0.700)*rk( 71)    *y(lMEPX)
     &                      +(-1.000)*rk( 98)    *y(lAACD)
          JAC(lMEO2,lHO2 )= +         rk( 69)    *y(lMEO2)
          JAC(lMEO2,lXO2 )= +(-0.900)*rk( 94)    *y(lC2O3)
          JAC(lMEO2,lALD2)= +(-1.000)*rk( 87)*flg
          JAC(lMEO2,lALDX)= +(-1.000)*rk(102)*flg
          JAC(lMEO2,lMEO2)= +         rk( 68)    *y(lNO)
     &                      +         rk( 69)    *y(lHO2)
     &                      +( 4.000)*rk( 70)    *y(lMEO2)
     &                      +         rk( 93)    *y(lC2O3)
     &                      +(-0.900)*rk( 93)    *y(lC2O3)
     &                      +         rk(109)    *y(lCXO3)
          JAC(lMEO2,lMEPX)= +(-0.700)*rk( 71)    *y(lOH)
          JAC(lMEO2,lC2O3)= +(-1.000)*rk( 88)    *y(lNO)
     &                      +         rk( 93)    *y(lMEO2)
     &                      +(-0.900)*rk( 93)    *y(lMEO2)
     &                      +(-0.900)*rk( 94)    *y(lXO2)
     &                      +(-4.000)*rk( 95)    *y(lC2O3)
     &                      +(-1.000)*rk(112)    *y(lCXO3)
          JAC(lMEO2,lPACD)= +(-1.000)*rk( 97)*flg
          JAC(lMEO2,lAACD)= +(-1.000)*rk( 98)    *y(lOH)
          JAC(lMEO2,lCXO3)= +         rk(109)    *y(lMEO2)
     &                      +(-1.000)*rk(112)    *y(lC2O3)
          JAC(lMEPX,lOH  )= +         rk( 71)    *y(lMEPX)
          JAC(lMEPX,lHO2 )= +(-1.000)*rk( 69)    *y(lMEO2)
     &                      +(-1.000)*rk( 82)    *y(lHCO3)
          JAC(lMEPX,lMEO2)= +(-1.000)*rk( 69)    *y(lHO2)
          JAC(lMEPX,lMEPX)= +         rk( 71)    *y(lOH)
     &                      +         rk( 72)*flg
          JAC(lMEPX,lHCO3)= +(-1.000)*rk( 82)    *y(lHO2)
          JAC(lMEOH,lOH  )= +         rk( 73)    *y(lMEOH)
          JAC(lMEOH,lMEO2)= +(-1.260)*rk( 70)    *y(lMEO2)
          JAC(lMEOH,lMEOH)= +         rk( 73)    *y(lOH)
          JAC(lHCO3,lNO  )= +         rk( 81)    *y(lHCO3)
          JAC(lHCO3,lHO2 )= +(-1.000)*rk( 79)    *y(lFORM)
     &                      +         rk( 82)    *y(lHCO3)
          JAC(lHCO3,lFORM)= +(-1.000)*rk( 79)    *y(lHO2)
          JAC(lHCO3,lHCO3)= +         rk( 80)*flg
     &                      +         rk( 81)    *y(lNO)
     &                      +         rk( 82)    *y(lHO2)
          JAC(lFACD,lNO  )= +(-1.000)*rk( 81)    *y(lHCO3)
          JAC(lFACD,lO3  )= +(-0.370)*rk(125)    *y(lETH)
          JAC(lFACD,lOH  )= +         rk( 83)    *y(lFACD)
          JAC(lFACD,lHCO3)= +(-1.000)*rk( 81)    *y(lNO)
          JAC(lFACD,lFACD)= +         rk( 83)    *y(lOH)
          JAC(lFACD,lETH )= +(-0.370)*rk(125)    *y(lO3)
          JAC(lC2O3,lNO2 )= +         rk( 89)    *y(lC2O3)
          JAC(lC2O3,lNO  )= +         rk( 88)    *y(lC2O3)
          JAC(lC2O3,lO   )= +(-1.000)*rk( 84)    *y(lALD2)
          JAC(lC2O3,lO3  )= +(-0.620)*rk(140)    *y(lOPEN)
     &                      +(-0.114)*rk(150)    *y(lISPD)
          JAC(lC2O3,lNO3 )= +(-1.000)*rk( 86)    *y(lALD2)
          JAC(lC2O3,lOH  )= +(-1.000)*rk( 85)    *y(lALD2)
     &                      +(-1.000)*rk( 96)    *y(lPACD)
     &                      +(-1.000)*rk(139)    *y(lOPEN)
     &                      +(-1.000)*rk(142)    *y(lMGLY)
     &                      +(-0.210)*rk(149)    *y(lISPD)
          JAC(lC2O3,lHO2 )= +         rk( 92)    *y(lC2O3)
          JAC(lC2O3,lXO2 )= +         rk( 94)    *y(lC2O3)
          JAC(lC2O3,lALD2)= +(-1.000)*rk( 84)    *y(lO)
     &                      +(-1.000)*rk( 85)    *y(lOH)
     &                      +(-1.000)*rk( 86)    *y(lNO3)
          JAC(lC2O3,lMEO2)= +         rk( 93)    *y(lC2O3)
          JAC(lC2O3,lC2O3)= +         rk( 88)    *y(lNO)
     &                      +         rk( 89)    *y(lNO2)
     &                      +         rk( 92)    *y(lHO2)
     &                      +         rk( 93)    *y(lMEO2)
     &                      +         rk( 94)    *y(lXO2)
     &                      +( 4.000)*rk( 95)    *y(lC2O3)
     &                      +         rk(112)    *y(lCXO3)
          JAC(lC2O3,lPAN )= +(-1.000)*rk( 90)*flg
     &                      +(-1.000)*rk( 91)*flg
          JAC(lC2O3,lPACD)= +(-1.000)*rk( 96)    *y(lOH)
          JAC(lC2O3,lCXO3)= +         rk(112)    *y(lC2O3)
          JAC(lC2O3,lOPEN)= +(-1.000)*rk(138)*flg
     &                      +(-1.000)*rk(139)    *y(lOH)
     &                      +(-0.620)*rk(140)    *y(lO3)
          JAC(lC2O3,lMGLY)= +(-1.000)*rk(142)    *y(lOH)
     &                      +(-1.000)*rk(143)*flg
          JAC(lC2O3,lISPD)= +(-0.210)*rk(149)    *y(lOH)
     &                      +(-0.114)*rk(150)    *y(lO3)
     &                      +(-0.967)*rk(152)*flg
          JAC(lPAN ,lNO2 )= +(-1.000)*rk( 89)    *y(lC2O3)
          JAC(lPAN ,lC2O3)= +(-1.000)*rk( 89)    *y(lNO2)
          JAC(lPAN ,lPAN )= +         rk( 90)*flg
     &                      +         rk( 91)*flg
          JAC(lPACD,lOH  )= +         rk( 96)    *y(lPACD)
          JAC(lPACD,lHO2 )= +(-0.800)*rk( 92)    *y(lC2O3)
     &                      +(-0.800)*rk(108)    *y(lCXO3)
          JAC(lPACD,lC2O3)= +(-0.800)*rk( 92)    *y(lHO2)
          JAC(lPACD,lPACD)= +         rk( 96)    *y(lOH)
     &                      +         rk( 97)*flg
          JAC(lPACD,lCXO3)= +(-0.800)*rk(108)    *y(lHO2)
          JAC(lAACD,lOH  )= +         rk( 98)    *y(lAACD)
          JAC(lAACD,lHO2 )= +(-0.200)*rk( 92)    *y(lC2O3)
     &                      +(-0.200)*rk(108)    *y(lCXO3)
          JAC(lAACD,lXO2 )= +(-0.100)*rk( 94)    *y(lC2O3)
     &                      +(-0.100)*rk(110)    *y(lCXO3)
          JAC(lAACD,lMEO2)= +(-0.100)*rk( 93)    *y(lC2O3)
     &                      +(-0.100)*rk(109)    *y(lCXO3)
          JAC(lAACD,lC2O3)= +(-0.200)*rk( 92)    *y(lHO2)
     &                      +(-0.100)*rk( 93)    *y(lMEO2)
     &                      +(-0.100)*rk( 94)    *y(lXO2)
          JAC(lAACD,lAACD)= +         rk( 98)    *y(lOH)
          JAC(lAACD,lCXO3)= +(-0.200)*rk(108)    *y(lHO2)
     &                      +(-0.100)*rk(109)    *y(lMEO2)
     &                      +(-0.100)*rk(110)    *y(lXO2)
          JAC(lCXO3,lNO2 )= +         rk(104)    *y(lCXO3)
          JAC(lCXO3,lNO  )= +         rk(103)    *y(lCXO3)
          JAC(lCXO3,lO   )= +(-1.000)*rk( 99)    *y(lALDX)
     &                      +(-0.250)*rk(144)    *y(lISOP)
          JAC(lCXO3,lO3  )= +(-0.200)*rk(146)    *y(lISOP)
     &                      +(-0.390)*rk(155)    *y(lTERP)
          JAC(lCXO3,lNO3 )= +(-1.000)*rk(101)    *y(lALDX)
     &                      +(-0.075)*rk(151)    *y(lISPD)
          JAC(lCXO3,lOH  )= +(-1.000)*rk(100)    *y(lALDX)
     &                      +(-0.250)*rk(149)    *y(lISPD)
          JAC(lCXO3,lHO2 )= +         rk(108)    *y(lCXO3)
          JAC(lCXO3,lXO2 )= +         rk(110)    *y(lCXO3)
          JAC(lCXO3,lALDX)= +(-1.000)*rk( 99)    *y(lO)
     &                      +(-1.000)*rk(100)    *y(lOH)
     &                      +(-1.000)*rk(101)    *y(lNO3)
          JAC(lCXO3,lMEO2)= +         rk(109)    *y(lCXO3)
          JAC(lCXO3,lC2O3)= +         rk(112)    *y(lCXO3)
          JAC(lCXO3,lCXO3)= +         rk(103)    *y(lNO)
     &                      +         rk(104)    *y(lNO2)
     &                      +         rk(108)    *y(lHO2)
     &                      +         rk(109)    *y(lMEO2)
     &                      +         rk(110)    *y(lXO2)
     &                      +( 4.000)*rk(111)    *y(lCXO3)
     &                      +         rk(112)    *y(lC2O3)
          JAC(lCXO3,lPANX)= +(-1.000)*rk(105)*flg
     &                      +(-1.000)*rk(106)*flg
          JAC(lCXO3,lISOP)= +(-0.250)*rk(144)    *y(lO)
     &                      +(-0.200)*rk(146)    *y(lO3)
          JAC(lCXO3,lISPD)= +(-0.250)*rk(149)    *y(lOH)
     &                      +(-0.075)*rk(151)    *y(lNO3)
          JAC(lCXO3,lTERP)= +(-0.390)*rk(155)    *y(lO3)
          JAC(lPANX,lNO2 )= +(-1.000)*rk(104)    *y(lCXO3)
          JAC(lPANX,lOH  )= +         rk(107)    *y(lPANX)
          JAC(lPANX,lCXO3)= +(-1.000)*rk(104)    *y(lNO2)
          JAC(lPANX,lPANX)= +         rk(105)*flg
     &                      +         rk(106)*flg
     &                      +         rk(107)    *y(lOH)
          JAC(lETHA,lOH  )= +         rk(113)    *y(lETHA)
          JAC(lETHA,lETHA)= +         rk(113)    *y(lOH)
          JAC(lETOH,lOH  )= +         rk(114)    *y(lETOH)
          JAC(lETOH,lETOH)= +         rk(114)    *y(lOH)
          JAC(lROR ,lNO2 )= +         rk(118)    *y(lROR)
          JAC(lROR ,lOH  )= +(-0.760)*rk(115)    *y(lPAR)
          JAC(lROR ,lPAR )= +(-0.760)*rk(115)    *y(lOH)
          JAC(lROR ,lROR )= +         rk(116)*flg
     &                      +(-0.020)*rk(116)*flg
     &                      +         rk(117)*flg
     &                      +         rk(118)    *y(lNO2)
          JAC(lOLE ,lO   )= +         rk(119)    *y(lOLE)
          JAC(lOLE ,lO3  )= +         rk(121)    *y(lOLE)
          JAC(lOLE ,lNO3 )= +         rk(122)    *y(lOLE)
          JAC(lOLE ,lOH  )= +         rk(120)    *y(lOLE)
          JAC(lOLE ,lOLE )= +         rk(119)    *y(lO)
     &                      +         rk(120)    *y(lOH)
     &                      +         rk(121)    *y(lO3)
     &                      +         rk(122)    *y(lNO3)
          JAC(lETH ,lO   )= +         rk(123)    *y(lETH)
          JAC(lETH ,lO3  )= +         rk(125)    *y(lETH)
          JAC(lETH ,lNO3 )= +         rk(126)    *y(lETH)
          JAC(lETH ,lOH  )= +         rk(124)    *y(lETH)
          JAC(lETH ,lETH )= +         rk(123)    *y(lO)
     &                      +         rk(124)    *y(lOH)
     &                      +         rk(125)    *y(lO3)
     &                      +         rk(126)    *y(lNO3)
          JAC(lIOLE,lO   )= +         rk(127)    *y(lIOLE)
          JAC(lIOLE,lO3  )= +         rk(129)    *y(lIOLE)
          JAC(lIOLE,lNO3 )= +         rk(130)    *y(lIOLE)
          JAC(lIOLE,lOH  )= +         rk(128)    *y(lIOLE)
          JAC(lIOLE,lIOLE)= +         rk(127)    *y(lO)
     &                      +         rk(128)    *y(lOH)
     &                      +         rk(129)    *y(lO3)
     &                      +         rk(130)    *y(lNO3)
          JAC(lTOL ,lOH  )= +         rk(131)    *y(lTOL)
          JAC(lTOL ,lTOL )= +         rk(131)    *y(lOH)
          JAC(lCRES,lNO3 )= +         rk(135)    *y(lCRES)
          JAC(lCRES,lOH  )= +(-0.360)*rk(131)    *y(lTOL)
     &                      +         rk(134)    *y(lCRES)
     &                      +(-0.200)*rk(141)    *y(lXYL)
          JAC(lCRES,lHO2 )= +(-1.000)*rk(137)    *y(lCRO)
          JAC(lCRES,lTOL )= +(-0.360)*rk(131)    *y(lOH)
          JAC(lCRES,lCRES)= +         rk(134)    *y(lOH)
     &                      +         rk(135)    *y(lNO3)
          JAC(lCRES,lTO2 )= +(-1.000)*rk(133)*flg
          JAC(lCRES,lCRO )= +(-1.000)*rk(137)    *y(lHO2)
          JAC(lCRES,lXYL )= +(-0.200)*rk(141)    *y(lOH)
          JAC(lTO2 ,lNO  )= +         rk(132)    *y(lTO2)
          JAC(lTO2 ,lOH  )= +(-0.560)*rk(131)    *y(lTOL)
     &                      +(-0.300)*rk(141)    *y(lXYL)
          JAC(lTO2 ,lTOL )= +(-0.560)*rk(131)    *y(lOH)
          JAC(lTO2 ,lTO2 )= +         rk(132)    *y(lNO)
     &                      +         rk(133)*flg
          JAC(lTO2 ,lXYL )= +(-0.300)*rk(141)    *y(lOH)
          JAC(lOPEN,lNO  )= +(-0.900)*rk(132)    *y(lTO2)
          JAC(lOPEN,lO3  )= +         rk(140)    *y(lOPEN)
          JAC(lOPEN,lOH  )= +(-0.300)*rk(134)    *y(lCRES)
     &                      +         rk(139)    *y(lOPEN)
          JAC(lOPEN,lCRES)= +(-0.300)*rk(134)    *y(lOH)
          JAC(lOPEN,lTO2 )= +(-0.900)*rk(132)    *y(lNO)
          JAC(lOPEN,lOPEN)= +         rk(138)*flg
     &                      +         rk(139)    *y(lOH)
     &                      +         rk(140)    *y(lO3)
          JAC(lCRO ,lNO2 )= +         rk(136)    *y(lCRO)
          JAC(lCRO ,lNO3 )= +(-1.000)*rk(135)    *y(lCRES)
          JAC(lCRO ,lOH  )= +(-0.400)*rk(134)    *y(lCRES)
          JAC(lCRO ,lHO2 )= +         rk(137)    *y(lCRO)
          JAC(lCRO ,lCRES)= +(-0.400)*rk(134)    *y(lOH)
     &                      +(-1.000)*rk(135)    *y(lNO3)
          JAC(lCRO ,lCRO )= +         rk(136)    *y(lNO2)
     &                      +         rk(137)    *y(lHO2)
          JAC(lMGLY,lO3  )= +(-0.200)*rk(140)    *y(lOPEN)
     &                      +(-0.850)*rk(150)    *y(lISPD)
          JAC(lMGLY,lOH  )= +(-0.800)*rk(141)    *y(lXYL)
     &                      +         rk(142)    *y(lMGLY)
     &                      +(-0.168)*rk(149)    *y(lISPD)
          JAC(lMGLY,lOPEN)= +(-0.200)*rk(140)    *y(lO3)
          JAC(lMGLY,lMGLY)= +         rk(142)    *y(lOH)
     &                      +         rk(143)*flg
          JAC(lMGLY,lXYL )= +(-0.800)*rk(141)    *y(lOH)
          JAC(lMGLY,lISPD)= +(-0.168)*rk(149)    *y(lOH)
     &                      +(-0.850)*rk(150)    *y(lO3)
          JAC(lXYL ,lOH  )= +         rk(141)    *y(lXYL)
          JAC(lXYL ,lXYL )= +         rk(141)    *y(lOH)
          JAC(lISOP,lNO2 )= +         rk(148)    *y(lISOP)
          JAC(lISOP,lO   )= +         rk(144)    *y(lISOP)
          JAC(lISOP,lO3  )= +         rk(146)    *y(lISOP)
          JAC(lISOP,lNO3 )= +         rk(147)    *y(lISOP)
          JAC(lISOP,lOH  )= +         rk(145)    *y(lISOP)
          JAC(lISOP,lISOP)= +         rk(144)    *y(lO)
     &                      +         rk(145)    *y(lOH)
     &                      +         rk(146)    *y(lO3)
     &                      +         rk(147)    *y(lNO3)
     &                      +         rk(148)    *y(lNO2)
          JAC(lISPD,lNO2 )= +(-0.200)*rk(148)    *y(lISOP)
          JAC(lISPD,lO   )= +(-0.750)*rk(144)    *y(lISOP)
          JAC(lISPD,lO3  )= +(-0.650)*rk(146)    *y(lISOP)
     &                      +         rk(150)    *y(lISPD)
          JAC(lISPD,lNO3 )= +(-0.200)*rk(147)    *y(lISOP)
     &                      +         rk(151)    *y(lISPD)
          JAC(lISPD,lOH  )= +(-0.912)*rk(145)    *y(lISOP)
     &                      +         rk(149)    *y(lISPD)
          JAC(lISPD,lISOP)= +(-0.750)*rk(144)    *y(lO)
     &                      +(-0.912)*rk(145)    *y(lOH)
     &                      +(-0.650)*rk(146)    *y(lO3)
     &                      +(-0.200)*rk(147)    *y(lNO3)
     &                      +(-0.200)*rk(148)    *y(lNO2)
          JAC(lISPD,lISPD)= +         rk(149)    *y(lOH)
     &                      +         rk(150)    *y(lO3)
     &                      +         rk(151)    *y(lNO3)
     &                      +         rk(152)*flg
          JAC(lTERP,lO   )= +         rk(153)    *y(lTERP)
          JAC(lTERP,lO3  )= +         rk(155)    *y(lTERP)
          JAC(lTERP,lNO3 )= +         rk(156)    *y(lTERP)
          JAC(lTERP,lOH  )= +         rk(154)    *y(lTERP)
          JAC(lTERP,lTERP)= +         rk(153)    *y(lO)
     &                      +         rk(154)    *y(lOH)
     &                      +         rk(155)    *y(lO3)
     &                      +         rk(156)    *y(lNO3)
c
      do j=1,njac
        do i=1,njac
          jac(i,j) = -jac(i,j)
        enddo
      enddo
c
      return
c
      end
