       subroutine constants(temp)
c       
       include 'aerpar.inc'
       include 'droppar.inc'
       include 'dropcom.inc'
c       dimension akeq(17),akhen(21),akre(120)
       real*4 dheq(17),dhhen(21),dhre(120)
       real*4 bkeq(17),bkhen(21),bkre(120)
       real*4 temp

       data dheq/1960.,1500.,0.,2720.,-3730.,8700.,-1260.,
     & -1000.,-1760.,
     & -450.,-6710.,4020.,-20.,6900.,0.e0,0.,0./
       data bkeq/1.23e-2,6.61e-8,1.e3,1.02e-2,2.2e-12,15.4,5.1e-4,
     & 4.46e-7,4.68e-11,1.75e-5,1.0e-14,1.82e3,1.78e-4,1.74e6,3.5e-5,
     & 5.26e-6,2.0e-12/
       data dhhen/3120.,0.0,4780.,8700.,2420.,6620.,
     & 6460.e0,5740.e0,1480.e0,
     & 2500.e0,2300.e0,5910.e0,6170.e0,5610.e0,2020.e0,5280.e0,
     & 6640.e0,8700.e0,3400.e0,
     & 5600.e0,4900.e0/
       data bkhen/1.23e0,0.0e0,49.e0,2.1e5,3.4e-2,7.45e4,6.3e3,
     & 3.5e3,1.9e-3,
     & 0.01e0,1.13e-2,2.9e0,473.e0,227.e0,727.e0,25.e0,2000.e0,2.1e5,
     & 75.e0,6.e0,220.e0/


       data dhre/0.0e0,0.0e0,-1500.e0,-1500.e0,-1700.e0,-2365.e0,
     & -1500.e0,0.0e0,0.0e0,
     & 0.0e0,0.0e0,0.0e0,-1500.e0,0.0e0,-2520.e0,0.0e0,-1910.e0,
     & 0.0e0,-1500.e0,-2820.e0,
     & -1500.e0,0.0e0,0.0e0,0.0e0,-1500.e0,-1500.e0,-1500.e0,
     & -3370.e0,0.0e0,-2160.e0,
     & -1500.e0,-1500.e0,-1500.e0,-1500.e0,0.0e0,0.0e0,-1500.e0,
     & -1500.e0,-6693.e0,-6950.e0,
     & 0.0e0,-1500.e0,-1500.e0,0.0e0,0.0e0,-1500.e0,-1500.e0,
     & -2800.e0,-1500.e0,-1500.e0,
     & 0.0e0,-1500.e0,-5180.e0,-3200.e0,0.0e0,-4300.e0,-1500.e0,
     & 0.0e0,-1500.e0,-3400.e0,
     & -2600.e0,0.0e0,-3000.e0,-1600.e0,0.0e0,-1700.e0,-1500.e0,
     & -4500.e0,-4400.e0,-1800.e0,
     & -2800.e0,0.0e0,-5530.e0,-5280.e0,-4430.e0,-13700.e0,
     & -11000.e0,-13700e0,-11000.e0,
     & -1500.e0,-1500.e0,-3100.e0,-1500.e0,-5300.e0,-4000.e0,
     & -1500.e0,-4755.e0,-1900.e0,
     &  0.0e0,-6650.e0,-7050.e0,-1500.e0,-1500.e0,-1500.e0,
     & -1500.e0,-1500.e0,-2000.e0,
     & -1500.e0,-2100.e0,-1500.e0,-1500.e0,-2700.e0,0.0e0,
     & -3800.e0,-4000.e0,0.0e0,0.0e0,
     & -1800.e0,0.0e0,0.0e0,0.0e0,-6100.e0,-4900.e0,
     & -4500.e0,-1500.e0,-1500.e0,
     & -2000.e0,0.e0,-1800.e0,120.e0/


       data bkre/2.5e-6,2.0e-5,7.0e9,1.0e10,2.7e7,
     & 8.6e5,1.0e8,0.3e0,0.5e0,
     & 0.13e0,2.0e9,1.0e4,1.5e9,70.e0,2.8e6,7.8e-3,1.5e7,
     & 1.5e6,4.0e8,8.0e5,
     & 4.3e9,6.1e9,2.1e10,1.3e3,4.5e9,1.0e9,3.1e9,
     & 1.4e5,4.5e7,7.3e6,
     & 2.0e8,1.0e8,2.0e10,1.3e9,3.7e-5,6.3e-6,1.0e9,
     & 1.0e10,6.3e3,5.0e5,
     & 4.0e5,2.5e8,1.2e9,1.0e-7,1.0e-5,4.5e9,1.0e9,
     & 1.0e6,1.0e8,2.0e9,
     & 0.1e0,1.6e8,4.6e-6,2.1e5,5.0e0,6.7e3,2.5e9,100.0e0,
     & 6.0e7,1.1e5,1.9e6,
     & 4.0e-4,7.6e5,5.0e7,5.4e-7,2.7e7,4.5e8,2.6e3,
     & 3.5e3,1.9e7,1.0e6,
     & 2.4e4,3.7e5,1.5e9,1.3e6,4.7e0,0.82e0,5.0e3,1.0e7,
     & 4.6e9,4.2e9,3.0e5,
     & 1.0e8,200.e0,1.4e4,2.e8,7.5e7,1.7e7,1.e5,0.31e0,
     & 1.8e-3,1.3e9,5.3e8,
     & 5.0e9,5.0e9,8.0e7,1.2e7,8.8e8,9.1e6,1.7e8,
     & 2.0e8,1.4e6,6.7e-3,
     & 1.9e7,5.0e7,6.0e2,1.0e6,2.5e7,1.0e8,2.0e6,
     & 1.42e2,4.77e3,2.94e2,
     & 3.6e3,1.4e9,3.4e8,
     & 2.5e4,1.0e5,2.5e7,120.e0/


       do 1020 i=1,17
       akeq(i)=bkeq(i)*exp(dheq(i)*(1.0/temp-1.0/298.0))
 1020  continue
       do 1025 i=1,21
       akhen(i)=bkhen(i)*exp(dhhen(i)*(1.0/temp-1.0/298.0))
 1025  continue
       do 1030 i=1,120
       akre(i)=bkre(i)*exp(dhre(i)*(1.0/temp-1.0/298.0))
 1030  continue

       return
       end
