c----CAMx v7Beta6 190902
c
c     CAMx.COM contains general model variables
c 
c     Copyright 1996 - 2018
c     Ramboll
c
c     Modifications:
c        11/05/01  Added Y2K flag
c        4/10/03   Moved dtmax from control file to parameter in timestep.f
c
c-----------------------------------------------------------------------
c     Variables for simulation date/time and update intervals:
c
c     date    --  Julian date (YYJJJ) of the current time step
c     time    --  time (HHMM) of the current step
c     datec   --  Julian date (YYJJJ) of the current time step for each grid
c     timec   --  time (HHMM) of the current step for each grid
c     begdate --  Julian date (YYJJJ) of the beginning of the simulation
c     begtim  --  time (HHMM) of the beginning of the simulation
c     dtinp   --  time interval for updating meteorological inputs (min)
c     dtems   --  time interval for updating emission inputs (min)
c     dtout   --  time interval to output concentrations (min)
c     dtmax   --  maximum allowable time step (min)
c     deltat  --  time step size for each grid (seconds)
c     xyordr  --  binary (0 or 1) variable to define horizontal advection
c                 order (0=X-Y, 1=Y-X) 
c     MAXDT   --  parameter for maximum allowable time step (in minutes)
c-----------------------------------------------------------------------
c
      integer, allocatable, dimension(:) :: datec
      real,    allocatable, dimension(:) :: timec
      real,    allocatable, dimension(:) :: deltat
c
      integer   date
      real      time
      integer   begdate
      real      begtim
      real      dtinp
      real      dtems
      real      dtout
      real      dtmax
      integer   xyordr
c      
      common /timstf/ date, time, begdate, begtim,
     &                dtinp, dtems, dtout, dtmax, xyordr
c
      real      MAXDT
c
      parameter( MAXDT = 15. )
c
c-----------------------------------------------------------------------
c     Variables for simulation identification:
c
c     runmsg  -- string conatining the simulation run ID
c-----------------------------------------------------------------------
c
      character*80 runmsg
c
      common /runid/ runmsg
c
c-----------------------------------------------------------------------
c     Variables for conversion constants:
c
c     densfac -- conversion factor to convert from PPM to umol/m3 (mol/m3)
c-----------------------------------------------------------------------
c
      real   densfac
c
      common /convrt/ densfac
c
